/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class AddOffsetsToTxnRequestData
implements ApiMessage {
    private String transactionalId;
    private long producerId;
    private short producerEpoch;
    private String groupId;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema[] SCHEMAS;

    public AddOffsetsToTxnRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public AddOffsetsToTxnRequestData(Struct _struct, short _version) {
        this.fromStruct(_struct, _version);
    }

    public AddOffsetsToTxnRequestData() {
        this.transactionalId = "";
        this.producerId = 0L;
        this.producerEpoch = 0;
        this.groupId = "";
    }

    @Override
    public short apiKey() {
        return 25;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 1;
    }

    @Override
    public void read(Readable _readable, short _version) {
        short length = _readable.readShort();
        if (length < 0) {
            throw new RuntimeException("non-nullable field transactionalId was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field transactionalId had invalid length " + length);
        }
        this.transactionalId = _readable.readString(length);
        this.producerId = _readable.readLong();
        this.producerEpoch = _readable.readShort();
        length = _readable.readShort();
        if (length < 0) {
            throw new RuntimeException("non-nullable field groupId was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field groupId had invalid length " + length);
        }
        this.groupId = _readable.readString(length);
        this._unknownTaggedFields = null;
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        byte[] _stringBytes = _cache.getSerializedValue(this.transactionalId);
        _writable.writeShort((short)_stringBytes.length);
        _writable.writeByteArray(_stringBytes);
        _writable.writeLong(this.producerId);
        _writable.writeShort(this.producerEpoch);
        _stringBytes = _cache.getSerializedValue(this.groupId);
        _writable.writeShort((short)_stringBytes.length);
        _writable.writeByteArray(_stringBytes);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        this._unknownTaggedFields = null;
        this.transactionalId = struct.getString("transactional_id");
        this.producerId = struct.getLong("producer_id");
        this.producerEpoch = struct.getShort("producer_epoch");
        this.groupId = struct.getString("group_id");
    }

    @Override
    public Struct toStruct(short _version) {
        Object _taggedFields = null;
        Struct struct = new Struct(SCHEMAS[_version]);
        struct.set("transactional_id", (Object)this.transactionalId);
        struct.set("producer_id", (Object)this.producerId);
        struct.set("producer_epoch", (Object)this.producerEpoch);
        struct.set("group_id", (Object)this.groupId);
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        byte[] _stringBytes = this.transactionalId.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'transactionalId' field is too long to be serialized");
        }
        _cache.cacheSerializedValue(this.transactionalId, _stringBytes);
        _size += _stringBytes.length + 2;
        _size += 8;
        _size += 2;
        _stringBytes = this.groupId.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'groupId' field is too long to be serialized");
        }
        _cache.cacheSerializedValue(this.groupId, _stringBytes);
        _size += _stringBytes.length + 2;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AddOffsetsToTxnRequestData)) {
            return false;
        }
        AddOffsetsToTxnRequestData other = (AddOffsetsToTxnRequestData)obj;
        if (this.transactionalId == null ? other.transactionalId != null : !this.transactionalId.equals(other.transactionalId)) {
            return false;
        }
        if (this.producerId != other.producerId) {
            return false;
        }
        if (this.producerEpoch != other.producerEpoch) {
            return false;
        }
        return !(this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.transactionalId == null ? 0 : this.transactionalId.hashCode());
        hashCode = 31 * hashCode + ((int)(this.producerId >> 32) ^ (int)this.producerId);
        hashCode = 31 * hashCode + this.producerEpoch;
        hashCode = 31 * hashCode + (this.groupId == null ? 0 : this.groupId.hashCode());
        return hashCode;
    }

    @Override
    public AddOffsetsToTxnRequestData duplicate() {
        AddOffsetsToTxnRequestData _duplicate = new AddOffsetsToTxnRequestData();
        _duplicate.transactionalId = this.transactionalId;
        _duplicate.producerId = this.producerId;
        _duplicate.producerEpoch = this.producerEpoch;
        _duplicate.groupId = this.groupId;
        return _duplicate;
    }

    public String toString() {
        return "AddOffsetsToTxnRequestData(transactionalId=" + (this.transactionalId == null ? "null" : "'" + this.transactionalId.toString() + "'") + ", producerId=" + this.producerId + ", producerEpoch=" + this.producerEpoch + ", groupId=" + (this.groupId == null ? "null" : "'" + this.groupId.toString() + "'") + ")";
    }

    public String transactionalId() {
        return this.transactionalId;
    }

    public long producerId() {
        return this.producerId;
    }

    public short producerEpoch() {
        return this.producerEpoch;
    }

    public String groupId() {
        return this.groupId;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public AddOffsetsToTxnRequestData setTransactionalId(String v) {
        this.transactionalId = v;
        return this;
    }

    public AddOffsetsToTxnRequestData setProducerId(long v) {
        this.producerId = v;
        return this;
    }

    public AddOffsetsToTxnRequestData setProducerEpoch(short v) {
        this.producerEpoch = v;
        return this;
    }

    public AddOffsetsToTxnRequestData setGroupId(String v) {
        this.groupId = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("transactional_id", Type.STRING, "The transactional id corresponding to the transaction."), new Field("producer_id", Type.INT64, "Current producer id in use by the transactional id."), new Field("producer_epoch", Type.INT16, "Current epoch associated with the producer id."), new Field("group_id", Type.STRING, "The unique group identifier."));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    }
}

