/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.support.csv;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderAdapter;
import com.alibaba.fastjson2.stream.StreamReader;
import com.alibaba.fastjson2.support.csv.CSVReaderUTF16;
import com.alibaba.fastjson2.support.csv.CSVReaderUTF8;
import com.alibaba.fastjson2.util.JDKUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public abstract class CSVReader
extends StreamReader
implements Closeable {
    boolean quote;

    CSVReader() {
    }

    CSVReader(ObjectReaderAdapter objectReader) {
        super(objectReader);
    }

    public CSVReader(Type[] types) {
        super(types);
    }

    public void config(StreamReader.Feature ... features) {
        for (StreamReader.Feature feature : features) {
            this.features |= feature.mask;
        }
    }

    public void config(StreamReader.Feature feature, boolean state) {
        this.features = state ? (this.features |= feature.mask) : (this.features &= feature.mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static CSVReader of(Reader reader, Class objectClass) {
        JSONReader.Context context = JSONFactory.createReadContext();
        ObjectReaderAdapter objectReader = (ObjectReaderAdapter)context.getObjectReader(objectClass);
        return new CSVReaderUTF16(reader, objectReader);
    }

    public static CSVReader of(String str, Class objectClass) {
        JSONReader.Context context = JSONFactory.createReadContext();
        ObjectReaderAdapter objectReader = (ObjectReaderAdapter)context.getObjectReader(objectClass);
        if (JDKUtils.JVM_VERSION > 8 && JDKUtils.STRING_VALUE != null) {
            try {
                int coder = JDKUtils.STRING_CODER.applyAsInt(str);
                if (coder == 0) {
                    byte[] bytes = JDKUtils.STRING_VALUE.apply(str);
                    return new CSVReaderUTF8(bytes, 0, bytes.length, objectReader);
                }
            }
            catch (Exception e) {
                throw new JSONException("unsafe get String.coder error");
            }
        }
        char[] chars = JDKUtils.getCharArray(str);
        return new CSVReaderUTF16(chars, 0, chars.length, objectReader);
    }

    public static CSVReader of(char[] chars, Class objectClass) {
        JSONReader.Context context = JSONFactory.createReadContext();
        ObjectReaderAdapter objectReader = (ObjectReaderAdapter)context.getObjectReader(objectClass);
        return new CSVReaderUTF16(chars, 0, chars.length, objectReader);
    }

    public static CSVReader of(byte[] utf8Bytes, Class objectClass) {
        JSONReader.Context context = JSONFactory.createReadContext();
        ObjectReaderAdapter objectReader = (ObjectReaderAdapter)context.getObjectReader(objectClass);
        return new CSVReaderUTF8(utf8Bytes, 0, utf8Bytes.length, objectReader);
    }

    public static CSVReader of(File file, Type ... types) throws IOException {
        return new CSVReaderUTF8((InputStream)new FileInputStream(file), StandardCharsets.UTF_8, types);
    }

    public static CSVReader of(File file, Charset charset, Type ... types) throws IOException {
        if (charset == StandardCharsets.UTF_16 || charset == StandardCharsets.UTF_16LE || charset == StandardCharsets.UTF_16BE) {
            return new CSVReaderUTF16((Reader)new InputStreamReader((InputStream)new FileInputStream(file), charset), types);
        }
        return new CSVReaderUTF8((InputStream)new FileInputStream(file), charset, types);
    }

    public static CSVReader of(File file, Class objectClass) throws IOException {
        return CSVReader.of(file, StandardCharsets.UTF_8, objectClass);
    }

    public static CSVReader of(File file, Charset charset, Class objectClass) throws IOException {
        JSONReader.Context context = JSONFactory.createReadContext();
        ObjectReaderAdapter objectReader = (ObjectReaderAdapter)context.getObjectReader(objectClass);
        if (charset == StandardCharsets.UTF_16 || charset == StandardCharsets.UTF_16LE || charset == StandardCharsets.UTF_16BE) {
            return new CSVReaderUTF16((Reader)new InputStreamReader((InputStream)new FileInputStream(file), charset), objectReader);
        }
        return new CSVReaderUTF8((InputStream)new FileInputStream(file), charset, objectReader);
    }

    public static CSVReader of(InputStream in, Type ... types) throws IOException {
        return new CSVReaderUTF8(in, StandardCharsets.UTF_8, types);
    }

    public static CSVReader of(InputStream in, Class objectClass) {
        return CSVReader.of(in, StandardCharsets.UTF_8, objectClass);
    }

    public static CSVReader of(InputStream in, Charset charset, Class objectClass) {
        JSONReader.Context context = JSONFactory.createReadContext();
        ObjectReaderAdapter objectReader = (ObjectReaderAdapter)context.getObjectReader(objectClass);
        return new CSVReaderUTF8(in, charset, objectReader);
    }

    public static CSVReader of(InputStream in, Charset charset, Type ... types) throws IOException {
        if (charset == StandardCharsets.UTF_16 || charset == StandardCharsets.UTF_16LE || charset == StandardCharsets.UTF_16BE) {
            return new CSVReaderUTF16((Reader)new InputStreamReader(in, charset), types);
        }
        return new CSVReaderUTF8(in, charset, types);
    }

    public static CSVReader of(Reader in, Type ... types) throws IOException {
        return new CSVReaderUTF16(in, types);
    }

    public static CSVReader of(String str, Type ... types) {
        if (JDKUtils.JVM_VERSION > 8 && JDKUtils.STRING_VALUE != null) {
            try {
                int coder = JDKUtils.STRING_CODER.applyAsInt(str);
                if (coder == 0) {
                    byte[] bytes = JDKUtils.STRING_VALUE.apply(str);
                    return new CSVReaderUTF8(bytes, 0, bytes.length, types);
                }
            }
            catch (Exception e) {
                throw new JSONException("unsafe get String.coder error");
            }
        }
        char[] chars = JDKUtils.getCharArray(str);
        return new CSVReaderUTF16(chars, 0, chars.length, types);
    }

    public static CSVReader of(char[] chars, Type ... types) {
        return new CSVReaderUTF16(chars, 0, chars.length, types);
    }

    public static CSVReader of(byte[] utf8Bytes, Type ... types) {
        return new CSVReaderUTF8(utf8Bytes, 0, utf8Bytes.length, types);
    }

    public void skipLines(int lines) throws IOException {
        if (lines < 0) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < lines; ++i) {
            this.seekLine();
        }
    }

    public List<String> readHeader() {
        String[] columns = (String[])this.readLineValues(true);
        if (this.objectReader != null) {
            JSONReader.Context context = JSONFactory.createReadContext(this.provider, new JSONReader.Feature[0]);
            Type[] types = new Type[columns.length];
            ObjectReader[] typeReaders = new ObjectReader[columns.length];
            for (int i = 0; i < columns.length; ++i) {
                String column = columns[i];
                FieldReader fieldReader = this.objectReader.getFieldReader(column);
                types[i] = fieldReader.fieldType;
                typeReaders[i] = fieldReader.getObjectReader(context);
            }
            this.types = types;
            this.typeReaders = typeReaders;
        }
        this.columns = Arrays.asList(columns);
        this.columnStats = new ArrayList();
        for (int i = 0; i < columns.length; ++i) {
            this.columnStats.add(new StreamReader.ColumnStat(columns[i]));
        }
        if (this.rowCount == 1) {
            this.rowCount = this.lineTerminated ? 0 : -1;
        }
        return this.columns;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public String getColumn(int columnIndex) {
        if (this.columns != null && columnIndex < this.columns.size()) {
            return (String)this.columns.get(columnIndex);
        }
        return null;
    }

    public Type getColumnType(int columnIndex) {
        if (this.types != null && columnIndex < this.types.length) {
            return this.types[columnIndex];
        }
        return null;
    }

    public List<StreamReader.ColumnStat> getColumnStats() {
        return this.columnStats;
    }

    @Override
    public <T> T readLineObject() {
        Object[] values;
        int i;
        if (this.inputEnd) {
            return null;
        }
        if (this.objectReader == null) {
            throw new JSONException("unsupported operation");
        }
        if (this.types == null) {
            FieldReader[] fieldReaders = this.objectReader.getFieldReaders();
            Type[] types = new Type[fieldReaders.length];
            for (i = 0; i < fieldReaders.length; ++i) {
                types[i] = fieldReaders[i].fieldType;
            }
            this.types = types;
        }
        if ((values = this.readLineValues(false)) == null) {
            return null;
        }
        if (this.columns != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (i = 0; i < values.length; ++i) {
                if (i >= this.columns.size()) continue;
                String column = (String)this.columns.get(i);
                map.put(column, values[i]);
            }
            return this.objectReader.createInstance(map, new JSONReader.Feature[0]);
        }
        return this.objectReader.createInstance(values == null ? Collections.emptyList() : Arrays.asList(values));
    }

    public abstract boolean isEnd();

    public final Object[] readLineValues() {
        return this.readLineValues(false);
    }

    protected abstract Object[] readLineValues(boolean var1);

    public final String[] readLine() {
        return (String[])this.readLineValues(true);
    }

    public static int rowCount(String str, StreamReader.Feature ... features) {
        CSVReaderUTF8 state = new CSVReaderUTF8(features);
        state.rowCount(str, str.length());
        return state.rowCount();
    }

    public static int rowCount(byte[] bytes, StreamReader.Feature ... features) {
        CSVReaderUTF8 state = new CSVReaderUTF8(features);
        state.rowCount(bytes, bytes.length);
        return state.rowCount();
    }

    public static int rowCount(char[] chars, StreamReader.Feature ... features) {
        CSVReaderUTF16 state = new CSVReaderUTF16(features);
        state.rowCount(chars, chars.length);
        return state.rowCount();
    }

    public static int rowCount(File file) throws IOException {
        if (!file.exists()) {
            return -1;
        }
        try (FileInputStream in = new FileInputStream(file);){
            int n = CSVReader.rowCount(in);
            return n;
        }
    }

    public static int rowCount(InputStream in) throws IOException {
        int cnt;
        byte[] bytes = new byte[524288];
        CSVReaderUTF8 state = new CSVReaderUTF8(new StreamReader.Feature[0]);
        while ((cnt = in.read(bytes)) != -1) {
            state.rowCount(bytes, cnt);
        }
        return state.rowCount();
    }

    public int errorCount() {
        return this.errorCount;
    }

    public int rowCount() {
        return this.lineTerminated ? this.rowCount : this.rowCount + 1;
    }

    void rowCount(String bytes, int length) {
        this.lineTerminated = false;
        for (int i = 0; i < length; ++i) {
            char next;
            int n;
            char ch = bytes.charAt(i);
            if (ch == '\"') {
                ++this.lineSize;
                if (!this.quote) {
                    this.quote = true;
                    continue;
                }
                n = i + 1;
                if (n >= length) break;
                next = bytes.charAt(n);
                if (next == '\"') {
                    ++i;
                    continue;
                }
                this.quote = false;
                continue;
            }
            if (this.quote) {
                ++this.lineSize;
                continue;
            }
            if (ch == '\n') {
                if (this.lineSize > 0 || (this.features & StreamReader.Feature.IgnoreEmptyLine.mask) == 0L) {
                    ++this.rowCount;
                    this.lineSize = 0;
                }
                this.lineTerminated = i + 1 == length;
                continue;
            }
            if (ch == '\r') {
                this.lineTerminated = true;
                if (this.lineSize > 0 || (this.features & StreamReader.Feature.IgnoreEmptyLine.mask) == 0L) {
                    ++this.rowCount;
                }
                this.lineSize = 0;
                n = i + 1;
                if (n >= length) break;
                next = bytes.charAt(n);
                if (next == '\n') {
                    ++i;
                }
                this.lineTerminated = i + 1 == length;
                continue;
            }
            ++this.lineSize;
        }
    }

    void rowCount(byte[] bytes, int length) {
        this.lineTerminated = false;
        for (int i = 0; i < length; ++i) {
            byte next;
            int n;
            byte ch;
            if (i + 4 < length) {
                byte b0 = bytes[i];
                byte b1 = bytes[i + 1];
                byte b2 = bytes[i + 2];
                byte b3 = bytes[i + 3];
                if (b0 > 34 && b1 > 34 && b2 > 34 && b3 > 34) {
                    this.lineSize += 4;
                    i += 3;
                    continue;
                }
            }
            if ((ch = bytes[i]) == 34) {
                ++this.lineSize;
                if (!this.quote) {
                    this.quote = true;
                    continue;
                }
                n = i + 1;
                if (n >= length) break;
                next = bytes[n];
                if (next == 34) {
                    ++i;
                    continue;
                }
                this.quote = false;
                continue;
            }
            if (this.quote) {
                ++this.lineSize;
                continue;
            }
            if (ch == 10) {
                if (this.lineSize > 0 || (this.features & StreamReader.Feature.IgnoreEmptyLine.mask) == 0L) {
                    ++this.rowCount;
                }
                this.lineSize = 0;
                this.lineTerminated = i + 1 == length;
                continue;
            }
            if (ch == 13) {
                if (this.lineSize > 0 || (this.features & StreamReader.Feature.IgnoreEmptyLine.mask) == 0L) {
                    ++this.rowCount;
                }
                this.lineTerminated = true;
                this.lineSize = 0;
                n = i + 1;
                if (n >= length) break;
                next = bytes[n];
                if (next == 10) {
                    ++i;
                }
                this.lineTerminated = i + 1 == length;
                continue;
            }
            ++this.lineSize;
        }
    }

    void rowCount(char[] bytes, int length) {
        this.lineTerminated = false;
        for (int i = 0; i < length; ++i) {
            char next;
            int n;
            char ch;
            if (i + 4 < length) {
                char b0 = bytes[i];
                char b1 = bytes[i + 1];
                char b2 = bytes[i + 2];
                char b3 = bytes[i + 3];
                if (b0 > '\"' && b1 > '\"' && b2 > '\"' && b3 > '\"') {
                    i += 3;
                    this.lineSize += 4;
                    continue;
                }
            }
            if ((ch = bytes[i]) == '\"') {
                ++this.lineSize;
                if (!this.quote) {
                    this.quote = true;
                    continue;
                }
                n = i + 1;
                if (n >= length) break;
                next = bytes[n];
                if (next == '\"') {
                    ++i;
                    continue;
                }
                this.quote = false;
                continue;
            }
            if (this.quote) {
                ++this.lineSize;
                continue;
            }
            if (ch == '\n') {
                if (this.lineSize > 0 || (this.features & StreamReader.Feature.IgnoreEmptyLine.mask) == 0L) {
                    ++this.rowCount;
                }
                this.lineSize = 0;
                this.lineTerminated = i + 1 == length;
                continue;
            }
            if (ch == '\r' || (this.features & StreamReader.Feature.IgnoreEmptyLine.mask) == 0L) {
                if (this.lineSize > 0) {
                    ++this.rowCount;
                }
                this.lineTerminated = true;
                this.lineSize = 0;
                n = i + 1;
                if (n >= length) break;
                next = bytes[n];
                if (next == '\n') {
                    ++i;
                }
                this.lineTerminated = i + 1 == length;
                continue;
            }
            ++this.lineSize;
        }
    }

    protected Object error(int columnIndex, Exception e) {
        ++this.errorCount;
        ++this.getColumnStat((int)columnIndex).errors;
        if ((this.features & StreamReader.Feature.ErrorAsNull.mask) != 0L) {
            return null;
        }
        String message = "read csv error, line " + this.rowCount + ", column ";
        String column = null;
        if (this.columns != null && columnIndex < this.columns.size()) {
            column = (String)this.columns.get(columnIndex);
        }
        message = column != null && !column.isEmpty() ? message + column : message + columnIndex;
        throw new JSONException(message, e);
    }

    public StreamReader.ColumnStat getColumnStat(String name) {
        if (this.columnStats != null) {
            for (StreamReader.ColumnStat stat : this.columnStats) {
                if (!name.equals(stat.name)) continue;
                return stat;
            }
        }
        return null;
    }

    public StreamReader.ColumnStat getColumnStat(int i) {
        if (this.columnStats == null) {
            this.columnStats = new ArrayList();
        }
        StreamReader.ColumnStat stat = null;
        if (i >= this.columnStats.size()) {
            for (int j = this.columnStats.size(); j <= i; ++j) {
                String column = null;
                if (this.columns != null && i < this.columns.size()) {
                    column = (String)this.columns.get(i);
                }
                stat = new StreamReader.ColumnStat(column);
                this.columnStats.add(stat);
            }
        } else {
            stat = (StreamReader.ColumnStat)this.columnStats.get(i);
        }
        return stat;
    }

    public void statAll() {
        String[] line;
        while ((line = (String[])this.readLineValues(true)) != null) {
            for (int i = 0; i < line.length; ++i) {
                String value = line[i];
                if (this.columnStats == null) {
                    this.columnStats = new ArrayList();
                }
                StreamReader.ColumnStat stat = this.getColumnStat(i);
                stat.stat(value);
            }
        }
    }

    public void readAll(ByteArrayConsumer consumer) {
        throw new UnsupportedOperationException();
    }

    public static interface ByteArrayConsumer {
        public void accept(int var1, int var2, byte[] var3, int var4, int var5, Charset var6);

        default public void afterRow(int row) {
        }
    }
}

