/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.aop;

import com.google.common.collect.Lists;
import com.xiaomi.youpin.docean.aop.AopContext;
import com.xiaomi.youpin.docean.aop.EnhanceInterceptor;
import com.xiaomi.youpin.docean.aop.IProxy;
import com.xiaomi.youpin.docean.common.MutableObject;
import com.xiaomi.youpin.docean.common.ReflectUtils;
import com.xiaomi.youpin.docean.exception.DoceanException;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class Proxy
implements IProxy {
    private Object obj;
    private InvocationHandler handler;

    public Proxy(Class clazz, LinkedHashMap<Class, EnhanceInterceptor> interceptor) {
        this.obj = ReflectUtils.getInstance((Class)clazz);
        this.handler = (proxy, method, args) -> {
            ArrayList interceptors = Lists.newArrayList();
            for (Map.Entry entry : interceptor.entrySet()) {
                if (method.getAnnotation((Class)entry.getKey()) == null) continue;
                interceptors.add((EnhanceInterceptor)entry.getValue());
            }
            if (interceptors.size() == 0) {
                return method.invoke(this.obj, args);
            }
            AopContext context = new AopContext();
            try {
                interceptors.stream().forEach(it -> {
                    if (it.needEnhance(method)) {
                        it.before(context, method, args);
                    }
                });
                Object result = method.invoke(this.obj, args);
                MutableObject o = new MutableObject(result);
                interceptors.stream().forEach(it -> {
                    if (it.needEnhance(method)) {
                        Object r = it.after(context, method, o.getObj());
                        o.setObj(r);
                    }
                });
                return o.getObj();
            }
            catch (Throwable ex) {
                interceptors.stream().forEach(it -> {
                    if (it.needEnhance(method)) {
                        it.exception(context, method, ex);
                    }
                });
                throw new DoceanException(ex);
            }
        };
    }

    @Override
    public <T> T getInstance() {
        return (T)java.lang.reflect.Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), this.obj.getClass().getInterfaces(), this.handler);
    }
}

