/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.bo;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.monitor.bo.Triple;

public enum AlarmCheckDataCount {
    zero("0", "\u7acb\u5373\u89e6\u53d1", "Trigger immediately"),
    one("1", "\u6301\u7eed20s", "Lasts 20 seconds"),
    two("2", "\u6301\u7eed40s", "Lasts 40 seconds"),
    three("3", "\u6301\u7eed60s", "Lasts 60 seconds"),
    five("5", "\u6301\u7eed100s", "Lasts 100 seconds"),
    six("6", "\u6301\u7eed120s", "Lasts 120 seconds"),
    seven("7", "\u6301\u7eed140s", "Lasts 140 seconds"),
    eight("8", "\u6301\u7eed160s", "Lasts 160 seconds"),
    nine("9", "\u6301\u7eed180s", "Lasts 180 seconds"),
    fifteen("15", "\u6301\u7eed5m", "Lasts 5 minutes");

    private String code;
    private String label;
    private String enLabel;

    private AlarmCheckDataCount(String code, String label, String enLabel) {
        this.code = code;
        this.label = label;
        this.enLabel = enLabel;
    }

    public static final AlarmCheckDataCount getByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        for (AlarmCheckDataCount count : AlarmCheckDataCount.values()) {
            if (!count.code.equals(code)) continue;
            return count;
        }
        return null;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getEnLabel() {
        return this.enLabel;
    }

    public void setEnLabel(String enLabel) {
        this.enLabel = enLabel;
    }

    public static Map<String, String> getEnumMap() {
        AlarmCheckDataCount[] values;
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (AlarmCheckDataCount value : values = AlarmCheckDataCount.values()) {
            map.put(value.getCode(), value.getLabel());
        }
        return map;
    }

    public static List<Triple> getEnumList() {
        AlarmCheckDataCount[] values;
        ArrayList<Triple> list = new ArrayList<Triple>();
        for (AlarmCheckDataCount value : values = AlarmCheckDataCount.values()) {
            Triple<Integer> triple = new Triple<Integer>(Integer.parseInt(value.getCode()), value.getLabel(), value.getEnLabel());
            list.add(triple);
        }
        return list;
    }

    public static void main(String[] args) {
        System.out.println(AlarmCheckDataCount.getEnumList());
    }
}

