/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.service.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.ozhera.app.api.message.HeraAppInfoModifyMessage;
import org.apache.ozhera.app.api.message.HeraAppModifyType;
import org.apache.ozhera.app.api.model.HeraAppBaseInfoModel;
import org.apache.ozhera.app.api.service.HeraAppService;
import org.apache.ozhera.monitor.bo.AlarmStrategyInfo;
import org.apache.ozhera.monitor.bo.AppViewType;
import org.apache.ozhera.monitor.bo.RuleStatusType;
import org.apache.ozhera.monitor.dao.AppAlarmRuleDao;
import org.apache.ozhera.monitor.dao.AppAlarmStrategyDao;
import org.apache.ozhera.monitor.dao.AppMonitorDao;
import org.apache.ozhera.monitor.dao.HeraAppRoleDao;
import org.apache.ozhera.monitor.dao.model.AlarmHealthQuery;
import org.apache.ozhera.monitor.dao.model.AlarmHealthResult;
import org.apache.ozhera.monitor.dao.model.AlarmStrategy;
import org.apache.ozhera.monitor.dao.model.AppAlarmRule;
import org.apache.ozhera.monitor.dao.model.AppMonitor;
import org.apache.ozhera.monitor.dao.model.HeraAppRole;
import org.apache.ozhera.monitor.result.ErrorCode;
import org.apache.ozhera.monitor.result.Result;
import org.apache.ozhera.monitor.service.AlarmStrategyService;
import org.apache.ozhera.monitor.service.AppAlarmService;
import org.apache.ozhera.monitor.service.AppGrafanaMappingService;
import org.apache.ozhera.monitor.service.AppMonitorService;
import org.apache.ozhera.monitor.service.HeraBaseInfoService;
import org.apache.ozhera.monitor.service.ResourceUsageService;
import org.apache.ozhera.monitor.service.api.AppMonitorServiceExtension;
import org.apache.ozhera.monitor.service.api.TeslaService;
import org.apache.ozhera.monitor.service.extension.PlatFormTypeExtensionService;
import org.apache.ozhera.monitor.service.model.AppMonitorModel;
import org.apache.ozhera.monitor.service.model.AppMonitorRequest;
import org.apache.ozhera.monitor.service.model.PageData;
import org.apache.ozhera.monitor.service.model.ProjectInfo;
import org.apache.ozhera.monitor.service.model.prometheus.AlarmRuleData;
import org.apache.ozhera.monitor.service.model.prometheus.MetricData;
import org.apache.ozhera.monitor.service.model.prometheus.MetricDataSet;
import org.apache.ozhera.monitor.service.model.prometheus.MetricResponse;
import org.apache.ozhera.monitor.service.prometheus.AlarmService;
import org.apache.ozhera.monitor.service.prometheus.PrometheusService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AppMonitorServiceImpl
implements AppMonitorService {
    private static final Logger log = LoggerFactory.getLogger(AppMonitorServiceImpl.class);
    @Autowired
    AppMonitorDao appMonitorDao;
    @Autowired
    HeraBaseInfoService heraBaseInfoService;
    @Autowired
    AppGrafanaMappingService appGrafanaMappingService;
    @Autowired
    AppAlarmService appAlarmService;
    @Autowired
    private TeslaService teslaService;
    @Autowired
    PrometheusService prometheusService;
    @Autowired
    ResourceUsageService resourceUsageService;
    @Autowired
    HeraAppRoleDao heraAppRoleDao;
    @Autowired
    AppAlarmStrategyDao strategyDao;
    @Autowired
    AppAlarmRuleDao ruleDao;
    @Autowired
    AlarmService alarmService;
    @Autowired
    AppMonitorServiceExtension appMonitorServiceExtension;
    @Autowired
    PlatFormTypeExtensionService platFormTypeExtensionService;
    @Autowired
    AlarmStrategyService alarmStrategyService;
    @Reference(registry={"registryConfig"}, check=false, interfaceClass=HeraAppService.class, group="${dubbo.group.heraapp}", timeout=5000)
    HeraAppService hearAppService;

    @Override
    public void appPlatMove(Integer OProjectId, Integer OPlat, Integer NProjectId, Integer Nplat, Integer newIamId, String NprojectName, Boolean rebuildRule) {
        List<AppMonitor> appMonitors;
        log.info("appPlatMove OProjectId:{},OPlat:{},NProjectId:{},Nplat:{},NprojectName:{}", new Object[]{OProjectId, OPlat, NProjectId, Nplat, NprojectName});
        if (OProjectId == null || OPlat == null || NProjectId == null || Nplat == null || StringUtils.isBlank((CharSequence)NprojectName)) {
            log.error("appPlatMove has invalid param! OProjectId:{},OPlat:{},NProjectId:{},Nplat:{},NprojectName:{}", new Object[]{OProjectId, OPlat, NProjectId, Nplat, NprojectName});
            return;
        }
        HeraAppBaseInfoModel baseInfo = new HeraAppBaseInfoModel();
        baseInfo.setBindId(String.valueOf(OProjectId));
        baseInfo.setPlatformType(OPlat);
        List<HeraAppBaseInfoModel> query = this.heraBaseInfoService.query(baseInfo, null, null);
        if (CollectionUtils.isEmpty(query)) {
            log.info("appPlatMove nodata found!OProjectId:{},OPlat:{},NProjectId:{},Nplat:{},NprojectName:{}", new Object[]{OProjectId, OPlat, NProjectId, Nplat, NprojectName});
            return;
        }
        if (query.size() > 1) {
            log.info("appPlatMove more than one data found!OProjectId:{},OPlat:{},NProjectId:{},Nplat:{},NprojectName:{}", new Object[]{OProjectId, OPlat, NProjectId, Nplat, NprojectName});
            return;
        }
        HeraAppBaseInfoModel heraAppBaseInfo = query.get(0);
        String oldProjectName = heraAppBaseInfo.getAppName();
        heraAppBaseInfo.setPlatformType(Nplat);
        heraAppBaseInfo.setIamTreeId(newIamId);
        heraAppBaseInfo.setBindId(String.valueOf(NProjectId));
        heraAppBaseInfo.setAppName(NprojectName);
        int update = this.heraBaseInfoService.insertOrUpdate(heraAppBaseInfo);
        if (update < 1) {
            log.error("appPlatMove update heraBaseInfo fail!OProjectId:{},OPlat:{},NProjectId:{},Nplat:{},NprojectName:{}", new Object[]{OProjectId, OPlat, NProjectId, Nplat, NprojectName});
        }
        HeraAppRole heraAppRole = new HeraAppRole();
        heraAppRole.setAppPlatform(OPlat);
        heraAppRole.setAppId(String.valueOf(OProjectId));
        List<HeraAppRole> appRoles = this.heraAppRoleDao.query(heraAppRole, null, null);
        if (!CollectionUtils.isEmpty(appRoles)) {
            appRoles.forEach(t -> {
                t.setAppId(String.valueOf(NProjectId));
                t.setAppPlatform(Nplat);
                this.heraAppRoleDao.update((HeraAppRole)t);
            });
        }
        if (!CollectionUtils.isEmpty(appMonitors = this.appMonitorDao.getByProjectIdAndPlat(OProjectId, OPlat))) {
            appMonitors.forEach(t -> {
                t.setAppSource(Nplat);
                t.setProjectId(NProjectId);
                t.setIamTreeId(newIamId);
                t.setProjectName(NprojectName);
                this.appMonitorDao.update((AppMonitor)t);
            });
        }
        if (rebuildRule.booleanValue()) {
            AlarmStrategy strategy = new AlarmStrategy();
            strategy.setAppId(OProjectId);
            strategy.setAppName(oldProjectName);
            PageData<List<AlarmStrategyInfo>> listPageData = this.strategyDao.searchByCondNoUser(strategy, 1, 1000, null, null);
            List<AlarmStrategyInfo> list = listPageData.getList();
            if (!CollectionUtils.isEmpty(list)) {
                list.forEach(t -> {
                    List<AppAlarmRule> rules = this.ruleDao.selectByStrategyId(t.getId());
                    for (AppAlarmRule rule : rules) {
                        int i;
                        Result result;
                        Integer oldAlarmId = rule.getAlarmId();
                        Integer oldIamId = rule.getIamId();
                        AppMonitor app = new AppMonitor();
                        app.setProjectId(NProjectId);
                        app.setProjectName(NprojectName);
                        rule.setIamId(newIamId);
                        rule.setProjectId(NProjectId);
                        StringBuilder cname = new StringBuilder();
                        cname.append(newIamId);
                        cname.append("-").append(rule.getAlert());
                        cname.append("-").append(System.currentTimeMillis());
                        rule.setCname(cname.toString());
                        AlarmRuleData ruleData = new AlarmRuleData();
                        BeanUtils.copyProperties((Object)rule, (Object)ruleData);
                        ruleData.setLabels(rule.getLabels());
                        ruleData.convertLabels();
                        ruleData.setIncludeEnvs(t.getIncludeEnvs());
                        ruleData.setExceptEnvs(t.getExceptEnvs());
                        ruleData.setIncludeZones(t.getIncludeZones());
                        ruleData.setExceptZones(t.getExceptZones());
                        ruleData.setIncludeContainerName(t.getIncludeContainerName());
                        ruleData.setExceptContainerName(t.getExceptContainerName());
                        ruleData.setAlertMembers(t.getAlertMembers());
                        if (!CollectionUtils.isEmpty(t.getIncludeFunctions())) {
                            ruleData.setIncludeFunctions(t.getIncludeFunctions().stream().map(String::valueOf).collect(Collectors.toList()));
                        }
                        if (!CollectionUtils.isEmpty(t.getExceptFunctions())) {
                            ruleData.setExceptFunctions(t.getExceptFunctions().stream().map(String::valueOf).collect(Collectors.toList()));
                        }
                        ruleData.setIncludeModules(t.getIncludeModules());
                        ruleData.setExceptModules(t.getExceptModules());
                        Result result1 = this.alarmService.addRule(app, rule, rule.getCreater(), ruleData);
                        if (!result1.isSuccess()) {
                            log.error("appPlatMove add new rule fail!rule{}", (Object)rule.toString());
                            return;
                        }
                        JsonElement data = (JsonElement)result1.getData();
                        Integer alarmId = data.getAsJsonObject().get("id").getAsInt();
                        rule.setAlarmId(alarmId);
                        if (rule.getRuleStatus().equals(RuleStatusType.pause.getCode()) && !(result = this.alarmService.enabledRule(alarmId, RuleStatusType.pause.getCode(), rule.getIamId(), rule.getCreater())).isSuccess()) {
                            log.error("appPlatMove pause rule fail!rule{}", (Object)rule.toString());
                        }
                        if (!(result = this.alarmService.deleteRule(oldAlarmId, oldIamId, rule.getCreater())).isSuccess()) {
                            log.error("appPlatMove del old rule fail!rule{}", (Object)rule.toString());
                        }
                        if ((i = this.ruleDao.updateByIdSelective(rule)) >= 1) continue;
                        log.error("appPlatMove update rule db fail! rule{}", (Object)rule.toString());
                    }
                    AlarmStrategy strategyUp = new AlarmStrategy();
                    strategyUp.setId(t.getId());
                    strategyUp.setAppId(NProjectId);
                    strategyUp.setAppName(NprojectName);
                    strategyUp.setIamId(newIamId);
                    boolean b = this.strategyDao.updateById(strategyUp);
                    if (!b) {
                        log.error("appPlatMove update strategy fail! oldP:{},new:{}", (Object)t.toString(), (Object)strategyUp.toString());
                    }
                });
            }
        }
    }

    @Override
    public Result selectAppAlarmHealth(AlarmHealthQuery query) {
        try {
            List<AlarmHealthResult> alarmHealthResults = this.appMonitorDao.selectAppHealth(query);
            if (!CollectionUtils.isEmpty(alarmHealthResults)) {
                for (AlarmHealthResult alarmHealth : alarmHealthResults) {
                    alarmHealth.setBasicMetricScore((alarmHealth.getCpuUseRate() > 0 ? 2 : 0) + (alarmHealth.getCpuLoad() > 0 ? 2 : 0) + (alarmHealth.getMemUseRate() > 0 ? 2 : 0) + (alarmHealth.getContainerNum() > 0 ? 2 : 0) + (alarmHealth.getJvmThread() > 0 ? 1 : 0) + (alarmHealth.getJvmGc() > 0 ? 1 : 0));
                    alarmHealth.setInterfaceMetricScore((alarmHealth.getHttpServerAvailability() > 0 ? 2 : 0) + (alarmHealth.getHttpServerQps() > 0 ? 1 : 0) + (alarmHealth.getHttpServerTimeCost() > 0 ? 1 : 0) + (alarmHealth.getHttpClientAvailability() > 0 ? 1 : 0) + (alarmHealth.getHttpClientQps() > 0 ? 1 : 0) + (alarmHealth.getHttpClientTimeCost() > 0 ? 1 : 0) + (alarmHealth.getDubboProviderAvailability() > 0 ? 2 : 0) + (alarmHealth.getDubboProviderQps() > 0 ? 1 : 0) + (alarmHealth.getDubboProviderTimeCost() > 0 ? 1 : 0) + (alarmHealth.getDubboProviderSlowQuery() > 0 ? 1 : 0) + (alarmHealth.getDubboConsumerAvailability() > 0 ? 1 : 0) + (alarmHealth.getDubboConsumerQps() > 0 ? 1 : 0) + (alarmHealth.getDubboConsumerTimeCost() > 0 ? 1 : 0) + (alarmHealth.getDubboConsumerSlowQuery() > 0 ? 1 : 0) + (alarmHealth.getDbAvailability() > 0 ? 2 : 0) + (alarmHealth.getDbSlowQuery() > 0 ? 1 : 0));
                    alarmHealth.setComprehensiveScore(alarmHealth.getBasicMetricScore() + alarmHealth.getInterfaceMetricScore());
                }
            }
            return Result.success(alarmHealthResults);
        }
        catch (Exception e) {
            log.error("selectAppAlarmHealth Error!{}", (Object)e.getMessage(), (Object)e);
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    @Override
    public Result getResourceUsageUrlForK8s(Integer appId, String appName) {
        return this.appMonitorServiceExtension.getResourceUsageUrlForK8s(appId, appName);
    }

    @Override
    public Result initAppsByUsername(String userName) {
        return this.appMonitorServiceExtension.initAppsByUsername(userName);
    }

    @Override
    public List<ProjectInfo> getAppsByUserName(String username) {
        return this.appMonitorServiceExtension.getAppsByUserName(username);
    }

    @Override
    public Result<PageData> getProjectInfos(String userName, String appName, Integer page, Integer pageSize) {
        if (page == null) {
            page = 1;
        }
        if (pageSize == null) {
            pageSize = 10;
        }
        PageData pd = new PageData();
        pd.setPage(page);
        pd.setPageSize(pageSize);
        HeraAppBaseInfoModel model = new HeraAppBaseInfoModel();
        model.setAppName(appName);
        Long total = this.hearAppService.count(model);
        pd.setTotal(total);
        List query = this.hearAppService.query(model, page, pageSize);
        ArrayList list = new ArrayList();
        if (CollectionUtils.isEmpty((Collection)query)) {
            pd.setList(list);
            return Result.success(pd);
        }
        query.forEach(t -> {
            ProjectInfo info = new ProjectInfo();
            info.setId(Long.valueOf(t.getBindId()));
            info.setName(t.getAppName());
            info.setIamTreeId(t.getIamTreeId() != null ? Long.valueOf(t.getIamTreeId().intValue()) : (long)t.getIamTreeId().intValue());
            list.add(info);
        });
        pd.setList(list);
        return Result.success(pd);
    }

    @Override
    public Result<String> createWithBaseInfo(AppMonitorModel appMonitorModel, String user) {
        HeraAppBaseInfoModel heraAppBaseInfo = appMonitorModel.baseInfo();
        Integer baseInfoId = this.createBaseInfo(heraAppBaseInfo);
        if (baseInfoId == null) {
            log.error("createBaseInfo fail!heraAppBaseInfo:{}", (Object)heraAppBaseInfo);
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        AppMonitor appMonitor = appMonitorModel.appMonitor();
        appMonitor.setBaseInfoId(baseInfoId);
        if (!this.appMonitorServiceExtension.checkCreateParam(appMonitor).booleanValue()) {
            log.error("AppMonitorService.createWithBaseInfo \u7528\u6237{}\u6dfb\u52a0\u9879\u76ee{}\uff0c\u53c2\u6570\u4e0d\u5408\u6cd5", (Object)user, (Object)appMonitor);
            return Result.fail((ErrorCode)ErrorCode.invalidParamError);
        }
        if (StringUtils.isNotBlank((CharSequence)appMonitor.getOwner()) && appMonitor.getOwner().equals("yes")) {
            appMonitor.setOwner(user);
        } else {
            appMonitor.setCareUser(user);
        }
        Result<String> result = this.create(appMonitor);
        if (!result.isSuccess()) {
            log.error("AppMonitorController.addApp fail! user:{},appMonitorModel:{}", (Object)user, (Object)appMonitorModel);
            return Result.fail((ErrorCode)ErrorCode.invalidParamError);
        }
        return Result.success(null);
    }

    @Override
    public Integer createBaseInfo(HeraAppBaseInfoModel heraAppBaseInfo) {
        HeraAppBaseInfoModel queryCondition = new HeraAppBaseInfoModel();
        queryCondition.setBindId(heraAppBaseInfo.getBindId());
        queryCondition.setPlatformType(heraAppBaseInfo.getPlatformType());
        List<HeraAppBaseInfoModel> query = this.heraBaseInfoService.query(queryCondition, 1, 10);
        if (!CollectionUtils.isEmpty(query)) {
            log.info("createBaseInfo HeraAppBaseInfo has exist!heraAppBaseInfo:{},query Result:{}", (Object)heraAppBaseInfo, (Object)new Gson().toJson(query));
            return query.get(0).getId();
        }
        int i = this.heraBaseInfoService.insertOrUpdate(heraAppBaseInfo);
        if (i <= 0) {
            return null;
        }
        return heraAppBaseInfo.getId();
    }

    @Override
    public Result<String> create(AppMonitor appMonitor) {
        AppMonitor app;
        if (appMonitor == null) {
            log.error("AppMonitorService.create param is null");
            return Result.fail((ErrorCode)ErrorCode.invalidParamError);
        }
        if (appMonitor.getProjectId() == null || StringUtils.isEmpty((CharSequence)appMonitor.getProjectName())) {
            log.error("AppMonitorService.create param is avalid! projectId or projectName is empty!");
            return Result.fail((ErrorCode)ErrorCode.invalidParamError);
        }
        if (StringUtils.isEmpty((CharSequence)appMonitor.getOwner()) && StringUtils.isEmpty((CharSequence)appMonitor.getCareUser())) {
            log.error("AppMonitorService.create param is avalid! owner and careUser can not both null at same time!");
            return Result.fail((ErrorCode)ErrorCode.invalidParamError);
        }
        AppViewType viewType = AppViewType.MyApp;
        String userName = appMonitor.getOwner();
        if (StringUtils.isEmpty((CharSequence)appMonitor.getOwner())) {
            viewType = AppViewType.MyCareApp;
            userName = appMonitor.getCareUser();
        }
        if ((app = this.appMonitorDao.getMyApp(appMonitor.getProjectId(), appMonitor.getIamTreeId(), userName, viewType)) != null) {
            log.info("AppMonitorService.create update Data appMonitor : {}", (Object)appMonitor);
            app.setProjectName(appMonitor.getProjectName());
            app.setBaseInfoId(appMonitor.getBaseInfoId());
            int update = this.appMonitorDao.update(app);
            if (update > 0) {
                log.info("AppMonitorService.create update Data success appMonitor : {}", (Object)appMonitor);
                return Result.success(null);
            }
            log.info("AppMonitorService.create database update Data failed appMonitor : {}", (Object)appMonitor);
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        if (AppViewType.MyCareApp.equals((Object)viewType)) {
            app = this.appMonitorDao.getMyApp(appMonitor.getProjectId(), appMonitor.getIamTreeId(), userName, AppViewType.MyApp);
            if (app != null) {
                log.error("AppMonitorService.create\u9879\u76ee\u5df2\u7ecf\u6dfb\u52a0\u8fc7\u53c2\u4e0e\u9879\u76ee\uff0c param={}", (Object)appMonitor);
                return Result.fail((ErrorCode)ErrorCode.REPEAT_ADD_PROJECT);
            }
        } else {
            Result<String> delResult;
            app = this.appMonitorDao.getMyApp(appMonitor.getProjectId(), appMonitor.getIamTreeId(), userName, AppViewType.MyCareApp);
            if (app != null && (delResult = this.delete(app.getId())).getCode() != ErrorCode.success.getCode()) {
                return delResult;
            }
        }
        try {
            int i = this.appMonitorDao.create(appMonitor);
            if (i > 0) {
                this.createGrafana(appMonitor);
                log.info("AppMonitorService.create success appMonitor : {}", (Object)appMonitor);
                return new Result(ErrorCode.success.getCode(), ErrorCode.success.getMessage(), null);
            }
            log.info("AppMonitorService.create database create data failed appMonitor : {}", (Object)appMonitor);
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        catch (Exception e) {
            log.error("AppMonitorService.create error" + e.getMessage(), (Throwable)e);
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    private void createGrafana(AppMonitor appMonitor) {
        HeraAppBaseInfoModel baseInfo;
        if (appMonitor.getAppSource() == null) {
            return;
        }
        StringBuilder appName = new StringBuilder();
        appName.append(appMonitor.getProjectId()).append("_").append(appMonitor.getProjectName().replace('.', '_'));
        String area = this.platFormTypeExtensionService.getGrafanaDirByTypeCode(appMonitor.getAppSource());
        if (StringUtils.isBlank((CharSequence)area)) {
            log.error("invalid grafana area!appMonitor:{}", (Object)appMonitor);
            return;
        }
        HeraAppBaseInfoModel heraAppBaseInfo = new HeraAppBaseInfoModel();
        heraAppBaseInfo.setBindId("" + appMonitor.getProjectId());
        heraAppBaseInfo.setPlatformType(appMonitor.getAppSource());
        List<HeraAppBaseInfoModel> query = this.heraBaseInfoService.query(heraAppBaseInfo, null, null);
        HeraAppBaseInfoModel heraAppBaseInfoModel = baseInfo = CollectionUtils.isEmpty(query) ? null : query.get(0);
        if (baseInfo == null) {
            log.error("no base data found for app : {},stop generate grafana url", (Object)appMonitor.getProjectName());
            return;
        }
        this.appGrafanaMappingService.createTmpByAppBaseInfo(baseInfo);
    }

    @Override
    public Result<String> delete(Integer id) {
        if (id == null) {
            log.error("AppMonitorService.delete error param id is null!");
            return Result.fail((ErrorCode)ErrorCode.invalidParamError);
        }
        AppMonitor app = this.appMonitorDao.getById(id);
        if (app == null) {
            log.error("AppMonitorService.delete error cannot find data by id : {}", (Object)id);
            return Result.fail((ErrorCode)ErrorCode.invalidParamError);
        }
        app.setStatus(1);
        int update = this.appMonitorDao.update(app);
        if (update < 1) {
            log.error("AppMonitorService.delete error delete database failed!");
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        return Result.success(null);
    }

    @Override
    public Result<String> deleteByUser(Integer projectId, Integer appSource, String userName) {
        try {
            List<AppMonitor> apps = this.appMonitorDao.getMyOwnerOrCareAppById(projectId, appSource, userName);
            if (CollectionUtils.isEmpty(apps)) {
                log.error("AppMonitorService.deleteByUser error cannot find data,projectId : {}", (Object)projectId);
                return Result.fail((ErrorCode)ErrorCode.unknownError);
            }
            for (AppMonitor app : apps) {
                app.setStatus(1);
                int update = this.appMonitorDao.update(app);
                if (update >= 1) continue;
                log.error("AppMonitorService.deleteByUser error delete database failed!app:{}", (Object)app);
                return Result.fail((ErrorCode)ErrorCode.unknownError);
            }
            return Result.success(null);
        }
        catch (Exception e) {
            log.error("deleteByUser error!" + e.getMessage(), (Throwable)e);
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    @Override
    public Result<PageData<List<AppMonitor>>> listApp(String appName, String userName, Integer page, Integer pageSize_) {
        if (StringUtils.isEmpty((CharSequence)userName)) {
            log.error("AppMonitorService.listApp param is invalid userName is empty!");
            return Result.fail((ErrorCode)ErrorCode.invalidParamError);
        }
        Integer pageNum = page;
        Integer pageSize = pageSize_;
        if (pageNum == null || pageNum < 1) {
            pageNum = 1;
        }
        if (pageSize == null) {
            pageSize = 10;
        }
        PageData<List<AppMonitor>> pd = new PageData<List<AppMonitor>>();
        pd.setPage(pageNum);
        pd.setPageSize(pageSize);
        try {
            Long dataTotal = this.appMonitorDao.getDataTotalByOr(appName, userName, userName);
            pd.setTotal(dataTotal);
            if (dataTotal != null && dataTotal.intValue() > 0) {
                List<AppMonitor> apps = this.appMonitorDao.getMyOwnerOrCareApp(appName, userName, pageNum, pageSize);
                pd.setList(apps);
            }
            log.info("AppMonitorService.listApp success! param  appName : {}, userName : {},result Count : {} ", new Object[]{appName, userName, dataTotal});
            return new Result(ErrorCode.success.getCode(), ErrorCode.success.getMessage(), pd);
        }
        catch (Exception e) {
            log.error("AppMonitorService.listApp error" + e.getMessage(), (Throwable)e);
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    @Override
    public Result<PageData<List<AppMonitor>>> listAppDistinct(String userName, String appName, Integer page, Integer pageSize_) {
        if (StringUtils.isEmpty((CharSequence)userName)) {
            log.error("AppMonitorService.listAppDistinct param is invalid userName is empty!");
            return Result.fail((ErrorCode)ErrorCode.invalidParamError);
        }
        Integer pageNum = page;
        Integer pageSize = pageSize_;
        if (pageNum == null || pageNum < 1) {
            pageNum = 1;
        }
        if (pageSize == null) {
            pageSize = 10;
        }
        PageData<List<AppMonitor>> pd = new PageData<List<AppMonitor>>();
        pd.setPage(pageNum);
        pd.setPageSize(pageSize);
        try {
            Long dataTotal = this.appMonitorDao.countAllMyAppDistinct(userName, appName);
            pd.setTotal(dataTotal);
            if (dataTotal != null && dataTotal.intValue() > 0) {
                List<AppMonitor> apps = this.appMonitorDao.getAllMyAppDistinct(userName, appName, pageNum, pageSize);
                pd.setList(apps);
            }
            log.info("AppMonitorService.listAppDistinct success! param  appName : {}, userName : {},result Count : {} ", new Object[]{appName, userName, dataTotal});
            return new Result(ErrorCode.success.getCode(), ErrorCode.success.getMessage(), pd);
        }
        catch (Exception e) {
            log.error("AppMonitorService.listAppDistinct error" + e.getMessage(), (Throwable)e);
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    @Override
    public Result<PageData<List<AppMonitor>>> listMyApp(AppMonitor appMonitor, String userName, Integer page, Integer pageSize_) {
        if (StringUtils.isEmpty((CharSequence)userName)) {
            log.error("AppMonitorService.listMyApp param is invalid userName is empty!");
            return Result.fail((ErrorCode)ErrorCode.invalidParamError);
        }
        Integer pageNum = page;
        Integer pageSize = pageSize_;
        if (pageNum == null || pageNum < 1) {
            pageNum = 1;
        }
        if (pageSize == null) {
            pageSize = 10;
        }
        PageData<List<AppMonitor>> pd = new PageData<List<AppMonitor>>();
        pd.setPage(pageNum);
        pd.setPageSize(pageSize);
        try {
            Long dataTotal = this.appMonitorDao.getDataTotal(appMonitor, userName, null);
            pd.setTotal(dataTotal);
            log.info("AppMonitorService.listMyApp success! param  appName : {}, userName : {},result Count : {} ", new Object[]{appMonitor.getProjectName(), userName, dataTotal});
            if (dataTotal != null && dataTotal.intValue() > 0) {
                List<AppMonitor> myCareApp = this.appMonitorDao.getMyOwnerApp(appMonitor, userName, pageNum, pageSize);
                pd.setList(myCareApp);
            }
            return new Result(ErrorCode.success.getCode(), ErrorCode.success.getMessage(), pd);
        }
        catch (Exception e) {
            log.error("AppMonitorService.listMyApp error" + e.getMessage(), (Throwable)e);
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    @Override
    public Result<PageData<List<AppMonitor>>> myAndCareAppList(String user, AppMonitorRequest param) {
        PageData<List<AppMonitor>> pageData = this.appMonitorDao.getMyAndCareAppList(user, param.getAppName(), param.getPage(), param.getPageSize(), param.isNeedPage());
        return Result.success(pageData);
    }

    @Override
    public Result<PageData<List<AppMonitor>>> listMyCareApp(String appName, String careUser, Integer page, Integer pageSize_) {
        if (StringUtils.isEmpty((CharSequence)careUser)) {
            log.error("AppMonitorService.listMyCareApp param is invalid careUser is empty!");
            return Result.fail((ErrorCode)ErrorCode.invalidParamError);
        }
        Integer pageNum = page;
        Integer pageSize = pageSize_;
        if (pageNum == null || pageNum < 1) {
            pageNum = 1;
        }
        if (pageSize == null) {
            pageSize = 10;
        }
        PageData<List<AppMonitor>> pd = new PageData<List<AppMonitor>>();
        pd.setPage(pageNum);
        pd.setPageSize(pageSize);
        try {
            AppMonitor appMonitor = new AppMonitor();
            appMonitor.setProjectName(appName);
            Long dataTotal = this.appMonitorDao.getDataTotal(appMonitor, null, careUser);
            pd.setTotal(dataTotal);
            log.info("AppMonitorService.listMyCareApp success! param  appName : {}, careUser : {},result Count : {} ", new Object[]{appName, careUser, dataTotal});
            if (dataTotal != null && dataTotal.intValue() > 0) {
                List<AppMonitor> myCareApp = this.appMonitorDao.getMyCareApp(appName, careUser, pageNum, pageSize);
                pd.setList(myCareApp);
            }
            return new Result(ErrorCode.success.getCode(), ErrorCode.success.getMessage(), pd);
        }
        catch (Exception e) {
            log.error("AppMonitorService.listMyCareApp error" + e.getMessage(), (Throwable)e);
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    @Override
    public AppMonitor getByIamTreeId(Integer aimTreeId) {
        try {
            return this.appMonitorDao.getByIamTreeId(aimTreeId);
        }
        catch (Exception e) {
            log.error("AppMonitorService.getByIamTreeId error! {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    @Override
    public Result getTeslaAlarmHealthByUser(String user) {
        return this.teslaService.getTeslaAlarmHealthByUser(user);
    }

    @Override
    public void washBaseId() {
        Integer pageSize = 100;
        Integer page = 0;
        Long dataTotalL = this.appMonitorDao.getDataTotal(new AppMonitor(), null, null);
        log.info("washBaseId totalNum:{}", (Object)dataTotalL);
        Integer dataTotal = dataTotalL.intValue();
        page = dataTotal % pageSize == 0 ? dataTotal / pageSize : dataTotal / pageSize + 1;
        for (int i = 1; i <= page; ++i) {
            List<AppMonitor> allApps = this.appMonitorDao.getAllApps(i, pageSize);
            for (AppMonitor app : allApps) {
                HeraAppBaseInfoModel queryCondition = new HeraAppBaseInfoModel();
                queryCondition.setBindId(String.valueOf(app.getProjectId()));
                queryCondition.setPlatformType(app.getAppSource());
                List<HeraAppBaseInfoModel> appBase = this.heraBaseInfoService.query(queryCondition, 1, 1);
                if (CollectionUtils.isEmpty(appBase)) {
                    log.info("washBaseId no HeraAppBaseInfo found for app:{}", (Object)app.toString());
                    continue;
                }
                app.setBaseInfoId(appBase.get(0).getId());
                int update = this.appMonitorDao.update(app);
                log.info("wash baseId for app:{},result:{}", (Object)app.toString(), (Object)update);
            }
        }
    }

    @Override
    public Result grafanaInterfaceList() {
        return this.appMonitorServiceExtension.grafanaInterfaceList();
    }

    @Override
    public Result selectByIAMId(Integer iamId, Integer iamType, String userName) {
        try {
            List<AppMonitor> appMonitors = this.appMonitorDao.selectByIAMId(iamId, iamType, userName);
            return Result.success(appMonitors);
        }
        catch (Throwable t) {
            log.error("select by iamId error : ", t);
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    @Override
    public void heraAppInfoModify(HeraAppInfoModifyMessage baseInfoModify) {
        if (HeraAppModifyType.create.equals((Object)baseInfoModify.getModifyType())) {
            HeraAppBaseInfoModel appBaseInfoModel = baseInfoModify.baseInfoModel();
            this.appGrafanaMappingService.createTmpByAppBaseInfo(appBaseInfoModel);
        }
        if (HeraAppModifyType.update.equals((Object)baseInfoModify.getModifyType())) {
            this.modifyAppAndAlarm(baseInfoModify);
        }
        if (HeraAppModifyType.delete.equals((Object)baseInfoModify.getModifyType())) {
            this.heraAppDelete(baseInfoModify);
        }
    }

    private void heraAppDelete(HeraAppInfoModifyMessage message) {
        this.deleteByBaseInfoId(message.getId());
        this.alarmStrategyService.deleteByAppIdAndIamId(message.getAppId(), message.getIamTreeId());
    }

    private void deleteByBaseInfoId(Integer baseInfoId) {
        List<AppMonitor> appMonitors = this.appMonitorDao.listAppsByBaseInfoId(baseInfoId);
        if (CollectionUtils.isEmpty(appMonitors)) {
            log.info("deleteByBaseInfoId no data found! baseInfoId:{}", (Object)baseInfoId);
            return;
        }
        for (AppMonitor appMonitor : appMonitors) {
            this.appMonitorDao.delete(appMonitor.getId());
        }
    }

    @Override
    public void modifyAppAndAlarm(HeraAppInfoModifyMessage baseInfoModify) {
        List<AppMonitor> appMonitors = this.appMonitorDao.listAppsByBaseInfoId(baseInfoModify.getId());
        if (!CollectionUtils.isEmpty(appMonitors)) {
            appMonitors.forEach(t -> {
                t.setAppSource(baseInfoModify.getPlatformType());
                t.setProjectId(baseInfoModify.getAppId());
                t.setIamTreeId(baseInfoModify.getIamTreeId());
                t.setIamTreeType(baseInfoModify.getIamTreeType());
                t.setProjectName(baseInfoModify.getAppName());
                this.appMonitorDao.update((AppMonitor)t);
            });
        }
        if (baseInfoModify.getIsNameChange().booleanValue()) {
            AlarmStrategy strategy = new AlarmStrategy();
            strategy.setAppId(baseInfoModify.getAppId());
            strategy.setIamId(baseInfoModify.getIamTreeId());
            if (!this.appMonitorServiceExtension.checkAppModifyStrategySearchCondition(baseInfoModify).booleanValue()) {
                return;
            }
            PageData<List<AlarmStrategyInfo>> listPageData = this.strategyDao.searchByCondNoUser(strategy, 1, 1000, null, null);
            List<AlarmStrategyInfo> list = listPageData.getList();
            if (!CollectionUtils.isEmpty(list)) {
                list.forEach(t -> {
                    List<AppAlarmRule> rules = this.ruleDao.selectByStrategyId(t.getId());
                    for (AppAlarmRule rule : rules) {
                        AppMonitor app = new AppMonitor();
                        app.setProjectId(baseInfoModify.getAppId());
                        app.setProjectName(baseInfoModify.getAppName());
                        AlarmRuleData ruleData = new AlarmRuleData();
                        BeanUtils.copyProperties((Object)rule, (Object)ruleData);
                        ruleData.setLabels(rule.getLabels());
                        ruleData.convertLabels();
                        ruleData.setIncludeEnvs(t.getIncludeEnvs());
                        ruleData.setExceptEnvs(t.getExceptEnvs());
                        ruleData.setIncludeZones(t.getIncludeZones());
                        ruleData.setExceptZones(t.getExceptZones());
                        ruleData.setIncludeContainerName(t.getIncludeContainerName());
                        ruleData.setExceptContainerName(t.getExceptContainerName());
                        ruleData.setAlertMembers(t.getAlertMembers());
                        ruleData.setAtMembers(t.getAtMembers());
                        if (!CollectionUtils.isEmpty(t.getIncludeFunctions())) {
                            ruleData.setIncludeFunctions(t.getIncludeFunctions().stream().map(String::valueOf).collect(Collectors.toList()));
                        }
                        if (!CollectionUtils.isEmpty(t.getExceptFunctions())) {
                            ruleData.setExceptFunctions(t.getExceptFunctions().stream().map(String::valueOf).collect(Collectors.toList()));
                        }
                        ruleData.setIncludeModules(t.getIncludeModules());
                        ruleData.setExceptModules(t.getExceptModules());
                        Result result = this.alarmService.editRule(rule, ruleData, app, rule.getCreater());
                        if (!result.isSuccess()) {
                            log.error("heraAppInfoModify fail! rule : {} , result : {}", (Object)rule.toString(), (Object)new Gson().toJson((Object)result));
                            continue;
                        }
                        int i = this.ruleDao.updateByIdSelective(rule);
                        if (i >= 1) continue;
                        log.error("heraAppInfoModify update rule db fail! rule{}", (Object)rule.toString());
                    }
                    AlarmStrategy strategyUp = new AlarmStrategy();
                    strategyUp.setId(t.getId());
                    strategyUp.setAppId(baseInfoModify.getAppId());
                    strategyUp.setAppName(baseInfoModify.getAppName());
                    strategyUp.setIamId(baseInfoModify.getIamTreeId());
                    boolean b = this.strategyDao.updateById(strategyUp);
                    if (!b) {
                        log.error("heraAppInfoModify update strategy fail! old:{},new:{}", (Object)t.toString(), (Object)strategyUp.toString());
                    }
                });
            }
        }
    }

    @Override
    public void washBugData() {
        AlarmStrategy strategy = new AlarmStrategy();
        PageData<List<AlarmStrategyInfo>> listPageData = this.strategyDao.searchByCondNoUser(strategy, 1, 1000, null, null);
        List<AlarmStrategyInfo> list = listPageData.getList();
        if (!CollectionUtils.isEmpty(list)) {
            list.forEach(t -> {
                AppAlarmRule rule;
                AppMonitor appMonitor;
                List<AppAlarmRule> rules = this.ruleDao.selectByStrategyId(t.getId());
                if (!CollectionUtils.isEmpty(rules) && (appMonitor = this.appMonitorDao.getByIamTreeIdAndAppId((rule = rules.get(0)).getIamId(), rule.getProjectId())) != null) {
                    AlarmStrategy strategyUp = new AlarmStrategy();
                    strategyUp.setId(t.getId());
                    strategyUp.setAppId(appMonitor.getProjectId());
                    strategyUp.setAppName(appMonitor.getProjectName());
                    strategyUp.setIamId(appMonitor.getIamTreeId());
                    boolean b = this.strategyDao.updateById(strategyUp);
                    if (!b) {
                        log.error("heraAppInfoModify update strategy fail! old:{},new:{}", (Object)t.toString(), (Object)strategyUp.toString());
                    }
                    for (AppAlarmRule rule1 : rules) {
                        AlarmRuleData ruleData = new AlarmRuleData();
                        BeanUtils.copyProperties((Object)rule1, (Object)ruleData);
                        ruleData.setLabels(rule1.getLabels());
                        ruleData.convertLabels();
                        ruleData.setIncludeEnvs(t.getIncludeEnvs());
                        ruleData.setExceptEnvs(t.getExceptEnvs());
                        ruleData.setIncludeZones(t.getIncludeZones());
                        ruleData.setExceptZones(t.getExceptZones());
                        ruleData.setIncludeContainerName(t.getIncludeContainerName());
                        ruleData.setExceptContainerName(t.getExceptContainerName());
                        ruleData.setAlertMembers(t.getAlertMembers());
                        ruleData.setAtMembers(t.getAtMembers());
                        if (!CollectionUtils.isEmpty(t.getIncludeFunctions())) {
                            ruleData.setIncludeFunctions(t.getIncludeFunctions().stream().map(String::valueOf).collect(Collectors.toList()));
                        }
                        if (!CollectionUtils.isEmpty(t.getExceptFunctions())) {
                            ruleData.setExceptFunctions(t.getExceptFunctions().stream().map(String::valueOf).collect(Collectors.toList()));
                        }
                        ruleData.setIncludeModules(t.getIncludeModules());
                        ruleData.setExceptModules(t.getExceptModules());
                        Result result = this.alarmService.editRule(rule1, ruleData, appMonitor, rule1.getCreater());
                        if (result.isSuccess()) continue;
                        log.error("washBugData fail! rule1 : {} , result : {}", (Object)rule1.toString(), (Object)new Gson().toJson((Object)result));
                    }
                }
            });
        }
    }

    @Override
    public void washBugDataForAppMonitor() {
        List<AppMonitor> allApps = this.appMonitorDao.getAllApps(1, 5000);
        for (AppMonitor appMonitor : allApps) {
            if (appMonitor.getBaseInfoId() == null) {
                log.error("update appMonitor no baseId found! appMonitor : {}", (Object)appMonitor.toString());
                continue;
            }
            HeraAppBaseInfoModel byId = this.heraBaseInfoService.getById(appMonitor.getBaseInfoId());
            if (byId == null || StringUtils.isBlank((CharSequence)byId.getBindId())) {
                log.error("update appMonitor HeraAppBaseInfo error! appMonitor : {}", (Object)appMonitor.toString());
                continue;
            }
            try {
                appMonitor.setProjectId(Integer.valueOf(byId.getBindId()));
                appMonitor.setIamTreeId(byId.getIamTreeId());
                int update = this.appMonitorDao.update(appMonitor);
                if (update >= 1) continue;
                log.error("update appMonitor fail! appMonitor : {}", (Object)appMonitor.toString());
            }
            catch (NumberFormatException e) {
                log.error("update appMonitor error!" + e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public Result historyInstance(String application, Long startTime, Long endTime) {
        String promql = "count(jvm_classes_loaded_classes{application=\"" + application + "\"}) by (serverIp)";
        log.info("historyInstance promql : {}", (Object)promql);
        MetricResponse rangeMetricResponse = this.prometheusService.queryRangePrometheusByPromQl(promql, startTime, endTime, null, null);
        if (rangeMetricResponse == null || rangeMetricResponse.getData() == null) {
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        MetricData rangeMetricData = rangeMetricResponse.getData();
        List<MetricDataSet> rangeResult = rangeMetricData.getResult();
        ArrayList rangeIps = new ArrayList();
        rangeResult.forEach(t -> rangeIps.add(t.getMetric().getServerIp()));
        return Result.success(rangeIps);
    }

    @Override
    public Long countByBaseInfoId(List<Integer> baseInfoIds, String user) {
        return this.appMonitorDao.countByBaseInfoIds(baseInfoIds, user);
    }

    @Override
    public List<AppMonitor> searchByBaseInfoId(List<Integer> baseInfoIds, String user, Integer page, Integer pageSize) {
        return this.appMonitorDao.getDataByBaseInfoIds(baseInfoIds, user, page, pageSize);
    }
}

