/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.service.impl;

import java.util.List;
import org.apache.ozhera.monitor.dao.GrafanaBlackListDao;
import org.apache.ozhera.monitor.dao.model.AppGrafanaBlackList;
import org.apache.ozhera.monitor.result.ErrorCode;
import org.apache.ozhera.monitor.result.Result;
import org.apache.ozhera.monitor.service.GrafanaBlackListService;
import org.apache.ozhera.monitor.service.model.PageData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GrafanaBlackListServiceImpl
implements GrafanaBlackListService {
    private static final Logger log = LoggerFactory.getLogger(GrafanaBlackListServiceImpl.class);
    @Autowired
    GrafanaBlackListDao grafanaBlackListDao;

    @Override
    public Result createBlackList(String serverName) {
        List<AppGrafanaBlackList> blackListByServerName = this.grafanaBlackListDao.getBlackListByServerName(serverName);
        if (blackListByServerName.size() >= 1) {
            return Result.fail((ErrorCode)ErrorCode.REPEAT_ADD_PROJECT);
        }
        Integer blackList = this.grafanaBlackListDao.createBlackList(serverName);
        if (blackList == null || blackList == -1 || blackList == 0) {
            log.error("GrafanaBlackListService.createBlackList error");
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        return Result.success((Object)blackList);
    }

    @Override
    public Result getBlackList(String serverName) {
        AppGrafanaBlackList blackList = this.grafanaBlackListDao.getBlackList(serverName);
        return Result.success((Object)blackList);
    }

    @Override
    public Result delBlackList(String serverName) {
        Integer res = this.grafanaBlackListDao.delBlackListByServerName(serverName);
        if (res == null || res == 0 || res == -1) {
            log.error("GrafanaBlackListService.delBlackList error");
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        return Result.success((Object)res);
    }

    @Override
    public Result getBlackListList(Integer page, Integer pageSize) {
        PageData<List<AppGrafanaBlackList>> pd = new PageData<List<AppGrafanaBlackList>>();
        pd.setPage(page);
        pd.setPageSize(pageSize);
        pd.setTotal(this.grafanaBlackListDao.getTotalBlackList());
        pd.setList(this.grafanaBlackListDao.getAllBlackList(page, pageSize));
        return Result.success(pd);
    }

    @Override
    public boolean isInBlackList(String serverName) {
        List<AppGrafanaBlackList> blackListByServerName = this.grafanaBlackListDao.getBlackListByServerName(serverName);
        return blackListByServerName.size() >= 1;
    }
}

