/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.trace.etl.manager.config;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import com.xiaomi.mone.tpc.login.filter.HttpReqUserFilter;
import javax.servlet.Filter;
import org.apache.ozhera.trace.etl.manager.filter.RequestHeaderFilter;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class FilterConfiguration {
    @NacosValue(value="${tpc.token.parse.url}")
    public String tokenParseUrl;

    @Bean
    public FilterRegistrationBean requestHeaderBean() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)new RequestHeaderFilter());
        registrationBean.addUrlPatterns(new String[]{"/*"});
        registrationBean.setOrder(1);
        return registrationBean;
    }

    @Bean
    public FilterRegistrationBean filterCasBean() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)new HttpReqUserFilter());
        registrationBean.addUrlPatterns(new String[]{"/*"});
        registrationBean.addInitParameter("innerAuth", "false");
        registrationBean.addInitParameter("IGNORE_URL", "/tracing/v1/*");
        registrationBean.addInitParameter("authTokenUrl", this.tokenParseUrl);
        registrationBean.addInitParameter("devMode", "false");
        registrationBean.setOrder(0);
        return registrationBean;
    }
}

