/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.ioc.meta;

import org.nutz.ioc.Iocs;
import org.nutz.ioc.meta.IocValue;
import org.nutz.json.Json;
import org.nutz.json.JsonFormat;
import org.nutz.lang.util.NutMap;

public class IocField {
    private String name;
    private IocValue value;
    private boolean optional;

    public IocField() {
    }

    public IocField(String value) {
        if (value.contains(":")) {
            this.value = Iocs.convert(value, false);
        } else {
            IocValue tmp = new IocValue();
            tmp.setType("normal");
            tmp.setValue(value);
            this.value = tmp;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IocValue getValue() {
        return this.value;
    }

    public void setValue(IocValue value) {
        this.value = value;
    }

    public String toString() {
        return String.format("{%s:%s}", this.name, Json.toJson(this.value));
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public String toJson(JsonFormat jf) {
        if (!this.optional) {
            return Json.toJson(this.value, jf);
        }
        NutMap map = new NutMap();
        map.put("optional", this.optional);
        map.put(this.value.getType(), this.value.getValue());
        return Json.toJson(map, jf);
    }
}

