/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.mapstruct.ap.internal.model.ContainerMappingMethod;
import org.mapstruct.ap.internal.model.ContainerMappingMethodBuilder;
import org.mapstruct.ap.internal.model.LifecycleCallbackMethodReference;
import org.mapstruct.ap.internal.model.MethodReference;
import org.mapstruct.ap.internal.model.assignment.Java8FunctionWrapper;
import org.mapstruct.ap.internal.model.common.Assignment;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.SelectionParameters;
import org.mapstruct.ap.internal.util.Collections;

public class StreamMappingMethod
extends ContainerMappingMethod {
    private final Set<Type> helperImports;

    private StreamMappingMethod(Method method, Collection<String> existingVariables, Assignment parameterAssignment, MethodReference factoryMethod, boolean mapNullToDefault, String loopVariableName, List<LifecycleCallbackMethodReference> beforeMappingReferences, List<LifecycleCallbackMethodReference> afterMappingReferences, SelectionParameters selectionParameters, Set<Type> helperImports) {
        super(method, existingVariables, parameterAssignment, factoryMethod, mapNullToDefault, loopVariableName, beforeMappingReferences, afterMappingReferences, selectionParameters);
        this.helperImports = helperImports;
    }

    @Override
    public Set<Type> getImportTypes() {
        Set<Type> types = super.getImportTypes();
        types.addAll(this.helperImports);
        return types;
    }

    public Type getSourceElementType() {
        return StreamMappingMethod.getElementType(this.getSourceParameter().getType());
    }

    @Override
    public Type getResultElementType() {
        return StreamMappingMethod.getElementType(this.getResultType());
    }

    private static Type getElementType(Type parameterType) {
        if (parameterType.isArrayType()) {
            return parameterType.getComponentType();
        }
        if (parameterType.isIterableType()) {
            return Collections.first(parameterType.determineTypeArguments(Iterable.class)).getTypeBound();
        }
        if (parameterType.isStreamType()) {
            return Collections.first(parameterType.determineTypeArguments(Stream.class)).getTypeBound();
        }
        throw new IllegalArgumentException("Could not get the element type");
    }

    public static class Builder
    extends ContainerMappingMethodBuilder<Builder, StreamMappingMethod> {
        public Builder() {
            super(Builder.class, "stream element");
        }

        @Override
        protected Type getElementType(Type parameterType) {
            return StreamMappingMethod.getElementType(parameterType);
        }

        @Override
        protected Assignment getWrapper(Assignment assignment, Method method) {
            return new Java8FunctionWrapper(assignment);
        }

        @Override
        protected StreamMappingMethod instantiateMappingMethod(Method method, Collection<String> existingVariables, Assignment assignment, MethodReference factoryMethod, boolean mapNullToDefault, String loopVariableName, List<LifecycleCallbackMethodReference> beforeMappingMethods, List<LifecycleCallbackMethodReference> afterMappingMethods, SelectionParameters selectionParameters) {
            Type sourceParameterType;
            HashSet<Type> helperImports = new HashSet<Type>();
            if (method.getResultType().isIterableType()) {
                helperImports.add(this.ctx.getTypeFactory().getType(Collectors.class));
            }
            if (!(sourceParameterType = Collections.first(method.getSourceParameters()).getType()).isCollectionType() && !sourceParameterType.isArrayType() && sourceParameterType.isIterableType()) {
                helperImports.add(this.ctx.getTypeFactory().getType(StreamSupport.class));
            }
            return new StreamMappingMethod(method, existingVariables, assignment, factoryMethod, mapNullToDefault, loopVariableName, beforeMappingMethods, afterMappingMethods, selectionParameters, helperImports);
        }
    }
}

