/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.narayana.jta.runtime.internal.tsr;

import io.quarkus.narayana.jta.runtime.internal.tsr.TransactionSynchronizationRegistryWrapper;
import jakarta.transaction.Synchronization;
import jakarta.transaction.TransactionSynchronizationRegistry;
import java.util.ArrayList;
import java.util.List;
import org.jboss.logging.Logger;

public class AgroalOrderedLastSynchronizationList
implements Synchronization {
    private static final Logger LOGGER = Logger.getLogger(AgroalOrderedLastSynchronizationList.class);
    private static final String ADD_SYNC_ERROR = "Syncs are not allowed because the group of synchronizations to which this sync belongs has already ran";
    private static final String REGISTER_SYNC_ERROR = "Syncs are not allowed to be registered when the transaction is in state ";
    private static final String[] PKG_PREFIXES = new String[]{"", "org.hibernate", "io.agroal.narayana"};
    private final List<SynchronizationGroup> synchGroups = new ArrayList<SynchronizationGroup>();
    private SynchronizationGroup otherSynchs;
    private final TransactionSynchronizationRegistry tsr;
    private volatile Throwable deferredThrowable;

    public AgroalOrderedLastSynchronizationList(TransactionSynchronizationRegistryWrapper transactionSynchronizationRegistryWrapper) {
        this.tsr = transactionSynchronizationRegistryWrapper;
        for (String packagePrefix : PKG_PREFIXES) {
            SynchronizationGroup synchronizationGroup = new SynchronizationGroup(packagePrefix);
            this.synchGroups.add(synchronizationGroup);
            if (!packagePrefix.isEmpty()) continue;
            this.otherSynchs = synchronizationGroup;
        }
    }

    public void registerInterposedSynchronization(Synchronization synchronization) {
        int status = this.tsr.getTransactionStatus();
        switch (status) {
            case 0: 
            case 7: {
                break;
            }
            default: {
                throw new IllegalStateException(REGISTER_SYNC_ERROR + status);
            }
        }
        String packageName = synchronization.getClass().getName();
        SynchronizationGroup synchGroup = this.otherSynchs;
        for (SynchronizationGroup g : this.synchGroups) {
            if (!g.shouldAdd(packageName)) continue;
            synchGroup = g;
            break;
        }
        synchGroup.add(synchronization);
    }

    public void beforeCompletion() {
        for (SynchronizationGroup g : this.synchGroups) {
            g.beforeCompletion();
        }
        if (this.deferredThrowable != null) {
            throw new RuntimeException(this.deferredThrowable);
        }
    }

    public void afterCompletion(int status) {
        for (SynchronizationGroup g : this.synchGroups) {
            g.afterCompletion(status);
        }
    }

    private class SynchronizationGroup
    implements Synchronization {
        String packagePrefix;
        final List<Synchronization> synchs;
        volatile ExecutionStatus status;

        public SynchronizationGroup(String packagePrefix) {
            this.packagePrefix = packagePrefix;
            this.synchs = new ArrayList<Synchronization>();
            this.status = ExecutionStatus.PENDING;
        }

        public void add(Synchronization synchronization) {
            if (this.status == ExecutionStatus.FINISHED) {
                throw new IllegalStateException(AgroalOrderedLastSynchronizationList.ADD_SYNC_ERROR);
            }
            this.synchs.add(synchronization);
        }

        public void beforeCompletion() {
            this.status = ExecutionStatus.RUNNING;
            for (int i = 0; i < this.synchs.size(); ++i) {
                Synchronization sync = this.synchs.get(i);
                try {
                    sync.beforeCompletion();
                    continue;
                }
                catch (Exception e) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debugf("The synchronization %s associated with tx key %s failed during beforeCompletion: %s", (Object)sync, AgroalOrderedLastSynchronizationList.this.tsr.getTransactionKey(), (Object)e.getMessage());
                    }
                    if (AgroalOrderedLastSynchronizationList.this.deferredThrowable != null) continue;
                    AgroalOrderedLastSynchronizationList.this.deferredThrowable = e;
                }
            }
            this.status = ExecutionStatus.FINISHED;
        }

        public void afterCompletion(int status) {
            int i = this.synchs.size();
            while (i-- > 0) {
                this.synchs.get(i).afterCompletion(status);
            }
        }

        private boolean shouldAdd(String packageName) {
            return !this.packagePrefix.isEmpty() && packageName.startsWith(this.packagePrefix);
        }
    }

    private static enum ExecutionStatus {
        PENDING,
        RUNNING,
        FINISHED;

    }
}

