/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.metrics;

import java.util.Arrays;
import java.util.Random;
import org.apache.iceberg.metrics.Histogram;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public class FixedReservoirHistogram
implements Histogram {
    private final Random rand = new Random();
    private final long[] measurements;
    private int count;

    public FixedReservoirHistogram(int reservoirSize) {
        this.measurements = new long[reservoirSize];
        this.count = 0;
    }

    @Override
    public synchronized int count() {
        return this.count;
    }

    @Override
    public synchronized void update(long value) {
        int index;
        ++this.count;
        int n = index = this.count <= this.measurements.length ? this.count - 1 : this.rand.nextInt(this.count);
        if (index < this.measurements.length) {
            this.measurements[index] = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Histogram.Statistics statistics() {
        int size = (int)Math.min((long)this.count, (long)this.measurements.length);
        if (size == 0) {
            return UniformWeightStatistics.EMPTY;
        }
        long[] values = new long[size];
        FixedReservoirHistogram fixedReservoirHistogram = this;
        synchronized (fixedReservoirHistogram) {
            System.arraycopy(this.measurements, 0, values, 0, size);
        }
        double sum = 0.0;
        double sumSquares = 0.0;
        for (long x : values) {
            sum += (double)x;
            double value = x;
            sumSquares += value * value;
        }
        double mean = sum / (double)size;
        double variance = (sumSquares - sum * sum / (double)size) / (double)size;
        double stdDev = Math.sqrt(variance);
        return new UniformWeightStatistics(values, mean, stdDev);
    }

    private static class UniformWeightStatistics
    implements Histogram.Statistics {
        private static final UniformWeightStatistics EMPTY = new UniformWeightStatistics(new long[0], 0.0, 0.0);
        private final long[] values;
        private final double mean;
        private final double stdDev;

        private UniformWeightStatistics(long[] values, double mean, double stdDev) {
            this.values = values;
            this.mean = mean;
            this.stdDev = stdDev;
            Arrays.sort(this.values);
        }

        @Override
        public int size() {
            return this.values.length;
        }

        @Override
        public double mean() {
            return this.mean;
        }

        @Override
        public double stdDev() {
            return this.stdDev;
        }

        @Override
        public long max() {
            return this.values.length == 0 ? 0L : this.values[this.values.length - 1];
        }

        @Override
        public long min() {
            return this.values.length == 0 ? 0L : this.values[0];
        }

        @Override
        public long percentile(double percentile) {
            Preconditions.checkArgument((!Double.isNaN(percentile) && percentile >= 0.0 && percentile <= 1.0 ? 1 : 0) != 0, (String)"Percentile point cannot be outside the range of [0.0 - 1.0]: %s", (Object)percentile);
            if (this.values.length == 0) {
                return 0L;
            }
            double position = percentile * (double)this.values.length;
            int index = (int)position;
            if (index < 1) {
                return this.values[0];
            }
            if (index >= this.values.length) {
                return this.values[this.values.length - 1];
            }
            double lower = this.values[index - 1];
            double upper = this.values[index];
            double interpolated = lower + (position - Math.floor(position)) * (upper - lower);
            return (long)interpolated;
        }
    }
}

