/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.context.impl.wrappers;

import io.smallrye.context.CleanAutoCloseable;
import io.smallrye.context.impl.CapturedContextState;
import io.smallrye.context.impl.Contextualized;
import java.util.function.Function;

public final class SlowContextualFunction<T, R>
implements Function<T, R>,
Contextualized {
    private final CapturedContextState state;
    private final Function<T, R> function;

    public SlowContextualFunction(CapturedContextState state, Function<T, R> function) {
        this.state = state;
        this.function = function;
    }

    @Override
    public R apply(T t) {
        try (CleanAutoCloseable activeState = this.state.begin();){
            R r = this.function.apply(t);
            return r;
        }
    }
}

