/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto;

import java.security.Provider;
import java.security.Security;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.store.LogExactlyOnce;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class CryptoUtils {
    static final Logger LOG = LoggerFactory.getLogger(CryptoUtils.class);
    private static final LogExactlyOnce LOG_FAILED_TO_LOAD_CLASS = new LogExactlyOnce(LOG);
    private static final LogExactlyOnce LOG_FAILED_TO_ADD_PROVIDER = new LogExactlyOnce(LOG);
    private static final String BOUNCY_CASTLE_PROVIDER_CLASS = "org.bouncycastle.jce.provider.BouncyCastleProvider";
    static final String BOUNCY_CASTLE_PROVIDER_NAME = "BC";

    public static String getJceProvider(Configuration conf) {
        String provider = conf.getTrimmed("hadoop.security.crypto.jce.provider", "");
        boolean autoAdd = conf.getBoolean("hadoop.security.crypto.jce.provider.auto-add", true);
        if (autoAdd && BOUNCY_CASTLE_PROVIDER_NAME.equals(provider)) {
            try {
                Class<?> clazz = Class.forName(BOUNCY_CASTLE_PROVIDER_CLASS);
                Security.addProvider((Provider)clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
                LOG.debug("Successfully added security provider {}", (Object)provider);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Trace", new Throwable());
                }
            }
            catch (ClassNotFoundException e) {
                LOG_FAILED_TO_LOAD_CLASS.warn("Failed to load org.bouncycastle.jce.provider.BouncyCastleProvider", e);
            }
            catch (Exception e) {
                LOG_FAILED_TO_ADD_PROVIDER.warn("Failed to add security provider for {}", provider, e);
            }
        }
        return provider;
    }

    private CryptoUtils() {
    }
}

