/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.persistence.cache;

import com.github.benmanes.caffeine.cache.Weigher;
import org.apache.polaris.core.persistence.ResolvedPolarisEntity;
import org.checkerframework.checker.index.qual.NonNegative;

public class EntityWeigher
implements Weigher<Long, ResolvedPolarisEntity> {
    public static final long WEIGHT_PER_MB = 0x100000L;
    private static final int APPROXIMATE_ENTITY_OVERHEAD = 1000;
    private static final int APPROXIMATE_BYTES_PER_CHAR = 3;
    private static final EntityWeigher instance = new EntityWeigher();

    private EntityWeigher() {
    }

    public static EntityWeigher getInstance() {
        return instance;
    }

    public @NonNegative int weigh(Long key, ResolvedPolarisEntity value) {
        return 1000 + value.getEntity().getName().length() * 3 + value.getEntity().getProperties().length() * 3 + value.getEntity().getInternalProperties().length() * 3;
    }

    public static Weigher<Long, ResolvedPolarisEntity> asWeigher() {
        return EntityWeigher.getInstance();
    }
}

