/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.common.utils.StringUtil;

public class PropertyName {
    private final String name;
    private final int hashCode;

    public PropertyName(String name) {
        this.name = name;
        this.hashCode = this.buildHashCode();
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyName that = (PropertyName)o;
        return PropertyName.equals(this.name, that.name);
    }

    public static boolean equals(String name, String other) {
        return PropertyName.equalsInternal(name, 0, name.length(), other, 0, other.length()) || PropertyName.equalsInternal(other, 0, other.length(), name, 0, name.length());
    }

    public static boolean equals(String name, int offset, int len, String other, int ooffset, int olen) {
        return PropertyName.equalsInternal(name, offset, len, other, ooffset, olen) || PropertyName.equalsInternal(other, ooffset, olen, name, offset, len);
    }

    private static boolean equalsInternal(String name, int offset, int len, String other, int ooffset, int olen) {
        if (name == other) {
            return true;
        }
        if (name.equals("*") && (other.isEmpty() || other.equals("\"\""))) {
            return false;
        }
        int matchPosition = offset + len - 1;
        for (int i = ooffset + olen - 1; i >= ooffset; --i) {
            if (matchPosition == -1) {
                return false;
            }
            char o = other.charAt(i);
            char n = name.charAt(matchPosition);
            if (n == '*') {
                if (o == ']') {
                    return false;
                }
                if (o == '\"') {
                    int beginQuote = other.lastIndexOf(34, i - 1);
                    if (beginQuote != -1) {
                        i = beginQuote;
                    }
                } else {
                    int previousDot = other.lastIndexOf(46, i);
                    i = previousDot != -1 ? previousDot + 1 : 0;
                }
            } else {
                if (o == ']' && n == ']') {
                    int otherBeginIndexed = other.lastIndexOf(91, i);
                    int nameBeginIndexed = name.lastIndexOf(91, matchPosition);
                    if (otherBeginIndexed != -1 && nameBeginIndexed != -1) {
                        if (other.charAt(otherBeginIndexed + 1) == '*' && name.charAt(nameBeginIndexed + 1) == '*') {
                            i -= 2;
                            matchPosition -= 3;
                            continue;
                        }
                        if (other.charAt(otherBeginIndexed + 1) == '*' && StringUtil.isNumeric((CharSequence)name, (int)(nameBeginIndexed + 1), (int)(matchPosition - nameBeginIndexed - 1))) {
                            i -= 2;
                            matchPosition = nameBeginIndexed - 1;
                            continue;
                        }
                        if (name.charAt(nameBeginIndexed + 1) == '*' && StringUtil.isNumeric((CharSequence)other, (int)(otherBeginIndexed + 1), (int)(i - otherBeginIndexed - 1))) {
                            i = otherBeginIndexed;
                            matchPosition -= 3;
                            continue;
                        }
                        if (StringUtil.isNumericEquals((CharSequence)name, (int)(nameBeginIndexed + 1), (int)(matchPosition - nameBeginIndexed - 1), (CharSequence)other, (int)(otherBeginIndexed + 1), (int)(i - otherBeginIndexed - 1))) {
                            i = otherBeginIndexed;
                            matchPosition = nameBeginIndexed - 1;
                            continue;
                        }
                    }
                    return false;
                }
                if (o != n) {
                    return false;
                }
            }
            --matchPosition;
        }
        return matchPosition < offset;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int buildHashCode() {
        int h = 0;
        int length = this.name.length();
        boolean quotesOpen = false;
        for (int i = 0; i < length; ++i) {
            char c = this.name.charAt(i);
            if (quotesOpen) {
                if (c != '\"') continue;
                quotesOpen = false;
                continue;
            }
            if (c == '\"') {
                quotesOpen = true;
                continue;
            }
            if (c != '.' && c != '[' && c != ']') continue;
            h = 31 * h + c;
        }
        return h;
    }

    public String toString() {
        return this.name;
    }

    public static PropertyName name(String name) {
        return new PropertyName(name);
    }

    public static PropertyName unprofiled(String name) {
        if (!name.isEmpty() && name.charAt(0) == '%') {
            int profilesEnd = name.indexOf(46, 1);
            return new PropertyName(profilesEnd == -1 ? name : name.substring(profilesEnd + 1));
        }
        return new PropertyName(name);
    }
}

