/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.ExecutionStatus;
import software.amazon.awssdk.services.cloudwatchlogs.model.ExecutionStatusListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetScheduledQueryHistoryRequest
extends CloudWatchLogsRequest
implements ToCopyableBuilder<Builder, GetScheduledQueryHistoryRequest> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identifier").getter(GetScheduledQueryHistoryRequest.getter(GetScheduledQueryHistoryRequest::identifier)).setter(GetScheduledQueryHistoryRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()}).build();
    private static final SdkField<Long> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("startTime").getter(GetScheduledQueryHistoryRequest.getter(GetScheduledQueryHistoryRequest::startTime)).setter(GetScheduledQueryHistoryRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Long> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("endTime").getter(GetScheduledQueryHistoryRequest.getter(GetScheduledQueryHistoryRequest::endTime)).setter(GetScheduledQueryHistoryRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<List<String>> EXECUTION_STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("executionStatuses").getter(GetScheduledQueryHistoryRequest.getter(GetScheduledQueryHistoryRequest::executionStatusesAsStrings)).setter(GetScheduledQueryHistoryRequest.setter(Builder::executionStatusesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionStatuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(GetScheduledQueryHistoryRequest.getter(GetScheduledQueryHistoryRequest::maxResults)).setter(GetScheduledQueryHistoryRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetScheduledQueryHistoryRequest.getter(GetScheduledQueryHistoryRequest::nextToken)).setter(GetScheduledQueryHistoryRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD, START_TIME_FIELD, END_TIME_FIELD, EXECUTION_STATUSES_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetScheduledQueryHistoryRequest.memberNameToFieldInitializer();
    private final String identifier;
    private final Long startTime;
    private final Long endTime;
    private final List<String> executionStatuses;
    private final Integer maxResults;
    private final String nextToken;

    private GetScheduledQueryHistoryRequest(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.executionStatuses = builder.executionStatuses;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final Long startTime() {
        return this.startTime;
    }

    public final Long endTime() {
        return this.endTime;
    }

    public final List<ExecutionStatus> executionStatuses() {
        return ExecutionStatusListCopier.copyStringToEnum(this.executionStatuses);
    }

    public final boolean hasExecutionStatuses() {
        return this.executionStatuses != null && !(this.executionStatuses instanceof SdkAutoConstructList);
    }

    public final List<String> executionStatusesAsStrings() {
        return this.executionStatuses;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExecutionStatuses() ? this.executionStatusesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetScheduledQueryHistoryRequest)) {
            return false;
        }
        GetScheduledQueryHistoryRequest other = (GetScheduledQueryHistoryRequest)((Object)obj);
        return Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && this.hasExecutionStatuses() == other.hasExecutionStatuses() && Objects.equals(this.executionStatusesAsStrings(), other.executionStatusesAsStrings()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetScheduledQueryHistoryRequest").add("Identifier", (Object)this.identifier()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("ExecutionStatuses", this.hasExecutionStatuses() ? this.executionStatusesAsStrings() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "executionStatuses": {
                return Optional.ofNullable(clazz.cast(this.executionStatusesAsStrings()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("identifier", IDENTIFIER_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("executionStatuses", EXECUTION_STATUSES_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetScheduledQueryHistoryRequest, T> g) {
        return obj -> g.apply((GetScheduledQueryHistoryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsRequest.BuilderImpl
    implements Builder {
        private String identifier;
        private Long startTime;
        private Long endTime;
        private List<String> executionStatuses = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetScheduledQueryHistoryRequest model) {
            super(model);
            this.identifier(model.identifier);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.executionStatusesWithStrings(model.executionStatuses);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final Long getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Long startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Long startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Long getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Long endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Long endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Collection<String> getExecutionStatuses() {
            if (this.executionStatuses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.executionStatuses;
        }

        public final void setExecutionStatuses(Collection<String> executionStatuses) {
            this.executionStatuses = ExecutionStatusListCopier.copy(executionStatuses);
        }

        @Override
        public final Builder executionStatusesWithStrings(Collection<String> executionStatuses) {
            this.executionStatuses = ExecutionStatusListCopier.copy(executionStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executionStatusesWithStrings(String ... executionStatuses) {
            this.executionStatusesWithStrings(Arrays.asList(executionStatuses));
            return this;
        }

        @Override
        public final Builder executionStatuses(Collection<ExecutionStatus> executionStatuses) {
            this.executionStatuses = ExecutionStatusListCopier.copyEnumToString(executionStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executionStatuses(ExecutionStatus ... executionStatuses) {
            this.executionStatuses(Arrays.asList(executionStatuses));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetScheduledQueryHistoryRequest build() {
            return new GetScheduledQueryHistoryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudWatchLogsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetScheduledQueryHistoryRequest> {
        public Builder identifier(String var1);

        public Builder startTime(Long var1);

        public Builder endTime(Long var1);

        public Builder executionStatusesWithStrings(Collection<String> var1);

        public Builder executionStatusesWithStrings(String ... var1);

        public Builder executionStatuses(Collection<ExecutionStatus> var1);

        public Builder executionStatuses(ExecutionStatus ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

