/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jdbc.postgresql.runtime.graal;

import io.quarkus.jdbc.postgresql.runtime.graal.UncheckedSQLException;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.function.BiFunction;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.graalvm.nativeimage.ImageSingletons;
import org.postgresql.core.BaseConnection;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.xml.DefaultPGXmlFactoryFactory;
import org.postgresql.xml.PGXmlFactoryFactory;

final class DomHelper {
    private BiFunction<DOMResult, BaseConnection, String> processDomResult;

    DomHelper() {
    }

    public static String processDomResult(DOMResult domResult, BaseConnection conn) throws SQLException {
        BiFunction<DOMResult, BaseConnection, String> func = ((DomHelper)ImageSingletons.lookup(DomHelper.class)).processDomResult;
        if (func == null) {
            return null;
        }
        try {
            return func.apply(domResult, conn);
        }
        catch (UncheckedSQLException e) {
            throw (SQLException)e.getCause();
        }
    }

    static void enableXmlProcessing() {
        ((DomHelper)ImageSingletons.lookup(DomHelper.class)).processDomResult = DomHelper::doProcessDomResult;
    }

    public static String doProcessDomResult(DOMResult domResult, BaseConnection conn) {
        try {
            return DomHelper.reallyProcessDomResult(domResult, conn);
        }
        catch (SQLException e) {
            throw new UncheckedSQLException(e);
        }
    }

    public static String reallyProcessDomResult(DOMResult domResult, BaseConnection conn) throws SQLException {
        TransformerFactory factory = DomHelper.getXmlFactoryFactory(conn).newTransformerFactory();
        try {
            Transformer transformer = factory.newTransformer();
            DOMSource domSource = new DOMSource(domResult.getNode());
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            transformer.transform(domSource, streamResult);
            return stringWriter.toString();
        }
        catch (TransformerException te) {
            throw new PSQLException(GT.tr((String)"Unable to convert DOMResult SQLXML data to a string.", (Object[])new Object[0]), PSQLState.DATA_ERROR, (Throwable)te);
        }
    }

    private static PGXmlFactoryFactory getXmlFactoryFactory(BaseConnection conn) throws SQLException {
        if (conn != null) {
            return conn.getXmlFactoryFactory();
        }
        return DefaultPGXmlFactoryFactory.INSTANCE;
    }
}

