/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.ConfigValue;
import io.smallrye.config.Secret;
import io.smallrye.config.SecuritySupport;
import io.smallrye.config._private.ConfigLogging;
import io.smallrye.config._private.ConfigMessages;
import io.smallrye.config.common.AbstractConverter;
import io.smallrye.config.common.AbstractDelegatingConverter;
import io.smallrye.config.common.AbstractSimpleDelegatingConverter;
import io.smallrye.config.common.utils.StringUtil;
import java.io.File;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Currency;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.UUID;
import java.util.function.IntFunction;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.spi.Converter;

public final class Converters {
    static final Converter<ConfigValue> CONFIG_VALUE_CONVERTER = new ConfigValueConverter();
    static final Converter<String> STRING_CONVERTER = BuiltInConverter.of(0, Converters.newEmptyValueConverter((Converter & Serializable)value -> value));
    static final Converter<Boolean> BOOLEAN_CONVERTER = BuiltInConverter.of(1, Converters.newTrimmingConverter(Converters.newEmptyValueConverter(new Converter<Boolean>(){

        public Boolean convert(String value) throws IllegalArgumentException, NullPointerException {
            if ("TRUE".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value) || "YES".equalsIgnoreCase(value) || "Y".equalsIgnoreCase(value) || "ON".equalsIgnoreCase(value) || "JA".equalsIgnoreCase(value) || "J".equalsIgnoreCase(value) || "SI".equalsIgnoreCase(value) || "SIM".equalsIgnoreCase(value) || "OUI".equalsIgnoreCase(value)) {
                return Boolean.TRUE;
            }
            if ("FALSE".equalsIgnoreCase(value) || "0".equalsIgnoreCase(value) || "NO".equalsIgnoreCase(value) || "N".equalsIgnoreCase(value) || "OFF".equalsIgnoreCase(value) || "NEIN".equalsIgnoreCase(value) || "N\u00c3O".equalsIgnoreCase(value) || "NON".equalsIgnoreCase(value)) {
                return Boolean.FALSE;
            }
            ConfigLogging.log.booleanConversionFalse(value);
            return Boolean.FALSE;
        }
    })));
    static final Converter<Double> DOUBLE_CONVERTER = BuiltInConverter.of(2, Converters.newTrimmingConverter(Converters.newEmptyValueConverter((Converter & Serializable)value -> {
        try {
            return Double.valueOf(value);
        }
        catch (NumberFormatException nfe) {
            throw ConfigMessages.msg.doubleExpected(value);
        }
    })));
    static final Converter<Float> FLOAT_CONVERTER = BuiltInConverter.of(3, Converters.newTrimmingConverter(Converters.newEmptyValueConverter((Converter & Serializable)value -> {
        try {
            return Float.valueOf(value);
        }
        catch (NumberFormatException nfe) {
            throw ConfigMessages.msg.floatExpected(value);
        }
    })));
    static final Converter<Long> LONG_CONVERTER = BuiltInConverter.of(4, Converters.newTrimmingConverter(Converters.newEmptyValueConverter((Converter & Serializable)value -> {
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException nfe) {
            throw ConfigMessages.msg.longExpected(value);
        }
    })));
    static final Converter<Integer> INTEGER_CONVERTER = BuiltInConverter.of(5, Converters.newTrimmingConverter(Converters.newEmptyValueConverter((Converter & Serializable)value -> {
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException nfe) {
            throw ConfigMessages.msg.integerExpected(value);
        }
    })));
    static final Converter<Class<?>> CLASS_CONVERTER = BuiltInConverter.of(6, Converters.newTrimmingConverter(Converters.newEmptyValueConverter((Converter & Serializable)value -> {
        try {
            return Class.forName(value, true, SecuritySupport.getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw ConfigMessages.msg.classConverterNotFound(e, value);
        }
    })));
    static final Converter<OptionalInt> OPTIONAL_INT_CONVERTER = BuiltInConverter.of(7, Converters.newOptionalIntConverter(INTEGER_CONVERTER));
    static final Converter<OptionalLong> OPTIONAL_LONG_CONVERTER = BuiltInConverter.of(8, Converters.newOptionalLongConverter(LONG_CONVERTER));
    static final Converter<OptionalDouble> OPTIONAL_DOUBLE_CONVERTER = BuiltInConverter.of(9, Converters.newOptionalDoubleConverter(DOUBLE_CONVERTER));
    static final Converter<InetAddress> INET_ADDRESS_CONVERTER = BuiltInConverter.of(10, Converters.newTrimmingConverter(Converters.newEmptyValueConverter((Converter & Serializable)value -> {
        try {
            return InetAddress.getByName(value);
        }
        catch (UnknownHostException e) {
            throw ConfigMessages.msg.unknownHost(e, value);
        }
    })));
    static final Converter<Character> CHARACTER_CONVERTER = BuiltInConverter.of(11, Converters.newEmptyValueConverter((Converter & Serializable)value -> {
        if (value.length() == 1) {
            return Character.valueOf(value.charAt(0));
        }
        throw ConfigMessages.msg.failedCharacterConversion(value);
    }));
    static final Converter<Short> SHORT_CONVERTER = BuiltInConverter.of(12, Converters.newTrimmingConverter(Converters.newEmptyValueConverter(Short::valueOf)));
    static final Converter<Byte> BYTE_CONVERTER = BuiltInConverter.of(13, Converters.newTrimmingConverter(Converters.newEmptyValueConverter(Byte::valueOf)));
    static final Converter<UUID> UUID_CONVERTER = BuiltInConverter.of(14, Converters.newTrimmingConverter(Converters.newEmptyValueConverter((Converter & Serializable)s -> {
        try {
            return UUID.fromString(s);
        }
        catch (IllegalArgumentException e) {
            throw ConfigMessages.msg.malformedUUID(e, s);
        }
    })));
    static final Converter<Currency> CURRENCY_CONVERTER = BuiltInConverter.of(15, Converters.newTrimmingConverter(Converters.newEmptyValueConverter((Converter & Serializable)s -> Currency.getInstance(s))));
    static final Converter<BitSet> BITSET_CONVERTER = BuiltInConverter.of(16, Converters.newTrimmingConverter(Converters.newTrimmingConverter((Converter & Serializable)s -> {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return BitSet.valueOf(data);
    })));
    static final Converter<Pattern> PATTERN_CONVERTER = BuiltInConverter.of(17, Converters.newTrimmingConverter(Converters.newEmptyValueConverter(Pattern::compile)));
    static final Converter<Path> PATH_CONVERTER = BuiltInConverter.of(18, Converters.newEmptyValueConverter((Converter & Serializable)x$0 -> Path.of(x$0, new String[0])));
    static final Converter<File> FILE_CONVERTER = BuiltInConverter.of(19, Converters.newEmptyValueConverter(File::new));
    static final Converter<URI> URI_CONVERTER = BuiltInConverter.of(20, Converters.newTrimmingConverter(Converters.newEmptyValueConverter(URI::create)));
    static final Converter<DateTimeFormatter> DATE_TIME_FORMATTER_CONVERTER = BuiltInConverter.of(21, Converters.newTrimmingConverter(Converters.newEmptyValueConverter(DateTimeFormatter::ofPattern)));
    static final Converter<CharSequence> CHAR_SEQUENCE_CONVERTER = BuiltInConverter.of(22, Converters.newTrimmingConverter(Converters.newEmptyValueConverter(Object::toString)));
    static final Map<Class<?>, Class<?>> PRIMITIVE_TYPES;
    static final Map<Type, Converter<?>> ALL_CONVERTERS;

    private Converters() {
        throw new UnsupportedOperationException();
    }

    static Class<?> wrapPrimitiveType(Class<?> primitiveType) {
        assert (primitiveType.isPrimitive());
        return PRIMITIVE_TYPES.get(primitiveType);
    }

    public static Type getConverterType(Class<?> clazz) {
        if (clazz.equals(Object.class)) {
            return null;
        }
        for (Type type : clazz.getGenericInterfaces()) {
            ParameterizedType pt;
            if (!(type instanceof ParameterizedType) || !(pt = (ParameterizedType)type).getRawType().equals(Converter.class)) continue;
            Type[] typeArguments = pt.getActualTypeArguments();
            if (typeArguments.length != 1) {
                throw ConfigMessages.msg.singleTypeConverter(clazz.getName());
            }
            return typeArguments[0];
        }
        return Converters.getConverterType(clazz.getSuperclass());
    }

    public static <T> Converter<T> getImplicitConverter(Class<? extends T> type) {
        return ALL_CONVERTERS.getOrDefault(type, Implicit.getConverter(type));
    }

    public static <T, C extends Collection<T>> Converter<C> newCollectionConverter(Converter<? extends T> itemConverter, IntFunction<C> collectionFactory) {
        return new CollectionConverter<T, C>(itemConverter, collectionFactory);
    }

    public static <A, T> Converter<A> newArrayConverter(Converter<? extends T> itemConverter, Class<A> arrayType) {
        if (!arrayType.isArray()) {
            throw ConfigMessages.msg.notArrayType(arrayType.toString());
        }
        return new ArrayConverter<T, A>(itemConverter, arrayType);
    }

    public static <K, V> Converter<Map<K, V>> newMapConverter(Converter<? extends K> keyConverter, Converter<? extends V> valueConverter, IntFunction<Map<K, V>> mapFactory) {
        return new MapConverter<K, V>(keyConverter, valueConverter, mapFactory);
    }

    public static <T> Converter<Optional<T>> newOptionalConverter(Converter<? extends T> delegateConverter) {
        return new OptionalConverter<T>(delegateConverter);
    }

    public static Converter<OptionalInt> newOptionalIntConverter(Converter<Integer> delegateConverter) {
        return new OptionalIntConverter(delegateConverter);
    }

    public static Converter<OptionalLong> newOptionalLongConverter(Converter<Long> delegateConverter) {
        return new OptionalLongConverter(delegateConverter);
    }

    public static Converter<OptionalDouble> newOptionalDoubleConverter(Converter<Double> delegateConverter) {
        return new OptionalDoubleConverter(delegateConverter);
    }

    public static <T> Converter<Secret<T>> newSecretConverter(Converter<T> delegateConverter) {
        return new SecretConverter<T>(delegateConverter);
    }

    public static <T> Converter<T> newEmptyValueConverter(Converter<T> delegateConverter, T emptyValue) {
        if (emptyValue == null) {
            return delegateConverter;
        }
        return new EmptyValueConverter<T>(delegateConverter, emptyValue);
    }

    public static <T> Converter<T> newEmptyValueConverter(Converter<T> delegateConverter) {
        return new EmptyValueConverter<Object>(delegateConverter, null);
    }

    public static <T> Converter<T> newTrimmingConverter(Converter<T> delegateConverter) {
        return new TrimmingConverter<T>(delegateConverter);
    }

    public static <T extends Comparable<T>> Converter<T> minimumValueConverter(Converter<? extends T> delegate, T minimumValue, boolean inclusive) {
        return new RangeCheckConverter<Object>(Comparator.naturalOrder(), (Converter<Object>)delegate, minimumValue, inclusive, null, false);
    }

    public static <T> Converter<T> minimumValueConverter(Comparator<? super T> comparator, Converter<? extends T> delegate, T minimumValue, boolean inclusive) {
        return new RangeCheckConverter<Object>((Comparator<Object>)comparator, (Converter<Object>)delegate, minimumValue, inclusive, null, false);
    }

    public static <T extends Comparable<T>> Converter<T> minimumValueStringConverter(Converter<? extends T> delegate, String minimumValue, boolean inclusive) {
        return Converters.minimumValueConverter(delegate, (Comparable)delegate.convert(minimumValue), inclusive);
    }

    public static <T> Converter<T> minimumValueStringConverter(Comparator<? super T> comparator, Converter<? extends T> delegate, String minimumValue, boolean inclusive) {
        return Converters.minimumValueConverter(comparator, delegate, delegate.convert(minimumValue), inclusive);
    }

    public static <T extends Comparable<T>> Converter<T> maximumValueConverter(Converter<? extends T> delegate, T maximumValue, boolean inclusive) {
        return new RangeCheckConverter<Object>(Comparator.naturalOrder(), (Converter<Object>)delegate, null, false, maximumValue, inclusive);
    }

    public static <T> Converter<T> maximumValueConverter(Comparator<? super T> comparator, Converter<? extends T> delegate, T maximumValue, boolean inclusive) {
        return new RangeCheckConverter<Object>((Comparator<Object>)comparator, (Converter<Object>)delegate, null, false, maximumValue, inclusive);
    }

    public static <T extends Comparable<T>> Converter<T> maximumValueStringConverter(Converter<? extends T> delegate, String maximumValue, boolean inclusive) {
        return Converters.maximumValueConverter(delegate, (Comparable)delegate.convert(maximumValue), inclusive);
    }

    public static <T> Converter<T> maximumValueStringConverter(Comparator<? super T> comparator, Converter<? extends T> delegate, String maximumValue, boolean inclusive) {
        return Converters.maximumValueConverter(comparator, delegate, delegate.convert(maximumValue), inclusive);
    }

    public static <T extends Comparable<T>> Converter<T> rangeValueConverter(Converter<? extends T> delegate, T minimumValue, boolean minInclusive, T maximumValue, boolean maxInclusive) {
        return new RangeCheckConverter<T>(Comparator.naturalOrder(), delegate, minimumValue, minInclusive, maximumValue, maxInclusive);
    }

    public static <T> Converter<T> rangeValueConverter(Comparator<? super T> comparator, Converter<? extends T> delegate, T minimumValue, boolean minInclusive, T maximumValue, boolean maxInclusive) {
        return new RangeCheckConverter<T>(comparator, delegate, minimumValue, minInclusive, maximumValue, maxInclusive);
    }

    public static <T extends Comparable<T>> Converter<T> rangeValueStringConverter(Converter<? extends T> delegate, String minimumValue, boolean minInclusive, String maximumValue, boolean maxInclusive) {
        return Converters.rangeValueConverter(delegate, (Comparable)delegate.convert(minimumValue), minInclusive, (Comparable)delegate.convert(maximumValue), maxInclusive);
    }

    public static <T> Converter<T> rangeValueStringConverter(Comparator<? super T> comparator, Converter<? extends T> delegate, String minimumValue, boolean minInclusive, String maximumValue, boolean maxInclusive) {
        return Converters.rangeValueConverter(comparator, delegate, delegate.convert(minimumValue), minInclusive, delegate.convert(maximumValue), maxInclusive);
    }

    public static <T> Converter<T> patternValidatingConverter(Converter<? extends T> delegate, Pattern pattern) {
        return new PatternCheckConverter<T>(delegate, pattern);
    }

    public static <T> Converter<T> patternValidatingConverter(Converter<? extends T> delegate, String pattern) {
        return Converters.patternValidatingConverter(delegate, Pattern.compile(pattern));
    }

    static <T> boolean isOptionalConverter(Converter<T> converter) {
        return converter instanceof OptionalConverter || converter.equals(OPTIONAL_INT_CONVERTER) || converter.equals(OPTIONAL_LONG_CONVERTER) || converter.equals(OPTIONAL_DOUBLE_CONVERTER);
    }

    static {
        ALL_CONVERTERS = new HashMap();
        ALL_CONVERTERS.put((Type)((Object)String.class), STRING_CONVERTER);
        ALL_CONVERTERS.put((Type)((Object)Boolean.class), BOOLEAN_CONVERTER);
        ALL_CONVERTERS.put((Type)((Object)Double.class), DOUBLE_CONVERTER);
        ALL_CONVERTERS.put((Type)((Object)Float.class), FLOAT_CONVERTER);
        ALL_CONVERTERS.put((Type)((Object)Long.class), LONG_CONVERTER);
        ALL_CONVERTERS.put((Type)((Object)Integer.class), INTEGER_CONVERTER);
        ALL_CONVERTERS.put((Type)((Object)Short.class), SHORT_CONVERTER);
        ALL_CONVERTERS.put((Type)((Object)Class.class), CLASS_CONVERTER);
        ALL_CONVERTERS.put((Type)((Object)InetAddress.class), INET_ADDRESS_CONVERTER);
        ALL_CONVERTERS.put((Type)((Object)OptionalInt.class), OPTIONAL_INT_CONVERTER);
        ALL_CONVERTERS.put((Type)((Object)OptionalLong.class), OPTIONAL_LONG_CONVERTER);
        ALL_CONVERTERS.put((Type)((Object)OptionalDouble.class), OPTIONAL_DOUBLE_CONVERTER);
        ALL_CONVERTERS.put((Type)((Object)Character.class), CHARACTER_CONVERTER);
        ALL_CONVERTERS.put((Type)((Object)Byte.class), BYTE_CONVERTER);
        ALL_CONVERTERS.put((Type)((Object)UUID.class), UUID_CONVERTER);
        ALL_CONVERTERS.put((Type)((Object)Currency.class), CURRENCY_CONVERTER);
        ALL_CONVERTERS.put((Type)((Object)BitSet.class), BITSET_CONVERTER);
        ALL_CONVERTERS.put((Type)((Object)Pattern.class), PATTERN_CONVERTER);
        ALL_CONVERTERS.put((Type)((Object)Path.class), PATH_CONVERTER);
        ALL_CONVERTERS.put((Type)((Object)File.class), FILE_CONVERTER);
        ALL_CONVERTERS.put((Type)((Object)URI.class), URI_CONVERTER);
        ALL_CONVERTERS.put((Type)((Object)DateTimeFormatter.class), DATE_TIME_FORMATTER_CONVERTER);
        ALL_CONVERTERS.put((Type)((Object)CharSequence.class), CHAR_SEQUENCE_CONVERTER);
        HashMap primitiveTypes = new HashMap(9);
        primitiveTypes.put(Byte.TYPE, Byte.class);
        primitiveTypes.put(Short.TYPE, Short.class);
        primitiveTypes.put(Integer.TYPE, Integer.class);
        primitiveTypes.put(Long.TYPE, Long.class);
        primitiveTypes.put(Float.TYPE, Float.class);
        primitiveTypes.put(Double.TYPE, Double.class);
        primitiveTypes.put(Character.TYPE, Character.class);
        primitiveTypes.put(Boolean.TYPE, Boolean.class);
        primitiveTypes.put(Void.TYPE, Void.class);
        PRIMITIVE_TYPES = primitiveTypes;
    }

    static class Implicit {
        Implicit() {
        }

        static <T> Converter<T> getConverter(Class<? extends T> clazz) {
            if (clazz.isEnum()) {
                return new HyphenateEnumConverter<T>(clazz);
            }
            Converter<? extends T> converter = Implicit.getConverterFromStaticMethod(clazz, "of", String.class);
            if (converter == null && (converter = Implicit.getConverterFromStaticMethod(clazz, "of", CharSequence.class)) == null && (converter = Implicit.getConverterFromStaticMethod(clazz, "valueOf", String.class)) == null && (converter = Implicit.getConverterFromStaticMethod(clazz, "valueOf", CharSequence.class)) == null && (converter = Implicit.getConverterFromStaticMethod(clazz, "parse", String.class)) == null && (converter = Implicit.getConverterFromStaticMethod(clazz, "parse", CharSequence.class)) == null && (converter = Implicit.getConverterFromConstructor(clazz, String.class)) == null) {
                converter = Implicit.getConverterFromConstructor(clazz, CharSequence.class);
            }
            return converter;
        }

        private static <T> Converter<T> getConverterFromConstructor(Class<? extends T> clazz, Class<? super String> paramType) {
            try {
                Constructor<? extends T> declaredConstructor = SecuritySupport.getDeclaredConstructor(clazz, paramType);
                if (!Implicit.isAccessible(declaredConstructor)) {
                    SecuritySupport.setAccessible(declaredConstructor, true);
                }
                return new ConstructorConverter<T>(declaredConstructor);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }

        private static <T> Converter<T> getConverterFromStaticMethod(Class<? extends T> clazz, String methodName, Class<? super String> paramType) {
            try {
                Method method = clazz.getMethod(methodName, paramType);
                if (clazz != method.getReturnType()) {
                    return null;
                }
                if (!Modifier.isStatic(method.getModifiers())) {
                    return null;
                }
                if (!Implicit.isAccessible(method)) {
                    SecuritySupport.setAccessible(method, true);
                }
                return new StaticMethodConverter<T>(clazz, method);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }

        private static boolean isAccessible(Executable e) {
            return Modifier.isPublic(e.getModifiers()) && Modifier.isPublic(e.getDeclaringClass().getModifiers()) || e.isAccessible();
        }

        static class HyphenateEnumConverter<E extends Enum<E>>
        implements Converter<E>,
        Serializable {
            private static final long serialVersionUID = -8298320652413719873L;
            private final Class<E> enumType;
            private final Map<String, E> values = new HashMap<String, E>();

            public HyphenateEnumConverter(Class<E> enumType) {
                this.enumType = enumType;
                for (Enum enumValue : (Enum[])this.enumType.getEnumConstants()) {
                    this.values.put(HyphenateEnumConverter.hyphenate(enumValue.name()), enumValue);
                }
            }

            public E convert(String value) throws IllegalArgumentException, NullPointerException {
                String trimmedValue = value.trim();
                if (trimmedValue.isEmpty()) {
                    return null;
                }
                String hyphenatedValue = HyphenateEnumConverter.hyphenate(trimmedValue);
                Enum enumValue = (Enum)this.values.get(hyphenatedValue);
                if (enumValue != null) {
                    return (E)((Enum)this.enumType.cast(enumValue));
                }
                throw ConfigMessages.msg.cannotConvertEnum(value, this.enumType, String.join((CharSequence)",", this.values.keySet()));
            }

            private static String hyphenate(String value) {
                return StringUtil.skewer((String)value);
            }
        }

        static class ConstructorConverter<T>
        implements Converter<T>,
        Serializable {
            private static final long serialVersionUID = 3350265927359848883L;
            private final Constructor<? extends T> ctor;

            public ConstructorConverter(Constructor<? extends T> ctor) {
                this.ctor = ctor;
            }

            public T convert(String value) {
                if (value.isEmpty()) {
                    return null;
                }
                try {
                    return this.ctor.newInstance(value);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw ConfigMessages.msg.constructorConverterFailure(e);
                }
            }

            Object writeReplace() {
                return new Serialized(this.ctor.getDeclaringClass(), this.ctor.getParameterTypes()[0]);
            }

            static final class Serialized
            implements Serializable {
                private static final long serialVersionUID = -2903564775826815453L;
                private final Class<?> c;
                private final Class<?> p;

                Serialized(Class<?> c, Class<?> p) {
                    this.c = c;
                    this.p = p;
                }

                Object readResolve() throws ObjectStreamException {
                    return Implicit.getConverter(this.c);
                }
            }
        }

        static class StaticMethodConverter<T>
        implements Converter<T>,
        Serializable {
            private static final long serialVersionUID = 3350265927359848883L;
            private final Class<? extends T> clazz;
            private final Method method;

            StaticMethodConverter(Class<? extends T> clazz, Method method) {
                assert (clazz == method.getReturnType());
                this.clazz = clazz;
                this.method = method;
            }

            public T convert(String value) {
                if (value.isEmpty()) {
                    return null;
                }
                try {
                    return this.clazz.cast(this.method.invoke(null, value));
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw ConfigMessages.msg.staticMethodConverterFailure(e);
                }
            }

            Object writeReplace() {
                return new Serialized(this.method.getDeclaringClass(), this.method.getName(), this.method.getParameterTypes()[0]);
            }

            static final class Serialized
            implements Serializable {
                private static final long serialVersionUID = -6334004040897615452L;
                private final Class<?> c;
                private final String m;
                private final Class<?> p;

                Serialized(Class<?> c, String m, Class<?> p) {
                    this.c = c;
                    this.m = m;
                    this.p = p;
                }

                Object readResolve() throws ObjectStreamException {
                    return Implicit.getConverter(this.c);
                }
            }
        }
    }

    static final class CollectionConverter<T, C extends Collection<T>>
    extends AbstractDelegatingConverter<T, C> {
        private static final long serialVersionUID = -8452214026800305628L;
        private final IntFunction<C> collectionFactory;

        CollectionConverter(Converter<? extends T> delegate, IntFunction<C> collectionFactory) {
            super(delegate);
            this.collectionFactory = collectionFactory;
        }

        Converter<C> create(Converter<? extends T> newDelegate) {
            return new CollectionConverter<T, C>(newDelegate, this.collectionFactory);
        }

        public C convert(String str) {
            if (str.isEmpty()) {
                return null;
            }
            String[] itemStrings = StringUtil.split((String)str);
            Collection collection = (Collection)this.collectionFactory.apply(itemStrings.length);
            for (String itemString : itemStrings) {
                Object item;
                if (itemString.isEmpty() || (item = this.getDelegate().convert(itemString)) == null) continue;
                collection.add(item);
            }
            return (C)(collection.isEmpty() ? null : collection);
        }
    }

    static final class ArrayConverter<T, A>
    extends AbstractDelegatingConverter<T, A> {
        private static final long serialVersionUID = 2630282286159527380L;
        private final Class<A> arrayType;

        ArrayConverter(Converter<? extends T> delegate, Class<A> arrayType) {
            super(delegate);
            this.arrayType = arrayType;
        }

        ArrayConverter<T, A> create(Converter<? extends T> newDelegate) {
            return new ArrayConverter<T, A>(newDelegate, this.arrayType);
        }

        public A convert(String str) {
            if (str.isEmpty()) {
                return null;
            }
            String[] itemStrings = StringUtil.split((String)str);
            A array = this.arrayType.cast(Array.newInstance(this.arrayType.getComponentType(), itemStrings.length));
            int size = 0;
            for (String itemString : itemStrings) {
                Object item;
                if (itemString.isEmpty() || (item = this.getDelegate().convert(itemString)) == null) continue;
                Array.set(array, size++, item);
            }
            return size == 0 ? null : (size < itemStrings.length ? (A)ArrayConverter.copyArray(array, this.arrayType, size) : (A)array);
        }

        private static <A> A copyArray(A array, Class<A> arrayType, int newSize) {
            if (array instanceof Object[]) {
                return arrayType.cast(Arrays.copyOf((Object[])array, newSize));
            }
            if (array instanceof boolean[]) {
                return arrayType.cast(Arrays.copyOf((boolean[])array, newSize));
            }
            if (array instanceof char[]) {
                return arrayType.cast(Arrays.copyOf((char[])array, newSize));
            }
            if (array instanceof byte[]) {
                return arrayType.cast(Arrays.copyOf((byte[])array, newSize));
            }
            if (array instanceof short[]) {
                return arrayType.cast(Arrays.copyOf((short[])array, newSize));
            }
            if (array instanceof int[]) {
                return arrayType.cast(Arrays.copyOf((int[])array, newSize));
            }
            if (array instanceof long[]) {
                return arrayType.cast(Arrays.copyOf((long[])array, newSize));
            }
            if (array instanceof float[]) {
                return arrayType.cast(Arrays.copyOf((float[])array, newSize));
            }
            if (array instanceof double[]) {
                return arrayType.cast(Arrays.copyOf((double[])array, newSize));
            }
            throw ConfigMessages.msg.unknownArrayType();
        }
    }

    static class MapConverter<K, V>
    extends AbstractConverter<Map<K, V>> {
        private static final long serialVersionUID = 4343545736186221103L;
        private final Converter<? extends K> keyConverter;
        private final Converter<? extends V> valueConverter;
        private final IntFunction<Map<K, V>> mapFactory;

        MapConverter(Converter<? extends K> keyConverter, Converter<? extends V> valueConverter, IntFunction<Map<K, V>> mapFactory) {
            this.keyConverter = keyConverter;
            this.valueConverter = valueConverter;
            this.mapFactory = mapFactory;
        }

        public Map<K, V> convert(String value) throws IllegalArgumentException, NullPointerException {
            int idx;
            if (value == null) {
                return null;
            }
            Map<K, V> map = this.mapFactory.apply(0);
            StringBuilder currentLine = new StringBuilder(value.length());
            int fromIndex = 0;
            while ((idx = value.indexOf(59, fromIndex)) >= 0) {
                if (value.charAt(idx - 1) == '\\') {
                    currentLine.append(value, fromIndex, idx + 1);
                } else {
                    this.processLine(map, value, currentLine.append(value, fromIndex, idx).toString());
                    currentLine.delete(0, currentLine.length());
                }
                fromIndex = idx + 1;
            }
            currentLine.append(value, fromIndex, value.length());
            if (currentLine.length() > 0) {
                this.processLine(map, value, currentLine.toString());
            }
            return map.isEmpty() ? null : map;
        }

        private void processLine(Map<K, V> map, String value, String rawLine) {
            int idx;
            String line = rawLine.replace("\\;", ";");
            int fromIndex = 0;
            while ((idx = line.indexOf(61, fromIndex)) >= 0) {
                if (line.charAt(idx - 1) != '\\') {
                    this.processEntry(map, StringUtil.unquoted((String)line.substring(0, idx).replace("\\=", "=")), line.substring(idx + 1).replace("\\=", "="));
                    return;
                }
                fromIndex = idx + 1;
            }
            throw ConfigMessages.msg.valueNotMatchMapFormat(value);
        }

        private void processEntry(Map<K, V> map, String key, String value) {
            map.put(this.keyConverter.convert(key), this.valueConverter.convert(value));
        }
    }

    static final class OptionalConverter<T>
    extends AbstractDelegatingConverter<T, Optional<T>> {
        private static final long serialVersionUID = -4051551570591834428L;

        OptionalConverter(Converter<? extends T> delegate) {
            super(delegate);
        }

        OptionalConverter<T> create(Converter<? extends T> newDelegate) {
            return new OptionalConverter<T>(newDelegate);
        }

        public Optional<T> convert(String value) {
            if (value.isEmpty()) {
                try {
                    return Optional.ofNullable(this.getDelegate().convert(value));
                }
                catch (IllegalArgumentException ignored) {
                    return Optional.empty();
                }
            }
            return Optional.ofNullable(this.getDelegate().convert(value));
        }
    }

    static final class OptionalIntConverter
    extends AbstractDelegatingConverter<Integer, OptionalInt> {
        private static final long serialVersionUID = 4331039532024222756L;

        OptionalIntConverter(Converter<? extends Integer> delegate) {
            super(delegate);
        }

        OptionalIntConverter create(Converter<? extends Integer> newDelegate) {
            return new OptionalIntConverter(newDelegate);
        }

        public OptionalInt convert(String value) {
            if (value.isEmpty()) {
                return OptionalInt.empty();
            }
            Integer converted = (Integer)this.getDelegate().convert(value);
            return converted == null ? OptionalInt.empty() : OptionalInt.of(converted);
        }
    }

    static final class OptionalLongConverter
    extends AbstractDelegatingConverter<Long, OptionalLong> {
        private static final long serialVersionUID = 140937551800590852L;

        OptionalLongConverter(Converter<? extends Long> delegate) {
            super(delegate);
        }

        OptionalLongConverter create(Converter<? extends Long> newDelegate) {
            return new OptionalLongConverter(newDelegate);
        }

        public OptionalLong convert(String value) {
            if (value.isEmpty()) {
                return OptionalLong.empty();
            }
            Long converted = (Long)this.getDelegate().convert(value);
            return converted == null ? OptionalLong.empty() : OptionalLong.of(converted);
        }
    }

    static final class OptionalDoubleConverter
    extends AbstractDelegatingConverter<Double, OptionalDouble> {
        private static final long serialVersionUID = -2882741842811044902L;

        OptionalDoubleConverter(Converter<? extends Double> delegate) {
            super(delegate);
        }

        OptionalDoubleConverter create(Converter<? extends Double> newDelegate) {
            return new OptionalDoubleConverter(newDelegate);
        }

        public OptionalDouble convert(String value) {
            if (value.isEmpty()) {
                return OptionalDouble.empty();
            }
            Double converted = (Double)this.getDelegate().convert(value);
            return converted == null ? OptionalDouble.empty() : OptionalDouble.of(converted);
        }
    }

    static final class SecretConverter<T>
    implements Converter<Secret<T>> {
        private static final long serialVersionUID = -4624156385855243648L;
        private final Converter<T> delegate;

        public SecretConverter(Converter<T> delegate) {
            this.delegate = delegate;
        }

        public Secret<T> convert(final String value) throws IllegalArgumentException, NullPointerException {
            return new Secret<T>(){

                @Override
                public T get() {
                    return delegate.convert(value);
                }
            };
        }
    }

    static class EmptyValueConverter<T>
    extends AbstractSimpleDelegatingConverter<T> {
        private static final long serialVersionUID = 5607979836385662739L;
        private final T emptyValue;

        EmptyValueConverter(Converter<? extends T> delegate, T emptyValue) {
            super(delegate);
            this.emptyValue = emptyValue;
        }

        protected EmptyValueConverter<T> create(Converter<? extends T> newDelegate) {
            return new EmptyValueConverter<T>(newDelegate, this.emptyValue);
        }

        public T convert(String value) {
            if (value.isEmpty()) {
                return this.emptyValue;
            }
            Object result = this.getDelegate().convert(value);
            if (result == null) {
                return this.emptyValue;
            }
            return (T)result;
        }
    }

    static class TrimmingConverter<T>
    extends AbstractSimpleDelegatingConverter<T> {
        private static final long serialVersionUID = 3241445721544473135L;

        TrimmingConverter(Converter<? extends T> delegate) {
            super(delegate);
        }

        protected TrimmingConverter<T> create(Converter<? extends T> newDelegate) {
            return new TrimmingConverter<T>(newDelegate);
        }

        public T convert(String value) {
            if (value == null) {
                throw ConfigMessages.msg.converterNullValue();
            }
            return (T)this.getDelegate().convert(value.trim());
        }
    }

    static final class RangeCheckConverter<T>
    implements Converter<T>,
    Serializable {
        private static final long serialVersionUID = 2764654140347010865L;
        private final Comparator<? super T> comparator;
        private final Converter<? extends T> delegate;
        private final T min;
        private final boolean minInclusive;
        private final T max;
        private final boolean maxInclusive;

        RangeCheckConverter(Comparator<? super T> cmp, Converter<? extends T> delegate, T min, boolean minInclusive, T max, boolean maxInclusive) {
            this.comparator = cmp;
            this.delegate = delegate;
            this.min = min;
            this.minInclusive = minInclusive;
            this.max = max;
            this.maxInclusive = maxInclusive;
        }

        public T convert(String value) {
            int cmp;
            Object result = this.delegate.convert(value);
            if (result == null) {
                return null;
            }
            if (this.min != null) {
                cmp = this.comparator.compare(result, this.min);
                if (this.minInclusive) {
                    if (cmp < 0) {
                        throw ConfigMessages.msg.lessThanMinimumValue(this.min, value);
                    }
                } else if (cmp <= 0) {
                    throw ConfigMessages.msg.lessThanEqualToMinimumValue(this.min, value);
                }
            }
            if (this.max != null) {
                cmp = this.comparator.compare(result, this.max);
                if (this.maxInclusive) {
                    if (cmp > 0) {
                        throw ConfigMessages.msg.greaterThanMaximumValue(this.max, value);
                    }
                } else if (cmp >= 0) {
                    throw ConfigMessages.msg.greaterThanEqualToMaximumValue(this.max, value);
                }
            }
            return (T)result;
        }

        Object readResolve() {
            return this.comparator != null ? this : new RangeCheckConverter<T>(Comparator.naturalOrder(), this.delegate, this.min, this.minInclusive, this.max, this.maxInclusive);
        }
    }

    static final class PatternCheckConverter<T>
    implements Converter<T>,
    Serializable {
        private static final long serialVersionUID = 358813973126582008L;
        private final Converter<? extends T> delegate;
        private final Pattern pattern;

        PatternCheckConverter(Converter<? extends T> delegate, Pattern pattern) {
            this.delegate = delegate;
            this.pattern = pattern;
        }

        public T convert(String value) {
            if (value == null) {
                return null;
            }
            if (this.pattern.matcher(value).matches()) {
                return (T)this.delegate.convert(value);
            }
            throw ConfigMessages.msg.valueNotMatchPattern(this.pattern, value);
        }
    }

    static final class ConfigValueConverter
    implements Converter<ConfigValue> {
        private static final long serialVersionUID = -5005688684588039934L;

        ConfigValueConverter() {
        }

        public ConfigValue convert(String value) throws IllegalArgumentException, NullPointerException {
            throw new IllegalStateException();
        }
    }

    static final class BuiltInConverter<T>
    implements Converter<T>,
    Serializable {
        private final int id;
        private final Converter<T> function;

        static <T> BuiltInConverter<T> of(int id, Converter<T> function) {
            return new BuiltInConverter<T>(id, function);
        }

        private BuiltInConverter(int id, Converter<T> function) {
            this.id = id;
            this.function = function;
        }

        public T convert(String value) {
            return (T)this.function.convert(value);
        }

        Object writeReplace() {
            return new Ser(this.id);
        }
    }

    static final class Ser
    implements Serializable {
        private static final long serialVersionUID = 5646753664957303950L;
        private final short id;

        Ser(int id) {
            this.id = (short)id;
        }

        Object readResolve() throws ObjectStreamException {
            return switch (this.id) {
                case 0 -> STRING_CONVERTER;
                case 1 -> BOOLEAN_CONVERTER;
                case 2 -> DOUBLE_CONVERTER;
                case 3 -> FLOAT_CONVERTER;
                case 4 -> LONG_CONVERTER;
                case 5 -> INTEGER_CONVERTER;
                case 6 -> CLASS_CONVERTER;
                case 7 -> OPTIONAL_INT_CONVERTER;
                case 8 -> OPTIONAL_LONG_CONVERTER;
                case 9 -> OPTIONAL_DOUBLE_CONVERTER;
                case 10 -> INET_ADDRESS_CONVERTER;
                case 11 -> CHARACTER_CONVERTER;
                case 12 -> SHORT_CONVERTER;
                case 13 -> BYTE_CONVERTER;
                case 14 -> UUID_CONVERTER;
                case 15 -> CURRENCY_CONVERTER;
                case 16 -> BITSET_CONVERTER;
                case 17 -> PATTERN_CONVERTER;
                case 18 -> PATH_CONVERTER;
                case 19 -> FILE_CONVERTER;
                case 20 -> URI_CONVERTER;
                case 21 -> DATE_TIME_FORMATTER_CONVERTER;
                case 22 -> CHAR_SEQUENCE_CONVERTER;
                default -> throw ConfigMessages.msg.unknownConverterId(this.id);
            };
        }
    }
}

