/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.jdbc.internal;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.incubator.semconv.code.CodeAttributesExtractor;
import io.opentelemetry.instrumentation.api.incubator.semconv.code.CodeAttributesGetter;
import io.opentelemetry.instrumentation.api.incubator.semconv.code.CodeSpanNameExtractor;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.DbClientMetrics;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.DbClientSpanNameExtractor;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.SqlClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.SqlClientAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.internal.ConfigPropertiesUtil;
import io.opentelemetry.instrumentation.api.semconv.network.ServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.semconv.network.ServerAttributesGetter;
import io.opentelemetry.instrumentation.jdbc.internal.DataSourceCodeAttributesGetter;
import io.opentelemetry.instrumentation.jdbc.internal.DataSourceDbAttributesExtractor;
import io.opentelemetry.instrumentation.jdbc.internal.DbRequest;
import io.opentelemetry.instrumentation.jdbc.internal.JdbcAttributesGetter;
import io.opentelemetry.instrumentation.jdbc.internal.JdbcNetworkAttributesGetter;
import io.opentelemetry.instrumentation.jdbc.internal.dbinfo.DbInfo;
import javax.sql.DataSource;

public final class JdbcInstrumenterFactory {
    public static final String INSTRUMENTATION_NAME = "io.opentelemetry.jdbc";
    private static final JdbcAttributesGetter dbAttributesGetter = new JdbcAttributesGetter();
    private static final JdbcNetworkAttributesGetter netAttributesGetter = new JdbcNetworkAttributesGetter();

    public static Instrumenter<DbRequest, Void> createStatementInstrumenter() {
        return JdbcInstrumenterFactory.createStatementInstrumenter(GlobalOpenTelemetry.get());
    }

    public static Instrumenter<DbRequest, Void> createStatementInstrumenter(OpenTelemetry openTelemetry) {
        return JdbcInstrumenterFactory.createStatementInstrumenter(openTelemetry, true, ConfigPropertiesUtil.getBoolean((String)"otel.instrumentation.common.db-statement-sanitizer.enabled", (boolean)true));
    }

    public static Instrumenter<DbRequest, Void> createStatementInstrumenter(OpenTelemetry openTelemetry, boolean enabled, boolean statementSanitizationEnabled) {
        return Instrumenter.builder((OpenTelemetry)openTelemetry, (String)INSTRUMENTATION_NAME, (SpanNameExtractor)DbClientSpanNameExtractor.create((SqlClientAttributesGetter)dbAttributesGetter)).addAttributesExtractor(SqlClientAttributesExtractor.builder((SqlClientAttributesGetter)dbAttributesGetter).setStatementSanitizationEnabled(statementSanitizationEnabled).build()).addAttributesExtractor((AttributesExtractor)ServerAttributesExtractor.create((ServerAttributesGetter)netAttributesGetter)).addOperationMetrics(DbClientMetrics.get()).setEnabled(enabled).buildInstrumenter(SpanKindExtractor.alwaysClient());
    }

    public static Instrumenter<DataSource, DbInfo> createDataSourceInstrumenter(OpenTelemetry openTelemetry, boolean enabled) {
        DataSourceCodeAttributesGetter getter = DataSourceCodeAttributesGetter.INSTANCE;
        return Instrumenter.builder((OpenTelemetry)openTelemetry, (String)INSTRUMENTATION_NAME, (SpanNameExtractor)CodeSpanNameExtractor.create((CodeAttributesGetter)getter)).addAttributesExtractor(CodeAttributesExtractor.create((CodeAttributesGetter)getter)).addAttributesExtractor((AttributesExtractor)DataSourceDbAttributesExtractor.INSTANCE).setEnabled(enabled).buildInstrumenter();
    }

    private JdbcInstrumenterFactory() {
    }
}

