#The OSULeaf data set consist of one dimensional outlines of leaves.
#The series were obtained by color image segmentation and boundary
#extraction (in the anti-clockwise direction) from digitized leaf
#images of six classes: Acer Circinatum, Acer Glabrum, Acer
#Macrophyllum, Acer Negundo, Quercus Garryana and Quercus Kelloggii
#for the MSc thesis "Content-Based Image Retrieval: Plant Species
#Identification" by A. Grandhi.
@problemName OSULeaf
@timeStamps false
@missing false
@univariate true
@equalLength true
@seriesLength 427
@classLabel true 1 2 3 4 5 6
@data
0.55067091,0.46471588,0.37526084,0.29305977,0.2064272,0.12730744,0.13329609,0.048569914,-0.010611307,-0.092537187,-0.13344732,-0.19703972,-0.21514807,-0.30597432,-0.38932154,-0.46005551,-0.54681588,-0.56313145,-0.64556041,-0.73268024,-0.81264798,-0.90074933,-0.98982207,-1.0802103,-1.1699535,-1.2587605,-1.3235518,-1.424243,-1.4891121,-1.5872739,-1.6873132,-1.8101804,-1.914892,-1.9912036,-2.0657639,-2.1244627,-2.1937424,-2.2602403,-2.3478834,-2.407907,-2.4480263,-2.4428834,-2.3994769,-2.3242773,-2.2695305,-2.1909616,-2.1228822,-2.0583905,-1.977025,-1.9391638,-1.8449628,-1.7667921,-1.7161038,-1.6428757,-1.5600839,-1.4642624,-1.4250991,-1.3753974,-1.4391674,-1.4916709,-1.5306082,-1.5261452,-1.5425813,-1.5113479,-1.4718302,-1.418194,-1.3697817,-1.2956333,-1.2416661,-1.1711771,-1.0963098,-1.0442524,-0.97796956,-0.89960044,-0.80700238,-0.74636623,-0.65772292,-0.57879789,-0.50713384,-0.44220573,-0.38683369,-0.29567345,-0.20391388,-0.1641069,-0.091481978,0.0025222979,0.090671843,0.14654011,0.22441929,0.33732865,0.40228985,0.49263393,0.57381568,0.65323124,0.75327425,0.76952989,0.83287069,0.9204729,1.0007878,1.108537,1.1402094,1.2219762,1.2925238,1.3575949,1.4557461,1.5466891,1.6563578,1.7566883,1.8112524,1.7133521,1.6180637,1.5145203,1.4639511,1.3750644,1.2987548,1.2290378,1.1546093,1.1269972,1.0948093,1.0290877,0.968854,0.92185491,0.92002162,0.84877992,0.80330553,0.73746369,0.64088735,0.54431842,0.53570214,0.57731012,0.52556349,0.41477313,0.35001909,0.32796776,0.30225557,0.22211182,0.14864954,0.061930446,-0.011099005,-0.13413427,-0.20398086,-0.17724357,-0.25984938,-0.31360056,-0.41490483,-0.44225984,-0.55165629,-0.61317618,-0.69400559,-0.64888218,-0.59790841,-0.53679062,-0.47901689,-0.42668434,-0.40453534,-0.35956775,-0.28461524,-0.20916361,-0.2066965,-0.10097678,-0.033504575,0.055781892,0.14442958,0.23194125,0.31939853,0.39540115,0.45854954,0.54981242,0.61342242,0.69332712,0.78012426,0.83809915,0.92524847,0.98880907,1.0751985,1.1273241,1.1360663,1.0922743,1.1266973,1.2157369,1.3230274,1.3151671,1.3088375,1.2549184,1.2989696,1.3029149,1.3419617,1.2854623,1.1937333,1.0997795,1.0465697,0.96411073,0.8662837,0.77513772,0.78905585,0.73279614,0.65219214,0.56573434,0.49225081,0.46029585,0.53450507,0.45047262,0.37933983,0.28739465,0.20491528,0.10850296,0.021992461,-0.068961262,-0.14022998,-0.22594018,-0.30940263,-0.40315108,-0.49039014,-0.58373728,-0.66607867,-0.70589381,-0.784159,-0.87468909,-0.96015366,-1.0406574,-1.0977561,-1.1836416,-1.2736874,-1.347567,-1.377804,-1.4224592,-1.4339047,-1.4164602,-1.3359702,-1.2604066,-1.1885246,-1.121741,-1.0740158,-1.0316884,-0.99350634,-0.98948849,-0.95633931,-0.91005879,-0.88514001,-0.88305195,-0.82933532,-0.82141273,-0.78161783,-0.79012115,-0.82534814,-0.79532882,-0.74201875,-0.69157799,-0.64415416,-0.69830929,-0.65974839,-0.5938364,-0.60066843,-0.56553824,-0.52524439,-0.55232844,-0.64540397,-0.69161076,-0.69790936,-0.63209765,-0.60798273,-0.56502912,-0.5391675,-0.47424094,-0.54137005,-0.58571471,-0.50908932,-0.47429567,-0.42048994,-0.34737778,-0.40279649,-0.33506793,-0.29331349,-0.22872018,-0.19971346,-0.25959054,-0.18511511,-0.11283504,-0.091138632,-0.039038187,0.054361401,0.10006392,0.19262568,0.28504382,0.36303629,0.28110959,0.19306996,0.1044147,0.0070475545,-0.077210998,-0.16033857,-0.21335893,-0.30766879,-0.35172153,-0.38868319,-0.45464751,-0.52432413,-0.61294925,-0.63872425,-0.66486635,-0.75454673,-0.82750663,-0.90941027,-0.95471997,-1.0063412,-0.93437795,-0.83808028,-0.78601902,-0.69534694,-0.62835546,-0.55164738,-0.45034106,-0.43820899,-0.38174364,-0.31180771,-0.21429528,-0.14575827,-0.13636153,-0.035546241,0.013359792,0.10617423,0.16273446,0.25288224,0.23506223,0.16630564,0.11658757,0.034301094,0.032615734,-0.050942997,-0.078021541,-0.027830511,0.00436124,0.099792942,0.18272781,0.24088257,0.32470886,0.42239313,0.41534304,0.36632752,0.37457573,0.37018076,0.46692233,0.50884616,0.58152459,0.63045147,0.72109366,0.79559116,0.8427754,0.80164739,0.76608633,0.84802433,0.89790488,0.95732457,1.032899,1.0748163,1.1512095,1.1591815,1.1080368,1.1776437,1.2479971,1.3114836,1.396232,1.3598873,1.3929663,1.478132,1.5595384,1.5820257,1.6291184,1.7180805,1.7672112,1.8346936,1.9183493,1.9988748,2.0795318,2.1647135,2.1594151,2.0623067,1.9968949,1.9041644,1.8345383,1.7560092,1.6859978,1.6493167,1.5514009,1.4901071,1.4051686,1.4187389,1.3699862,1.3069145,1.2201537,1.1338458,1.0821186,1.1302169,1.0365065,0.95195761,0.87696223,0.83357356,0.74268363,0.72940825,0.77248349,0.67852962,0.64107768,0.56520231,0.49265893,0.40632664,0.43750492,0.47827755,0.45706359,0.36616474,0.32075614,0.25879155,0.20917194,0.11866429,0.037619065,-0.015010646,-0.091304905,-0.043057343,0.01916562,0.039731565,0.063977696,0.11545024,0.18664347,0.21309934,0.27483805,0.34554285,0.40678533,0.50921864:6
0.63031972,0.5516186,0.53626431,0.40026686,0.25537324,0.17479686,0.18606359,0.18844177,0.25658008,0.21568204,0.052388403,-0.088413558,-0.22097592,-0.3713832,-0.50346499,-0.66233449,-0.78011773,-0.83372711,-0.81830321,-0.79132189,-0.6770701,-0.56164671,-0.47082152,-0.38033851,-0.21732836,-0.050753161,0.065179392,0.22050405,0.30731475,0.3861651,0.50817568,0.53531315,0.37019998,0.25109127,0.10773674,-0.031188743,-0.19030911,-0.30344392,-0.46030327,-0.54716946,-0.65196023,-0.7149927,-0.82187275,-0.93014985,-1.086723,-1.2398883,-1.3216816,-1.4630307,-1.516471,-1.6422974,-1.7290554,-1.734351,-1.8623625,-1.9862407,-1.9902167,-1.9747958,-2.0348381,-2.0392906,-2.0111188,-1.9281184,-1.9203597,-1.7775592,-1.8331582,-1.7208633,-1.641771,-1.585067,-1.4803651,-1.2810767,-1.1739032,-1.0097566,-0.91742855,-0.82878963,-0.66949628,-0.55601707,-0.38943879,-0.26686896,-0.1079062,0.038862047,0.2007672,0.24827715,0.21505162,0.15451643,0.16064648,0.18886606,0.22244452,0.40417442,0.52785388,0.66921854,0.7664108,0.91888251,0.98681211,1.0566021,1.2779558,1.4563199,1.6068692,1.6831998,1.6967559,1.6595362,1.6209313,1.5899603,1.567167,1.5521608,1.5452579,1.5465933,1.5560985,1.5734696,1.5911007,1.6236383,1.6646106,1.7140084,1.7721674,1.8405489,1.9145199,1.9929689,2.0711893,1.942376,1.7109465,1.6466945,1.6457793,1.6044674,1.6364292,1.6620106,1.7447754,1.851936,1.9632701,2.0879998,2.2124163,2.3436803,2.2402702,2.149652,2.1468146,2.1345024,2.1499971,2.1124802,2.0052678,1.8279287,1.7103986,1.6198337,1.5469022,1.4411406,1.3661703,1.2412472,1.0869206,0.92162813,0.89373685,0.8452454,0.76870058,0.6747662,0.59056695,0.491797,0.53202489,0.66617266,0.75339159,0.75211164,0.64112091,0.59510295,0.44545127,0.32328512,0.24963684,0.16545653,0.091094324,-0.011673284,-0.11471224,-0.24017998,-0.35539503,-0.4323298,-0.43208799,-0.40883987,-0.20508743,0.012950121,0.076533722,-0.0038003038,-0.078810968,-0.141686,-0.26489335,-0.40112923,-0.5441391,-0.6379819,-0.76550622,-0.8794029,-0.96205425,-1.068248,-1.163454,-1.1804768,-1.2370949,-1.2912076,-1.3797533,-1.4691045,-1.5345495,-1.5886449,-1.7296632,-1.6657574,-1.4915602,-1.3137966,-1.2542291,-1.2692602,-1.3044639,-1.181726,-1.029063,-0.91211612,-0.78351741,-0.76202183,-0.76033286,-0.66014489,-0.64242217,-0.67257502,-0.57591948,-0.48595826,-0.38133344,-0.30740609,-0.19140777,-0.10220673,-0.054521917,0.093998367,0.22771281,0.32247085,0.45867151,0.56102249,0.67451093,0.55226288,0.43994964,0.26146234,0.13681807,-0.012646686,-0.19292545,-0.31441662,-0.49787912,-0.56272457,-0.64513516,-0.73694423,-0.65071974,-0.60752212,-0.6311463,-0.53972235,-0.53298247,-0.44535491,-0.36497279,-0.27684243,-0.14893488,-0.032354826,0.078349146,0.16375465,0.26950357,0.27250184,0.35931099,0.31631808,0.40183881,0.50365653,0.56527602,0.68819925,0.73264476,0.80091002,0.88878127,1.0331719,1.152619,1.0805926,0.91055532,0.7426748,0.62083825,0.4749416,0.37940588,0.3780687,0.46948739,0.5724349,0.6962824,0.78257063,0.8315565,0.92724184,1.0602858,1.0994347,1.1593148,1.0529728,1.0364935,0.96733173,0.90420466,0.85033188,0.80418752,0.76703018,0.73868803,0.70624583,0.67062486,0.56910011,0.435228,0.27534062,0.15827052,0.12748374,0.056962184,-0.095522811,-0.2410755,-0.404172,-0.56560675,-0.71122781,-0.85646233,-0.94313978,-0.97702199,-1.0578191,-1.1346133,-1.2812259,-1.3563979,-1.459877,-1.5276274,-1.3942447,-1.4436027,-1.3587412,-1.3194889,-1.2763744,-1.227679,-1.1451385,-0.98863025,-0.94995332,-0.89572618,-0.81696955,-0.71363102,-0.62083029,-0.57984646,-0.47605839,-0.37479539,-0.23667593,-0.088654487,3.7043561E-4,0.13263319,0.20872746,0.353174,0.46321628,0.59247157,0.74467806,0.89192719,1.0518105,1.1598112,1.1079134,0.91611707,0.70839476,0.52476753,0.31388524,0.1411612,-0.041848062,-0.172125,-0.34184661,-0.49217012,-0.65681958,-0.78651928,-0.79837776,-0.73217597,-0.60976038,-0.6076112,-0.56833514,-0.40782614,-0.23293437,-0.08794991,0.039275375,0.18477494,0.35102298,0.52547834,0.6030907,0.46735601,0.36720323,0.28514839,0.30999759,0.42187118,0.50031318,0.6426935,0.78666979,0.79678868,0.91362606,1.0249735,1.1822043,1.3465739,1.3492372,1.1716435,0.98313986,0.80729353,0.64373982,0.47625096,0.31190696,0.15232907,0.020422362,-0.11832374,-0.19121102,-0.35987243,-0.47931312,-0.61786618,-0.7596443,-0.903156,-0.97390793,-1.0614095,-1.1968612,-1.3998889,-1.5569526,-1.6346547,-1.6758995,-1.6988298,-1.6845677,-1.577779,-1.493792,-1.3807278,-1.1961366,-0.96329787,-0.73217708,-0.51768777,-0.3083607,-0.11346854,-0.22223321,-0.35178716,-0.48698453,-0.59542469,-0.67511627,-0.76848524,-0.8913246,-0.94024486,-1.0049265,-0.95727747,-0.92712637,-0.913088,-0.81337925,-0.65113365,-0.47883583,-0.30492328,-0.16644997,0.013302697,0.17103859,0.13694311,0.14064779,0.23362373,0.34265394,0.4056582,0.47763995,0.55776348:5
2.3759275,2.3244688,2.2454227,2.1819047,2.0848658,2.0141761,1.9436014,1.8484452,1.7981654,1.7448033,1.6597699,1.6017388,1.5519828,1.5024304,1.4588871,1.4088981,1.3588336,1.3096531,1.2876807,1.2413079,1.2070276,1.1946869,1.181861,1.1988462,1.1906552,1.1776643,1.1708677,1.1468442,1.1187541,1.090777,1.0612287,1.0272267,1.0053269,0.98720638,0.97104803,0.94910529,0.92233645,0.8695427,0.83289929,0.83038447,0.80958019,0.73938406,0.6591093,0.62237213,0.60402341,0.560602,0.47648988,0.40475356,0.3822453,0.33543174,0.28927679,0.22662174,0.19559937,0.13123246,0.09259325,0.055182686,0.028617416,-0.0033533389,-0.028161913,-0.058033015,-0.057415362,-0.07494993,-0.079778476,-0.090207421,-0.11026781,-0.13501472,-0.14899814,-0.16147521,-0.19192214,-0.20367136,-0.22400257,-0.27797468,-0.31675348,-0.34181609,-0.35953651,-0.40800803,-0.46067028,-0.4797569,-0.50725783,-0.52564405,-0.56219942,-0.58843566,-0.63278541,-0.68688626,-0.7386833,-0.79802671,-0.79947598,-0.83690168,-0.88512344,-0.93648278,-0.99791338,-1.0678322,-1.1055093,-1.1708924,-1.2289292,-1.3050653,-1.3575893,-1.4150087,-1.4224806,-1.359734,-1.4138518,-1.4837057,-1.5426263,-1.6230618,-1.6029538,-1.6156848,-1.6809898,-1.7331648,-1.7455172,-1.7254402,-1.7335478,-1.7057953,-1.6918345,-1.6723024,-1.6354595,-1.6039903,-1.5654908,-1.5289847,-1.4855687,-1.4487082,-1.4139698,-1.3687006,-1.3285826,-1.2803525,-1.2220958,-1.1890899,-1.1520736,-1.0980552,-1.0529533,-1.0187513,-0.95774195,-0.92900239,-0.90853684,-0.87011598,-0.82365696,-0.83221479,-0.85060725,-0.87134294,-0.88684043,-0.85311526,-0.83759158,-0.82840332,-0.75533529,-0.69250989,-0.64379883,-0.5726057,-0.51716847,-0.46669922,-0.39470361,-0.33383268,-0.2698397,-0.23410844,-0.23410844,-0.15101075,-0.11942168,-0.1008049,-0.049449378,0.015453297,0.074723691,0.12035463,0.14324084,0.196292,0.23602879,0.23602879,0.25268047,0.29977775,0.31740377,0.3274146,0.29053725,0.27568968,0.22444745,0.18797398,0.19657396,0.19243214,0.17028175,0.21196393,0.19656831,0.22796062,0.25244457,0.27771075,0.35348571,0.38547741,0.44056806,0.47388632,0.54783342,0.59800257,0.64855692,0.6810848,0.73778364,0.77576102,0.83595457,0.880098,0.92648398,0.9661641,0.99339606,1.0138277,1.0718099,1.1139322,1.1545842,1.2013135,1.2370955,1.2619057,1.2696046,1.3173472,1.2980986,1.2591265,1.2995725,1.2519325,1.2803995,1.328191,1.3488115,1.4039004,1.4137598,1.3670412,1.34164,1.3172793,1.2806688,1.2536922,1.222739,1.2095502,1.1716532,1.1080503,1.0901663,1.0609779,1.0457041,1.016203,0.99168735,0.96038779,0.91724,0.83615259,0.81377969,0.78762856,0.74878957,0.70821996,0.64578736,0.59980691,0.53551685,0.48604001,0.39025107,0.35114835,0.3225811,0.2435486,0.17967106,0.11907365,0.10957847,0.083483807,0.053443574,-0.0077168493,-0.044616811,-0.077280686,-0.12045304,-0.13369992,-0.1520079,-0.18465527,-0.26365285,-0.31015827,-0.34513779,-0.43445027,-0.48866394,-0.57818725,-0.62893931,-0.72057869,-0.7914232,-0.86071882,-0.9227243,-1.0229215,-1.0682218,-1.1127617,-1.1858291,-1.2396186,-1.3115941,-1.2424739,-1.1908078,-1.1461107,-1.2060744,-1.1886255,-1.1225253,-1.0352896,-0.98048796,-0.8993561,-0.8546777,-0.76378344,-0.76378344,-0.70310185,-0.66123879,-0.59213652,-0.54486329,-0.47677149,-0.42093815,-0.36367154,-0.30650742,-0.22633397,-0.22754913,-0.3037336,-0.31649848,-0.29481669,-0.23046531,-0.18047302,-0.14568864,-0.064456692,-0.038798259,-0.04016988,-0.048648067,-0.063338804,-0.079128283,-0.092109171,-0.099308902,-0.09876223,-0.13514035,-0.13933501,-0.17207519,-0.1966177,-0.25124296,-0.30991468,-0.32431282,-0.35014112,-0.39815606,-0.45231729,-0.50576188,-0.56598386,-0.63079034,-0.66348727,-0.70711823,-0.73555674,-0.74345091,-0.73300132,-0.6849865,-0.67387994,-0.69346123,-0.72121678,-0.75633409,-0.79597189,-0.83853419,-0.86703296,-0.91217817,-0.93655318,-0.99191658,-1.0136159,-1.0329339,-1.0744843,-1.0951517,-1.1079501,-1.1313979,-1.133137,-1.1216254,-1.0727028,-1.0177444,-0.96281658,-0.9163104,-0.87505846,-0.84701007,-0.84543603,-0.84619784,-0.84093659,-0.84979279,-0.84395211,-0.85258641,-0.84708345,-0.85674075,-0.8403828,-0.84271405,-0.86077137,-0.88095172,-0.87246323,-0.87935806,-0.90259952,-0.90079706,-0.91705571,-0.91921702,-0.90816461,-0.91079667,-0.88044545,-0.87747783,-0.8719592,-0.84036882,-0.82721675,-0.80075983,-0.78379893,-0.74577061,-0.71768644,-0.67136976,-0.60629564,-0.55082333,-0.50680252,-0.4260531,-0.34529268,-0.26760127,-0.18861994,-0.10564123,-0.021151282,0.062455729,0.14622147,0.23068883,0.3159428,0.400425,0.48344849,0.56770852,0.64814174,0.6973997,0.76339725,0.84561833,0.8956077,0.96050086,1.0336358,1.0743171,1.1588307,1.2434835,1.3112393,1.3627253,1.4478196,1.5400058,1.6343242,1.7046911,1.776706,1.8623305,1.9194087,2.0176881,2.069028,2.1581546,2.2503612,2.3343448,2.3727285,2.4476669,2.4613473,2.4600405,2.4300608,2.4077744:2
1.4930883,1.430498,1.3308005,1.2156366,1.0815208,1.0167189,0.8983319,0.83571268,0.69858144,0.69234686,0.63074507,0.51673029,0.43365084,0.3064457,0.29661919,0.24825939,0.17340291,0.039763066,0.030781961,-0.039677735,-0.21749553,-0.26035147,-0.38866018,-0.47927507,-0.66601301,-0.70829315,-0.78400378,-0.77035982,-0.65013378,-0.46347962,-0.33133282,-0.18679786,0.013667806,0.1842579,0.35548386,0.54556269,0.67369614,0.86503239,1.0513864,1.2449596,1.1995546,1.0775942,0.98080159,0.87135074,0.85277897,0.74391285,0.65173197,0.60307844,0.60700506,0.45837896,0.36340663,0.30645163,0.18501207,0.12825941,0.056656778,-0.056363939,-0.16571405,-0.28346309,-0.39826806,-0.47629433,-0.58439388,-0.64872753,-0.73749468,-0.6253388,-0.71739263,-0.46358243,-0.32727604,-0.14551822,-0.11883586,-0.20222087,-0.25279591,-0.30035934,-0.39871429,-0.49663654,-0.45728347,-0.550228,-0.61660788,-0.65169542,-0.70761637,-0.76846342,-0.81821603,-0.84252102,-1.0048449,-1.1386996,-1.2394558,-1.4129445,-1.47761,-1.5293023,-1.6736875,-1.8514964,-1.6984857,-1.8094971,-1.9500298,-2.0536211,-1.9948277,-1.8539989,-1.7877832,-1.5927154,-1.4057063,-1.293716,-1.0966721,-0.90673245,-0.70763096,-0.61745341,-0.51930522,-0.35082398,-0.15688633,0.029501455,0.17811147,0.35526872,0.44766597,0.52248632,0.73193551,0.88987044,1.0531457,1.2027617,1.3840582,1.620931,1.7403574,1.8274043,1.9019758,2.0830008,2.265505,2.3807842,2.4605201,2.4781198,2.4020453,2.2509394,2.0366086,1.8146275,1.6403947,1.4103524,1.2116252,1.0431878,1.0345922,0.85267071,0.82456028,0.62228125,0.4338179,0.34182516,0.18322103,0.036792656,-0.13827067,-0.14210689,-0.30738894,-0.49728368,-0.64175108,-0.7945085,-0.99272446,-1.1809439,-1.3455832,-1.423255,-1.5572213,-1.7580626,-1.8577375,-1.9467905,-2.1002609,-2.1972083,-2.2794501,-2.4443813,-2.3277635,-2.2168446,-2.0802398,-1.9660855,-1.8920008,-1.9242845,-1.8119346,-1.618263,-1.4389948,-1.2220287,-1.0917549,-0.93994985,-0.80015569,-0.68830688,-0.66975886,-0.69466819,-0.68485297,-0.69435452,-0.6546331,-0.62654605,-0.62557374,-0.65530027,-0.53610563,-0.36268588,-0.29542408,-0.21693548,-0.1175937,-0.20900909,-0.11563677,-0.29872077,-0.46055542,-0.52959011,-0.65968997,-0.81550407,-0.7070891,-0.72633852,-0.57051658,-0.50146186,-0.43836679,-0.35502291,-0.25073924,-0.23751099,-0.10585029,-0.10204917,-0.008854976,0.117067,0.21585691,0.17487592,0.15079469,0.14790303,0.15716766,0.12216638,0.096468936,0.19138546,0.24386076,0.17241618,0.27938781,0.41096437,0.44164549,0.50755562,0.60166428,0.68680403,0.69315883,0.51660299,0.34914453,0.26535478,0.039285663,-0.076387878,-0.16189428,-0.36359333,-0.60121413,-0.81579751,-0.72687703,-0.64457931,-0.57439482,-0.62572509,-0.56480948,-0.47570855,-0.30758645,-0.24341609,-0.17963804,-0.017368555,0.16434059,0.35493363,0.31568949,0.41879956,0.396893,0.5740023,0.68030215,0.66952627,0.79479692,0.90340497,0.96169215,1.0053597,1.1343347,1.3007667,1.3247859,1.3400566,1.5192027,1.5817421,1.6669124,1.8285726,1.9272793,2.0659221,1.981492,1.7659098,1.597468,1.4109778,1.2837339,1.1339611,0.95490694,0.79469291,0.60782588,0.48681669,0.43776261,0.25464079,0.061519856,-0.08506191,-0.20010001,-0.38334332,-0.52952842,-0.65755867,-0.82367321,-0.80005721,-0.82565299,-0.70466157,-0.59854987,-0.48862963,-0.41251773,-0.24866728,-0.21599566,-0.089972345,0.0087440868,0.16061467,0.24996546,0.099599141,0.22901092,0.38203952,0.51991868,0.6272605,0.75718713,0.89270801,0.85568558,0.88274227,1.0408551,1.1705319,1.3096229,1.2308035,1.3906888,1.556281,1.5911685,1.7467973,1.8648514,1.9881006,1.9067531,1.6916382,1.5327168,1.3240706,1.0760137,0.88630724,0.78930916,0.57476114,0.40490977,0.15888374,-0.022464362,-0.10013515,-0.36005827,-0.50244567,-0.70089241,-0.74620437,-1.0038699,-1.1914179,-1.2816248,-1.4269768,-1.4027254,-1.3258417,-1.1748285,-1.0301795,-0.89004505,-0.75265351,-0.59288646,-0.49414687,-0.56776758,-0.40148476,-0.24711465,-0.16242254,-0.29147035,-0.18963297,-0.060401483,-0.24750199,-0.35619365,-0.28840033,-0.47968356,-0.54099683,-0.43292795,-0.54973804,-0.72289877,-0.83348481,-0.99864634,-1.0620042,-1.0866468,-1.2253121,-1.3829812,-1.4900002,-1.6447189,-1.4870659,-1.2978674,-1.0894244,-0.88663964,-0.68195593,-0.49466828,-0.47571563,-0.2896796,-0.06167631,0.17964005,0.2728675,0.46717685,0.67295758,0.73409806,0.9280728,1.043207,1.2333554,1.334426,1.5448412,1.7032802,1.6727636,1.5182349,1.3297662,1.1919683,1.0592517,0.93231943,0.89309227,0.81305461,0.73981396,0.62775007,0.55327143,0.4552211,0.32710239,0.28226372,0.15500104,0.042818379,-0.070995448,-0.22668441,-0.38811232,-0.53471053,-0.71098306,-0.69595143,-0.78587294,-0.83229133,-0.98083376,-1.0944841,-1.1445273,-1.1536075,-0.90405744,-0.70840469,-0.52213841,-0.3489086,-0.14634329,0.067670543,0.072865066,0.29112303,0.48082407,0.68532744,0.85820819,1.0245701,1.2407233,1.4560599:1
-0.075356071,-0.10460647,-0.12923853,-0.18079369,-0.20419518,-0.17661209,-0.16688036,-0.085327986,-0.14070192,-0.14446787,-0.14579267,-0.24963742,-0.30779249,-0.33378626,-0.33309705,-0.36843434,-0.40084118,-0.48284847,-0.51613974,-0.58661056,-0.53419728,-0.5684025,-0.65204116,-0.63211223,-0.67593482,-0.67210661,-0.68597326,-0.70409257,-0.78728655,-0.81908914,-0.82257374,-0.89522663,-0.93347416,-0.95558328,-0.9905593,-1.0517329,-1.1413089,-1.1377457,-1.1541893,-1.0176663,-0.9017895,-0.76053552,-0.65252239,-0.51910649,-0.39240145,-0.28530733,-0.15573715,-0.029517174,0.085404398,0.22050964,0.3338807,0.47385545,0.58402204,0.71084546,0.83307147,0.96750742,1.0814778,1.2111737,1.3260822,1.4713821,1.5740096,1.7176867,1.8300642,1.9595071,2.0726747,2.2148046,2.3279137,2.4600878,2.5865335,2.7042428,2.8358923,2.9569057,3.0992064,3.1721785,3.1795461,3.1140739,3.0088183,2.8662786,2.7322518,2.6173473,2.4849796,2.3791577,2.241285,2.1073584,1.9945264,1.865626,1.7305225,1.6132094,1.483157,1.3449444,1.2272878,1.1036349,0.98426479,0.86845942,0.72339333,0.61812974,0.48207508,0.3589696,0.22913344,0.11228205,-0.018096198,-0.13813546,-0.25214432,-0.36650443,-0.49155272,-0.5987406,-0.70978836,-0.8382162,-0.91658419,-0.9905593,-0.95863031,-0.92448693,-0.96025026,-0.89176241,-0.90651325,-0.89128679,-0.92527274,-0.977728,-1.034371,-1.0832028,-1.1531735,-1.133456,-1.0551166,-1.019305,-0.98326178,-0.97272181,-0.90469063,-0.79716566,-0.72568008,-0.64271677,-0.58604044,-0.5676529,-0.54567158,-0.54889932,-0.538549,-0.56446963,-0.68275465,-0.72647022,-0.67837837,-0.66866279,-0.62313772,-0.64769809,-0.76070301,-0.7238754,-0.70369912,-0.66334768,-0.58783747,-0.58929605,-0.64049209,-0.76855978,-0.90527419,-0.99949174,-0.92583779,-1.0244242,-1.0660054,-1.0499356,-1.031021,-0.94107217,-0.84073614,-0.77565748,-0.65719539,-0.55475687,-0.50119017,-0.46542044,-0.3877473,-0.27173112,-0.24505848,-0.17766054,-0.12420989,-0.065125291,-0.044534021,-0.040937181,-0.11158528,-0.24539277,-0.27386725,-0.36737852,-0.26922074,-0.24186026,-0.18233006,-0.15858785,-0.063707967,-0.0018798119,-0.0041269148,0.048319063,0.10842974,0.16423486,0.14543819,0.07128068,-0.019672316,-0.0087521746,0.031557449,0.092356617,0.14087602,0.19724301,0.26081883,0.24738086,0.27865108,0.38140721,0.41789982,0.49894851,0.57355981,0.63728874,0.70317345,0.74796389,0.7554486,0.71691185,0.59597113,0.47037042,0.34404517,0.21457496,0.07683612,-0.037943973,-0.21014384,-0.38323134,-0.50877606,-0.68412984,-0.80052052,-0.87942663,-0.98323327,-1.1278042,-1.2534089,-1.3924176,-1.5296916,-1.6020588,-1.5264946,-1.3866937,-1.462988,-1.4100976,-1.4910803,-1.4340671,-1.3718562,-1.2721931,-1.2286137,-1.1389513,-1.1343503,-1.0153136,-0.9098816,-0.78042408,-0.70123051,-0.61718333,-0.49919476,-0.45575125,-0.37314723,-0.33263059,-0.2730216,-0.15729353,-0.069422107,-0.03853056,-0.082281482,-0.12287967,-0.25881873,-0.30487753,-0.38642365,-0.39355822,-0.34379782,-0.3033106,-0.31839656,-0.2104605,-0.12365631,-0.058982942,0.057373123,0.12144808,0.21659431,0.28604504,0.31830976,0.45267219,0.56129732,0.69687631,0.70168324,0.73292517,0.7141699,0.78696052,0.89778703,1.0060892,1.0613525,1.1970213,1.3140155,1.4576147,1.5549831,1.6960972,1.814691,1.9415388,2.0770425,2.1931242,2.2306719,2.1783256,2.053422,1.9475255,1.8375977,1.7108945,1.6036915,1.4741446,1.3695731,1.2452758,1.1453271,1.0184146,0.91930357,0.87723464,0.84244361,0.75108438,0.64408948,0.52023015,0.4198673,0.31534916,0.22511379,0.098278606,0.028447584,0.092687676,0.16318443,0.26748367,0.31375399,0.37100131,0.30154254,0.20597134,0.1013425,0.0098009708,-0.089482868,-0.194448,-0.30729602,-0.41832621,-0.50755256,-0.6043055,-0.68633972,-0.78057966,-0.86017141,-0.84009068,-0.74426911,-0.72348803,-0.81401672,-0.89417311,-0.99075362,-1.0848553,-1.1498485,-1.2268827,-1.2901334,-1.3675433,-1.4281596,-1.5021767,-1.5651186,-1.6221455,-1.5219711,-1.424034,-1.2927332,-1.1969772,-1.0621797,-0.96068117,-0.83254876,-0.72186292,-0.60429287,-0.46543163,-0.35458302,-0.26524988,-0.12742888,0.007034624,0.11605124,0.25103377,0.36508673,0.47758939,0.6163792,0.75542796,0.87858786,1.0126061,1.1471544,1.2611271,1.3003706,1.2406181,1.1547148,1.0633183,0.93491292,0.83657752,0.74002254,0.62431233,0.59094043,0.50842037,0.3715729,0.27010504,0.15435154,0.26280365,0.28203829,0.21374738,0.13592911,0.055623062,-0.040159471,-0.092733873,-0.16990894,-0.23317455,-0.29886927,-0.4102169,-0.38376296,-0.27964928,-0.15100348,-0.0775425,-0.11651546,-0.18017638,-0.22837685,-0.31241122,-0.30649486,-0.26128942,-0.33088025,-0.43291589,-0.53257323,-0.48250705,-0.49039456,-0.58319081,-0.66154672,-0.73945127,-0.80855661,-0.87903122,-0.94147195,-0.9896065,-0.99475406,-1.0476058,-0.88640393,-0.71338956,-0.54352387,-0.41572336,-0.30588699,-0.26707362,-0.26791076,-0.27379372,-0.21777925,-0.16088928,-0.19923683,-0.20136735,-0.18869614,-0.13857736,-0.049999015:3
1.3730908,1.3314569,1.2496347,1.1521447,1.0732221,0.95293218,0.87313484,0.7959635,0.77650775,0.66317822,0.55814208,0.45903633,0.3346309,0.23851937,0.16431008,0.15669841,0.11789588,0.041721144,-0.057312424,-0.17192307,-0.22383654,-0.25074643,-0.35574497,-0.47630489,-0.56686377,-0.66103954,-0.76439887,-0.87524096,-0.94674166,-0.91367055,-0.82920032,-0.77012855,-0.68167416,-0.61119753,-0.53170226,-0.46536887,-0.4120764,-0.39366765,-0.33471536,-0.26279496,-0.16557193,-0.10361742,-0.023167298,0.055506262,0.13929653,0.22762424,0.28062656,0.21320249,0.13605389,0.0892566,0.20040745,0.28808903,0.40515858,0.49156513,0.55512595,0.61500411,0.58754228,0.507075,0.44687163,0.47419504,0.56582302,0.65959282,0.76563862,0.8520172,0.93991398,0.91896587,0.84986828,0.79654687,0.71864989,0.69685281,0.68699725,0.7076747,0.73932162,0.68915366,0.60480814,0.51358409,0.43010909,0.33478351,0.30083111,0.22776392,0.16842546,0.10766717,0.11242775,0.11120158,0.16408316,0.24284012,0.29173735,0.23622142,0.14309816,0.088387503,0.012734228,-0.058478921,-0.11417366,-0.23599713,-0.32962382,-0.4164536,-0.43291144,-0.49374867,-0.55801486,-0.62469129,-0.70322225,-0.78412614,-0.7911336,-0.75523389,-0.84241926,-0.89466526,-0.91024534,-0.83677071,-0.80276353,-0.71655631,-0.61545778,-0.52532358,-0.43804723,-0.34224233,-0.24879225,-0.15583562,-0.063428863,0.017647535,0.10274186,0.14861484,0.23188704,0.33953643,0.42101628,0.51795021,0.61829874,0.70479799,0.79709878,0.88448212,0.97804051,1.0788625,1.1617249,1.2647076,1.3588164,1.4412027,1.5258059,1.5900578,1.6146821,1.5635462,1.4581261,1.3646927,1.2986113,1.2100723,1.1729166,1.0698588,0.98856989,0.88338676,0.80412833,0.78665013,0.84237075,0.83689255,0.77913304,0.68152793,0.60084698,0.52094224,0.44699239,0.4321522,0.4311004,0.39915819,0.31741598,0.23990433,0.15948914,0.080430823,-0.0033964256,-0.032925718,0.031045999,0.089466084,0.17680259,0.18534532,0.14520158,0.084273102,0.014367776,-0.028040313,-0.088269638,-0.15795977,-0.24737283,-0.31234051,-0.39053556,-0.37749994,-0.4247353,-0.47910107,-0.54224643,-0.58535936,-0.62256675,-0.67220214,-0.69752175,-0.5995136,-0.6002788,-0.5139997,-0.43013531,-0.35609871,-0.25960311,-0.20224957,-0.13154592,-0.041926108,0.024158065,1.1915144E-5,-0.057242117,-0.11172391,-0.1014403,-0.16642381,-0.23007627,-0.27574616,-0.31316648,-0.39140396,-0.46110771,-0.52019378,-0.59649443,-0.6400731,-0.61037117,-0.64919736,-0.70910729,-0.7841572,-0.88473547,-0.97655808,-1.0663443,-1.1152303,-1.1749361,-1.2062128,-1.1908708,-1.0817823,-1.0022493,-0.94797349,-0.96916545,-1.0175956,-1.0427644,-1.1017709,-1.1443059,-1.2187036,-1.3042625,-1.3925664,-1.4551883,-1.544144,-1.6019765,-1.6720053,-1.7447284,-1.8136121,-1.8788194,-1.9414983,-2.0039348,-2.0627133,-2.007475,-1.9220418,-1.8205898,-1.7222904,-1.6894103,-1.5827591,-1.4482257,-1.3502409,-1.2393853,-1.136266,-1.0326095,-0.89604394,-0.7944438,-0.65788352,-0.5232532,-0.45053528,-0.36154568,-0.26616513,-0.14713039,-0.013316665,0.092188994,0.22727725,0.32715951,0.46458306,0.56854261,0.70025848,0.83565804,0.96011952,1.0726865,1.1754613,1.2736291,1.3759285,1.5121986,1.6146374,1.7503347,1.8524952,1.9883648,2.0592433,2.1545855,2.2605649,2.3960479,2.4676988,2.5743413,2.676902,2.7683851,2.8264615,2.867816,2.8316886,2.7688015,2.6648805,2.5323082,2.4476215,2.3316817,2.1968742,2.061639,1.9589473,1.8237436,1.7193583,1.5852849,1.4816819,1.3475166,1.2458608,1.1090569,0.9752133,0.87165197,0.73771696,0.6345549,0.49961219,0.38400065,0.2606488,0.15960956,0.060518687,0.059280235,-0.076230494,-0.18995111,-0.31427158,-0.41673301,-0.55359754,-0.68813805,-0.69199999,-0.80947299,-0.88872623,-0.99922167,-1.127011,-1.1806227,-1.29127,-1.3984606,-1.5166302,-1.6355148,-1.7056746,-1.8200322,-1.906078,-1.9588601,-2.0379577,-2.0338532,-1.9783816,-1.9293029,-1.883179,-1.8287076,-1.77257,-1.7086694,-1.6431883,-1.5611181,-1.4930368,-1.4170309,-1.3346667,-1.2555376,-1.1829374,-1.0875415,-1.0051554,-0.94759969,-0.86850468,-0.81294278,-0.77472742,-0.80400131,-0.87550847,-0.91874075,-0.83772693,-0.74211045,-0.65818933,-0.55633484,-0.49929328,-0.42003378,-0.34383277,-0.23969825,-0.18165618,-0.17686874,-0.23135014,-0.24651693,-0.13349672,-0.025832761,-2.5266734E-4,0.0097727861,0.098268693,0.14598426,0.19851045,0.1843889,0.10587146,0.034419539,-0.040822643,-0.12941375,-0.20002443,-0.28179761,-0.36425433,-0.45133792,-0.53491724,-0.53899016,-0.49699453,-0.45916009,-0.42340433,-0.37754506,-0.3280928,-0.26517546,-0.21408748,-0.18380843,-0.12049143,-0.048819765,0.021879425,0.086122906,0.12759518,0.19160218,0.24346309,0.30523552,0.35587014,0.32508461,0.23814961,0.18474383,0.1368522,0.12610807,0.20320199,0.26204842,0.32030049,0.38044906,0.46214657,0.50414082,0.44482108,0.47195525,0.57261822,0.63894526,0.64839176,0.75503836,0.86838091,0.95339607,1.0506395,1.1624349,1.265789,1.3503154:3
1.6918959,1.641405,1.5636877,1.4857924,1.388561,1.3910654,1.4526523,1.4875092,1.4841033,1.4413995,1.3781169,1.2993987,1.2343029,1.1691858,1.0997254,1.0307563,0.95597197,0.8699139,0.78831155,0.69792516,0.60801748,0.51560067,0.40418638,0.28720862,0.17812419,0.060695455,-0.06258448,-0.19831324,-0.3448663,-0.50462009,-0.62625636,-0.78381926,-0.94524728,-1.104174,-1.2627783,-1.3858513,-1.5357307,-1.6908251,-1.8104835,-1.9561842,-2.0850764,-2.1826116,-2.2509562,-2.1479999,-2.0215896,-1.9037799,-1.7907147,-1.6734095,-1.5486087,-1.4447633,-1.3281893,-1.2190009,-1.0973898,-0.99224652,-0.88329199,-0.77854199,-0.66234878,-0.54804899,-0.4433236,-0.33734448,-0.21904118,-0.10683136,0.0015816271,0.10816377,0.23242505,0.33715365,0.45189163,0.57041236,0.67941553,0.76437443,0.85252676,0.94330481,0.99343967,0.9955443,0.99987903,0.98394837,0.9439689,0.90916024,0.8524621,0.77254026,0.68217914,0.58817805,0.48087847,0.38196943,0.28114144,0.23900717,0.29811949,0.36539683,0.41392642,0.39250456,0.32501497,0.24499677,0.14550141,0.060745584,-0.03475012,-0.13450305,-0.23514855,-0.33185171,-0.42459769,-0.50692523,-0.61022753,-0.70067358,-0.80099301,-0.88710367,-0.9747392,-1.0858363,-1.155892,-1.2368746,-1.3167703,-1.3940947,-1.4802382,-1.5696217,-1.6532152,-1.7185285,-1.7757008,-1.8371741,-1.8771879,-1.9245085,-1.8112094,-1.7901118,-1.6789005,-1.5506241,-1.4221457,-1.2850762,-1.1529158,-1.0531544,-0.92054067,-0.78773897,-0.64817521,-0.48871338,-0.34179168,-0.18974125,-0.041728733,0.076675942,0.18600687,0.27999562,0.35336861,0.40634232,0.44415015,0.46398944,0.45524535,0.45393854,0.43082865,0.4036451,0.38099014,0.3585607,0.31782755,0.28769842,0.25577168,0.21621858,0.19913042,0.16073845,0.11594401,0.084034758,0.071439939,0.036664139,0.010821503,-0.02642005,-0.04569434,-0.067409062,-0.10059681,-0.14189359,-0.13911834,-0.20496919,-0.23277806,-0.27246869,-0.30541583,-0.34100426,-0.37481139,-0.41825525,-0.46779237,-0.50860876,-0.6174857,-0.6818753,-0.67313501,-0.54842731,-0.44574808,-0.32293592,-0.20668382,-0.089103659,0.026824789,0.15151399,0.22376649,0.26028152,0.29074208,0.30538538,0.31219366,0.30721712,0.31912862,0.34696208,0.42955213,0.50304399,0.54460709,0.60669573,0.64296123,0.68504498,0.71545725,0.77072855,0.74209166,0.78832194,0.81862719,0.86004628,0.8941185,0.96344145,0.99891597,1.0475955,1.1083508,1.1522983,1.1957863,1.2380582,1.318928,1.4475855,1.5745472,1.7049432,1.8676231,1.9959001,2.0893914,2.1782124,2.1679206,2.1257276,2.1049909,1.9809492,1.880827,1.7214453,1.5968185,1.4872487,1.3369476,1.1907702,1.1153213,1.10504,1.0477971,1.0269209,1.0267997,0.9832509,0.98018722,0.96152825,0.89225534,0.88857109,0.84323175,0.79437567,0.74030073,0.68204436,0.62354229,0.58140494,0.53574417,0.48494026,0.43391708,0.38226389,0.32608759,0.27021169,0.2190528,0.16525512,0.12491459,0.072858438,0.017269196,-0.033261571,-0.077878133,-0.1607668,-0.24642766,-0.38664047,-0.52083985,-0.50872099,-0.50640859,-0.60757,-0.71475015,-0.82861623,-0.84400316,-0.7623442,-0.65980286,-0.53881503,-0.54533366,-0.67079441,-0.81336262,-0.92962242,-0.9568068,-0.90157092,-0.85755728,-0.77677436,-0.7089531,-0.65746392,-0.65071553,-0.55805099,-0.57393637,-0.54526316,-0.4730891,-0.43697029,-0.37251181,-0.29631829,-0.25232586,-0.20868378,-0.15976223,-0.11348531,-0.07423269,-0.042185201,-0.0052324186,0.04429408,0.083153346,0.11117406,0.14353737,0.16834264,0.19431886,0.22145579,0.25445872,0.29831664,0.34674187,0.39262412,0.44953184,0.50387966,0.54993076,0.61601526,0.6629317,0.70884917,0.75098309,0.78008959,0.80950072,0.85048896,0.87712336,0.86465229,0.78415925,0.7058813,0.59882372,0.48980319,0.38969884,0.28066158,0.15828582,0.027265768,-0.070436532,-0.077334054,-0.20468624,-0.29867141,-0.37250856,-0.50141379,-0.64357535,-0.79693455,-0.8928023,-1.0580208,-1.2208494,-1.3878207,-1.4883008,-1.6340904,-1.7529898,-1.8872403,-2.0530455,-2.172409,-2.2710928,-2.3516675,-2.4859504,-2.5108708,-2.4832263,-2.3879938,-2.2827031,-2.1809464,-2.078677,-1.9626274,-1.851396,-1.7375709,-1.6385938,-1.5271666,-1.4288966,-1.3141357,-1.2017918,-1.1021691,-0.98291736,-0.87631007,-0.76925121,-0.67307056,-0.57025423,-0.46900641,-0.37086935,-0.25685735,-0.1579792,-0.061377973,0.05376574,0.14411833,0.243058,0.32634365,0.42607646,0.53120951,0.63438938,0.73287657,0.8317074,0.92896241,0.9616543,0.9602702,0.9313766,0.92540249,0.90771506,0.85326242,0.80102409,0.70199584,0.63595508,0.52395967,0.4072861,0.30298291,0.18453721,0.088024159,-0.0098778781,-0.11282199,-0.17733844,-0.28114851,-0.36188945,-0.40118726,-0.38903952,-0.30929837,-0.18918894,-0.037168571,0.11461789,0.25473039,0.37221918,0.48425964,0.58645219,0.71710696,0.80846491,0.88674129,0.95336861,1.0643584,1.172108,1.2546828,1.330243,1.408481,1.4891769,1.5605079,1.609078,1.6667865,1.6841084,1.6996352,1.7195356:2
1.029364,0.87520572,0.725283,0.56617453,0.42044688,0.25486669,0.083849474,-0.059232318,-0.22173424,-0.3765339,-0.52387416,-0.69140769,-0.8322617,-0.95202887,-1.0615153,-1.1014204,-1.0025599,-0.89294374,-0.79153627,-0.71507233,-0.65033783,-0.62061156,-0.54241699,-0.44997125,-0.31414358,-0.18569072,-0.026691088,0.0070395785,0.10126442,0.20653787,0.27411697,0.29597632,0.36300955,0.38918502,0.38573929,0.26576297,0.12697739,0.074466854,0.13689044,0.24167864,0.35871898,0.42757708,0.49882029,0.62775827,0.68879201,0.8055114,0.89273237,0.89282821,0.7740638,0.72420675,0.70677635,0.83176252,0.92498171,1.0222609,1.12495,1.197615,1.1781059,1.2317086,1.3484081,1.4186807,1.5227528,1.6416102,1.749392,1.7898653,1.7076054,1.5734685,1.411648,1.2797503,1.1131349,1.0017283,0.92420779,0.7651324,0.60327337,0.4371892,0.30740235,0.17311102,0.0046675035,0.022555632,-0.016847539,0.062894718,0.16902765,0.2488636,0.33856529,0.38813287,0.43235135,0.46977427,0.43290467,0.27730307,0.15459026,0.11951396,0.1565077,0.2282513,0.28853597,0.30447757,0.39536874,0.46651497,0.54843196,0.56645601,0.46023232,0.36303273,0.22754196,0.1154048,0.0083537922,0.014380588,0.10577111,0.21736964,0.34127354,0.38389149,0.44911531,0.53908685,0.61613411,0.73818783,0.80431112,0.70937219,0.83881422,0.96934425,1.1000222,1.2565868,1.2869477,1.4159679,1.5616893,1.6977999,1.8506227,1.9168291,1.8795809,1.7374671,1.5916942,1.4528609,1.3027773,1.1617105,1.0222392,0.89420491,0.80919185,0.6746373,0.53476293,0.38838338,0.24489997,0.11852003,-0.032055823,-0.17822743,-0.29748084,-0.23876062,-0.25106846,-0.31321708,-0.44340554,-0.58359965,-0.72736967,-0.8756747,-1.0174082,-1.1722436,-1.3252116,-1.4578063,-1.6030276,-1.7469589,-1.8894323,-2.0381679,-2.1774762,-2.3243868,-2.4259495,-2.3183419,-2.2495666,-2.1684356,-2.095783,-2.0322318,-1.95642,-1.8834141,-1.763966,-1.7320802,-1.6144778,-1.4858352,-1.4294557,-1.4178965,-1.4445981,-1.4790034,-1.3234748,-1.2261091,-1.1013185,-0.98218687,-0.88112904,-0.83777778,-0.77858684,-0.70090478,-0.62727967,-0.57070857,-0.65640472,-0.79148735,-0.8862997,-0.99832793,-1.0958866,-0.98354896,-0.87484362,-0.74341331,-0.6397856,-0.53503531,-0.44216001,-0.32060999,-0.23785965,-0.18607168,-0.053266066,0.064841912,0.20573618,0.20907826,0.16451482,0.28449416,0.40781001,0.54279004,0.67309839,0.73428213,0.76433163,0.91276704,1.0546114,1.193888,1.3280419,1.4684049,1.5880289,1.7048074,1.6295658,1.501596,1.3128494,1.1852996,1.0199851,0.87190199,0.78437122,0.6571638,0.51289483,0.35407996,0.19520044,0.05988522,0.13481749,0.10336417,-0.062631301,-0.20634462,-0.36064274,-0.49473373,-0.57569084,-0.68276854,-0.83505132,-0.97394605,-1.0460278,-0.95331685,-0.85441937,-0.76132506,-0.72590329,-0.82726945,-0.95155505,-1.0300796,-1.1571742,-1.2264144,-1.3490735,-1.4814894,-1.6045232,-1.6206471,-1.6456925,-1.7682949,-1.8866921,-1.9978293,-2.1219181,-2.2519131,-2.3601881,-2.4711649,-2.552934,-2.6027281,-2.6697778,-2.5886377,-2.4054662,-2.2431362,-2.0858229,-1.9426905,-1.9376558,-1.7877694,-1.6194788,-1.4505286,-1.3031573,-1.1453553,-0.9781459,-0.88112628,-0.87495821,-0.82188907,-0.73133369,-0.56671512,-0.44199039,-0.28006572,-0.18898468,-0.019389337,0.11430834,0.27703846,0.33363145,0.46921027,0.64615609,0.80691249,0.96840765,1.1353951,1.3029154,1.4703,1.5920124,1.6251032,1.5573189,1.4758761,1.413483,1.3310653,1.2416411,1.1371777,1.0374923,1.0609648,1.0129543,0.92209792,0.83218792,0.73376806,0.69840384,0.57273392,0.45781472,0.49312096,0.55580334,0.49572648,0.40821197,0.34211821,0.26068705,0.26341913,0.22234007,0.14255,0.070245177,0.0061004396,-0.052291873,0.074126937,0.20737638,0.35232611,0.47699437,0.44034281,0.35372783,0.27774139,0.27996163,0.23383305,0.13801974,0.085078964,0.16738416,0.081865623,-0.036780773,-0.15427899,-0.18301841,-0.057120494,0.093349116,0.16779775,0.14927882,0.092567525,0.016204616,0.030872447,-0.037455882,-0.13484508,-0.23375625,-0.22108913,-0.30187333,-0.29912886,-0.16059437,-0.013502769,0.12854742,0.28010092,0.40405536,0.56458334,0.69733073,0.83425194,0.93933862,1.0744192,1.2373876,1.3678992,1.3901473,1.3305818,1.2877223,1.1881249,1.19794,1.0907504,0.99362729,0.99127348,0.89647367,0.81172702,0.86090082,0.9642623,0.89772488,0.82565716,0.75760133,0.66196369,0.56743609,0.46031702,0.37339831,0.2759593,0.17132412,0.083064335,0.0064538411,0.024085415,0.19775583,0.20911091,0.14169427,0.11941467,0.044608685,0.022189644,0.042603452,-0.059957942,-0.16126672,-0.27477364,-0.38467891,-0.511909,-0.62194343,-0.72038096,-0.80347516,-0.86344517,-0.91226314,-0.94407825,-0.97959061,-1.0125964,-1.0085561,-1.0211695,-1.0550692,-1.0821767,-1.076714,-0.92053144,-0.78246216,-0.63309386,-0.46219338,-0.32397307,-0.16832232,-0.011398553,0.13059055,0.29376004,0.45856643,0.60047125,0.77257014,0.90743735,0.99463684:3
1.7751806,1.8383546,1.9104974,1.9687411,1.9569559,1.936453,1.9199593,1.8878364,1.8573255,1.8323988,1.8060941,1.7777421,1.7282319,1.6914569,1.6352583,1.5820588,1.5235623,1.4689213,1.4157525,1.3715923,1.3385001,1.3084475,1.2723351,1.2412035,1.2183505,1.1987468,1.1915758,1.1876763,1.1805721,1.1687066,1.1554138,1.1205054,1.0752673,1.0488563,1.0523564,1.0476428,1.0541996,1.0035268,0.96229284,0.92375227,0.88390667,0.82983849,0.78591284,0.73632166,0.69793573,0.65703581,0.61006797,0.56488385,0.52176539,0.47172787,0.43248752,0.38675032,0.33350632,0.28072345,0.22267923,0.14215503,0.065982618,0.004419024,-0.069016921,-0.127828,-0.19342986,-0.24951463,-0.31023421,-0.37107454,-0.4288512,-0.47718142,-0.53265977,-0.57827512,-0.62136659,-0.65399986,-0.68368134,-0.70633599,-0.72373363,-0.73819128,-0.73673696,-0.7321874,-0.72390632,-0.71173645,-0.69976466,-0.68281767,-0.65419622,-0.62067578,-0.58832858,-0.55756776,-0.53453451,-0.49761042,-0.43154577,-0.38860423,-0.4267896,-0.51564728,-0.54525598,-0.5633369,-0.55733366,-0.53033059,-0.49678523,-0.44903169,-0.39162601,-0.34397479,-0.27637724,-0.20752096,-0.13787472,-0.09023228,-0.017741799,-0.019072888,-0.075615578,-0.074873084,-0.14787422,-0.22951346,-0.31571751,-0.38270201,-0.46828351,-0.53726952,-0.61962266,-0.69297264,-0.76202468,-0.83371099,-0.89677679,-0.97479831,-1.0535619,-1.1184484,-1.1936058,-1.2704248,-1.340608,-1.4208989,-1.490042,-1.5533925,-1.6351646,-1.7076714,-1.7753422,-1.8584725,-1.9375845,-2.0110141,-2.0421179,-2.080051,-2.1111119,-2.1359763,-2.1489292,-2.1476438,-2.1404151,-2.1293467,-2.0910143,-2.0458689,-1.995603,-1.9401012,-1.871295,-1.798717,-1.7255424,-1.6568354,-1.5943561,-1.515555,-1.4390977,-1.3718093,-1.2894272,-1.2250088,-1.1475181,-1.0689698,-1.0049342,-0.93614839,-0.8632652,-0.78502132,-0.71326683,-0.64736555,-0.57058236,-0.50525833,-0.43259162,-0.35671302,-0.29372488,-0.21793492,-0.1555909,-0.079796559,-0.016996105,0.057081659,0.13740118,0.20344498,0.27497054,0.35477077,0.41893261,0.49876796,0.57845474,0.65074625,0.71662548,0.65080274,0.58045774,0.49276515,0.41695929,0.31780206,0.24235834,0.14571565,0.070728791,0.001896769,-0.023347081,-0.0086925348,0.050509617,0.11751875,0.17703588,0.24228599,0.31708283,0.39436499,0.45736456,0.52604233,0.60863668,0.67872337,0.73931089,0.81931993,0.89511046,0.96221378,1.031367,1.1133871,1.1812516,1.2597242,1.326554,1.3992699,1.3893188,1.4426193,1.5124127,1.5840862,1.6532806,1.7291358,1.8163393,1.7510571,1.6598353,1.5944536,1.5162376,1.4480428,1.3638505,1.289576,1.2192368,1.144748,1.0637679,0.99070702,0.92126903,0.84127675,0.76593376,0.69549503,0.73053276,0.7712591,0.82368169,0.76444032,0.69300938,0.6162875,0.54164205,0.47305354,0.39449994,0.31709717,0.2453403,0.17472235,0.10198116,0.029742252,-0.039716191,-0.12288388,-0.19415537,-0.26618105,-0.33831311,-0.40244183,-0.46858389,-0.54159899,-0.58654364,-0.62377199,-0.64266171,-0.63586364,-0.6152867,-0.57851466,-0.52824494,-0.45302503,-0.38398589,-0.32522454,-0.22631358,-0.1292988,-0.03189001,0.068494347,0.16367977,0.25040571,0.31510769,0.2618769,0.16120556,0.07750874,-0.0016329986,-0.073491965,-0.13916269,-0.19962236,-0.23925647,-0.21502111,-0.27152638,-0.35180665,-0.42724356,-0.49852001,-0.56310453,-0.64056029,-0.69681233,-0.76050061,-0.82413167,-0.87293312,-0.92662602,-0.99215036,-1.0489149,-1.1170073,-1.1754933,-1.2353803,-1.2799095,-1.3311345,-1.3855086,-1.4294864,-1.4748608,-1.5191607,-1.5566702,-1.6026868,-1.6385174,-1.6758245,-1.7111185,-1.7490624,-1.7727282,-1.7914229,-1.8073508,-1.8087697,-1.8032802,-1.7930699,-1.7613605,-1.6991634,-1.6519061,-1.5694003,-1.478656,-1.4049233,-1.3221621,-1.2454859,-1.1802362,-1.1011495,-1.0426893,-0.97958252,-0.91232751,-0.83042498,-0.76521574,-0.70030841,-0.62451201,-0.5584699,-0.48550851,-0.41809794,-0.34678949,-0.28237053,-0.21062196,-0.12947337,-0.05661498,0.014382917,0.080137794,0.15713175,0.2379973,0.30709961,0.38827034,0.46415112,0.5469819,0.62960278,0.63232732,0.5723708,0.52978681,0.50438793,0.47414886,0.43906019,0.41810468,0.41529586,0.4523288,0.52265002,0.49374269,0.43914801,0.40464901,0.34943378,0.3148142,0.27581177,0.25090923,0.22872208,0.20374341,0.1933268,0.17879737,0.16651152,0.16651237,0.15750987,0.15509423,0.15078598,0.1496914,0.14260919,0.12809912,0.1302669,0.13148016,0.13199566,0.13633003,0.14310005,0.14785853,0.16521001,0.187747,0.20848224,0.22034308,0.23514849,0.25747075,0.28047018,0.31265778,0.34902568,0.38728154,0.42588238,0.47123047,0.51697304,0.56713182,0.59195196,0.61553522,0.64591104,0.67918063,0.71487038,0.75344032,0.78241494,0.82206157,0.86197705,0.88134334,0.92296112,0.97039118,1.006428,1.04538,1.0994026,1.1260633,1.1788218,1.2381728,1.2799781,1.3239739,1.387332,1.4504871,1.4948274,1.5452891,1.586767,1.6397106,1.7077881,1.7563769:4
0.48611703,0.37862716,0.28282109,0.17326867,0.056185696,-0.057300013,-0.17992483,-0.28467578,-0.35581915,-0.44579762,-0.55543244,-0.65471669,-0.73243384,-0.81443745,-0.86273456,-0.92295342,-1.012789,-1.0697545,-1.1293533,-1.2178159,-1.2576908,-1.2930574,-1.2979438,-1.258632,-1.2816077,-1.1370403,-0.99421735,-0.98775584,-0.85105781,-0.6991739,-0.56722809,-0.44428485,-0.3557852,-0.22815773,-0.11283894,-0.0012471786,0.10427243,0.14595874,0.29527935,0.40343337,0.32540572,0.2165944,0.20343614,0.10311873,0.0052546339,-0.028252131,-0.099756453,-0.19920076,-0.28476973,-0.40165468,-0.43481434,-0.45776907,-0.50571588,-0.60519926,-0.7155312,-0.76065719,-0.82940941,-0.89398177,-0.95899346,-1.0530574,-1.0806524,-1.1245757,-1.1625092,-1.0847698,-1.0667369,-0.94651073,-0.82655361,-0.68898154,-0.66081861,-0.6191651,-0.51776058,-0.38871583,-0.2616565,-0.1299047,-0.0080129613,0.1268967,0.25624774,0.38149324,0.51479708,0.64002623,0.76179828,0.88936926,1.0189031,1.1435893,1.2522997,1.3625991,1.4086798,1.5243488,1.6477001,1.7123514,1.8352343,1.8989959,2.0066491,2.1164899,2.2441503,2.2442237,2.2475332,2.1410126,2.0230246,1.9075956,1.7905654,1.7052883,1.6123275,1.5722742,1.4587925,1.3516561,1.2294496,1.0941134,0.96804901,0.8447056,0.75084487,0.61609201,0.48042669,0.36120056,0.23001218,0.10149697,-0.036687637,-0.16038385,-0.28288182,-0.37725649,-0.43078195,-0.56417205,-0.69210033,-0.82840229,-0.94068643,-1.0665735,-1.1981639,-1.2807355,-1.3731116,-1.4409383,-1.5353949,-1.4983441,-1.3881724,-1.3993236,-1.2982221,-1.2401672,-1.1684255,-1.1225062,-1.1008611,-1.1014541,-1.0043218,-0.91611401,-0.86744127,-0.73627382,-0.63915928,-0.56517763,-0.51829238,-0.54219484,-0.46273732,-0.36432099,-0.35975125,-0.26094048,-0.16243939,-0.090260426,0.0062909747,0.091118831,0.16980594,0.23359521,0.31206778,0.39051192,0.47183564,0.55744449,0.64925759,0.73854678,0.84429752,0.9403037,1.0397364,0.92135748,0.84915403,0.74798758,0.61251421,0.50247906,0.47218349,0.37718463,0.30975498,0.17539384,0.038036404,-0.091991388,-0.22652071,-0.35267092,-0.48643253,-0.61386837,-0.74413585,-0.87034231,-0.94509969,-1.0315504,-1.095146,-1.1103489,-1.1602441,-1.1577069,-1.0384099,-0.9229356,-0.79991183,-0.6633982,-0.52915398,-0.43374794,-0.29793723,-0.18708737,-0.03617347,0.073419774,0.20222239,0.31763029,0.40644827,0.46771267,0.58261328,0.73400641,0.89193158,0.98664825,0.91564005,0.8051241,0.70328041,0.59417855,0.49329578,0.44106164,0.42070284,0.49459491,0.57699497,0.69815984,0.77664133,0.83863919,0.84602165,0.8934108,0.97642188,1.0730495,1.1709107,1.272149,1.3830119,1.4738957,1.5284046,1.4765515,1.3436435,1.2141828,1.1004379,0.98003517,0.85112979,0.74593431,0.59570205,0.4847227,0.30409542,0.18072311,0.073364393,-0.0245557,-0.11867675,-0.23015125,-0.40590397,-0.58142489,-0.74080683,-0.88320068,-1.0245639,-1.164849,-1.287258,-1.4477904,-1.6059681,-1.7635264,-1.9128706,-1.9085182,-1.8750087,-1.8102967,-1.7604466,-1.6811474,-1.635135,-1.6488758,-1.6263105,-1.5438025,-1.4335067,-1.3585737,-1.2425674,-1.1136165,-0.96944469,-0.82277456,-0.67025259,-0.51919921,-0.38763041,-0.2487445,-0.1214548,0.01380265,0.12909879,0.25398713,0.36470088,0.45472144,0.52247552,0.61053104,0.72146251,0.70546301,0.65091498,0.60974137,0.55800602,0.49973189,0.44606342,0.47410063,0.60336882,0.68864575,0.82431053,0.9117268,0.97290115,1.0709209,1.2088354,1.2686651,1.3077275,1.3841186,1.4456193,1.5477673,1.5685978,1.6604046,1.7249674,1.842895,1.9939687,1.9708511,1.8512716,1.7347615,1.6202004,1.5120837,1.3968424,1.3001195,1.1835205,1.1428923,1.1092996,0.98587126,0.86375992,0.75075162,0.63283214,0.5062283,0.4050499,0.31206047,0.32613105,0.27746847,0.38406182,0.46003128,0.53750025,0.631045,0.72938603,0.75208111,0.63995308,0.50212118,0.37234549,0.25397149,0.1381918,0.039373965,-0.078372278,-0.19261234,-0.32676344,-0.47379544,-0.57389227,-0.66542131,-0.70341362,-0.83779502,-0.97153591,-1.0564325,-1.1567506,-1.1798561,-1.2632877,-1.3548123,-1.4239077,-1.536209,-1.6081531,-1.6557359,-1.7935345,-1.9279427,-2.0479084,-2.1215914,-2.1198111,-2.1891386,-2.1017209,-2.0593782,-1.9481287,-1.8234727,-1.7012753,-1.6232074,-1.5064739,-1.4296447,-1.3062253,-1.1760406,-1.0972838,-1.0194836,-0.92107857,-0.89840495,-0.76428824,-0.65721004,-0.52601172,-0.40543456,-0.28351528,-0.23814033,-0.18181796,-0.13267622,-0.0047872507,0.13034797,0.24517259,0.36146413,0.48027006,0.59359221,0.7208838,0.82450369,0.94603468,1.0624313,1.1790883,1.295098,1.419565,1.3942001,1.2992394,1.2225152,1.1627915,1.1150872,1.1132939,1.0746917,0.98462763,0.85386687,0.73238128,0.67276305,0.60893288,0.57914865,0.52822144,0.49943823,0.39062476,0.32528432,0.23937788,0.11718433,0.048442927,0.026679625,-0.0013160174,-0.065738665,-0.068196151,-0.024101545,0.071622746,0.16526033,0.27035755,0.37336391,0.47947854:5
3.2115582,3.063774,2.8574483,2.6301694,2.4068958,2.3160476,2.1485521,1.9211291,1.6937134,1.5015632,1.2891974,1.0619112,0.88510368,0.65786268,0.43064341,0.20355791,0.026676123,-0.20049327,-0.42758026,-0.65445867,-0.83090553,-1.0090413,-1.2356572,-1.3615135,-1.5382223,-1.6735427,-1.5498094,-1.4152445,-1.3221488,-1.2166092,-1.2058618,-1.0990321,-1.0534215,-1.1349541,-1.2295728,-1.1542191,-1.2933739,-1.2125359,-1.092281,-1.0708749,-0.93954891,-0.796092,-0.64641011,-0.5532101,-0.44756579,-0.3493796,-0.28606142,-0.27894613,-0.2860186,-0.45590369,-0.64893536,-0.85700652,-0.97498091,-0.9308626,-0.8746732,-0.81448922,-0.70149745,-0.63265958,-0.54748348,-0.58834549,-0.53483885,-0.43769023,-0.3052756,-0.24793476,-0.14213673,-0.073090585,-0.041613758,-0.0040456422,-0.028716601,0.014677046,0.038350801,0.046143024,0.079304896,0.20097809,0.11465224,0.23240543,0.24995164,0.32250497,0.4000017,0.42386352,0.38740974,0.2062477,0.082537108,-0.062316319,-0.12385866,-0.2536786,-0.37168155,-0.54689863,-0.59513621,-0.71320153,-0.62229674,-0.80892177,-0.72208727,-0.59660174,-0.4830108,-0.46129203,-0.36446405,-0.43318507,-0.31268588,-0.26790395,-0.25428409,-0.19546571,-0.10007452,-0.015502194,0.0038829325,0.075903887,0.12643725,0.20171625,0.28449183,0.41711115,0.44096397,0.51334481,0.64805775,0.74360993,0.84490562,0.96276275,1.0399566,1.0638564,0.88797859,0.70978897,0.52233932,0.44339338,0.32173596,0.22695202,0.12659142,0.068169419,-0.091846152,-0.18887342,-0.38361184,-0.39123864,-0.54667079,-0.65040894,-0.83868251,-0.9275194,-0.96544196,-0.87423352,-0.73326499,-0.66000784,-0.51970314,-0.41394465,-0.29248332,-0.18828776,-0.053127074,0.046499267,0.063881516,0.19744978,0.31028879,0.23806503,0.32072324,0.44641179,0.57120271,0.71123702,0.86638585,0.9936203,1.0741076,1.1377616,1.296937,1.3983705,1.4803771,1.5198977,1.3616548,1.1936006,1.031797,0.93757853,0.77913279,0.61596037,0.47959902,0.32590396,0.16770894,-0.0037556139,-0.1456549,-0.15186168,-0.31502381,-0.47089297,-0.6146916,-0.77746396,-0.93186242,-1.0907657,-1.1424823,-0.95401005,-0.82097727,-0.64811859,-0.49310533,-0.37015462,-0.23579656,-0.115825,-0.18165786,-0.030936283,0.062363214,0.1818892,0.29661658,0.38735424,0.54016841,0.68856801,0.83749642,0.94210289,0.95888183,0.85035317,0.67941302,0.5140277,0.42327102,0.26195326,0.23314629,0.14193716,-0.0046548177,-0.1137707,-0.16899694,-0.32228913,-0.42277692,-0.55479903,-0.68481843,-0.8147599,-0.94773366,-1.0755841,-1.2135716,-1.3206909,-1.1682232,-1.0133929,-0.85291114,-0.66549244,-0.54034559,-0.37154661,-0.22560142,-0.069888779,0.053859667,0.14799997,0.3299276,0.44827161,0.57262774,0.6607903,0.75842664,0.89672829,1.0490268,1.0709733,1.1614261,1.3177263,1.4533607,1.6165511,1.7747359,1.9414956,2.00102,1.8407975,1.7094485,1.6202576,1.4329063,1.3895258,1.2108811,1.0410562,1.0185319,0.82658295,0.72946919,0.60725148,0.44313518,0.54251302,0.45697794,0.33716554,0.18086208,0.070945292,-0.1068646,-0.18488481,-0.32577089,-0.51369651,-0.68152413,-0.8509215,-1.0206104,-0.91235169,-0.75219141,-0.59933607,-0.45063296,-0.27639852,-0.18656746,-0.025412952,0.12344583,0.30651232,0.44611167,0.34700495,0.4514467,0.60172873,0.75624683,0.88021015,0.96436102,1.1103214,1.2773757,1.4495699,1.6141752,1.5602278,1.4004269,1.307818,1.1891722,1.0467423,1.0435984,0.93753955,0.80635933,0.66572061,0.66190146,0.70845504,0.58238226,0.45297872,0.41916417,0.31295612,0.19891692,0.086918777,-0.0089801627,0.14500405,0.093560846,-0.0070596257,-0.10537467,-0.19746567,-0.28476646,-0.38888462,-0.48423689,-0.57634743,-0.66210783,-0.76550534,-0.85159131,-0.9495776,-0.85899687,-0.78925078,-1.0165324,-1.1169427,-0.95711811,-0.83025262,-0.81420675,-0.67681927,-0.49883098,-0.32017449,-0.1415885,0.040148235,0.12064727,0.29569391,0.47468897,0.6549666,0.87525082,0.81996993,0.73012596,0.65372107,0.54618514,0.49130208,0.39901558,0.32229703,0.25417561,0.32656397,0.23192711,0.14682568,0.099399065,0.0022828173,-0.12401444,0.015418627,-0.04494491,-0.12327509,-0.21033897,-0.28758477,-0.35273101,-0.42540843,-0.47832276,-0.52983944,-0.55596996,-0.61334858,-0.70288499,-0.75462804,-0.82243315,-0.95863994,-0.83821823,-0.67255076,-0.65149271,-0.49977305,-0.34185251,-0.17213649,-0.21349676,-0.30780187,-0.36890877,-0.40632386,-0.48722861,-0.58445551,-0.71809391,-0.86964998,-0.81773607,-0.76761459,-0.86762627,-0.94051645,-0.99980354,-1.1234573,-1.1938431,-1.3047147,-1.3489604,-1.4760143,-1.5740649,-1.6866708,-1.801301,-1.8685926,-1.9374391,-1.9497273,-2.0522725,-2.0973031,-2.2185351,-2.2437831,-2.3348119,-2.361127,-2.4118129,-2.269045,-2.0758369,-1.8522227,-1.6296846,-1.4564483,-1.2307151,-1.0061054,-0.81397089,-0.60723272,-0.38135155,-0.15480069,0.071388821,0.29773659,0.52405185,0.75073504,0.97700095,1.2043091,1.4312859,1.6587062,1.8856808,2.1126719,2.3398933,2.566905,2.794331,3.0205149,3.0904981,3.1982126,3.2081955:1
2.2721466,2.2035244,2.1431741,2.1211666,2.066817,1.9951408,1.9118624,1.8609131,1.7829041,1.7487721,1.6954811,1.6587857,1.6866774,1.6440424,1.5939936,1.5269664,1.4595164,1.3937806,1.3081057,1.2217689,1.149948,1.0573362,0.98803021,0.91808325,0.85378568,0.78677544,0.71894845,0.64906774,0.59666846,0.53567853,0.48578201,0.4688585,0.43950868,0.41237482,0.37363758,0.34719367,0.29091259,0.25580188,0.22398329,0.17680276,0.15289326,0.061250643,0.0041258866,-0.096291571,-0.19760565,-0.30716458,-0.37317745,-0.44890884,-0.5044025,-0.54630882,-0.58634608,-0.62252315,-0.67471272,-0.71112937,-0.73055446,-0.76835081,-0.8407257,-0.85986623,-0.88662375,-0.91607164,-0.95545959,-0.97391242,-0.98428149,-0.99991455,-1.0222766,-1.0341776,-1.0433888,-1.0352831,-1.0487307,-1.047356,-1.0263441,-1.0263425,-0.97302861,-0.96024763,-0.95612453,-0.92127264,-0.92822858,-0.90637958,-0.91521176,-0.89837181,-0.88398016,-0.876823,-0.87451651,-0.86307725,-0.85423463,-0.86869987,-0.84917715,-0.87647964,-0.90110578,-0.89387429,-0.873055,-0.86113486,-0.79492995,-0.75864543,-0.7487502,-0.70986574,-0.6435845,-0.62384173,-0.56724622,-0.53506317,-0.51018038,-0.4831288,-0.45524797,-0.42642054,-0.40886639,-0.37807963,-0.35493969,-0.34969008,-0.33532456,-0.31862637,-0.31389074,-0.31983848,-0.34648331,-0.36338577,-0.39773847,-0.45432989,-0.51573243,-0.61887402,-0.68060794,-0.76414378,-0.8424596,-0.90102189,-0.93938194,-0.9073196,-0.86556648,-0.79904823,-0.74816618,-0.68827807,-0.63467166,-0.57565429,-0.51782158,-0.45746857,-0.39934517,-0.33743889,-0.29227264,-0.23894659,-0.17995964,-0.13168082,-0.069611401,-0.020425447,0.041067522,0.093372378,0.15489296,0.22939493,0.29182037,0.34118233,0.41678501,0.46945811,0.54464672,0.59473169,0.67170724,0.73511858,0.79995925,0.86366938,0.9078462,0.93128633,0.95096227,0.94604115,0.93519076,0.86719171,0.79503101,0.72328894,0.62660513,0.5753895,0.47625604,0.42930853,0.35202825,0.28065635,0.19234558,0.16482536,0.1442351,0.20156559,0.26178919,0.34050048,0.4308256,0.49997149,0.59750745,0.65536242,0.75377036,0.84761548,0.93590773,1.0224101,1.0938301,1.1416609,1.1982458,1.2341274,1.2804712,1.3192911,1.3214999,1.3506747,1.3572758,1.3333657,1.301959,1.2893006,1.2557089,1.2049376,1.1545631,1.0933581,1.0338731,0.97230767,0.91064291,0.85203166,0.78716452,0.73370085,0.66925708,0.61937752,0.55469255,0.49726519,0.44839592,0.37100824,0.30338243,0.22857934,0.16267032,0.091499677,0.013266051,-0.056343021,-0.13365283,-0.21712953,-0.28835872,-0.35620115,-0.42438544,-0.49341291,-0.48035905,-0.41812868,-0.33664255,-0.25492287,-0.19431388,-0.089871049,0.014538033,0.076624452,0.1377674,0.23750439,0.30189101,0.36625116,0.42877112,0.49671658,0.59055245,0.66092802,0.72453285,0.78503437,0.853441,0.91766198,0.97507275,1.0240261,1.0807185,1.1359133,1.1769919,1.15553,1.1583106,1.1346509,1.0958854,1.0624022,1.0204277,0.96632993,0.91542413,0.86211817,0.79719085,0.73000119,0.67099932,0.61370926,0.54769816,0.46883091,0.41339098,0.3215685,0.22391117,0.16816628,0.076709028,-0.019672826,-0.11203127,-0.16387546,-0.25608655,-0.30558053,-0.36849851,-0.42920544,-0.4954812,-0.56877697,-0.65797279,-0.72471279,-0.81676618,-0.90931918,-1.0011771,-1.0919108,-1.1867873,-1.2466645,-1.3332547,-1.4172812,-1.4948229,-1.5724815,-1.6503225,-1.7267378,-1.7972154,-1.8658804,-1.9346877,-1.9967141,-2.049586,-2.1103053,-2.170521,-2.207955,-2.2382927,-2.2039998,-2.1474842,-2.1194826,-2.0884331,-2.038104,-2.0060627,-1.9444047,-1.8713984,-1.7918543,-1.7005396,-1.6222602,-1.5480903,-1.475542,-1.399593,-1.3310604,-1.2306922,-1.1605826,-1.0810598,-1.0037857,-0.90461577,-0.83397871,-0.74908359,-0.66500537,-0.56046685,-0.46290761,-0.41312903,-0.35681387,-0.27443268,-0.22364557,-0.16955212,-0.16346201,-0.16172897,-0.17414572,-0.20185131,-0.22802983,-0.26450175,-0.29094663,-0.32215337,-0.34920078,-0.38313743,-0.41799821,-0.45028049,-0.4737763,-0.50757902,-0.54144195,-0.55877496,-0.58537649,-0.61200402,-0.6248786,-0.64746448,-0.66688775,-0.68734451,-0.71436082,-0.73579311,-0.76131264,-0.78357887,-0.80189429,-0.81421181,-0.83003715,-0.84662474,-0.86432741,-0.87846752,-0.89739451,-0.90952973,-0.91668662,-0.92342992,-0.92921818,-0.93065917,-0.92964569,-0.9173981,-0.90775702,-0.89346805,-0.87128167,-0.84472105,-0.82173251,-0.78966775,-0.75903812,-0.70645792,-0.64963076,-0.58340901,-0.51782158,-0.44534485,-0.37120253,-0.29483982,-0.22652472,-0.1497109,-0.079935622,0.0098937713,0.082369354,0.15055411,0.23925036,0.3203764,0.37921397,0.42860567,0.46459088,0.54871697,0.63775532,0.72808255,0.81629534,0.90373424,0.97915564,1.0320375,1.0813258,1.1653839,1.2545862,1.3212837,1.3875501,1.4305318,1.5023293,1.5559089,1.6034586,1.6445865,1.6819657,1.7182815,1.7332694,1.7399455,1.7189536,1.7139121,1.7259405,1.7862439,1.8950148,1.9669814,2.0653671,2.1409844,2.208378,2.2843114,2.3058689,2.3226079:2
1.9415264,1.8617847,1.7763839,1.6915915,1.5673699,1.5638291,1.4812648,1.3657956,1.2211792,1.1626482,1.0323454,0.91574706,0.79272117,0.91718966,1.0259469,0.96626676,0.88288826,0.79718635,0.70345279,0.6494686,0.54078003,0.52172673,0.4293673,0.31641974,0.17832677,0.070385313,0.035593634,0.20760152,0.36390958,0.528889,0.6788632,0.72450263,0.60863693,0.52186265,0.47314106,0.42165722,0.33495422,0.34509975,0.29098561,0.23947274,0.15194335,0.10328955,0.11159524,0.2407319,0.27584458,0.25992399,0.18360995,0.16496371,0.10065679,0.0024771279,-0.016864294,-0.071366781,-0.10698881,-0.15659806,-0.19734566,-0.25078152,-0.31854776,-0.40908859,-0.25496601,-0.1239643,0.044677484,0.18548112,0.35525825,0.49139674,0.6440584,0.80692031,0.89750209,0.8949801,0.80242368,0.73839751,0.69320753,0.80185395,0.78616449,0.70174247,0.60974451,0.55627171,0.44931927,0.34358796,0.28207922,0.45841562,0.58124927,0.54566978,0.58857708,0.52630356,0.47898336,0.41255238,0.31223236,0.20903329,0.088729606,-0.011883942,-0.035704115,-0.098195089,-0.20382066,-0.27801574,-0.36224156,-0.43977351,-0.49071959,-0.54111351,-0.56269101,-0.58239774,-0.64105412,-0.70680261,-0.735364,-0.78968267,-0.83997334,-0.88578309,-0.84377104,-0.81480465,-0.78633053,-0.62374428,-0.40968223,-0.32388223,-0.21279038,-0.050806843,0.096567359,0.24975538,0.41035699,0.61996935,0.71850838,0.87208271,1.0013078,1.1255766,1.3418382,1.4659778,1.5339067,1.5473167,1.4446583,1.2929441,1.1510733,0.96460976,1.144097,1.0930009,0.88617921,0.67261508,0.51503607,0.36984815,0.21459991,0.0032393353,-0.20587025,-0.36769482,-0.5672875,-0.77803714,-0.899607,-0.84027647,-0.81319963,-0.79370041,-0.78170537,-0.77645143,-0.76237968,-0.68857924,-0.66942776,-0.64146614,-0.61703898,-0.58115187,-0.5273495,-0.49510371,-0.45202274,-0.32584839,-0.17355259,-0.040855631,0.094132157,0.17219836,0.24977039,0.33610978,0.44371755,0.45653382,0.46252774,0.38566859,0.27233108,0.25393281,0.32333825,0.4243901,0.51807298,0.62763501,0.66818518,0.78471504,0.85603126,0.93253487,0.8624112,0.7362242,0.7496677,0.85877593,0.96477355,1.0540159,1.0332926,1.1087475,1.2079821,1.2465052,1.1662117,1.0402568,0.88070022,0.71838919,0.55183115,0.42065574,0.28462284,0.099886469,-0.052733891,-0.19543639,-0.37990044,-0.52438195,-0.54663308,-0.50111013,-0.41999076,-0.38501606,-0.30562516,-0.29015647,-0.26376677,-0.199206,-0.14270015,-0.015281134,0.055317512,0.13563039,0.12183253,0.0060402518,-0.053671752,0.030300558,0.12034759,0.22679728,0.30105359,0.28328746,0.37579053,0.46037475,0.39814213,0.4144125,0.52158282,0.63202895,0.58799011,0.5380244,0.36873888,0.21321759,0.0036576905,-0.029985494,0.06501462,0.19353289,0.27794732,0.31222233,0.44409398,0.54205131,0.68549232,0.7174894,0.71491163,0.62057095,0.59702244,0.74766554,0.85160027,0.88721107,1.0157999,1.1456665,1.294065,1.4333859,1.5360783,1.6791505,1.7691885,1.7772713,1.7673104,1.5991877,1.4362721,1.2940902,1.1331115,0.99658976,0.83723932,0.69437741,0.60062445,0.51413749,0.36374023,0.21285488,0.0677907,-0.096405489,-0.23204359,-0.27983017,-0.26956028,-0.36139531,-0.52456916,-0.6857021,-0.81713932,-0.98711154,-1.1183019,-1.2819722,-1.3766633,-1.488661,-1.6296574,-1.7909754,-1.9439385,-2.0872174,-2.2390446,-2.3926314,-2.5545062,-2.6203626,-2.5879685,-2.476023,-2.4365263,-2.2722165,-2.1073336,-1.9968442,-1.8857083,-1.7344049,-1.5589267,-1.5255932,-1.464062,-1.4593121,-1.5958117,-1.6002841,-1.4752781,-1.3383202,-1.1556206,-1.0115298,-0.89354645,-0.8079298,-0.86811003,-0.80675691,-0.69702074,-0.6456196,-0.54960965,-0.47666864,-0.37985308,-0.37425727,-0.49927111,-0.65118964,-0.75658235,-0.84300332,-0.90865161,-0.8106459,-0.65220245,-0.52559244,-0.44593551,-0.3091607,-0.20277745,-0.055636379,0.088424921,0.22014358,0.31979937,0.3830526,0.29243662,0.2323071,0.36382023,0.50199663,0.64867214,0.73993757,0.86666101,1.0642741,1.209757,1.3410064,1.5123848,1.6325986,1.7587067,1.7396763,1.6314066,1.4367129,1.2524859,1.1834146,1.1065754,0.9859822,0.86814658,0.75424455,0.56385909,0.56815496,0.54694403,0.38160535,0.18806487,-0.011132015,-0.17570928,-0.28161432,-0.4705879,-0.6085877,-0.73043909,-0.67392572,-0.54853847,-0.42767869,-0.27524853,-0.15447951,-0.13211762,-0.22218751,-0.30520373,-0.46309987,-0.49641039,-0.59271746,-0.7682467,-0.90642933,-1.0466775,-1.0300126,-0.97729232,-1.0582405,-1.1933468,-1.3289959,-1.4891893,-1.6178653,-1.7453755,-1.8732159,-2.014403,-2.130355,-2.2549587,-2.3892618,-2.4774429,-2.5116294,-2.6363019,-2.5755814,-2.7351377,-2.6432169,-2.4861312,-2.2730869,-2.1137452,-1.9513345,-1.7944132,-1.5947726,-1.4225705,-1.2608804,-1.0948299,-0.92792828,-0.76787253,-0.5584431,-0.44875592,-0.49620398,-0.38233935,-0.22224559,-0.059008293,0.14971273,0.312905,0.47376541,0.68026511,0.78354928,0.90520905,1.1102225,1.2815673,1.4855972,1.6961536,1.8559203,1.9787346:3
1.8057587,1.7072457,1.5988215,1.5002324,1.4177035,1.332263,1.2497281,1.1575148,1.0470536,0.95229241,0.85996062,0.78269943,0.73201915,0.70947328,0.6507417,0.51855749,0.38816174,0.28588658,0.18882503,0.083842445,-0.022255451,-0.06359414,-0.026053827,0.035628783,0.10505533,0.17377439,0.24754703,0.27467653,0.17366921,0.055824516,-0.050208427,-0.1461884,-0.25723921,-0.37364026,-0.46938996,-0.54843584,-0.66955751,-0.81556393,-0.93325765,-1.0521394,-1.1794922,-1.2987909,-1.4166114,-1.5385381,-1.6628306,-1.7809184,-1.8506384,-1.882679,-1.949703,-2.0249429,-1.9948535,-1.9252275,-1.816074,-1.7016508,-1.5828968,-1.4937775,-1.3849314,-1.2702024,-1.1542193,-1.0433849,-0.92708463,-0.81852032,-0.69537179,-0.58479432,-0.46808594,-0.35882139,-0.24232985,-0.1244294,-0.017993506,0.10286145,0.20895801,0.25306535,0.32664428,0.34881103,0.35989614,0.46281989,0.55320551,0.68052768,0.81232011,0.93109675,1.0394338,1.1455868,1.2470225,1.3523657,1.4787091,1.5987914,1.6477715,1.5790216,1.4837235,1.3920794,1.3016388,1.204962,1.0997833,1.0175263,1.0004245,0.90949959,0.82475422,0.77941221,0.72743349,0.66628499,0.58628602,0.52868999,0.55527312,0.64319719,0.71556421,0.77734154,0.86219893,0.88126969,0.80635364,0.72621074,0.66121406,0.60961028,0.53957199,0.47337435,0.38293973,0.26263528,0.14541372,0.05945433,0.018674189,-0.024172701,-0.08804299,-0.18367161,-0.25884259,-0.36168751,-0.43870914,-0.54524199,-0.64928518,-0.69655644,-0.73481238,-0.80233005,-0.78165795,-0.69406441,-0.5717787,-0.46559152,-0.33481095,-0.20780233,-0.072889157,0.033129486,0.13538502,0.22109139,0.32230819,0.43793998,0.55915977,0.66746079,0.7747786,0.87357276,0.98327651,1.078683,1.0856617,1.0112625,0.89494984,0.81182833,0.70548059,0.61852662,0.54176844,0.46362095,0.42179862,0.39000433,0.31797039,0.21447112,0.094657776,-0.0043670805,-0.076928514,-0.085005214,-0.060950802,-0.11111825,-0.18902522,-0.29629119,-0.40754688,-0.5061248,-0.61210257,-0.710677,-0.79014147,-0.89058865,-0.99180619,-1.0976473,-1.1965388,-1.3036521,-1.3527874,-1.4282599,-1.3540728,-1.2854019,-1.3117953,-1.3986091,-1.4789292,-1.5760227,-1.6405477,-1.6881726,-1.7833652,-1.8413053,-1.9200971,-1.8125475,-1.6875232,-1.564169,-1.4222042,-1.3677765,-1.2356023,-1.1025296,-0.95928864,-0.83502228,-0.6920565,-0.53097589,-0.40290556,-0.24645333,-0.086089282,0.074145266,0.21571586,0.35665129,0.51702352,0.63932992,0.79996211,0.94162657,1.0832989,1.2249419,1.3669549,1.5280537,1.6895783,1.8340557,1.9568465,2.0607984,2.1465857,2.1228461,2.0613991,1.9604688,1.8172781,1.6741004,1.5493857,1.4062619,1.2804098,1.1503239,1.0149979,0.87250204,0.74867756,0.58764555,0.44536306,0.30309729,0.16068857,0.0033269958,-0.14261173,-0.30391557,-0.4469961,-0.6086078,-0.75184172,-0.89526169,-1.0385798,-1.1818816,-1.3251341,-1.4682799,-1.4627444,-1.3446778,-1.348926,-1.2847047,-1.2206645,-1.2268447,-1.2631417,-1.3462005,-1.3072512,-1.2958781,-1.2198495,-1.1311217,-1.0395608,-0.93919431,-0.83298151,-0.73761958,-0.64527002,-0.54995886,-0.49382371,-0.50116961,-0.51917172,-0.46401106,-0.37528252,-0.28217026,-0.23397773,-0.1390706,-0.06036083,0.038659147,0.11918583,0.23737993,0.29348249,0.21375754,0.10128411,-0.013879378,-0.12541829,-0.23540213,-0.34676496,-0.46572712,-0.57795193,-0.68722237,-0.80628041,-0.87961707,-0.87946486,-0.90873424,-0.96088627,-0.90637088,-0.93148361,-0.8926118,-0.84859269,-0.73538512,-0.62145174,-0.50418797,-0.36019879,-0.24623655,-0.16861145,-0.10423014,-0.0096830703,0.049451437,0.14531157,0.20147284,0.32258811,0.3152351,0.38117068,0.43128346,0.51100732,0.57556237,0.66107768,0.76101436,0.81952091,0.83816402,0.76117925,0.69709446,0.63322597,0.56492364,0.56824326,0.63689904,0.69926938,0.74731235,0.80480959,0.86432213,0.92726197,0.98232495,1.0370601,1.0446142,1.0991283,1.1717893,1.2423372,1.3038314,1.3881794,1.4743293,1.5583787,1.6454548,1.6327935,1.5213797,1.401312,1.2789158,1.1959846,1.0450011,0.93253153,0.8643169,0.79627041,0.69052077,0.5480091,0.41527977,0.31456941,0.17991089,0.055339989,-0.071043539,-0.11695485,-0.13941461,-0.17593123,-0.26387256,-0.39593122,-0.52455382,-0.63903166,-0.76358733,-0.88979025,-1.0018215,-1.1103048,-1.2240592,-1.3474098,-1.4669248,-1.5935977,-1.6217312,-1.7039429,-1.7982234,-1.8948948,-1.9859503,-1.9840624,-1.9029885,-1.8393551,-1.7611521,-1.6848406,-1.576378,-1.4583469,-1.3537835,-1.2430914,-1.1363794,-1.0168213,-0.90593967,-0.79305227,-0.68640766,-0.57402868,-0.46157339,-0.36700055,-0.25754568,-0.13754562,-0.02714402,0.095575578,0.21324677,0.33623264,0.45953898,0.58360977,0.70879079,0.80617435,0.76419175,0.66480861,0.57833918,0.53684434,0.51751165,0.52668497,0.56832246,0.63587774,0.70929703,0.7845296,0.86983828,0.96037326,1.0445608,1.1240499,1.1233775,1.1549697,1.2203715,1.2817196,1.3699923,1.4400174,1.4771097,1.5711359,1.685517,1.7927148:5
-0.65526357,-0.63218472,-0.60342886,-0.58630521,-0.5654588,-0.55108374,-0.5446006,-0.53911499,-0.52418407,-0.51335592,-0.52190982,-0.53697664,-0.56257689,-0.58414367,-0.61571394,-0.65466971,-0.69240405,-0.74392626,-0.80089485,-0.86151932,-0.9223706,-0.98204653,-1.0277214,-1.0926619,-1.1351636,-1.1570463,-1.0801398,-1.0172215,-0.95297748,-0.88095335,-0.80422123,-0.73550895,-0.67241745,-0.61005481,-0.53593344,-0.45936029,-0.39511585,-0.32369941,-0.25644991,-0.18996657,-0.12428273,-0.048838579,0.026093585,0.10290389,0.16616703,0.24635893,0.32438526,0.38735317,0.45951324,0.52384804,0.58748089,0.64130921,0.70353112,0.76273512,0.8198547,0.87401497,0.9250141,0.97657446,1.0162377,1.0585437,1.1051269,1.1379792,1.1690156,1.2137483,1.250033,1.2865109,1.3157874,1.3314002,1.328026,1.3168988,1.3041889,1.294823,1.3037859,1.3198188,1.3728171,1.4180943,1.4681328,1.516706,1.5566875,1.5947021,1.6376025,1.6813657,1.7186595,1.7508498,1.7843852,1.8044759,1.806133,1.7875355,1.7537789,1.7137137,1.6635321,1.6292321,1.5843713,1.5635614,1.5630362,1.5760416,1.578277,1.5700188,1.5343025,1.4934686,1.4414632,1.3873471,1.3487912,1.2765648,1.2222789,1.1596722,1.1019253,1.0211848,0.96482424,0.88350586,0.82743878,0.74725027,0.68814187,0.65119923,0.57131087,0.4889376,0.4232603,0.36695983,0.30483917,0.2363639,0.17032143,0.10357452,0.019130065,-0.05327988,-0.13133069,-0.19784503,-0.26505061,-0.3253093,-0.37949793,-0.43332563,-0.51556901,-0.58203788,-0.64471263,-0.72899186,-0.79515363,-0.86478156,-0.92908088,-0.98352187,-1.0539617,-1.1341374,-1.0836014,-1.0249065,-0.95901236,-0.90722181,-0.85341835,-0.80894699,-0.74695636,-0.68857346,-0.63501314,-0.57069553,-0.51895962,-0.46472064,-0.40830179,-0.34632957,-0.29154472,-0.23679978,-0.18959027,-0.13235306,-0.081254661,-0.03289985,0.0094436519,0.03116547,0.042003546,0.055125911,0.064883056,0.060876263,0.049516575,0.025371491,-0.014044891,-0.039179408,-0.068124601,-0.097564723,-0.13383329,-0.15143525,-0.17766996,-0.21774385,-0.25985579,-0.29024326,-0.32520649,-0.36634272,-0.38673095,-0.42328615,-0.45848168,-0.47867745,-0.51400248,-0.55877179,-0.58623788,-0.61842582,-0.65795231,-0.69525497,-0.73043035,-0.77321387,-0.81240611,-0.85034801,-0.88604222,-0.88921188,-0.91506562,-0.93626391,-0.95720561,-0.98289085,-1.0061984,-1.0228667,-1.0443392,-1.0668593,-1.0909249,-1.1138851,-1.1376678,-1.160055,-1.1812648,-1.1983532,-1.2137108,-1.2347721,-1.2627103,-1.2851652,-1.3024109,-1.3202602,-1.3375969,-1.3633676,-1.3738964,-1.3950395,-1.4210304,-1.4449935,-1.4433126,-1.4375458,-1.4229275,-1.3949832,-1.36772,-1.330063,-1.2760156,-1.2355442,-1.1934177,-1.1301096,-1.0775827,-1.0139232,-0.95478667,-0.90331922,-0.84585146,-0.7842014,-0.72179674,-0.66354361,-0.6019751,-0.54472284,-0.47708927,-0.41048017,-0.35305869,-0.29588688,-0.22501792,-0.16621098,-0.12073958,-0.061783974,-0.029503789,-0.016777405,-0.0041207727,0.012589061,0.018580851,0.01911604,0.01881247,0.015779284,0.028520834,0.046164247,0.074300934,0.096357346,0.1175576,0.14380026,0.16384466,0.17669309,0.18881268,0.21523125,0.24799458,0.28712308,0.31884417,0.35960196,0.39065738,0.42373813,0.45291918,0.48896036,0.5280584,0.56362342,0.59357415,0.6299722,0.66243942,0.69331958,0.72778376,0.76205514,0.78742355,0.81505264,0.85465038,0.87807314,0.91379283,0.94228819,0.95171088,0.95059643,0.95077718,0.95494315,0.95387439,0.936312,0.91382595,0.89873709,0.87733692,0.87329578,0.92549705,0.96913745,1.0130888,1.0582022,1.0999429,1.1538796,1.2046207,1.2581775,1.3128688,1.3618629,1.4328667,1.4983095,1.5486351,1.6160218,1.6703482,1.7372477,1.7990005,1.8679041,1.9337484,1.9880458,2.0403403,2.0442124,2.0460634,2.0408572,1.988812,1.9228499,1.8510108,1.7978272,1.7325864,1.6785006,1.6149975,1.5619765,1.5043305,1.4523768,1.3943806,1.342218,1.2726648,1.2086732,1.1525172,1.0903244,1.0377853,0.9698674,0.90160638,0.83642226,0.74875262,0.68165264,0.63774709,0.58514882,0.50965311,0.44378255,0.38895554,0.35869884,0.32898891,0.29111512,0.24411387,0.20644788,0.14571388,0.11683578,0.073365763,0.020157436,-0.052380913,-0.10109862,-0.149755,-0.21914381,-0.26870369,-0.34394576,-0.39827689,-0.44569909,-0.51406057,-0.58363659,-0.61045948,-0.62799064,-0.63953635,-0.66020153,-0.674577,-0.69829787,-0.71721761,-0.74305748,-0.77698334,-0.81782187,-0.87749878,-0.92987536,-0.96286626,-1.0178896,-1.0844293,-1.1455103,-1.2001343,-1.2592634,-1.3196088,-1.3779969,-1.4364188,-1.4912509,-1.5440603,-1.607713,-1.6596167,-1.6787436,-1.6619755,-1.641635,-1.6132862,-1.588779,-1.5623175,-1.5400853,-1.5000756,-1.4680989,-1.4407345,-1.4134946,-1.3794288,-1.3412715,-1.3067648,-1.2702952,-1.2309398,-1.196406,-1.1580087,-1.1262657,-1.0794462,-1.046721,-1.0161434,-0.97962331,-0.93860512,-0.89764127,-0.85998421,-0.82559337,-0.79108998,-0.7583531,-0.72325433,-0.69288868,-0.66746097:2
0.97246861,0.92743685,0.88143796,0.81049575,0.75259897,0.69046473,0.61769564,0.5346564,0.45429271,0.37396,0.30395292,0.24139234,0.19396336,0.15175853,0.092578736,0.0070131557,-0.10339802,-0.22002056,-0.33630498,-0.44917836,-0.56267923,-0.69181902,-0.8097734,-0.9581224,-1.0826419,-1.2260414,-1.3494421,-1.4842709,-1.6185342,-1.7038192,-1.8187493,-1.9567514,-2.0692072,-2.1825643,-2.3024691,-2.4000424,-2.4349141,-2.3268474,-2.2110012,-2.1000093,-1.9856608,-1.878927,-1.7681374,-1.6581795,-1.5452565,-1.4239557,-1.3029131,-1.1955384,-1.0760337,-0.95776723,-0.8481707,-0.72885561,-0.61322811,-0.49988913,-0.3823226,-0.26829067,-0.15003287,-0.032466465,0.08011785,0.19779156,0.30940882,0.4179201,0.53207101,0.5688428,0.56468463,0.54808015,0.52455371,0.49911391,0.45895564,0.42584211,0.3931465,0.354164,0.32898285,0.29213726,0.24335716,0.1650053,0.076576098,0.012341324,-0.055600264,-0.11596279,-0.18000272,-0.24182984,-0.28402236,-0.34085712,-0.39855312,-0.45826713,-0.51891153,-0.56627062,-0.62070403,-0.66724324,-0.73023054,-0.77371626,-0.8144671,-0.85316488,-0.80766577,-0.71815426,-0.62864677,-0.54646127,-0.45942735,-0.3581635,-0.27207851,-0.1715165,-0.077352366,0.031113928,0.15942259,0.28080137,0.41821472,0.54368926,0.61672015,0.67710734,0.72205611,0.73077631,0.74087196,0.75384173,0.77149831,0.7932934,0.81953845,0.85099982,0.88585963,0.92172882,0.94564258,0.92630696,0.87813046,0.86048226,0.8549083,0.86145385,0.86209585,0.85558789,0.86200862,0.85468759,0.86182466,0.85093673,0.84695524,0.88439642,0.99228764,1.0963082,1.1710344,1.218091,1.3226877,1.4371201,1.554393,1.6748533,1.7854868,1.8940935,1.9727674,2.0412344,2.0782239,2.08023,2.0044267,1.8907617,1.7726435,1.6621942,1.54196,1.433444,1.3191867,1.2045449,1.0909906,1.1370418,1.1751424,1.2059044,1.2120751,1.183574,1.1620156,1.1246421,1.0619112,0.97895494,0.90468533,0.87109497,0.85269728,0.8378908,0.81641208,0.78132346,0.74455598,0.72470666,0.73367893,0.74255405,0.75407601,0.76838195,0.77104876,0.7634418,0.75080844,0.73312301,0.71113689,0.69913404,0.65947075,0.5990898,0.56229699,0.49600092,0.43804179,0.37323295,0.29479923,0.21264304,0.10352568,-0.032044716,-0.14033705,-0.24773304,-0.35402082,-0.45196285,-0.54026979,-0.63790373,-0.69947481,-0.65190064,-0.62256482,-0.58946325,-0.52557225,-0.46855517,-0.42004611,-0.36737943,-0.31501363,-0.26041097,-0.21461397,-0.19007171,-0.20890379,-0.17496182,-0.10314116,0.020094855,0.1815262,0.30099331,0.38363312,0.47883844,0.56994636,0.65804335,0.7255525,0.7978199,0.84811137,0.85561822,0.85951662,0.81646981,0.67899193,0.58464162,0.47199419,0.35391268,0.43065427,0.5217485,0.61586224,0.67697504,0.7364349,0.76362629,0.79207033,0.79048238,0.77861358,0.69887471,0.57497062,0.46198717,0.34916614,0.23593613,0.11933937,0.0035995276,-0.1140812,-0.23040405,-0.34179838,-0.45645972,-0.56599261,-0.68983477,-0.80098611,-0.91969329,-1.0315412,-1.1507267,-1.2604413,-1.3809332,-1.4911123,-1.6117431,-1.7206444,-1.842919,-1.9495812,-2.0642772,-2.1763409,-2.2895145,-2.398984,-2.4776363,-2.4210072,-2.3356415,-2.2583119,-2.1475725,-2.0321436,-1.909425,-1.7864734,-1.6826039,-1.5628033,-1.4647937,-1.3479696,-1.2357918,-1.1011238,-0.99686356,-0.86242086,-0.74300483,-0.65282536,-0.53933626,-0.41869977,-0.29557376,-0.21942814,-0.13997987,-0.076643674,-0.1112219,-0.17716381,-0.25468271,-0.24483284,-0.17672047,-0.085583428,-0.0078253134,0.0685287,0.16036442,0.23773172,0.31071256,0.37205649,0.42825756,0.47126781,0.41025945,0.34297395,0.25776643,0.17279577,0.070358052,-0.032050307,-0.13205893,-0.23579747,-0.36591836,-0.49376185,-0.62205485,-0.74956013,-0.87870928,-1.0360672,-1.1939702,-1.321751,-1.4447879,-1.5655554,-1.6639305,-1.6242,-1.5203376,-1.4020923,-1.2918091,-1.1686462,-1.0514551,-0.90942771,-0.79040418,-0.67360277,-0.55115657,-0.42742714,-0.32368445,-0.20005363,-0.082651151,0.028685556,0.13358806,0.24274198,0.34958438,0.45724236,0.55489477,0.66021093,0.74621844,0.85064159,0.9522455,1.0514912,1.1496126,1.240729,1.3299354,1.328333,1.2701583,1.21396,1.1961963,1.29526,1.4070781,1.4782896,1.5255108,1.5052692,1.4492091,1.3545586,1.2420782,1.1602465,1.0960477,0.97990916,0.88767863,0.78695657,0.81781945,0.9475717,1.07655,1.1784697,1.301971,1.3282605,1.2782634,1.184383,1.0788272,0.9858651,0.89454725,0.78690331,0.69012508,0.59624638,0.48722021,0.38883892,0.28762549,0.18749241,0.083134326,-0.022438721,-0.13663184,-0.24172301,-0.3654454,-0.4750511,-0.58758427,-0.71567089,-0.83802899,-0.96597091,-1.0844753,-1.2051473,-1.3110264,-1.4122897,-1.5105299,-1.5696887,-1.467559,-1.334247,-1.1978784,-1.047814,-0.91886639,-0.76112024,-0.63023587,-0.49900001,-0.36778556,-0.24013559,-0.13485239,-0.0024994449,0.12126144,0.22180283,0.31901784,0.4175258,0.51655639,0.61064419,0.70772764,0.79839236,0.89519105,0.98637099:2
2.2224305,2.1504594,2.1374338,2.0778707,2.004239,1.9390537,1.8751145,1.80102,1.737884,1.6703729,1.5978763,1.5277941,1.4586257,1.391481,1.3160188,1.2496567,1.1830588,1.1238173,1.0475294,0.9771622,0.90433626,0.8625701,0.8510054,0.83723994,0.8179897,0.78989301,0.75105937,0.70227465,0.65225295,0.61464104,0.58991421,0.55235835,0.50488225,0.43671931,0.36055462,0.29526039,0.22679866,0.16388336,0.11222454,0.079197011,0.0025742813,-0.07488859,-0.14149275,-0.21604525,-0.28292029,-0.31534552,-0.34227109,-0.31400314,-0.28322033,-0.33887972,-0.41038693,-0.4827868,-0.56167732,-0.63942889,-0.72789384,-0.75990722,-0.76069957,-0.76219485,-0.76430144,-0.77804595,-0.77757225,-0.78011377,-0.77933191,-0.77717041,-0.78248244,-0.77908655,-0.78911649,-0.78187744,-0.7665124,-0.75193686,-0.72903656,-0.68946241,-0.65218265,-0.61271197,-0.57533481,-0.54579603,-0.53500084,-0.5469887,-0.55004681,-0.59238551,-0.59298727,-0.56454483,-0.53295212,-0.51201871,-0.49480182,-0.46209417,-0.4424471,-0.40608778,-0.38711207,-0.36962423,-0.35472418,-0.35090803,-0.33017397,-0.31131168,-0.33485337,-0.38390121,-0.44389122,-0.50925339,-0.58595451,-0.66240515,-0.72957805,-0.80685601,-0.88216259,-0.95895313,-1.029071,-1.0960195,-1.1664153,-1.2349237,-1.3113433,-1.3832395,-1.4535352,-1.5327387,-1.6014529,-1.6719458,-1.7385739,-1.8157484,-1.8880248,-1.9590017,-1.9548926,-1.8742369,-1.8056233,-1.7279365,-1.6360341,-1.5633431,-1.4963865,-1.4212448,-1.3402331,-1.2803158,-1.1826732,-1.0946878,-1.0373977,-0.95841786,-0.87494242,-0.7800802,-0.69628291,-0.59974381,-0.52190568,-0.42390173,-0.34359754,-0.24768259,-0.17611641,-0.098807927,-0.032903779,0.034852756,0.093207116,0.12995083,0.166211,0.20969943,0.27136977,0.33802183,0.40253333,0.47920156,0.55027897,0.61162623,0.66805102,0.71716464,0.76363964,0.80467159,0.83107339,0.81715596,0.79063639,0.7636111,0.73434039,0.70395554,0.6669128,0.62299414,0.57356005,0.52343155,0.4734169,0.43206997,0.37946541,0.3328884,0.26139077,0.18484733,0.13402032,0.087358549,0.048834824,0.024203616,0.029707442,0.096584381,0.15173861,0.23303803,0.30534476,0.37382674,0.44842895,0.51787032,0.59837745,0.6556109,0.73640168,0.7984988,0.86267739,0.92915994,0.99824632,1.0722198,1.1319709,1.1929407,1.2568622,1.314375,1.3736361,1.4311053,1.4979259,1.5500954,1.6128192,1.6678446,1.7275105,1.7687002,1.7707338,1.7672905,1.7547652,1.7356205,1.7192257,1.6906299,1.6552914,1.6099536,1.5622708,1.5133953,1.4582566,1.4080522,1.3629575,1.3091244,1.2590835,1.1895339,1.1601702,1.1719525,1.1931308,1.2056593,1.223175,1.1789272,1.1041428,1.0436492,0.9692958,0.90321224,0.83268495,0.76268793,0.69215248,0.62097006,0.55498893,0.48429166,0.41007033,0.34947284,0.27739524,0.20701404,0.13793143,0.072712805,0.0068458849,-0.060150761,-0.13404682,-0.19899232,-0.27468448,-0.34383487,-0.41232994,-0.4828777,-0.54659152,-0.61382282,-0.67942285,-0.75493714,-0.81978088,-0.88919561,-0.96513267,-1.0271327,-1.097064,-1.1678267,-1.2436153,-1.3053117,-1.3758699,-1.4403181,-1.5156785,-1.580391,-1.634046,-1.5983601,-1.5279597,-1.4345307,-1.3764853,-1.300273,-1.2185039,-1.1368248,-1.0696334,-0.98551771,-0.90210712,-0.8192122,-0.73619151,-0.64434464,-0.55412476,-0.45488838,-0.35668896,-0.25739408,-0.18192743,-0.10915659,-0.052825871,-0.0049643147,0.05190743,0.070776643,0.074481996,0.066706247,0.044709588,0.020174493,-0.012633583,-0.052450454,-0.090928065,-0.12474936,-0.15775213,-0.1793113,-0.16780948,-0.13566222,-0.11676459,-0.14107207,-0.1715783,-0.21617721,-0.26066134,-0.30619946,-0.35132968,-0.41403796,-0.47644052,-0.5196385,-0.56784141,-0.62196019,-0.67512626,-0.7191243,-0.77546491,-0.82698491,-0.88696551,-0.94549425,-1.0017709,-1.0553863,-1.1086351,-1.1734893,-1.2227147,-1.2654927,-1.3010882,-1.346202,-1.3809528,-1.4069853,-1.4260353,-1.4498149,-1.4632892,-1.4743588,-1.4902679,-1.5157545,-1.5285732,-1.5623227,-1.5439445,-1.4927288,-1.4446547,-1.396319,-1.3367803,-1.2820154,-1.225182,-1.1618154,-1.0960646,-1.0221107,-0.96738303,-0.90203663,-0.83464928,-0.75925903,-0.68655034,-0.62201481,-0.5635577,-0.52701019,-0.50131709,-0.48480253,-0.4698133,-0.44670211,-0.44125364,-0.424936,-0.42281952,-0.41407039,-0.41080338,-0.41483549,-0.36938129,-0.33232747,-0.2866811,-0.24685339,-0.20665065,-0.17435326,-0.14380402,-0.11850937,-0.094489708,-0.084602042,-0.078787621,-0.10374295,-0.056366181,0.01776751,0.090306989,0.15538503,0.22214417,0.29072368,0.35182638,0.41497996,0.47636591,0.53934052,0.59073033,0.64599926,0.70185927,0.75366176,0.81231779,0.85370022,0.8860407,0.91501144,0.94325924,0.96781994,0.97881558,0.97805939,0.97999374,0.9688254,0.94933574,0.92836954,0.97936989,1.0499838,1.125614,1.1989356,1.2590748,1.3347951,1.4020936,1.4661799,1.5336222,1.5983174,1.6577067,1.7272435,1.7857812,1.8500949,1.9119551,1.9760089,2.0428678,2.1030977,2.1474529,2.1880425,2.2107495:2
1.4728153,1.3881829,1.2951223,1.2150456,1.2242182,1.221252,1.1418981,1.0661825,0.97840274,0.89086247,0.80675668,0.71940371,0.63014685,0.53123658,0.44495899,0.35969318,0.27225764,0.18903573,0.11481446,0.052486374,0.031707059,0.063982882,0.099351177,0.14960348,0.20008179,0.26653748,0.33747508,0.40965254,0.50261584,0.57919448,0.63034418,0.73024248,0.83024936,0.85093182,0.87643173,0.77693848,0.65145103,0.55089951,0.42568999,0.35086384,0.22584748,0.10045921,-0.024847959,-0.12448593,-0.22650521,-0.34901834,-0.44782301,-0.54598742,-0.62258579,-0.70421676,-0.7702223,-0.83504036,-0.90773894,-0.98089573,-1.0551826,-1.1361497,-1.2098014,-1.2862732,-1.3721593,-1.4578169,-1.5401151,-1.6228404,-1.7037096,-1.7805189,-1.846711,-1.9015645,-1.963639,-2.0186224,-2.0537336,-2.0852769,-2.0887407,-2.0838411,-2.0309581,-1.9557627,-1.8863194,-1.7831585,-1.6961338,-1.6064794,-1.5093808,-1.420926,-1.3351869,-1.2528766,-1.1635796,-1.0829954,-0.99783593,-0.91091864,-0.82811957,-0.74149482,-0.65324912,-0.57002307,-0.48200204,-0.39863481,-0.31161019,-0.23119052,-0.14542415,-0.060056891,-0.022271178,0.064312046,0.15553868,0.23907157,0.32357926,0.41074441,0.4943237,0.56911517,0.59280501,0.65471518,0.60821148,0.54914982,0.47683771,0.40030032,0.32653161,0.24718071,0.18848125,0.13283828,0.11678155,0.2114286,0.3016061,0.30121022,0.30333198,0.30249188,0.25765248,0.19137692,0.1323581,0.074718066,0.020112859,-0.030178361,-0.078854471,-0.13039124,-0.17545775,-0.21595672,-0.25724498,-0.29907369,-0.3385138,-0.38085552,-0.41323258,-0.45664014,-0.48193843,-0.49165215,-0.50102431,-0.51745913,-0.52112484,-0.49853884,-0.47790259,-0.48158949,-0.52246492,-0.54371581,-0.56265185,-0.58416189,-0.606594,-0.62374626,-0.62873178,-0.64559973,-0.66178549,-0.661805,-0.66214556,-0.69523307,-0.68693558,-0.64722063,-0.58352278,-0.49829362,-0.41760001,-0.32644104,-0.23488288,-0.14444518,-0.056039008,0.031409804,0.12112472,0.2080171,0.29614058,0.38557256,0.47795816,0.56707367,0.60909474,0.69893231,0.78719204,0.87829662,0.96673289,1.0623983,1.1557131,1.2469162,1.335149,1.4214583,1.4781683,1.5594674,1.6503165,1.7341529,1.8207771,1.739017,1.6834206,1.6005192,1.5549949,1.6461543,1.7299574,1.7186513,1.7392612,1.7722643,1.7777114,1.7616236,1.7664298,1.7608333,1.7395665,1.7258501,1.6909625,1.6536739,1.6147027,1.564552,1.5105148,1.4579222,1.4003632,1.3560234,1.3026102,1.254855,1.2265219,1.1747055,1.1360208,1.1006135,1.0767857,1.0456462,1.0150433,0.99086909,0.95757597,0.95263216,0.94507758,0.94474736,0.93801431,0.94123779,0.93680936,0.95861019,0.9824774,1.0135802,1.0495852,1.0960509,1.1314729,1.1525557,1.1213092,1.059118,0.9972722,0.92733056,0.86619934,0.80184256,0.74030738,0.67533989,0.60840474,0.53165697,0.46088876,0.39960101,0.34269283,0.28058549,0.22197695,0.15872575,0.095578921,0.013692307,-0.068817832,-0.19336089,-0.29677449,-0.39709615,-0.47577959,-0.5333097,-0.59113061,-0.64773124,-0.69409363,-0.73190948,-0.75920061,-0.791742,-0.81873754,-0.8272066,-0.84394027,-0.85374489,-0.855078,-0.85374205,-0.85862887,-0.84888819,-0.83641444,-0.82558302,-0.80520247,-0.78139381,-0.74389516,-0.69893173,-0.65509013,-0.60806821,-0.54622693,-0.49006446,-0.42022099,-0.35533468,-0.26348204,-0.17266115,-0.098135105,4.1448905E-4,0.089813265,0.071487595,-0.020712676,-0.1101521,-0.14690619,-0.14147091,-0.092639791,-0.020534018,0.048215177,0.1138543,0.19073149,0.29802769,0.38132376,0.42307607,0.46603999,0.50416201,0.56823497,0.5542366,0.49404196,0.42062671,0.34495618,0.25690101,0.13917743,0.040705413,-0.064709936,-0.16435356,-0.25273323,-0.26571091,-0.32002101,-0.44169581,-0.53886193,-0.6577608,-0.77310605,-0.87821537,-0.98065134,-1.0803467,-1.1839051,-1.2855692,-1.3831096,-1.4824257,-1.5835439,-1.6742313,-1.7781795,-1.8607876,-1.9457484,-2.0279175,-2.1072539,-2.1754845,-2.230577,-2.263112,-2.2808286,-2.2702092,-2.2355057,-2.1896518,-2.1386393,-2.0778088,-2.0041246,-1.9298874,-1.8532684,-1.7752689,-1.7007039,-1.6191006,-1.5302881,-1.4489323,-1.37076,-1.2927411,-1.2045061,-1.1161226,-1.0310425,-0.95321472,-0.85422555,-0.7777021,-0.68885558,-0.59790042,-0.51523799,-0.42619631,-0.33893281,-0.25225672,-0.15934266,-0.069618534,0.024288084,0.1147623,0.080223711,0.026943793,0.065448865,0.15297686,0.23914338,0.33002546,0.41671889,0.46751223,0.51982802,0.608221,0.69939024,0.79147548,0.80990005,0.72022554,0.63178519,0.54875382,0.45931924,0.3582837,0.27771272,0.18963605,0.10145727,0.0040329745,-0.079901196,-0.13325231,-0.15827419,-0.15737236,-0.14082857,-0.099912736,-0.01114287,0.10088257,0.19804741,0.28449362,0.38323204,0.48702522,0.57127099,0.66961439,0.77404483,0.85924766,0.95267278,1.0435948,1.1313932,1.2208441,1.2818297,1.2046107,1.1400266,1.1217054,1.1845458,1.2813325,1.3723192,1.4745256,1.565375,1.6536444,1.6753049,1.6100141,1.5386266,1.4855019,1.5263006:4
1.6500396,1.5920584,1.5407896,1.4992257,1.4025696,1.2724297,1.1627442,1.0535208,1.0136983,1.0575509,1.1309864,1.2245327,1.3054381,1.3749882,1.271936,1.138323,0.99871444,0.89149901,0.77945109,0.66310313,0.54037416,0.40105896,0.26162275,0.12216019,0.021152983,-0.047678447,-0.11463539,-0.16196712,-0.15716402,-0.10543589,-0.043941041,0.036283255,0.10964905,0.19466872,0.28280526,0.39082358,0.48918245,0.60381646,0.74095188,0.82949398,0.93025428,0.87095065,0.78171085,0.68762075,0.59432207,0.47708925,0.35472855,0.22173779,0.095417441,0.08646593,0.023394764,-0.087724331,-0.20069046,-0.31242905,-0.40732615,-0.51418819,-0.62987308,-0.7389603,-0.8521931,-0.95117789,-1.0608539,-1.1615973,-1.2629633,-1.3884079,-1.5059119,-1.6064202,-1.7072651,-1.8108651,-1.8740772,-1.9353385,-2.0250801,-2.0585282,-2.050211,-1.9797859,-1.8780609,-1.7733112,-1.6470499,-1.5419687,-1.4416225,-1.3398517,-1.2358632,-1.1398721,-1.0308659,-0.92869325,-0.83107273,-0.79951695,-0.68806017,-0.57839071,-0.47541489,-0.38243232,-0.283162,-0.18248867,-0.095567598,0.0091896903,-0.056839993,-0.13017894,-0.22336977,-0.31289646,-0.39181962,-0.47808247,-0.5574545,-0.63606901,-0.69057063,-0.67000075,-0.57870262,-0.64522,-0.73031629,-0.80056484,-0.87993487,-0.95046311,-1.0135706,-1.0716924,-1.122003,-1.1736751,-1.2282864,-1.2721141,-1.3158531,-1.3462851,-1.3791595,-1.4112644,-1.4281016,-1.4508633,-1.4734425,-1.4881435,-1.482857,-1.4480128,-1.3580035,-1.2781277,-1.1710363,-1.0727591,-0.9660653,-0.89791279,-0.80217528,-0.72712151,-0.66821985,-0.61763942,-0.57599069,-0.52736227,-0.48164865,-0.4018686,-0.34368287,-0.31145133,-0.27703459,-0.24408794,-0.23287712,-0.25550336,-0.24972513,-0.23724944,-0.17941362,-0.19245023,-0.2020366,-0.21611083,-0.21908348,-0.22170834,-0.20921589,-0.20508056,-0.19416989,-0.17498026,-0.15972429,-0.12703671,-0.093873195,-0.03370602,0.074416244,0.18782775,0.28067158,0.38377767,0.49149446,0.57505685,0.65435707,0.72182395,0.81160212,0.89046115,0.88994409,0.8903053,0.89635762,0.90504839,0.92808181,0.95594054,0.99011481,1.0305889,1.0730004,1.1150654,1.1751605,1.2222151,1.2608814,1.3091583,1.3447046,1.364454,1.3932355,1.4120025,1.4264013,1.4279852,1.4153283,1.4254284,1.4968829,1.6318734,1.7483285,1.8810388,1.990454,2.1218626,2.2399481,2.3604914,2.3611635,2.2715994,2.1626106,2.0217301,1.9128859,1.7731407,1.6633423,1.5837474,1.558946,1.4709415,1.406884,1.3709935,1.3787908,1.4017301,1.4081959,1.3967788,1.3725832,1.3374065,1.2953938,1.2470668,1.2068676,1.1702321,1.1310986,1.098388,1.0776259,1.0462507,1.0215436,1.0011434,0.99022382,0.99118613,0.95310858,0.90462677,0.85922192,0.81034259,0.77046805,0.70605074,0.60591114,0.50316272,0.41971584,0.33124615,0.27274975,0.23349692,0.20575629,0.17812688,0.15878015,0.1380546,0.12446719,0.12313957,0.1334537,0.14033053,0.15141275,0.16240766,0.18259728,0.20462575,0.24219286,0.31107218,0.36323585,0.4317159,0.40322074,0.44111369,0.47838199,0.37202291,0.28193357,0.19226275,0.099903474,0.011618201,-0.073456358,-0.16443258,-0.26037767,-0.3436746,-0.4323064,-0.50952336,-0.6023389,-0.67765343,-0.77216956,-0.87095294,-0.99955778,-1.0912141,-1.1642546,-1.2126555,-1.2439152,-1.2689637,-1.286781,-1.2940739,-1.2892129,-1.2753188,-1.2537338,-1.2278598,-1.190064,-1.1589889,-1.1197687,-1.0782621,-1.0246407,-0.96638755,-0.91679397,-0.85936855,-0.80876623,-0.74945808,-0.69380505,-0.64500239,-0.57935048,-0.48639461,-0.39918493,-0.31320025,-0.21515482,-0.11140952,-0.0066251316,0.053884085,-0.040638245,-0.047905896,0.02869087,0.10416002,0.18587652,0.26232355,0.34263777,0.41684095,0.4989335,0.39848254,0.28871582,0.17818821,0.068547181,-0.040774159,-0.13622252,-0.18808475,-0.26726018,-0.39811325,-0.50824992,-0.62682635,-0.76694671,-0.90682116,-1.0472056,-1.1869259,-1.3263743,-1.4636951,-1.5725754,-1.6925129,-1.8001273,-1.8870696,-1.962699,-2.0111051,-2.0326355,-1.9960283,-1.9584837,-1.8996923,-1.8153335,-1.7239099,-1.6188588,-1.5381651,-1.4361323,-1.3505209,-1.2465978,-1.1518273,-1.0497176,-0.95064861,-0.85430777,-0.75543418,-0.65733492,-0.56342468,-0.44965059,-0.35923756,-0.26112203,-0.16410221,-0.05801978,0.034125736,0.026176514,0.083433859,0.1810158,0.28020249,0.37050442,0.48574036,0.57505437,0.68825581,0.79002794,0.88875061,0.9786654,0.90564607,0.80051475,0.69959123,0.60198825,0.50630218,0.41748355,0.31635045,0.21401887,0.13567852,0.042057332,-0.043540157,-0.12712956,-0.22490052,-0.2927004,-0.37544814,-0.44648829,-0.51987636,-0.57514658,-0.53330425,-0.45246074,-0.32361787,-0.18814631,-0.075024676,0.04014916,0.17593806,0.2904541,0.40240849,0.51340477,0.62771228,0.73938873,0.87365689,0.96917183,1.0617526,1.152862,1.0897381,1.0131365,0.93184654,0.86998483,0.80960615,0.87584548,0.99774144,1.1355758,1.247904,1.3501125,1.4137435,1.3344901,1.417313,1.5197645,1.6024182,1.6623528:4
1.780518,1.5794149,1.4047716,1.2317637,1.0826075,0.95676416,0.79401926,0.73236122,0.61887334,0.54781137,0.42345089,0.26032813,0.10152076,-0.067114039,-0.19990049,-0.29623853,-0.2142035,-0.15540185,-0.074288738,0.0091931097,0.05764039,0.076911946,0.16693224,0.10761346,0.16065958,0.2122884,0.27101989,0.34158412,0.33845827,0.44999411,0.47168396,0.54517836,0.60767695,0.67503724,0.61084367,0.56159079,0.63181905,0.72684221,0.74166744,0.82887834,0.92880139,0.8613494,0.94922834,1.0266549,1.0570564,1.0991606,1.1591792,1.2053432,1.2845333,1.4081195,1.5260159,1.5387297,1.4329835,1.2714852,1.1065112,0.94012777,0.81191856,0.69744426,0.53263825,0.37207492,0.29504174,0.2092994,0.061205032,0.02693752,-0.042428467,-0.11026662,-0.25489479,-0.41175418,-0.54748017,-0.67675464,-0.76318828,-0.90561919,-0.91752142,-0.98788464,-1.1111825,-1.0028319,-0.86993207,-0.7583225,-0.68161306,-0.61852667,-0.48714617,-0.35455278,-0.47714774,-0.36019109,-0.26126381,-0.17379703,-0.082198927,0.0070914018,0.075109759,0.13861233,0.23419943,0.29680615,0.26841312,0.35335397,0.4319979,0.59830533,0.64353837,0.76937385,0.85864254,0.9643794,0.98408379,0.92617622,0.83375134,0.71702812,0.60698493,0.50905188,0.35928932,0.26374472,0.11347761,-0.0039096467,-0.16969949,-0.30924215,-0.42983299,-0.51816979,-0.6470974,-0.7608113,-0.8418574,-0.9013781,-0.98278196,-1.1337447,-1.1914892,-1.1912834,-1.2764561,-1.3653812,-1.5543028,-1.5236249,-1.65823,-1.8210355,-1.9380675,-2.095753,-2.2125314,-2.0939799,-1.9551857,-1.8468527,-1.6941385,-1.5492148,-1.6104807,-1.7232697,-1.578538,-1.4065299,-1.2683919,-1.1640672,-1.0691428,-0.99909944,-0.94500143,-0.88491304,-0.80328179,-0.71930661,-0.64099545,-0.54764565,-0.4810493,-0.40300511,-0.51495924,-0.56223979,-0.5773532,-0.69613299,-0.66954103,-0.75237944,-0.8676233,-0.90106346,-0.9657952,-0.97415373,-1.0256199,-1.0999684,-1.1871777,-1.3379981,-1.2881796,-1.4279037,-1.4780416,-1.5154495,-1.6793757,-1.8325954,-1.8620479,-1.6790071,-1.5420867,-1.5730189,-1.7277714,-1.8121066,-1.7279032,-1.6647123,-1.573664,-1.4548175,-1.3107188,-1.2089404,-1.0546202,-0.90092244,-0.76871361,-0.82253572,-0.67781816,-0.53422086,-0.43965961,-0.28281629,-0.11940709,-0.042488857,0.10836971,0.23267206,0.28711512,0.44091874,0.53211122,0.65980097,0.81331107,0.95096396,1.1094412,1.245093,1.1378132,1.0405949,0.9943981,0.87876272,0.82602996,0.74603143,0.69917698,0.60119021,0.6360727,0.51310311,0.41293644,0.44575577,0.36775664,0.29355423,0.1887174,0.1217602,0.046829004,-0.011394148,0.077027209,0.029047078,-0.066572045,-0.15572008,-0.11023477,-0.16635844,-0.21923718,-0.20396142,-0.29408087,-0.33627284,-0.43627215,-0.4016762,-0.4687034,-0.50062655,-0.3318721,-0.23465454,-0.1010738,-0.22026711,-0.11385461,0.0048961859,3.8508243E-4,0.13196826,0.23544127,0.44647663,0.50813237,0.48971189,0.70136074,0.85922182,1.0688259,1.2014487,1.2869733,1.2190926,1.1752493,1.1075667,1.0295723,0.94656415,0.93286488,0.93042136,0.83650215,0.88722417,0.85195142,0.78145775,0.87793603,0.81933363,0.73485386,0.70693373,0.63615513,0.5925044,0.59598787,0.66160619,0.69318492,0.60525228,0.51683198,0.44850274,0.48469093,0.40448168,0.35029068,0.30296788,0.25152411,0.21532514,0.17175097,0.13278012,0.046071668,-0.001403939,-0.073292694,-0.15087755,-0.01083592,0.1451901,0.30368959,0.43298603,0.52043099,0.63789334,0.72687732,0.79921522,0.95980257,1.0938431,1.1923698,1.3198344,1.3713815,1.4815265,1.51193,1.3633624,1.2123466,1.0608414,0.91321789,0.7677062,0.62579707,0.63408966,0.44890202,0.33873463,0.16985329,0.034404895,-0.12013034,-0.2569626,-0.41545007,-0.51458054,-0.62526356,-0.61618256,-0.61338851,-0.72987728,-0.76971585,-0.73662245,-0.68687516,-0.63824456,-0.5821657,-0.53549451,-0.62781792,-0.7122258,-0.8358684,-0.95334382,-1.0932084,-1.2490244,-1.4047312,-1.5682415,-1.6767636,-1.7207444,-1.7107878,-1.8404916,-1.7797104,-1.8672106,-1.8421023,-1.8778755,-1.8370041,-1.7147051,-1.6503781,-1.6204245,-1.6062199,-1.6609452,-1.6858415,-1.699023,-1.7435912,-1.8056951,-1.7961153,-1.6915515,-1.6270571,-1.4925533,-1.3303219,-1.168554,-1.1979884,-1.356057,-1.2460698,-1.1190821,-0.96877629,-0.85005364,-0.71556217,-0.59871238,-0.49109258,-0.36376939,-0.25721054,-0.14708341,-0.049774755,0.060461884,0.17988451,0.30103693,0.40403479,0.50022175,0.60986592,0.69571327,0.76070779,0.74608734,0.8131243,0.87759706,0.99975711,1.0477982,1.131897,1.2163383,1.2589847,1.3254494,1.386735,1.4547368,1.5047679,1.5785457,1.6617871,1.6514367,1.5362416,1.4294582,1.2865388,1.1345186,0.98715336,0.89688691,0.8588385,0.91185443,0.95781964,1.0351184,1.1013734,1.1696662,1.1709553,1.2286889,1.2061651,1.2879377,1.3381839,1.3625036,1.4181975,1.4869917,1.3991685,1.4255385,1.4374046,1.4751904,1.5626868,1.5358606,1.5940774,1.6417702,1.6939745,1.7711545,1.8528084:1
1.6118237,1.5342336,1.4409858,1.3535836,1.2715389,1.1766397,1.0689145,0.96407179,0.89549249,0.80839567,0.72292136,0.62173721,0.53479838,0.41933942,0.31410976,0.22919366,0.14941681,0.057209165,-0.064124219,-0.18426282,-0.30525028,-0.42446398,-0.54572508,-0.63453157,-0.73899275,-0.85487108,-0.98950541,-1.1100912,-1.2288092,-1.3251697,-1.4105387,-1.490465,-1.5880568,-1.6912983,-1.8220081,-1.9257857,-2.0039015,-2.0803594,-2.133564,-2.1911137,-2.195365,-2.2030572,-2.1787822,-2.1796321,-2.1360685,-2.0867882,-2.0321265,-1.9603337,-1.889178,-1.8159065,-1.7452754,-1.6839518,-1.6206247,-1.5506158,-1.4770973,-1.396077,-1.3162472,-1.2260072,-1.1405639,-1.1030446,-1.0169509,-0.92059879,-0.82159748,-0.74853133,-0.72761511,-0.63440011,-0.54554789,-0.46448876,-0.38661306,-0.32930107,-0.28058416,-0.19142506,-0.10793745,-0.052502887,-0.077308373,-0.12186632,-0.17635244,-0.21514698,-0.131452,-0.088254826,0.011703653,0.10252901,0.20004558,0.29603363,0.38946198,0.48692431,0.58288266,0.65519974,0.74208696,0.74741161,0.80293135,0.88110085,0.9547368,1.0527341,1.1160334,1.1935202,1.2773974,1.3287897,1.3533692,1.3497564,1.2735259,1.190752,1.1332074,1.0814934,1.0277716,0.94032249,0.85944677,0.78387504,0.70290362,0.62419368,0.57999233,0.55149868,0.49310326,0.41443552,0.33351767,0.25966321,0.171641,0.08716324,-0.02252534,-0.10995682,-0.18222678,-0.24820656,-0.29461065,-0.27470746,-0.24400423,-0.20832337,-0.15641394,-0.093355911,-0.034876688,-0.0028899725,-0.064396054,-0.12600642,-0.19592358,-0.28335917,-0.386824,-0.45707973,-0.4859735,-0.55342453,-0.65017079,-0.72281839,-0.78753347,-0.86580235,-0.94968807,-1.0497773,-1.146528,-1.2419917,-1.33616,-1.3919239,-1.4685352,-1.5643068,-1.6445923,-1.6866399,-1.7525316,-1.83972,-1.9386918,-2.0385939,-2.0707195,-2.1350414,-2.1409549,-2.2039682,-2.2561476,-2.2809011,-2.3459027,-2.3562558,-2.3281759,-2.2903211,-2.2212741,-2.1261413,-2.0255922,-1.9294621,-1.8336335,-1.7387934,-1.6375298,-1.5309533,-1.4282901,-1.329327,-1.2337573,-1.1343262,-1.0383609,-0.98244325,-0.90593795,-0.8014753,-0.70611181,-0.59535262,-0.50391428,-0.41652557,-0.32216419,-0.23734792,-0.14070012,-0.053666108,0.043136059,0.13489393,0.23011269,0.32521496,0.42438108,0.52694722,0.61620924,0.71338702,0.80168946,0.89742856,0.98629858,1.0889967,1.1837048,1.2834109,1.3800351,1.3962761,1.3702635,1.3467004,1.3109249,1.2808704,1.2547575,1.2231406,1.2262843,1.2051481,1.1842677,1.146844,1.142676,1.1584587,1.153812,1.102081,1.0606764,1.0367936,1.001018,0.93716141,0.89180912,0.85626075,0.90341364,0.93619287,0.97502445,1.0271435,1.0903427,1.1471419,1.1887685,1.2130185,1.2138862,1.1552552,1.1018258,1.040587,0.99660474,0.95989828,0.88782265,0.8130733,0.7326552,0.65460582,0.59655058,0.54462654,0.46822838,0.37782252,0.30221813,0.22999219,0.16942448,0.095066909,0.014248691,-0.058825581,-0.11577881,-0.16140662,-0.20901661,-0.26183429,-0.31950678,-0.37355727,-0.43477704,-0.48930295,-0.53990748,-0.59099245,-0.63692521,-0.63265731,-0.53470479,-0.43633686,-0.33045816,-0.24608935,-0.14622934,-0.038835015,0.088651302,0.19648135,0.30355574,0.40315452,0.50221021,0.57668024,0.66090137,0.75319244,0.84986021,0.94913046,1.0252093,1.1110744,1.1579204,1.0974721,1.0309392,0.95569742,0.90039929,0.82980025,0.77184134,0.69355776,0.62097643,0.57088164,0.55837212,0.48452652,0.4155314,0.34767745,0.30483645,0.28854516,0.28820587,0.28408068,0.22717628,0.19713391,0.20099503,0.19670081,0.18345153,0.1415682,0.064461638,-0.02162007,-0.11058405,-0.19671607,-0.28193361,-0.36339717,-0.44777465,-0.52285797,-0.55024261,-0.50729344,-0.48119814,-0.51543214,-0.5915056,-0.66853422,-0.72271606,-0.75819386,-0.79683968,-0.79322538,-0.8509653,-0.84420789,-0.89783447,-0.90802266,-0.88225161,-0.85358126,-0.77986784,-0.7622006,-0.7256461,-0.69486439,-0.66120977,-0.57869944,-0.54875228,-0.54565656,-0.44233095,-0.38291909,-0.3150176,-0.23782147,-0.18456189,-0.12087084,-0.042499548,0.027161057,0.089198239,0.15403655,0.20950163,0.23742027,0.28937925,0.34426064,0.40504777,0.45638086,0.51022282,0.57464301,0.62443077,0.67422238,0.74689961,0.81191078,0.88167267,0.95055686,1.0135892,1.0755564,1.1429851,1.2052701,1.172031,1.0781502,0.96054956,0.84190012,0.72946745,0.59930803,0.49594205,0.38881827,0.30224525,0.19618727,0.10259524,-0.0081327467,-0.035295472,-0.07884466,-0.11608245,-0.1367282,-0.13026741,-0.058208664,0.021061512,0.10167462,0.19087616,0.27077412,0.35313691,0.44486007,0.53068631,0.59833549,0.6636515,0.72579843,0.78882695,0.83632799,0.86861481,0.93058867,0.98947446,0.99120609,0.94849117,0.9015961,0.86153183,0.86218157,0.80694816,0.78318217,0.79676845,0.81174199,0.84633211,0.89737585,0.95750545,0.99931588,1.0264255,1.0946884,1.1308387,1.1613201,1.195455,1.2444209,1.285244,1.3267323,1.376667,1.4395374,1.4958729,1.5536522,1.6120321:5
0.20196812,0.13492584,0.044455423,-0.040931135,-0.11100961,-0.19144875,-0.23762993,-0.21532397,-0.16056078,-0.22248635,-0.31617324,-0.4042202,-0.47990329,-0.55527384,-0.62036118,-0.66457089,-0.70365681,-0.74494696,-0.79500494,-0.84155934,-0.88099114,-0.91385413,-0.93620472,-0.94975117,-0.96350511,-0.97462347,-0.98739901,-1.0045292,-1.0276484,-1.0453309,-1.0400263,-0.99853725,-0.90448432,-0.79223339,-0.69826421,-0.60774338,-0.52384289,-0.43953407,-0.34891406,-0.26523822,-0.1826838,-0.089280109,-0.0024115302,0.079944103,0.16397809,0.2527025,0.34518876,0.42610492,0.51699882,0.61465934,0.54234826,0.47765522,0.42454261,0.37731152,0.34652495,0.33959244,0.3843631,0.35795991,0.31048381,0.2778271,0.24620779,0.22359453,0.21545317,0.2143174,0.21219386,0.21144035,0.21908017,0.22873868,0.25339377,0.27358269,0.30124612,0.3269325,0.3570916,0.39502744,0.44000344,0.48915227,0.56484508,0.65229314,0.72643112,0.78650476,0.83748439,0.89505336,0.94719433,0.9901776,0.97145004,0.95993923,0.95309223,0.94895336,0.93793348,0.93653499,0.94796398,0.95474349,0.95061321,0.96976391,0.99373081,1.0070005,1.0066905,0.99721313,0.98194346,0.97037442,0.96940393,0.9877116,1.0485705,1.131539,1.219364,1.3106745,1.4070177,1.4985241,1.5928211,1.6860588,1.778294,1.8739771,1.9339254,1.8667311,1.7760848,1.6850933,1.5846059,1.494486,1.4008089,1.3036131,1.2081967,1.1197078,1.0234584,0.92938897,0.83333998,0.73776005,0.798164,0.88431822,0.95464797,0.96639777,0.87856109,0.79598376,0.69998823,0.59391022,0.47005885,0.38059669,0.29650338,0.23749964,0.18912381,0.1087832,0.053059315,-0.0048577599,-0.049229063,-0.081540935,-0.077660435,-0.094443125,-0.097947305,-0.087142492,-0.077905943,-0.076154562,0.01483137,0.12260228,0.21128432,0.23398502,0.27095037,0.30337405,0.35523365,0.38134045,0.44412763,0.52217898,0.61591598,0.6841334,0.58729381,0.46218374,0.35454809,0.2339377,0.12017221,0.025081713,-0.082916426,-0.17262955,-0.26065042,-0.33051384,-0.3880061,-0.44160362,-0.51199939,-0.60811837,-0.70132592,-0.79849584,-0.89934637,-0.98474234,-1.0759121,-1.1196159,-1.1432393,-1.1540995,-1.1545104,-1.1368192,-1.1307394,-1.1261132,-1.1171386,-1.1065585,-1.0901481,-1.0648033,-1.0434144,-1.0090847,-0.97710759,-0.93926738,-0.88457922,-0.82226455,-0.76096863,-0.69508344,-0.6361463,-0.55334719,-0.49990531,-0.6169492,-0.72972102,-0.73178368,-0.67704955,-0.61465125,-0.55430397,-0.49271538,-0.41471012,-0.35264529,-0.32724921,-0.41260701,-0.49604757,-0.57519944,-0.66917996,-0.76420241,-0.84570301,-0.92527617,-1.0148763,-1.1173965,-1.2128605,-1.3180483,-1.4388673,-1.5312102,-1.6351603,-1.7410869,-1.8451822,-1.9496586,-2.0699803,-2.1661279,-2.27277,-2.3548253,-2.4111777,-2.4215399,-2.4008235,-2.328209,-2.2265935,-2.1330788,-2.0270523,-1.9195467,-1.817775,-1.7158994,-1.6149637,-1.5112485,-1.406735,-1.3028874,-1.1954065,-1.0963936,-0.99400284,-0.89463713,-0.79242526,-0.69524785,-0.59735535,-0.49443342,-0.39487393,-0.29664316,-0.19781308,-0.09412622,-0.13667284,-0.21746782,-0.26881025,-0.25109278,-0.17782984,-0.065280567,0.051636002,0.16491479,0.27119698,0.36839724,0.47086806,0.57366614,0.69989819,0.64602002,0.529504,0.42545785,0.32713656,0.24209046,0.17149885,0.19185554,0.10707697,0.028059624,-0.058207682,-0.13202243,-0.2118182,-0.28906372,-0.35377766,-0.41258501,-0.47049394,-0.51238706,-0.52462996,-0.51588134,-0.47280499,-0.41350678,-0.33589102,-0.25421871,-0.17283287,-0.072793787,0.033238776,0.14519121,0.24864261,0.36653046,0.47018847,0.56976535,0.67292336,0.78263271,0.8946323,1.0143215,1.1312598,1.2335107,1.3201888,1.3699725,1.4884235,1.6076365,1.7452369,1.6755116,1.5823613,1.492026,1.4114878,1.3552211,1.3598245,1.4346686,1.5307681,1.6371144,1.7413347,1.8440527,1.9226226,1.9218951,1.8163438,1.9116767,1.9937967,2.1095255,2.1473342,2.0804797,2.007985,1.9053293,1.7781649,1.6479602,1.5168892,1.4027907,1.2854147,1.1595421,1.1000376,1.0787563,1.1004913,1.167009,1.2475158,1.329096,1.4125351,1.4966891,1.5369519,1.5381076,1.4590835,1.3645265,1.2725214,1.1623394,1.0978714,1.1241288,1.0514491,0.95320653,0.86039855,0.76123072,0.6613217,0.55638088,0.45616414,0.36094909,0.25469381,0.15297106,0.049800773,-0.044272807,-0.14172535,-0.25154314,-0.33176314,-0.40024037,-0.44108145,-0.44103397,-0.46498981,-0.44578158,-0.40447083,-0.45337004,-0.53731588,-0.58423166,-0.60020628,-0.63407361,-0.72106701,-0.77332697,-0.7022769,-0.65791803,-0.70983693,-0.62546032,-0.53174298,-0.51069165,-0.56710707,-0.66283011,-0.74337834,-0.82545818,-0.89956282,-0.98131012,-1.0583271,-1.1388801,-1.2113083,-1.2908466,-1.3692,-1.4373076,-1.5128353,-1.5814993,-1.6611541,-1.7139517,-1.7481053,-1.7210166,-1.6621075,-1.5922598,-1.5078435,-1.4035065,-1.2993583,-1.1955684,-1.0748897,-0.95752043,-0.82706956,-0.70259314,-0.58402135,-0.44747105,-0.33433279,-0.21434529,-0.11318561,0.021356081,0.1376433:4
2.4399374,2.4110143,2.3630521,2.2891417,2.2273447,2.1704295,2.1070909,2.0550288,1.985622,1.9234135,1.8625538,1.8065934,1.74015,1.6703734,1.609034,1.5546803,1.493926,1.4419328,1.3717268,1.3132275,1.2462836,1.1908715,1.1341751,1.0699115,1.014586,0.94893003,0.8919794,0.82975255,0.77196725,0.70414739,0.6530266,0.58237852,0.5184353,0.45031046,0.39042119,0.33530497,0.27914949,0.1914757,0.13571922,0.08134342,-0.0043077912,-0.069215725,-0.082589282,-0.085055171,-0.08273934,-0.074920055,-0.07418769,-0.071098006,-0.07306178,-0.075677565,-0.083548182,-0.12316143,-0.14040472,-0.15995344,-0.20361593,-0.25183841,-0.27937819,-0.32881779,-0.37943521,-0.4282198,-0.47249866,-0.50610172,-0.54896597,-0.58801657,-0.59977196,-0.63057312,-0.65485871,-0.68110688,-0.7125787,-0.75092956,-0.79819696,-0.86816705,-0.88865331,-0.92482063,-0.97051586,-1.0115169,-1.0864752,-1.1709934,-1.2138246,-1.2623849,-1.3207543,-1.3391364,-1.3738371,-1.3994645,-1.4103517,-1.4150902,-1.4055281,-1.3940681,-1.3710155,-1.3422136,-1.3220289,-1.2838346,-1.2404017,-1.2040815,-1.1675043,-1.1215761,-1.0639278,-1.0166719,-0.95995545,-0.91018342,-0.84160913,-0.79774677,-0.73587145,-0.67159017,-0.61196212,-0.56753378,-0.55120333,-0.61511834,-0.60976814,-0.57304145,-0.62689636,-0.68287287,-0.75644852,-0.80982664,-0.87516081,-0.93319448,-0.99891748,-1.0526145,-1.1137709,-1.1679843,-1.2283167,-1.2887344,-1.3330245,-1.3885997,-1.4480348,-1.459599,-1.4557343,-1.4307631,-1.3940669,-1.3546729,-1.3143854,-1.2510087,-1.1939715,-1.1310116,-1.0668473,-0.99000377,-0.93748073,-0.85267152,-0.80746934,-0.72217329,-0.67638975,-0.59026463,-0.54033951,-0.45773426,-0.41068989,-0.32437988,-0.26018961,-0.1908722,-0.10404139,-0.023145107,0.029050861,0.085263602,0.16262561,0.21715299,0.25979754,0.23850817,0.27408137,0.35671262,0.34485316,0.26028916,0.20079933,0.13871945,0.092592731,0.050732119,0.0027625584,-0.027052846,-0.033335282,-0.0056015201,0.030070269,0.072103936,0.12532716,0.17174714,0.22165263,0.2814038,0.34015892,0.41471733,0.47065749,0.52683789,0.59096324,0.65812052,0.73012453,0.78256892,0.83595469,0.91231401,0.98106086,1.0389908,1.1162154,1.1783836,1.2351893,1.2883399,1.34688,1.3362995,1.2830825,1.2009312,1.1801984,1.2390308,1.3010627,1.3706451,1.4292253,1.4909809,1.5521429,1.6123199,1.6948322,1.7451277,1.7565548,1.6776829,1.6218932,1.5446109,1.4852831,1.3963022,1.3499816,1.2746739,1.2881257,1.35362,1.3384901,1.2644539,1.1970852,1.1291305,1.0587612,0.99442654,0.91871029,0.85828008,0.7791067,0.72697858,0.64007729,0.5901832,0.51229772,0.44771512,0.3968647,0.3388027,0.31615769,0.31704158,0.36240849,0.42023041,0.4759408,0.52530815,0.58792918,0.64556478,0.71242686,0.78004721,0.82340017,0.79051069,0.72418553,0.66243044,0.60540512,0.54225852,0.47175133,0.40593381,0.34736938,0.28959935,0.22987889,0.15725853,0.10193911,0.048040114,-0.029253334,-0.091152667,-0.15281734,-0.20357894,-0.27172252,-0.33528512,-0.38857666,-0.46642901,-0.51454916,-0.5789357,-0.646152,-0.69202457,-0.75770444,-0.8201126,-0.86276996,-0.92426653,-0.97927203,-1.0216848,-1.0278656,-1.0172496,-0.9985837,-0.94858024,-0.91372292,-0.84739764,-0.80604112,-0.72970096,-0.68401387,-0.61090906,-0.52763265,-0.44318021,-0.36846409,-0.30656549,-0.24218355,-0.19456879,-0.13156872,-0.12336709,-0.15551103,-0.20815656,-0.26129889,-0.31746974,-0.37409076,-0.43727672,-0.50617244,-0.55587256,-0.60356584,-0.65565009,-0.71061273,-0.76074651,-0.81012122,-0.86349391,-0.91586441,-0.96426654,-1.0173845,-1.0640237,-1.1125777,-1.1554609,-1.1963532,-1.2381717,-1.2790132,-1.3184494,-1.3579168,-1.3884494,-1.4100966,-1.4326471,-1.4506933,-1.4631348,-1.4744032,-1.4692093,-1.4664953,-1.4635256,-1.4469573,-1.4089273,-1.344692,-1.2696125,-1.2187701,-1.1529284,-1.0836168,-1.0315945,-0.97174882,-0.92359557,-0.84423609,-0.78545232,-0.73007614,-0.67216411,-0.60891103,-0.54999614,-0.48281551,-0.50088259,-0.51755942,-0.53943518,-0.56201681,-0.57686242,-0.61025942,-0.62408048,-0.6593116,-0.68920242,-0.69930956,-0.72148353,-0.74101444,-0.73764832,-0.7386273,-0.73410972,-0.72088644,-0.70844928,-0.69250185,-0.67142958,-0.65313454,-0.63151613,-0.60600484,-0.58485549,-0.56526068,-0.54118882,-0.52139108,-0.48969385,-0.47258739,-0.43995919,-0.42002623,-0.38039567,-0.35512442,-0.31988117,-0.28713531,-0.25665171,-0.24107591,-0.2283103,-0.21030112,-0.19021214,-0.14479449,-0.084487978,-0.027698796,0.031916585,0.084001548,0.17048101,0.2267952,0.29347033,0.34643479,0.41053239,0.46301481,0.47022149,0.49170711,0.52913883,0.53486008,0.55420939,0.60910592,0.67061498,0.72350081,0.78004065,0.84718783,0.91083478,0.97170781,1.027927,1.0898118,1.1535691,1.220647,1.2816272,1.3402783,1.3991241,1.4597368,1.5267662,1.5909662,1.6475982,1.7057188,1.7648777,1.8232918,1.8878061,1.9502954,2.0165217,2.090123,2.1454158,2.2049714,2.2643985,2.3291612,2.3853249,2.4335616:4
2.1196541,2.0375952,1.9542212,1.8751672,1.7944582,1.7175985,1.6415299,1.5594676,1.4791579,1.3964597,1.3189378,1.2369344,1.154645,1.0700155,0.99332523,0.90244848,0.82673525,0.77752674,0.76829537,0.77385767,0.77780975,0.7768744,0.77121004,0.76427982,0.74956451,0.73102452,0.70822446,0.69467499,0.67706972,0.65558612,0.62245228,0.61301763,0.60216634,0.58408105,0.57838214,0.56621135,0.50213343,0.43865237,0.41350471,0.40403964,0.40645717,0.41915193,0.4426378,0.46775569,0.40212442,0.32812464,0.25599221,0.17691236,0.10854841,0.066827251,0.020953571,-0.025518634,-0.075030359,-0.13894982,-0.23408677,-0.31464065,-0.39098112,-0.46731232,-0.53765163,-0.60433382,-0.64826177,-0.68325575,-0.69164341,-0.69308829,-0.68920211,-0.67605247,-0.65417585,-0.63096889,-0.60765482,-0.58504358,-0.55943649,-0.53126837,-0.50443356,-0.48328911,-0.46150432,-0.42991466,-0.39705639,-0.36927088,-0.32799961,-0.28809855,-0.23879997,-0.18875668,-0.13915475,-0.078885412,-0.0069797398,0.063118434,0.12808543,0.16315616,0.086579586,-0.018651777,-0.08088926,-0.18831227,-0.27754214,-0.367084,-0.47197919,-0.57863627,-0.68041909,-0.74299049,-0.81783214,-0.88783221,-0.96804674,-1.0460548,-1.123397,-1.2063593,-1.2898487,-1.3827568,-1.4627141,-1.5498689,-1.6416824,-1.7465183,-1.8042401,-1.8402679,-1.8792092,-1.8891472,-1.8718552,-1.835729,-1.7872634,-1.7545354,-1.71835,-1.6706901,-1.6256393,-1.5626022,-1.4989252,-1.4475703,-1.3859538,-1.3247454,-1.2644505,-1.1920429,-1.1125207,-1.0334757,-0.96666848,-0.88830872,-0.80503476,-0.73055488,-0.65638187,-0.56646294,-0.47755067,-0.39402177,-0.30923666,-0.2227128,-0.11835127,-0.12493035,-0.098849342,-0.16055254,-0.16370785,-0.1080588,-0.0393776,0.043339595,0.12025456,0.2040445,0.29474255,0.38407003,0.47622732,0.56588375,0.66821787,0.73482223,0.68906225,0.60364889,0.51770846,0.43299294,0.36529568,0.28683475,0.22171862,0.16852047,0.1256188,0.1054172,0.11911209,0.16285638,0.22875847,0.29033911,0.35461023,0.42516209,0.48912284,0.55599329,0.63343821,0.70389547,0.77525787,0.84659429,0.92186894,0.9964297,1.0745082,1.1158689,1.1875348,1.2629285,1.3302097,1.4099883,1.497268,1.5675224,1.6024171,1.5669194,1.474566,1.4116619,1.4043883,1.4536219,1.5259808,1.5959352,1.6645546,1.7467446,1.8172521,1.8928341,1.961669,2.0377674,2.0949182,2.0153421,1.9332574,1.8999771,1.8823133,1.8054982,1.7264679,1.6429723,1.5616751,1.481637,1.4039778,1.3136002,1.2373633,1.1572831,1.0777699,0.99571389,0.92155869,0.82738949,0.78414297,0.77395064,0.80707227,0.88415502,0.95977837,1.0401006,1.1232264,1.106883,1.0317623,0.9513547,0.87352766,0.79819806,0.71644377,0.63819147,0.56656471,0.52714371,0.50105895,0.41752514,0.34514028,0.26239235,0.1851083,0.10428996,0.032881577,-0.053781374,-0.12432332,-0.20543778,-0.28089671,-0.36227847,-0.43912586,-0.51164097,-0.59482895,-0.67036871,-0.74471713,-0.81889289,-0.89528273,-0.93467751,-0.94715891,-0.92519782,-0.89224149,-0.85133614,-0.78809931,-0.71819407,-0.64590782,-0.57056063,-0.49612602,-0.4188195,-0.33622313,-0.24004067,-0.14953369,-0.12033929,-0.094159951,0.012007184,0.1022812,0.1936044,0.2475292,0.18328505,0.10842502,0.041110158,-0.042973236,-0.13336455,-0.22480281,-0.30080345,-0.37499019,-0.44962495,-0.53794299,-0.61322519,-0.69201541,-0.76388766,-0.81036433,-0.77950294,-0.71248372,-0.74943423,-0.8389967,-0.91285244,-0.99668603,-1.0848283,-1.1679459,-1.2419578,-1.3196002,-1.391452,-1.4567507,-1.5364759,-1.6052585,-1.6784746,-1.7456784,-1.8139863,-1.8655977,-1.9244498,-1.9685211,-2.0154004,-2.0506916,-2.0726602,-2.0793814,-2.0757957,-2.060761,-2.0345771,-1.9936972,-1.9336504,-1.8555644,-1.7639617,-1.6910463,-1.6250862,-1.5572184,-1.4861351,-1.4168193,-1.3466192,-1.2765624,-1.2068624,-1.139277,-1.0575691,-0.98658198,-0.91403024,-0.8407938,-0.77743678,-0.80908097,-0.77002448,-0.68000033,-0.60835156,-0.53381376,-0.4595194,-0.39571253,-0.31381479,-0.23831212,-0.25713673,-0.29875692,-0.36324365,-0.38853193,-0.32547973,-0.25840645,-0.274133,-0.30800302,-0.35506147,-0.40143504,-0.43862782,-0.47783444,-0.51100784,-0.52618102,-0.54574013,-0.56819062,-0.58171582,-0.58893681,-0.58342608,-0.57454377,-0.55383388,-0.52919902,-0.50252303,-0.4704241,-0.426228,-0.36668477,-0.29823323,-0.22401314,-0.14775961,-0.11330376,-0.080170902,-0.054767781,-0.03370363,-0.0014567097,0.039617851,0.11822955,0.16819548,0.21663989,0.26131529,0.30263161,0.27993179,0.24928402,0.23157946,0.24305382,0.27517493,0.30679797,0.35110977,0.42625673,0.47127019,0.47172965,0.47530509,0.49387058,0.50846245,0.52170554,0.5302358,0.57031605,0.59063165,0.61052028,0.62493239,0.63633007,0.64557961,0.65254381,0.65533452,0.67879153,0.73572077,0.75871974,0.71713256,0.80142752,0.8801087,0.95879522,1.0407298,1.1229517,1.1990898,1.2787257,1.359687,1.4379979,1.517805,1.5986109,1.6766537,1.7562525,1.8360715,1.9228791,2.0086999,2.0800115:4
1.3118222,1.3659515,1.4732998,1.357816,1.3763037,1.483651,1.4199344,1.3248201,1.1580149,0.89970321,0.71138019,0.5812415,0.41335805,0.35531534,0.50360417,0.43364158,0.5140021,0.59547089,0.59139583,0.63235743,0.63953654,0.79622879,0.86135983,0.8594805,0.86232079,0.89682378,1.0216993,1.2006261,1.2273913,1.3132241,1.3523504,1.4799711,1.386302,1.5260549,1.533334,1.4832409,1.3114366,1.1633796,0.99065924,0.76671508,0.61154685,0.43236476,0.23941059,0.058276315,-0.1247242,-0.28579768,-0.44676679,-0.3975558,-0.38506985,-0.34944354,-0.26640954,-0.1613679,-0.16572856,-0.07698097,-0.072896911,0.087256882,0.13852229,0.19977922,0.28829912,0.33152374,0.32362648,0.48635776,0.40792204,0.52073218,0.56402868,0.62609356,0.67478621,0.8115498,0.79951173,0.85371921,0.9314121,1.0265175,1.0916216,1.1489778,1.2030112,1.2209248,1.1583668,1.031773,0.86738884,0.69275753,0.6780988,0.52261214,0.36619101,0.16710912,0.040194536,-0.16642802,-0.36817631,-0.64259285,-0.91876418,-1.195148,-1.359773,-1.1867115,-1.1559078,-1.0302718,-0.91860569,-0.76876188,-0.64990213,-0.52032681,-0.39866984,-0.27709526,-0.15498894,-0.029109161,0.096960229,0.22092247,0.26961657,0.34348663,0.46579266,0.612117,0.71129501,0.78613552,0.83480653,0.95905156,1.0902126,1.1779088,1.3092021,1.3624337,1.4403613,1.3259588,1.1167878,1.021259,0.87290821,0.7080733,0.65141145,0.51273769,0.28329579,0.18723771,0.099668635,-0.031065819,-0.22768996,-0.4373702,-0.63051846,-0.82500558,-0.90137563,-1.0104018,-1.2119735,-1.2974346,-1.4948198,-1.6190426,-1.759592,-1.8845662,-1.9715144,-1.9260771,-1.7246379,-1.5216499,-1.3672385,-1.2508174,-1.1162966,-1.0920956,-0.95595748,-0.79000674,-0.69986492,-0.50692101,-0.44265236,-0.37708965,-0.43069,-0.25539259,-0.08895887,-0.020506797,0.14259661,0.26785501,0.38202044,0.22042616,0.26317205,0.34876672,0.51278351,0.43276431,0.61194221,0.57071981,0.36963962,0.26571276,0.38619583,0.29203571,0.13761054,0.18590711,0.19517726,0.046064743,-0.095669534,-0.23887232,-0.3996852,-0.57928191,-0.59261765,-0.48025007,-0.47025991,-0.62445763,-0.76507161,-0.87335169,-1.040691,-1.2287546,-1.3334269,-1.4868523,-1.6615453,-1.8087957,-1.9874883,-1.866445,-1.7171268,-1.5107659,-1.3477622,-1.1847705,-1.0673414,-0.91082679,-0.74219428,-0.60768353,-0.61831176,-0.54375475,-0.32455936,-0.16774499,-0.003497702,0.17647312,0.33649274,0.51476402,0.56327261,0.79101267,0.92563545,1.0951581,1.2643505,1.4667346,1.6335252,1.5726394,1.3957655,1.2382497,1.015129,0.86072134,0.71018956,0.58624566,0.57204686,0.44611938,0.29762466,0.15678917,0.16764366,0.1691348,0.0084474386,-0.16528192,-0.28762189,-0.41279491,-0.61540172,-0.74243617,-0.64034784,-0.63728952,-0.84261344,-1.0294,-1.2299427,-1.4096435,-1.5845438,-1.7541745,-1.801533,-1.7318778,-1.6600416,-1.4842732,-1.2390247,-1.0485425,-0.84708843,-0.63089682,-0.47064878,-0.36474629,-0.16366543,-0.026969295,0.13149506,0.40060919,0.64079006,0.81043869,1.0640436,1.2718761,1.4561466,1.5288172,1.6292483,1.5235791,1.3761208,1.2641294,1.1156758,1.0600642,0.90533973,0.88034294,0.76057421,0.62089684,0.4910572,0.35875071,0.42155039,0.50119284,0.38293399,0.26462242,0.15547107,0.12696808,0.05491883,-0.024805772,-0.16434617,-0.24738833,-0.10280984,-0.12486132,-0.21184888,-0.30715861,-0.39263566,-0.50930345,-0.62751207,-0.68951216,-0.74808474,-0.87153461,-0.9874779,-1.0693009,-1.1631443,-1.0571022,-0.95857719,-0.77268601,-0.53552299,-0.34109156,-0.15147642,0.06029502,0.23220652,0.35091413,0.43867037,0.60451478,0.83180654,0.98844635,1.2579965,1.2054856,1.1039802,1.0689037,0.98474401,0.9468527,0.87402702,0.7643093,0.82173338,0.73396664,0.68337112,0.7964574,0.83085141,0.74488428,0.66142125,0.58976384,0.5930577,0.53219432,0.42436766,0.31888777,0.23528446,0.17407737,0.11488746,0.047339836,-0.030254624,-0.016347376,0.13885092,0.33350367,0.53751192,0.74094855,0.88912441,1.0877735,1.2989989,1.4524062,1.2903072,1.2572365,1.1648744,1.0706799,0.97131393,0.86457213,0.87701628,0.81630403,0.71905653,0.65211094,0.5812985,0.43329225,0.33042112,0.30644417,0.28795254,0.1515499,0.036011908,-0.044352021,-0.17459805,-0.26732577,-0.33788616,-0.4491064,-0.4320477,-0.41912065,-0.53326296,-0.66119591,-0.77003512,-0.9085081,-1.0667455,-1.2353377,-1.3938942,-1.5314341,-1.7000341,-1.8814075,-2.0278722,-2.13793,-2.168779,-2.3728055,-2.4977146,-2.6854946,-2.8424308,-3.0591257,-3.1572677,-3.1362279,-2.8959779,-2.6517677,-2.4532095,-2.2493142,-2.0483227,-1.8267896,-1.6257763,-1.4518269,-1.3106001,-1.128646,-0.97423999,-0.8357456,-0.71668976,-0.56138213,-0.4501285,-0.28026218,-0.40360805,-0.62200595,-0.57808039,-0.47777085,-0.37257418,-0.22354026,-0.067745789,0.051127211,0.16081108,0.32014683,0.4438826,0.56939428,0.6252214,0.68325953,0.80517563,0.9447195,1.0788112,1.1202118,1.0719326,1.1778161,1.2584809:1
2.4723475,2.3645176,2.2600958,2.1478683,2.0825078,1.9767043,1.8649421,1.7903552,1.7246335,1.6236552,1.5195239,1.4081087,1.4078804,1.3429261,1.2427323,1.1779924,1.0660713,1.0286508,1.0164744,0.94956012,0.83818524,0.78535096,0.66948368,0.64202773,0.57959337,0.52122278,0.43076226,0.38397257,0.28027871,0.1804432,0.1767099,0.23780305,0.23620019,0.28618881,0.22126347,0.13075615,0.056306005,-0.057497782,-0.10101084,-0.24097493,-0.36129604,-0.50374948,-0.53675503,-0.66333699,-0.80063046,-0.91661262,-1.041567,-1.0960221,-1.1870329,-1.1152056,-1.089293,-0.95495642,-0.87694193,-0.78993605,-0.69680922,-0.63029488,-0.5779542,-0.46293305,-0.38892558,-0.28515275,-0.19583643,-0.16262018,-0.045261726,0.016234162,0.11335483,0.14308187,0.093117799,0.019235331,-0.072698833,-0.18716215,-0.17658003,-0.27212155,-0.37166271,-0.48934518,-0.49271234,-0.52705454,-0.65918332,-0.72150248,-0.84240644,-0.92814208,-0.96047547,-1.0762931,-1.1874612,-1.2373283,-1.2993353,-1.3846089,-1.4908018,-1.5647089,-1.6774689,-1.7810348,-1.8507422,-1.9639141,-2.050303,-2.1240614,-2.2043143,-2.2744581,-2.3470799,-2.4525203,-2.5047608,-2.5163372,-2.4216408,-2.3432464,-2.2678352,-2.1879301,-2.1134364,-2.0395466,-1.9576937,-1.8206999,-1.7429866,-1.662376,-1.5705592,-1.4598818,-1.3803174,-1.2867965,-1.208231,-1.1256149,-1.0287327,-0.92086967,-0.85158798,-0.74850722,-0.66780575,-0.57355861,-0.48241026,-0.37110007,-0.26424395,-0.15845859,-0.088326384,0.0049620685,0.10792065,0.18162547,0.29769774,0.38370921,0.45058124,0.55489636,0.64146146,0.73038134,0.84654747,0.95082396,1.0555931,1.0563834,0.99448408,0.91235405,0.89831612,0.83433354,0.77024175,0.81116724,0.78429853,0.72738575,0.68345495,0.64384102,0.70453702,0.71327674,0.67536089,0.59757312,0.5895655,0.5134214,0.47658488,0.52713605,0.55808985,0.52036664,0.48388996,0.47170365,0.41938896,0.3445502,0.28376636,0.32272349,0.37328474,0.4026753,0.37203821,0.32036377,0.30065519,0.2031015,0.17535768,0.13787029,0.048762815,0.010570574,0.044515287,0.12958838,0.17275053,0.26341037,0.23594641,0.1905017,0.19676253,0.099665384,0.045885279,0.054436324,-0.06633161,-0.091525959,-0.1785051,-0.25985382,-0.28484207,-0.36525957,-0.39493216,-0.49412899,-0.57926658,-0.61742097,-0.7160506,-0.81685862,-0.92907244,-0.97606073,-1.0215869,-1.128947,-1.2342044,-1.3323021,-1.234803,-1.1033859,-0.97277136,-0.84508864,-0.72213007,-0.59730353,-0.46447118,-0.34064614,-0.21204319,-0.08844919,0.043344768,0.16504102,0.29178313,0.42923444,0.56091895,0.68665445,0.82568037,0.96043677,1.0875363,1.2245885,1.3642646,1.4854837,1.6169986,1.7133047,1.8398611,1.9615883,2.0919991,2.1989077,2.2947036,2.2351522,2.1963919,2.0962158,2.0084157,1.8828495,1.7513033,1.6156545,1.4792453,1.3400729,1.2362412,1.1000827,0.97698791,0.84460045,0.73620612,0.59639779,0.46143532,0.3341693,0.19559135,0.070202954,-0.053086642,-0.17832891,-0.30615684,-0.44322003,-0.56963701,-0.69522263,-0.82026744,-0.9080656,-1.0382578,-1.1639807,-1.2852329,-1.261931,-1.164838,-1.0659475,-0.9827601,-0.88415367,-0.79735516,-0.74899974,-0.64318759,-0.55875974,-0.50504305,-0.42723598,-0.37144618,-0.34243135,-0.2670897,-0.2310663,-0.14817375,-0.080320655,-0.091976436,-0.023315361,0.044178875,0.11020615,0.11113402,0.092972085,0.10565623,0.10751766,0.055381367,-0.0053670606,-0.13340885,-0.17917328,-0.11574109,-0.023790858,0.041176879,0.025085636,0.11852059,0.11285728,0.16093251,0.18374423,0.10919005,-0.01539181,0.0071671903,0.1119292,0.053021222,0.14079728,0.13763797,0.18336993,0.12630191,0.019380859,0.053388333,0.14089516,0.14228936,0.19477044,0.23484641,0.14016462,0.15713415,0.23779425,0.24322937,0.31655545,0.28433735,0.34965808,0.39762318,0.4942539,0.50773948,0.59814442,0.65894519,0.74643192,0.76651038,0.6530501,0.5143229,0.40046456,0.25937997,0.1552476,0.088918324,-0.053583203,-0.16878835,-0.26697272,-0.38513863,-0.45332553,-0.58021977,-0.66915435,-0.7965567,-0.89544492,-1.0220875,-1.1130773,-1.1978838,-1.3178227,-1.3677683,-1.3400555,-1.3010044,-1.1607544,-1.0339752,-0.96177171,-0.85022046,-0.78854281,-0.79709976,-0.7316624,-0.62835505,-0.50381761,-0.49359512,-0.38326676,-0.28422956,-0.26414439,-0.27086184,-0.36438361,-0.4991914,-0.63576162,-0.74944337,-0.86181339,-0.96807057,-1.0410122,-1.0607316,-1.0756936,-1.1198385,-1.0323248,-0.96077031,-0.83696817,-0.75015148,-0.69231745,-0.57609956,-0.45855955,-0.38510613,-0.33421106,-0.2132479,-0.094412833,-0.02506154,0.075438112,0.18101039,0.27993903,0.29837392,0.26274872,0.27726104,0.24184559,0.19360428,0.29490637,0.38367382,0.48529243,0.49535629,0.59477037,0.70014493,0.74925863,0.84270364,0.82813203,0.81839898,0.79213002,0.89879114,1.0161225,1.0421149,1.1589487,1.211258,1.2850012,1.2571463,1.236659,1.3540143,1.4680163,1.5345882,1.6297282,1.6243459,1.7335521,1.8198694,1.8937813,1.9559681,2.0725883,2.1887661,2.3183364,2.4264916:6
1.5181764,1.4020276,1.3100015,1.1925166,1.1247718,1.0190498,0.88132134,0.79404333,0.77134139,0.66181365,0.58112714,0.47721912,0.37888865,0.3803243,0.45047194,0.37845982,0.27329129,0.19365454,0.14427649,0.13389387,0.049888451,-0.049989634,-0.11130057,-0.19538144,-0.10631611,0.0068940956,0.10285592,0.032265287,-0.050332814,-0.10276885,-0.12935187,-0.22148677,-0.32629258,-0.41426405,-0.52311376,-0.53789144,-0.65600547,-0.71252154,-0.76837757,-0.77548421,-0.81550715,-0.85442477,-0.86850362,-0.92593793,-0.96175828,-0.8472692,-0.71026378,-0.58606001,-0.4660493,-0.33841047,-0.20720354,-0.082533605,0.045342081,0.16550727,0.29747124,0.31277728,0.26480111,0.24794053,0.25443282,0.19756995,0.13208065,0.17198577,0.12006791,0.061813147,-0.028911955,-0.12037333,-0.14325259,-0.037444577,-0.050364368,-0.1221959,-0.20207155,-0.28431286,-0.3528294,-0.39614548,-0.31686255,-0.22612729,-0.26901837,-0.34922345,-0.4311359,-0.49063951,-0.57574565,-0.68013364,-0.77218718,-0.8676371,-0.95624347,-1.0418238,-1.132181,-1.2161966,-1.2850722,-1.3293416,-1.3253222,-1.3462282,-1.3871113,-1.3887879,-1.4503373,-1.5319112,-1.5879835,-1.5111656,-1.3801764,-1.2556082,-1.1292331,-0.98729791,-0.8516003,-0.72236859,-0.56638598,-0.45317766,-0.32562644,-0.18893504,-0.07774203,0.039083664,0.15251731,0.27073364,0.3834613,0.50693675,0.62115141,0.72425457,0.83909171,0.94637448,1.0507793,1.1727207,1.2668054,1.3773354,1.4892336,1.5994623,1.7115256,1.8247324,1.9284037,2.0389519,2.1584771,2.2583869,2.3758132,2.4947232,2.5959943,2.7160062,2.7637144,2.6303383,2.5314587,2.4247068,2.3000352,2.1922022,2.0663559,1.954939,1.8410606,1.7255217,1.614987,1.5058061,1.3931274,1.2773063,1.1657797,1.0523017,0.93563144,0.82031816,0.71806282,0.59352364,0.4911451,0.36679209,0.24392989,0.13006832,0.011887107,-0.11226154,-0.22365133,-0.35934568,-0.48565656,-0.58946445,-0.68204701,-0.71302568,-0.68608442,-0.80043669,-0.90817129,-1.042294,-1.1745534,-1.3262219,-1.3634963,-1.3509417,-1.3338775,-1.3010564,-1.2596101,-1.1930926,-1.1130122,-1.0169059,-0.95205207,-0.90223724,-0.87073334,-0.84335112,-0.7938166,-0.75324411,-0.66675225,-0.57346399,-0.60226602,-0.55959756,-0.50908762,-0.46178353,-0.45548579,-0.46748744,-0.59866492,-0.72338398,-0.69421865,-0.64151768,-0.58225066,-0.52553654,-0.46497502,-0.41136414,-0.3518044,-0.28538575,-0.30324848,-0.22531197,-0.16937354,-0.20000995,-0.23092802,-0.25580633,-0.27403899,-0.28511732,-0.29010113,-0.28859824,-0.27983173,-0.26562458,-0.24433678,-0.21726157,-0.22261649,-0.37448306,-0.49401335,-0.56150532,-0.4982125,-0.43409021,-0.35736623,-0.27146257,-0.19966614,-0.10206356,-0.033706469,-0.048753129,-0.19163788,-0.16764737,-0.081930158,0.0097235543,0.10207671,0.051091381,0.16201062,0.27474117,0.35044853,0.44669319,0.52811953,0.51106247,0.38197294,0.24755163,0.34382587,0.46613635,0.5663607,0.67205162,0.73337617,0.8321078,0.96409781,1.0991915,1.0566888,0.9595599,1.0480814,1.1316678,1.203461,1.2776767,1.3872786,1.5346672,1.5587818,1.5547944,1.6790099,1.7614142,1.8042579,1.8836318,1.9425952,1.94099,1.8328461,1.7132238,1.5581548,1.4133557,1.2460393,1.1243628,0.98133682,0.83624604,0.69495242,0.54374722,0.43142343,0.29090203,0.143564,0.0077286444,-0.12310765,-0.19414717,-0.19843419,-0.26920766,-0.39818808,-0.53538859,-0.68562941,-0.8000631,-0.92555402,-1.0914634,-1.2315862,-1.3634673,-1.4938006,-1.6268254,-1.7593686,-1.7939783,-1.7647255,-1.7738755,-1.7606256,-1.6744083,-1.5910787,-1.5092548,-1.420402,-1.3258141,-1.2164615,-1.1505958,-1.2365653,-1.2154683,-1.0879373,-0.95885328,-0.83939283,-0.69465819,-0.57646832,-0.55610582,-0.45643073,-0.3643798,-0.27029604,-0.17694049,-0.0904789,-0.018071969,-0.093607138,-0.21225872,-0.3134657,-0.41213298,-0.48098698,-0.45350962,-0.35267178,-0.25716733,-0.14714828,-0.11444711,-0.042197694,0.064046763,0.18147655,0.29290643,0.41296982,0.52640389,0.50555232,0.52483478,0.63510055,0.74151557,0.86380032,0.97953982,1.0705215,1.2175146,1.3491258,1.4704069,1.6045486,1.7356922,1.8026718,1.7079238,1.5938453,1.4407059,1.3288871,1.1823916,1.0523278,1.0119709,0.88370741,0.74275874,0.59648396,0.51128547,0.45563315,0.48716923,0.38718425,0.245564,0.14952872,0.068367338,-0.058306869,-0.091144805,-0.21968972,-0.35312011,-0.44173253,-0.54504941,-0.44819281,-0.35573498,-0.2956176,-0.16107495,-0.072756127,-0.1159593,-0.23221846,-0.34157041,-0.43539053,-0.48295927,-0.59852642,-0.71706235,-0.83090033,-0.95438017,-1.0704923,-1.079103,-1.1060342,-1.2185263,-1.3372536,-1.4327836,-1.5468612,-1.6513111,-1.7100261,-1.7662479,-1.8252823,-1.9134986,-1.9761124,-1.8369029,-1.72919,-1.5939665,-1.4536689,-1.311223,-1.1361646,-0.99590433,-0.81862939,-0.64982032,-0.56557103,-0.61556541,-0.51610442,-0.33872105,-0.16619543,-0.010963969,0.16225215,0.31722408,0.4043401,0.51420905,0.6340528,0.75031973,0.92832287,1.1066088,1.2840299,1.4314564,1.5397059:3
0.088649138,0.047539909,0.040165783,0.041931564,0.028796521,0.054221977,0.010545468,-9.1331772E-4,0.018398252,0.034315233,0.031599728,0.042796658,0.039147622,0.06031246,0.082574978,0.08736633,0.092744926,0.11933938,0.15171298,0.16738639,0.17557515,0.20724866,0.22888935,0.25109691,0.32848965,0.38677433,0.42308392,0.48241406,0.49393314,0.50762853,0.57124757,0.6300565,0.6623762,0.73143531,0.74676885,0.78838316,0.83931613,0.87676907,0.86346492,0.87023263,0.87250507,0.87993426,0.87443099,0.88371097,0.87617428,0.8796679,0.86507191,0.84748363,0.86063389,0.92285184,0.88427025,0.91143137,1.0043983,1.0321966,1.0464394,1.0011123,0.976974,0.97489514,1.0088452,0.98310045,1.0178482,1.045107,0.99844365,0.88822315,0.77610241,0.69004255,0.59319689,0.51320024,0.49215593,0.42217892,0.31295379,0.25318301,0.14095745,0.029211054,-0.062854381,-0.12341569,-0.22372982,-0.29010413,-0.34667702,-0.33393161,-0.40401477,-0.42656283,-0.41875827,-0.39918374,-0.3654747,-0.30847109,-0.27153548,-0.18971564,-0.14741772,-0.1304162,-0.085241013,-0.052392988,-0.054392741,-0.032703792,-0.0089278094,0.044144725,0.13584857,0.19525876,0.28540751,0.36483096,0.41913444,0.47088507,0.52604188,0.56432361,0.62432995,0.67952985,0.74352437,0.78788831,0.8282893,0.86991543,0.86520855,0.86722746,0.8875288,0.95452936,1.0119528,1.0679866,1.1095737,1.0657033,0.98031894,0.86477773,0.77578789,0.69638505,0.65049257,0.56243655,0.50173557,0.42023217,0.32700362,0.287292,0.33691472,0.36802285,0.37432582,0.4339047,0.48478286,0.52571841,0.54977708,0.57821513,0.58399319,0.60310987,0.63007646,0.65840157,0.67226466,0.70795751,0.70428816,0.73718048,0.81213252,0.88537653,0.91893544,0.87232674,0.8165342,0.78039902,0.73323409,0.68315936,0.58937762,0.50675241,0.43019865,0.34576807,0.25993591,0.16963775,0.092452023,0.016757906,-0.033433627,-0.095980086,-0.13779941,-0.21605515,-0.3114174,-0.39351941,-0.48252194,-0.55889601,-0.6511574,-0.67328323,-0.73792063,-0.81790258,-0.83588865,-0.84728014,-0.87159052,-0.88501977,-0.90661584,-0.93346742,-0.95946414,-0.97040638,-0.97608075,-1.0312201,-1.0820413,-1.1421836,-1.2244575,-1.2766513,-1.289823,-1.3130372,-1.3445066,-1.3732686,-1.4354707,-1.4877318,-1.5405846,-1.6284189,-1.7093022,-1.7878458,-1.8804876,-1.9668277,-2.0490598,-2.1202318,-2.1955183,-2.2710245,-2.3451996,-2.4190701,-2.5092947,-2.5861557,-2.656247,-2.7264496,-2.8001268,-2.860938,-2.9176447,-2.9645332,-2.9572321,-3.0061742,-3.0406455,-3.0430893,-3.0540987,-3.0065428,-2.970764,-2.9314874,-2.8361095,-2.7683414,-2.7134842,-2.6257138,-2.5494419,-2.4610921,-2.3640155,-2.2689949,-2.1758286,-2.0933687,-2.0617351,-2.0125668,-1.9244338,-1.8175375,-1.7215534,-1.6263062,-1.5488474,-1.4465237,-1.3638599,-1.2975498,-1.2259035,-1.143501,-1.064144,-0.96405127,-0.88096446,-0.79892951,-0.71282875,-0.64116464,-0.55039889,-0.46415899,-0.36965713,-0.36125117,-0.31411704,-0.2113375,-0.12491385,-0.037379576,0.036835051,0.12174078,0.22311845,0.30248689,0.39518862,0.48096919,0.55430973,0.64085435,0.71639036,0.75219356,0.84147585,0.94239686,1.0255032,1.0369048,1.0123408,0.99797771,0.97687174,0.96088381,0.94170453,0.89632467,0.85851218,0.81151086,0.77500913,0.73206364,0.66302022,0.63317945,0.59991489,0.56424103,0.5481645,0.55516968,0.5831457,0.60956297,0.59382427,0.55776819,0.50736763,0.48026075,0.4564625,0.43011047,0.40994136,0.38668522,0.36171122,0.36876946,0.38238697,0.45228089,0.52012406,0.5446357,0.59606848,0.69702511,0.77378366,0.81422141,0.91515506,1.0072974,1.0571363,1.1386736,1.1976121,1.2592124,1.2467803,1.2006007,1.135731,1.0800755,1.0204651,0.96922392,0.89832195,0.84879386,0.82043694,0.79727566,0.7600579,0.73978287,0.70200603,0.66459579,0.62782488,0.58929083,0.53963975,0.49976376,0.45906588,0.41065889,0.36508262,0.33220129,0.29590772,0.26439655,0.22121343,0.18613682,0.13433913,0.083982354,0.045879142,0.0024048413,-0.042968439,-0.10199422,-0.14189031,-0.18282314,-0.20286113,-0.21875769,-0.17752049,-0.098648587,0.018138559,0.13177278,0.23086434,0.27953479,0.35024628,0.45895084,0.51360152,0.6207744,0.73756236,0.79448618,0.83045824,0.80392591,0.73069987,0.69552856,0.680728,0.67357657,0.66465922,0.66699721,0.67811519,0.70270071,0.73719175,0.73260615,0.7108048,0.67281365,0.62036531,0.56754095,0.52721284,0.48692046,0.43009618,0.3915591,0.3721377,0.33205908,0.31403404,0.27914875,0.26035102,0.22154195,0.20725776,0.15104617,0.17649126,0.1403944,0.12244557,0.083072711,0.050588772,0.057146189,0.11139234,0.05061821,0.0021476342,-1.5544385E-4,-0.021700109,-0.051170392,-0.010291796,-0.065229906,-0.066485619,-0.095925579,-0.092717404,-0.08223603,-0.084688492,-0.076812076,-0.056983481,-2.2087083E-4,0.041602989,0.083871538,0.12741744,0.15813262,0.11503806,0.12826784,0.12620286,0.065464241,0.063512962,0.004430898,0.0020227225,0.033135378,0.051222887,0.03606497,0.045450014,0.075107406,0.10124383:5
1.0066967,0.89564255,0.72304499,0.50557272,0.38706009,0.26513568,0.082434985,-0.066522377,-0.2594447,-0.40232593,-0.36925454,-0.54732815,-0.68565623,-0.85852619,-0.79660101,-0.70458298,-0.61914261,-0.5581969,-0.62849482,-0.51639752,-0.4044631,-0.25395857,-0.15915304,-0.036360812,0.071811201,0.08473103,0.096738518,0.17928037,0.32624611,0.44554744,0.59778932,0.5208683,0.63216285,0.73874931,0.88914824,0.84168409,0.93886215,0.96318509,1.1131622,1.2602127,1.3530951,1.3175232,1.1360807,0.94392709,0.73004626,0.60256266,0.46938525,0.40469137,0.32336789,0.173303,0.03684792,-0.14016158,-0.2202533,-0.27418106,-0.41299525,-0.53672196,-0.71281319,-0.79234779,-0.85173004,-0.72555469,-0.58888234,-0.40785797,-0.41515446,-0.25554927,-0.036941737,0.1386834,0.28402772,0.38822604,0.43844647,0.42617924,0.48578374,0.5521441,0.61380389,0.53500658,0.56108969,0.72010961,0.70210131,0.82523898,0.77251854,0.82228349,0.82955823,0.78787945,0.74306258,0.66266317,0.61720382,0.48874888,0.37019804,0.28346562,0.11838022,0.10886002,-0.016408976,-0.13905044,-0.16457078,-0.36460039,-0.48350615,-0.69964837,-0.54967131,-0.51426151,-0.48233296,-0.48782997,-0.37923388,-0.50012831,-0.48762446,-0.66126174,-0.65259685,-0.47485679,-0.33504192,-0.21272328,-0.044492187,0.0088841908,0.1233589,0.25299566,0.35886491,0.52651594,0.6072796,0.76828148,0.86201255,0.93477587,1.1220149,1.2984943,1.4787315,1.6922441,1.7519537,1.892963,1.9781045,1.9911827,1.8989989,1.7882664,1.6816139,1.5557116,1.5604439,1.4367698,1.3443308,1.2854085,1.2452564,1.1773531,1.0559519,0.91582427,0.8232007,0.71639742,0.58959534,0.40309901,0.41768419,0.29421974,0.30332243,0.34080976,0.21810491,0.16992619,0.056854168,-0.073997442,-0.16060009,-0.29739144,-0.33485274,-0.3809555,-0.56426234,-0.54093838,-0.72967212,-0.75389487,-0.89485634,-0.87897785,-0.75839222,-0.67191332,-0.55581711,-0.35853808,-0.18019721,-0.050594751,0.07991166,0.25848812,0.43883978,0.6242689,0.80753216,0.98851864,1.1805092,1.3644797,1.552973,1.7413836,1.8851419,1.8547485,1.7485926,1.6161638,1.5093312,1.4168001,1.2710594,1.1873296,1.1997258,1.064497,0.94133012,0.79286032,0.70619297,0.57743655,0.47710321,0.43377334,0.35095414,0.22062434,0.096927267,0.034858431,-0.080128998,-0.12626404,-0.17932708,-0.2778696,-0.37665102,-0.49940645,-0.59966852,-0.53706439,-0.32165198,-0.14706099,-0.036360812,0.1290883,0.3099054,0.46753368,0.66670799,0.77438098,0.63921637,0.55063236,0.45397221,0.39207112,0.35094298,0.29627784,0.21586782,0.28977712,0.22370946,0.19466267,0.12073247,0.23887319,0.15465206,0.082956091,0.047744637,0.020010547,-0.049878049,-0.11173924,-0.16445983,-0.27345715,-0.35001387,-0.44630205,-0.32982888,-0.20682887,-0.11692896,0.019446879,0.18037724,0.025390853,-0.055656193,-0.12636396,-0.19873724,-0.22997931,-0.36301118,-0.37932554,-0.47091046,-0.61947187,-0.77904465,-0.95205634,-1.1098092,-1.2682953,-1.442819,-1.5931889,-1.742354,-1.9170519,-1.9998924,-1.8272713,-1.9304505,-2.0619504,-2.1274928,-2.1226149,-2.2863477,-2.3536422,-2.4342513,-2.5131131,-2.5053909,-2.3069063,-2.1308963,-1.9868016,-1.8171644,-1.7776229,-1.6985604,-1.4834849,-1.3168404,-1.1085119,-1.0873792,-0.89789113,-0.67856142,-0.49036908,-0.29122971,-0.22206607,-0.079603202,0.11976841,0.28240436,0.4756214,0.60375607,0.7269242,0.91192136,1.067262,1.2835723,1.3613014,1.5477763,1.7451085,1.9661071,2.1820966,2.3042762,2.4697369,2.5021629,2.4611248,2.3352718,2.182962,1.9967646,1.8015432,1.6505909,1.4373959,1.1858964,1.0261537,0.89351659,0.68096282,0.55889935,0.36685612,0.30399346,0.11762341,-0.078510619,-0.098154045,-0.32235423,-0.5378059,-0.73041391,-0.97561036,-0.94571018,-1.1284011,-1.2400005,-1.4049911,-1.509314,-1.6036966,-1.741,-1.849971,-1.935294,-2.0556583,-2.1515553,-2.1420888,-2.3695912,-2.3877243,-2.3597345,-2.3723335,-2.2571065,-2.2295505,-2.1774977,-2.1529433,-1.9966716,-1.9399882,-1.8507425,-1.6969397,-1.5588217,-1.3805583,-1.2293199,-1.0857699,-0.96303884,-0.84432957,-0.70576909,-0.62142932,-0.50068869,-0.39447515,-0.28012268,-0.18930752,-0.15904617,-0.050731704,0.05486015,0.1408007,0.27348433,0.37147119,0.27494395,0.1072942,-0.09316057,-0.32352285,-0.49297559,-0.65412981,-0.73058785,-0.82599247,-0.76346098,-0.62906105,-0.48792551,-0.35445706,-0.26343866,-0.14240788,-0.016201453,0.070204309,0.11667841,0.19897464,0.27461812,0.32151813,0.36030867,0.35219313,0.32105783,0.40718287,0.50058845,0.62039187,0.75121647,0.80398866,0.70794702,0.52446633,0.34705786,0.17953904,0.12793385,-0.021297262,-0.18454921,-0.25430422,-0.40702036,-0.42729386,-0.61807282,-0.66875281,-0.62761292,-0.61440903,-0.49020518,-0.39739913,-0.33575132,-0.25043964,-0.1672229,-0.10495667,-0.028660797,-0.09102021,-0.1413687,-0.12795189,-0.096912858,-0.010887637,-0.032312714,0.03545945,0.097816502,0.13044023,0.27704998,0.38462592,0.52264354,0.65794002,0.82951318,0.94677511,1.0013222:1
-0.35716353,-0.42372567,-0.4896125,-0.56035501,-0.61888371,-0.68185461,-0.73469562,-0.78783624,-0.84582604,-0.85948839,-0.86062024,-0.90176432,-0.94079612,-0.97818135,-1.0214657,-1.0550234,-1.0942118,-1.1308904,-1.1597134,-1.198978,-1.2284412,-1.2610481,-1.2798054,-1.3079133,-1.3340169,-1.3509266,-1.3569659,-1.3799934,-1.3772789,-1.3959548,-1.4062075,-1.3994267,-1.4052995,-1.4272725,-1.4193698,-1.399173,-1.3917743,-1.38208,-1.370799,-1.3564037,-1.3298822,-1.3098903,-1.2839444,-1.2516174,-1.2449725,-1.2060318,-1.1490531,-1.1046914,-1.0125895,-0.91753269,-0.84552397,-0.76589752,-0.70308268,-0.62034885,-0.5405634,-0.47729847,-0.39005195,-0.32719682,-0.25712513,-0.18447844,-0.1305843,-0.098680788,-0.074498725,-0.048157129,-0.031301981,-0.010722024,0.019198818,0.049285356,0.079239792,0.11415143,0.14487838,0.17306037,0.24509932,0.32462363,0.33892936,0.37144458,0.43866204,0.4795815,0.48490057,0.50466664,0.52070833,0.54501777,0.57916821,0.58859915,0.62649234,0.64168771,0.67430206,0.70014125,0.72693516,0.76140994,0.79006164,0.82733924,0.85786564,0.89760345,0.92772481,0.95059252,0.97707244,1.0127193,1.0425499,1.0778666,1.1064969,1.1294551,1.1525994,1.176882,1.1966404,1.2082863,1.217966,1.2226646,1.2278027,1.2235675,1.2146705,1.2063258,1.200771,1.1840134,1.1676177,1.1563213,1.1655354,1.2030981,1.2690842,1.337292,1.4343864,1.51155,1.4683208,1.3648666,1.2661052,1.2450576,1.3263152,1.3153451,1.2431566,1.1754042,1.1405708,1.1460564,1.1692703,1.1750339,1.1930235,1.1917055,1.1818961,1.1670258,1.1549014,1.1378535,1.1162768,1.1022177,1.0801326,1.0696939,1.0543635,1.0491607,1.0414632,1.0350753,1.0280719,1.0211235,1.0109153,0.99970371,0.98619342,0.97853382,0.97331573,0.97672804,0.97820995,0.98807239,0.99648755,0.99763078,0.97544822,0.96363879,0.95633434,0.94008289,0.92586523,0.91328194,0.90753737,0.88170582,0.86064285,0.83608687,0.81519965,0.79169573,0.76991641,0.75234865,0.70798883,0.63400529,0.54100247,0.47152255,0.4028121,0.31788163,0.25089336,0.17602071,0.11358162,0.046097368,-0.023453915,-0.088764708,-0.1464979,-0.2070189,-0.25945146,-0.28399624,-0.31924984,-0.33460673,-0.34396212,-0.34300065,-0.33960999,-0.32668203,-0.31644637,-0.30573627,-0.28311446,-0.27780574,-0.27010622,-0.26502702,-0.253661,-0.24276708,-0.22113685,-0.21036118,-0.21606436,-0.25898993,-0.24717303,-0.2091104,-0.16773938,-0.13671783,-0.098436281,-0.078345529,-0.14640587,-0.2183694,-0.30035904,-0.39482059,-0.49971295,-0.55932998,-0.61620488,-0.68881147,-0.79305737,-0.86812998,-0.96968967,-1.0433791,-1.1483509,-1.2244523,-1.3163435,-1.3939356,-1.455107,-1.5131065,-1.57999,-1.6303657,-1.6856085,-1.7198477,-1.7439903,-1.7657139,-1.7734288,-1.7860886,-1.7902965,-1.8009593,-1.7942225,-1.7758121,-1.7689256,-1.7423888,-1.7115678,-1.6826059,-1.6257302,-1.5647171,-1.5168421,-1.4576157,-1.3904921,-1.3240855,-1.2753635,-1.1985937,-1.1210885,-1.0501194,-0.95901898,-0.89206028,-0.80200679,-0.71653109,-0.67370954,-0.6472603,-0.58288227,-0.5244421,-0.4362017,-0.34362622,-0.24925877,-0.1557349,-0.063700914,0.030946565,0.060743325,-0.039639482,-0.11851222,-0.19651632,-0.27694886,-0.35642456,-0.42313052,-0.49549001,-0.55846129,-0.61826612,-0.66239322,-0.71133612,-0.74119671,-0.74681404,-0.73922052,-0.72600847,-0.70148087,-0.67545413,-0.64461794,-0.6125258,-0.57307879,-0.53327043,-0.47231332,-0.41262069,-0.36072752,-0.29273564,-0.22861051,-0.17516712,-0.10794563,-0.043508431,0.018983188,0.084181599,0.15797044,0.22955949,0.30397189,0.37792971,0.45312209,0.52761917,0.60264559,0.68485718,0.75538482,0.82956257,0.90438689,0.98033983,1.0573676,1.132364,1.1867785,1.1021769,1.0789039,1.1090841,1.1741145,1.2416991,1.3135443,1.4002803,1.4924405,1.5673448,1.6731814,1.7484755,1.8337002,1.9309126,2.0057699,2.1125509,2.0924119,1.9918435,1.890724,1.8215533,1.7267999,1.6539843,1.5554104,1.4893423,1.4474662,1.457142,1.5031743,1.5389289,1.4421492,1.3743419,1.3032248,1.2335406,1.1371277,1.0402194,0.94015213,0.84146099,0.74189489,0.64229257,0.54265142,0.46615437,0.42100892,0.38139486,0.37621736,0.40480955,0.45568752,0.50867044,0.58050527,0.64847274,0.72253329,0.78902003,0.86518724,0.9241716,0.99330734,1.0311326,0.97222113,0.89863419,0.82641761,0.75256225,0.66880806,0.57725772,0.5066138,0.42979711,0.33006887,0.29550721,0.20134273,0.11543677,0.052582646,-0.029642459,-0.11043874,-0.18525251,-0.26512142,-0.3590592,-0.42538107,-0.52284194,-0.59165042,-0.67855788,-0.76369109,-0.85213169,-0.92278007,-1.000157,-1.0847753,-1.1655154,-1.2440953,-1.3039265,-1.3483789,-1.3850393,-1.4386812,-1.4700793,-1.5024144,-1.5175804,-1.5369353,-1.5275623,-1.5264654,-1.5150671,-1.4773587,-1.4400043,-1.3843631,-1.3299295,-1.2687401,-1.1769349,-1.0798023,-0.97776338,-0.87625668,-0.77351034,-0.69725887,-0.5961499,-0.52065491,-0.41571797,-0.34319937:4
1.0541617,1.128083,1.2086565,1.2434306,1.2569705,1.2560246,1.2505429,1.2161137,1.1630853,1.0886186,1.0264655,0.95535172,0.9648751,1.0044637,1.1036538,1.2017969,1.2965095,1.2451479,1.3425304,1.4402527,1.5435972,1.6452627,1.741118,1.8413999,1.9406411,2.0497256,2.1428572,2.0553881,1.9515129,1.8516672,1.7508239,1.6551602,1.5455986,1.451569,1.3501787,1.2724434,1.2677231,1.2848272,1.3064284,1.3153482,1.3528081,1.3459838,1.3711725,1.3868416,1.3773013,1.3273422,1.260868,1.2290637,1.2079154,1.181515,1.1553448,1.1401495,1.1329986,1.1398161,1.1511692,1.0829833,1.0192034,0.94564714,0.87053305,0.74790008,0.67191179,0.61016322,0.54218774,0.47322217,0.42799717,0.39103024,0.36624284,0.35426812,0.34285973,0.32806123,0.32330761,0.33974593,0.3603394,0.37462931,0.37877312,0.32717181,0.31158578,0.32446883,0.36927211,0.4284287,0.49660832,0.56086726,0.48841118,0.40024041,0.32311311,0.23598543,0.14969978,0.10078995,0.037555832,-0.025393579,-0.089091176,-0.15455339,-0.22225204,-0.28690132,-0.34343329,-0.40476177,-0.45784539,-0.51312531,-0.58834083,-0.7087283,-0.81496445,-0.90367742,-0.990407,-1.0667911,-1.111677,-1.16004,-1.2102804,-1.2558216,-1.2847183,-1.2986508,-1.2881773,-1.2720635,-1.2459632,-1.1987759,-1.1523491,-1.0886453,-1.0154022,-0.95889803,-0.88414757,-0.79416294,-0.69770561,-0.60297651,-0.50631869,-0.40801122,-0.30942257,-0.21947125,-0.31300749,-0.35828066,-0.31220207,-0.21672342,-0.12042091,-0.014189221,0.099848046,0.20078802,0.30871039,0.41515076,0.51271888,0.41664966,0.30900106,0.20074648,0.089094514,-0.008495227,-0.1191454,-0.23176883,-0.33259919,-0.43354821,-0.48482339,-0.58715241,-0.69165947,-0.80343719,-0.90886833,-1.0175773,-1.1271168,-1.2324844,-1.3293045,-1.4332531,-1.5402712,-1.6467877,-1.7448584,-1.8467285,-1.9395809,-2.0315394,-2.1064912,-2.1390866,-2.1288254,-2.1020967,-2.0818809,-2.0396729,-2.0047084,-1.9405007,-1.8602435,-1.7789068,-1.6890068,-1.5986139,-1.4902925,-1.3841485,-1.2934402,-1.2017736,-1.1083454,-1.0167252,-0.91919169,-0.81901603,-0.7167579,-0.62396868,-0.52613343,-0.42988301,-0.33590076,-0.22865756,-0.12692835,-0.08706768,-0.026191859,-0.10577307,-0.056130461,0.043688139,0.14302083,0.25388485,0.36705548,0.47509768,0.58431766,0.6847951,0.63662543,0.5257652,0.40546417,0.27401342,0.20631211,0.091532281,-0.036819608,-0.15783167,-0.26978916,-0.25013342,-0.27404201,-0.31243203,-0.34216435,-0.35480191,-0.32351687,-0.28113482,-0.18786164,-0.087429525,0.0024897286,0.10256556,0.20020948,0.29839331,0.39968591,0.50183185,0.60351809,0.70375205,0.8019798,0.90304504,0.99961644,1.1046126,1.205154,1.3076883,1.2725453,1.1746344,1.0827744,1.0575468,1.0984471,1.1951608,1.2950737,1.4025423,1.50348,1.6061951,1.7098498,1.7334664,1.8217324,1.9190926,1.9257598,1.8427105,1.7540319,1.6627231,1.5619023,1.4686234,1.3677271,1.2747783,1.1814761,1.1281368,1.1529861,1.2473827,1.3710787,1.4202187,1.3085327,1.2021587,1.095345,0.99381581,0.8953064,0.79943841,0.69987102,0.59692655,0.49526764,0.40292161,0.30355319,0.19775652,0.097494178,-0.0036095084,-0.10408047,-0.20134361,-0.29784331,-0.39913915,-0.47707496,-0.52145728,-0.51505189,-0.48332138,-0.4373049,-0.36611505,-0.30575295,-0.23275018,-0.14708388,-0.050787359,0.046183292,0.14186431,0.25865451,0.37678229,0.49701698,0.63904831,0.77933465,0.86934815,0.74496107,0.63807662,0.53228419,0.44319846,0.30197174,0.19058903,0.071091162,-0.023111196,-0.085459255,-0.080578433,-0.017883028,-0.082671588,-0.20517426,-0.32731853,-0.44932872,-0.59114878,-0.71021623,-0.83425431,-0.93563314,-1.0772868,-1.2184333,-1.328155,-1.439529,-1.5602095,-1.6751095,-1.7685881,-1.8467403,-1.9297013,-1.9944535,-2.0519311,-2.0820536,-2.0991272,-2.0609802,-1.9764291,-1.8768342,-1.7794076,-1.6822363,-1.5842777,-1.4818233,-1.3771597,-1.2810737,-1.1757585,-1.0733582,-0.96695187,-0.86770327,-0.76645993,-0.66540418,-0.55729318,-0.45005142,-0.35011904,-0.32477049,-0.24503143,-0.1453405,-0.03630996,0.067145836,0.18074099,0.28271346,0.2776963,0.17523858,0.058846319,-0.028347482,-0.11867066,-0.23220858,-0.3217848,-0.33840868,-0.26437061,-0.17287103,-0.26281739,-0.35444366,-0.45937678,-0.55043794,-0.63756879,-0.72958274,-0.80899638,-0.8855634,-0.94871027,-0.99609321,-1.0659587,-1.115216,-1.1527493,-1.1950181,-1.2355892,-1.2653025,-1.2805727,-1.2922453,-1.2845064,-1.2507691,-1.1972447,-1.1291264,-1.0460672,-0.96049963,-0.84242784,-0.74193965,-0.65141142,-0.57830846,-0.50483632,-0.43514724,-0.35533383,-0.27683717,-0.20042407,-0.11967771,-0.042058244,0.029983578,0.10601781,0.18085777,0.20851294,0.20344719,0.19423986,0.17248465,0.15069082,0.13815797,0.11814717,0.10601623,0.11239995,0.12428713,0.13712975,0.16265965,0.17635552,0.17900446,0.19101434,0.2173139,0.24644395,0.32139414,0.40691792,0.49829644,0.59036003,0.70270134,0.7930055,0.86528777,0.93687701,0.99761223:4
2.4438989,2.3243027,2.2114516,2.1013038,1.9818512,1.869472,1.7441679,1.624639,1.5309353,1.4458899,1.3292485,1.2698307,1.1873313,1.0793179,0.96640098,0.90258663,0.89349887,0.79675151,0.68674257,0.62475206,0.53850359,0.50648548,0.53024829,0.38502521,0.31954112,0.18367575,0.12668481,0.058929369,0.061924331,0.10351935,-0.015906437,-0.12917532,-0.21023419,-0.33048015,-0.42868494,-0.51924962,-0.63266752,-0.62892714,-0.53143156,-0.52435761,-0.41328717,-0.34822273,-0.27129084,-0.16789816,-0.073663724,0.0013179168,-0.093557776,-0.19082425,-0.26789325,-0.36486046,-0.46475567,-0.51986932,-0.59998134,-0.68159744,-0.7499425,-0.81218658,-0.89602518,-0.99555951,-1.0861117,-1.1848539,-1.2443322,-1.3052787,-1.3638358,-1.4346071,-1.5503972,-1.647363,-1.7531069,-1.8566772,-1.9577609,-2.0807864,-2.2033805,-2.2892918,-2.3895333,-2.4782467,-2.5595795,-2.596695,-2.6437172,-2.536013,-2.4002278,-2.3022046,-2.1737114,-2.044331,-2.0724136,-2.1268707,-2.0977656,-2.166468,-2.1692651,-2.1840405,-2.1889318,-2.1023664,-2.0831248,-2.0350465,-2.0002886,-1.934261,-1.8485954,-1.7564857,-1.6897345,-1.6033166,-1.5477747,-1.4722995,-1.3739892,-1.2871778,-1.1978165,-1.1359869,-1.0605156,-0.99876939,-0.90958888,-0.82398319,-0.722228,-0.63373872,-0.555392,-0.47765925,-0.38698061,-0.30028635,-0.19418741,-0.11818344,-0.025241691,0.06096263,0.13734341,0.24306713,0.33895317,0.38730275,0.48849011,0.57960793,0.65325369,0.7418768,0.82835716,0.892406,0.9945203,1.0792229,1.170836,1.2855729,1.367747,1.3029375,1.2307645,1.1548379,1.0883758,1.0063812,0.96594228,0.92057997,0.87509256,0.85401659,0.79404431,0.75301009,0.73989303,0.74050945,0.69589566,0.6514608,0.64652574,0.58232013,0.54232303,0.51527238,0.49002521,0.5515375,0.58626552,0.52704173,0.48955904,0.41893466,0.39765686,0.33783579,0.40555924,0.40698518,0.36938519,0.31604058,0.29234851,0.2206527,0.23922004,0.16162883,0.12759938,0.075994713,0.14071223,0.11380719,0.082187954,-0.01068548,0.010856865,-0.083076216,-0.14690757,-0.14201771,-0.22923734,-0.26010647,-0.33657936,-0.35563999,-0.42738456,-0.52333682,-0.61499059,-0.6500949,-0.75490872,-0.86344394,-0.93165188,-0.83693218,-0.71333692,-0.580755,-0.44785753,-0.31324163,-0.1609421,-0.027645871,0.10781362,0.26043875,0.39595232,0.5326534,0.66632655,0.80221272,0.93819282,1.0514761,1.1583015,1.2619233,1.3742228,1.4132084,1.4465745,1.4794021,1.5164538,1.5547794,1.5243169,1.4948469,1.4609403,1.5374736,1.5218657,1.5548683,1.4441769,1.3956462,1.3368936,1.3167739,1.2054551,1.1189376,0.99858593,0.89529944,0.75812684,0.62093686,0.48394924,0.36114151,0.2607841,0.12409117,-0.012669075,-0.16670384,-0.31396448,-0.42348946,-0.57735711,-0.73174362,-0.88220901,-0.90015463,-0.95649541,-0.88213828,-0.8190447,-0.74233819,-0.64980021,-0.54104649,-0.43242667,-0.34853393,-0.27225142,-0.19008844,-0.1331396,-0.16301721,-0.073319954,-0.054381951,0.027725319,0.073842439,0.05927313,0.12166272,0.20917601,0.16769613,0.23760018,0.22415521,0.28722479,0.22271592,0.14544693,0.14608169,0.17247307,0.24825473,0.29404257,0.3100264,0.41678067,0.40792089,0.47371024,0.45693718,0.35663399,0.29528891,0.33262493,0.4149389,0.40386378,0.4713764,0.48882457,0.53361646,0.47636745,0.39975817,0.41599069,0.49544947,0.47336132,0.51392598,0.58741144,0.58472538,0.49754599,0.57397602,0.62149526,0.69676217,0.60727392,0.68070223,0.74994768,0.72343956,0.80203429,0.8950337,0.90286386,0.98737621,1.0789818,1.1440583,1.0057357,0.89433435,0.81157552,0.7049563,0.60063105,0.4988443,0.39693569,0.35068644,0.24765172,0.14391842,0.052722558,-0.04082764,-0.14872233,-0.23722315,-0.32126661,-0.43463515,-0.49422319,-0.61896957,-0.70675537,-0.7812096,-0.87642734,-0.95855279,-1.0482365,-1.1486538,-1.2068324,-1.2732981,-1.1597084,-1.1242649,-1.0086802,-0.96688311,-0.99104876,-0.87148464,-0.81352963,-0.69135654,-0.62603341,-0.57271988,-0.59928652,-0.488207,-0.46872706,-0.37010759,-0.265756,-0.32617944,-0.29181069,-0.22843744,-0.13562622,-0.156017,-0.048713279,0.0058758905,0.033479841,0.14421668,0.17846758,0.28966398,0.38170362,0.45898985,0.3405611,0.21842401,0.14571692,0.029090741,-0.05487426,-0.11827162,-0.21751799,-0.29578259,-0.31156383,-0.38628531,-0.49316575,-0.5706559,-0.66800681,-0.7253403,-0.83367126,-0.90210399,-1.008176,-1.0591504,-1.1467179,-1.2534781,-1.2131201,-1.0923286,-1.0420631,-0.95543631,-0.89726003,-0.78852177,-0.74803567,-0.66838033,-0.59738353,-0.48850917,-0.42597125,-0.36210685,-0.24998818,-0.19043012,-0.10057145,0.0032890308,-0.020438986,-0.0063687791,0.053308181,0.18096617,0.20868498,0.32581799,0.38946684,0.48907301,0.55888728,0.54390133,0.54059877,0.66658575,0.75941824,0.83764805,0.96546238,0.94595783,0.95996564,1.0586913,1.1564304,1.2534168,1.2110088,1.2610282,1.3338166,1.4518679,1.5650115,1.5649659,1.6592893,1.7886185,1.8258226,1.9575077,2.0819055,2.2195191,2.3572037:6
1.1412866,1.0706313,0.985524,0.92012355,0.81776421,0.74276124,0.67225891,0.62200713,0.53499973,0.47208937,0.40484375,0.32875373,0.26529662,0.25485503,0.19478324,0.11060993,0.02439443,-0.058866553,-0.14911605,-0.20543212,-0.30198997,-0.37289212,-0.40038862,-0.36144707,-0.30527282,-0.32639956,-0.42787771,-0.54041264,-0.67480458,-0.79150405,-0.91795589,-0.99172773,-1.060144,-1.1471662,-1.2465198,-1.253062,-1.1998424,-1.1103149,-1.1547425,-1.2372686,-1.3309044,-1.4268321,-1.5175422,-1.6121942,-1.7042383,-1.7899629,-1.8764446,-1.9455323,-1.8707788,-1.7635543,-1.6414325,-1.530396,-1.4073713,-1.3036393,-1.1904925,-1.09509,-0.9717345,-0.89244114,-0.79666806,-0.68534814,-0.56732508,-0.48008375,-0.36874335,-0.26204643,-0.15489793,-0.044266959,0.073666746,0.19284108,0.30770196,0.41768213,0.5339442,0.66804791,0.80220881,0.93621915,1.0478384,1.1269182,1.2733122,1.4056087,1.5412561,1.6870159,1.8074822,1.9321787,2.0729899,2.2056815,2.3236578,2.4805371,2.6243224,2.6969501,2.7087964,2.618387,2.4657846,2.3721431,2.2318484,2.0901533,1.9398221,1.794202,1.6778255,1.6194126,1.4729783,1.3391371,1.2002675,1.0694881,0.99998314,0.87794321,0.78143606,0.64965927,0.59635103,0.46814898,0.34532149,0.21944911,0.099068739,-0.021434791,-0.10474949,-0.21911286,-0.28478212,-0.33037965,-0.44551825,-0.53818779,-0.63546777,-0.73461201,-0.82246054,-0.8798135,-1.0112723,-1.1234363,-1.2456596,-1.3732127,-1.4820199,-1.6245081,-1.7671535,-1.8531611,-1.8483085,-1.8461574,-1.7846409,-1.703616,-1.6408366,-1.5692618,-1.4883606,-1.4032479,-1.3197536,-1.2629849,-1.2659766,-1.3208843,-1.3034708,-1.2206091,-1.1357919,-1.0617311,-0.98633995,-0.89848737,-0.82554937,-0.72603474,-0.65114994,-0.5762943,-0.52941816,-0.53850681,-0.56256728,-0.53238581,-0.42230236,-0.31890994,-0.24625904,-0.15551048,-0.05501167,-0.032527812,0.068734844,0.16177659,0.23146827,0.2882896,0.37796362,0.4910871,0.58958656,0.66621409,0.67358375,0.56809114,0.44753496,0.33598684,0.22655239,0.11863104,0.010585564,-0.098104733,-0.20990483,-0.32447961,-0.4383005,-0.55592953,-0.68048296,-0.79643692,-0.91854914,-1.0489758,-1.1719877,-1.2976298,-1.3747907,-1.3941727,-1.3546126,-1.2347051,-1.1260989,-1.0047941,-0.87523936,-0.76947553,-0.68633604,-0.61068566,-0.53673813,-0.44648644,-0.34046045,-0.25269506,-0.17365374,-0.078376618,0.031482304,0.10432654,0.16365627,0.24504417,0.31916321,0.39518243,0.49074696,0.58446034,0.68166718,0.72281784,0.62253706,0.51527931,0.40685661,0.30201108,0.20023072,0.11719143,0.06545055,0.096899262,0.19960703,0.25008195,0.30065753,0.36806345,0.43292217,0.49777259,0.49518895,0.54356657,0.61595965,0.6937264,0.73697931,0.81273525,0.90274534,0.99901307,0.99350751,0.87708654,0.75887508,0.63225742,0.49823403,0.38326997,0.29547488,0.17501486,0.060704128,-0.062240896,-0.18508612,-0.29646944,-0.37887961,-0.39531036,-0.38781462,-0.44264521,-0.55411073,-0.66430512,-0.77711238,-0.88883902,-0.99732729,-0.93246416,-0.82246619,-0.72496789,-0.63817554,-0.52275518,-0.41008638,-0.28810076,-0.17707963,-0.063137244,0.051547629,0.16725108,0.28154833,0.35726365,0.26019306,0.1685647,0.11295078,0.045347836,0.041852317,0.13319219,0.24890316,0.34251014,0.46599395,0.58000956,0.68471268,0.69152731,0.72717617,0.79683176,0.88451842,0.9964695,1.0811259,1.1729401,1.2934751,1.4248121,1.5126336,1.4208496,1.3217987,1.2282314,1.1656755,1.0805506,1.0002389,0.92050317,0.85721303,0.8439779,0.78947411,0.68097413,0.58322392,0.4916445,0.39224445,0.29961322,0.26110305,0.311724,0.37586867,0.44642327,0.52531626,0.60525521,0.68332096,0.60484506,0.47797264,0.35966148,0.22032199,0.096322033,-0.059342997,-0.19904015,-0.32453217,-0.46188525,-0.5902232,-0.70679462,-0.83461292,-0.9736809,-1.1093659,-1.2185532,-1.3711949,-1.4823095,-1.6219017,-1.734579,-1.850799,-1.9611077,-2.056034,-2.158176,-2.2120581,-2.2231488,-2.1105398,-2.0174889,-1.9406302,-1.8263164,-1.7156607,-1.5961993,-1.4829326,-1.3689675,-1.258534,-1.1607158,-1.0791864,-0.95894414,-0.82713151,-0.71249534,-0.59776312,-0.48562335,-0.37146866,-0.25394459,-0.13666522,-0.098741712,-0.069817869,0.0079138961,0.10940563,0.21392754,0.32380964,0.4351255,0.53999318,0.64624309,0.75490101,0.82715493,0.92697409,1.0346265,1.1490918,1.2570722,1.3673269,1.4748402,1.5892941,1.6477794,1.5320941,1.4239813,1.31254,1.2278677,1.1618858,1.076979,0.99335571,0.89361134,0.83592232,0.80851315,0.72525603,0.62604538,0.5370106,0.44876188,0.36270225,0.29789454,0.31174504,0.37548177,0.43954572,0.53385854,0.64477695,0.72158856,0.8201773,0.92257586,1.0301948,1.0800403,0.97952999,0.87461436,0.7718085,0.66565872,0.55637949,0.46860892,0.38616016,0.30060917,0.19973816,0.091694363,-0.021006623,-0.14554568,-0.25779282,-0.32379455,-0.27724239,-0.13858713,-0.024035126,0.077615014,0.22159043,0.36571842,0.4865775,0.6136642,0.75896822,0.90896089,1.0628614:5
1.8568082,1.7592307,1.7008941,1.6267041,1.5277527,1.4457179,1.3577294,1.3022509,1.2191586,1.1330368,1.0948028,1.0521226,0.97888662,0.91998003,0.84308849,0.83403894,0.74154067,0.67018097,0.65237968,0.68301391,0.72678953,0.79459249,0.91030667,0.96734899,0.90546852,0.8208786,0.73362362,0.69659533,0.62700841,0.56897947,0.45361206,0.37401142,0.33026138,0.24459938,0.13860887,0.054151776,-0.0046228846,-0.063728398,-0.12689057,-0.19792494,-0.28481559,-0.37902218,-0.47524669,-0.58909052,-0.6900943,-0.77345242,-0.80848454,-0.74846782,-0.65677421,-0.55431399,-0.44974149,-0.34114859,-0.22970238,-0.12629239,-0.019485424,0.075870176,0.14554276,0.1938716,0.29542138,0.4016907,0.503803,0.58358936,0.69529923,0.79913959,0.78325268,0.69545497,0.5992804,0.49255688,0.37212431,0.2553688,0.1384491,0.022198457,-0.070994293,-0.18280461,-0.275302,-0.33134512,-0.37499096,-0.45616396,-0.54135419,-0.59094576,-0.65490463,-0.73431765,-0.8243626,-0.91352272,-0.97633885,-1.0047913,-1.0616633,-1.1384138,-1.2053373,-1.2598555,-1.3445979,-1.4382696,-1.519779,-1.595544,-1.638117,-1.5969844,-1.5599504,-1.5072448,-1.4146715,-1.3519258,-1.2598326,-1.2057139,-1.1235623,-1.0332646,-0.9026836,-0.7922151,-0.66672403,-0.55538789,-0.4394276,-0.31600445,-0.20418395,-0.091153855,0.0029697475,0.10686136,0.16794182,0.23661888,0.34986765,0.43001413,0.53506565,0.60748251,0.6849489,0.77752672,0.89646432,1.003149,1.0488364,1.1626494,1.2524728,1.2933292,1.3302155,1.4232737,1.5204177,1.6131981,1.7118753,1.7830885,1.8670994,1.9456149,1.9628574,1.8836646,1.7769934,1.702551,1.6408932,1.5922745,1.5063021,1.4073265,1.3692928,1.3230671,1.2503168,1.2266644,1.1365276,1.1471119,1.0771948,0.99375839,0.93760032,0.84043935,0.74268411,0.64353623,0.54326094,0.47470687,0.36935545,0.27735429,0.22311855,0.12682709,0.024145584,-0.088865807,-0.17603728,-0.28319526,-0.36971237,-0.45026327,-0.54674204,-0.60084507,-0.71787775,-0.84486439,-0.97888392,-1.0478376,-1.0802793,-1.1318833,-1.0975592,-1.0819757,-1.0219106,-0.94108623,-0.85252717,-0.77026372,-0.67975198,-0.60908143,-0.54232498,-0.48817489,-0.45047441,-0.43175197,-0.40204242,-0.32016396,-0.21826937,-0.15696297,-0.04195052,0.06608442,0.14998071,0.23837416,0.33213733,0.40903731,0.43703051,0.49846106,0.43512937,0.32477612,0.22066877,0.10957372,6.1544168E-4,-0.08817839,-0.19102905,-0.26106508,-0.35379887,-0.46524959,-0.57588011,-0.68546472,-0.80534159,-0.87388066,-0.95597487,-1.0204075,-1.0590719,-1.0921864,-1.084179,-1.050919,-0.99995392,-0.93451657,-0.85943102,-0.7826264,-0.74726219,-0.68742091,-0.65694324,-0.58819494,-0.54744965,-0.51448928,-0.42771949,-0.34958301,-0.25941756,-0.16849631,-0.090081287,-0.043833384,0.0029072271,0.079456269,0.15125844,0.22950412,0.29928061,0.31384008,0.21481642,0.14110451,0.16592481,0.19669557,0.25752385,0.30301067,0.38380128,0.4663925,0.52118281,0.58257853,0.61966774,0.69623416,0.74631998,0.8308781,0.87024903,0.96423006,1.0478021,1.1293963,1.1973622,1.2888855,1.3555234,1.4235138,1.3137482,1.1983184,1.0879272,0.97091287,0.84357416,0.73352074,0.64596385,0.52854235,0.41010602,0.29961556,0.18632664,0.068477909,-0.015965853,-0.05691475,-0.168552,-0.28214359,-0.39553303,-0.50230368,-0.61457456,-0.72647784,-0.83600633,-0.95046221,-1.0390437,-1.0819189,-1.1836219,-1.2992371,-1.4086605,-1.5191182,-1.6031715,-1.7070125,-1.7986518,-1.8624296,-1.9558105,-2.0156681,-2.1083555,-2.1847344,-2.294174,-2.3787295,-2.357381,-2.33041,-2.201951,-2.1064885,-1.9884754,-1.9242845,-1.8613264,-1.7978685,-1.7186032,-1.6754051,-1.5539122,-1.4448372,-1.3244306,-1.2521614,-1.1392068,-1.0334452,-0.90440634,-0.77961831,-0.65622819,-0.54969601,-0.41551425,-0.26601451,-0.14160786,-0.023695217,0.08214579,0.18836513,0.16952168,0.19340253,0.24962897,0.31892287,0.41792201,0.53185007,0.61170104,0.6607536,0.77318986,0.86320575,0.98579248,1.0560344,1.1123806,1.2042457,1.3078152,1.4053872,1.4989389,1.5914015,1.6929769,1.8135297,1.8924424,1.7892218,1.6761017,1.5655004,1.5004809,1.4004913,1.3041312,1.1974972,1.1734146,1.0876321,1.0139506,0.93653619,0.86590602,0.79335892,0.70810774,0.63398643,0.61664655,0.65972888,0.73277325,0.67995838,0.57400391,0.47060041,0.33922065,0.21620445,0.10713688,-0.015408514,-0.10669066,-0.17115062,-0.27418949,-0.374915,-0.4869359,-0.55942211,-0.66532359,-0.77258539,-0.89230164,-0.99736977,-1.123457,-1.2323597,-1.308951,-1.383529,-1.4938952,-1.5638078,-1.62818,-1.6804263,-1.6375002,-1.6014553,-1.5108356,-1.4564197,-1.3443412,-1.2806422,-1.1866737,-1.0927935,-1.0215813,-0.90903512,-0.79780306,-0.69553764,-0.5786625,-0.4957985,-0.41052814,-0.32192238,-0.20764553,-0.092587178,0.017193003,0.13288224,0.2476414,0.35034122,0.42714116,0.55121045,0.67543443,0.79537844,0.92088305,1.0368093,1.1365695,1.2618206,1.3858834,1.515959,1.6371011,1.7516777,1.8802629:5
1.9669672,1.9553236,1.9272584,1.886538,1.8430499,1.811804,1.7658396,1.7090216,1.6660227,1.6108897,1.5442166,1.4947701,1.4304173,1.3698844,1.3068265,1.2559105,1.1946907,1.116756,1.0578866,1.0052126,0.95382535,0.89803147,0.83516557,0.75338951,0.67908212,0.6066139,0.52537581,0.51098705,0.54547421,0.58579217,0.62585984,0.66246071,0.68861311,0.69985344,0.70813366,0.72185065,0.70498115,0.68046351,0.66368034,0.62911859,0.59297125,0.55108268,0.48127827,0.43898747,0.38617149,0.32478343,0.2487878,0.17233505,0.093187137,0.012863912,-0.064146858,-0.14515538,-0.20329493,-0.2871337,-0.35918625,-0.43338551,-0.50828356,-0.57642909,-0.64602829,-0.71748989,-0.78189851,-0.85235119,-0.92338571,-0.98793242,-1.0555588,-1.1249245,-1.2005319,-1.2765402,-1.3412233,-1.4020139,-1.4756707,-1.5397572,-1.6060165,-1.6861712,-1.740037,-1.8031897,-1.873935,-1.945969,-1.9953662,-2.056912,-2.1072097,-2.0880656,-2.0262246,-1.954937,-1.8792029,-1.8078827,-1.7377034,-1.6530441,-1.5737888,-1.5139994,-1.4237046,-1.3359121,-1.2470349,-1.1968625,-1.1447885,-1.0784359,-1.0416808,-1.0145257,-0.96760736,-0.94156005,-0.91554446,-0.89799835,-0.88902024,-0.88162126,-0.87877487,-0.8837518,-0.88778291,-0.89211667,-0.899021,-0.89278474,-0.89022844,-0.89501453,-0.9000435,-0.89454602,-0.89488235,-0.89446189,-0.88967007,-0.87963931,-0.86958511,-0.85936799,-0.8544071,-0.8371002,-0.82865508,-0.80740336,-0.81034216,-0.80337253,-0.80893245,-0.79098658,-0.79039874,-0.77382964,-0.75659102,-0.7017072,-0.63782803,-0.56054094,-0.49782328,-0.44771966,-0.36773453,-0.29738407,-0.23237426,-0.17834639,-0.14211314,-0.1076842,-0.067097231,-0.048867468,-0.022038657,-0.005524072,0.017709552,0.039498788,0.043948151,0.053234945,0.061940207,0.07687952,0.078597742,0.085159696,0.097197347,0.098878025,0.10893901,0.12788025,0.14681021,0.18750369,0.23151798,0.26278736,0.28747098,0.31810541,0.35033247,0.39067759,0.46533018,0.52357925,0.60325634,0.67065225,0.73107238,0.79769476,0.85458956,0.86757645,0.86416641,0.88059032,0.95117295,0.98736606,1.0207636,1.0370746,1.0281776,0.99396005,0.95809222,0.89114669,0.84452607,0.78291039,0.72791687,0.67459314,0.67567964,0.72923731,0.79228226,0.84408492,0.94121892,1.0361959,1.0853351,1.15861,1.2535344,1.3084875,1.3516833,1.3351643,1.3649749,1.4201339,1.4422443,1.4369946,1.4872052,1.56399,1.5624949,1.5513503,1.5303346,1.4737961,1.3796622,1.282523,1.2177617,1.1195463,1.0493801,0.95687922,0.89070054,0.8218143,0.75566639,0.74412626,0.76256669,0.77435358,0.79043123,0.80019893,0.80129498,0.789019,0.77448659,0.76000692,0.74671667,0.73400571,0.72501709,0.72805477,0.71711525,0.7040963,0.68481895,0.68948636,0.68235124,0.67348228,0.65333309,0.65244223,0.6304932,0.61909733,0.59688125,0.59157646,0.58348925,0.5576232,0.53636856,0.52235597,0.50058064,0.47713365,0.45265736,0.43780395,0.4096022,0.38266624,0.34204193,0.30173527,0.23708975,0.15750068,0.067167772,0.0085599701,-0.057305763,-0.099372699,-0.13222577,-0.15284164,-0.15655117,-0.15936792,-0.13859397,-0.13503863,-0.13079451,-0.1171695,-0.10620853,-0.098128733,-0.084530114,-0.082573327,-0.074364864,-0.066032689,-0.066182066,-0.064064025,-0.070882993,-0.081254977,-0.07369852,-0.086468888,-0.095203393,-0.11404263,-0.12464566,-0.15071758,-0.16027492,-0.1947095,-0.23572667,-0.28380923,-0.35330544,-0.40417966,-0.4723789,-0.5426306,-0.61687138,-0.68681904,-0.75528666,-0.82357845,-0.89405813,-0.99191775,-1.0605887,-1.123907,-1.225137,-1.2884948,-1.3698336,-1.4529413,-1.549214,-1.6382172,-1.7320682,-1.822409,-1.9008926,-1.9400189,-1.9517385,-1.9441259,-1.9273559,-1.9034396,-1.8809834,-1.8490141,-1.8187431,-1.7895102,-1.7491148,-1.7141686,-1.6822703,-1.6381422,-1.5942296,-1.5558334,-1.5044548,-1.4592488,-1.4168269,-1.3707088,-1.3199712,-1.2700299,-1.2172525,-1.1674145,-1.1227717,-1.0746714,-1.0130438,-0.96802922,-0.92344172,-0.85688775,-0.80650818,-0.75480345,-0.70122462,-0.63746396,-0.5988501,-0.55919658,-0.53371727,-0.46805093,-0.40138987,-0.33787868,-0.27490559,-0.21222491,-0.1540211,-0.087285543,-0.023680873,0.038239703,0.074167117,0.13002582,0.16430581,0.20960161,0.25015673,0.28172342,0.31057692,0.33380029,0.36460822,0.36694592,0.32206558,0.28069673,0.23297265,0.1766927,0.11582813,0.06827846,0.015660731,-0.044495203,-0.10458281,-0.16942742,-0.22360713,-0.2851075,-0.34117623,-0.41301094,-0.47747721,-0.53276975,-0.59075088,-0.64960537,-0.60335569,-0.50820847,-0.42051538,-0.34726938,-0.25569222,-0.1846013,-0.088059819,0.0059615267,0.066978587,0.16964206,0.2610737,0.35214669,0.43625483,0.50124868,0.59388344,0.67438738,0.74151247,0.83380284,0.89306378,0.97964245,1.037101,1.0913101,1.1501315,1.217403,1.2809888,1.341108,1.3835482,1.4305155,1.4738825,1.5122981,1.5556426,1.5957698,1.6308661,1.6704716,1.7064186,1.7440484,1.7840249,1.8180505,1.8590885,1.8916764,1.9253006,1.9570195,1.9754444:2
0.54372562,0.42455572,0.30195602,0.14714456,-0.017968409,-0.15784759,-0.26209833,-0.34126279,-0.3441624,-0.30159091,-0.44099899,-0.6178078,-0.71312236,-0.82341212,-0.86060885,-1.004876,-1.1364148,-1.2443533,-1.191556,-1.1678971,-1.1365654,-1.053893,-1.0071027,-0.85670232,-0.67262306,-0.51461039,-0.32417463,-0.23614306,-0.33094814,-0.4732784,-0.65000602,-0.82364644,-0.96580963,-1.1252154,-1.2914378,-1.4194838,-1.5550158,-1.7073093,-1.8874778,-1.9991714,-2.0829409,-2.147694,-2.339001,-2.4809771,-2.445985,-2.3377828,-2.1970748,-2.0192014,-1.8304034,-1.6220666,-1.4226253,-1.2310846,-1.0577967,-0.97702638,-0.87672551,-0.77772257,-0.66320566,-0.51502316,-0.53050353,-0.42658115,-0.34081979,-0.25764417,-0.226493,-0.24267203,-0.16449456,-0.080890547,0.048710904,0.15069241,0.29870176,0.40085607,0.41514612,0.34819296,0.35638828,0.47808926,0.46283914,0.64894564,0.69911634,0.78332757,0.58243715,0.53138422,0.36052299,0.26127802,0.18823009,0.058401288,0.021864101,-0.064614555,-0.23501459,-0.22641026,-0.32264834,-0.2510049,-0.27812685,-0.16802853,-0.022192905,-0.055634089,-0.071020185,-0.13201331,-0.14376537,-0.2404545,-0.18605243,-0.16559865,-0.020048422,0.055380888,0.20224438,0.29591114,0.30791215,0.32958114,0.38510367,0.3591521,0.31272771,0.34615057,0.24500402,0.12164299,0.0061760883,-0.097872942,-0.19191467,-0.27537368,-0.34831557,-0.40940262,-0.45858894,-0.49525619,-0.51968671,-0.53148943,-0.53058907,-0.51698245,-0.49107823,-0.45302851,-0.40232632,-0.34001986,-0.26566033,-0.1801792,-0.083530209,0.022360492,-0.10836835,-0.19606214,-0.34996268,-0.44277169,-0.57865915,-0.42124859,-0.38540039,-0.58148035,-0.70676942,-0.78422546,-0.87951759,-0.9445493,-1.0634385,-1.1543236,-1.0975525,-1.1682454,-1.0910084,-1.1988897,-0.99885648,-0.9368812,-0.99422648,-0.89834642,-0.94854826,-0.83034198,-0.83977338,-0.85030962,-0.85937526,-0.72326087,-0.66125844,-0.50611288,-0.31096482,-0.099810139,0.068012207,0.15719215,0.28958394,0.38336116,0.43511542,0.57727385,0.53107148,0.59222562,0.64815138,0.6475014,0.68412028,0.69479474,0.5364273,0.38118439,0.24194751,0.12480842,-0.0029668269,-0.083316242,-0.17407927,-0.31750181,-0.3562318,-0.41556522,-0.56339548,-0.7037429,-0.77940813,-0.89376128,-1.0225914,-1.0667263,-1.1685083,-1.3287776,-1.4646829,-1.6130623,-1.599521,-1.7655533,-1.8072515,-1.696117,-1.5650711,-1.609579,-1.5739942,-1.3940774,-1.2618163,-1.1081926,-0.99377641,-0.8406917,-0.76640338,-0.58730605,-0.46935102,-0.40784947,-0.29758192,-0.19226743,-0.1024702,0.081956109,0.25518111,0.44682026,0.5329669,0.62278538,0.70549376,0.7789859,0.75333595,0.89189625,0.95890936,1.079812,1.1834485,1.1781886,1.2457629,1.4371694,1.5477553,1.3476963,1.1528879,0.9629084,0.77845439,0.59998065,0.42771711,0.26235728,0.10414408,-0.046036268,-0.1833399,-0.31566999,-0.4438405,-0.55674779,-0.65905523,-0.74598475,-0.82383433,-0.89005483,-0.94311916,-0.98343375,-1.0098865,-1.0225685,-1.0209366,-1.0064359,-0.9779651,-0.93576442,-0.88068965,-0.81792148,-0.74110128,-0.71436228,-0.81491281,-0.94558086,-1.0303915,-1.1332269,-1.2792616,-1.3273004,-1.340925,-1.2030426,-1.0357196,-0.90748457,-0.80996574,-0.64354978,-0.51866279,-0.40157309,-0.27540009,-0.1399091,0.0042664253,0.15690797,0.31734524,0.48470025,0.65878229,0.83908137,1.0249554,1.0044037,0.99787472,1.129919,1.2549603,1.4364239,1.5776969,1.7554098,1.8908605,1.9983987,2.0319373,2.0129247,2.0533643,2.1545742,2.2457503,2.3745217,2.3946385,2.4808424,2.5758993,2.6623647,2.7003567,2.6299525,2.436575,2.2510423,2.120447,1.9638279,1.7672789,1.5780504,1.4830342,1.3405778,1.1634367,0.95295969,0.79568898,0.58846897,0.38327066,0.27447739,0.18680055,0.079554328,0.071050611,-0.010611215,-0.050934293,-0.15676758,-0.29394559,-0.46286482,-0.4221154,-0.50636403,-0.61577749,-0.48780666,-0.44392771,-0.27319012,-0.1531169,0.064976875,0.22120708,0.31473038,0.44813359,0.48180043,0.64774502,0.76402101,0.97785041,1.1621049,1.3010396,1.3510924,1.2174661,1.1270464,1.0236212,0.93018578,0.78989142,0.73261862,0.64305966,0.54289902,0.53092688,0.48040796,0.51440021,0.56804665,0.65981696,0.69085454,0.75570255,0.83274365,0.94913108,1.059895,1.1639898,1.3099549,1.4870107,1.4664204,1.4488454,1.5309474,1.6091246,1.7408142,1.8604654,1.9093093,2.012917,2.1015645,2.2027808,2.1496521,1.9472251,1.7966226,1.6500979,1.5124609,1.4164774,1.3783107,1.2096161,1.0723396,0.92553599,0.89601971,0.89928076,0.85092692,0.66166133,0.51482514,0.41877912,0.32683594,0.22695757,0.11784139,0.034504225,-0.099654393,-0.22255867,-0.37409683,-0.46915349,-0.5095376,-0.58444661,-0.57211809,-0.47952965,-0.33068326,-0.17711731,-0.055243344,0.10708067,0.25175137,0.10643474,-0.093665405,-0.28477065,-0.45140622,-0.64156634,-0.77084299,-0.81183491,-0.80506697,-0.68208815,-0.47143875,-0.25853809,-0.19540348,-0.038903173,0.18235313,0.39832295,0.57795632,0.72829102,0.76068403,0.64812165:5
1.9376695,1.8518616,1.7586588,1.6690715,1.6260875,1.541806,1.460197,1.3639495,1.2834772,1.1963474,1.1107671,1.026732,0.94953877,0.85715465,0.78652399,0.80279483,0.86783663,0.95598296,1.050229,1.1491654,1.2296858,1.2154984,1.1313761,1.0504843,0.96255757,0.8749059,0.7847965,0.70814212,0.62877995,0.58824873,0.51127183,0.42408115,0.33708831,0.25330088,0.17040004,0.086902384,0.012590896,-0.076942827,-0.16157886,-0.2458499,-0.35083652,-0.42958159,-0.53535086,-0.61591269,-0.70512383,-0.78781182,-0.87089811,-0.94678204,-1.0269097,-1.097964,-1.1639175,-1.1556969,-1.1022704,-1.0390311,-0.9789534,-0.90282956,-0.79421486,-0.67715994,-0.58833191,-0.49786956,-0.39636562,-0.28825866,-0.16970418,-0.07967532,0.034889955,0.14160915,0.23114863,0.32896187,0.41491833,0.51501897,0.47952456,0.38155547,0.30360238,0.2226858,0.14409585,0.065212585,-0.016354491,-0.073079678,-0.12813462,-0.21924527,-0.2878621,-0.34363164,-0.39662927,-0.36856707,-0.44839947,-0.54400937,-0.63846199,-0.73240255,-0.82594633,-0.89785713,-0.98166683,-1.0482533,-1.1189209,-1.195382,-1.2596096,-1.3257735,-1.3716255,-1.4185543,-1.4581786,-1.5025588,-1.5269996,-1.5631094,-1.5900096,-1.6305153,-1.6497794,-1.6795627,-1.6878164,-1.70268,-1.6704129,-1.6134779,-1.5357452,-1.4418727,-1.3543774,-1.2650958,-1.1839244,-1.0980283,-1.0066867,-0.92217114,-0.8378548,-0.74935928,-0.66108583,-0.57912466,-0.48919818,-0.39790859,-0.31207608,-0.23971871,-0.31090522,-0.38562679,-0.47258453,-0.543283,-0.57912895,-0.59014291,-0.5349174,-0.52168031,-0.57225017,-0.62627195,-0.68392731,-0.72431058,-0.77739746,-0.81961488,-0.85797205,-0.87336123,-0.8561608,-0.81919308,-0.76933147,-0.71344373,-0.65566916,-0.59682626,-0.53165149,-0.47471088,-0.37939756,-0.28753891,-0.18747282,-0.091684274,0.0074440994,0.10030347,0.19671661,0.23038922,0.25936748,0.31145042,0.34104565,0.34725446,0.36430474,0.38106146,0.39991574,0.412947,0.41707833,0.41044001,0.40481662,0.40141983,0.40703508,0.41549953,0.43228541,0.45254448,0.49611319,0.52861381,0.56625167,0.59997891,0.60523473,0.60527171,0.56360063,0.52974966,0.49962404,0.47391878,0.46271416,0.45398335,0.43751913,0.42167887,0.40585857,0.42853665,0.50227182,0.59306628,0.67491415,0.75911203,0.846084,0.93733197,1.0156232,1.1108602,1.1924798,1.2778732,1.3648103,1.4531557,1.53765,1.6245941,1.7074727,1.7942727,1.8864988,1.9639525,2.0631934,2.1432049,2.2326037,2.3213054,2.4080671,2.4907791,2.5929252,2.5717814,2.4909996,2.3892161,2.3063343,2.2194216,2.1275387,2.0339766,1.9483094,1.8623611,1.7782075,1.6855198,1.5992354,1.5145993,1.4258359,1.3438743,1.2555916,1.1641805,1.0783536,0.99237179,0.90652292,0.81987239,0.73142835,0.75103444,0.77087352,0.77286141,0.75095536,0.77040422,0.75112079,0.73490946,0.73456696,0.72376461,0.69877888,0.67206531,0.6426099,0.58776226,0.52364861,0.48067375,0.43997565,0.41409691,0.38131484,0.36734329,0.36929912,0.36858049,0.37094884,0.36795156,0.35145768,0.33490949,0.30492143,0.27561944,0.24260292,0.2323658,0.24586588,0.24740649,0.24395044,0.26045114,0.23934519,0.22154098,0.18453446,0.12832773,0.067701222,0.0072027633,-0.051861846,-0.1255349,-0.18546897,-0.24995153,-0.3119211,-0.37117341,-0.45015968,-0.55199884,-0.6501244,-0.75008799,-0.82661234,-0.88978124,-0.94549063,-1.0010922,-1.0417935,-1.0690019,-1.0829892,-1.0961417,-1.1107981,-1.1252641,-1.1240549,-1.1207509,-1.0980903,-1.0675966,-1.0438534,-1.013373,-0.98055654,-0.9556009,-0.91408159,-0.85330974,-0.77941081,-0.7166523,-0.67338257,-0.60948422,-0.5389721,-0.56306003,-0.60603107,-0.57116755,-0.51195339,-0.42688101,-0.33297353,-0.23711658,-0.14106719,-0.08384071,-0.025057267,-0.12855864,-0.22655785,-0.30988178,-0.3975805,-0.49736674,-0.59009412,-0.68341433,-0.76430482,-0.85937221,-0.95516533,-1.0348613,-1.1222785,-1.213045,-1.3015953,-1.3825789,-1.474186,-1.5637448,-1.6432628,-1.7323649,-1.8080355,-1.8651096,-1.8870202,-1.8902206,-1.8868038,-1.8592777,-1.8255053,-1.783793,-1.7371927,-1.6981314,-1.6423389,-1.587307,-1.5265647,-1.4643748,-1.394937,-1.3136677,-1.2397128,-1.1638556,-1.0828678,-1.0087331,-0.92917371,-0.84923406,-0.76180765,-0.6799738,-0.5850113,-0.50572494,-0.40554209,-0.30800009,-0.33466081,-0.28703403,-0.22419612,-0.14186388,-0.05465683,0.034181495,0.12205502,0.215151,0.31750793,0.40839657,0.46077372,0.34760012,0.280669,0.16167644,0.067830643,-0.050270548,-0.16550991,-0.27986586,-0.36491476,-0.44632672,-0.52780979,-0.59925191,-0.65878532,-0.65507447,-0.58706918,-0.51886279,-0.44267303,-0.3579889,-0.28518893,-0.20921714,-0.12389337,-0.040167773,0.043409912,0.13063691,0.20437194,0.29011793,0.37896078,0.4639254,0.54399514,0.62614977,0.71940459,0.80237019,0.88278128,0.95858347,1.050515,1.1382061,1.2275788,1.2944325,1.2062655,1.1511324,1.224399,1.3165567,1.4019947,1.481002,1.5729429,1.6625045,1.7469664,1.8308388,1.9225346:4
1.3963174,1.3003266,1.2195159,1.072697,1.07066,0.98027074,0.86284052,0.74788018,0.65330626,0.72892619,0.70275747,0.57850827,0.52996356,0.4000541,0.42500716,0.38421105,0.35694907,0.36904902,0.29196508,0.27583244,0.15465567,0.041396086,0.051656138,-0.011013853,-0.072730045,-0.11342227,-0.18769384,-0.2154051,-0.25535026,-0.43379589,-0.34730437,-0.48654905,-0.51591253,-0.3498038,-0.19194052,0.015736817,0.20557536,0.39098276,0.43059079,0.64978082,0.82438175,1.0280094,1.11684,1.0278027,0.95445902,0.91148836,0.7676991,0.71031385,0.65714687,0.53942517,0.48008115,0.37044054,0.52994987,0.52264257,0.47477726,0.3963985,0.30950973,0.31030562,0.23233019,0.16264518,0.042979516,-0.0314811,-0.16520627,-0.28139548,-0.3399511,-0.27161062,-0.1086498,-0.1566134,-0.31237392,-0.41713597,-0.46724801,-0.56041389,-0.68871677,-0.8079267,-0.87931807,-0.91458565,-1.038472,-1.1103591,-1.2592541,-1.3315459,-1.5094762,-1.2873523,-1.5371122,-1.4719324,-1.2651809,-1.0897611,-0.95055609,-0.71011792,-0.44748258,-0.18292119,0.08264668,0.34648664,0.61077952,0.87559142,1.1411832,1.4064968,1.6708016,1.9349409,2.1699965,2.3238504,2.5170571,2.7075444,2.8277518,2.8701921,2.8272273,2.7286941,2.4876965,2.2909785,2.1463915,2.0396949,1.7736998,1.5080896,1.3486849,1.188333,0.9225348,0.72745817,0.46189776,0.196262,-0.06933745,-0.33486534,-0.60055841,-0.83906184,-0.99041351,-1.2561727,-1.4273964,-1.4023283,-1.3128165,-1.3020371,-1.1705114,-1.0937566,-1.1103832,-0.97063605,-0.92099773,-0.87937402,-0.8222683,-0.73436876,-0.70694029,-0.6237751,-0.58848876,-0.50786777,-0.47650565,-0.35393186,-0.33285487,-0.20458154,-0.11073881,-0.037075243,0.024423931,0.055137425,0.12308299,0.21224487,0.21737602,0.29390002,0.36872583,0.37889754,0.39437192,0.4203872,0.46766881,0.56542292,0.58456892,0.65216868,0.58668562,0.51270296,0.30982416,0.10995293,0.023325099,-0.07617788,-0.22124511,-0.42896646,-0.59454024,-0.60902193,-0.44893912,-0.55086365,-0.70050857,-0.53551961,-0.59671455,-0.4588515,-0.44324733,-0.38344247,-0.35126884,-0.32057842,-0.37336478,-0.35198264,-0.23596942,-0.1648648,-0.089423544,-0.084037121,0.087555688,0.094102767,0.22373758,0.26688693,0.31614743,0.47094775,0.44561235,0.3711276,0.35832581,0.48227109,0.55025147,0.55569189,0.62748577,0.69910008,0.76119645,0.78662604,0.77805472,0.99488792,0.94302378,0.98877743,0.9077138,0.85271224,0.73108694,0.48562806,0.25185531,0.086646723,-0.10289616,-0.16367532,-0.24129167,-0.30943088,-0.48383157,-0.57919324,-0.70050559,-0.94671121,-0.92313583,-0.89291902,-1.1050794,-1.2996708,-1.2263469,-1.0732642,-0.97599296,-0.90660808,-0.77813997,-0.73309531,-0.6863093,-0.55542713,-0.51016238,-0.33942065,-0.23797353,-0.16804899,-0.11490062,-0.048019349,0.082222717,0.23698626,0.29102845,0.38305021,0.20722242,0.28428951,0.43553142,0.4685193,0.42079771,0.60283537,0.6583714,0.71937386,0.85362082,0.77093303,0.59825271,0.48322731,0.65496512,0.80243316,0.93536372,0.99775326,0.93867497,1.020545,1.1942324,1.2806149,1.4743091,1.579274,1.7526598,1.797108,1.9386362,1.9022134,1.6978499,1.522465,1.3367195,1.1680381,0.97270886,0.88164238,0.69847604,0.5136244,0.34049898,0.16847221,0.092733139,-0.083453338,-0.27480057,-0.44282415,-0.61406599,-0.80666546,-0.79772602,-0.97483629,-1.1378331,-1.3234584,-1.5124042,-1.6896229,-1.8634206,-2.0544486,-2.2281821,-2.2715249,-2.4076918,-2.3850158,-2.3196503,-2.1698253,-1.9473636,-1.8333229,-1.7233475,-1.4701339,-1.315641,-1.1534017,-1.0619638,-0.91746305,-1.0787431,-1.0029942,-0.82906029,-0.68439162,-0.55575953,-0.47442486,-0.34704095,-0.16474456,-0.024249161,0.059402329,0.063313058,0.29887909,0.44597874,0.54755935,0.73528623,0.93008392,1.0780486,0.95661634,0.81380548,0.58054954,0.45567881,0.26716523,0.076988491,-0.12767117,-0.10368129,-0.25108676,-0.44288245,-0.60761429,-0.76976445,-0.9165966,-1.0708698,-0.93958504,-0.85542881,-1.022765,-1.1841085,-1.3313642,-1.4320686,-1.5920575,-1.7437945,-1.9023073,-2.0312718,-1.9784094,-2.0915329,-2.0462889,-2.0796938,-1.8970742,-1.7113473,-1.5349037,-1.3673327,-1.1765058,-1.0045967,-0.83246225,-0.68006321,-0.69479762,-0.52705537,-0.3413064,-0.16994735,0.0094307308,0.22377654,0.2640218,0.45143825,0.63686265,0.83078203,0.89302228,1.087143,1.2631023,1.4603031,1.6361458,1.7766258,1.7188159,1.627596,1.5342055,1.4429702,1.2806943,1.1742476,1.069903,1.0000898,0.9127544,0.75647577,0.58726927,0.46064004,0.31845764,0.3600923,0.30358391,0.18415381,0.31676927,0.17408092,0.10088927,-0.073941556,-0.20273085,-0.14874192,-0.071142652,-0.23656679,-0.36228159,-0.50762674,-0.63232325,-0.72324631,-0.82482371,-0.95838518,-1.0711479,-1.1859782,-1.2934507,-1.3740583,-1.4113038,-1.5312454,-1.4802217,-1.2138433,-0.957342,-0.77717661,-0.51436543,-0.2523236,-0.066426152,-0.0016644527,0.16945547,0.35509265,0.55164627,0.73846551,0.93803293,1.2021584,1.3949633,1.4666742:1
0.229383,0.14638478,0.059929909,-0.030578286,-0.11401065,-0.20359021,-0.28393682,-0.36880768,-0.43662007,-0.44710668,-0.35582537,-0.43830997,-0.52829696,-0.61487642,-0.70137764,-0.78330352,-0.86334205,-0.92544863,-0.99075799,-1.0456709,-1.109895,-1.1617427,-1.2259848,-1.2880887,-1.3533933,-1.4064899,-1.4660449,-1.5123222,-1.5487146,-1.5708738,-1.5721849,-1.5689377,-1.5534533,-1.5373362,-1.4853578,-1.4276196,-1.3494664,-1.2636797,-1.1747639,-1.0674834,-0.97212211,-0.89037598,-0.81106129,-0.74781172,-0.67497197,-0.60145981,-0.51602181,-0.42300678,-0.31746647,-0.20579936,-0.099763336,-0.023107533,0.027698151,0.0014876016,-0.025564544,-0.094075883,-0.15253982,-0.19360806,-0.2384315,-0.26552797,-0.2637544,-0.19712562,-0.20013355,-0.23237092,-0.26169587,-0.28465846,-0.29337664,-0.29861247,-0.31432258,-0.32414473,-0.33254735,-0.35272169,-0.36314649,-0.36505554,-0.36209802,-0.37032828,-0.3632159,-0.34035169,-0.29950058,-0.24374856,-0.17659224,-0.065232825,0.031720556,0.14458679,0.26001825,0.37705822,0.47199706,0.56446058,0.62267445,0.59601671,0.55778671,0.51333212,0.47468342,0.44022551,0.41478821,0.41276135,0.4424754,0.51300145,0.57013119,0.63588103,0.7085834,0.80878417,0.92954639,1.0272645,1.1183971,1.1987646,1.2431869,1.2697485,1.2935185,1.3219155,1.3482753,1.3673496,1.3817101,1.395224,1.3827572,1.3589645,1.3424209,1.3029007,1.255304,1.2055255,1.1517127,1.1199784,1.1306493,1.1791254,1.288437,1.2685965,1.3861058,1.5012591,1.599788,1.5210256,1.4679438,1.4173399,1.3853757,1.3835417,1.3912679,1.3882436,1.368318,1.3371048,1.3045921,1.2642606,1.2279574,1.1695121,1.1108056,1.0384513,0.97442798,0.95494717,0.96981408,0.99165832,0.94088023,0.83839198,0.73172673,0.62760503,0.5433014,0.46434482,0.4017453,0.32566713,0.26810043,0.21252123,0.15933857,0.11855412,0.090017551,0.063954116,0.045286072,0.038090285,0.045015786,0.055962536,0.079933288,0.096157265,0.11632169,0.13289744,0.14241259,0.1633367,0.18279424,0.20574699,0.25262143,0.31484938,0.3943789,0.49210198,0.59086403,0.69067881,0.79609087,0.88812051,0.82468187,0.73588072,0.63182559,0.52909276,0.43375703,0.33797285,0.23195819,0.14062087,0.042737673,-0.061176712,-0.12932972,-0.23010028,-0.32939649,-0.41575281,-0.51680996,-0.60467106,-0.66753883,-0.74468921,-0.83392047,-0.91305017,-1.0014797,-1.095618,-1.2005033,-1.2992234,-1.4080651,-1.5192502,-1.5824518,-1.6198681,-1.6652995,-1.6940598,-1.7039837,-1.7161787,-1.7147684,-1.7061121,-1.6922332,-1.660128,-1.6333622,-1.6015047,-1.5598064,-1.5247982,-1.4694318,-1.4085039,-1.3475154,-1.2843883,-1.2304681,-1.1624064,-1.0959541,-1.0348236,-0.96994362,-0.90914601,-0.84183299,-0.77258452,-0.69456482,-0.61367791,-0.53014587,-0.43693722,-0.35495257,-0.26442717,-0.17434574,-0.089629816,0.0036978293,0.093514531,0.19524996,0.29676037,0.40094456,0.39313357,0.45197172,0.51498034,0.45153281,0.39113421,0.28880357,0.15876432,0.029907905,-0.097914677,-0.20266308,-0.27970779,-0.28638848,-0.2603431,-0.36735199,-0.48202778,-0.58527404,-0.69417285,-0.82067234,-0.93381602,-1.0406211,-1.1551711,-1.2671775,-1.3623674,-1.4807476,-1.5860243,-1.6760109,-1.7350455,-1.7530084,-1.7588014,-1.7460029,-1.7207897,-1.6652764,-1.6013861,-1.4858111,-1.3670647,-1.2536372,-1.1416375,-1.0314104,-0.92052482,-0.80948388,-0.70797324,-0.60445415,-0.50181859,-0.39814969,-0.2890811,-0.18704228,-0.082916763,0.022951809,0.12384745,0.23777358,0.34084815,0.43554038,0.5307231,0.61081768,0.63899099,0.60350015,0.5933193,0.67305224,0.78847801,0.89115091,0.99666427,1.0933557,1.1905717,1.2319035,1.1437571,1.0669912,1.0147431,0.96965829,0.89111507,0.81953186,0.75330553,0.69692724,0.66470336,0.68495695,0.72577306,0.81497059,0.92531535,1.0381021,1.1298166,1.2431328,1.3382792,1.4520791,1.5871396,1.723247,1.8587769,1.8804276,1.8087911,1.8005008,1.8730481,1.9745187,2.0770831,2.1640194,2.0706158,1.9539906,1.9218112,1.9434556,1.807703,1.7528564,1.6369418,1.5211608,1.3915741,1.2904301,1.1960278,1.0895404,0.99170174,0.90023693,0.81707311,0.7336706,0.66417146,0.61280475,0.59973776,0.6349963,0.69016181,0.74567927,0.80537079,0.87063668,0.95468493,1.0458846,1.1081287,1.2123822,1.3315581,1.2544161,1.1477785,1.0461245,0.94380703,0.82584864,0.7246899,0.68541175,0.74236666,0.66640114,0.56645497,0.4667044,0.36550717,0.271994,0.1680191,0.049464706,-0.062052694,-0.16824546,-0.28349205,-0.39457829,-0.50384423,-0.60568074,-0.72194044,-0.83469648,-0.94058973,-1.0443509,-1.158873,-1.2805029,-1.3775672,-1.4763934,-1.5539153,-1.6330392,-1.6913756,-1.7420895,-1.7821978,-1.7978673,-1.7781288,-1.7277188,-1.6640564,-1.5623864,-1.4497537,-1.3520437,-1.2423668,-1.1295931,-1.0220092,-0.92082298,-0.81803064,-0.70783118,-0.59823082,-0.49710148,-0.40117746,-0.30782157,-0.32140877,-0.21578193,-0.11823347,-0.013995553,0.089009816,0.17272313,0.26229788,0.2877032:4
0.7100518,0.68418062,0.65286818,0.61704093,0.57275359,0.53165991,0.4842976,0.44088271,0.39642717,0.35107114,0.2880473,0.24346183,0.18025666,0.13303922,0.07330703,0.0077558523,-0.056897382,-0.12168748,-0.16850727,-0.23764641,-0.29242159,-0.34980947,-0.41023115,-0.47201492,-0.54565054,-0.6052881,-0.67686917,-0.73937359,-0.81053559,-0.87582287,-0.9360064,-1.017745,-1.1007693,-1.1847751,-1.2694658,-1.3383019,-1.4255261,-1.5058204,-1.5787332,-1.6423967,-1.7117162,-1.7853407,-1.7347667,-1.6685292,-1.5984067,-1.519989,-1.4549241,-1.3816638,-1.3119621,-1.2482712,-1.1870319,-1.110109,-1.0495773,-0.96516879,-0.91546118,-0.88949274,-0.88077772,-0.87882087,-0.86023097,-0.83479688,-0.80869267,-0.79386306,-0.77957918,-0.76842743,-0.7559917,-0.75317743,-0.7345576,-0.71603703,-0.69209575,-0.68950546,-0.68020902,-0.68440584,-0.67612047,-0.68944411,-0.7015402,-0.70322469,-0.72219476,-0.73640095,-0.71599355,-0.69375233,-0.66189994,-0.64196071,-0.61087335,-0.57446965,-0.54370583,-0.51527716,-0.486908,-0.44984917,-0.41120345,-0.37764328,-0.33641462,-0.29359447,-0.24826568,-0.19949051,-0.15878721,-0.11149284,-0.090974311,-0.027430364,0.039901835,0.090869183,0.1617676,0.23250255,0.29482893,0.36743285,0.43652538,0.49756121,0.56506888,0.63537539,0.70551893,0.77205761,0.83867045,0.90981862,0.96987174,1.0401203,1.0880811,1.1201511,1.1423229,1.1600574,1.1447365,1.166695,1.1745093,1.1995204,1.230775,1.2525204,1.3011198,1.3408485,1.385082,1.4275074,1.4714348,1.5253881,1.5673318,1.6082102,1.6407112,1.6788434,1.7231319,1.7670254,1.805636,1.8430804,1.886072,1.936439,1.9583261,1.9900751,1.9730187,1.9710525,1.9197864,1.8575963,1.7920796,1.7177018,1.6706146,1.6124405,1.6008721,1.5738141,1.5391829,1.4975655,1.4521253,1.4009181,1.3530422,1.3344413,1.2981767,1.2661955,1.2246049,1.1850815,1.1490141,1.1086712,1.0748424,1.0422474,1.0020997,0.9514883,0.88340268,0.84119657,0.78876148,0.73601018,0.6722878,0.62074865,0.62515655,0.59049883,0.59613475,0.59824002,0.61184171,0.58335006,0.5127891,0.44056348,0.37229393,0.30411027,0.23557934,0.17321744,0.099672917,0.030086746,-0.043006548,-0.11345638,-0.18073978,-0.22431592,-0.2597602,-0.32941831,-0.39704813,-0.4500134,-0.46902642,-0.52219565,-0.55479048,-0.58846181,-0.61825103,-0.64403188,-0.69145729,-0.71969206,-0.77758236,-0.82023111,-0.8570461,-0.8739589,-0.91127407,-0.94895557,-0.97559856,-1.0049349,-1.0292252,-1.0445841,-1.069202,-1.07332,-1.045626,-1.076727,-1.0902709,-1.1080799,-1.1311584,-1.1592208,-1.1956478,-1.2615349,-1.3562783,-1.4543629,-1.5281994,-1.6036088,-1.6805671,-1.7565108,-1.8252293,-1.8848858,-1.9565467,-1.9999567,-1.9692987,-1.9828177,-1.9492892,-1.9100964,-1.8703637,-1.8317332,-1.7862476,-1.7240094,-1.6688269,-1.6375387,-1.5882433,-1.5788753,-1.5419327,-1.4955577,-1.4560463,-1.3887184,-1.3186137,-1.2536571,-1.2103605,-1.1372001,-1.0746945,-0.99846687,-0.92979728,-0.86637792,-0.78495037,-0.70260627,-0.6197668,-0.54104052,-0.47616286,-0.39912842,-0.34216399,-0.28379588,-0.22664359,-0.17404808,-0.11432254,-0.059784867,-0.012026105,0.025711951,0.058642139,0.092770404,0.12353006,0.12839682,0.08638892,0.047416516,-0.0059363569,-0.053990054,-0.10620317,-0.16204545,-0.2216923,-0.29493162,-0.34862053,-0.41114869,-0.47803136,-0.54042903,-0.60510933,-0.66504001,-0.73047569,-0.80224941,-0.85640589,-0.92730152,-0.9789429,-1.0324891,-1.0940028,-1.1426599,-1.1669409,-1.1177115,-1.0632826,-0.99834227,-0.93186732,-0.87174028,-0.79958978,-0.72303014,-0.66381682,-0.58891257,-0.51201108,-0.43920816,-0.37382269,-0.30030522,-0.22645356,-0.16273627,-0.08972046,0.0017888917,0.064499882,0.14329388,0.21700062,0.28766264,0.35684599,0.42079318,0.48532437,0.55345251,0.61156776,0.67625117,0.73562966,0.79825391,0.85694911,0.90517151,0.97099873,1.0188418,1.080266,1.1358097,1.1875477,1.2230992,1.2478874,1.2711397,1.2762149,1.2604885,1.251718,1.2228853,1.1801386,1.1529086,1.1011091,1.0573745,1.0499324,1.1090529,1.1820504,1.2401286,1.303619,1.371832,1.4281888,1.4719708,1.519982,1.5508013,1.5699746,1.5859385,1.5732203,1.5459816,1.5066893,1.4642026,1.3968687,1.3347184,1.2561756,1.1941874,1.1346361,1.0602741,1.0025822,1.0017814,1.0428314,1.0670211,1.089242,1.0967534,1.0654061,1.0148303,0.9488785,0.89593806,0.83706351,0.7804623,0.70807627,0.65245018,0.59163262,0.53410143,0.46891717,0.39916721,0.34441144,0.27909768,0.21932761,0.15200042,0.085671788,0.0238686,-0.02687568,-0.09407161,-0.15483819,-0.23271309,-0.29399361,-0.36980812,-0.43268692,-0.51114087,-0.57393745,-0.64905867,-0.71110464,-0.73730773,-0.68659946,-0.62685226,-0.56547609,-0.50205649,-0.43570016,-0.36953937,-0.30338706,-0.22262679,-0.14748262,-0.074955619,-0.004418005,0.064149808,0.15851114,0.22818353,0.29528663,0.35728681,0.4130069,0.48202994,0.55082029,0.59761787,0.64945692,0.68835852,0.71214959:2
1.8609406,1.7723147,1.6818242,1.5959249,1.5187165,1.4768589,1.3928403,1.3087658,1.2872554,1.2114856,1.1541926,1.1624536,1.0945072,1.031879,0.95556953,0.88188829,0.80201037,0.73309444,0.66093933,0.58894208,0.53334424,0.48121796,0.50761188,0.62961809,0.73364059,0.83776443,0.94208852,1.0282297,0.97667219,0.90218113,0.83654216,0.76404852,0.68501911,0.60244547,0.51922783,0.43289279,0.33313558,0.25171841,0.21161651,0.18518306,0.15848768,0.090797866,0.0074676753,-0.073042678,-0.18539552,-0.30188103,-0.41367833,-0.41789426,-0.42098026,-0.51436227,-0.50469001,-0.53716261,-0.55315151,-0.52472702,-0.50393374,-0.42212394,-0.4757599,-0.37211453,-0.27700036,-0.22593149,-0.15550462,-0.057699305,0.018054177,0.086672421,0.17712373,0.2700771,0.37146662,0.45917276,0.55492412,0.65272267,0.6823677,0.73663801,0.70344249,0.6062276,0.50451809,0.42021511,0.35295432,0.24181494,0.15600674,0.055040511,-0.036977271,-0.12804661,-0.21505599,-0.31157562,-0.39892134,-0.4699993,-0.48129626,-0.47260352,-0.37040912,-0.27803154,-0.16759341,-0.076204036,0.028264919,0.12619398,0.23224093,0.32963944,0.43119614,0.53104119,0.63224739,0.72785106,0.83194463,0.92443849,0.85115089,0.75294674,0.66006043,0.55795977,0.45419151,0.35782602,0.26002719,0.15953702,0.062811803,-0.036840157,-0.13162843,-0.23065254,-0.33051058,-0.43060305,-0.52088871,-0.62350886,-0.71798238,-0.81315907,-0.89280526,-0.99194629,-1.0750151,-1.1450749,-1.1361213,-1.101505,-1.0885535,-1.0143533,-0.99347097,-0.91815499,-0.83214082,-0.81757067,-0.76398592,-0.69671704,-0.63348089,-0.58446733,-0.57868136,-0.55038775,-0.51139125,-0.50103934,-0.47484354,-0.39495983,-0.38025401,-0.35288567,-0.26877508,-0.23936839,-0.162031,-0.10315024,-0.025947792,0.040657236,0.10942378,0.098913246,0.010526905,-0.070519008,-0.096232762,-0.2009036,-0.31969332,-0.4188944,-0.50016783,-0.56547107,-0.6037167,-0.58352931,-0.56837119,-0.57041653,-0.46289431,-0.41065214,-0.36655895,-0.25734534,-0.21048851,-0.12349119,-0.074569808,-5.4683665E-4,0.058183458,0.1595533,0.25810124,0.33934378,0.41370959,0.46446081,0.51940195,0.60983322,0.6056075,0.70270739,0.80393343,0.86917784,0.91758211,1.029603,1.0578606,1.1122566,1.1528752,1.1802013,1.1825671,1.1111043,1.0438845,0.94052801,0.84820877,0.76277955,0.70833319,0.67733297,0.61057136,0.60987455,0.57063344,0.53476916,0.58868187,0.65324246,0.62099004,0.68691496,0.70920042,0.75969599,0.76423666,0.77787994,0.78077692,0.83728054,0.83900796,0.91594435,0.95532149,1.008578,1.090359,1.1331163,1.1881511,1.2211468,1.3011901,1.3464549,1.3881436,1.4515873,1.493783,1.5577686,1.6208598,1.6560918,1.6016501,1.4604767,1.3545358,1.2308371,1.1085316,0.98625693,0.88350194,0.76127175,0.61973229,0.47838441,0.37663285,0.36215018,0.30782207,0.20226503,0.077749969,-0.045632114,-0.15817249,-0.26833769,-0.37970253,-0.48945453,-0.61445923,-0.70649281,-0.80657809,-0.91566216,-0.86451668,-0.98918102,-1.1105292,-1.2203783,-1.3326331,-1.4412698,-1.5832364,-1.6889437,-1.6995841,-1.7260177,-1.7300176,-1.7065194,-1.6618556,-1.6259229,-1.6092548,-1.5537954,-1.4553152,-1.376406,-1.2809135,-1.2166269,-1.1646363,-1.0716075,-1.0157556,-0.94877879,-0.84914807,-0.750506,-0.67098044,-0.59828865,-0.5052892,-0.40663062,-0.35375815,-0.28792805,-0.24256982,-0.14746045,-0.041972471,0.052617604,0.10120394,0.1768726,0.25412352,0.36025897,0.44538708,0.53688284,0.63799126,0.69383281,0.80234477,0.86460207,0.79605653,0.73845036,0.71080331,0.72942196,0.77922734,0.87340227,0.88599546,0.97552821,1.0215123,1.0522115,1.1131679,1.1658017,1.2353071,1.2439242,1.3033042,1.3485337,1.4162419,1.4990698,1.5761647,1.6636764,1.6042863,1.5084961,1.4066636,1.2992389,1.2105893,1.1227739,1.0396363,0.95231443,0.89804459,0.8031036,0.707403,0.61096282,0.51963532,0.42753556,0.33590119,0.27333054,0.22963749,0.25900885,0.31242027,0.36011384,0.28026604,0.1934185,0.09903262,0.0065492721,-0.076076383,-0.18565024,-0.27188826,-0.34348646,-0.46684391,-0.58655897,-0.71131721,-0.80219804,-0.90524533,-0.92388777,-1.0511562,-1.1591306,-1.2625266,-1.3052485,-1.4119572,-1.5100819,-1.6045733,-1.7013555,-1.7833984,-1.8395756,-1.8809958,-1.9321731,-1.980685,-2.0226074,-2.0343069,-2.0688245,-2.1221705,-2.1507004,-2.1953575,-2.2110825,-2.228262,-2.2160192,-2.2691591,-2.3228099,-2.3545859,-2.4115196,-2.3116426,-2.2110447,-2.1504478,-2.1145454,-2.1056823,-2.0741127,-2.0696277,-1.9986114,-1.9260106,-1.8554296,-1.7641112,-1.6698691,-1.5754928,-1.4776791,-1.3775199,-1.2807744,-1.2195206,-1.1430164,-1.0466649,-0.9775239,-0.88630749,-0.83985833,-0.74283874,-0.64429222,-0.54403798,-0.43792758,-0.34027939,-0.23705338,-0.13942093,-0.039360528,0.061038294,0.16030863,0.2584452,0.35680817,0.46235507,0.57341053,0.63158283,0.68461571,0.78470175,0.90510975,1.009345,1.1303073,1.2459848,1.359803,1.4678199,1.5813471,1.6910186,1.7913981,1.9031548:5
2.3014735,2.231113,2.1426839,2.0534515,1.9682994,1.8814989,1.8044371,1.7227336,1.6346211,1.5756353,1.5251777,1.4396986,1.33951,1.2702164,1.215448,1.1505963,1.0874119,1.0146021,0.94976526,0.88440698,0.80785442,0.74880675,0.67956045,0.60470301,0.5286326,0.43925544,0.35697722,0.26305111,0.19473082,0.15489438,0.18268812,0.2194076,0.1661114,0.10631876,0.017621309,-0.069992608,-0.17685335,-0.25363482,-0.33675114,-0.44067488,-0.54834051,-0.65734021,-0.74437353,-0.84243501,-0.94288268,-1.0238802,-1.0781634,-1.1483555,-1.2283453,-1.2469369,-1.1503443,-1.2143306,-1.3105995,-1.2890169,-1.2597996,-1.1680402,-1.0741874,-0.97719371,-0.87933065,-0.8406674,-0.85784852,-0.89744816,-0.9459725,-0.99744824,-1.068403,-1.0997807,-1.151739,-1.2193001,-1.1970292,-1.2374711,-1.3120404,-1.3752822,-1.413187,-1.465951,-1.516753,-1.5049391,-1.5971117,-1.6549112,-1.6302647,-1.5925876,-1.6709143,-1.6067085,-1.6228387,-1.4957867,-1.4266925,-1.3358467,-1.2576833,-1.2138092,-1.0843125,-1.015158,-1.0145787,-0.90427779,-0.79294894,-0.68157581,-0.61677077,-0.53486143,-0.44308392,-0.31302917,-0.182981,-0.052902557,0.077157879,0.11417234,0.11061656,0.064603307,-0.042116815,-0.15733181,-0.24944884,-0.37818997,-0.49020761,-0.54694232,-0.626855,-0.70752901,-0.82968243,-0.90416057,-0.98564754,-0.97683426,-0.94941758,-0.91579946,-0.88446757,-0.87357374,-0.89521952,-0.92424325,-0.95522826,-1.0221461,-1.0196042,-0.9654002,-0.88820262,-0.83925319,-0.76560839,-0.70557405,-0.61433808,-0.52910804,-0.44476816,-0.36233102,-0.29096614,-0.215189,-0.13560802,-0.057696247,-0.042731652,-0.12240541,-0.14757094,-0.16242323,-0.24134931,-0.33237605,-0.42965485,-0.4942641,-0.56088523,-0.65188636,-0.73807075,-0.83032102,-0.76503065,-0.83393098,-0.87502857,-0.94136002,-1.0264148,-0.99290541,-1.01276,-1.0596027,-1.0828978,-1.0490915,-1.0480871,-1.096391,-1.1312845,-1.0911609,-1.0367969,-0.94533799,-0.83251605,-0.80279367,-0.80996793,-0.72669855,-0.60993858,-0.5302323,-0.46165984,-0.40760834,-0.35155196,-0.28634715,-0.28390613,-0.36825917,-0.4378236,-0.48704209,-0.47104926,-0.41600726,-0.35313832,-0.27121589,-0.2007363,-0.082272804,0.01034582,0.094368362,0.16713074,0.23660976,0.31062155,0.37981221,0.48076267,0.57375416,0.67163915,0.77530517,0.84751108,0.94688952,1.0246504,1.1122978,1.1786854,1.2615393,1.3358943,1.3836482,1.4274722,1.5026967,1.5773497,1.6884031,1.7863855,1.8673023,1.9137277,1.9644803,2.0198053,2.0906928,2.1800772,2.2745559,2.4051589,2.5012503,2.5715227,2.5749176,2.5184082,2.4497443,2.3675103,2.2754691,2.2176632,2.1446715,2.0888187,2.0256804,1.9692798,1.9100269,1.8711619,1.8334015,1.8391263,1.8999844,1.9751531,1.999902,1.8798584,1.7596682,1.6396598,1.5373856,1.4604556,1.3529218,1.2663704,1.1580037,1.0605331,0.95893337,0.89112078,0.86212878,0.82852429,0.7419481,0.65313981,0.56051858,0.45422965,0.34542998,0.23361679,0.14451999,0.054279418,-0.0086867168,-0.011889271,-0.019522425,0.047914538,0.063125612,-0.02986769,-0.14982534,-0.25194494,-0.35021934,-0.39590868,-0.45211071,-0.52649818,-0.57071654,-0.53268417,-0.46449558,-0.4426931,-0.43816856,-0.43006434,-0.45499848,-0.47583768,-0.49410723,-0.47834278,-0.55114298,-0.65069894,-0.73178729,-0.82560426,-0.77265249,-0.74767249,-0.77247084,-0.769135,-0.79221675,-0.79442407,-0.81980067,-0.82482416,-0.83014618,-0.83363665,-0.8328095,-0.91452834,-0.93814737,-0.9098144,-0.92312628,-0.95562829,-0.9018996,-0.91266197,-0.85196875,-0.83248106,-0.78930639,-0.71693219,-0.72313922,-0.71213778,-0.66180409,-0.60265796,-0.63962331,-0.62255836,-0.60045037,-0.57079177,-0.54443746,-0.51306327,-0.47367044,-0.43011321,-0.37705535,-0.33246453,-0.30009253,-0.33671673,-0.34777582,-0.39747513,-0.3468552,-0.30641493,-0.2833944,-0.2504412,-0.15803081,-0.14894591,-0.16373382,-0.11310045,-0.075310046,-0.036449777,-0.0025508241,0.0053163432,0.079537347,0.04281183,-0.0041818516,-0.0072644519,-0.050887763,-0.04508476,-0.018671035,0.0025411325,0.027900896,0.028923153,0.028538721,-0.016879626,-0.056452745,-0.12617373,-0.12242408,-0.059322757,-0.04210482,-0.12853373,-0.090413979,-0.047673777,-0.091850079,-0.093815976,-0.11812179,-0.088825468,-0.080991798,-0.090330468,-0.077482045,-0.038203742,-0.029759261,-0.052347575,-0.010675474,-0.022771902,0.010361987,0.039208013,0.06293011,0.045739246,0.11050407,0.0908086,0.10528338,0.16474448,0.25045625,0.23868694,0.32302616,0.31913271,0.33751932,0.39577135,0.43627893,0.45221904,0.44126427,0.37144573,0.27973925,0.18007575,0.075032375,-0.020160498,-0.12494507,-0.23096525,-0.3149654,-0.39651222,-0.48487615,-0.56107019,-0.63013259,-0.70509451,-0.7520839,-0.761076,-0.69419252,-0.58557004,-0.47544092,-0.34565199,-0.21582947,-0.086011363,0.043741393,0.17343503,0.30338121,0.43322913,0.56316873,0.69256664,0.80286006,0.90659332,1.0036608,1.0950772,1.1979259,1.2969859,1.38898,1.4786715,1.5658866,1.6664536,1.7670875,1.8708761,1.9800521,2.0757911,2.1876376,2.2799949:5
0.69460933,0.69875747,0.68323248,0.69032833,0.68563537,0.68170964,0.71684847,0.77994478,0.77062177,0.75677938,0.74121175,0.73855304,0.76155575,0.80213953,0.82826413,0.86248998,0.9199956,0.95939946,0.99973717,1.0364378,1.0800981,1.1191914,1.1631003,1.2097592,1.2551309,1.2993999,1.3359744,1.3605035,1.3952486,1.4150232,1.4326649,1.4690975,1.49131,1.5055806,1.5099717,1.5341797,1.5448544,1.6053399,1.6716281,1.6023074,1.6701825,1.7333086,1.830208,1.8086767,1.7241104,1.6445921,1.5712029,1.522347,1.5020093,1.4889769,1.4711983,1.4464667,1.4132124,1.3792149,1.3361544,1.2961825,1.2489513,1.1967788,1.1452111,1.1057372,1.0758844,1.0488268,1.0273283,1.0076061,0.97795802,0.95660593,0.92939177,0.90198958,0.8747047,0.84852325,0.83874903,0.83307973,0.85054598,0.88908422,0.9184193,0.94793906,0.99145213,0.98365394,0.91269528,0.85137402,0.78433385,0.71172978,0.6449685,0.57154237,0.49777989,0.42591935,0.36310278,0.30172154,0.23235778,0.15589365,0.077015335,0.0016585007,-0.070031222,-0.16703847,-0.26864653,-0.36727237,-0.43351818,-0.48297991,-0.51549257,-0.54420689,-0.57560919,-0.58422351,-0.60760949,-0.62499283,-0.62756007,-0.6221944,-0.6085467,-0.58621471,-0.56684305,-0.5424813,-0.51276954,-0.46505126,-0.42645118,-0.38216786,-0.32371028,-0.28230943,-0.23234269,-0.19244123,-0.15979796,-0.11953067,-0.078670508,-0.028076865,0.036522005,0.06758779,-0.018095337,-0.11743935,-0.20903573,-0.25849079,-0.2521584,-0.22705426,-0.18441499,-0.14956817,-0.095769981,-0.056202244,0.0054844668,0.055800338,0.11749928,0.17369124,0.18763304,0.10038492,-0.0018035326,-0.086427152,-0.19049808,-0.2939022,-0.361112,-0.38896645,-0.44202607,-0.55462985,-0.63146682,-0.73787933,-0.84781299,-0.96105935,-1.0739396,-1.1772304,-1.2680619,-1.3559616,-1.4529104,-1.5496294,-1.6466993,-1.741776,-1.8370774,-1.9167261,-2.013251,-2.100945,-2.1941261,-2.2816516,-2.355341,-2.3784688,-2.3856054,-2.3763066,-2.3480094,-2.3077297,-2.2637887,-2.2000662,-2.1266337,-2.0630931,-1.9995356,-1.9289934,-1.8517349,-1.7611833,-1.6636732,-1.5632026,-1.4890295,-1.4136809,-1.3340829,-1.246655,-1.1665557,-1.0662455,-0.96585215,-0.86391626,-0.76134934,-0.66029043,-0.71380965,-0.73236114,-0.67612619,-0.70336206,-0.64785249,-0.57642243,-0.48614147,-0.40033786,-0.3096481,-0.37005069,-0.34290166,-0.25774279,-0.26009896,-0.35767565,-0.46389999,-0.5785579,-0.6686932,-0.74864323,-0.83859518,-0.92669817,-1.0325567,-1.1054016,-1.1339353,-1.1294176,-1.0989691,-1.0369752,-0.95151895,-0.85164833,-0.76203201,-0.66626153,-0.57258989,-0.48525881,-0.38697443,-0.29306764,-0.20270573,-0.11823365,-0.024311711,0.066288581,0.16037194,0.24738389,0.34221503,0.43863776,0.53195504,0.62954208,0.73097369,0.82646032,0.91316446,0.99949228,1.0064104,0.9122016,0.82743656,0.75993102,0.76501909,0.83690207,0.93416908,1.0267219,1.1328186,1.2236444,1.3258957,1.4227103,1.5247445,1.6261312,1.7297371,1.8284499,1.8696302,1.9502647,2.0447839,2.0656602,1.9691214,1.8992957,1.8075913,1.7249845,1.630877,1.5342378,1.4514514,1.3647118,1.2795499,1.1962114,1.1126489,1.0241763,0.9358078,0.85184269,0.77177496,0.70609263,0.70044466,0.74936165,0.81967144,0.90002978,0.98364287,1.0623386,1.0933651,1.0089767,0.90798007,0.78665146,0.68155202,0.58551783,0.4856234,0.38256127,0.29275754,0.18594378,0.10645315,0.0063308732,-0.096153508,-0.16783961,-0.27168975,-0.34598143,-0.44254063,-0.51722139,-0.59148153,-0.6632651,-0.72594397,-0.77884419,-0.80696392,-0.80047618,-0.76356908,-0.71531054,-0.64578989,-0.57752086,-0.50521196,-0.43176687,-0.35555133,-0.26307891,-0.1878494,-0.088549763,-0.0090273709,0.088388057,0.17517935,0.25654818,0.33911771,0.4390151,0.51735729,0.61649818,0.69597319,0.70762404,0.60760355,0.48293827,0.38665066,0.26148441,0.19971391,0.20107064,0.078031677,-0.017450991,-0.14188853,-0.26470743,-0.38149435,-0.4724026,-0.55777014,-0.67027983,-0.75532862,-0.85994684,-0.93521966,-1.0359879,-1.1105981,-1.2097593,-1.280337,-1.3707732,-1.438017,-1.5230592,-1.5788123,-1.6346079,-1.6709148,-1.7058959,-1.704773,-1.6948971,-1.6612662,-1.6194547,-1.5484059,-1.4415755,-1.3191833,-1.2205586,-1.1185638,-1.0161757,-0.91854139,-0.83641335,-0.73181186,-0.65135672,-0.56325904,-0.4683806,-0.38118714,-0.29899312,-0.21481795,-0.11413492,-0.013086538,0.075079414,0.16953543,0.25523879,0.19361563,0.11128499,0.025218531,-0.035353337,-0.067825456,-2.8815861E-4,-0.056305912,-0.12530417,-0.19277825,-0.25642019,-0.32512629,-0.39004215,-0.44396212,-0.49198311,-0.53879296,-0.57445835,-0.60627847,-0.62708218,-0.64483113,-0.66901788,-0.69187112,-0.69267661,-0.69806164,-0.71234614,-0.71066264,-0.70357722,-0.68598995,-0.65808395,-0.60341433,-0.5517289,-0.48354997,-0.41024979,-0.33728287,-0.25861124,-0.18669099,-0.1013595,-0.0019792097,0.11601043,0.22397229,0.29085128,0.34518591,0.4023273,0.45922824,0.50551349,0.55727893,0.59545427,0.63115506,0.65721529,0.67632164:4
0.085897601,-0.050730109,-0.18904026,-0.33809726,-0.4733864,-0.6085924,-0.72732185,-0.85598823,-0.99484155,-1.1061725,-1.2178262,-1.291725,-1.181722,-1.104639,-1.0325161,-0.9351881,-0.88198096,-0.78144311,-0.70662444,-0.65876771,-0.60217541,-0.56229566,-0.52520623,-0.57417813,-0.64917321,-0.64736886,-0.69075188,-0.65856972,-0.63722879,-0.61723319,-0.55445799,-0.47185607,-0.44804192,-0.37385919,-0.31331692,-0.25228176,-0.14804702,-0.1064919,-0.066555669,-0.039367287,0.0079103324,0.095611376,0.17110845,0.29344967,0.24826366,0.27123254,0.34232878,0.41930049,0.42424082,0.46503827,0.51536216,0.55745106,0.65109418,0.70610969,0.77981263,0.85584121,0.94408979,1.0189592,1.1161712,1.2052997,1.3030205,1.3658418,1.3572973,1.3663208,1.3981894,1.4922071,1.6059851,1.6110669,1.5807432,1.5786676,1.505457,1.4162544,1.3216797,1.2300166,1.1779995,1.0895569,0.97564848,0.88760665,0.78301506,0.73264115,0.69352609,0.68449443,0.736833,0.66527404,0.53067542,0.46462995,0.40755908,0.35580444,0.35754775,0.45245451,0.55524489,0.61041379,0.67273761,0.77393924,0.90283256,0.9948287,0.99659119,0.96321385,0.9295642,0.90173933,0.87771557,0.85913382,0.84941512,0.84711279,0.85765278,0.86795941,0.88456786,0.90741499,0.93668943,0.97187024,1.0129165,1.0597224,1.0905511,1.0715209,0.98167529,0.89700939,0.79009011,0.72882808,0.63542921,0.54728542,0.49188965,0.48366413,0.43389811,0.38741579,0.36376584,0.30858418,0.2426213,0.1824272,0.10099977,0.074953485,0.069738668,0.044937102,0.085801746,0.11648379,0.20384336,0.27019284,0.32469169,0.37819921,0.46700186,0.56334815,0.62114723,0.70417119,0.80915987,0.89539805,0.91295282,0.93470224,1.0175248,1.1315798,1.2217149,1.334868,1.4597527,1.5737078,1.6029572,1.489338,1.3716916,1.3006643,1.2187388,1.1521978,1.0452966,0.93285106,0.81525722,0.69466991,0.61987948,0.64060651,0.62847151,0.53701562,0.44378395,0.33027719,0.20534181,0.076306513,-0.046550066,-0.17466015,-0.26893052,-0.33435102,-0.30295194,-0.30581646,-0.28722778,-0.2522507,-0.18293506,-0.10777345,-0.086536794,-0.030886794,0.03978345,0.091902138,0.13613447,0.065801467,-0.088320715,-0.23346506,-0.38950608,-0.53518208,-0.67807951,-0.82605978,-0.97163852,-1.1072669,-1.2523364,-1.3868281,-1.5517907,-1.6956288,-1.8493645,-1.9925156,-2.1382623,-2.2890319,-2.4189067,-2.5531494,-2.6767614,-2.7479866,-2.7877551,-2.9149449,-2.9886055,-2.97735,-2.8902484,-2.7996621,-2.6897764,-2.548184,-2.4757769,-2.4418673,-2.3660552,-2.3208197,-2.2625501,-2.1985093,-2.0716617,-1.9438659,-1.8453758,-1.7114467,-1.5841414,-1.4458583,-1.311427,-1.231289,-1.1042977,-1.04255,-0.96774007,-0.86742351,-0.75155411,-0.63530697,-0.54032369,-0.51005377,-0.48015798,-0.40970991,-0.31850598,-0.21488439,-0.090619356,0.028104999,0.15049284,0.25172293,0.35454307,0.47371449,0.58702498,0.70122881,0.7709163,0.864556,0.96935169,1.0752279,1.1914501,1.3023855,1.3941394,1.5162051,1.6212827,1.5430045,1.4175366,1.2887959,1.179572,1.0928649,1.0402241,0.92049579,0.80013112,0.68654801,0.58569851,0.51022511,0.41939547,0.30820659,0.2021811,0.09649437,-0.015827142,-0.1312544,-0.23302636,-0.32559203,-0.3224133,-0.25855522,-0.17346785,-0.095678953,-0.012065305,0.11209417,0.20782924,0.33214605,0.41540381,0.54754627,0.63293641,0.7873227,0.91558558,1.0131227,0.94078422,0.82676223,0.71142756,0.60259951,0.50119672,0.42567197,0.3264928,0.22570592,0.15031805,0.029688133,-0.087633922,-0.20248115,-0.25072665,-0.35881046,-0.44077657,-0.52311932,-0.57933543,-0.63558794,-0.68671039,-0.78237182,-0.85415649,-0.86345424,-0.95162628,-1.0328873,-1.1635932,-1.1425808,-1.156082,-1.1381793,-0.99307926,-0.87127684,-0.7949318,-0.72355555,-0.61231717,-0.45646436,-0.36502233,-0.2498718,-0.13112947,0.0080143308,0.11507311,0.2164166,0.3371135,0.46854154,0.60071537,0.72262183,0.83570619,0.9537411,1.0256005,1.1653828,1.2934144,1.4382507,1.5414279,1.6723957,1.7140841,1.6282534,1.5255159,1.4171474,1.3129934,1.2396451,1.1773961,1.1041557,1.0398856,0.98182156,0.91987015,0.8467657,0.81587996,0.79443637,0.73769164,0.65819876,0.5917823,0.56129229,0.52940801,0.49188448,0.43348588,0.34934059,0.24739902,0.24638708,0.18301532,0.10216151,-0.0043442471,-0.031150171,-0.056079998,-0.076327972,-0.018664618,0.041825616,0.015475522,-0.022490491,-0.080817197,-0.15038039,-0.23661533,-0.34417929,-0.40065228,-0.43605549,-0.46655815,-0.5657855,-0.58410123,-0.54642243,-0.54717564,-0.59096418,-0.67210259,-0.75236284,-0.84841535,-0.9095973,-0.89151189,-0.80755514,-0.65703047,-0.49407931,-0.48401909,-0.53495084,-0.59992372,-0.62598577,-0.64587847,-0.65214461,-0.75856075,-0.80580816,-0.83824656,-0.86222389,-0.94934879,-1.0411635,-1.1467471,-1.2536843,-1.3183611,-1.3785012,-1.4609331,-1.5689683,-1.5614026,-1.4159647,-1.2822087,-1.1505019,-1.0215516,-0.8923496,-0.75985646,-0.62203287,-0.48492386,-0.3422036,-0.21556542,-0.076140346,0.057197329:5
0.95980875,0.89333427,0.82837807,0.75221912,0.66880817,0.6021032,0.57992126,0.51516094,0.41286991,0.2696735,0.16915159,0.13633061,0.06545877,-0.010132685,-0.098606444,-0.20111104,-0.25350079,-0.33657083,-0.46461763,-0.57890065,-0.6055522,-0.67143349,-0.77330237,-0.80724724,-0.80497816,-0.83620958,-0.74089209,-0.64990797,-0.52707211,-0.39867976,-0.26515956,-0.13227929,0.015409988,0.15446253,0.29656039,0.42602712,0.55160058,0.66976982,0.79753249,0.9166892,1.0230806,1.1185311,1.2313157,1.3465268,1.4532008,1.5669202,1.6779712,1.7715284,1.7226258,1.6243929,1.515667,1.4642474,1.4631897,1.3960499,1.2900296,1.228983,1.2602798,1.2111751,1.2016547,1.1888491,1.1536809,1.0679714,0.9708945,0.89216839,0.78501787,0.67789102,0.56563262,0.53053632,0.42941426,0.43827411,0.47272785,0.55324465,0.59423904,0.5452982,0.45646381,0.35724445,0.24325599,0.12731941,0.022699681,-0.028615553,-0.11198029,-0.22869823,-0.31602602,-0.38572456,-0.45868996,-0.36338197,-0.23039724,-0.13999098,-0.13020271,-0.16407115,-0.22937532,-0.3171104,-0.3822293,-0.43624057,-0.50008636,-0.50724879,-0.45875147,-0.34882668,-0.20384327,-0.14155128,-0.0039278651,0.12506189,0.18661022,0.31028172,0.31421798,0.18807089,0.076994236,-0.044853036,-0.19000691,-0.31574856,-0.44125312,-0.57826408,-0.70011413,-0.78812318,-0.89029815,-0.96043192,-1.0473652,-1.1448402,-1.216635,-1.2647306,-1.2523157,-1.2408662,-1.1757025,-1.0927996,-1.0387493,-0.93035453,-0.84474669,-0.79165939,-0.73618339,-0.64067986,-0.55543307,-0.50295169,-0.48492059,-0.58729278,-0.55948586,-0.49343392,-0.37424271,-0.28025103,-0.20649426,-0.16002491,-0.12885055,-0.039621943,0.077365513,0.15680873,0.19366261,0.19781299,0.20110882,0.17939877,0.23004953,0.32884788,0.4167842,0.53676745,0.66690304,0.77134935,0.84290121,0.83499254,0.84386418,0.87906574,0.91857083,0.98878684,1.0844892,1.167886,1.2229004,1.2791262,1.3413334,1.3900503,1.3029005,1.1687708,1.0383966,0.92200788,0.79230905,0.67368322,0.55670329,0.43021054,0.30863361,0.19200353,0.074842239,-0.058930001,-0.19914555,-0.3408686,-0.48824503,-0.64685155,-0.76344095,-0.79078596,-0.82596766,-0.81573302,-0.72863264,-0.58943412,-0.48762815,-0.42384989,-0.36412638,-0.25910645,-0.1519822,-0.046747081,0.038888611,0.14806784,0.20313685,0.30192173,0.39276984,0.50627379,0.58053311,0.63738419,0.72853027,0.80823652,0.87058293,0.94439346,1.0500351,1.1419454,1.2080593,1.1809655,1.0422513,0.90753629,0.78049096,0.62537741,0.52457345,0.51922878,0.50002885,0.52690259,0.62272172,0.69818046,0.76852158,0.79516142,0.81467465,0.8767126,0.95201192,1.0232751,1.084319,1.0867162,1.1238404,1.1994096,1.2725485,1.3385223,1.3902897,1.4530699,1.5238413,1.6231152,1.7028809,1.5926523,1.4647944,1.3327387,1.2047938,1.0599076,0.93594607,0.80492257,0.67235157,0.53860034,0.40921164,0.28784702,0.14697892,0.013029302,-0.1199951,-0.24178853,-0.37433649,-0.43288623,-0.50974412,-0.63440818,-0.75404903,-0.88141482,-1.0030073,-1.1172149,-1.240657,-1.3563186,-1.4676697,-1.5647315,-1.6733892,-1.7864345,-1.8965735,-1.9722028,-2.0897625,-2.2092044,-2.3023535,-2.3796026,-2.4400538,-2.4341265,-2.3902928,-2.3191573,-2.2193141,-2.1068581,-2.0166184,-1.8952753,-1.7740792,-1.6704111,-1.5451152,-1.4615738,-1.3278317,-1.2301154,-1.0973871,-0.95969289,-0.83478047,-0.69352186,-0.59402976,-0.45177351,-0.33146824,-0.20515599,-0.072957832,-0.0189262,-0.11374564,-0.20078812,-0.28776368,-0.27878306,-0.21982209,-0.16889016,-0.093474372,-0.059218918,-0.0058547809,0.053009135,0.15225929,0.22926169,0.3224847,0.3832268,0.41988422,0.50641017,0.62088952,0.73410232,0.8374845,0.9082971,0.99844394,1.0851263,1.1899467,1.278573,1.2020271,1.105148,1.0015334,0.92609988,0.8188853,0.71452436,0.62027076,0.55862697,0.51318295,0.39820147,0.31135754,0.20316927,0.10666188,0.017400723,-0.076115676,-0.14544108,-0.20176893,-0.32704399,-0.38121325,-0.34125369,-0.2661527,-0.19513804,-0.27178359,-0.37295503,-0.46637116,-0.59107498,-0.70904919,-0.78766748,-0.88466346,-1.0277624,-1.1447362,-1.2780953,-1.3828609,-1.5009775,-1.6022171,-1.7095664,-1.8203565,-1.9305609,-2.0509178,-2.1700949,-2.2105906,-2.2668465,-2.3083205,-2.4191432,-2.4225072,-2.343376,-2.231133,-2.1851214,-2.0808788,-2.0945074,-1.9907402,-1.8715506,-1.7730033,-1.706444,-1.6243365,-1.5058591,-1.3860085,-1.2700058,-1.1465724,-1.0237826,-0.90320861,-0.77876441,-0.6559964,-0.53038409,-0.42977423,-0.3194974,-0.20958259,-0.085600642,0.036446438,0.16513623,0.29991071,0.42184197,0.55813176,0.6789078,0.80573713,0.93623301,1.0748302,1.2175575,1.3553934,1.4770709,1.6186046,1.5692438,1.4662382,1.3740895,1.2871437,1.1876809,1.105316,1.0299558,0.96364279,0.89599893,0.89056447,0.87966848,0.89083097,0.81678008,0.77472727,0.73237155,0.65370556,0.59835075,0.47680122,0.43408318,0.37083002,0.38078832,0.47290227,0.58917992,0.70383786,0.81715221,0.92043682:5
2.7980987,2.7172936,2.6253303,2.5302866,2.442413,2.3506208,2.2517328,2.1660616,2.0560903,1.9796263,1.8797058,1.7814709,1.6984122,1.6080597,1.5077009,1.4105225,1.3175767,1.225426,1.1387851,1.0395566,0.9418906,0.85183728,0.76965097,0.6723079,0.57306612,0.47440528,0.37608249,0.27827212,0.19509712,0.10926131,-0.0023888782,-0.085116814,-0.18635616,-0.29726502,-0.40210558,-0.49943852,-0.59628167,-0.69311893,-0.78848832,-0.9105286,-1.0062959,-1.108596,-1.2244732,-1.3232938,-1.4409811,-1.5620971,-1.6561525,-1.7768886,-1.8616312,-1.8892545,-1.8678717,-1.8467552,-1.8042524,-1.7576031,-1.7162348,-1.6697319,-1.6439138,-1.56718,-1.4901659,-1.4158916,-1.3314043,-1.2643822,-1.1763602,-1.1168401,-1.0633537,-0.97136613,-0.92272471,-0.87734361,-0.82405685,-0.75362154,-0.76363934,-0.80860985,-0.78233501,-0.7095159,-0.63519485,-0.56906263,-0.49505897,-0.42311155,-0.376493,-0.40250006,-0.38173066,-0.34576789,-0.31899497,-0.27304895,-0.25649818,-0.27592653,-0.37181672,-0.44968742,-0.51461333,-0.59626874,-0.6767185,-0.74330184,-0.81715553,-0.81171021,-0.83773845,-0.77937069,-0.71812346,-0.65525774,-0.5916906,-0.53846145,-0.48633932,-0.42168326,-0.35580392,-0.36706639,-0.4127642,-0.40556131,-0.37069403,-0.28502345,-0.24427331,-0.16287181,-0.091465181,-0.035167318,0.026906559,0.080064863,0.065200659,0.0028087992,-0.045074401,-0.021587697,0.035646038,0.092514116,0.16874611,0.22573273,0.30347499,0.38257386,0.45359584,0.48379483,0.48698126,0.56019541,0.63461263,0.70548246,0.772636,0.83549805,0.89761831,0.91465849,0.97597309,1.0453863,1.0936327,1.1338011,1.1255842,1.0745579,0.99362882,0.90424959,0.81844926,0.73169046,0.64304378,0.56032958,0.50296237,0.4607413,0.37752797,0.29233921,0.2047755,0.11366812,0.02809847,-0.044827932,-0.055708308,-0.094345529,-0.15388854,-0.23985825,-0.33050492,-0.41341985,-0.49282981,-0.58296776,-0.6661009,-0.74454931,-0.8367806,-0.90744245,-0.98308616,-1.0319043,-1.0741947,-1.0475247,-0.98935844,-0.89544081,-0.82642907,-0.71659978,-0.60812669,-0.50982331,-0.48344968,-0.53328732,-0.49027197,-0.41202416,-0.3194304,-0.23261756,-0.15106468,-0.11342961,-0.058046637,0.016474252,0.052560498,0.14108838,0.22418354,0.22601346,0.18355133,0.13765352,0.081797863,0.045581906,0.072044624,0.15057772,0.24341849,0.30512161,0.3805116,0.41189521,0.39074129,0.4573012,0.5398766,0.61026836,0.67218482,0.68174323,0.69135584,0.7679274,0.83849582,0.91507514,0.98854863,1.0504905,1.1065775,1.1820717,1.2485521,1.3265096,1.4124754,1.432605,1.4330839,1.4097511,1.2956583,1.2361267,1.1668476,1.1054231,1.0016433,0.92020825,0.80856625,0.736709,0.74416961,0.74439634,0.6691371,0.55883289,0.44341063,0.35497444,0.29970608,0.21651681,0.12123809,0.05737654,0.045732673,0.10484547,0.046765684,0.11215026,0.1946181,0.23303822,0.20898272,0.16622381,0.09878439,0.04422893,-0.060678895,-0.087001249,-0.17631736,-0.27482171,-0.35852752,-0.46296167,-0.47884143,-0.48568311,-0.5387365,-0.63841964,-0.68072888,-0.76335243,-0.84812534,-0.9291318,-0.99942887,-0.93088152,-0.84399114,-0.7606121,-0.66340535,-0.57690245,-0.46946966,-0.38031135,-0.28185143,-0.18198892,-0.084798694,-9.2980172E-4,-0.0062330485,0.020198604,0.10045513,0.1891233,0.27975946,0.35801336,0.44315781,0.53745165,0.63573632,0.69202211,0.75741079,0.84227779,0.910935,0.99480868,1.0947082,1.1403726,1.0832552,1.0115812,0.95010867,0.88293657,0.83837442,0.79653404,0.72075164,0.64187943,0.55869623,0.50465788,0.51307499,0.45502452,0.38601867,0.31351838,0.24810422,0.2441553,0.2776123,0.21769624,0.15688399,0.088041563,0.024856064,0.075671463,0.13404576,0.20003833,0.16252166,0.11053873,0.065935368,0.0053380862,-0.017991625,-0.073535327,-0.13364994,-0.20487507,-0.27418017,-0.35070848,-0.36915387,-0.2954477,-0.32653603,-0.41206792,-0.49891147,-0.55784719,-0.64411532,-0.72442595,-0.7826848,-0.82114925,-0.74382034,-0.67387321,-0.58373702,-0.50178242,-0.42642843,-0.34652138,-0.32003072,-0.36772039,-0.41689076,-0.45877493,-0.44374111,-0.48980794,-0.54584321,-0.62796013,-0.61282386,-0.62398766,-0.68598659,-0.75253484,-0.83202839,-0.92716915,-1.0208442,-1.1026644,-1.0993182,-1.1396608,-1.1762637,-1.2284885,-1.2719332,-1.3412714,-1.4250996,-1.5011515,-1.5830903,-1.6585215,-1.6956637,-1.7512029,-1.7870132,-1.7500249,-1.8150889,-1.8334072,-1.8783661,-1.9046306,-1.9080426,-1.9578037,-1.9436002,-1.8609463,-1.7579881,-1.6366996,-1.515547,-1.3947268,-1.3004812,-1.1793711,-1.0851273,-0.96924599,-0.86934442,-0.77459827,-0.67537942,-0.55792779,-0.46279497,-0.3674842,-0.27198102,-0.17623586,-0.080402877,0.01577467,0.11207887,0.20869509,0.30554173,0.39327074,0.47278615,0.57011457,0.66746195,0.7651385,0.85584075,0.93793956,1.0319699,1.129866,1.2220686,1.3041685,1.3980196,1.4969625,1.5944446,1.6871508,1.7689164,1.8645545,1.9630271,2.0614374,2.1525581,2.2358906,2.3315761,2.4309647,2.5255769,2.6138749,2.7015538,2.7769313,2.7975464:3
3.3475871,3.2518709,3.0930053,2.9729562,2.8018277,2.5247997,2.308238,2.0742671,1.8576549,1.6288198,1.4791866,1.2253098,1.0893071,0.88234244,0.71562506,0.47584457,0.24559244,0.048525001,-0.11437692,-0.34579208,-0.57175754,-0.79248876,-0.96213825,-1.174151,-1.3911337,-1.5077517,-1.6523405,-1.6789454,-1.868,-2.0366161,-2.2724933,-2.400659,-2.228279,-1.9912898,-2.0990282,-2.0375627,-1.8868944,-1.7015159,-1.6830847,-1.5362849,-1.4751258,-1.3203366,-1.1781538,-1.0480044,-0.94521407,-0.81479191,-0.72665113,-0.64286618,-0.60301133,-0.5397566,-0.46222368,-0.43404331,-0.49460266,-0.41143493,-0.33793087,-0.27354159,-0.20985952,-0.20525055,-0.16964964,-0.1672185,-0.11526437,-0.25978473,-0.36998029,-0.43577734,-0.61001674,-0.67712991,-0.73325457,-0.67727233,-0.80977993,-0.93566065,-0.80748922,-0.86323384,-0.93900329,-0.80381068,-0.70685852,-0.56843377,-0.43815355,-0.29456507,-0.13932877,-0.0015049002,0.0017347893,-0.030777396,0.073125202,0.13265187,0.15225014,0.13363721,0.22847552,0.26219714,0.4113151,0.52210467,0.51266176,0.37605262,0.17961338,-0.023066681,-0.21172894,-0.41588711,-0.59407081,-0.68175519,-0.71977809,-0.64722077,-0.61077934,-0.52348402,-0.51608796,-0.44967995,-0.32721253,-0.41813247,-0.30483962,-0.12014144,0.11457688,0.35373571,0.48374142,0.54541325,0.52669016,0.54023125,0.5799741,0.62920464,0.74634273,0.84276395,0.84724399,0.92390575,1.0344002,1.1185677,1.2427134,1.3875885,1.55359,1.7277088,1.8177427,1.8812368,1.7551879,1.6629986,1.5394319,1.3676676,1.2361292,1.0530562,0.8141585,0.7676602,0.78000716,0.59197923,0.47129311,0.42315335,0.41323855,0.29335307,0.29651475,0.2038799,0.05850307,-0.091658394,-0.14035477,0.075591474,-0.064411525,-0.10449598,-0.18581523,-0.19934788,-0.24691613,-0.11147577,-0.064171538,-0.017106545,-0.028311987,0.031111877,0.1427771,0.061028589,0.18572351,0.28049494,0.17280062,0.25271937,0.32117008,0.33630564,0.3904274,0.40167637,0.40288017,0.51367214,0.50352345,0.67668294,0.63856701,0.57540408,0.70051476,0.68513755,0.82174849,0.93138427,0.99602964,1.1393937,1.1664488,0.99473159,0.79658889,0.69084658,0.50111574,0.29563254,0.44916074,0.33180326,0.44573956,0.25165744,0.13889487,-0.052714592,-0.11101668,-0.25138069,-0.26046197,-0.32314188,-0.22257349,-0.18388855,-0.26781959,-0.12868802,-0.082598563,0.029126894,-0.048440585,0.076412252,0.15261699,0.29887812,0.53147254,0.66557316,0.81157106,0.91744842,0.943362,0.90021366,0.77377309,0.59889766,0.49648026,0.3130957,0.11078928,-3.1958987E-4,0.13744561,-0.022816217,0.055546721,0.095353622,-0.061240948,-0.009967,-0.061195929,-0.097195214,-0.1831138,-0.25330045,-0.37499586,-0.50312166,-0.59197275,-0.70124545,-0.80575117,-0.87657819,-0.92827615,-1.0674286,-1.2200142,-1.3127148,-1.1324564,-1.2414262,-1.4409713,-1.5848615,-1.629792,-1.6296833,-1.4189885,-1.2095832,-1.0171045,-1.0055444,-0.83748102,-0.73833727,-0.71041793,-0.5008935,-0.57254622,-0.32832079,-0.24508801,-0.027437658,0.13918904,0.34971187,0.52691318,0.75333344,0.99428759,1.2098218,1.3276363,1.2195623,1.0715316,0.92176091,0.7741513,0.63014174,0.46696311,0.43576625,0.38731015,0.23449428,0.080111122,-0.052449316,-0.082682128,-0.077118488,-0.21187546,-0.3268025,-0.54675995,-0.69170209,-0.81998407,-0.92114422,-1.0675823,-1.2064774,-1.1501329,-1.2705521,-1.2037615,-1.1568794,-1.0539093,-0.9750321,-0.8434776,-0.72301841,-0.75869664,-0.62911936,-0.52348402,-0.42866017,-0.22548335,-0.16045577,-0.10526743,-0.022352186,0.13646234,0.33244614,0.52876761,0.68274578,0.69491752,0.85880174,0.95195995,0.92156939,0.72214563,0.52319064,0.31954491,0.15240978,-0.014049431,-0.12532042,0.053791976,0.02682448,-0.034568904,-0.075529969,-0.17376067,-0.27612487,-0.27275913,-0.46684091,-0.64669364,-0.54004389,-0.57458481,-0.38931126,-0.2636106,-0.12156407,-0.12522534,0.08975758,0.23825367,0.21707418,0.31689446,0.15987496,0.12791202,0.033033854,0.010654743,-0.090977559,-0.17671243,-0.33284698,-0.36969629,-0.22809537,-0.22756511,-0.18263687,-0.22557986,-0.2325136,-0.255978,-0.33792741,-0.41707113,-0.46594724,-0.39422452,-0.30230295,-0.13256496,-0.094434471,0.026751123,0.12434833,0.38254376,0.37068838,0.56310422,0.59002059,0.52043983,0.46231106,0.42268821,0.39221947,0.32228568,0.22955681,0.11778553,0.042896541,-0.016286735,-0.072928942,-0.096708189,-0.094493968,-0.14969717,-0.17315737,-0.31565322,-0.41887416,-0.49845656,-0.66402099,-0.57010655,-0.67455361,-0.80977993,-0.85594935,-0.925249,-0.99853328,-1.1487646,-1.1065927,-1.2569848,-1.4354929,-1.3672993,-1.4824712,-1.6202057,-1.8081683,-1.9006091,-2.0493536,-1.9773335,-1.8261808,-1.71949,-1.4998825,-1.2812277,-1.0511006,-0.9125598,-0.74535938,-0.60119315,-0.44042111,-0.51287451,-0.27414094,-0.10408889,-0.060420962,0.12797493,0.36122167,0.58644052,0.80721682,1.016462,1.2389394,1.4627294,1.5933667,1.842807,2.0437917,2.2695368,2.4785245,2.7093204,2.9075488,3.1412874,3.2221062,3.3304827,3.3852172,3.4648173:1
1.7232489,1.6417187,1.5386561,1.4495152,1.3336024,1.2337036,1.1052367,1.028365,0.93606134,0.83073914,0.6717995,0.58631694,0.46991134,0.520801,0.52187111,0.44849829,0.35024564,0.21884102,0.10280519,0.014646814,-0.060120062,-0.22824392,-0.33881776,-0.42171636,-0.55247634,-0.49741183,-0.40440553,-0.28943269,-0.31937056,-0.35703001,-0.42387846,-0.45688195,-0.47252242,-0.58666094,-0.62829092,-0.71122069,-0.80651982,-0.87721571,-0.99713684,-1.0257094,-0.89444568,-0.86843404,-0.91660224,-0.99821419,-1.0206921,-1.0660138,-1.0492629,-1.1401763,-1.1991327,-1.2147234,-1.2752538,-1.2262175,-1.109867,-0.96166082,-0.86612824,-0.73264633,-0.61309984,-0.55181733,-0.54212079,-0.50319651,-0.46438417,-0.39751479,-0.37983896,-0.38346144,-0.39484877,-0.41588249,-0.37153784,-0.33465458,-0.33625254,-0.38019781,-0.42777306,-0.49818682,-0.57060782,-0.66433246,-0.72497846,-0.73592778,-0.824612,-0.74273062,-0.61892618,-0.47609686,-0.47630697,-0.52426736,-0.59340118,-0.66183406,-0.71366227,-0.76884235,-0.83252744,-0.91585232,-1.0254572,-1.0108507,-1.0990788,-1.1450157,-1.2052987,-1.2185011,-1.1545326,-1.2820331,-1.253759,-1.2501543,-1.1452153,-1.0015292,-0.87266157,-0.70467585,-0.56353872,-0.39705247,-0.27445478,-0.19322331,-0.053938412,0.11547135,0.28248661,0.45372546,0.58130726,0.73310585,0.86850728,1.0401544,1.1675981,1.3427271,1.4755778,1.5847321,1.7547753,1.9265594,2.047511,2.1763093,2.2960187,2.3852224,2.4850886,2.5354736,2.582849,2.616086,2.6291671,2.6108599,2.497346,2.3779347,2.2782051,2.1223496,1.9674353,2.0224916,1.892566,1.7690158,1.6398141,1.5273861,1.3865551,1.2622691,1.1207693,0.9713209,0.92500532,0.83214941,0.71126481,0.58568909,0.41490015,0.28863251,0.12585837,-0.032699917,-0.19610071,-0.36058107,-0.48829171,-0.59699741,-0.7529226,-0.87713483,-0.9768578,-1.120692,-1.1123005,-1.0329413,-0.96299101,-0.87470495,-0.80938533,-0.71068265,-0.592953,-0.48068783,-0.41849938,-0.35724174,-0.28828741,-0.23910828,-0.3036174,-0.29333096,-0.22015013,-0.21205199,-0.296673,-0.30935604,-0.27706686,-0.25334366,-0.22213291,-0.18204893,-0.13325552,-0.23073892,-0.32265963,-0.2678937,-0.19698653,-0.23439703,-0.19867406,-0.31621226,-0.25993301,-0.22090587,-0.23885063,-0.2223848,-0.27352142,-0.33761649,-0.42506659,-0.55410153,-0.68731892,-0.78486382,-0.71299261,-0.67401665,-0.62481041,-0.56365582,-0.48562206,-0.43965631,-0.39114133,-0.320754,-0.30263876,-0.36486337,-0.50425754,-0.45944612,-0.39629294,-0.33845752,-0.25325118,-0.28803341,-0.23005392,-0.14781892,-0.15166987,-0.070684029,0.0015909891,0.011518338,-0.096775013,-0.21179464,-0.25020331,-0.16258186,-0.077773418,-0.01206892,0.076679729,0.17196719,0.24266442,0.28904023,0.3161919,0.3680945,0.43803753,0.46479981,0.454529,0.56637711,0.62403488,0.64456519,0.57339789,0.60102048,0.72487688,0.83070891,0.89951516,0.91919336,1.0679126,1.1853014,1.3110057,1.3906232,1.4841487,1.5747349,1.7033928,1.7663517,1.7062775,1.5840362,1.4478945,1.3440249,1.1966629,1.0618117,0.9446601,0.8211198,0.67922948,0.55708656,0.4528903,0.32090304,0.19673646,0.055310627,-0.062197035,-0.20479541,-0.27290606,-0.29277704,-0.41206637,-0.53899306,-0.66239043,-0.78013597,-0.92551163,-1.0388374,-1.1579688,-1.2951958,-1.4088323,-1.5275624,-1.6618546,-1.7760155,-1.8989424,-1.9901953,-1.9396489,-1.8990136,-1.8463191,-1.7822649,-1.7037341,-1.6390548,-1.5113785,-1.4482676,-1.2929355,-1.1846914,-1.0875993,-1.0321887,-0.98977822,-1.0766357,-1.0082838,-0.89197085,-0.77244829,-0.6699891,-0.57719282,-0.50836797,-0.43094748,-0.30557682,-0.20122031,-0.13520453,-0.065060326,0.021272015,0.07456528,0.082722738,0.010081348,-0.11034938,-0.24779242,-0.34894004,-0.42703331,-0.49169139,-0.47837251,-0.39140311,-0.28654796,-0.18777542,-0.078290383,0.0099927133,0.019925751,0.13885244,0.26626639,0.38675977,0.49551637,0.61323344,0.70230451,0.68633462,0.63157197,0.71134411,0.82895028,0.96812829,1.0830365,1.2113763,1.3322019,1.35244,1.4493866,1.5343269,1.645421,1.7892954,1.9049317,2.0131434,1.9804129,1.922552,1.8012779,1.7079013,1.5816717,1.4728968,1.408982,1.286205,1.1505793,1.0164799,0.86949289,0.80732276,0.83319703,0.75807948,0.65870306,0.53788589,0.39757906,0.31314609,0.20318579,0.13345855,0.0046622786,-0.039955373,-0.12225302,-0.11698392,-0.0097694836,0.13538262,0.21894221,0.17874943,0.12191703,0.060173496,-0.02815493,-0.15879186,-0.27931989,-0.38801284,-0.36502078,-0.42068564,-0.53157134,-0.65865723,-0.75318015,-0.86785625,-0.98195077,-0.99698582,-0.99215493,-1.0361934,-1.1338691,-1.229818,-1.3188988,-1.4153576,-1.5137231,-1.5970601,-1.6988006,-1.7142473,-1.8072316,-1.7366179,-1.5640257,-1.3915061,-1.2161088,-1.0836863,-0.94904446,-0.81006309,-0.65270867,-0.47955909,-0.37354105,-0.332818,-0.2077719,-0.033034237,0.094452252,0.26928144,0.40086859,0.534489,0.62335216,0.73494228,0.90973866,1.0653682,1.2137521,1.389166,1.5648293,1.6751476,1.7284607:3
0.79736891,0.72202614,0.63288595,0.55459596,0.45705621,0.37784466,0.31114955,0.26186798,0.20396281,0.11393053,0.031842716,-0.040977791,-0.11895709,-0.18444295,-0.26205986,-0.32214184,-0.40078044,-0.48284826,-0.55716378,-0.63034629,-0.70694201,-0.79037222,-0.87935536,-0.9560623,-1.0425191,-1.1275682,-1.2133409,-1.2840976,-1.3688888,-1.441534,-1.514993,-1.5947818,-1.6682355,-1.7438556,-1.8080358,-1.8908328,-1.9755211,-2.040356,-2.110189,-2.1856532,-2.2569927,-2.3117468,-2.3719823,-2.3994455,-2.2973983,-2.1672095,-2.0711434,-1.9765076,-1.8809437,-1.7849919,-1.6496495,-1.5508871,-1.4161657,-1.3093014,-1.169965,-1.0651188,-0.95893904,-0.86298547,-0.77492333,-0.70515833,-0.63264853,-0.58800102,-0.5326183,-0.46678962,-0.4350563,-0.4151239,-0.40220977,-0.36831243,-0.35709947,-0.37083495,-0.35500016,-0.3549725,-0.35134705,-0.36903617,-0.38749421,-0.40231785,-0.42956083,-0.45085469,-0.48435189,-0.52346833,-0.54233718,-0.57820654,-0.60644789,-0.62973505,-0.6443933,-0.64565763,-0.64709436,-0.66629667,-0.68336199,-0.71787615,-0.75230762,-0.78197073,-0.7977456,-0.81462405,-0.81471483,-0.76250024,-0.66833723,-0.57251528,-0.47201487,-0.44618544,-0.38435138,-0.30470885,-0.24137654,-0.14152635,-0.054775559,0.047533374,0.15139768,0.24512107,0.29549198,0.34811796,0.37744285,0.40691849,0.43329664,0.47105735,0.56044614,0.62298092,0.67998732,0.7039412,0.70170982,0.67219456,0.65477698,0.69025639,0.73838122,0.7756426,0.80125339,0.82594721,0.8381772,0.86216696,0.88620821,0.91001456,0.94589835,0.9921399,1.1144066,1.2141113,1.3133719,1.3843634,1.5131873,1.6140668,1.7169187,1.8563829,1.9285498,2.0298683,2.1344111,2.2508172,2.2942848,2.3247451,2.3035979,2.2475441,2.1768228,2.0663057,1.9279104,1.8495772,1.8187465,1.7635203,1.7091425,1.6799896,1.6544004,1.6453115,1.6448786,1.6490603,1.6584143,1.6671277,1.6595762,1.624806,1.6132168,1.5714694,1.533247,1.4768603,1.4807484,1.4379493,1.3763392,1.3307986,1.2936153,1.2426662,1.17653,1.125169,1.0560211,0.99888007,0.90906308,0.84531795,0.72776714,0.64648612,0.5687375,0.49854061,0.46838823,0.4290395,0.41364228,0.42796064,0.4197592,0.4236346,0.42966262,0.42249454,0.38665345,0.3176467,0.25730935,0.25371665,0.17796059,0.12292031,0.054980486,-0.048294791,-0.12932271,-0.23062185,-0.33942671,-0.43493108,-0.51545788,-0.61828106,-0.71751993,-0.82378735,-0.9217674,-1.0228833,-1.1131893,-1.2226601,-1.3112511,-1.3719586,-1.4376533,-1.4890853,-1.510427,-1.4485559,-1.5080909,-1.5034334,-1.4911582,-1.4577347,-1.4300221,-1.3915844,-1.3376041,-1.3233447,-1.301262,-1.2731049,-1.2457103,-1.2146571,-1.185893,-1.1671331,-1.1397987,-1.1096097,-1.0696623,-1.024147,-0.97078922,-0.91993379,-0.86386425,-0.84272188,-0.79377394,-0.77405738,-0.71319367,-0.68326688,-0.64782162,-0.60615371,-0.5751716,-0.55236155,-0.51960075,-0.4888987,-0.48830612,-0.51513625,-0.50351766,-0.45895527,-0.4107848,-0.35668529,-0.3179507,-0.27306164,-0.22538863,-0.18283827,-0.15004907,-0.1052645,-0.097153301,-0.098503159,-0.11601673,-0.14384235,-0.2644987,-0.39203165,-0.49402535,-0.60457156,-0.71363251,-0.82362492,-0.92362553,-1.0390062,-1.1429003,-1.2193886,-1.2399159,-1.2739513,-1.1829772,-1.0939739,-1.002538,-0.96510798,-0.91470547,-0.8384399,-0.74459789,-0.65857702,-0.56122176,-0.4682011,-0.38346616,-0.28754045,-0.18950108,-0.10096067,-0.014861856,0.08902892,0.1779752,0.28172682,0.3697857,0.42700194,0.52027631,0.61587181,0.66100074,0.64254392,0.61199927,0.57916615,0.59550294,0.65801406,0.76399525,0.86892069,0.93080389,0.99396761,1.0577046,1.1153554,1.1693357,1.1911631,1.2033176,1.1957109,1.1318116,1.0449495,0.95954983,0.88089087,0.79291465,0.69531939,0.58935538,0.49745202,0.38667975,0.2978331,0.2087246,0.12267197,0.034784792,-0.052756771,-0.13368418,-0.20911712,-0.27826762,-0.32058922,-0.32263654,-0.31255392,-0.2982559,-0.26469701,-0.2395845,-0.21200992,-0.16423788,-0.11772344,-0.067673737,-5.2067591E-4,0.094994251,0.19360947,0.29262696,0.37201611,0.46242046,0.55987288,0.63413488,0.70445726,0.8452382,0.98169555,1.0802151,1.1390234,1.1669031,1.1720649,1.1486507,1.1149701,1.0649029,1.0191619,0.98459463,0.93911846,0.88212909,0.82452892,0.7620719,0.69404651,0.62537674,0.5472155,0.45759659,0.40184012,0.30809585,0.23350678,0.12928242,0.033193877,-0.061102775,-0.13872284,-0.25839029,-0.35522949,-0.4547378,-0.59092212,-0.7262552,-0.82745408,-0.88989108,-0.98162569,-1.0188126,-0.98735942,-0.90683798,-0.82539432,-0.74067422,-0.66060398,-0.57523042,-0.49304768,-0.4107966,-0.32942164,-0.25050098,-0.14430301,-0.054029474,0.037714875,0.13085822,0.22956699,0.31892086,0.40833448,0.50334453,0.5980013,0.6931765,0.7876333,0.87112265,0.96310296,1.0510684,1.141107,1.2211265,1.2765894,1.3184499,1.3570402,1.3408354,1.3117296,1.265311,1.2459751,1.1925744,1.1350771,1.0917958,0.98573044,0.95529266,0.88655854,0.85690953:2
0.38508532,0.27564999,0.1413792,0.012153409,-0.061126048,0.0017921453,-0.095091656,-0.18989171,-0.28265303,-0.35957476,-0.44350993,-0.5176341,-0.58379663,-0.62665625,-0.64961142,-0.56603295,-0.45753566,-0.52260649,-0.432452,-0.3701569,-0.44960809,-0.55512603,-0.63269625,-0.6909612,-0.7558883,-0.81367716,-0.87572585,-0.92980114,-0.97226083,-1.0276454,-1.0735436,-1.1172745,-1.1621911,-1.2013326,-1.236084,-1.2625737,-1.2861669,-1.2995668,-1.305119,-1.3095514,-1.3016993,-1.282815,-1.2393836,-1.1850981,-1.0997874,-0.99555491,-0.90370671,-0.81597001,-0.75205205,-0.67929894,-0.61002636,-0.54454847,-0.4682202,-0.40738468,-0.33912559,-0.2712243,-0.19950695,-0.13879838,-0.071821566,-0.0012343457,0.057603069,0.11131625,0.062816909,0.012647504,-0.032082137,-0.036705603,0.016246105,0.0059109471,-0.0267139,-0.045207948,-0.049159388,-0.044426605,-0.029628192,-0.0082491025,0.014715778,0.050277983,0.089330411,0.14829793,0.21370734,0.27614971,0.34654059,0.43330497,0.54695351,0.62348299,0.68930137,0.72042238,0.75749585,0.79525605,0.83275089,0.84689704,0.86409548,0.90465968,0.9440725,0.98134488,1.0248503,1.0670078,1.1016602,1.1388476,1.159892,1.1819913,1.1748418,1.164635,1.1439503,1.1261343,1.1123817,1.1229043,1.191302,1.2856178,1.3730828,1.4701929,1.5615123,1.663219,1.7623418,1.8540063,1.9506702,2.0479672,2.1466492,2.2460233,2.337565,2.4361427,2.4841377,2.3831167,2.2911508,2.1955252,2.0973604,1.9978747,1.8997009,1.8043815,1.7113699,1.6154617,1.5136032,1.4138256,1.3177641,1.2185099,1.1372038,1.1180957,1.1236478,1.1065958,1.1025475,1.0773859,1.0582818,1.0444169,1.027537,1.0038766,0.97733324,0.93973681,0.90383218,0.87145198,0.82184662,0.76724408,0.73055934,0.6971116,0.67553855,0.65422898,0.61265467,0.58423732,0.5639031,0.54824173,0.53092224,0.45499222,0.3983512,0.39444951,0.39778435,0.39059488,0.40930503,0.36395214,0.32371707,0.28596377,0.23225666,0.17038797,0.12793267,0.079723769,0.026716693,-0.018546,-0.056864656,-0.14351021,-0.23613851,-0.34738025,-0.44178988,-0.52543112,-0.60190823,-0.67775591,-0.73462833,-0.77608766,-0.8020971,-0.80889669,-0.82290002,-0.81994966,-0.82121136,-0.81214959,-0.79882721,-0.78412767,-0.75572635,-0.73624444,-0.696533,-0.64318224,-0.58964406,-0.51658591,-0.45154254,-0.44382882,-0.5020199,-0.43881777,-0.35609704,-0.28521694,-0.20031378,-0.10634128,-0.10899385,-0.2087551,-0.30446313,-0.39299325,-0.48366549,-0.55730774,-0.64099903,-0.7274222,-0.8127136,-0.89979212,-0.98412209,-1.0762094,-1.1561068,-1.2458364,-1.3358969,-1.4314539,-1.5426211,-1.6609391,-1.7682046,-1.8634096,-1.9206512,-1.9480059,-1.9546637,-1.943286,-1.9167623,-1.856875,-1.776186,-1.6794841,-1.6005205,-1.4969127,-1.4188413,-1.3387959,-1.2267677,-1.1063582,-0.98483987,-0.87880249,-0.74968042,-0.64349787,-0.53397548,-0.42098111,-0.35215956,-0.43573097,-0.52144126,-0.56417555,-0.51972136,-0.42179793,-0.29355632,-0.16418324,-0.031451541,0.0379457,0.16940149,0.28896975,0.39592717,0.29337487,0.19249419,0.08628761,-0.027594863,-0.12219747,-0.17406812,-0.18171257,-0.29567801,-0.40852837,-0.52018067,-0.63299873,-0.7205735,-0.80906023,-0.90465169,-0.98938936,-1.0519264,-1.1165823,-1.1777382,-1.2197746,-1.1951918,-1.1450951,-1.0830224,-1.0063304,-0.93416702,-0.85830554,-0.77388276,-0.67764399,-0.58197534,-0.48819762,-0.38119724,-0.28010341,-0.18225679,-0.068651823,0.02783792,0.14128351,0.25397325,0.34761271,0.44870462,0.5579444,0.67157098,0.78405023,0.89559166,0.99381611,1.0262676,1.1323836,1.2143961,1.1280026,1.0523444,0.96119065,0.8968996,0.83736854,0.79161702,0.79006354,0.85990191,0.94171354,1.0376258,1.1258328,1.2218432,1.3226866,1.4105798,1.5064359,1.5745327,1.5547967,1.6427776,1.7318532,1.8231027,1.83855,1.7317472,1.7345205,1.6430283,1.5402959,1.4442155,1.3367353,1.2456318,1.1400242,1.1102178,1.14808,1.2294455,1.3198341,1.3274275,1.3044582,1.2063899,1.1149721,1.0109743,0.91766681,0.82277245,0.72833347,0.63360694,0.53689989,0.42436608,0.33657401,0.22986999,0.14074836,0.03977114,-0.056807159,-0.09663891,-0.097964721,-0.06689655,-0.0091595296,0.064335845,0.17706032,0.27379638,0.38157529,0.48195886,0.59180297,0.69184337,0.79828351,0.87359028,0.77817246,0.67680917,0.5874685,0.48604127,0.38847145,0.28822892,0.19371835,0.10160318,8.0160806E-4,0.025315151,0.084392851,0.07339499,0.055235627,-0.049010283,-0.15200808,-0.24984235,-0.34680163,-0.44350362,-0.53447984,-0.62627253,-0.7122895,-0.81471713,-0.90966052,-0.99981997,-1.0929985,-1.1923339,-1.2918944,-1.3862206,-1.4687631,-1.5604372,-1.6519312,-1.7263172,-1.7957248,-1.8639787,-1.9305832,-1.9718939,-1.9668868,-1.9499364,-1.8950117,-1.8254414,-1.7391248,-1.6585215,-1.5458774,-1.4544565,-1.3402377,-1.2280885,-1.1143479,-1.0028776,-0.86717903,-0.75780788,-0.6232854,-0.49128405,-0.35704341,-0.29793244,-0.22092216,-0.10956026,0.0046293892,0.13845337,0.2459076,0.34586694:4
1.9381298,1.7589569,1.5795839,1.433235,1.2680494,1.08877,0.90921655,0.77647199,0.59736737,0.44304583,0.28545707,0.11253981,0.0013769571,0.028296259,0.078599916,0.11486388,0.16347293,0.20902051,0.25611271,0.3232817,0.31274399,0.36754659,0.43027937,0.4316794,0.4980817,0.4889229,0.50337626,0.52067258,0.49356007,0.46762083,0.41116105,0.3518643,0.38391841,0.38982369,0.47320076,0.53826663,0.55501595,0.53879391,0.56486882,0.59200128,0.58110399,0.55631441,0.51694444,0.50191749,0.59012467,0.52865912,0.60149076,0.58041424,0.53615439,0.51430039,0.57607339,0.56038363,0.55272588,0.51648909,0.51474956,0.45095159,0.31830896,0.19810634,0.070077181,0.098376376,0.049810616,0.052696156,0.10602821,0.18020799,0.053433366,0.13521993,0.21380711,0.23208491,0.25378576,0.2372917,0.29657818,0.37004859,0.42622889,0.37957989,0.38344928,0.4191526,0.42328809,0.46011741,0.45268972,0.44702849,0.42228689,0.38308965,0.3240384,0.30295097,0.28954538,0.36512111,0.39973961,0.4431424,0.4586906,0.49346768,0.49905001,0.55415288,0.57358034,0.59247139,0.65557559,0.70650461,0.76717293,0.8602221,0.92199813,0.96648237,1.0360813,1.0940724,1.1426844,1.133303,1.0982528,0.94981766,0.82486616,0.68036132,0.5766558,0.4554012,0.33771068,0.23693264,0.15916192,0.031224339,-0.10835682,-0.21775874,-0.36157543,-0.46027206,-0.57769001,-0.66936114,-0.77561069,-0.87634128,-0.94796164,-1.0178859,-1.1311002,-1.2343593,-1.3687076,-1.4134991,-1.4711644,-1.5589863,-1.6832808,-1.7891919,-1.8631442,-1.9774491,-1.9486831,-2.0947321,-2.273195,-2.3968608,-2.5221678,-2.6423065,-2.6153079,-2.5850598,-2.5647972,-2.5306885,-2.4550574,-2.3692983,-2.2789003,-2.1962636,-2.1276254,-2.0831204,-2.0554305,-1.9942989,-1.9350143,-1.8566634,-1.8020002,-1.6726,-1.6344378,-1.5192257,-1.4129992,-1.4276066,-1.3179559,-1.3066605,-1.1832636,-1.042721,-0.97066929,-0.83734231,-0.71729724,-0.82227925,-0.67420975,-0.64456398,-0.60098747,-0.4768155,-0.42149632,-0.50604543,-0.57267447,-0.64890502,-0.65314323,-0.5597692,-0.49040755,-0.45085014,-0.37226991,-0.20561915,-0.037221654,0.1263709,0.2525965,0.33448637,0.3744279,0.3723424,0.45602767,0.5509919,0.61626862,0.76121779,0.93367184,1.0927704,1.2004986,1.3711619,1.4804146,1.6367824,1.7989046,1.9324834,2.1091317,2.2838171,2.3533084,2.322688,2.2131153,2.1348379,2.1239879,2.0335114,1.9100199,1.8037142,1.6972407,1.612954,1.5128275,1.4153361,1.2860652,1.141712,1.1417954,1.053756,0.95669531,0.90667688,0.78933675,0.68211572,0.54786088,0.57703438,0.53222088,0.5326541,0.46635032,0.34454929,0.25635731,0.17127797,0.079128868,-0.026941644,-0.12007712,-0.23284455,-0.18915674,-0.27384473,-0.38935359,-0.47484396,-0.58426759,-0.65555807,-0.62910546,-0.62916697,-0.71927279,-0.81074484,-0.74479316,-0.64250295,-0.53674566,-0.41699627,-0.43227736,-0.34151211,-0.20407673,-0.095694826,-0.12381718,-0.16157273,-0.19071493,-0.18101257,-0.30697931,-0.2772039,-0.34587392,-0.41554703,-0.4625704,-0.53177751,-0.57103189,-0.67191602,-0.76672314,-0.87419919,-0.8588559,-0.99563722,-1.0863833,-1.2196739,-1.3458971,-1.4156673,-1.3282949,-1.2748486,-1.3872529,-1.3179649,-1.3895342,-1.4331935,-1.4830504,-1.5372444,-1.5936375,-1.6157034,-1.670159,-1.7618998,-1.8552949,-1.9421987,-1.9783483,-2.0024292,-1.9212391,-1.8993458,-1.7910393,-1.6844207,-1.5525992,-1.4039802,-1.2760523,-1.3050176,-1.1893628,-1.0663763,-0.96711245,-0.83803484,-0.7340445,-0.6887459,-0.57082676,-0.45526093,-0.46633646,-0.37111326,-0.25884602,-0.16090363,-0.067448012,0.028289459,0.14420049,0.267021,0.36821798,0.49873618,0.60207293,0.69039532,0.77321547,0.82302425,0.74614571,0.66915949,0.58177535,0.48610956,0.41127947,0.39820211,0.31801484,0.24108773,0.16246666,0.17669676,0.13441505,0.074829278,0.003925685,-0.058217252,-0.12990721,-0.19355461,-0.11995752,-0.12853934,-0.1643757,-0.16535932,-0.18286852,-0.12567069,-0.11578423,-0.1526625,-0.21241682,-0.25306077,-0.27544393,-0.16224358,0.010494744,0.14989559,0.17154038,0.16407098,0.16613757,0.18361946,0.20605947,0.16604613,0.11184031,0.055719078,0.068952479,-0.0045990462,-0.034058371,-0.065406533,-0.12000933,-0.15215327,-0.17449017,-0.20652311,-0.22671935,-0.24494163,-0.26260976,-0.27201146,-0.23901408,-0.17698081,-0.097436751,-0.051641266,0.052529178,0.035542787,0.10492646,0.22564363,0.33690393,0.47114909,0.60717454,0.64584,0.67391974,0.72761681,0.78021099,0.80804427,0.87987974,0.94453956,0.95000963,0.94556672,0.95847498,0.93494317,0.8780427,0.88998712,0.97053017,0.95598714,0.92610501,0.86830206,0.87403981,0.85036016,0.79520355,0.76673756,0.67980609,0.64323206,0.54196742,0.47658277,0.45798348,0.42459303,0.40036609,0.32418995,0.28651546,0.20889432,0.26506727,0.22823332,0.17929206,0.27077873,0.4376952,0.56186672,0.73548142,0.89489248,1.0411964,1.1666001,1.2948111,1.4740039,1.6517188,1.8332677,1.965457,2.0109867,1.9697638:3
0.84628592,0.80489275,0.72246653,0.63646546,0.50118751,0.45867515,0.43907116,0.35313586,0.27447259,0.19040791,0.045283659,0.15380125,0.026031582,0.03993779,-0.06505948,-0.045693477,0.0088189887,-0.034604825,-0.11144406,-0.055472119,-0.22096204,-0.27062999,-0.37144142,-0.31046562,-0.42209959,-0.46973079,-0.54052842,-0.61765424,-0.70437598,-0.56167483,-0.48666703,-0.37528142,-0.20552434,-0.029604143,-0.069325994,-0.073772106,-0.10821732,-0.19689639,-0.23326947,-0.23711637,-0.24718699,-0.32792354,-0.39865172,-0.51132286,-0.62351203,-0.66213955,-0.76527704,-0.79387096,-0.85048606,-1.0027168,-1.1824082,-1.349688,-1.4990712,-1.6061102,-1.6979528,-1.8599555,-1.9530072,-1.8591422,-1.9327102,-1.7629005,-1.5880141,-1.4233178,-1.2529211,-1.0880848,-0.91321296,-0.76051393,-0.5789996,-0.40563948,-0.23866082,-0.066596773,0.10232896,0.26744914,0.43150569,0.61569416,0.79290651,0.94728976,1.1135796,1.2850883,1.4618068,1.6029708,1.7775766,1.9452484,2.1304787,2.300736,2.4421386,2.3726369,2.2793875,2.1502786,1.9714934,1.843249,1.6678074,1.5029648,1.3268402,1.148801,0.97176741,0.83680329,0.64426729,0.4595776,0.30308429,0.11515058,-0.044912104,-0.192451,-0.34912062,-0.45314114,-0.63431352,-0.72004606,-0.90322905,-1.0856158,-1.1541997,-1.3128279,-1.4898422,-1.6702167,-1.6879767,-1.8607088,-1.8770278,-2.0067705,-2.1613447,-2.3256528,-2.4444619,-2.408848,-2.3323491,-2.1882053,-2.0270602,-2.0286431,-1.8735939,-1.7880249,-1.730333,-1.6385589,-1.4843212,-1.3377287,-1.1997901,-1.0811105,-0.973922,-0.89732627,-0.87286334,-0.84043603,-0.75646945,-0.77122077,-0.67518654,-0.71707497,-0.63194864,-0.54428716,-0.4657198,-0.37979315,-0.29591534,-0.1977748,-0.11945029,-0.0121903,0.029354319,-0.11909003,-0.34837073,-0.51869262,-0.65715201,-0.72069375,-0.60422561,-0.47519031,-0.43012649,-0.3392478,-0.21490294,-0.15407887,-0.12142378,-0.023948581,0.095733884,0.16245976,0.23551394,0.28749979,0.34720306,0.42115269,0.47081908,0.50295214,0.58760242,0.66053102,0.77406921,0.90040022,1.0178844,1.1566235,1.2378496,1.3285415,1.3710396,1.220823,1.0510974,0.86660824,0.70930035,0.57591936,0.46658604,0.28554195,0.13738679,0.081069299,-0.097186282,-0.25915432,-0.42437629,-0.57806697,-0.74512736,-0.80480309,-0.69251104,-0.61968535,-0.57092939,-0.44216897,-0.35519212,-0.26151779,-0.20813744,-0.057104083,-0.044647591,0.025926782,0.095464797,0.22025256,0.34489261,0.44749921,0.53940776,0.63688655,0.65049082,0.74492544,0.79998599,0.8420763,0.92640707,1.0085075,0.96693485,1.0234541,1.1210859,1.2549627,1.3113798,1.3496901,1.4819615,1.6297754,1.6470098,1.7788128,1.8776789,1.9805179,1.8304963,1.5903533,1.349108,1.1677454,0.92766825,0.77866605,0.68326091,0.48944379,0.26363559,0.20145419,-0.021220738,-0.20469243,-0.38133803,-0.59212122,-0.54442092,-0.41150616,-0.3056108,-0.16132084,-0.033377831,0.084740856,0.22876204,0.34474348,0.47643737,0.61964777,0.72103091,0.6229285,0.55822398,0.70980558,0.84190624,0.99212506,1.088853,1.1977568,1.272791,1.3975983,1.3813435,1.5166508,1.6711721,1.6832368,1.8462171,1.9975669,2.1673016,2.3329699,2.4299577,2.2339162,2.0439089,1.8478613,1.8004932,1.6593986,1.4855502,1.3782427,1.1956771,1.0258944,0.98895072,0.79488146,0.62695419,0.48042699,0.28197046,0.12541377,-0.043400492,-0.13644039,-0.22517985,-0.3966393,-0.5490568,-0.72117409,-0.87777267,-1.0614395,-1.2140943,-1.3791685,-1.5609731,-1.7321477,-1.8952048,-1.9349302,-1.8084405,-1.6933139,-1.4954374,-1.2985279,-1.1683219,-1.0936831,-0.9955573,-0.85111602,-0.75744201,-0.66462132,-0.78106081,-0.65492957,-0.52865538,-0.40547022,-0.26705744,-0.37884898,-0.25982535,-0.094769976,0.0060547303,-0.1365148,-0.2475009,-0.40488963,-0.33919803,-0.48913899,-0.6010165,-0.74243428,-0.71944115,-0.61369016,-0.78851001,-0.91539371,-1.0598415,-1.1457929,-1.2933336,-1.4129811,-1.5293229,-1.4945209,-1.3009999,-1.1754163,-1.0289194,-0.84670593,-0.69046097,-0.54649848,-0.38671621,-0.22738337,-0.12964876,-0.030827162,0.11515058,0.24908059,0.4325034,0.5554297,0.74285184,0.94675426,1.0941224,1.1740237,1.0578007,0.91987431,0.87176589,0.72539489,0.61014087,0.54947917,0.45725161,0.34700082,0.43503054,0.32454067,0.17132854,0.080565129,0.16532819,0.079097544,-0.056977346,-0.17426941,-0.24705132,-0.37843231,-0.23931316,-0.40775807,-0.52053111,-0.64535395,-0.76619578,-0.88414966,-1.0382761,-0.94712008,-0.77709279,-0.67217356,-0.52112547,-0.34991407,-0.18002029,-0.082784375,0.082874088,0.2486759,0.35397218,0.53470721,0.64628969,0.79992895,0.95178206,1.1040126,1.0458716,0.97013756,0.94779846,0.83857726,0.7565302,0.63273086,0.56981154,0.56105128,0.47434616,0.37572723,0.26145709,0.21276752,0.21841999,0.18044267,0.12120952,0.04076424,-0.0094011745,-0.13311322,-0.21866465,-0.23889674,-0.31991536,-0.38137604,-0.45965367,-0.57274402,-0.47778659,-0.29641443,-0.11347067,0.058827041,0.29294062,0.40266618,0.64102983,0.78566268,0.88253294:1
1.7530133,1.6617202,1.5430458,1.451726,1.3368172,1.2178349,1.1779259,1.1433629,1.0280134,0.92857074,0.81442342,0.72549638,0.65149407,0.71522331,0.74519884,0.67265676,0.58389538,0.487444,0.38755329,0.27396072,0.18144544,0.1127629,0.001406154,-0.09736255,-0.14460015,-0.17898354,-0.11907666,-0.046381817,0.021961213,0.11022465,0.16951055,0.17848269,0.12360515,0.031860005,-0.082304919,-0.13982563,-0.24261159,-0.35332368,-0.35363258,-0.46928585,-0.5867869,-0.68466154,-0.78882264,-0.8956808,-0.9485065,-0.88577137,-0.86508491,-0.87066224,-0.93945443,-1.0192992,-1.1036257,-1.1965107,-1.2986296,-1.3899197,-1.455266,-1.5161948,-1.5906833,-1.695287,-1.7344005,-1.6324552,-1.541235,-1.4361806,-1.3278829,-1.2336698,-1.118385,-1.0148686,-0.95737448,-0.85249355,-0.7628896,-0.68733411,-0.58023026,-0.46783722,-0.36598297,-0.34178008,-0.37323462,-0.30614054,-0.19874608,-0.094859617,0.01272221,0.089783209,0.18980262,0.2850011,0.39756641,0.45022288,0.53303574,0.64651643,0.74319688,0.83724858,0.94379389,1.0544953,1.1518168,1.1842075,1.1535116,1.0850382,1.0047177,0.90935461,0.81826254,0.74310441,0.65706071,0.56200099,0.46272077,0.37532016,0.29571501,0.23527121,0.27724086,0.26407064,0.17525154,0.11235129,0.05820518,-0.014463465,0.012300736,-0.020572839,-0.10422428,-0.18420576,-0.23499552,-0.14811988,-0.077361251,-0.097065458,-0.16770194,-0.20463323,-0.26349952,-0.31869001,-0.39696471,-0.47196659,-0.43968829,-0.45645111,-0.48574427,-0.56832968,-0.63015811,-0.62065354,-0.69626157,-0.76962308,-0.69547005,-0.60573828,-0.51203234,-0.41141372,-0.29519897,-0.22500479,-0.23681143,-0.26285893,-0.29287771,-0.29843657,-0.28671898,-0.31662898,-0.34616813,-0.36044437,-0.38359361,-0.46736579,-0.57737536,-0.66525592,-0.67633045,-0.7300572,-0.78308355,-0.84473,-0.90927466,-0.91284935,-0.85244014,-0.75319471,-0.64110376,-0.57394967,-0.57107745,-0.59305041,-0.63005162,-0.68114684,-0.73387445,-0.73618713,-0.78895302,-0.82183456,-0.85316648,-0.89003381,-0.90707451,-0.93740301,-0.98247235,-1.0436496,-1.1106859,-1.1505585,-1.1735645,-1.1310292,-1.0893154,-0.9786725,-0.8724511,-0.73067976,-0.61724727,-0.47663651,-0.3692463,-0.22571757,-0.11167213,0.033210242,0.17597217,0.29002085,0.43173347,0.52702016,0.65749024,0.8002394,0.94377909,1.0887208,1.2322462,1.3748742,1.520029,1.6644035,1.8094971,1.9540099,2.0682665,2.211766,2.2960117,2.4309453,2.5291045,2.6659746,2.7848383,2.9292712,3.055817,3.184248,3.2841126,3.2911735,3.2577628,3.1697707,3.028326,2.9140671,2.7687614,2.6424392,2.5083777,2.3622686,2.2168273,2.0712986,1.9260858,1.7807872,1.6662142,1.520521,1.374774,1.2294882,1.0848087,0.93978265,0.79425698,0.68003983,0.53417557,0.38859707,0.24400428,0.1013266,-0.016680575,-0.16201576,-0.30660973,-0.42437205,-0.56735159,-0.71162337,-0.85678283,-0.97345593,-1.1188303,-1.2327187,-1.300378,-1.2773665,-1.2723346,-1.2726589,-1.2774572,-1.2607419,-1.2289346,-1.245899,-1.2184177,-1.1863769,-1.1646188,-1.155898,-1.1258463,-1.0758602,-0.99582003,-0.92345663,-0.85874324,-0.82241099,-0.76874183,-0.72335068,-0.68096339,-0.60853458,-0.53815466,-0.50487153,-0.5377946,-0.62274223,-0.61108236,-0.54994513,-0.50093947,-0.42419795,-0.36496023,-0.29894142,-0.28239572,-0.33745844,-0.28336196,-0.21990682,-0.15920244,-0.10549013,-0.091504549,-0.17221027,-0.27143016,-0.37761117,-0.4833267,-0.57672269,-0.6771441,-0.78976,-0.88421313,-0.9833398,-1.0100528,-0.97842388,-0.95343792,-0.90661445,-0.86521006,-0.81506411,-0.77805167,-0.72425075,-0.67110279,-0.62341348,-0.58200635,-0.65676601,-0.73275683,-0.69155485,-0.63107788,-0.56449101,-0.48715042,-0.47052287,-0.41881568,-0.34168282,-0.27704018,-0.19311053,-0.14470308,-0.23290495,-0.318503,-0.39938519,-0.36884555,-0.30276259,-0.23339778,-0.15379901,-0.12525517,-0.09521339,-0.03596259,0.046463942,0.12269924,0.21919064,0.2748512,0.27336992,0.24021609,0.31947457,0.4065744,0.48858101,0.56991352,0.64716723,0.71926178,0.77003111,0.85509772,0.92383229,0.99832644,1.0667673,1.1501203,1.207114,1.1700075,1.0612914,0.97601949,0.86546766,0.75235806,0.65544867,0.54994089,0.44317058,0.35484259,0.24446454,0.13504312,0.017427109,-0.081907623,-0.14462967,-0.22993432,-0.24529341,-0.31602342,-0.42850205,-0.5339616,-0.61497308,-0.69122025,-0.79891103,-0.90543498,-1.0281603,-1.1351699,-1.2057951,-1.2479657,-1.3396117,-1.4419997,-1.4409298,-1.3503837,-1.256138,-1.1670007,-1.0737871,-0.97877083,-0.86833835,-0.78154701,-0.70792545,-0.688186,-0.63192462,-0.53503955,-0.42340533,-0.31136621,-0.23999869,-0.23174582,-0.10635121,0.005455161,0.11902377,0.18222639,0.31173987,0.43569181,0.47074503,0.48714459,0.41923832,0.32271553,0.240952,0.20377498,0.13711627,0.058963854,0.10295396,0.19380006,0.31235124,0.37316141,0.34809687,0.46313444,0.54887916,0.6443027,0.72194523,0.74659202,0.83985996,0.94775217,1.0615981,1.1410572,1.2707419,1.353074,1.4596727,1.6018501,1.7095994,1.7602461:3
1.7582998,1.6681106,1.5668331,1.4759004,1.3802181,1.2877549,1.1749817,1.0835099,0.97943857,0.89011312,0.79038842,0.69583297,0.5992586,0.49978454,0.40894363,0.30694532,0.21540279,0.11610594,0.015034635,-0.07499185,-0.1699772,-0.27039383,-0.3531235,-0.42670019,-0.52333076,-0.62029547,-0.71579719,-0.80822618,-0.9071936,-1.0022046,-1.1028146,-1.1938214,-1.2871548,-1.395374,-1.482274,-1.5696565,-1.5056443,-1.4562083,-1.3640117,-1.2629564,-1.1875084,-1.0702279,-0.9874857,-0.92534879,-0.89166837,-0.83292705,-0.77932983,-0.72365676,-0.68018904,-0.62022137,-0.58861527,-0.55130471,-0.4994524,-0.47016801,-0.4860003,-0.56425507,-0.64803381,-0.75306148,-0.85001371,-0.9031538,-0.88198271,-0.81008392,-0.76241817,-0.70205572,-0.63986568,-0.56623222,-0.54215808,-0.45599846,-0.38102774,-0.30149417,-0.21403951,-0.14610303,-0.090836882,-0.03077255,0.026449286,0.10516473,0.1693347,0.23329095,0.28896335,0.34889521,0.31747306,0.27078628,0.2600902,0.24534109,0.31379914,0.38533482,0.46733333,0.54805719,0.62729193,0.70223354,0.77774632,0.83740869,0.89817692,0.9711166,1.0758222,1.1591712,1.2251829,1.3037191,1.375238,1.4209632,1.4710055,1.5338796,1.5949005,1.5984283,1.5304318,1.4379832,1.3494412,1.2693581,1.1719574,1.0937535,0.99356257,0.90240895,0.81227814,0.72153471,0.62573998,0.5361833,0.47657946,0.4279513,0.34593151,0.26689839,0.18349175,0.080737847,-0.0092099069,-0.11561221,-0.21869127,-0.31711766,-0.42680314,-0.5220517,-0.63420735,-0.72859911,-0.8342776,-0.93778263,-1.0260059,-1.1397815,-1.2345141,-1.3420782,-1.4418142,-1.5381788,-1.6262843,-1.6882903,-1.7853881,-1.8692598,-1.8792003,-1.7768593,-1.6826639,-1.5817127,-1.4768718,-1.3788283,-1.2897805,-1.2241162,-1.1272559,-1.0274876,-0.9243809,-0.82127512,-0.72049664,-0.61494746,-0.53536762,-0.43988962,-0.34824255,-0.24765711,-0.15453538,-0.018075959,0.058561846,0.13614918,0.21432481,0.283545,0.34791891,0.43311319,0.50303504,0.56709885,0.57740326,0.51886717,0.49352051,0.4484968,0.39959987,0.34869658,0.36211494,0.35047111,0.42361717,0.51342258,0.60028438,0.67924308,0.73568765,0.78856671,0.85624762,0.93922158,1.0274987,1.1174746,1.1446888,1.1389568,1.1567057,1.1963845,1.2604664,1.3493857,1.4240727,1.4963842,1.5380843,1.5867637,1.608874,1.5566678,1.5110391,1.4401981,1.3690036,1.2611716,1.1859845,1.1623008,1.1038931,0.98970283,0.89168433,0.79192782,0.73590786,0.6310419,0.53226737,0.44217724,0.34365936,0.31123991,0.32081325,0.35497426,0.40495805,0.44535075,0.44044569,0.38515317,0.3003141,0.21418603,0.12070727,0.042193434,-0.040720046,-0.13564151,-0.22800533,-0.3126131,-0.4013867,-0.48490907,-0.5737985,-0.67013396,-0.76292146,-0.85730892,-0.93383041,-1.0087921,-1.091578,-1.1752883,-1.2506489,-1.3497008,-1.432871,-1.5145308,-1.5968959,-1.678248,-1.7683429,-1.8537739,-1.9342622,-1.9929561,-2.0461061,-2.088068,-2.0598025,-1.9931118,-1.8554898,-1.7616752,-1.6690967,-1.5513646,-1.4508306,-1.3128196,-1.2111641,-1.1309516,-1.0198157,-0.89558273,-0.80178114,-0.67364151,-0.58019081,-0.47673042,-0.38880408,-0.27078392,-0.1726176,-0.068155693,0.019077759,0.10248012,0.18157212,0.28559517,0.35499794,0.43177531,0.52758931,0.6155026,0.72844032,0.8324268,0.9277889,1.0182872,1.1094736,1.1855457,1.2634786,1.3739351,1.4703945,1.5702369,1.6616211,1.7571372,1.859863,1.9364127,1.9616349,1.9091853,1.8354388,1.7708829,1.7014905,1.6535185,1.5781481,1.5289208,1.4800561,1.4711002,1.4343636,1.3822776,1.313477,1.2672011,1.2247137,1.1773716,1.1589213,1.1405218,1.139141,1.0996158,1.0300779,0.94601596,0.8853959,0.79997226,0.75953978,0.67692421,0.61859458,0.54389241,0.46308897,0.36602515,0.27947864,0.23418614,0.23837333,0.26404225,0.32317398,0.38237618,0.44110028,0.46049747,0.43365907,0.39496794,0.3214457,0.25638346,0.25221072,0.22158456,0.16853922,0.13739893,0.10330383,0.031007101,-0.042068123,-0.11625547,-0.18743285,-0.26544165,-0.33898245,-0.41842072,-0.49889157,-0.57004471,-0.62612919,-0.68238401,-0.72914929,-0.68559699,-0.66230765,-0.59129937,-0.49686401,-0.41801406,-0.31186034,-0.22841663,-0.14768955,-0.078897003,-0.018098768,-0.004457089,-0.04634764,-0.10047493,-0.17707424,-0.24708999,-0.30026475,-0.37965882,-0.43993164,-0.46696858,-0.51469417,-0.60396331,-0.69590809,-0.78365154,-0.86777051,-0.95550959,-1.0618584,-1.1493296,-1.2183894,-1.2728167,-1.3608622,-1.4394442,-1.5420394,-1.6309366,-1.7149593,-1.7835985,-1.8169891,-1.8704776,-1.7928915,-1.6860112,-1.5887827,-1.499382,-1.3999699,-1.2917274,-1.2030388,-1.1061678,-1.0094258,-0.91039309,-0.80704985,-0.71478078,-0.61808249,-0.52667656,-0.42600663,-0.32753148,-0.22892024,-0.13121216,-0.027730976,0.056832582,0.16000882,0.24842433,0.35266311,0.44650947,0.55102888,0.64553448,0.74504317,0.8475481,0.93976138,1.0432156,1.1359912,1.2365862,1.3372997,1.4269165,1.5280125,1.622464,1.7143701:5
2.4799358,2.3766687,2.2604096,2.149527,2.0524241,1.9536824,1.9165754,2.0281101,1.9372113,1.8405266,1.7334291,1.6416021,1.5409097,1.4387019,1.3337847,1.2343014,1.2909185,1.3815397,1.4745029,1.571652,1.5475182,1.4545057,1.3672337,1.247592,1.1654597,1.0556036,1.0076549,0.99099701,0.97453291,0.96630749,0.95305738,0.93987382,0.92808691,0.89726565,0.8633841,0.83339992,0.7955324,0.76114109,0.73232801,0.69731862,0.65719592,0.60739246,0.57472728,0.55531312,0.54358495,0.5366573,0.52714889,0.51077134,0.46264569,0.36408802,0.2857423,0.22193792,0.16620863,0.11946586,0.080159147,0.056384011,0.027216131,0.0080499712,-0.0035289256,-0.0069642138,0.0057101321,0.018159072,0.022086501,1.5292401E-4,-5.9156329E-4,0.012871937,0.044507487,0.075531302,0.1186294,0.098377449,0.027999888,-0.039654584,-0.093435334,-0.15637518,-0.2103424,-0.27982276,-0.36322943,-0.43615882,-0.52148136,-0.59991532,-0.71929894,-0.80266107,-0.90283356,-1.0133808,-1.1421364,-1.2362105,-1.3246409,-1.3904554,-1.4327984,-1.4471105,-1.4420849,-1.441555,-1.4383053,-1.4355882,-1.4323581,-1.4175331,-1.3969672,-1.3717518,-1.3500844,-1.3176239,-1.2784025,-1.259,-1.2367122,-1.1973176,-1.1644234,-1.0941661,-1.0156583,-0.93638263,-0.85092337,-0.75365005,-0.67294576,-0.58653557,-0.59037299,-0.68778154,-0.77893492,-0.7620819,-0.70534532,-0.61858758,-0.51900795,-0.43141001,-0.35689787,-0.24960209,-0.13519266,-0.046751242,0.072120956,0.17260827,0.26166399,0.34042505,0.2417843,0.14463477,0.041487334,-0.054325871,-0.15990714,-0.25500106,-0.35800832,-0.44512863,-0.52905124,-0.63832866,-0.73195344,-0.82528219,-0.91231168,-1.0143997,-1.107906,-1.1934755,-1.2846147,-1.3726625,-1.4576605,-1.5418157,-1.6231709,-1.703016,-1.7758547,-1.8468475,-1.8685051,-1.8423743,-1.7943173,-1.7126958,-1.6336486,-1.549318,-1.469173,-1.3852944,-1.3274013,-1.240093,-1.1579676,-1.0894921,-1.0074845,-0.91755369,-0.83957084,-0.76320079,-0.67385888,-0.60553901,-0.54033857,-0.45519024,-0.36349108,-0.28493449,-0.19642519,-0.10618998,0.0038887562,0.12065866,0.15254073,0.16259062,0.096478271,0.12736335,0.20782738,0.29864079,0.39903837,0.49607648,0.5969125,0.69352627,0.82310228,0.90047564,0.83453879,0.70877818,0.61663532,0.48942632,0.35933058,0.26738748,0.14322493,0.064492942,-0.015800256,-0.066395231,-0.054630266,0.007382309,0.072047526,0.15420987,0.24508166,0.32185948,0.42733973,0.51607095,0.60328529,0.69971799,0.77923866,0.88457951,0.97065859,1.0665156,1.1668572,1.2377835,1.2172674,1.2356122,1.3120773,1.2525776,1.180863,1.2185101,1.3186285,1.4023883,1.4979015,1.5700468,1.6691837,1.7395127,1.710929,1.6200407,1.5141233,1.4187666,1.4533319,1.3886419,1.2866819,1.1952465,1.1057386,1.0028804,0.90384215,0.80845183,0.71342817,0.62035771,0.52464512,0.4304803,0.37542258,0.35617856,0.37412191,0.46801625,0.54876583,0.65933747,0.74421322,0.83178785,0.92580337,1.0249482,1.0051695,0.9127091,0.82151363,0.72883323,0.62907245,0.5496988,0.44753173,0.36385547,0.26863258,0.18824562,0.090139924,-0.0032904924,-0.082927444,-0.16571905,-0.26586909,-0.35290125,-0.43637298,-0.51449445,-0.60119282,-0.68746776,-0.77277188,-0.84974303,-0.93575821,-1.0159129,-1.0918512,-1.1563967,-1.2280433,-1.2851799,-1.3245751,-1.3525347,-1.3487373,-1.3295749,-1.2897653,-1.2335917,-1.1730491,-1.0924122,-1.0274395,-0.95546703,-0.86554359,-0.77500717,-0.68399382,-0.56716695,-0.46164728,-0.37011676,-0.28004451,-0.22513869,-0.12944576,8.0813286E-4,0.12440721,0.21938976,0.30755897,0.39619151,0.3710939,0.30476821,0.23507468,0.17076609,0.086636116,-1.7604299E-4,-0.12640375,-0.2117284,-0.2926899,-0.34137367,-0.33296772,-0.23715545,-0.1392393,-0.067723201,-0.18183741,-0.26661525,-0.38690726,-0.46831911,-0.58694948,-0.65870615,-0.73669571,-0.81208407,-0.87826748,-0.93718544,-0.9882041,-1.0366704,-1.09041,-1.1434744,-1.1974026,-1.2341923,-1.2716814,-1.3235834,-1.3653331,-1.4031779,-1.4358415,-1.4687857,-1.5011601,-1.5232516,-1.5456069,-1.5516073,-1.5647731,-1.5615893,-1.5601182,-1.5516447,-1.5360689,-1.5115116,-1.482488,-1.4422307,-1.387039,-1.3064335,-1.2126377,-1.1296936,-0.99914765,-0.90731064,-0.82749071,-0.76173705,-0.6979848,-0.62140208,-0.54855601,-0.48367352,-0.41117324,-0.34427176,-0.27434228,-0.21629249,-0.25114802,-0.27922008,-0.28402288,-0.28471538,-0.28110808,-0.27421266,-0.2505734,-0.22079356,-0.19902903,-0.18089694,-0.16733347,-0.14419832,-0.10913531,-0.075378316,-0.023287582,0.038114107,0.09103728,0.17043294,0.28098433,0.37448881,0.50437129,0.59505531,0.71502706,0.69212465,0.67850466,0.67874155,0.69690991,0.71412896,0.74885263,0.79288819,0.84332977,0.89095027,0.92141241,0.93281824,0.95101472,0.94488319,0.93720382,0.93046189,0.91888427,0.9061634,0.93832226,1.0152655,1.0912389,1.1906883,1.2910011,1.3846548,1.4821941,1.5742511,1.670477,1.7620399,1.8638789,1.9647339,2.0635814,2.177239,2.2801031,2.375234,2.4750397:4
1.0158585,0.98042375,0.9327494,0.88017278,0.82909516,0.77865656,0.7245153,0.66404607,0.59820161,0.5315204,0.46679977,0.40639306,0.34507558,0.28866931,0.21282517,0.13625514,0.060525594,-0.016452709,-0.094569667,-0.17883414,-0.25513939,-0.33458352,-0.41566836,-0.50172241,-0.57488925,-0.64775802,-0.73311899,-0.81123044,-0.88294202,-0.97314333,-1.0632434,-1.1537287,-1.2443178,-1.3350556,-1.4447908,-1.5566851,-1.659877,-1.7194087,-1.7700783,-1.8094822,-1.8637864,-1.905313,-1.84545,-1.7637919,-1.6688874,-1.5754062,-1.4781531,-1.3981,-1.3082781,-1.2311366,-1.147694,-1.0600289,-0.98921933,-0.91677577,-0.83111952,-0.7452786,-0.67374601,-0.59586891,-0.52709047,-0.4582869,-0.39631732,-0.33873587,-0.27108696,-0.23431555,-0.21688012,-0.20725884,-0.21080175,-0.22105983,-0.23761914,-0.25690414,-0.2787776,-0.30719096,-0.33646278,-0.36791847,-0.39921388,-0.43586383,-0.4562988,-0.47180632,-0.48768171,-0.51785951,-0.53185026,-0.55753674,-0.55198609,-0.55118232,-0.52593715,-0.50752921,-0.49449807,-0.49528552,-0.50777355,-0.51175219,-0.538698,-0.57165547,-0.60106187,-0.63730076,-0.67244879,-0.70792731,-0.75080104,-0.78830922,-0.82986401,-0.87156745,-0.9081883,-0.94390673,-0.97979737,-1.0257047,-1.0508226,-0.9677886,-0.87547572,-0.79877389,-0.70104249,-0.61014282,-0.52782224,-0.44310912,-0.36796864,-0.29470673,-0.23096694,-0.16095746,-0.099618981,-0.039001918,0.017833848,0.079978421,0.13274151,0.19032455,0.23865848,0.28911206,0.34628257,0.39830889,0.45882039,0.51432246,0.57145697,0.62758913,0.66754402,0.70758626,0.73946112,0.77210402,0.79843982,0.82626731,0.82897052,0.81750738,0.77877258,0.70074328,0.65189079,0.63250323,0.70314447,0.77801423,0.86466891,0.94034693,1.0233312,1.1003805,1.1824714,1.2611005,1.3401005,1.4199692,1.4984101,1.5778865,1.6586068,1.7405001,1.8131586,1.8967517,1.9784524,2.0589886,2.1369101,2.2218081,2.2942185,2.3744487,2.4578592,2.5286439,2.5404105,2.5171357,2.4463709,2.3677613,2.2839677,2.2060184,2.1207672,2.0472069,1.9623709,1.8827946,1.8036759,1.7227215,1.639284,1.5594336,1.4824937,1.4055438,1.326179,1.2406233,1.1592548,1.0818888,1.0037065,0.92338748,0.84598418,0.76527473,0.68847595,0.68156884,0.69704316,0.71312828,0.73255158,0.72376436,0.70616881,0.69129466,0.66087785,0.61844868,0.60811403,0.59536118,0.57463188,0.56223368,0.55161553,0.53145496,0.48191702,0.43167923,0.3706338,0.29864189,0.22203915,0.14529577,0.087421266,0.039791237,0.0027270104,-0.023934772,-0.035984652,-0.068186344,-0.10401836,-0.13961428,-0.18268545,-0.23069747,-0.28023189,-0.34654787,-0.42061136,-0.49213304,-0.53388386,-0.58448737,-0.67796518,-0.77006534,-0.86232538,-0.93974668,-1.0309628,-1.0879929,-1.1416107,-1.1951997,-1.2402966,-1.2407417,-1.2940007,-1.3311429,-1.3152879,-1.3253884,-1.294034,-1.3206603,-1.3364698,-1.3151903,-1.3202352,-1.3092807,-1.2803816,-1.2691936,-1.2491211,-1.2264245,-1.1769871,-1.123936,-1.0668324,-1.0058624,-0.94065275,-0.87825987,-0.82092466,-0.77110153,-0.76731483,-0.77806871,-0.80654751,-0.81902203,-0.83042105,-0.83244451,-0.81702783,-0.79339918,-0.76028586,-0.72537439,-0.68876444,-0.64807195,-0.61274226,-0.5843941,-0.5525163,-0.5186819,-0.47638254,-0.44318352,-0.41506236,-0.3722364,-0.33914587,-0.31305526,-0.30372897,-0.29736299,-0.30481492,-0.31663471,-0.37137332,-0.41917992,-0.48085414,-0.54812914,-0.62448775,-0.70246499,-0.78192667,-0.85515485,-0.91876316,-1.0034186,-1.075491,-1.1323477,-1.2129852,-1.3074321,-1.4018231,-1.444297,-1.5372313,-1.6146613,-1.7039823,-1.7270643,-1.8040161,-1.8514622,-1.7384304,-1.7753351,-1.6882118,-1.6510256,-1.5986167,-1.5245396,-1.4115172,-1.3377025,-1.2697826,-1.2075122,-1.1318528,-1.038243,-0.98823285,-0.95572686,-0.8962455,-0.87011447,-0.80045989,-0.69067101,-0.6218991,-0.55366234,-0.46768713,-0.39502966,-0.32127498,-0.23937773,-0.15814543,-0.079027504,0.009149565,0.089648127,0.16445758,0.24674998,0.31369483,0.39375131,0.45985194,0.51572341,0.58205263,0.6417781,0.69551594,0.7420185,0.79926085,0.84293756,0.84676833,0.82587029,0.79548147,0.76072358,0.73564329,0.71122925,0.66451222,0.61298497,0.53629855,0.47175308,0.40983734,0.34898237,0.28024784,0.20743758,0.14419381,0.099746151,0.081670699,0.15447803,0.22975199,0.31037414,0.3966595,0.48043302,0.5597739,0.64372288,0.72227519,0.79256317,0.87617572,0.94849901,1.0244123,1.0960589,1.1704287,1.24719,1.323761,1.3980963,1.4677238,1.5146025,1.5452504,1.5615767,1.5472524,1.5233616,1.4753603,1.4075265,1.3406261,1.2660146,1.1932384,1.1143443,1.0479991,0.9672428,0.92581745,0.8546974,0.8045824,0.73251963,0.65390418,0.5772702,0.49284213,0.41442605,0.33955559,0.27241245,0.23216936,0.18232435,0.15064278,0.13597965,0.10496196,0.17988536,0.27805406,0.33742082,0.42346995,0.52082202,0.59957702,0.65700541,0.73006388,0.78929759,0.84011257,0.89364663,0.93237556,0.96622115,1.0025954,1.0179359,1.0281474:2
1.7417926,1.6469787,1.5474561,1.450094,1.338136,1.1939431,1.1027092,1.0117888,0.9231357,0.80188492,0.67923656,0.52961935,0.3974568,0.2663274,0.11450074,0.19730336,0.16716468,0.16502681,0.061696131,-0.057563627,-0.1538075,-0.26118361,-0.35215006,-0.4270397,-0.55002294,-0.64954066,-0.7654612,-0.89591911,-1.0232569,-1.0795181,-1.0233012,-0.97736582,-0.91288973,-0.82702979,-0.75750942,-0.74267637,-0.80893657,-0.92913009,-0.97568218,-1.0311181,-1.0305248,-1.085391,-1.1910114,-1.2983302,-1.3896616,-1.4605626,-1.5224409,-1.6001348,-1.7072857,-1.850402,-1.9446919,-2.0611196,-2.1417308,-2.1619342,-2.1916378,-2.2209182,-2.1877863,-2.2756433,-2.2968849,-2.330312,-2.3986874,-2.4654175,-2.5691202,-2.6777645,-2.7357264,-2.6867637,-2.5570346,-2.4178631,-2.309445,-2.1659068,-2.0549238,-1.9267857,-1.7974941,-1.6609817,-1.551612,-1.4203166,-1.2907868,-1.1716872,-1.0561924,-0.92929313,-0.80040349,-0.6691438,-0.61843361,-0.57258776,-0.59332302,-0.54711674,-0.43654933,-0.30371159,-0.19213772,-0.052217092,0.054165716,0.16855588,0.29411369,0.42561971,0.47130857,0.56083261,0.67508332,0.81104187,0.94749358,1.0646292,1.2016047,1.3118723,1.4277389,1.5732178,1.600329,1.5736867,1.4916492,1.3785871,1.2816477,1.1787186,1.1578957,1.0574093,0.95546231,0.83513839,0.79703888,0.7511077,0.6796495,0.6747294,0.64299604,0.68666753,0.71191412,0.70357592,0.63009027,0.54620693,0.46217361,0.44025142,0.40236336,0.31989258,0.24996009,0.24479781,0.3131108,0.43701749,0.55236165,0.58953838,0.61354283,0.61836944,0.58851309,0.56123082,0.50253252,0.45911355,0.42216429,0.37807209,0.35970582,0.39690163,0.37420998,0.33118726,0.27410755,0.20969464,0.18515658,0.13475191,0.075163552,0.05213148,6.8038792E-4,-0.040240197,0.04050465,-0.0037031023,0.12738832,0.1966042,0.35670937,0.47313401,0.60245388,0.73653814,0.83524059,0.95595283,1.0132173,1.0228106,1.048668,1.0487948,1.008465,0.9987185,0.97823169,0.96340358,0.87491425,0.80186246,0.79697838,0.80521119,0.93264736,0.99586971,0.96006169,0.88182409,0.80771377,0.72377575,0.65904828,0.65172858,0.59443767,0.51934664,0.44119018,0.44644584,0.54448319,0.62520647,0.68600104,0.69368623,0.64771537,0.60487313,0.59819408,0.53709256,0.60397501,0.61696637,0.59259842,0.56459055,0.50721314,0.47809533,0.50676985,0.50701596,0.40724816,0.31144089,0.21239876,0.17882488,0.06683598,-0.020268851,-0.13173576,-0.23660405,-0.33945671,-0.44272866,-0.52401197,-0.59928758,-0.68682763,-0.80942243,-0.82147922,-0.73229667,-0.65390763,-0.59317759,-0.52236414,-0.45709207,-0.38335662,-0.31284834,-0.31710576,-0.32536149,-0.21394303,-0.083705571,0.038034489,0.16028551,0.28328311,0.37787943,0.43616527,0.42198574,0.4760434,0.55668842,0.59772129,0.64092102,0.68049516,0.6561292,0.55232715,0.37756299,0.41128322,0.49498769,0.55744208,0.64716445,0.71047418,0.77141833,0.82338238,0.8362636,0.82523407,0.75394475,0.58895403,0.56182382,0.57857212,0.64101647,0.70193418,0.71048198,0.72836662,0.73860065,0.69677383,0.6359711,0.67468997,0.66374279,0.68765926,0.63124504,0.66162514,0.67406634,0.66245078,0.55504478,0.43379656,0.31644774,0.17771406,0.059841436,-0.072647282,-0.19843864,-0.33055358,-0.32049178,-0.28778688,-0.25410373,-0.21175869,-0.17345932,-0.14934981,-0.1102638,-0.019903486,-0.030070321,0.013901965,0.053916667,0.1284118,0.16029433,0.1155688,-0.022672696,-0.060334067,0.0092002393,0.054435071,0.13598255,0.20382669,0.24171127,0.33385608,0.37708605,0.43580175,0.47741159,0.52062118,0.57227658,0.59416107,0.52345463,0.41367351,0.2888168,0.16719558,0.13672061,0.20569087,0.2867638,0.35216991,0.45091913,0.51047284,0.46359998,0.54203818,0.61912784,0.68313771,0.75857191,0.82052903,0.8039116,0.7211303,0.81412983,0.89791058,1.0127915,1.0695838,1.0895743,1.1688052,1.2416926,1.3228468,1.4059312,1.4691993,1.5338525,1.5889906,1.5778729,1.4819837,1.3069749,1.1781517,1.0491599,0.91984788,0.78852283,0.66562936,0.50847189,0.36088889,0.2332615,0.056225573,-0.071619453,-0.24906465,-0.27927177,-0.32387699,-0.41634211,-0.59141476,-0.72034535,-0.87060376,-1.0215179,-1.1484276,-1.2647078,-1.3307102,-1.3848644,-1.5009492,-1.6231839,-1.7984326,-1.9584198,-2.0904494,-2.2099554,-2.3277225,-2.2889553,-2.2362861,-2.1701029,-2.113266,-2.0182869,-1.9357684,-1.8920749,-1.8328103,-1.7271816,-1.6062965,-1.510335,-1.4058289,-1.2945919,-1.1868719,-1.2169129,-1.2626088,-1.3103612,-1.2057591,-1.0867635,-0.95596471,-0.84706455,-0.72465817,-0.73914311,-0.64923562,-0.51225383,-0.39493326,-0.26053303,-0.14937703,-0.13115436,-0.22069343,-0.33459325,-0.40370534,-0.50904207,-0.60826676,-0.54563141,-0.44556994,-0.30019066,-0.15225688,-0.11843159,-0.034339337,0.053406723,0.17932117,0.3428721,0.40130226,0.41119467,0.44142125,0.51651081,0.63119856,0.78724447,0.87193498,0.96611399,1.1070982,1.2055303,1.3516403,1.4911946,1.6591171,1.7748738,1.8152332:3
0.19240006,0.19506391,0.1831643,0.18510797,0.16875649,0.20287874,0.2203002,0.22647353,0.24108325,0.26277361,0.29579937,0.30061618,0.2964857,0.29443297,0.31109488,0.33446302,0.3526836,0.37278888,0.4047555,0.45032068,0.49880153,0.55152465,0.59257761,0.6297455,0.68308318,0.74801176,0.8016155,0.84039909,0.89632325,0.97035811,1.0190576,1.0758803,1.1280936,1.1836296,1.2153342,1.2633025,1.3010593,1.3459816,1.3787757,1.4194727,1.4605012,1.4964815,1.5286241,1.5538071,1.5715081,1.6024295,1.6709745,1.7512066,1.8451225,1.9393918,2.0233854,2.1064105,2.2128325,2.2398202,2.1910122,2.1048731,2.0165115,1.9162167,1.8334289,1.7565406,1.6699795,1.594199,1.5433762,1.4460942,1.3721749,1.3037022,1.2473992,1.1939595,1.1507673,1.1119253,1.0808879,1.0444245,1.022916,1.0018385,0.98506322,0.97372853,0.97269052,0.9668717,0.95247222,0.94182697,0.92727701,0.90627421,0.88484281,0.85817806,0.87938589,0.93921427,0.99156046,0.9897697,0.97694761,0.9768244,0.9777684,0.96054529,0.92435404,0.87310837,0.84291279,0.81049639,0.76363845,0.73023483,0.70322475,0.68098888,0.64746747,0.59391766,0.52526784,0.44796735,0.35372033,0.28125274,0.20536802,0.1456542,0.10862858,0.067000393,0.034361024,0.0035760245,-0.03549367,-0.064052626,-0.088568132,-0.10814829,-0.12577166,-0.14623106,-0.16129913,-0.17906565,-0.18692482,-0.19275672,-0.19005579,-0.19251611,-0.25749148,-0.35221933,-0.44615243,-0.52045459,-0.61429171,-0.70756178,-0.78490113,-0.85140525,-0.92568441,-0.99750414,-1.0841802,-1.1609842,-1.2357252,-1.2942846,-1.3445357,-1.3781609,-1.4018077,-1.4290046,-1.4417849,-1.4455159,-1.4458962,-1.4269554,-1.410075,-1.3910631,-1.3522688,-1.3131581,-1.266852,-1.2216353,-1.1806097,-1.1431443,-1.1008367,-1.0570435,-1.0173117,-0.9644521,-0.90403854,-0.84655725,-0.78473646,-0.72266394,-0.71505175,-0.67322673,-0.6199167,-0.55267668,-0.4904814,-0.41991707,-0.34394393,-0.27084465,-0.203659,-0.121233,-0.049900015,0.0030019049,-0.076866094,-0.14761945,-0.22328814,-0.3032256,-0.38678043,-0.47366901,-0.55842776,-0.66310539,-0.74881296,-0.85487355,-0.94417423,-1.0455616,-1.1493318,-1.2387739,-1.2988929,-1.3465705,-1.3771409,-1.3759366,-1.3550506,-1.3028947,-1.2467075,-1.1741852,-1.109042,-1.0360746,-0.97290288,-0.8975135,-0.82632191,-0.77856431,-0.74337651,-0.66245883,-0.59276267,-0.51397757,-0.44077046,-0.37452621,-0.28893694,-0.21215118,-0.14072517,-0.070701784,0.018126356,0.085533782,0.16139531,0.23880771,0.3140188,0.3959412,0.46645367,0.54611066,0.6225693,0.69987274,0.77046425,0.82583942,0.87770836,0.96188364,0.95436186,0.88806892,0.82217774,0.77964583,0.70234129,0.63441639,0.57514541,0.54005735,0.54928032,0.62286347,0.7067944,0.7890913,0.87284493,0.95754102,1.0393843,1.1235225,1.2024497,1.2894312,1.3755703,1.4664724,1.5234986,1.5769019,1.6497023,1.6565655,1.7077979,1.7647653,1.8222464,1.8896768,1.8761971,1.796956,1.7272912,1.6408929,1.5444388,1.4569666,1.3879327,1.2963271,1.2260956,1.1537698,1.0797686,1.0036972,0.96032837,0.97281958,1.0175714,1.0701835,1.1522978,1.2298058,1.2977748,1.2458968,1.1672267,1.0950202,1.0121121,0.94060765,0.84914972,0.7630788,0.69144265,0.60725436,0.52091808,0.43466054,0.34569117,0.27819721,0.19090328,0.11205414,0.039473038,-0.037020822,-0.10549324,-0.17766217,-0.25188251,-0.32339716,-0.40495241,-0.47605806,-0.54668421,-0.62827417,-0.70170718,-0.76022064,-0.77410367,-0.76814247,-0.74160256,-0.70536273,-0.66619669,-0.61019138,-0.55045568,-0.49101343,-0.42981136,-0.37118751,-0.30713177,-0.24288842,-0.17947188,-0.10327772,-0.0081169242,0.076610125,0.18291263,0.21660955,0.1375806,0.033625587,-0.048068419,-0.10770229,-0.1900066,-0.27036549,-0.29103374,-0.32763975,-0.41695352,-0.48264821,-0.57900129,-0.68399439,-0.78938675,-0.89249014,-0.97075844,-1.0723563,-1.1704864,-1.2212736,-1.3042775,-1.3968351,-1.462546,-1.5590384,-1.631242,-1.722959,-1.792977,-1.854145,-1.9041489,-1.9462201,-1.9660737,-1.9767091,-1.9763767,-1.9677155,-1.9408544,-1.8907892,-1.7952995,-1.709468,-1.6386165,-1.5644183,-1.4939178,-1.430407,-1.3549001,-1.2833166,-1.2118254,-1.1430086,-1.075206,-1.0076742,-1.0164433,-0.92607686,-0.86089531,-0.78477673,-0.71879808,-0.65465401,-0.57968291,-0.51540633,-0.43994413,-0.3682284,-0.29803981,-0.34162911,-0.40737808,-0.47755761,-0.53789237,-0.60533992,-0.66011546,-0.71615014,-0.75316882,-0.77903992,-0.80407141,-0.79348759,-0.73547022,-0.7126709,-0.76479155,-0.8055884,-0.85274634,-0.89224307,-0.92470255,-0.95775029,-0.97854326,-1.0045037,-1.0253891,-1.0495034,-1.0614893,-1.0566042,-1.0459848,-1.0474485,-1.0426576,-1.0488195,-1.0239051,-0.99173342,-0.94746263,-0.88802128,-0.83632009,-0.76968077,-0.69607288,-0.62876555,-0.54547779,-0.46198492,-0.37351161,-0.28783195,-0.23310982,-0.1887373,-0.13319085,-0.078283574,-0.036704642,0.010277292,0.053656637,0.090420252,0.12324964,0.1519164,0.17571619:4
1.1730246,1.0858535,1.0017523,0.91480359,0.82937236,0.73793479,0.6553053,0.57160046,0.48407666,0.39256525,0.30600007,0.22291729,0.22284871,0.1676975,0.078224545,-0.009070105,-0.094219011,-0.18242182,-0.26896022,-0.32029949,-0.32749017,-0.40978025,-0.4965756,-0.5573878,-0.64577085,-0.72187168,-0.80905729,-0.89575867,-0.94154514,-0.96715501,-1.0441461,-1.1300854,-1.2093726,-1.3019156,-1.384748,-1.4753278,-1.5556389,-1.6430892,-1.7257773,-1.7829504,-1.8745064,-1.9525768,-1.9914234,-1.9626791,-1.8921456,-1.8138476,-1.7732739,-1.6810284,-1.6065117,-1.5141467,-1.4227872,-1.3263439,-1.2297563,-1.1373611,-1.0462417,-0.94387767,-0.84891798,-0.75846246,-0.66413686,-0.56996405,-0.47106652,-0.37603914,-0.28424312,-0.20008197,-0.11900836,-0.060930582,-0.049864067,0.03180698,0.096305358,0.16510554,0.19356206,0.25017602,0.34787714,0.38054634,0.45880763,0.51037229,0.55294008,0.47009612,0.38189158,0.31541341,0.32990265,0.42681006,0.45408497,0.53717811,0.52493896,0.51872484,0.5639903,0.62302453,0.6971323,0.78745835,0.85755914,0.92757792,1.0037742,1.0778711,1.1800996,1.2841655,1.3877036,1.4771254,1.5533811,1.6404881,1.705536,1.8054754,1.8984264,2.0033822,2.0945871,2.1995383,2.2797361,2.2183687,2.1229596,2.0122263,1.8988081,1.7952839,1.7300775,1.6317957,1.5810993,1.5069668,1.416622,1.3550272,1.3068628,1.3202112,1.2148005,1.2005614,1.1250549,1.0535467,1.017305,0.92443381,0.90264658,0.88850462,0.81459175,0.76432015,0.67668204,0.64815967,0.65570283,0.65223234,0.64053173,0.55228374,0.52068422,0.45217749,0.38484946,0.39339344,0.31159164,0.24474697,0.18761844,0.11004851,0.09253362,0.0070795432,-0.041750895,0.015429144,0.070084764,0.12263129,0.19197002,0.25792535,0.3246237,0.42804745,0.51798504,0.50208982,0.4272879,0.35583137,0.26743867,0.2568643,0.17703843,0.11149887,0.11341501,0.032092569,-0.050531605,-0.036520052,-0.055358869,-0.12775441,-0.1799924,-0.24908053,-0.30310322,-0.37050249,-0.40413569,-0.45099815,-0.53940536,-0.60425977,-0.67010579,-0.74931084,-0.80717217,-0.92627885,-0.94491688,-1.0450165,-1.1441141,-1.2373076,-1.2707464,-1.348921,-1.4152817,-1.4998277,-1.5451158,-1.616253,-1.7027402,-1.7793164,-1.8504521,-1.9249086,-1.9673429,-1.9839372,-2.0648385,-2.0974764,-2.0214746,-1.9871662,-1.904043,-1.8190259,-1.7266162,-1.6536695,-1.5741341,-1.490979,-1.4149813,-1.3348516,-1.2758479,-1.2125743,-1.1380295,-1.0417025,-1.0718778,-1.1456124,-1.2256182,-1.2953522,-1.3636484,-1.4229142,-1.4626986,-1.4605979,-1.4358438,-1.4229267,-1.3656856,-1.2970874,-1.2166346,-1.137364,-1.0548365,-0.97596367,-0.89465891,-0.81441075,-0.72974422,-0.66885611,-0.58490425,-0.50477895,-0.48337686,-0.45786074,-0.37881508,-0.29568363,-0.21278035,-0.12775659,-0.041171613,0.043048557,0.12287789,0.18393531,0.23060908,0.31570555,0.37466505,0.45724677,0.52326512,0.60692716,0.62964081,0.71882218,0.80020042,0.88666552,0.95064283,1.0361828,1.1187988,1.1979151,1.2836957,1.363814,1.4486859,1.5316825,1.6188124,1.6114825,1.5364358,1.4521496,1.3758964,1.3000347,1.2763801,1.2865265,1.2094375,1.1579552,1.1460306,1.1296731,1.0612646,1.0315081,1.0528696,1.003654,0.97669387,0.92523548,0.91220977,0.83464178,0.86187743,0.90667957,0.87701562,0.7997965,0.69926938,0.6420956,0.5554082,0.48659782,0.40011873,0.30448217,0.23220639,0.15385507,0.083503062,0.004815067,-0.064376369,-0.14029018,-0.21722921,-0.29553912,-0.36799491,-0.44825372,-0.50372937,-0.57164845,-0.64745612,-0.72475599,-0.77075253,-0.81480137,-0.85295809,-0.84621927,-0.90213368,-0.902641,-0.88021119,-0.86424764,-0.82767635,-0.78683458,-0.7077072,-0.6283385,-0.53888371,-0.47734692,-0.44374845,-0.36492732,-0.27792004,-0.19658094,-0.11064055,-0.028461452,0.054424129,0.13917731,0.22053336,0.30149845,0.39078782,0.46143506,0.46638006,0.54580393,0.63197447,0.7175851,0.80756918,0.88604309,0.97149439,1.0583973,1.1384434,1.2216439,1.3091652,1.389015,1.4314894,1.4325028,1.46184,1.4689664,1.445432,1.3684754,1.2839977,1.216098,1.1836095,1.2102472,1.1745046,1.0954222,1.0296663,0.95177117,0.86480812,0.77929202,0.69844469,0.61730706,0.52965705,0.44271642,0.36088331,0.2753382,0.19236436,0.1070851,0.025925378,-0.040751441,-0.11927272,-0.20513008,-0.2876954,-0.37710472,-0.41477734,-0.47258239,-0.55809745,-0.64080587,-0.72644091,-0.79515982,-0.85656016,-0.89780207,-0.98017761,-0.99208281,-0.99545855,-1.067613,-1.0687826,-1.0844912,-1.106134,-1.0566295,-1.0931679,-1.0418005,-1.0507117,-1.0313797,-0.99899353,-0.94899949,-0.88498261,-0.82092649,-0.80072537,-0.77166834,-0.71171289,-0.65650486,-0.59330617,-0.5147039,-0.44149686,-0.38166241,-0.31900959,-0.25210261,-0.17217409,-0.1102461,-0.031216806,0.038075021,0.1102683,0.18860789,0.26475094,0.33832728,0.42591104,0.5066535,0.58707874,0.67534517,0.75670274,0.83367522,0.89021843,0.96778118,0.98544178,1.0616647,1.1317625:6
2.4193918,2.3280025,2.2712024,2.2104114,2.1298861,2.0455656,1.9745082,1.8991826,1.8301552,1.7541497,1.67896,1.6056914,1.5354708,1.4625592,1.3803189,1.3090406,1.2360024,1.1490792,1.0661969,0.98164842,0.8972805,0.82322453,0.75665169,0.69713967,0.62676763,0.58636443,0.56289273,0.55655015,0.5462554,0.5466386,0.53802952,0.52700099,0.52450798,0.52131581,0.51225539,0.50714347,0.49621137,0.4834686,0.48060034,0.46043084,0.43796543,0.40404973,0.37353856,0.33530581,0.27137286,0.19955627,0.13171815,0.051353387,-0.040718184,-0.12814027,-0.20011419,-0.23304694,-0.23931335,-0.23048256,-0.22478551,-0.21702435,-0.21008214,-0.21734414,-0.21725604,-0.22326981,-0.22739609,-0.23423632,-0.24197951,-0.27519006,-0.29749387,-0.28490956,-0.27444744,-0.33535489,-0.41513332,-0.49329705,-0.58874674,-0.66718656,-0.75226989,-0.83585572,-0.89935638,-0.9614774,-1.0217246,-1.0706348,-1.0864264,-1.0899554,-1.0949888,-1.0886071,-1.0847864,-1.0717931,-1.0588346,-1.0444254,-1.0290843,-1.0126135,-0.99513138,-0.97629375,-0.94982874,-0.91129881,-0.8630406,-0.82644267,-0.76801686,-0.71407318,-0.64816526,-0.60101928,-0.54083528,-0.55697709,-0.61991836,-0.70389293,-0.78579433,-0.85231105,-0.9320213,-1.0390661,-1.1181811,-1.1918321,-1.2585473,-1.2927941,-1.3228546,-1.3458421,-1.3721856,-1.3857897,-1.3829081,-1.372912,-1.3521763,-1.3252414,-1.2711929,-1.2117077,-1.1446966,-1.07388,-1.0002985,-0.92083593,-0.83959308,-0.75389658,-0.66287152,-0.59236451,-0.57704089,-0.53913738,-0.46200329,-0.37436558,-0.27612327,-0.20098267,-0.2370579,-0.31217001,-0.38371234,-0.45841878,-0.54087284,-0.62316041,-0.69901438,-0.76721251,-0.83903282,-0.90780489,-0.97786725,-1.0367689,-1.1072376,-1.1585631,-1.2177965,-1.2679083,-1.3082805,-1.3404239,-1.3214704,-1.2785414,-1.2112289,-1.1390103,-1.065171,-0.9903928,-0.91577324,-0.84035061,-0.76360841,-0.68637396,-0.57907398,-0.49740049,-0.40574679,-0.31895577,-0.2383836,-0.15995405,-0.080210986,0.011872649,0.10546423,0.18449125,0.29218396,0.37209428,0.44510924,0.41143371,0.4827549,0.56698756,0.65407002,0.76251496,0.8700708,0.80308417,0.74008799,0.66428579,0.60830821,0.55365105,0.50883781,0.46563303,0.45181075,0.493243,0.55194714,0.62729792,0.6919651,0.77721989,0.84802883,0.91982357,0.98686961,1.0634532,1.1257068,1.2039415,1.2712319,1.3560155,1.4422849,1.5272343,1.5571953,1.5756568,1.6520403,1.7225806,1.8077402,1.8947109,1.9722663,2.0602423,2.1653803,2.2295308,2.1735652,2.1016988,2.0481238,1.974871,1.8844392,1.8251789,1.7332786,1.64948,1.5504778,1.4456282,1.3648804,1.2854015,1.1824293,1.1344562,1.1455652,1.200475,1.2179998,1.2405429,1.1575674,1.0719215,0.99384682,0.88932353,0.80408102,0.72370641,0.64085862,0.54900003,0.45644068,0.37696294,0.27639887,0.20198463,0.11046471,0.019784248,-0.059090082,-0.14024426,-0.22117041,-0.31601172,-0.39102035,-0.4733955,-0.57499371,-0.60202743,-0.56153153,-0.49807747,-0.43903386,-0.3852327,-0.30868687,-0.23893546,-0.16966015,-0.097288388,-0.013111862,0.055230324,0.13372529,0.21687456,0.28963168,0.36103064,0.44158895,0.42395412,0.33909789,0.26025066,0.18202384,0.10966691,0.034311508,-0.040479127,-0.10785018,-0.18174691,-0.23740153,-0.27730871,-0.34960092,-0.42628667,-0.50009508,-0.57745313,-0.64884605,-0.71342309,-0.77955216,-0.84693485,-0.91191213,-0.97803094,-1.0437376,-1.111576,-1.1787955,-1.2389838,-1.298683,-1.3462097,-1.3944321,-1.4391811,-1.4636884,-1.465062,-1.4458327,-1.4171084,-1.3732688,-1.3031789,-1.2255754,-1.1471021,-1.0650326,-0.96024679,-0.85205173,-0.77303572,-0.70895242,-0.61567445,-0.53596455,-0.51197081,-0.58676574,-0.6410478,-0.69995154,-0.75808,-0.80717446,-0.84490392,-0.86598551,-0.84851,-0.89120513,-0.93510064,-0.98829961,-1.0297253,-1.0719348,-1.1073958,-1.1420286,-1.1731844,-1.204892,-1.2254217,-1.2591683,-1.2783004,-1.2919712,-1.3089553,-1.321386,-1.3374735,-1.3411516,-1.3354761,-1.3203485,-1.2957212,-1.2781065,-1.2389459,-1.1908956,-1.1328349,-1.0614552,-0.96490943,-0.89487232,-0.81795774,-0.74320396,-0.66131223,-0.60070406,-0.52648161,-0.45311893,-0.39327366,-0.31993444,-0.32948837,-0.33430458,-0.32595369,-0.31735456,-0.30491192,-0.28270543,-0.22560366,-0.15763838,-0.16032462,-0.15801081,-0.15399945,-0.15403238,-0.14887824,-0.14148051,-0.13838365,-0.12798033,-0.11040154,-0.07933031,-0.050201356,-0.014715648,0.0203459,0.04359921,0.084169137,0.11280371,0.14787317,0.18112627,0.2141746,0.24711471,0.28154158,0.30517965,0.33678393,0.3656467,0.39218719,0.41972403,0.4411743,0.45690803,0.47475928,0.49836216,0.52917845,0.568249,0.61338485,0.67904604,0.73756035,0.646331,0.55252858,0.59666204,0.68247167,0.76692739,0.83020986,0.908748,0.99262975,1.0803263,1.1625154,1.2472945,1.3119153,1.3938113,1.4758115,1.5416496,1.6189833,1.6893404,1.7656678,1.8421194,1.9132761,1.9741866,2.0559352,2.12481,2.1851304,2.2646505,2.3324624,2.4012842:4
1.6311847,1.585915,1.5056882,1.4151726,1.382279,1.2598386,1.2784995,1.1848444,1.0861143,1.0056303,1.0274965,0.94317381,0.86169422,0.74407739,0.66275575,0.53998592,0.47700517,0.45034413,0.45904698,0.40965044,0.29704872,0.19216872,0.096020003,0.033744126,-0.051023815,-0.14286571,-0.26039774,-0.32550198,-0.43547453,-0.52460045,-0.67043756,-0.77075871,-0.71773184,-0.58926718,-0.45181571,-0.30585705,-0.17217639,-0.031906959,0.092664966,0.23224773,0.36373494,0.49334004,0.48361109,0.62855985,0.75722204,0.91135664,1.0357105,1.1779945,1.3308537,1.4877143,1.4917975,1.4554386,1.3372085,1.2352959,1.1323602,1.0543872,0.94303385,0.8833935,0.79267543,0.68844383,0.59189466,0.51146062,0.39959694,0.30789838,0.22103472,0.14523252,0.067977426,0.016752409,-0.053817479,-0.066419299,-0.12349381,-0.16291182,-0.2527028,-0.32326624,-0.3460563,-0.37369271,-0.4368058,-0.49580325,-0.58430794,-0.66081437,-0.6664309,-0.55486016,-0.3826657,-0.19163427,-0.092609918,0.068528466,0.24024812,0.35302973,0.4780508,0.55714458,0.54662014,0.4831652,0.37168098,0.25954371,0.22434873,0.14000826,0.09896137,0.17434955,0.18083538,0.18226119,0.14420429,0.1002955,0.038305561,-0.0034347294,-0.053308228,-0.09211928,-0.16128725,-0.22994571,-0.30951781,-0.20182939,-0.10591279,0.035812733,0.18212775,0.21594716,0.2440895,0.2472391,0.24056881,0.21960761,0.16909169,0.094817702,0.083301561,0.031711937,-0.026402048,-0.05541515,-0.12301669,-0.18020443,-0.19252912,-0.26379093,-0.34388147,-0.39873336,-0.56777309,-0.63784445,-0.7504198,-0.86088673,-0.95255514,-1.0619991,-1.224405,-1.3113876,-1.4617318,-1.6067041,-1.7588478,-1.8997362,-2.0428115,-2.1944786,-2.3306835,-2.4710615,-2.4235443,-2.3827826,-2.2280824,-2.0760209,-1.9313936,-1.7919054,-1.6200173,-1.4734232,-1.3191259,-1.1519014,-0.98928593,-0.8545901,-0.73902289,-0.65418519,-0.53297207,-0.3595889,-0.22096938,-0.051763603,0.099686407,0.23781464,0.38563975,0.53233701,0.70717365,0.84751889,0.99401372,1.1494382,1.3020779,1.4415085,1.5747689,1.733838,1.8758292,2.0380357,2.1730196,2.3333588,2.4640266,2.5870824,2.6435082,2.5784373,2.4556281,2.3153078,2.1694981,2.0027924,1.8338447,1.6907277,1.5181033,1.371523,1.2256098,1.0679552,0.91222613,0.76865804,0.61184469,0.5662982,0.44661396,0.26852796,0.12999489,-0.020954578,-0.18805288,-0.3267914,-0.49962285,-0.64114161,-0.78988828,-0.96089518,-1.099798,-1.2631518,-1.4053571,-1.5619901,-1.7252257,-1.8640916,-2.0416684,-2.1814614,-2.3307686,-2.4801738,-2.6264864,-2.7082306,-2.5922484,-2.4532438,-2.2981296,-2.2868316,-2.1044911,-1.9148469,-1.7762517,-1.6365777,-1.5193534,-1.407905,-1.301501,-1.2448173,-1.1682238,-1.1464362,-1.0626314,-0.97084316,-0.87456294,-0.86938726,-0.87557991,-0.8466737,-0.78373558,-0.73145683,-0.65571333,-0.62984589,-0.58114609,-0.58628827,-0.66458535,-0.82167179,-0.97718683,-1.1348806,-1.2751972,-1.3862743,-1.3691119,-1.3297192,-1.2241303,-1.1177554,-1.0714014,-1.0770533,-1.0294108,-1.0556025,-1.0055109,-0.95420638,-0.83531339,-0.72290464,-0.62794239,-0.56477284,-0.44856593,-0.46454969,-0.3628628,-0.28032617,-0.31404911,-0.23257056,-0.1621657,-0.072422483,-0.025832977,-0.003144014,-0.14845148,-0.29968386,-0.33298534,-0.46312381,-0.59964262,-0.75276963,-0.87831994,-0.88705153,-0.77753518,-0.6580639,-0.51648575,-0.40572396,-0.33980029,-0.25139752,-0.17449952,-0.13665079,-0.037739011,0.055032265,0.15482084,0.21880383,0.24591483,0.31066234,0.3968382,0.48382645,0.534464,0.61918261,0.74123214,0.81459149,0.90245221,1.0270436,1.1452628,1.2381442,1.3136307,1.3869174,1.3601028,1.2392585,1.0815472,0.94064075,0.88392862,0.73718679,0.58289438,0.44606467,0.27727022,0.2593877,0.12149924,-0.019172572,-0.14146911,-0.27212552,-0.42269725,-0.5610283,-0.61004087,-0.67831114,-0.6625766,-0.58203507,-0.48829747,-0.39482344,-0.30970648,-0.21359516,-0.12928458,-0.070157109,0.028741165,0.12211808,0.23158113,0.11497256,0.037122526,0.11719631,0.28520599,0.33120851,0.44401139,0.5783038,0.6873781,0.80548075,0.82510964,0.89297948,1.0225956,1.1420916,1.2672846,1.3984065,1.5059764,1.5233013,1.3587288,1.2055652,1.0226418,0.85351719,0.75378881,0.61685049,0.50503349,0.34744076,0.30080539,0.13221373,0.010166659,-0.15323696,-0.28246708,-0.40980446,-0.56278487,-0.63355193,-0.7507074,-0.7020847,-0.57188788,-0.44319552,-0.29981291,-0.1694913,-0.029853568,0.053343692,0.18558058,0.33139712,0.46434827,0.42295778,0.51332768,0.6667608,0.76328429,0.67421124,0.81847719,0.93998398,0.8416608,0.91565548,0.78106416,0.84587103,0.71719325,0.58343474,0.46631382,0.55807016,0.46495284,0.45218045,0.33726356,0.22730956,0.11054283,-0.018301684,-0.13032305,-0.25516063,-0.36651038,-0.47625073,-0.60013787,-0.67014818,-0.4867292,-0.29758576,-0.099317419,0.089387086,0.21285056,0.36092155,0.42896402,0.41907873,0.57107714,0.72366333,0.82570927,1.0280969,1.1716615,1.2510933,1.4539305,1.5693311,1.6757148:1
0.39467362,0.31990008,0.33317518,0.2194022,0.066848122,-0.043414881,-0.14964345,-0.22163603,-0.29521073,-0.37079343,-0.44056787,-0.51212312,-0.57950457,-0.64277755,-0.69771731,-0.7467548,-0.79276094,-0.84067265,-0.88860304,-0.94169431,-0.98430107,-1.0223711,-1.0567793,-1.088693,-1.1228478,-1.1455204,-1.1516121,-1.1669028,-1.1770272,-1.1773565,-1.1846612,-1.1901676,-1.1876798,-1.1826772,-1.1602612,-1.1337102,-1.1016126,-1.0533117,-1.0155733,-0.95349323,-0.86562697,-0.82634192,-0.72928173,-0.62926616,-0.49886675,-0.36898854,-0.25584134,-0.16278677,-0.048948247,0.055749916,0.15233791,0.25478271,0.35292543,0.45504919,0.55903007,0.65027789,0.76910286,0.85417203,0.94804663,1.0476848,1.1250264,1.1149565,1.0742151,1.0357642,0.97160639,0.93161347,0.91094134,0.90649206,0.91946324,0.94221759,0.95844046,0.97469373,1.0076591,1.0231177,1.0322637,1.0555351,1.0719914,1.0887501,1.1101732,1.1258634,1.1503298,1.1727852,1.1954328,1.2162216,1.2421701,1.2667631,1.2870857,1.3256511,1.3580166,1.3912652,1.415376,1.4373771,1.4555817,1.4695477,1.465281,1.448493,1.4204394,1.3737057,1.3325098,1.2876344,1.2237298,1.1633199,1.0859306,1.0215848,0.97933587,1.0050422,1.1011309,1.1916293,1.3108352,1.4185793,1.5213982,1.6428959,1.7611844,1.6937821,1.5640803,1.4538304,1.3145453,1.2162702,1.0894325,1.102156,1.0946047,0.97899513,0.83137213,0.76246975,0.81117839,0.88297474,0.96121639,1.0201348,1.0765172,1.113521,1.1476565,1.1529912,1.1661174,1.163555,1.1675815,1.1583227,1.1525845,1.1377589,1.1218075,1.1137467,1.0924341,1.0877672,1.0684749,1.0513685,1.0321862,1.0049806,0.98687418,0.9688085,0.94081856,0.92614485,0.91145883,0.91583717,0.91733986,0.92293131,0.93801138,0.89806672,0.77797511,0.67485935,0.56752187,0.461964,0.35824207,0.27196421,0.16614594,0.091372107,0.0012608134,-0.082590244,-0.15785392,-0.22754799,-0.29574172,-0.3457554,-0.37159293,-0.40281526,-0.42873753,-0.45892723,-0.46064377,-0.47080926,-0.47481106,-0.46560428,-0.45215856,-0.44502594,-0.41797085,-0.39409259,-0.35668047,-0.3083422,-0.25637996,-0.21305648,-0.18138018,-0.15259189,-0.11490771,-0.084416433,-0.13043534,-0.20849742,-0.2770726,-0.35073972,-0.42725495,-0.50845299,-0.59432969,-0.66913652,-0.76223588,-0.84685972,-0.92461893,-0.99667129,-1.098264,-1.1762327,-1.2577979,-1.3440703,-1.4492315,-1.551482,-1.6735226,-1.7657885,-1.8599394,-1.9337833,-1.9899016,-2.0357491,-2.085554,-2.1242579,-2.1452427,-2.1369935,-2.099298,-2.0605359,-2.0143286,-1.9596295,-1.8909305,-1.8294835,-1.7550331,-1.6826992,-1.5943502,-1.5106399,-1.4363701,-1.3330725,-1.2389246,-1.1307797,-1.0272724,-0.93886147,-0.82678965,-0.70750714,-0.61246765,-0.50243554,-0.39342336,-0.27588557,-0.16913032,-0.05237428,0.072006462,0.18137532,0.30140621,0.3980624,0.51407179,0.62862251,0.72678705,0.85590352,0.94418846,1.0319191,0.94022198,0.83809562,0.73114267,0.62799523,0.52900427,0.41443937,0.31667104,0.22099344,0.1143592,0.00572806,-0.10359923,-0.21144147,-0.32119093,-0.42389914,-0.52997842,-0.64109503,-0.72960905,-0.83199092,-0.93853236,-1.0425382,-1.1309481,-1.2302758,-1.3193549,-1.4016341,-1.4748729,-1.5432679,-1.5822075,-1.5650268,-1.5332069,-1.4879132,-1.421834,-1.3336146,-1.2343914,-1.1294347,-1.0229409,-0.91538046,-0.80727572,-0.6991555,-0.59101125,-0.48208958,-0.37264119,-0.29064691,-0.19084577,-0.091966742,-0.0067146826,0.10603357,0.21593724,0.29671181,0.41265085,0.52232902,0.63675249,0.75143556,0.89838567,1.0196439,1.1723246,1.2897547,1.223326,1.0723573,0.96137387,0.85117918,0.74049025,0.63289055,0.55143084,0.52629232,0.60705331,0.70796139,0.81191932,0.90275254,0.99814378,1.1097263,1.2291015,1.3785659,1.4856315,1.5133379,1.4083938,1.2618079,1.1138446,1.0358387,0.90939464,0.95881263,1.0786616,1.1830938,1.1614025,1.0867782,0.98852423,0.89527834,0.79415037,0.69870723,0.6017183,0.51558552,0.43049188,0.33950575,0.25499556,0.17893412,0.091564369,0.012074263,-0.044962326,-0.11798149,-0.18618554,-0.23313737,-0.2864567,-0.32926023,-0.34833736,-0.34674338,-0.33009285,-0.30643492,-0.25459615,-0.16011937,-0.051739133,0.056551742,0.15508771,0.25628527,0.37990962,0.47285696,0.58340578,0.69208127,0.802132,0.90396975,1.0140372,1.1064249,0.98460612,0.88625318,0.76912273,0.66970044,0.55972687,0.45146956,0.34494653,0.23797094,0.13882191,0.020529735,-0.080813077,-0.18018885,-0.29298323,-0.38634006,-0.49911493,-0.59500256,-0.70240929,-0.80021388,-0.90301702,-0.99167725,-1.0956282,-1.1758571,-1.2738878,-1.3233024,-1.3711392,-1.4399949,-1.5071051,-1.5911925,-1.6456402,-1.6778976,-1.7233042,-1.7429086,-1.7680627,-1.7743642,-1.761709,-1.7440113,-1.7068217,-1.6451589,-1.5655088,-1.4751124,-1.4000701,-1.2851422,-1.1706188,-1.0560262,-0.90369084,-0.75097903,-0.63383659,-0.52038912,-0.3673431,-0.24851089,-0.1033175,0.010603171,0.14154901,0.25155927,0.35815544:4
0.91777277,0.84878172,0.78268851,0.71592898,0.63102462,0.56683611,0.49548432,0.41606718,0.34768114,0.28708833,0.22945877,0.16726256,0.10237377,0.034977166,-0.046282243,-0.14273928,-0.26784536,-0.36438912,-0.45167954,-0.51034042,-0.55989209,-0.6010486,-0.64052345,-0.66440721,-0.68278427,-0.68508702,-0.69308845,-0.68594027,-0.68196647,-0.69247345,-0.69064141,-0.67969487,-0.65676223,-0.61419687,-0.56315311,-0.52492675,-0.47075376,-0.41576634,-0.3725794,-0.30915054,-0.26631763,-0.19519339,-0.16942508,-0.26776335,-0.34922089,-0.38131745,-0.32353095,-0.26766516,-0.1900365,-0.10287309,0.0010787298,0.083716169,0.18632893,0.26537428,0.29895374,0.21376229,0.1263726,0.030540495,-0.050640463,-0.15076789,-0.23597261,-0.32500086,-0.41107799,-0.49051685,-0.58483755,-0.68274936,-0.77836831,-0.86226593,-0.96373049,-1.051788,-1.1420656,-1.2216482,-1.3133767,-1.3987805,-1.4909204,-1.5793448,-1.666104,-1.7511701,-1.8381897,-1.8922671,-1.9483868,-1.9766935,-2.0040263,-2.0139073,-2.0044518,-1.9799802,-1.9274225,-1.8830577,-1.8258704,-1.7675955,-1.7084032,-1.6443812,-1.5629341,-1.4837534,-1.4047468,-1.3133849,-1.2407808,-1.1503552,-1.0826675,-0.98941748,-0.8958292,-0.81687431,-0.70504205,-0.60488302,-0.50241369,-0.37811088,-0.30137529,-0.31670258,-0.30671739,-0.22725911,-0.14597137,-0.039066383,0.077309239,0.16983266,0.27173042,0.3687267,0.46484696,0.56602565,0.59609205,0.47547637,0.38195717,0.27256378,0.16611668,0.075977066,-0.03062213,-0.11466929,-0.19354881,-0.26167503,-0.29959704,-0.312098,-0.2907694,-0.23637243,-0.14356655,-0.060244619,0.018752924,0.10266657,0.18972109,0.28423564,0.36888835,0.45130632,0.53445129,0.61980633,0.71821753,0.80311798,0.89038641,0.97617215,1.0666549,1.1590782,1.2338024,1.1623942,1.1445794,1.1905714,1.2688399,1.3528023,1.4533022,1.5392935,1.6373672,1.7183335,1.8172554,1.8284715,1.7384769,1.6877113,1.5931231,1.4981214,1.4231304,1.3233252,1.2339142,1.1423894,1.0771658,1.1290351,1.2099957,1.3007512,1.2943568,1.210316,1.1110742,1.0355448,0.94593216,0.85610502,0.76403492,0.67765941,0.58323347,0.50441783,0.41379283,0.32894767,0.23534258,0.15044939,0.06321195,-0.025066883,-0.11442898,-0.18628707,-0.22894515,-0.23660875,-0.20960164,-0.14965651,-0.091622636,-0.040699597,0.022463895,0.12906326,0.2468658,0.33764523,0.45813357,0.55033383,0.54778824,0.46943207,0.3702278,0.27280189,0.17458283,0.091375566,0.017275996,-0.0086974093,-0.10283624,-0.18304772,-0.28620788,-0.39653416,-0.4886928,-0.58205603,-0.66696884,-0.76043691,-0.84287838,-0.93805216,-1.0323629,-1.113707,-1.2063953,-1.2937186,-1.3758058,-1.4617276,-1.542272,-1.6167997,-1.7114446,-1.7940919,-1.8697521,-1.951205,-2.0297972,-2.0955893,-2.1625591,-2.2246573,-2.2791212,-2.3250163,-2.3273853,-2.2762587,-2.2058152,-2.1307987,-2.0553429,-1.9737668,-1.8865399,-1.7962181,-1.7076912,-1.6218393,-1.5353016,-1.4506229,-1.3572167,-1.2731879,-1.1729291,-1.0732834,-0.97383542,-0.88552703,-0.78348581,-0.68908926,-0.57767286,-0.48607255,-0.37739696,-0.29699292,-0.34790692,-0.27574071,-0.17898995,-0.091714082,0.026066776,0.13707127,0.24766654,0.35563442,0.43491507,0.46310102,0.39502566,0.32731829,0.26214995,0.22746387,0.14919895,0.064995641,-0.034677566,-0.13980092,-0.21217316,-0.31041087,-0.38808674,-0.32342467,-0.23879141,-0.14496359,-0.17418994,-0.25188183,-0.34547002,-0.43085639,-0.49088713,-0.56938663,-0.62817228,-0.69484933,-0.76792092,-0.82235564,-0.85840179,-0.88921196,-0.92451262,-0.94600641,-0.98147505,-1.0055744,-1.0263953,-1.0269358,-1.0280354,-1.0113621,-0.98881859,-0.97126064,-0.93989157,-0.90429695,-0.86395404,-0.81456505,-0.76251197,-0.69767929,-0.63547709,-0.55883929,-0.4816483,-0.38474537,-0.28240899,-0.19019187,-0.12782992,-0.076225894,-0.018452298,0.032401466,0.081701094,0.15462657,0.21834894,0.30115009,0.36162585,0.42480515,0.49032892,0.55515161,0.61854554,0.68496979,0.75832988,0.83064328,0.90027218,0.97465619,1.0467031,1.134877,1.0774139,1.0225881,0.95691941,0.91650351,0.87412541,0.83105331,0.79043438,0.76018439,0.74381879,0.73857276,0.75512975,0.75505377,0.75262096,0.75995528,0.77340004,0.80173991,0.82209532,0.84555697,0.85835899,0.89245701,0.93337642,0.97522057,1.0194483,1.0630178,1.1071611,1.1363467,1.1901982,1.2281427,1.2720834,1.3243572,1.3568527,1.393272,1.4196475,1.4454052,1.4660928,1.4843036,1.4981346,1.5100046,1.5158936,1.5179751,1.5223779,1.5326307,1.5774238,1.5789438,1.4893544,1.4013351,1.3083329,1.3769741,1.4600791,1.5130789,1.4848559,1.3974692,1.3647673,1.3629082,1.3677868,1.369189,1.3633126,1.3599692,1.3556608,1.339306,1.3168299,1.2780157,1.2454585,1.2101038,1.1735587,1.1246511,1.1000546,1.0597574,1.01131,0.96354201,0.9229873,0.87946845,0.84000337,0.79542854,0.75722166,0.73391332,0.72353475,0.71864168,0.71796124,0.70715079,0.711881,0.71802009,0.73931465,0.78089068,0.81959448,0.85050806,0.90119956:4
2.0123392,1.9009273,1.7748804,1.6331412,1.5228682,1.3182119,1.1134291,0.90865074,0.73582986,0.54618144,0.34145942,0.13666335,-0.068139875,-0.27283598,-0.43030061,-0.63473534,-0.83946963,-1.0440912,-1.2008959,-1.3573669,-1.5153039,-1.671029,-1.8261868,-1.9819517,-2.1411591,-2.295064,-2.501362,-2.6091372,-2.8128817,-2.8530247,-2.6484454,-2.4995801,-2.4936036,-2.3803202,-2.3696291,-2.2501102,-2.1265732,-2.0026569,-1.8732557,-1.9158631,-1.7887309,-1.7071711,-1.6431599,-1.5341873,-1.4187383,-1.3121692,-1.2466977,-1.1909449,-1.0560644,-0.93296161,-0.7863446,-0.65885147,-0.5094458,-0.63410943,-0.7105237,-0.81588861,-0.86550527,-0.91490553,-0.88785401,-0.7512518,-0.7102624,-0.67411377,-0.57068372,-0.62533199,-0.68503952,-0.81368492,-0.81720639,-0.91363144,-0.93650915,-0.80999952,-0.64931041,-0.54440884,-0.57712813,-0.42581083,-0.30319168,-0.36615863,-0.26450052,-0.21074947,-0.16963381,-0.15522292,-0.19347497,-0.15410429,-0.072849379,0.038385906,0.10349861,0.028060643,0.086253793,0.16887407,0.28032447,0.39693508,0.37153987,0.37075995,0.47121532,0.51477971,0.58588964,0.69716432,0.79039389,0.6710257,0.5286299,0.39571723,0.27642128,0.15847234,0.059006592,-0.010999047,-0.043977263,0.024834799,0.097725086,0.17268802,0.25687583,0.32187421,0.39499459,0.43961036,0.5152612,0.55521623,0.59550086,0.65332106,0.71891186,0.82498039,0.88180141,0.9875486,1.0261198,1.0870897,1.1492487,1.199086,1.2500113,1.316478,1.4001585,1.467492,1.5752349,1.6417472,1.7308486,1.7887751,1.8364048,1.8713869,1.7894459,1.6619456,1.5212506,1.349368,1.317302,1.1744582,1.0173744,0.86013367,0.75387003,0.58551552,0.47785319,0.36128522,0.24387438,0.24756633,0.36471874,0.45667009,0.56074305,0.68252296,0.79208978,0.9120204,1.0194073,1.1026773,1.2110299,1.3411444,1.4237265,1.5142843,1.5853644,1.6657659,1.7936937,1.8420661,1.90452,1.9487999,1.9503705,1.8206691,1.6829332,1.5375517,1.4305206,1.3373171,1.1971764,1.0449399,1.0270068,0.93960637,0.81417959,0.66682084,0.6135753,0.46567944,0.33015365,0.27127471,0.27635909,0.17056761,0.021436941,-0.12016218,-0.25726573,-0.40502632,-0.51609142,-0.67221678,-0.80334113,-0.94114032,-1.0914851,-1.2374619,-1.3348793,-1.2068608,-1.0479925,-0.86641021,-0.72629418,-0.57413333,-0.48484673,-0.35188904,-0.21826748,-0.087082145,-0.0028438962,0.096191024,0.22114472,0.29228939,0.26746388,0.2319976,0.12331709,0.0036059704,0.099215502,0.14772287,0.20720868,0.27442342,0.2064587,0.067548236,0.0012328083,0.11699766,0.17801326,0.08034207,-0.02496127,-0.15228604,-0.2678201,-0.2209526,-0.10788842,-0.19964435,-0.28664818,-0.3846938,-0.45850352,-0.61819457,-0.75353391,-0.70476325,-0.84040207,-0.98090268,-1.1234026,-1.2450134,-1.1077022,-0.97563132,-0.80753683,-0.66245174,-0.52575856,-0.39904494,-0.29146229,-0.14796234,-0.014255434,0.089179204,0.13090867,0.24792453,0.35684141,0.47267314,0.59645044,0.72978633,0.85351289,0.78860836,0.90539238,1.0509695,1.193014,1.2918856,1.4258559,1.5554112,1.5293931,1.3799043,1.339264,1.1869067,1.0487039,1.1308152,1.066437,0.93289195,0.84389443,0.72038525,0.75858591,0.64308452,0.56078151,0.49120124,0.36334574,0.22410643,0.27602311,0.16539705,0.039891252,-0.072854024,-0.19687603,-0.33205664,-0.46236351,-0.4386798,-0.28197654,-0.14266145,-0.0064029762,0.14858324,0.2600087,0.42313592,0.60603905,0.67982345,0.82753297,0.94800328,1.1030773,1.2131893,1.1168338,1.0240425,0.92132024,0.83299903,0.84841435,0.73682799,0.64539796,0.55442961,0.44230135,0.35946049,0.47843994,0.37573521,0.28930906,0.23766349,0.18184688,0.077295079,-0.0063801549,-0.093589662,-0.15915096,-0.1618217,-0.21815646,-0.29965474,-0.39994467,-0.41100527,-0.46879672,-0.56199411,-0.64652482,-0.71585533,-0.7409746,-0.75666484,-0.62702634,-0.54077923,-0.37534747,-0.23865502,-0.085843503,0.044951257,0.2163902,0.20429052,0.36259369,0.50692585,0.66459214,0.78949658,0.75411948,0.63921613,0.58672621,0.48167728,0.37915472,0.34385915,0.34151011,0.22892252,0.15127572,0.041830668,0.055331461,-0.070819916,0.046788236,0.12539876,0.069575343,0.011967309,-0.068467701,-0.11691825,-0.16509673,-0.1622909,-0.2498466,-0.22990915,-0.27210638,-0.40103929,-0.48236466,-0.44118414,-0.58252536,-0.58198395,-0.68481129,-0.77052196,-0.61845496,-0.54201823,-0.3872077,-0.27677715,-0.38075932,-0.34844894,-0.46254908,-0.5287268,-0.60257305,-0.71707752,-0.76971587,-0.82407601,-0.8585722,-0.90657503,-1.0298442,-1.0257576,-1.133633,-1.2554848,-1.3674389,-1.4876031,-1.5147026,-1.4773446,-1.5543564,-1.5153268,-1.3715601,-1.3438428,-1.3900449,-1.4116965,-1.52839,-1.6303405,-1.6998378,-1.8624886,-1.9026009,-1.7166711,-1.5117999,-1.3071447,-1.1492178,-0.94337867,-0.74807624,-0.62747172,-0.47065665,-0.3478041,-0.15368927,0.0050189721,0.21072306,0.40390238,0.57477765,0.77962904,0.93872351,1.1384428,1.3039014,1.4634911,1.6249294,1.7858584,1.8867165,2.0006243,2.0498032:1
2.6085026,2.5269041,2.4427281,2.3559979,2.2852382,2.1921232,2.1089063,2.0298781,1.9440629,1.8606132,1.7739871,1.6915145,1.6093034,1.5262641,1.446597,1.3649783,1.2766133,1.19854,1.1084223,1.0256434,0.9416247,0.85848047,0.77646376,0.69226764,0.61187882,0.53431793,0.44551271,0.36665698,0.27839121,0.1958033,0.13341348,0.083943695,0.062327052,0.065138347,0.06251537,0.056441751,0.030351546,-0.007539686,-0.050633836,-0.074812504,-0.084922102,-0.081251945,-0.075331145,-0.091931496,-0.12044491,-0.153004,-0.17126869,-0.17596962,-0.16959115,-0.16732676,-0.15911318,-0.15164146,-0.13312122,-0.12864158,-0.20975156,-0.23641451,-0.22529435,-0.20121092,-0.16946862,-0.21808928,-0.25955585,-0.30770563,-0.3696603,-0.41456118,-0.46913367,-0.52838629,-0.59825382,-0.65752818,-0.72428171,-0.80247061,-0.89341765,-0.99261969,-1.05496,-1.1068717,-1.1465153,-1.1780592,-1.1941199,-1.1955726,-1.1699057,-1.1274963,-1.0782088,-1.0369509,-0.99939842,-0.94899152,-0.91101566,-0.86164021,-0.82217215,-0.78570998,-0.73262529,-0.67294223,-0.59678531,-0.49757967,-0.4131684,-0.33456793,-0.34986636,-0.29964886,-0.20381856,-0.10764836,-0.0275129,0.056301214,0.10546874,0.031520078,-0.054597496,-0.13313152,-0.21570039,-0.30125018,-0.38189032,-0.45615428,-0.50621304,-0.57377403,-0.66061551,-0.74316838,-0.83806112,-0.9189163,-1.0133418,-1.0945323,-1.1894744,-1.2683285,-1.3643854,-1.4487541,-1.5296144,-1.6095136,-1.6883214,-1.7618525,-1.8310701,-1.8557578,-1.8451228,-1.8122186,-1.7699064,-1.7241201,-1.675157,-1.6083857,-1.5441487,-1.4700918,-1.3992056,-1.3068646,-1.2287952,-1.132154,-1.0569425,-0.9651947,-0.88446502,-0.80992118,-0.73292896,-0.65652919,-0.56936111,-0.48035142,-0.40194775,-0.31623248,-0.23517312,-0.15575991,-0.079889865,0.0014185409,0.08996601,0.18451151,0.27700653,0.39266278,0.48081794,0.594565,0.67643533,0.75476621,0.76923459,0.70001724,0.6342752,0.57767825,0.50721672,0.43368619,0.3801422,0.2980237,0.23479957,0.16576179,0.099620045,0.053513149,0.050065394,0.085709465,0.15690897,0.23038299,0.30771261,0.39200216,0.47195857,0.55735742,0.63683485,0.72374943,0.80511815,0.88351122,0.9685441,1.0511458,1.1335153,1.2214617,1.3008776,1.3879644,1.4699572,1.4392305,1.3501919,1.3150785,1.3794148,1.4589019,1.5430506,1.6248699,1.7023639,1.7894026,1.8760524,1.9591186,2.038417,2.0115,1.9255396,1.8484011,1.7620058,1.6759524,1.5951343,1.5136932,1.4286139,1.3714491,1.3816429,1.4582832,1.462624,1.3770825,1.298895,1.2125969,1.1315492,1.0522858,0.96716721,0.88200921,0.7944157,0.72210676,0.63340075,0.56051724,0.4734042,0.38326796,0.30997908,0.230496,0.15085793,0.10205184,0.10176515,0.15151092,0.2227815,0.32808698,0.41217602,0.51773573,0.62009308,0.70919968,0.79851872,0.76777468,0.68985724,0.60258674,0.5129096,0.43055098,0.34571219,0.25850573,0.17376826,0.089960445,0.0087628725,-0.080348154,-0.16636471,-0.24701647,-0.32825128,-0.41154353,-0.49020918,-0.57257926,-0.65117282,-0.73769436,-0.81940505,-0.90000073,-0.98991023,-1.0663331,-1.1425096,-1.2367029,-1.3187732,-1.3910917,-1.4677617,-1.5458526,-1.6289018,-1.6923249,-1.7465177,-1.7885749,-1.8001735,-1.7737717,-1.7199429,-1.6504613,-1.5693608,-1.4779593,-1.3790988,-1.2861919,-1.1894307,-1.0928722,-0.99550557,-0.90759434,-0.78887298,-0.69483021,-0.5977325,-0.61016649,-0.54667266,-0.43239221,-0.31889535,-0.2041291,-0.091809886,0.023643619,0.01676608,-0.066278434,-0.14769408,-0.22855521,-0.30714936,-0.38514616,-0.44163497,-0.4673536,-0.39022022,-0.30447437,-0.22909769,-0.27314265,-0.36559374,-0.47326497,-0.57706406,-0.65271409,-0.74640747,-0.81546685,-0.90204657,-0.96780135,-1.0267196,-1.075628,-1.122433,-1.1677175,-1.2162083,-1.246114,-1.2727005,-1.283288,-1.2955273,-1.3125923,-1.3100029,-1.3055298,-1.3017493,-1.2765244,-1.2410114,-1.1816549,-1.0983608,-0.99615985,-0.90866161,-0.83822366,-0.76400307,-0.69195142,-0.61493064,-0.54705725,-0.48413094,-0.4111714,-0.33031055,-0.25146476,-0.18638089,-0.12024408,-0.048653242,0.016016708,0.078585052,0.03582,-0.020285905,-0.066950415,-0.10951909,-0.13183246,-0.13601136,-0.16790622,-0.20140765,-0.23758621,-0.27173139,-0.30675975,-0.33620348,-0.35235376,-0.33842827,-0.30398423,-0.26246649,-0.21315143,-0.13830555,-0.043535775,0.056509265,0.017817826,-0.0033039772,-0.021173322,-0.042419777,-0.055043966,-0.067358862,-0.069012937,-0.073825255,-0.069380155,-0.042059682,-0.015898822,0.0099220855,0.023061017,0.042216098,0.05736145,0.072671616,0.083649788,0.12618728,0.12842944,0.0492559,-0.041642728,-0.13121454,-0.20620157,-0.20097201,-0.11645854,-0.033886318,0.052183346,0.067832075,0.14734687,0.22969282,0.31295757,0.40233899,0.48005262,0.56371949,0.64935674,0.72737083,0.81454245,0.89343087,0.97853112,1.066039,1.148598,1.2282609,1.3150584,1.3970685,1.4814614,1.5618763,1.644485,1.7333472,1.8154621,1.896542,1.9754592,2.064521,2.1423982,2.2308696,2.3207421,2.3943859,2.4886142,2.5673127:4
2.584425,2.4954132,2.4024054,2.296658,2.199647,2.0875338,1.9794697,1.8932843,1.7801716,1.6862969,1.5980886,1.4867233,1.4123246,1.3311115,1.2331892,1.1286781,1.0379942,0.95740579,0.88337111,0.79888326,0.70382918,0.61256742,0.51194822,0.41116904,0.3264862,0.22030764,0.13395285,0.035372318,-0.068694984,-0.16968478,-0.26330063,-0.35983709,-0.45770617,-0.53474582,-0.61638517,-0.71271944,-0.81784943,-0.90977619,-1.0121929,-1.1027462,-1.2277606,-1.3438449,-1.4348157,-1.5432165,-1.6461075,-1.7658322,-1.8663177,-1.9657136,-1.9814371,-1.9811079,-1.9110707,-1.8605401,-1.8184653,-1.7716201,-1.7516832,-1.7141393,-1.6630147,-1.6116494,-1.5736836,-1.5144117,-1.4351147,-1.3539338,-1.2637289,-1.174227,-1.0826253,-0.97614672,-0.87372733,-0.77439472,-0.68173267,-0.61906253,-0.55560029,-0.59070179,-0.67152643,-0.5997012,-0.50260531,-0.42443346,-0.38848662,-0.26749236,-0.20122908,-0.12054398,-0.11044566,-0.034968963,0.064858851,0.1532783,0.24275503,0.28730549,0.37021313,0.40013709,0.37047426,0.28158841,0.15929734,0.052258807,-0.047566951,-0.1347653,-0.2446434,-0.33233902,-0.43969114,-0.53631021,-0.575945,-0.50557178,-0.51916313,-0.46607152,-0.37036495,-0.33583596,-0.27331277,-0.20522393,-0.1226967,-0.11093761,-0.095773145,-0.10209127,-0.055525639,0.042324785,0.1056394,0.20267023,0.2599539,0.32395347,0.34627035,0.35377764,0.42594633,0.51862201,0.58733773,0.66920207,0.68025194,0.72068731,0.74956824,0.87361054,0.99661021,1.0914466,1.1983342,1.2973055,1.375711,1.4063598,1.4207705,1.362751,1.2766146,1.1577795,1.0574686,1.0313229,0.94454382,0.87675116,0.76874934,0.66684952,0.57645921,0.4929652,0.44661214,0.4183545,0.34211441,0.21808064,0.14267359,0.11447652,0.021943189,-0.06243943,-0.17780962,-0.26393638,-0.36927419,-0.50532102,-0.59593881,-0.6726719,-0.6000384,-0.51488207,-0.42917208,-0.33033227,-0.2718254,-0.18386382,-0.076300911,0.0056899065,0.048666663,0.10911525,0.20410177,0.27394216,0.3666099,0.46751169,0.50135614,0.56424,0.6600864,0.67592357,0.65752583,0.54974565,0.44716773,0.34946913,0.25459674,0.27915562,0.35347337,0.4789241,0.59511123,0.71348491,0.79434046,0.91623842,0.97778081,1.0523663,1.1864758,1.2810908,1.3302155,1.4099711,1.5115827,1.625146,1.7030405,1.7680052,1.6951403,1.5922452,1.4721434,1.3630696,1.2696077,1.2114175,1.1348057,1.0273059,0.91689465,0.81802672,0.87545199,0.87074207,0.78422701,0.69994612,0.60733778,0.50915448,0.40682731,0.3186593,0.21994307,0.13406802,0.057610146,0.069695384,0.083499031,0.14119812,0.21275148,0.28829908,0.35668457,0.29607646,0.20752511,0.11476324,0.030021633,-0.066215682,-0.081462736,-0.15235387,-0.28308714,-0.39987727,-0.50822061,-0.57591699,-0.46887836,-0.45052365,-0.4999662,-0.56785231,-0.67847743,-0.7739441,-0.84290106,-0.96210515,-1.0684078,-1.1571101,-1.2426379,-1.2478598,-1.2289827,-1.1843509,-1.1504149,-1.0805401,-0.99934034,-0.91160723,-0.81376937,-0.7746317,-0.68863693,-0.59124364,-0.49967224,-0.4011025,-0.29928288,-0.19877334,-0.10240229,-0.0095732062,0.012317646,-0.026275829,-0.040721701,0.068848268,0.17928178,0.28808423,0.38295725,0.48782226,0.58645909,0.6940588,0.72996342,0.80300586,0.91048665,1.0164205,1.1288086,1.2252056,1.329448,1.3456219,1.3106626,1.2057934,1.0952782,0.98243985,0.87370264,0.84435585,0.76657981,0.66372222,0.57776011,0.50861246,0.40774043,0.45470701,0.44882549,0.34222915,0.23559521,0.15177391,0.062347521,0.042053506,-0.028905261,-0.12127874,-0.17043699,-0.068187001,-0.06072789,0.049780251,0.073970907,0.095075086,0.021120262,-0.045042365,-0.12135123,-0.19208607,-0.26735079,-0.35480477,-0.44296947,-0.52103233,-0.47574294,-0.49468141,-0.55950168,-0.63188644,-0.69422278,-0.75492015,-0.83099036,-0.89609942,-0.96187956,-1.0227012,-0.97853452,-0.8807201,-0.75964831,-0.63642734,-0.51536505,-0.39767276,-0.30011097,-0.2050317,-0.083846281,0.019479039,0.1116669,0.074544007,0.023856993,-0.04551347,-0.12231271,-0.15563808,-0.23323387,-0.32270199,-0.413091,-0.40031363,-0.36552165,-0.4460282,-0.52694655,-0.60470897,-0.69318372,-0.7862048,-0.86725061,-0.9512029,-1.0315699,-0.9466289,-0.94922428,-0.99854594,-1.0749883,-1.1154603,-1.1770141,-1.2927172,-1.3765758,-1.3988399,-1.3483551,-1.4405105,-1.5357029,-1.5633512,-1.6373586,-1.6851543,-1.7550436,-1.7856828,-1.7985714,-1.873596,-1.9099567,-1.9333899,-1.9879323,-2.0103828,-2.0223273,-2.0684295,-1.9591314,-1.8586618,-1.7332013,-1.6201116,-1.4953176,-1.3955591,-1.2774879,-1.1789138,-1.0718953,-0.95491427,-0.85777396,-0.75721305,-0.65228669,-0.5429561,-0.43088761,-0.41821369,-0.3229093,-0.22726336,-0.12650272,-0.022838343,0.068306304,0.1669147,0.26880172,0.36617611,0.46221793,0.55878685,0.66764198,0.75407868,0.85671536,0.95982841,1.0489121,1.1517984,1.2491419,1.3428024,1.4431324,1.5453173,1.6356174,1.7427943,1.84567,1.943068,2.0387121,2.1414457,2.2555725,2.3642487,2.4626667,2.5883591,2.6283943:3
0.2289694,0.16369679,0.098383641,0.043533436,0.012554705,-0.01637287,-0.026718662,-0.014008582,0.044837774,0.1540886,0.12433275,0.13460751,0.12718793,0.11705214,0.12221006,0.1256961,0.13190137,0.15732261,0.18521428,0.21819735,0.24112474,0.25385406,0.29666779,0.34935349,0.38734303,0.42232077,0.46776658,0.5140354,0.55900941,0.6077323,0.66557303,0.70972381,0.74833613,0.78673924,0.8240062,0.84590912,0.86257796,0.95192145,0.91296939,0.90352488,0.99116722,1.0793562,1.1750083,1.2728337,1.3701433,1.4694547,1.5600141,1.5910205,1.6853435,1.7886721,1.8621443,1.9692614,2.0007507,2.0968891,2.1931406,2.2828933,2.210553,2.1039879,2.0026986,1.9050275,1.8058781,1.7064604,1.6087249,1.5097627,1.4149426,1.3212549,1.2239027,1.1304803,1.0436586,0.94693818,0.87085721,0.81022083,0.81925187,0.84241639,0.85801073,0.86617795,0.86684356,0.86920563,0.87128328,0.85830559,0.83855374,0.80905844,0.77090971,0.73700909,0.70116457,0.66590028,0.64645311,0.63568172,0.61736964,0.61439986,0.6274385,0.64756978,0.67964652,0.69544578,0.6269461,0.56353311,0.56233395,0.58816031,0.63911902,0.69350678,0.66119109,0.58743132,0.52298685,0.46108188,0.4014136,0.34480763,0.28261614,0.21969965,0.16618912,0.10735447,0.043232118,-0.029371683,-0.11868158,-0.20994068,-0.31861705,-0.40191706,-0.47258131,-0.5290168,-0.58233228,-0.61976872,-0.64567995,-0.6552827,-0.65080045,-0.63212505,-0.5924413,-0.55497552,-0.51873737,-0.48326876,-0.4563078,-0.4227384,-0.39143616,-0.34016943,-0.2575349,-0.17454679,-0.097429897,-0.0079206196,0.095214611,0.10073616,0.0039296732,-0.078386599,-0.069488001,2.7264151E-4,-0.024880851,0.019013675,0.09378366,0.18226868,0.28503082,0.38697236,0.42544596,0.51585018,0.61919907,0.55547878,0.44429506,0.340565,0.2194426,0.12729696,0.016792467,-0.085428476,-0.18704147,-0.27113679,-0.32007083,-0.42415207,-0.54103017,-0.64472827,-0.74563905,-0.84787523,-0.95245871,-1.053897,-1.1555883,-1.2515313,-1.3446908,-1.4344643,-1.5287663,-1.6221129,-1.7085314,-1.7979229,-1.8813782,-1.9412073,-1.9664275,-1.9595542,-1.9299532,-1.8904474,-1.8355127,-1.7773123,-1.718381,-1.6526224,-1.5750197,-1.5011681,-1.4261587,-1.3502901,-1.2716961,-1.1841794,-1.100806,-1.0193484,-0.94510623,-0.8561419,-0.77324957,-0.69358175,-0.6031933,-0.51436316,-0.42123291,-0.3385203,-0.24252901,-0.15997312,-0.069501316,0.030574577,0.099078331,-0.016685663,-0.072181242,-0.035454623,0.043923713,0.13263272,0.21502135,0.30986404,0.39406283,0.48187349,0.57678683,0.66868556,0.72527122,0.80651266,0.72486547,0.6264789,0.53064916,0.45619478,0.35318114,0.25817038,0.16127253,0.070373684,-0.027297124,-0.13547394,-0.22364384,-0.29574093,-0.32818425,-0.3265297,-0.30290851,-0.24348472,-0.16930313,-0.091340277,-0.0055859587,0.10269658,0.20504867,0.31263775,0.40730264,0.51349186,0.61555971,0.73464474,0.84047618,0.94609884,1.0539102,1.1636855,1.2703884,1.3266997,1.4294608,1.5350141,1.4473037,1.3502448,1.27851,1.2871691,1.3565122,1.4601773,1.5633986,1.6878634,1.7976379,1.9098334,2.0072631,2.0978909,2.1731619,2.0953246,2.0095123,1.9224788,1.8347427,1.8265689,1.7400813,1.6223744,1.516347,1.4105203,1.2941871,1.1945724,1.09652,1.0142554,1.0021229,1.0424378,1.1075627,1.1693382,1.2279127,1.1887757,1.1134629,1.0237268,0.90653839,0.79889594,0.68925036,0.57620021,0.46318152,0.35152095,0.2552307,0.12638559,0.014731785,-0.11406251,-0.22479485,-0.33623406,-0.44367446,-0.53285799,-0.6059811,-0.65276307,-0.65520769,-0.62446074,-0.57941871,-0.53212755,-0.4850171,-0.42214067,-0.36242282,-0.2856182,-0.19914936,-0.11532902,-0.0022759673,0.094033075,0.20065474,0.24539668,0.35767513,0.38118729,0.26943347,0.18341419,0.081344606,-0.039743394,-0.1532463,-0.26442098,-0.38556288,-0.50482708,-0.58841852,-0.5741074,-0.51577836,-0.56360808,-0.65252667,-0.75267361,-0.84992715,-0.95661969,-1.0598601,-1.1737176,-1.2855825,-1.3978322,-1.4964934,-1.6138897,-1.7178738,-1.8468464,-1.9716297,-2.0960278,-2.1920555,-2.2664216,-2.3041868,-2.2963527,-2.2357398,-2.1345437,-2.0385265,-1.9396029,-1.8490696,-1.7619184,-1.6709606,-1.5714291,-1.4822491,-1.3873113,-1.3007649,-1.2130372,-1.1248666,-1.0298334,-0.96572115,-0.90238969,-0.80338257,-0.71955269,-0.62260818,-0.53943663,-0.4441283,-0.35147156,-0.26438661,-0.16789794,-0.071986639,-0.04415376,-0.14288298,-0.23200436,-0.32308898,-0.41922879,-0.50625144,-0.59814526,-0.67987209,-0.75744517,-0.84111172,-0.91595652,-0.96783951,-0.93994092,-0.83474092,-0.82249656,-0.86776755,-0.93142895,-0.99831668,-1.0565105,-1.1099925,-1.1600732,-1.1955932,-1.2326363,-1.2585736,-1.2718419,-1.2790897,-1.2842097,-1.2808049,-1.2657357,-1.2439479,-1.2144094,-1.1771446,-1.104453,-1.0283542,-0.93732787,-0.84865409,-0.74280507,-0.65706384,-0.58489228,-0.52231684,-0.47014276,-0.41535526,-0.36208548,-0.31901161,-0.27424675,-0.24015181,-0.19957473,-0.120079,-0.057567099,0.0068364285,0.090653201,0.17716228:4
1.8214967,1.6928498,1.5320648,1.4005863,1.2685157,1.141506,0.98035118,0.83990846,0.66361042,0.56680298,0.41496134,0.25629541,0.10979239,-0.036282325,-0.162028,-0.28407394,-0.40836828,-0.53647316,-0.67031324,-0.82916915,-0.96269654,-1.1124097,-1.2687441,-1.3704587,-1.5502942,-1.6800812,-1.5874655,-1.4942596,-1.4318612,-1.3072855,-1.2169816,-1.1262646,-1.0270782,-1.0114992,-1.0049838,-0.89535537,-0.80783194,-0.71056496,-0.60610571,-0.48906093,-0.46379679,-0.55526322,-0.64289183,-0.56517392,-0.48484419,-0.40360642,-0.51546206,-0.54266354,-0.44352155,-0.40053157,-0.51578687,-0.63347495,-0.73967827,-0.7943552,-0.96157911,-1.0771816,-1.0983911,-1.0005396,-1.1260364,-1.2423472,-1.4205918,-1.5938481,-1.6798066,-1.7860218,-1.9688049,-2.155435,-2.1477163,-2.0302185,-1.877762,-1.7293541,-1.61001,-1.4652621,-1.3229566,-1.1778073,-1.1498671,-1.1767882,-1.0207015,-0.87251085,-0.73088661,-0.59901097,-0.44276136,-0.30374303,-0.15555722,-0.097769563,-0.077322258,0.023120342,0.15498309,0.30315373,0.45842048,0.58975745,0.73335406,0.66479061,0.78371613,0.91831729,1.0705917,1.2188437,1.343788,1.3351393,1.4340732,1.5725919,1.6986359,1.7711068,1.9143453,2.051877,2.1851492,2.1420106,1.9855402,1.8368643,1.727132,1.581568,1.4387561,1.497476,1.3829045,1.2659949,1.1170693,0.98104938,0.86413498,0.81976832,0.93975164,0.82846479,0.69982199,0.60105795,0.49094119,0.46395928,0.37463857,0.24882556,0.14281437,0.0068802539,-0.1063237,-0.20367581,-0.11834309,-0.21823644,-0.33726078,-0.44427603,-0.55576895,-0.67767686,-0.76853762,-0.78342498,-0.89958295,-0.9986319,-1.0818586,-1.1911613,-1.2965321,-1.3420796,-1.1539245,-0.94966071,-0.79242172,-0.70332344,-0.4972633,-0.29371408,-0.15664791,-0.062515349,0.026928128,1.948729E-4,0.023284589,0.22906683,0.37974454,0.56180952,0.76753079,0.89513282,1.0342604,1.23032,1.3586482,1.5646556,1.5975603,1.4966743,1.3713941,1.263094,1.1951334,1.0652503,0.98886188,1.0186015,0.91278021,0.80015393,0.68431927,0.60545903,0.48479316,0.37216257,0.38488653,0.402936,0.31214158,0.24398201,0.23970574,0.21369362,0.14345845,0.098890471,0.056440409,-0.0054458331,-0.095358638,-0.20153484,-0.26802196,-0.26835313,-0.3744874,-0.4423611,-0.50445991,-0.57601159,-0.67526353,-0.65626425,-0.70625075,-0.75098646,-0.81707848,-0.92064988,-0.98376691,-1.07415,-1.1267441,-1.2485043,-1.271885,-1.2252246,-1.1255914,-1.0393428,-0.95066279,-0.99796746,-0.8746668,-0.73511447,-0.5960711,-0.44353605,-0.27421063,-0.16276427,-0.079443763,-0.17907192,-0.28189174,-0.3564741,-0.34702514,-0.38078985,-0.44158626,-0.41893666,-0.45444216,-0.53984645,-0.59215115,-0.52168919,-0.46186496,-0.49210409,-0.52411627,-0.56978721,-0.63002074,-0.67667064,-0.78012265,-0.85867991,-0.94010312,-0.90436299,-0.77935925,-0.65762822,-0.66382644,-0.76495617,-0.80921531,-0.84380928,-0.94122668,-0.9741768,-1.0667201,-1.1717287,-1.2720349,-1.377407,-1.5437771,-1.6690516,-1.7099637,-1.5893247,-1.428005,-1.2787404,-1.1039884,-0.95239654,-0.75918915,-0.60745758,-0.40295163,-0.27481049,-0.07884173,0.12550282,0.32657128,0.45906018,0.66045878,0.86087601,1.0036727,1.1959223,1.3990735,1.5976034,1.8025982,1.9289122,2.096934,2.2857982,2.3714221,2.4935395,2.5935197,2.6741413,2.7148099,2.6751722,2.5440141,2.3988885,2.2241199,2.0726453,1.9005143,1.7663514,1.5776327,1.4223833,1.2568641,1.0891647,0.88707222,0.7510849,0.54750993,0.41527383,0.21735534,0.011620252,-0.1139839,-0.31457089,-0.44987741,-0.65087125,-0.78962541,-0.98969187,-1.1195539,-1.3120442,-1.2339583,-1.1011407,-0.95851886,-0.94309177,-0.84603842,-0.82702606,-0.71736557,-0.59081298,-0.53142554,-0.50083755,-0.45384111,-0.39541376,-0.3761692,-0.29846622,-0.24907961,-0.21591041,-0.27838834,-0.41969379,-0.54632771,-0.70863451,-0.68709791,-0.60865711,-0.52831521,-0.47248405,-0.40321323,-0.29394635,-0.21909015,-0.14260884,-0.19631005,-0.19862692,-0.099569994,-0.027323155,0.014102947,0.079823103,0.11854887,0.15324658,0.22729094,0.28981239,0.35666507,0.4151246,0.44193978,0.25427168,0.05005689,-0.075894644,-0.26801496,-0.22740375,-0.32636987,-0.46121735,-0.61630508,-0.79285751,-0.80999834,-0.72577701,-0.63461981,-0.55164171,-0.47106593,-0.37550763,-0.30483468,-0.24199712,-0.23709706,-0.13661709,-0.044558931,-0.0026550704,0.087420955,0.12392777,-0.016688645,0.043508005,0.14202129,0.23814651,0.30635174,0.41187412,0.51005796,0.62730279,0.54856844,0.53372423,0.63735013,0.75718142,0.81793712,0.93040277,1.0589244,1.1640031,1.2943677,1.3078586,1.1285261,0.93132254,0.76804327,0.68037798,0.55256329,0.36933557,0.18059853,-0.0029347007,-0.14892237,-0.31804029,-0.41328997,-0.29814317,-0.2086658,-0.066244033,0.053038238,0.15857916,0.2238964,0.2849231,0.4278123,0.50026444,0.57539656,0.60474123,0.56174063,0.67754351,0.79069104,0.86279153,0.99710178,1.0957923,1.0119888,1.1540148,1.293485,1.3079018,1.4181862,1.513568,1.6560995,1.8261311,1.8797146:1
1.8439939,1.8169757,1.7787065,1.7331524,1.667838,1.5953778,1.5115458,1.4307914,1.3334766,1.2436218,1.1377968,1.0503196,0.96332939,0.85996324,0.77800496,0.71648335,0.67445739,0.68327394,0.69812718,0.71979239,0.776716,0.80403635,0.84919241,0.89314278,0.86697079,0.88750796,0.88448895,0.84593052,0.81316665,0.77229091,0.7106388,0.67575038,0.6670612,0.62159334,0.57414151,0.52790347,0.45739084,0.38726556,0.28015049,0.18906978,0.11570768,0.019053841,-0.083368556,-0.1766256,-0.2891338,-0.38620704,-0.50217229,-0.60493614,-0.71019097,-0.79933344,-0.89999051,-1.0011395,-1.0926103,-1.1880108,-1.2624586,-1.2418577,-1.2290881,-1.1542566,-1.1024505,-1.0267913,-0.93878174,-0.85146338,-0.76732702,-0.70459396,-0.64989434,-0.59111532,-0.54930913,-0.5673005,-0.51453958,-0.47082481,-0.4698618,-0.47064387,-0.46541853,-0.4167423,-0.4565169,-0.42683566,-0.42831778,-0.48592328,-0.53651162,-0.57348534,-0.61060843,-0.65567547,-0.70123855,-0.74371398,-0.79250481,-0.83270532,-0.83839051,-0.86245181,-0.89019975,-0.90482778,-0.91817718,-0.92658614,-0.92794391,-0.92533362,-0.91485967,-0.893692,-0.8673824,-0.83712828,-0.79934906,-0.75988502,-0.71587488,-0.66708724,-0.61520143,-0.55738425,-0.49531685,-0.43061185,-0.36313103,-0.29164653,-0.23286795,-0.15512653,-0.071478998,0.013907936,0.085728308,0.15128349,0.24605375,0.34265131,0.42498853,0.5251707,0.62308781,0.72368992,0.82382012,0.92470188,1.0264884,1.1291176,1.2368274,1.327797,1.4393829,1.5493678,1.6218927,1.719072,1.8303761,1.9423592,2.0356883,2.0807119,2.007941,1.8966997,1.7866588,1.676472,1.5673082,1.4600517,1.3534698,1.2469606,1.1416949,1.0709862,0.99982034,0.92324497,0.82625256,0.72423077,0.62566084,0.54401094,0.4488673,0.35435883,0.26195818,0.17057903,0.081571959,-0.0058761527,-0.090965934,-0.17355168,-0.25151327,-0.32730054,-0.40056652,-0.4718041,-0.53705988,-0.59884058,-0.6575307,-0.71096045,-0.74640238,-0.79366269,-0.83102589,-0.86377838,-0.89386844,-0.91537695,-0.93146,-0.94473046,-0.95436821,-0.95294836,-0.96619261,-1.0062884,-1.0526153,-1.1161986,-1.1693246,-1.2289123,-1.2847642,-1.3320715,-1.3904526,-1.4472112,-1.5089389,-1.5836293,-1.6014232,-1.6672887,-1.7120796,-1.7805469,-1.8153387,-1.8381992,-1.8596112,-1.9026895,-1.9127645,-1.9132428,-1.9143082,-1.9102363,-1.9120005,-1.9486669,-1.9296411,-1.9599809,-1.9451153,-1.9520838,-1.8979663,-1.8088863,-1.7278937,-1.631721,-1.5413226,-1.4457557,-1.3425285,-1.2537165,-1.1801879,-1.1135556,-1.060746,-1.0036947,-0.92048824,-0.83462559,-0.71388837,-0.61485474,-0.5575176,-0.53016835,-0.51078339,-0.46402601,-0.41596076,-0.34677653,-0.27771559,-0.20314119,-0.12121571,-0.061263038,-0.0020713012,0.018896527,0.07294839,0.090080228,0.12117014,0.11888595,0.11416478,0.127971,0.12430285,0.12037663,0.1287515,0.15839374,0.20888812,0.26977275,0.35122534,0.44488516,0.55139534,0.64560541,0.75407331,0.85371857,0.96262771,1.0736734,1.1953657,1.3141503,1.4354905,1.54552,1.6138526,1.6555437,1.6975645,1.7015784,1.640698,1.5682128,1.4739275,1.400327,1.3538473,1.2677581,1.1729044,1.0783686,0.9862785,0.87571488,0.78723472,0.67723215,0.57519613,0.47866829,0.37074409,0.27995635,0.17200261,0.064885733,-0.038551247,-0.14060865,-0.20713812,-0.25225943,-0.31206687,-0.37042711,-0.3978865,-0.36545525,-0.32780859,-0.37760571,-0.44421283,-0.49190002,-0.5559893,-0.60387869,-0.64228614,-0.69109852,-0.73241022,-0.76657889,-0.84436739,-0.85414518,-0.87383265,-0.94888301,-1.0318295,-1.1143652,-1.1847669,-1.2288866,-1.2953859,-1.3547805,-1.4160135,-1.4898508,-1.4841052,-1.4343343,-1.3542622,-1.2834754,-1.2246609,-1.1500562,-1.0764645,-1.0067719,-0.95944131,-0.89488026,-0.82931725,-0.77179372,-0.7314055,-0.6777585,-0.6299632,-0.57797233,-0.53061858,-0.50205281,-0.52810916,-0.56938545,-0.61545331,-0.64837848,-0.66590097,-0.71094763,-0.74541997,-0.72880076,-0.74064904,-0.72573066,-0.66088876,-0.59848841,-0.50558343,-0.42282772,-0.32780866,-0.23554743,-0.1503145,-0.068605447,0.012773598,0.09677189,0.17262886,0.24963858,0.32874188,0.40152269,0.47229377,0.54017207,0.61704634,0.68721668,0.74659814,0.78982397,0.79435941,0.76905284,0.73182577,0.71382469,0.70569262,0.74708797,0.82939358,0.91225049,0.99243437,1.0540037,1.1031177,1.1297827,1.1550633,1.1386254,1.105689,1.0481859,1.0094835,0.92656816,0.84768618,0.7683799,0.68475923,0.60505487,0.51949672,0.43973449,0.35517451,0.27020392,0.18220019,0.096213804,0.013826808,-0.065625171,-0.14548444,-0.19150871,-0.23531742,-0.2928521,-0.21659046,-0.1150946,-0.057403426,-0.017104571,0.057111739,0.14268662,0.22969396,0.31319658,0.40150446,0.48980311,0.58237191,0.67663117,0.77289652,0.87670274,0.97808813,1.0845,1.1486656,1.2329631,1.3164843,1.408863,1.4974823,1.5613727,1.6087946,1.6186992,1.6070426,1.5985785,1.5804585,1.5546458,1.5571231,1.6522016,1.7426575,1.8033227,1.8379038,1.8608913,1.8409843:2
1.5503298,1.4348273,1.3279384,1.2117552,1.14442,1.0631358,1.0081313,0.88656271,0.75057675,0.76430298,0.63905756,0.56274687,0.45596563,0.40163086,0.34240514,0.31356135,0.22111761,0.09823598,0.0010889819,0.099801624,0.14889612,0.070594622,0.02447417,-0.064769653,-0.06192631,-0.14324373,-0.16692335,-0.22284852,-0.29731853,-0.4047975,-0.5181875,-0.59335225,-0.52908919,-0.38704008,-0.23375954,-0.099449444,0.056040126,0.21482128,0.2679829,0.36875293,0.5141592,0.66347752,0.81592364,0.96925108,0.91874475,0.82105993,0.73639485,0.69497095,0.57726865,0.43703659,0.34739486,0.23471193,0.11326465,0.019549086,-0.0466042,-0.0094963309,-0.09367301,-0.18407165,-0.3006641,-0.38927914,-0.46567329,-0.57131888,-0.68672229,-0.72703046,-0.86226717,-0.95955689,-1.0819376,-1.1010828,-1.1856233,-1.1673444,-1.0293945,-0.89200001,-0.85199088,-0.95449995,-1.0317273,-1.1246271,-1.1785995,-1.2510506,-1.3003383,-1.4151652,-1.5343019,-1.6542004,-1.7395401,-1.8240357,-1.7696044,-1.7804816,-1.8524835,-1.7603192,-1.5938977,-1.4141164,-1.2746935,-1.1002138,-0.89157489,-0.71223253,-0.5381077,-0.36014501,-0.14954097,0.021451899,0.19322265,0.3573722,0.51439717,0.70140988,0.84435079,0.98677467,1.0694466,1.2777044,1.4465776,1.6397475,1.7975902,1.9814135,2.0991555,2.2425438,2.3603845,2.5428751,2.6270372,2.6708316,2.6590052,2.5864985,2.4677407,2.2850107,2.1439524,1.9730881,1.8270652,1.6485867,1.4759012,1.3397299,1.2114328,1.0341794,0.91352323,0.73884809,0.57840524,0.45921937,0.27184565,0.099382209,-0.11805972,-0.23320003,-0.41055797,-0.57752707,-0.72458006,-0.86864326,-1.0445088,-1.2507287,-1.4244625,-1.6297182,-1.8070194,-1.9750588,-2.0635594,-2.1451082,-2.234446,-2.3284497,-2.4103557,-2.3268256,-2.2535176,-2.1630563,-2.0836639,-1.9869537,-1.8437902,-1.6939935,-1.5487758,-1.4197049,-1.3873835,-1.2611133,-1.1702549,-1.0805074,-1.0022181,-0.95009573,-0.87536919,-0.76447641,-0.6558208,-0.51797002,-0.58619804,-0.59615626,-0.48093584,-0.33765489,-0.30719199,-0.44606495,-0.58732955,-0.72466835,-0.85772316,-1.0218886,-1.0782361,-1.0039025,-0.89616021,-0.81219766,-0.68290057,-0.59883928,-0.53218412,-0.42771758,-0.32730268,-0.23588605,-0.29355668,-0.16596845,-0.11140256,-0.017246903,0.044816629,0.11391006,0.18349085,0.086258995,0.023667488,0.12933848,0.2135256,0.29316313,0.36762265,0.4656028,0.42976267,0.54540571,0.6567826,0.71887585,0.7924168,0.88755561,0.97440194,1.0734323,1.1312403,0.97821677,0.80403034,0.62764847,0.46897439,0.29649884,0.22953903,0.17097639,0.0021998968,-0.20890325,-0.36727515,-0.53825814,-0.73818543,-0.92295002,-1.0664545,-1.0140963,-0.9216448,-0.76485474,-0.60972887,-0.57488896,-0.48782333,-0.42137862,-0.32846416,-0.22047394,-0.080831432,0.0096757445,-0.074778315,0.038771572,0.16586864,0.2869816,0.38407311,0.42688095,0.49955055,0.61586562,0.72656685,0.60592475,0.61807091,0.77750504,0.86204535,0.9592283,1.0325959,1.0283982,1.151368,1.3142649,1.342471,1.5086477,1.6055432,1.6910806,1.7277787,1.6095191,1.4567399,1.3186503,1.1620155,1.0664936,1.0123422,0.85972689,0.71058031,0.57966323,0.58176898,0.42585754,0.27472294,0.13529131,0.068094803,-0.079824908,-0.21639812,-0.3697138,-0.51028471,-0.64083571,-0.5995797,-0.47362762,-0.28927476,-0.15049442,-0.091764666,-0.092576051,0.049716746,0.18983893,0.33020544,0.46926158,0.50387312,0.42231947,0.5737523,0.7169062,0.81093554,0.92500756,1.0517426,0.97264129,1.0968936,1.2042756,1.2738834,1.3842814,1.5036708,1.4565728,1.346304,1.208275,1.0799677,0.90531988,0.82198812,0.73537095,0.56339988,0.55801715,0.48829023,0.33889769,0.20302479,0.067010439,-0.10231248,-0.25422382,-0.29686779,-0.41774652,-0.54047066,-0.69517489,-0.77929527,-0.91057749,-1.049653,-1.2210179,-1.388481,-1.5801195,-1.7104778,-1.7533263,-1.7428042,-1.5937349,-1.4681272,-1.3312559,-1.1951739,-1.0851641,-0.9654965,-0.85276226,-0.72380429,-0.606587,-0.71751063,-0.60192862,-0.46749253,-0.37086382,-0.3403214,-0.38727588,-0.25616571,-0.17033769,-0.241331,-0.34882182,-0.29492261,-0.43055957,-0.55956103,-0.49531513,-0.43946598,-0.56590319,-0.72479876,-0.81977853,-0.83920678,-0.94610976,-1.1003588,-1.1884776,-1.3382792,-1.3745214,-1.2165399,-1.0707816,-0.91557872,-0.77271755,-0.60997824,-0.48599746,-0.341393,-0.18037114,-0.083610762,0.074947575,0.23418829,0.33381672,0.52022787,0.66561519,0.72232369,0.82824432,0.98971799,1.175294,1.3409511,1.4846396,1.4324106,1.3351778,1.1870924,1.1924757,1.0743698,0.93667997,0.88509685,0.84254661,0.72237185,0.61959911,0.56704946,0.4529876,0.37144207,0.29909063,0.46702764,0.39718364,0.30826294,0.2059711,0.084519533,-0.012262579,-0.11260081,-0.22445103,-0.30017905,-0.43459095,-0.45112894,-0.49746412,-0.58930278,-0.59213331,-0.69445706,-0.52367964,-0.35536177,-0.18664234,-0.018362324,0.11195359,0.30867571,0.46803102,0.5994959,0.65341849,0.82403492,0.99522211,1.1677906,1.339506,1.5024972:1
0.40604571,0.29799034,0.18009448,0.098619816,0.090276588,-0.0065186284,-0.10667736,-0.18628437,-0.27210433,-0.36046614,-0.41683556,-0.45091219,-0.34293934,-0.23269356,-0.19614928,-0.249034,-0.37201973,-0.50754234,-0.62850058,-0.71535908,-0.78109462,-0.82825912,-0.87178403,-0.91897471,-0.97259306,-1.0234099,-1.0887439,-1.1153537,-1.1423083,-1.1758304,-1.2007841,-1.2114795,-1.2178611,-1.204013,-1.1663467,-1.1052211,-1.0711039,-1.0031199,-0.92328349,-0.83819729,-0.77118327,-0.6657448,-0.58196333,-0.49645525,-0.40994139,-0.32830852,-0.23911146,-0.14882717,-0.073114496,0.0094283673,0.092427853,0.17486891,0.27319731,0.35469636,0.42897839,0.50614489,0.55772988,0.51328871,0.58475433,0.56096855,0.54178088,0.52539015,0.53362531,0.54646637,0.51330087,0.4611196,0.44020668,0.4490703,0.46314284,0.46883278,0.48049378,0.48655166,0.48957176,0.50207647,0.53712804,0.6006531,0.68461031,0.78921935,0.8996752,0.9915707,1.0552075,1.1224766,1.2018778,1.239886,1.2768473,1.3175339,1.3553153,1.3928324,1.4269831,1.4635468,1.4862052,1.5145619,1.5310468,1.5276359,1.5035493,1.4815004,1.4792455,1.5369137,1.6466875,1.7532051,1.8565162,1.9658984,2.0735874,2.1788786,2.2764383,2.3856347,2.4525519,2.4106987,2.3154548,2.2177946,2.1060118,2.0057029,1.8920761,1.7805542,1.6735088,1.5557861,1.4503448,1.3189503,1.2946015,1.2794706,1.2394892,1.2012855,1.1560229,1.0952465,1.0310207,0.98449821,0.94569016,0.91723705,0.88106226,0.83622147,0.79372684,0.74799979,0.70133417,0.656446,0.62319457,0.58164638,0.54342051,0.50188257,0.46452396,0.40330632,0.35884304,0.33381192,0.32138221,0.31095978,0.2771379,0.27545265,0.2678188,0.22741507,0.16776584,0.10881441,0.065526331,0.024940854,-0.049665677,-0.16892491,-0.27849378,-0.34584734,-0.38144048,-0.41224052,-0.44924393,-0.48075103,-0.50396405,-0.51251591,-0.52841866,-0.53691491,-0.54288696,-0.53264279,-0.51816989,-0.50192017,-0.47782352,-0.43937791,-0.38551624,-0.32891935,-0.27796719,-0.21996509,-0.24517159,-0.37431155,-0.3992821,-0.36569645,-0.31442445,-0.2597968,-0.20761054,-0.17939508,-0.25585664,-0.34067774,-0.4325005,-0.52909747,-0.64855293,-0.73593652,-0.8264556,-0.9103658,-0.99586711,-1.0937019,-1.1780725,-1.2657729,-1.3648333,-1.4594333,-1.5699436,-1.6816715,-1.7975114,-1.887304,-1.9659278,-2.0057766,-1.9968982,-1.9662962,-1.9080394,-1.8393479,-1.761545,-1.6921978,-1.6230113,-1.5428271,-1.4517425,-1.3598156,-1.2715865,-1.181984,-1.091145,-1.0035512,-0.91192993,-0.81151848,-0.70931205,-0.60251761,-0.50137726,-0.39286579,-0.27970461,-0.1669524,-0.11940276,-0.23634438,-0.34843898,-0.44394905,-0.42314871,-0.34402218,-0.21693791,-0.10910092,0.018014836,0.12889347,0.24359026,0.35098317,0.3736201,0.50031293,0.61902712,0.72993674,0.74157238,0.6318196,0.52165028,0.40818102,0.28636597,0.17467706,0.064815718,-0.043343866,-0.00563353,-0.033275932,-0.14461298,-0.25940914,-0.37424165,-0.48721284,-0.60420456,-0.70463783,-0.82019788,-0.92991233,-1.0341098,-1.1339231,-1.2351079,-1.3376975,-1.4326162,-1.5160721,-1.5370949,-1.504314,-1.4287431,-1.318848,-1.2109849,-1.101076,-0.97176569,-0.86706978,-0.74710382,-0.58883652,-0.45253696,-0.31690732,-0.18036186,-0.042275383,0.096262066,0.23477475,0.36569337,0.29734384,0.39497438,0.51794657,0.65694354,0.79463339,0.9536073,1.0022518,0.87484154,0.74870488,0.62715244,0.52788427,0.43357214,0.34765031,0.27077749,0.20914533,0.16242671,0.18680155,0.24788006,0.34072039,0.44347275,0.55558477,0.66333029,0.78388369,0.90289182,1.0183038,1.1541303,1.2600561,1.3980694,1.386881,1.2789503,1.1784753,1.1368101,1.1992801,1.3036039,1.4125864,1.5116981,1.6084328,1.7181274,1.7309635,1.8215479,1.7281728,1.6149621,1.6042878,1.5801728,1.4709815,1.3464024,1.2370026,1.1120403,0.98946551,0.85307605,0.79105744,0.81790062,0.91051909,1.0196465,1.1280186,1.2473635,1.1899014,1.0617356,0.94361558,0.82129114,0.70963864,0.62409806,0.71236391,0.60725136,0.48190193,0.36975142,0.25050569,0.14072056,0.015379156,-0.10046142,-0.22204597,-0.31087785,-0.44701734,-0.53946622,-0.62153223,-0.71852892,-0.77270602,-0.78490092,-0.74837914,-0.67776741,-0.59278408,-0.5219375,-0.4357112,-0.3222943,-0.20115283,-0.082527353,0.019233736,0.13557586,0.25573407,0.37938444,0.49249944,0.52671809,0.41567207,0.30538224,0.19345462,0.078222509,-0.026628617,-0.12883961,-0.22988746,-0.3348505,-0.32596416,-0.22577852,-0.33808541,-0.34304869,-0.33802112,-0.45293201,-0.56348594,-0.67825104,-0.79868812,-0.91187346,-1.0210899,-1.129991,-1.2441311,-1.3469193,-1.4499522,-1.550233,-1.6378753,-1.7368837,-1.8226552,-1.9034256,-1.9819373,-2.0484958,-2.1164278,-2.1535808,-2.1601164,-2.076971,-1.9763028,-1.8648589,-1.7398998,-1.6027066,-1.4466402,-1.3092623,-1.1737249,-1.0408399,-0.91241414,-0.78258968,-0.66146495,-0.58195061,-0.61904358,-0.54309624,-0.40843007,-0.25267379,-0.11383305,0.028720202,0.18067852,0.33581865:4
0.90658914,0.84865919,0.76893464,0.69563821,0.61710067,0.54452859,0.44278569,0.35002169,0.26153496,0.16923193,0.077429694,-0.016171126,-0.087638286,-0.17770705,-0.26012634,-0.32796401,-0.43632432,-0.52601566,-0.61504382,-0.70998887,-0.79731759,-0.90383839,-0.99073738,-1.1005151,-1.1888052,-1.2811703,-1.3633863,-1.4433129,-1.5267687,-1.6083692,-1.7148616,-1.7693387,-1.6612109,-1.5518919,-1.4682721,-1.3590808,-1.2499769,-1.1630176,-1.0516086,-0.96543604,-0.8563784,-0.74680249,-0.6359793,-0.54086956,-0.43872491,-0.32765857,-0.21975971,-0.12868988,-0.037995179,0.047905713,0.12683704,0.21196009,0.30396422,0.39154954,0.4763183,0.55766177,0.63656632,0.69024359,0.70870809,0.76839995,0.83549714,0.90747512,0.94434183,0.92404201,0.91073476,0.88781284,0.8942661,0.9688895,1.0448339,1.0819981,1.0621142,1.0296811,1.00205,0.96675751,0.94992774,0.89520767,0.88450305,0.83667672,0.81725763,0.78098851,0.82879244,0.86524837,0.90303556,0.91168998,0.91519922,0.90069768,0.83350343,0.75027806,0.6844347,0.60899988,0.57753371,0.4880179,0.4106065,0.32017219,0.23869294,0.16315672,0.062616492,-0.035249939,-0.11866177,-0.20230074,-0.28723716,-0.37735988,-0.46177079,-0.5298679,-0.5971484,-0.66415355,-0.72830437,-0.79573257,-0.78578617,-0.86310507,-0.84885212,-0.81788161,-0.76874807,-0.71238804,-0.64078422,-0.55716405,-0.52666533,-0.46670139,-0.39659493,-0.33807609,-0.29523205,-0.23950563,-0.18098873,-0.1208077,-0.079794983,-0.10788438,-0.15885454,-0.22445059,-0.30131596,-0.39022013,-0.43778061,-0.48116241,-0.55950941,-0.62827267,-0.72509519,-0.79201845,-0.8262176,-0.91924781,-0.97366728,-1.0305842,-1.0876793,-1.1378097,-1.2223041,-1.3363639,-1.4243615,-1.5024975,-1.5750699,-1.6056642,-1.7065185,-1.7500857,-1.8309613,-1.8899614,-1.9168327,-1.9626784,-1.8713611,-1.7725804,-1.674628,-1.5939895,-1.4982259,-1.3989661,-1.3014226,-1.2127007,-1.1104642,-1.0304772,-0.932933,-0.83825826,-0.74942637,-0.65247786,-0.56378119,-0.47750252,-0.37345957,-0.28145926,-0.22867952,-0.13822828,-0.037005104,0.019547782,0.1130386,0.20924146,0.29205264,0.38828764,0.48882753,0.58064906,0.67180412,0.76374223,0.85837422,0.94937236,1.0408985,1.1376413,1.2335998,1.326042,1.42196,1.5149813,1.6070238,1.7089647,1.7962528,1.8880392,1.9838383,2.074931,2.1440291,2.1557173,2.1380094,2.1698861,2.1844089,2.091314,1.9992644,1.8937947,1.8029499,1.7079225,1.610105,1.5132748,1.4267838,1.3268396,1.2386314,1.1360807,1.0513646,0.95613117,0.86259956,0.76932657,0.67968838,0.5855392,0.48778431,0.39544967,0.30629389,0.21432966,0.12320899,0.029062117,-0.06106128,-0.15809465,-0.25241119,-0.34555787,-0.42679362,-0.52157506,-0.62004458,-0.70806608,-0.80170631,-0.89300911,-0.97842263,-1.0773522,-1.1605463,-1.2543136,-1.3448099,-1.4398524,-1.5191017,-1.6196505,-1.7105958,-1.8036853,-1.8899319,-1.9793425,-2.0749911,-2.0480314,-1.9678296,-1.8869795,-1.7616982,-1.6686584,-1.6050218,-1.5361327,-1.4475155,-1.3820347,-1.3071145,-1.2343233,-1.1593468,-1.1048154,-1.0706721,-0.968042,-0.88379588,-0.85448508,-0.78483069,-0.70319265,-0.67935505,-0.6183759,-0.58186482,-0.51569666,-0.42385924,-0.34352518,-0.26995663,-0.2463096,-0.19380033,-0.19732399,-0.19938071,-0.25501526,-0.3366967,-0.42220399,-0.512736,-0.58070401,-0.66900171,-0.78705467,-0.89338353,-1.0047994,-0.97824435,-0.94462056,-0.8644381,-0.77619797,-0.67898882,-0.57835935,-0.4881953,-0.48011295,-0.39188407,-0.32214305,-0.26797112,-0.17760588,-0.086767693,0.0087264602,0.10497287,0.19716982,0.30581165,0.39248442,0.47634212,0.56878281,0.66418857,0.77364999,0.87817141,0.89081036,0.84478931,0.77466816,0.74870251,0.75034445,0.80610705,0.89060347,0.96675426,1.0235151,1.1201383,1.1918616,1.2327793,1.2705699,1.325449,1.3693103,1.3816802,1.4226938,1.3620054,1.2929216,1.2229023,1.1553114,1.0813763,0.99778494,0.91703066,0.8438726,0.81929948,0.81202274,0.73256101,0.65858681,0.56735477,0.47335503,0.3938256,0.30095099,0.21394074,0.18349668,0.12436462,-0.0085258463,-0.14092381,-0.24634203,-0.35534204,-0.4432793,-0.5537071,-0.64473454,-0.73242354,-0.81215703,-0.86296411,-0.9706774,-1.0751642,-1.1790856,-1.2600013,-1.3280048,-1.2591357,-1.149744,-1.0442375,-0.97439485,-0.86272011,-0.77416139,-0.67359526,-0.5913913,-0.49894605,-0.41019701,-0.34483186,-0.26282893,-0.18552345,-0.10270951,0.002131581,0.086266084,0.17516283,0.2679014,0.35129385,0.44022745,0.53055206,0.61482678,0.69549101,0.77942003,0.86016176,0.93717434,1.0240124,1.0480631,0.99833268,0.95784639,0.91553514,0.88585781,0.86045737,0.89117141,0.96886714,1.0548942,1.1348355,1.1963616,1.218971,1.2582508,1.3121332,1.3489784,1.3493209,1.3708217,1.4393377,1.4443738,1.4020619,1.3617014,1.362194,1.365229,1.3142612,1.2415606,1.1901602,1.1095748,1.0151288,0.9658449,0.8772024,0.790065,0.74049682,0.73186739,0.77574552,0.81176909,0.85178301,0.90343561,0.93611694:5
1.7020335,1.6234529,1.5319498,1.4387563,1.3520919,1.2685361,1.1999174,1.1202543,1.0435835,0.97791903,0.93894559,0.89191013,0.79106866,0.69380599,0.59446905,0.48750834,0.39285183,0.27495457,0.18337064,0.098470876,0.043880573,0.034149778,0.10724674,0.19569736,0.29505935,0.39283236,0.49066298,0.58903397,0.68828271,0.78437951,0.8016089,0.67718286,0.55619898,0.43944921,0.31930325,0.20125763,0.092858631,-0.027763199,-0.13331691,-0.24678173,-0.35446599,-0.46332622,-0.57535382,-0.6800433,-0.78708891,-0.89178276,-0.99724705,-1.1009802,-1.2019054,-1.3059626,-1.3857152,-1.4585035,-1.4158652,-1.2987163,-1.1882571,-1.0778171,-0.96705287,-0.86129109,-0.75243664,-0.6376525,-0.52670131,-0.41345409,-0.29364318,-0.17071844,-0.046863732,0.080684083,0.20960001,0.33886225,0.48110708,0.56364871,0.49501037,0.39761862,0.3060238,0.22186708,0.13918139,0.059092224,-0.018406186,-0.093699562,-0.16732004,-0.24181648,-0.32187822,-0.3838725,-0.43967446,-0.4905611,-0.55607241,-0.64002457,-0.73047872,-0.81410726,-0.89367553,-0.97525651,-1.0533493,-1.1244637,-1.1972682,-1.2601645,-1.3183252,-1.377864,-1.4360598,-1.494467,-1.543072,-1.6028325,-1.6559278,-1.6210562,-1.5272078,-1.4149138,-1.3033734,-1.2027179,-1.126154,-1.0254625,-0.9149737,-0.80280965,-0.72141845,-0.60709643,-0.48919684,-0.38731086,-0.28065623,-0.1622259,-0.061119325,0.055068916,0.15898851,0.25556748,0.36878445,0.48956584,0.61241946,0.69760265,0.81839595,0.94032862,1.0651673,1.1683911,1.2286636,1.3321942,1.4539076,1.5409175,1.6636724,1.7579002,1.8532886,1.9591253,2.0564163,2.1334982,2.2033571,2.2202759,2.1810907,2.113405,2.0237373,1.9710591,1.907922,1.8623962,1.7646038,1.6796856,1.6215588,1.5302317,1.426994,1.3236927,1.2719705,1.1615671,1.0449361,0.94328446,0.85369775,0.73826047,0.61709373,0.50688252,0.38296503,0.26774002,0.15318421,0.036647796,-0.069273595,-0.12266617,-0.16815744,-0.27341741,-0.37796324,-0.44011324,-0.53320553,-0.61515228,-0.69759458,-0.79637497,-0.9071362,-0.98605441,-1.0990332,-1.2056852,-1.3005397,-1.4126813,-1.5177965,-1.6276211,-1.6178774,-1.529907,-1.4572845,-1.3378553,-1.2133165,-1.097468,-0.9682075,-0.86574725,-0.75709069,-0.68734744,-0.66340752,-0.6939012,-0.67367778,-0.60530631,-0.51044632,-0.37687493,-0.28933853,-0.20950394,-0.13194538,-0.089038107,-0.041071145,0.014940434,0.074919868,0.15625972,0.25314393,0.33661103,0.31239928,0.26922806,0.23507732,0.20159638,0.19607755,0.17300378,0.14694371,0.14685512,0.11616005,0.1033831,0.074717768,-0.039819275,-0.14348253,-0.25555776,-0.36683604,-0.48328629,-0.59237148,-0.68921243,-0.68604689,-0.6036577,-0.55407148,-0.4676737,-0.37643434,-0.28770876,-0.17957821,-0.077600043,0.017646554,0.12228278,0.22294434,0.32709458,0.42927745,0.52636537,0.62343604,0.71837508,0.81730128,0.91335487,1.0189021,1.1188677,1.1647016,1.0753125,0.96671225,0.85601421,0.74845139,0.6403475,0.55098396,0.56431368,0.61647789,0.73712438,0.84752946,0.95296534,1.0559449,1.0684912,1.1080972,1.1707559,1.2297248,1.2863393,1.3776612,1.4884957,1.5845178,1.5634855,1.4517171,1.3334606,1.2271379,1.1253319,1.0214355,0.92210333,0.8251366,0.72875555,0.62808519,0.51056216,0.39938211,0.2930248,0.21435248,0.13650433,0.037409051,-0.065141624,-0.17195947,-0.30487381,-0.43375046,-0.56709504,-0.71662898,-0.85393716,-0.98271525,-1.1265742,-1.2629664,-1.3697951,-1.503261,-1.6301144,-1.7277662,-1.7835944,-1.7491308,-1.7007351,-1.6353214,-1.5555057,-1.4629376,-1.3633285,-1.2581327,-1.1516793,-1.020904,-0.90096035,-0.79082256,-0.66136434,-0.54841639,-0.42620673,-0.30410091,-0.18064625,-0.062904826,0.035243118,0.13910986,0.24356973,0.34838873,0.44346498,0.43606289,0.38396961,0.34802505,0.35642598,0.41618919,0.52256282,0.62699951,0.73395488,0.83233092,0.91605306,0.97994314,1.0662341,1.1538753,1.2443557,1.3353556,1.4324495,1.5345033,1.6405468,1.7410902,1.6952491,1.5780559,1.454516,1.3329061,1.2163136,1.1186385,1.0464109,0.98237454,0.86552667,0.74633728,0.62651133,0.51092317,0.40069038,0.30889204,0.30636378,0.33050542,0.36626436,0.43431885,0.45109381,0.34577782,0.23849072,0.12872328,0.023755409,-0.083208197,-0.1896378,-0.30016914,-0.4073935,-0.51291564,-0.624145,-0.73351266,-0.84397881,-0.94968037,-1.0566555,-1.1647983,-1.2748649,-1.3825296,-1.4938199,-1.6105792,-1.7210577,-1.8303031,-1.9380134,-2.0414609,-2.1519091,-2.254667,-2.2620895,-2.1277831,-1.9949883,-1.8637986,-1.7224786,-1.5814169,-1.4563346,-1.3302541,-1.2002636,-1.0694804,-0.9537713,-0.97997086,-1.0385519,-1.0620523,-1.0439238,-0.95507077,-0.85311832,-0.76741788,-0.6780824,-0.64968584,-0.6814283,-0.63152494,-0.52595305,-0.48186746,-0.42402216,-0.30661027,-0.16929816,-0.050772741,-0.014688808,0.053933643,0.15825965,0.29034507,0.39454695,0.51178534,0.63764463,0.7381319,0.83526586,0.94941922,1.0707637,1.165763,1.2797019,1.383554,1.5008664,1.6336519:5
1.7675849,1.6692188,1.7708328,1.7503912,1.67814,1.6090708,1.588819,1.5099495,1.4858978,1.4264202,1.4293764,1.4022639,1.3235786,1.2870673,1.2545736,1.193826,1.1212729,1.1104226,1.0198504,0.94634013,0.86179776,0.76615851,0.68677337,0.6850756,0.58987306,0.59688002,0.59239907,0.50837948,0.63884022,0.75722754,0.8169785,0.91613889,1.0011113,1.0552058,0.96233179,0.88928991,0.86662464,0.80796139,0.73976693,0.69012995,0.64096427,0.60124575,0.54902516,0.51381493,0.56433451,0.47003696,0.40900477,0.34127712,0.33272911,0.39709528,0.50756771,0.59916341,0.67216927,0.70304155,0.73572113,0.82709827,0.75213766,0.82877076,0.80743969,0.75554532,0.69837405,0.61590445,0.54727828,0.47946598,0.40581364,0.35232007,0.30283767,0.21955194,0.21087107,0.16674215,0.14686702,0.16013504,0.1844889,0.21545395,0.18722124,0.10759599,0.092384484,0.046909234,-0.071441059,-0.13523979,-0.29002406,-0.41288104,-0.48932169,-0.5532509,-0.72396053,-0.79814856,-0.92061444,-1.0392835,-1.1529848,-1.3381094,-1.5204067,-1.7068294,-1.8254183,-1.8441736,-1.7599966,-1.6827118,-1.5809455,-1.4643746,-1.3581012,-1.3127857,-1.2010556,-1.067868,-0.96621054,-0.83516966,-0.7090245,-0.59648553,-0.52690174,-0.42382371,-0.29914912,-0.14332078,-0.065861085,0.047289197,0.18938444,0.31537362,0.4335561,0.55800748,0.70951877,0.83257528,0.99624582,1.10568,1.2523245,1.3917034,1.4735139,1.5086495,1.6553016,1.768372,1.9087627,2.0638153,2.1938856,2.3273744,2.3592197,2.3740345,2.3389999,2.2021399,2.0829107,2.0098399,2.0077048,1.9575424,1.8893802,1.7683032,1.6334782,1.4924642,1.3480101,1.2170751,1.0733014,0.92245904,0.79750232,0.65081312,0.51543778,0.39025245,0.25098996,0.17082926,0.054738351,-0.091926572,-0.22734777,-0.37503605,-0.51031134,-0.64491841,-0.78747986,-0.91536994,-1.0350192,-1.1672148,-1.3122236,-1.3138431,-1.2824839,-1.4128092,-1.4836381,-1.6287153,-1.7452503,-1.8929601,-2.0019392,-2.1233996,-2.2426415,-2.2685594,-2.2253423,-2.1204434,-2.0684719,-1.9904999,-1.8804006,-1.8298757,-1.7334554,-1.6655894,-1.5986008,-1.5557268,-1.4614537,-1.4156558,-1.3261171,-1.278238,-1.2246538,-1.1654775,-1.1468249,-1.0882333,-1.0730245,-0.99119866,-0.9685574,-0.93314417,-0.88313481,-0.86427179,-0.81900458,-0.70306227,-0.66625058,-0.77184053,-0.81900458,-0.80885397,-0.7659344,-0.69000341,-0.81332506,-0.76617289,-0.82524887,-0.85206137,-0.86622024,-0.74233477,-0.7004782,-0.75364646,-0.86133089,-0.89096182,-0.92477466,-1.0314239,-1.0971155,-1.0179355,-0.91422414,-0.95982743,-1.0409532,-1.1351347,-1.2128623,-1.2634258,-1.1811918,-1.149954,-1.0544046,-1.1182618,-1.2326472,-1.3704001,-1.473559,-1.5653048,-1.5214951,-1.4594866,-1.3836684,-1.4217779,-1.3763905,-1.2765644,-1.2773599,-1.2038115,-1.1617878,-1.0793778,-1.0669513,-1.0829176,-1.0709708,-0.94276955,-0.82613538,-0.8356761,-0.7855414,-0.65401947,-0.65487163,-0.70486262,-0.57016215,-0.44274539,-0.35686292,-0.3190827,-0.19726233,-0.07418069,0.073811337,0.20806604,0.34011533,0.46962339,0.59031311,0.73681686,0.77655735,0.86009435,0.97327235,1.0807809,1.241784,1.2367579,1.1451862,1.0571311,0.96802471,0.88430525,0.80505834,0.72943161,0.65536814,0.544097,0.46256538,0.41761965,0.38072886,0.22264732,0.074018712,-0.0068639692,-0.11155384,-0.2555755,-0.24934849,-0.33653082,-0.51661195,-0.62885335,-0.60439766,-0.47267876,-0.4157552,-0.47691838,-0.40457638,-0.36484656,-0.34805095,-0.37258925,-0.3887304,-0.24042732,-0.17434112,-0.14751756,-0.14466682,-0.17043988,-0.030818084,-0.053394804,-0.063021426,0.0098463542,0.13585066,0.24035232,0.29188243,0.18170105,0.056451321,-0.036732568,-0.17869505,-0.28556786,-0.40822231,-0.4610483,-0.42562702,-0.53028041,-0.6400539,-0.70933261,-0.62649109,-0.74462338,-0.81622098,-0.75458144,-0.80544135,-0.90976541,-0.96249553,-1.0633397,-0.92759132,-0.98830868,-0.97251945,-0.94137333,-0.90720159,-1.0304408,-0.98774184,-0.86867682,-0.74775278,-0.64359417,-0.60728095,-0.5085802,-0.38011342,-0.26373751,-0.16297645,-0.047068367,0.065740533,0.17297079,0.11412637,0.10650577,0.2248238,0.34428858,0.45901384,0.55447435,0.61810163,0.75325807,0.8894662,1.0003498,1.1091295,1.0051876,0.88674555,0.87104065,0.9664262,0.9247077,1.0021186,0.89928447,0.79448786,0.78323689,0.71898903,0.62990635,0.5639993,0.51273378,0.45717447,0.44796387,0.38506056,0.28078405,0.24337287,0.17513313,0.10931357,-0.020914316,-0.12099571,-0.20071652,-0.30705918,-0.14588146,-0.018231541,0.094139896,0.20408779,0.30979781,0.34620468,0.44525634,0.53944007,0.59478643,0.69006243,0.6990828,0.75306725,0.83273063,0.78941963,0.71107611,0.71882864,0.73550218,0.64849052,0.57577129,0.44961601,0.41115698,0.3465915,0.26709674,0.17392416,0.11008284,0.090445846,0.23062962,0.37140105,0.48005334,0.61550589,0.74616985,0.88678526,1.0177101,0.96794036,0.958943,1.0950558,1.0986907,1.2305842,1.3682924,1.4753824,1.6075045,1.7405227:1
-0.032914586,-0.08444335,-0.10863199,-0.14505486,-0.22328169,-0.30320023,-0.38188361,-0.46607065,-0.45881036,-0.49570242,-0.58608289,-0.56690299,-0.65872299,-0.63241301,-0.68635965,-0.71999698,-0.7736227,-0.82309064,-0.90488838,-0.93916179,-1.001759,-1.1208327,-0.97525669,-0.83145115,-0.68337013,-0.5519604,-0.41481082,-0.40810948,-0.39780335,-0.4938823,-0.50427489,-0.46679354,-0.55888707,-0.45829997,-0.54726593,-0.63706618,-0.68999866,-0.60240126,-0.64145262,-0.69867276,-0.74709959,-0.75223343,-0.78296966,-0.83705912,-0.88005424,-0.95959962,-1.0355245,-1.1596158,-1.060128,-1.0226041,-1.090647,-1.1870756,-1.2021126,-1.2308874,-1.2904425,-1.3717494,-1.4351157,-1.5185929,-1.6215213,-1.721612,-1.7983254,-1.8809416,-1.9794545,-2.1322165,-2.2185002,-2.2884998,-2.3748872,-2.3062792,-2.1515345,-1.9981059,-1.9858184,-1.8628912,-1.706926,-1.5451352,-1.4201767,-1.2573663,-1.1175655,-1.0428352,-0.91652644,-0.78434694,-0.66872103,-0.51358372,-0.38613305,-0.22087481,-0.095713455,0.059776865,0.21803059,0.32005339,0.44279443,0.39214412,0.56546181,0.71455902,0.87786689,1.0246755,1.0656443,1.1726248,1.1928331,1.2974085,1.3687337,1.499063,1.559569,1.6780053,1.8012584,1.7930025,1.8707916,1.999854,2.0714596,2.0499667,2.1882317,2.3223499,2.4155832,2.5389008,2.5601727,2.5271472,2.4836718,2.4258737,2.3444746,2.2832875,2.1873104,2.0526779,1.8930446,1.7661972,1.6220048,1.4551812,1.3152736,1.1897803,1.0332304,0.90540749,0.76098408,0.65947031,0.53059046,0.41094969,0.29037275,0.12974127,0.0042104329,-0.15431241,-0.28263065,-0.38797426,-0.49863138,-0.65776467,-0.75314188,-0.82464216,-0.95195716,-1.0750001,-1.1955787,-1.3536974,-1.4942222,-1.605085,-1.7883894,-1.9446471,-1.9410854,-2.1006213,-2.2344376,-2.3137011,-2.2287782,-2.1040864,-2.0006235,-1.8682357,-1.7521202,-1.6508603,-1.5999041,-1.5033275,-1.4603285,-1.3633997,-1.3423004,-1.2622026,-1.2205577,-1.129133,-1.0846635,-0.97657471,-1.0174552,-1.1472211,-1.2319096,-1.125831,-0.99779634,-0.88812998,-0.80715725,-0.75305897,-0.69177048,-0.57836324,-0.46506012,-0.39984849,-0.32610102,-0.28625066,-0.27548813,-0.20804775,-0.162169,-0.19945326,-0.11711336,-0.034871172,-0.084209852,-0.22060526,-0.35881053,-0.48772626,-0.55406456,-0.45043779,-0.38014771,-0.29307613,-0.24595057,-0.14853316,-0.091725063,-0.059172686,-0.0084110516,0.068037058,0.11008306,0.16097111,0.14490799,0.20017654,0.28286151,0.33311415,0.41698863,0.48053975,0.55428014,0.62113264,0.63022563,0.52322958,0.36156731,0.23488797,0.15697524,0.083038058,-0.030122891,-0.16491317,-0.30307714,-0.44981418,-0.52172091,-0.41010928,-0.33116827,-0.23730985,-0.14276888,-0.060681891,0.0061932622,0.10468206,0.17775774,0.27931431,0.33187186,0.34058674,0.45034751,0.55736729,0.63398053,0.74020384,0.80861256,0.90661812,0.87966903,0.96929089,1.0047896,1.0576879,1.1384377,1.2413215,1.3494162,1.4467274,1.4757406,1.3098528,1.1744275,1.0170997,0.91105222,0.84597546,0.68282014,0.5806821,0.42990655,0.27243175,0.1266881,-0.033958007,-0.15279836,-0.055217395,0.051207255,0.15898075,0.24680404,0.33664682,0.43863329,0.41351441,0.55863321,0.68824835,0.80398608,0.84864119,0.93479655,1.0060385,1.1315511,1.2313333,1.3700001,1.4733337,1.4096804,1.3426935,1.2114704,1.131971,0.99710201,0.86703339,0.74294218,0.61877609,0.489429,0.37252929,0.24731476,0.11226819,-0.012388593,-0.15556496,-0.22387687,-0.097811088,0.035654658,0.15629992,0.30066724,0.40957453,0.53041128,0.63185059,0.72406498,0.59723783,0.68570919,0.7809586,0.9328422,0.89763351,1.0499013,1.1373238,1.1673968,1.0678526,0.94766259,0.91263678,0.78979719,0.68669121,0.56211215,0.4670665,0.57806327,0.49936003,0.38957649,0.26199851,0.16627346,0.039238758,-0.11182176,-0.23156775,-0.35268199,-0.50012384,-0.62714153,-0.7463507,-0.61439158,-0.47654805,-0.35877051,-0.23344909,-0.10956137,0.016028695,0.11521405,0.27299529,0.2823086,0.40403162,0.53238006,0.63477298,0.75028147,0.84529507,0.86504806,0.97237714,1.1094987,1.2414508,1.3508819,1.5049592,1.4832124,1.3847564,1.2519001,1.1385843,1.0752424,0.95483184,0.92711525,0.92196941,0.76961256,0.63997501,0.54945345,0.58488249,0.48521491,0.31829608,0.1901221,0.07962681,-0.052038826,-0.083418902,-0.23569064,-0.40221231,-0.54559265,-0.67149945,-0.79002999,-0.9035607,-0.93735584,-0.79335744,-0.66994737,-0.53769788,-0.39360956,-0.27135726,-0.17840503,-0.055514089,0.08082375,0.093341657,0.23922835,0.36986292,0.50098712,0.58738477,0.71513979,0.85669759,0.95781076,0.90421077,0.78413982,0.69388585,0.58869975,0.50231598,0.41684013,0.29886243,0.19580776,0.072433043,-0.039761843,-0.17244114,-0.080665903,-0.089117956,-0.20010424,-0.30626205,-0.42468214,-0.50169966,-0.55247888,-0.65869821,-0.75335152,-0.87704816,-0.9550256,-0.76888135,-0.63322367,-0.45254564,-0.29775895,-0.27919704,-0.17299159,-0.050217515,0.018372848,-0.012878734,-0.0072612776,-0.02500039,-0.035329147,-0.072806267,0.0057516358:1
0.40826298,0.32101001,0.20950825,0.12275178,0.010684809,-0.074551179,-0.18472705,-0.27445997,-0.3267532,-0.39200866,-0.503927,-0.59126385,-0.67879079,-0.79003294,-0.87700415,-0.98805565,-1.0963419,-1.1861968,-1.2605725,-1.3700848,-1.4591313,-1.5485938,-1.6184195,-1.6904743,-1.7595562,-1.8337827,-1.8914184,-1.9620567,-2.0173295,-2.0580334,-2.0879076,-2.0930132,-2.0724454,-2.030249,-1.980858,-1.9247374,-1.8586233,-1.7861456,-1.7176675,-1.6520238,-1.5813511,-1.5122557,-1.4390953,-1.365467,-1.2934697,-1.2241554,-1.1441594,-1.0638329,-0.99508937,-0.922783,-0.84547435,-0.7668855,-0.69083143,-0.61219403,-0.53422624,-0.45270534,-0.37867594,-0.30565307,-0.22976263,-0.14717326,-0.066840409,0.010919697,0.08480402,0.16017408,0.24367031,0.32397668,0.39731294,0.47966242,0.55395074,0.63788485,0.71367982,0.76735133,0.69105944,0.60481102,0.52749136,0.44390497,0.3782967,0.29804433,0.23419958,0.19425122,0.1753238,0.16609128,0.16801589,0.18888958,0.18924731,0.24479538,0.33638012,0.4207004,0.50512994,0.59533998,0.67980886,0.75797224,0.83878228,0.92863592,1.0177993,1.1043704,1.1798632,1.2654879,1.3507563,1.4226922,1.3728924,1.3378523,1.3210765,1.4078549,1.505687,1.6072577,1.706016,1.8035253,1.8734455,1.959203,1.8980432,1.7944,1.7077032,1.6179298,1.5297834,1.4518069,1.428292,1.4084662,1.3355557,1.2487481,1.1705531,1.0918328,1.0101407,0.93199028,0.85655977,0.78209209,0.7049084,0.62778528,0.55985022,0.49215091,0.42307184,0.36142469,0.30135976,0.24899282,0.20339946,0.1661411,0.15199096,0.1644492,0.2012308,0.25552083,0.32823824,0.41890743,0.50191062,0.5861736,0.68665487,0.77495365,0.69975458,0.6129945,0.52581233,0.43826545,0.35141075,0.29546496,0.25184271,0.16564388,0.054512728,-0.031269229,-0.11695786,-0.2024102,-0.28770903,-0.37297373,-0.48354172,-0.57216397,-0.67884887,-0.76273495,-0.84406991,-0.93052256,-1.0137588,-1.0964813,-1.1776547,-1.2416687,-1.3130286,-1.3792433,-1.4446165,-1.5204798,-1.5939442,-1.6556835,-1.718768,-1.7833557,-1.8493429,-1.8885104,-1.9366015,-1.9757577,-2.0083692,-2.0212926,-2.0341884,-2.0269719,-2.0074008,-1.9737125,-1.9202282,-1.8360912,-1.7345318,-1.6495073,-1.5606852,-1.4821724,-1.3985539,-1.3226363,-1.2437153,-1.159544,-1.0855858,-1.0077959,-0.92764075,-0.85618978,-0.77953884,-0.69713982,-0.62044923,-0.53907498,-0.46211099,-0.38144404,-0.30246488,-0.22025224,-0.14616868,-0.075931612,0.0063435446,0.077470245,0.15473986,0.24700275,0.31880217,0.40863044,0.49570375,0.46818984,0.40471448,0.3287658,0.257215,0.19258863,0.12749832,0.062066259,-3.1401605E-4,-0.057112588,-0.11555595,-0.16853408,-0.21927,-0.2656461,-0.30805503,-0.34157954,-0.38099317,-0.41989413,-0.45205364,-0.48362545,-0.51340827,-0.53661551,-0.54708371,-0.5602196,-0.58747427,-0.60639425,-0.62981402,-0.63967967,-0.64067867,-0.64190627,-0.64262268,-0.64284312,-0.62488226,-0.6155404,-0.59103883,-0.56362063,-0.51670369,-0.46912489,-0.40942597,-0.34498246,-0.26964777,-0.19397665,-0.12076104,-0.032532002,0.051280251,0.15605968,0.22465895,0.30099558,0.37030642,0.46057861,0.52400909,0.59641004,0.66540495,0.73129548,0.79140303,0.77810462,0.75504485,0.77070863,0.86003217,0.88607429,0.89480674,0.90992979,0.92983937,0.96603316,0.99833924,1.0341822,1.0673694,1.1062136,1.1367975,1.1576226,1.1883332,1.2231988,1.2610694,1.2827388,1.3106104,1.3417277,1.3759587,1.3876497,1.4133792,1.4427246,1.4663631,1.4964392,1.5185463,1.5350166,1.5524604,1.567074,1.5803188,1.592749,1.6065409,1.6057759,1.6193776,1.6410636,1.6805951,1.7705504,1.8635048,1.8076417,1.7186429,1.6441695,1.5655303,1.4898114,1.4295352,1.3637536,1.3147854,1.2939966,1.2783279,1.2705545,1.2573427,1.2308037,1.2137113,1.1743279,1.130321,1.0873679,1.0365419,0.99715611,0.94887166,0.90297099,0.86509916,0.82201726,0.78163334,0.74079446,0.69980297,0.66168705,0.62129034,0.58768176,0.56005217,0.53145813,0.50343727,0.47311054,0.44549195,0.43233195,0.4294859,0.43013712,0.43484935,0.44101893,0.43827592,0.45487103,0.46134463,0.48060641,0.49784884,0.49575574,0.47878333,0.50085822,0.53488583,0.52431349,0.46176703,0.40255736,0.34748978,0.27567224,0.21149589,0.14341588,0.072036646,0.010559402,-0.056583349,-0.12170427,-0.18665156,-0.23017529,-0.28117927,-0.34841071,-0.42414796,-0.5130402,-0.6224709,-0.68351541,-0.73831096,-0.7819216,-0.82369548,-0.86893346,-0.89550657,-0.91537025,-0.93293697,-0.94438818,-0.95808248,-0.97513232,-0.98134442,-0.98611564,-0.9943113,-0.9877963,-0.97936712,-0.95765832,-0.94754697,-0.93669133,-0.91018322,-0.88613327,-0.84987409,-0.82440326,-0.78727405,-0.75254056,-0.71409434,-0.67793213,-0.6263703,-0.57086574,-0.50898475,-0.44552047,-0.3842949,-0.32179163,-0.26571234,-0.20066463,-0.13194953,-0.058635907,-0.10057375,-0.17883975,-0.20929811,-0.15569673,-0.10176509,-0.035602808,0.03958925,0.11588212,0.19499338,0.28432922,0.37926222:4
2.6428146,2.5450397,2.4416267,2.3308845,2.2354909,2.1364154,2.0319607,1.9258796,1.8306246,1.7262337,1.6458754,1.5416813,1.4384293,1.3374161,1.2333043,1.1286572,1.033962,0.92720906,0.83829773,0.73506117,0.62747281,0.52080289,0.41239357,0.29751464,0.18592105,0.075226688,-0.032078335,-0.1465039,-0.25479643,-0.37428099,-0.48489789,-0.59939549,-0.71206996,-0.81958119,-0.93863539,-1.0585772,-1.1687663,-1.2904191,-1.4025531,-1.499333,-1.6114053,-1.5472979,-1.4740271,-1.4192908,-1.3233061,-1.2510552,-1.151005,-1.160788,-1.0614436,-0.98173585,-0.94546505,-1.0360461,-0.99201533,-0.91013239,-0.8534279,-0.7516518,-0.68153735,-0.601144,-0.4891226,-0.46798603,-0.38370409,-0.35332852,-0.38169813,-0.33752669,-0.24403707,-0.11829044,-0.012179217,0.090606174,0.16965748,0.259805,0.32767992,0.43834711,0.50859246,0.5802428,0.61881706,0.70054091,0.78635536,0.85808957,0.77993522,0.65582187,0.5082843,0.39663109,0.29500199,0.20742583,0.095687944,0.041684367,-0.062900857,-0.15957292,-0.24359776,-0.35259403,-0.43904216,-0.53124407,-0.65700324,-0.7604152,-0.89551896,-1.004063,-1.0570555,-1.1051685,-1.1054361,-1.0945467,-1.2027832,-1.1916722,-1.1026666,-1.0480793,-0.96737115,-0.87632713,-0.77647268,-0.67794686,-0.58491349,-0.49487562,-0.42600578,-0.32635707,-0.22564891,-0.11850648,-0.024711963,0.068858885,0.16084266,0.26182739,0.35842691,0.4536664,0.54762538,0.63829513,0.73642739,0.77709779,0.68283344,0.60254201,0.51353571,0.41563478,0.42981006,0.50131015,0.60394902,0.6709424,0.7094568,0.80954856,0.90882571,0.93836886,0.94787707,1.0591499,1.1558448,1.2122167,1.2884264,1.4037367,1.5046291,1.425215,1.3279985,1.2293122,1.1353743,1.044223,0.94753382,0.87311552,0.78114046,0.67510077,0.57116711,0.47431397,0.39132156,0.34733662,0.34429497,0.22825872,0.10564776,-0.005657306,-0.12329222,-0.2397625,-0.36557682,-0.43313217,-0.46934192,-0.56808399,-0.66722226,-0.75941231,-0.86699564,-0.98089236,-1.0690004,-1.1722034,-1.2476724,-1.2718183,-1.3265245,-1.3890953,-1.4750142,-1.5682256,-1.6885428,-1.778207,-1.8974645,-2.0141064,-2.1178818,-2.2247247,-2.3241755,-2.2317788,-2.13092,-2.0480339,-1.9455969,-1.8209708,-1.707094,-1.5963726,-1.5525539,-1.4855999,-1.4037421,-1.2893916,-1.1945454,-1.1272487,-1.0472957,-0.92302613,-0.77670513,-0.66153132,-0.52235619,-0.3867067,-0.25429874,-0.13498926,-0.032253858,0.042158386,0.11958769,0.25559868,0.3815869,0.48386528,0.46508429,0.40386793,0.35691899,0.31216119,0.31617216,0.38637146,0.50139484,0.59577682,0.68249416,0.7587713,0.85660807,0.92843622,1.0209428,1.1145694,1.1886153,1.2926271,1.3979339,1.4962928,1.4372384,1.3157067,1.2195747,1.1436232,1.05266,0.9795386,0.97814253,0.94046538,0.83204849,0.72022595,0.626426,0.51796949,0.41459511,0.40187676,0.43967829,0.48996113,0.55724338,0.60026636,0.49504665,0.3922888,0.28830704,0.18957567,0.08929392,-0.013534855,-0.12041737,-0.22163417,-0.32832509,-0.42654989,-0.52966645,-0.63102403,-0.73231848,-0.83498557,-0.93211493,-1.0302053,-1.1296357,-1.2280071,-1.3236505,-1.4075185,-1.378332,-1.2923249,-1.2180857,-1.1095083,-1.0010342,-0.90481412,-0.8088983,-0.70694572,-0.59463202,-0.48459597,-0.3847464,-0.27240051,-0.16364745,-0.052341328,0.05494527,0.17347059,0.2610968,0.26538964,0.32292957,0.4324509,0.52853448,0.64015816,0.72896893,0.82168462,0.89947453,1.0191666,1.1056256,1.2035341,1.3217542,1.4153688,1.3698422,1.2621932,1.1725193,1.0887623,1.0163111,0.95215945,0.8757831,0.85811026,0.8133094,0.72938246,0.65884177,0.57757696,0.49725818,0.41098018,0.40718314,0.46709271,0.54670253,0.63484375,0.73295787,0.82020462,0.80663022,0.69252786,0.60595704,0.47171056,0.35907382,0.24184027,0.16475384,0.1152821,0.048173664,-0.019798735,-0.12632799,-0.19671563,-0.29069574,-0.30456505,-0.34409985,-0.44520892,-0.56179614,-0.67482574,-0.77388325,-0.85958287,-0.96005968,-0.9287577,-0.82692975,-0.72767384,-0.6208676,-0.52232715,-0.41762648,-0.31727671,-0.21631831,-0.11214661,-0.013189595,0.090633317,0.1985891,0.30273155,0.40657835,0.51214823,0.61932512,0.59624312,0.49005653,0.39252595,0.28769235,0.20384548,0.11214632,0.0058830885,-0.073363922,-0.1741855,-0.27537284,-0.36948672,-0.45991685,-0.48817867,-0.55039628,-0.59717085,-0.68944431,-0.75042097,-0.82775534,-0.91726489,-0.98211383,-1.0053298,-1.0819925,-1.1370626,-1.2101508,-1.2776948,-1.336517,-1.4036892,-1.4758259,-1.5486544,-1.6330314,-1.7178964,-1.6723342,-1.6028249,-1.4970922,-1.3934006,-1.2846459,-1.1699827,-1.0604572,-0.94199865,-0.83158493,-0.71486321,-0.60305396,-0.48766873,-0.37653896,-0.26055875,-0.15138911,-0.03928396,0.073138457,0.18164867,0.29771402,0.40647215,0.51668403,0.6235349,0.73066571,0.84088788,0.94726249,1.0544562,1.1617578,1.2709875,1.3735115,1.4770971,1.5803331,1.6862426,1.7900445,1.8945163,1.9975928,2.1028452,2.2060544,2.3089326,2.4125467,2.516642,2.5946987:5
2.1118556,2.0223231,1.9283097,1.8272797,1.7392712,1.6362187,1.5449539,1.437437,1.3511153,1.2503708,1.157029,1.0491153,0.96046172,0.85872232,0.75597403,0.635482,0.54148518,0.48454056,0.44297209,0.42922782,0.43458393,0.41161562,0.41930714,0.40735983,0.40202115,0.37863516,0.35305983,0.32253447,0.28453457,0.26258276,0.23714647,0.21762018,0.18964421,0.1678162,0.15337888,0.13214525,0.10753771,0.10139918,0.092831311,0.084990991,0.080018709,0.077136043,0.084300529,0.094400393,0.063537458,-0.0053874738,-0.028014765,-0.030957861,-0.0091520911,0.014493762,0.037578316,0.04977885,-0.019334023,-0.09041756,-0.1334378,-0.17924911,-0.23306226,-0.30775065,-0.3866654,-0.46026591,-0.5151576,-0.5810162,-0.65582099,-0.74799388,-0.83665079,-0.91846725,-0.98910616,-1.0520116,-1.0857273,-1.1057483,-1.1119809,-1.1208661,-1.1206568,-1.1055097,-1.0699332,-1.0347525,-1.000913,-0.96394207,-0.91985768,-0.88447652,-0.8448906,-0.79531253,-0.74883786,-0.69606872,-0.64481015,-0.58899116,-0.52967454,-0.46205035,-0.39642948,-0.32718169,-0.252854,-0.18009294,-0.10834107,-0.1103115,-0.078560941,-0.0086049578,0.071722119,0.15164492,0.23910962,0.29840487,0.19616522,0.10860948,0.018608189,-0.075243452,-0.17909857,-0.25007036,-0.33653608,-0.41824545,-0.50947584,-0.59380444,-0.6820434,-0.7689371,-0.86327404,-0.95205417,-1.0462868,-1.141058,-1.2379927,-1.3435225,-1.447831,-1.550703,-1.6553751,-1.7672379,-1.8669472,-1.9675355,-2.076508,-2.1267652,-2.1313836,-2.1170625,-2.0912059,-2.0645005,-2.0302843,-1.9673564,-1.8821122,-1.7844562,-1.6952052,-1.5907434,-1.4886689,-1.380526,-1.2671695,-1.1664713,-1.0612894,-0.97113371,-0.86770967,-0.77089412,-0.67887014,-0.56175951,-0.45211428,-0.35053885,-0.24597006,-0.14466139,-0.023372378,0.079299203,0.1823409,0.28508014,0.39086835,0.45418808,0.47979859,0.4806544,0.56413571,0.68220649,0.78120396,0.9026362,0.98753542,1.0943418,1.2048155,1.1283008,1.0417528,0.95878822,0.90122868,0.8204521,0.73350507,0.65596654,0.58606673,0.51830061,0.47080754,0.41822236,0.37643003,0.334851,0.30014381,0.29021504,0.32563584,0.39057752,0.47039419,0.55195685,0.62873192,0.70989927,0.79050746,0.86743375,0.95669409,1.0360355,1.1193615,1.2016102,1.2901036,1.373931,1.4473868,1.5338908,1.6022214,1.6757712,1.7449104,1.7780723,1.692943,1.5867657,1.603202,1.6846309,1.7652956,1.8425537,1.9274374,2.0234275,2.0868107,2.0014095,1.9008713,1.805703,1.718263,1.6545799,1.7264245,1.7796916,1.6903478,1.5880081,1.4696298,1.3549893,1.252891,1.1692214,1.0670717,0.96683547,0.86420857,0.76169756,0.65756113,0.557562,0.45533715,0.3430379,0.24485396,0.20587035,0.19712413,0.20226421,0.23692224,0.30659693,0.38338743,0.46103677,0.53898099,0.62716311,0.71362081,0.79808157,0.88061829,0.96177862,0.94837139,0.85930544,0.77266553,0.67987319,0.59319991,0.50664663,0.4206538,0.32775702,0.23782684,0.18068774,0.17594182,0.25436445,0.1925821,0.11096673,0.021775493,-0.069135934,-0.15353957,-0.24571289,-0.33273249,-0.4175598,-0.50626125,-0.5967052,-0.67607854,-0.76735197,-0.85213422,-0.94161825,-1.0261355,-1.1153192,-1.2043445,-1.2853665,-1.3712,-1.4546982,-1.533046,-1.6168866,-1.7024924,-1.7812714,-1.8593332,-1.9379328,-2.0092656,-2.0735039,-2.1197564,-2.1496771,-2.1445653,-2.1152562,-2.0694516,-2.0109437,-1.9296038,-1.8559537,-1.7701271,-1.6815474,-1.5748271,-1.4701414,-1.3665077,-1.2457171,-1.138872,-1.0449582,-0.95132818,-0.87692,-0.8021813,-0.71019545,-0.64379946,-0.58778012,-0.58319665,-0.48593788,-0.38119384,-0.2652521,-0.16450821,-0.042063619,0.047365143,-0.018958096,-0.096438764,-0.18390915,-0.26790048,-0.34140166,-0.40522971,-0.44969127,-0.49493509,-0.53350132,-0.54762798,-0.51782846,-0.43408684,-0.3441691,-0.31985606,-0.40525919,-0.47076393,-0.52960603,-0.5831392,-0.63298461,-0.67650544,-0.71859797,-0.75990679,-0.79280181,-0.81543314,-0.84788162,-0.87077252,-0.89170758,-0.90644849,-0.92010506,-0.93710762,-0.94828446,-0.95773524,-0.96416599,-0.95089783,-0.93078306,-0.91190527,-0.88249644,-0.84725054,-0.80973336,-0.75472331,-0.65971356,-0.54122902,-0.4530084,-0.38408402,-0.31189963,-0.24884626,-0.18455344,-0.12295757,-0.049548235,0.021398772,0.098114419,0.16768868,0.2437766,0.3136412,0.38164872,0.44942072,0.48373732,0.45700486,0.42785988,0.40086481,0.43225459,0.42989563,0.42148774,0.41234705,0.3997467,0.39639199,0.40387354,0.41203398,0.42201246,0.43451938,0.45099734,0.47365393,0.49246038,0.50761689,0.53303681,0.56107207,0.57965774,0.61625223,0.64750687,0.67866016,0.7180837,0.74884995,0.75964044,0.78015062,0.80496859,0.82659765,0.87689344,0.94285782,0.86112206,0.77630004,0.70633662,0.60680365,0.50174733,0.39722935,0.29114605,0.34415364,0.44255601,0.54157285,0.63518557,0.73300711,0.8316343,0.92731056,1.0255076,1.1217254,1.2121006,1.3170187,1.4117906,1.5116377,1.6002325,1.7054855,1.7920666,1.8957899,1.9880283,2.077045:4
0.86641082,0.8164395,0.7515828,0.68268826,0.62502753,0.57128087,0.52493741,0.4683122,0.38955628,0.29683532,0.20152516,0.11045605,0.041108442,-0.047438656,-0.13878336,-0.23155266,-0.35472215,-0.45598136,-0.56658049,-0.6460788,-0.70495041,-0.74687809,-0.7733844,-0.79222672,-0.78609602,-0.78217117,-0.769409,-0.75063519,-0.73435614,-0.70522428,-0.6711032,-0.63037432,-0.60292534,-0.55174154,-0.49531843,-0.43294522,-0.36715014,-0.29994894,-0.22339245,-0.2201383,-0.30604802,-0.3112606,-0.24007103,-0.16483215,-0.078144307,0.0015883494,0.088910426,0.17666603,0.27544073,0.37751402,0.40046016,0.29928148,0.19101202,0.10421123,-0.0051966642,-0.0967868,-0.18453461,-0.27418576,-0.37232706,-0.44688886,-0.48547843,-0.58910558,-0.66809077,-0.75460935,-0.83447274,-0.92336865,-1.0113036,-1.1012554,-1.1931568,-1.2889048,-1.3840741,-1.4565476,-1.5488514,-1.6579811,-1.7797516,-1.8670557,-1.9462364,-2.0025107,-2.0329868,-2.0656178,-2.053224,-2.0475442,-2.0232299,-1.9823006,-1.9268436,-1.8473038,-1.7613585,-1.6713021,-1.5872092,-1.4645568,-1.3697935,-1.2580963,-1.1509352,-1.0707278,-0.95784471,-0.85826938,-0.73043721,-0.62830874,-0.49960693,-0.39820091,-0.26842722,-0.16245779,-0.030899016,0.075208777,0.085491274,0.083216079,0.1896111,0.29434496,0.41519205,0.5319355,0.63827291,0.66905786,0.58715664,0.49603913,0.41718784,0.33215964,0.23564687,0.1522085,0.070769757,-0.0035711135,-0.079039467,-0.14369925,-0.20889651,-0.26026525,-0.29294153,-0.28433934,-0.24910174,-0.19381049,-0.11361782,-0.034361942,0.054002056,0.14502,0.23813737,0.32262425,0.40193053,0.49318454,0.58043902,0.66335223,0.75839792,0.85286492,0.93707498,1.0251808,1.1152437,1.2249449,1.3316981,1.3131691,1.2503322,1.2385912,1.3075591,1.3927519,1.4797414,1.568344,1.6565356,1.7518146,1.8335253,1.9342924,2.0295696,1.9640138,1.8650525,1.7828694,1.6870119,1.5825179,1.487415,1.3837203,1.2902815,1.1832926,1.0803272,0.97497297,0.86772924,0.77336721,0.73071007,0.73964904,0.81315671,0.89672107,0.97383758,1.060953,1.1530593,1.246799,1.3301371,1.3794146,1.2903685,1.2011226,1.1077338,1.0115651,0.92820365,0.82999972,0.74394762,0.64653814,0.55154586,0.45745672,0.36123871,0.26519654,0.16920225,0.076258696,-0.01375694,-0.10391304,-0.20028809,-0.30077544,-0.39549902,-0.4873162,-0.58422776,-0.68359846,-0.77297603,-0.86455862,-0.96727089,-1.0519537,-1.1462843,-1.2401842,-1.2672811,-1.2483423,-1.211693,-1.1645348,-1.1178167,-1.0562528,-0.96279738,-0.87918871,-0.787395,-0.66630412,-0.56669382,-0.45501669,-0.35388559,-0.29185169,-0.16530807,-0.060836721,0.04614263,-0.0030499713,-0.12631781,-0.21755909,-0.32959062,-0.41950398,-0.51413833,-0.60568932,-0.70026146,-0.78776787,-0.77032027,-0.71541058,-0.78465678,-0.8840295,-0.98386445,-1.0703862,-1.1598864,-1.2470536,-1.3387712,-1.426416,-1.5240523,-1.6069792,-1.702037,-1.7853359,-1.8558895,-1.9353298,-2.0056013,-2.0607145,-2.1193048,-2.171244,-2.1991826,-2.21048,-2.227193,-2.2393592,-2.2172475,-2.1846389,-2.0978752,-2.0008918,-1.9060706,-1.8218385,-1.7268962,-1.6258201,-1.5445232,-1.4478749,-1.3543851,-1.2601334,-1.1794529,-1.0970495,-1.0243385,-0.91223765,-0.818775,-0.72562036,-0.61098579,-0.49827458,-0.393423,-0.28194199,-0.20279214,-0.099665524,0.010464138,0.12793101,0.23119909,0.32271427,0.34771059,0.24805832,0.16811973,0.066555579,-0.0088809439,-0.071089386,-0.12506134,-0.18174532,-0.21950741,-0.23560402,-0.18288476,-0.07841461,0.0067579428,0.031586871,-0.069300398,-0.12678743,-0.19980521,-0.2633447,-0.31712282,-0.36546395,-0.40403313,-0.42225715,-0.4455451,-0.46203864,-0.4702846,-0.4839021,-0.50227424,-0.51395411,-0.52428326,-0.53167311,-0.51873235,-0.51056849,-0.50557655,-0.48832975,-0.44704733,-0.41596171,-0.36649217,-0.31767087,-0.2449885,-0.17853683,-0.087034501,-0.0068016815,0.080463468,0.14101834,0.19064774,0.24327191,0.29685299,0.34314818,0.40157475,0.45433746,0.51794906,0.58008349,0.63727901,0.6805123,0.72678896,0.76972928,0.80900368,0.84300315,0.85185512,0.85068911,0.84466482,0.85206668,0.8554649,0.85680712,0.87797809,0.88812985,0.9029316,0.92267164,0.94386474,0.97687993,1.011343,1.0455912,1.0743398,1.0994511,1.1262067,1.164297,1.2017929,1.2460535,1.2786249,1.3061544,1.3384994,1.3849608,1.4130984,1.4401603,1.4646579,1.4900615,1.5282899,1.5914342,1.6779015,1.615095,1.5261381,1.4057026,1.3967181,1.4532727,1.3807364,1.3550918,1.3267842,1.3091208,1.2940235,1.2808021,1.2594555,1.2421502,1.2170791,1.1882122,1.1605547,1.1300779,1.0892081,1.0482516,1.0179483,0.97599508,0.94761171,0.88264387,0.88386403,0.85872341,0.82314817,0.79679567,0.77886486,0.77350362,0.76430751,0.76175827,0.75983854,0.7675713,0.76792342,0.77696253,0.77043529,0.77447156,0.77715398,0.79037246,0.79200269,0.80012493,0.81198409,0.8263734,0.78159489,0.69131936,0.67947149,0.70054699,0.7271528,0.75638403,0.77464578,0.80663551,0.85770989:4
2.6123594,2.4831333,2.3772301,2.2565699,2.1380896,2.0257916,1.9294431,1.8208645,1.7189689,1.6099142,1.5152839,1.3973962,1.3049013,1.1885407,1.0828204,0.98879505,0.94438929,0.91923266,0.89818212,0.8772123,0.86457972,0.84920258,0.8333729,0.81570405,0.80121128,0.77431701,0.74630814,0.71557043,0.67129019,0.61853091,0.56177522,0.5221617,0.4716892,0.41415067,0.35999132,0.30819244,0.25998309,0.22271983,0.19639634,0.16315704,0.13887677,0.1249482,0.09955391,0.073873932,0.062721669,0.061837158,0.061205677,0.071565625,0.070802842,0.0076047305,-0.033559164,-0.075635521,-0.11742947,-0.1649555,-0.22359462,-0.28988154,-0.34619913,-0.40628996,-0.46885086,-0.51988863,-0.57258504,-0.64632418,-0.74537775,-0.83021153,-0.92798434,-1.0085992,-1.088418,-1.1545035,-1.2111103,-1.2345358,-1.2382412,-1.2317313,-1.2155642,-1.2011561,-1.1714681,-1.1353491,-1.101464,-1.0639902,-1.0246057,-0.98097168,-0.93315121,-0.9002412,-0.84961754,-0.79512759,-0.73410018,-0.66873086,-0.59589918,-0.52906924,-0.44429941,-0.36175971,-0.27698022,-0.27556676,-0.37526153,-0.39571671,-0.37318741,-0.33185335,-0.26078837,-0.18293639,-0.10200572,-0.029649484,0.048634458,0.13039676,0.21180202,0.29844731,0.26082156,0.16929169,0.070647838,-0.018364293,-0.11509109,-0.20712892,-0.29621987,-0.35976562,-0.42833815,-0.51982512,-0.61420203,-0.70308441,-0.79896538,-0.89787552,-0.98528455,-1.0843548,-1.1862423,-1.2708805,-1.373035,-1.4697731,-1.5676133,-1.668022,-1.7695748,-1.8636604,-1.9608746,-2.0127541,-2.0711897,-2.0903337,-2.1010947,-2.0741523,-2.0328108,-1.9781345,-1.9122417,-1.8309966,-1.7459306,-1.6556297,-1.5403117,-1.4198866,-1.2951466,-1.1718449,-1.0489507,-0.94933764,-0.82662125,-0.74258765,-0.63237904,-0.52333354,-0.39956954,-0.28730405,-0.17686973,-0.063314596,0.045629102,0.07213853,0.047531937,0.11346181,0.24393011,0.3623563,0.4705744,0.56576006,0.64625994,0.57773408,0.49597354,0.41745443,0.31927566,0.23265273,0.1386088,0.057355285,-0.016878077,-0.089770993,-0.15238096,-0.21437221,-0.25796984,-0.2838764,-0.24857974,-0.20944428,-0.14118924,-0.073305743,-3.9376521E-4,0.085929919,0.18083686,0.2718899,0.36546803,0.46985917,0.57054579,0.68409739,0.80186836,0.93099237,1.0052631,0.97755362,1.0537022,1.1758965,1.2380173,1.2715899,1.3066316,1.2482838,1.1860675,1.1278293,1.070149,1.0924471,1.1759304,1.2699252,1.3835367,1.5144786,1.6168729,1.6635644,1.6181766,1.6952462,1.7654623,1.7161599,1.6168665,1.5200494,1.4256781,1.3323079,1.2356814,1.1731356,1.2744165,1.303413,1.2090741,1.1049327,1.0318914,0.9489251,0.84181179,0.72902612,0.62384399,0.50969374,0.3882797,0.29550189,0.211543,0.099626882,0.011894833,-0.057017937,-0.086879552,-0.095597883,-0.071048326,0.0052767202,0.085389187,0.17937585,0.24230949,0.32016356,0.41609862,0.50297526,0.60326371,0.7007705,0.79191578,0.89454512,0.90899556,0.82018474,0.72440912,0.62565627,0.53492758,0.43953334,0.33994351,0.28700977,0.31341717,0.3816833,0.32617945,0.22672693,0.13072055,0.033484468,-0.066534581,-0.16234189,-0.25253187,-0.35039192,-0.44440884,-0.54530279,-0.63244315,-0.7263718,-0.81769569,-0.90331131,-1.0050471,-1.091012,-1.1892165,-1.2816095,-1.3672587,-1.4547114,-1.5440749,-1.6307919,-1.7122936,-1.7951179,-1.8650546,-1.9295748,-1.9515091,-1.9422606,-1.9096804,-1.8572703,-1.7891667,-1.7019353,-1.6073945,-1.5000879,-1.3916044,-1.2770052,-1.1428154,-1.0315043,-0.9185737,-0.7856911,-0.67489348,-0.5398075,-0.40509572,-0.27050698,-0.16033183,-0.1082071,-0.15817459,-0.091322016,0.027795353,0.15234468,0.21779526,0.32266706,0.36213361,0.2888941,0.22771761,0.13925184,0.057355549,-0.026414507,-0.09866851,-0.16309604,-0.21564555,-0.25563565,-0.22432043,-0.14160716,-0.046013177,0.051805886,-0.054482609,-0.15759712,-0.24332508,-0.31900134,-0.4014086,-0.47565509,-0.54180017,-0.61277219,-0.6716588,-0.72743542,-0.79420593,-0.85232201,-0.90906451,-0.96831177,-1.0155054,-1.0620467,-1.1161067,-1.1510384,-1.1882831,-1.2255834,-1.252177,-1.2750081,-1.2944264,-1.302161,-1.2984009,-1.2956542,-1.2911399,-1.2562286,-1.2014971,-1.1391046,-1.0619263,-0.96990384,-0.8413376,-0.74107888,-0.65861975,-0.5823394,-0.51304939,-0.44156768,-0.37790519,-0.30048117,-0.23056785,-0.15283377,-0.071231134,0.0029941053,0.097931512,0.18221242,0.25844899,0.3369573,0.42390746,0.39666263,0.35251434,0.3370686,0.35726387,0.30416761,0.28068835,0.25610402,0.2414817,0.23392278,0.23764369,0.2316839,0.24214376,0.25353454,0.26198372,0.29743331,0.33337644,0.36277373,0.40980927,0.46034923,0.52308383,0.58267053,0.66116598,0.74284633,0.84830407,0.91730331,0.94152227,0.96954363,0.99483663,1.0140912,1.0484282,1.083396,1.1172593,1.1607005,1.1976265,1.2228065,1.2251626,1.2279485,1.2233054,1.2063802,1.2054274,1.2367788,1.3261377,1.3993277,1.5116311,1.6072402,1.703058,1.8186471,1.9149273,2.02316,2.136515,2.2478271,2.3758204,2.4831781,2.5907561:4
2.5370523,2.4537178,2.37216,2.2915116,2.20512,2.1306709,2.0508376,1.9653609,1.8800073,1.8023169,1.7253814,1.6446121,1.5643121,1.515762,1.459877,1.4146941,1.3688893,1.3208936,1.2623718,1.1939636,1.1248334,1.0573118,1.0002581,0.94884041,0.90835433,0.85353608,0.79173444,0.7473621,0.70292989,0.68596996,0.66118593,0.63684124,0.62231844,0.61340784,0.6056543,0.58653891,0.520247,0.49497853,0.48988387,0.51542973,0.51416178,0.46140894,0.39547589,0.32761786,0.26066716,0.1884347,0.10905358,0.02348069,-0.069379425,-0.16232047,-0.24053773,-0.3161912,-0.38303547,-0.44128756,-0.4867638,-0.51987851,-0.54114007,-0.55469178,-0.5608908,-0.56914562,-0.57514185,-0.58030597,-0.58158179,-0.57933893,-0.56338115,-0.53647848,-0.57705218,-0.58508466,-0.57719597,-0.55438479,-0.52041792,-0.46697833,-0.48083312,-0.55809238,-0.62234311,-0.68556034,-0.75455808,-0.83166465,-0.91039792,-0.99589018,-1.0802454,-1.1615749,-1.2503248,-1.3485663,-1.4290665,-1.4678662,-1.5015762,-1.5375869,-1.5620731,-1.5736945,-1.5599764,-1.514082,-1.4716406,-1.4307438,-1.3658077,-1.2786813,-1.1877744,-1.102771,-1.0362319,-0.98109826,-0.93341727,-0.87756251,-0.80468474,-0.72730373,-0.65052468,-0.5690903,-0.51215285,-0.58639097,-0.63942181,-0.58562077,-0.51891163,-0.44555175,-0.37514473,-0.29969207,-0.23313663,-0.32743633,-0.43921385,-0.54012145,-0.59943405,-0.68875941,-0.77180669,-0.8482001,-0.92097383,-0.99378217,-1.0504553,-1.1057741,-1.1668205,-1.2261083,-1.287636,-1.357154,-1.3958651,-1.4156434,-1.3772665,-1.3234989,-1.2522024,-1.1730983,-1.1093957,-1.0309845,-0.96484977,-0.88685062,-0.81378124,-0.72963045,-0.65214209,-0.569536,-0.47158023,-0.38168682,-0.29585201,-0.20807158,-0.12819385,-0.044110552,0.03736716,0.11549518,0.20453205,0.2779045,0.36606434,0.41939891,0.37091891,0.40301464,0.4735154,0.56305458,0.6418925,0.73364092,0.825122,0.88413478,0.77671041,0.66933007,0.56910941,0.48140466,0.39860876,0.31887437,0.25835092,0.18198627,0.12524515,0.072173252,0.0050635427,-0.04832502,-0.095113309,-0.042932291,0.036712368,0.1206552,0.19789011,0.27850654,0.35661463,0.44215447,0.51765159,0.60297342,0.67982039,0.76032875,0.83770977,0.92185847,0.99766163,1.077782,1.101414,1.1817491,1.266484,1.2983722,1.2145417,1.1301637,1.0734723,1.0882845,1.1658635,1.2489234,1.3289853,1.4099028,1.4970287,1.5789293,1.6434529,1.6002084,1.5205187,1.4341657,1.3585653,1.3464711,1.3506122,1.2672428,1.1873221,1.1045092,1.0260626,0.94299696,0.86431644,0.7829227,0.74489237,0.74744397,0.76936057,0.81320016,0.87084619,0.95599871,0.97041501,0.8832476,0.79510139,0.71585122,0.65615553,0.59816368,0.51272562,0.42729998,0.34247348,0.26105446,0.17924066,0.093338805,0.011747322,-0.069249773,-0.15530605,-0.23560955,-0.31102665,-0.39180853,-0.46269042,-0.52881994,-0.58664346,-0.59425831,-0.57339668,-0.53222327,-0.47494696,-0.42933176,-0.38293425,-0.32626182,-0.27059335,-0.21457672,-0.1468946,-0.077727285,-0.0075300551,0.071113239,0.15914988,0.19685269,0.26966465,0.34520093,0.42119328,0.48949188,0.43724588,0.34692187,0.25755472,0.14203597,0.057905919,-0.033834192,-0.12246608,-0.19459513,-0.2520044,-0.27407667,-0.2515097,-0.34930467,-0.44675296,-0.54396014,-0.64115611,-0.73797207,-0.83481938,-0.93106208,-1.0266825,-1.1069646,-1.1993922,-1.2931907,-1.3782136,-1.4619409,-1.5542054,-1.6453204,-1.7207508,-1.8032937,-1.8716676,-1.9336904,-1.9676747,-1.9707703,-1.9656554,-1.9471532,-1.9085853,-1.8333765,-1.753725,-1.6752856,-1.5961079,-1.510269,-1.4292818,-1.3453266,-1.2633986,-1.182886,-1.0987574,-1.0184395,-0.92938957,-0.85173301,-0.77146353,-0.68285307,-0.59609925,-0.51643445,-0.45938683,-0.38226004,-0.29936931,-0.2140386,-0.1327449,-0.13479538,-0.21942259,-0.30085366,-0.37323049,-0.40177598,-0.46497748,-0.54509017,-0.6116165,-0.66466028,-0.69823768,-0.70586887,-0.70125244,-0.62232366,-0.64085775,-0.7027015,-0.76284732,-0.82467883,-0.87996054,-0.93206746,-0.98034181,-1.0172798,-1.0525967,-1.0902565,-1.1132527,-1.1412917,-1.1701188,-1.1864292,-1.1976667,-1.1929245,-1.1679011,-1.1445972,-1.1104548,-1.0698531,-1.0167817,-0.95600727,-0.88416773,-0.81585939,-0.74915427,-0.67543244,-0.59930314,-0.52058181,-0.43199604,-0.3384245,-0.27349517,-0.21402991,-0.15113154,-0.0902629,-0.025413602,0.032255409,0.085683847,0.15846821,0.2385505,0.31400984,0.41781991,0.51592074,0.62883335,0.56788015,0.51824627,0.46318892,0.40534982,0.37517458,0.40133153,0.4455552,0.48556958,0.51841266,0.55667503,0.58724311,0.59064923,0.62090559,0.65245396,0.65457499,0.63619186,0.6484314,0.70761426,0.73752058,0.80276046,0.87743532,0.95598082,1.0376773,1.0705529,1.1057903,1.1597759,1.1991665,1.2404511,1.2396859,1.2492651,1.2892185,1.3447377,1.4244429,1.5076422,1.5924903,1.6246418,1.6279182,1.7096316,1.7903271,1.8736049,1.951976,2.0370554,2.1163614,2.1794838,2.2364009,2.3126573,2.397394,2.4794993:4
1.8769077,1.7815256,1.6823825,1.5767951,1.4857632,1.3869767,1.2775706,1.1653708,1.0756708,1.0175646,1.018907,1.1114982,1.1519079,1.0783071,0.98966081,0.87855198,0.78426222,0.7010721,0.58399593,0.49398557,0.39948981,0.3010304,0.19968968,0.11029719,0.020773072,-0.073504514,-0.16705477,-0.25381049,-0.36264169,-0.43508133,-0.51392273,-0.55904353,-0.59922081,-0.60866215,-0.61099855,-0.5698865,-0.51135189,-0.4157084,-0.28983669,-0.20203368,-0.073452918,0.056612868,0.18918511,0.28374058,0.41740077,0.5126125,0.64874496,0.75002698,0.847726,0.84863797,0.75067854,0.66936973,0.56453436,0.45952746,0.36147811,0.2789678,0.19784373,0.099374829,0.031641556,-0.016490496,-0.079996253,-0.18014209,-0.2672663,-0.35466145,-0.43854362,-0.51861308,-0.60756514,-0.68831273,-0.76097872,-0.84363068,-0.92447069,-1.0034834,-1.069,-1.151227,-1.2145105,-1.2954163,-1.3547877,-1.4313216,-1.4842066,-1.5519443,-1.6118963,-1.6500132,-1.7185323,-1.7626055,-1.8102421,-1.8618325,-1.8943321,-1.9229187,-1.928723,-1.932776,-1.9298427,-1.8918679,-1.8504371,-1.8005658,-1.7192706,-1.6312705,-1.5304615,-1.4334567,-1.3433426,-1.2521944,-1.154044,-1.0572069,-0.96881779,-0.85573636,-0.7710007,-0.6675906,-0.55999553,-0.45930683,-0.37046009,-0.25075667,-0.16188715,-0.061177892,0.036393775,0.15511155,0.24676645,0.34421755,0.44134363,0.55396186,0.63138788,0.52979549,0.42567426,0.38595018,0.34103159,0.28014867,0.1888412,0.10411679,0.049918162,0.0067499846,-0.035571498,-0.092374798,-0.12061424,-0.15180732,-0.18124149,-0.18411814,-0.18256997,-0.17453397,-0.17288744,-0.17563277,-0.17904338,-0.15876133,-0.17468357,-0.17025944,-0.14020246,-0.11153274,-0.082384914,-0.048698457,-0.01505243,0.010489033,0.04343463,0.091928251,0.13091668,0.18710935,0.26763858,0.39619635,0.48411035,0.56318504,0.65903821,0.75419516,0.85390119,0.92929844,0.90562785,0.86760328,0.86370108,0.86887115,0.88583601,0.90786149,0.92783334,0.94144598,0.95469944,0.96329645,0.97392696,0.9854937,0.97992,0.98990395,0.99609025,1.0106515,1.0164162,1.0105647,1.0070207,0.99466274,0.98238092,0.95545587,0.93805299,0.91300683,0.87901152,0.83967204,0.79512323,0.77272415,0.76096946,0.75736368,0.84311942,0.92073773,1.0234152,1.1079538,1.2105114,1.3048647,1.4064172,1.4901933,1.5957933,1.6920481,1.7803221,1.7079062,1.6284875,1.5168225,1.4187128,1.3280903,1.2232101,1.1305093,1.0380677,1.0650496,1.156799,1.2570372,1.2078789,1.1462732,1.1088633,1.1256517,1.1478948,1.1705637,1.1824515,1.1975266,1.1920013,1.1886088,1.1821213,1.1618045,1.1446604,1.1323761,1.1142685,1.0892685,1.0599474,1.0302731,0.99903056,0.96845429,0.94140227,0.91867504,0.88729833,0.85788925,0.83614671,0.80542028,0.77814116,0.75890976,0.71980024,0.67905564,0.65581397,0.63702236,0.62773681,0.64458052,0.65400382,0.67616648,0.70459027,0.73394738,0.76668676,0.78210785,0.81506971,0.80642032,0.74505897,0.66476789,0.57626671,0.49384494,0.42467451,0.35034967,0.2739799,0.19341457,0.11079081,0.037793171,-0.024803889,-0.10080013,-0.1771921,-0.28838339,-0.42057057,-0.52610101,-0.60761154,-0.68586517,-0.75302184,-0.81317583,-0.85678356,-0.9004015,-0.92783511,-0.96442951,-0.98808757,-1.0054947,-1.0068676,-0.99098955,-0.97279221,-0.94430775,-0.9108051,-0.87324617,-0.8530716,-0.81246936,-0.75811878,-0.70492935,-0.6497792,-0.60516667,-0.56277122,-0.50087796,-0.43005292,-0.36434471,-0.27433837,-0.18299459,-0.10602232,-0.016540779,0.078999524,0.18432099,0.27098726,0.3624129,0.4677402,0.56011804,0.65652031,0.7176748,0.62837065,0.52498899,0.42487729,0.33241536,0.23694532,0.14196335,0.041771293,-0.045457045,-0.15641432,-0.23960705,-0.34502187,-0.39326541,-0.40726604,-0.51757971,-0.50506764,-0.57555936,-0.6689999,-0.76978355,-0.86821505,-0.97339149,-1.0705079,-1.1728484,-1.2668009,-1.3608105,-1.4517345,-1.5398286,-1.646726,-1.7414747,-1.8336183,-1.9355999,-2.0249648,-2.1243426,-2.2269051,-2.3303586,-2.408553,-2.456365,-2.4847707,-2.4792059,-2.4354117,-2.3746792,-2.3069799,-2.2300806,-2.1584808,-2.0980361,-2.0341477,-1.9581164,-1.8756108,-1.7937373,-1.7069883,-1.6175401,-1.5219402,-1.3991924,-1.3147672,-1.229222,-1.1529403,-1.0655046,-0.97072744,-0.87193076,-0.77302636,-0.68255328,-0.58667574,-0.44891095,-0.3520614,-0.25415743,-0.15853533,-0.034362064,0.062512295,0.034847254,0.10929592,0.17865565,0.2822711,0.37925024,0.51794292,0.6156342,0.55347834,0.46600735,0.3348964,0.20185272,0.070572814,-0.016807278,-0.14237166,-0.2324393,-0.35910808,-0.45019985,-0.52801322,-0.58891517,-0.63806609,-0.66202037,-0.6424865,-0.61170589,-0.55408138,-0.47049706,-0.3800664,-0.28311492,-0.19534216,-0.093289327,0.0011304713,0.10037736,0.18693468,0.28547812,0.38625097,0.47775774,0.58654339,0.68432344,0.77360876,0.87921296,0.9841447,1.0632068,1.1653968,1.2768392,1.3810061,1.4814338,1.5753216,1.6629219,1.5995214,1.5865856,1.6738967,1.770644,1.8564697:4
0.42339146,0.37633342,0.33248256,0.28082563,0.23173466,0.17236159,0.1056044,0.045136665,-0.022585551,-0.093254144,-0.17424115,-0.23738804,-0.32230814,-0.40829598,-0.49369953,-0.57902424,-0.68684244,-0.77150237,-0.84484426,-0.91177824,-0.93238435,-0.94562085,-0.93854761,-0.91465976,-0.91057766,-0.86307624,-0.81682703,-0.75843458,-0.71546985,-0.65021129,-0.60846862,-0.55410397,-0.50407018,-0.46133898,-0.41955662,-0.38319174,-0.353372,-0.34130451,-0.34484611,-0.35951258,-0.3733904,-0.40873203,-0.4352772,-0.4871831,-0.5311094,-0.57710182,-0.62446937,-0.66401278,-0.7038095,-0.75167632,-0.78984051,-0.82896844,-0.88098778,-0.9402459,-0.99143496,-1.0639196,-1.1353468,-1.1956315,-1.2651768,-1.335796,-1.4052477,-1.4828874,-1.5530334,-1.6238112,-1.6988356,-1.7693356,-1.8408634,-1.9099108,-1.9696702,-2.0389768,-2.0927321,-2.1304831,-2.1169201,-2.0579298,-1.9788071,-1.9124198,-1.8449708,-1.7795205,-1.7103551,-1.6329337,-1.5616966,-1.4911477,-1.4252878,-1.3665779,-1.2975864,-1.2262208,-1.1403407,-1.0679226,-0.97895431,-0.88934677,-0.80178973,-0.7307851,-0.62981853,-0.57633826,-0.50418927,-0.46821919,-0.41720819,-0.3999009,-0.36625188,-0.35178226,-0.33288133,-0.32378002,-0.31177447,-0.30274783,-0.28803064,-0.27328741,-0.25891924,-0.25034105,-0.23769731,-0.22535322,-0.21194435,-0.19715194,-0.18718326,-0.16865694,-0.145179,-0.11680574,-0.077645583,-0.042457266,-0.030120581,-0.019012786,-0.012013904,-0.011568727,-0.01856004,-0.022442619,-0.069862997,-0.1023862,-0.14332904,-0.13631767,-0.072786273,-0.0021128925,0.069639445,0.14863229,0.22367555,0.30132943,0.37664118,0.45492714,0.54607438,0.6240069,0.70035383,0.77130518,0.84865944,0.92715756,1.0140262,1.0905373,1.1666123,1.2470194,1.3244234,1.401234,1.4837751,1.5679824,1.641598,1.7139033,1.807332,1.8793712,1.9505198,2.0343903,2.1221055,2.2053289,2.2745169,2.3423912,2.3810913,2.40129,2.4081718,2.3942591,2.3524954,2.2662819,2.1832298,2.1156533,2.0359246,1.9537274,1.8762514,1.7983847,1.7210768,1.6440513,1.5673396,1.4890347,1.41107,1.3286468,1.2450171,1.1716258,1.0998522,1.0208238,0.94160627,0.85804696,0.77764411,0.70019702,0.62405676,0.54489465,0.45912754,0.38131187,0.31099311,0.2246423,0.15322363,0.077106652,-0.015571781,-0.058472162,-0.10995146,-0.12603085,-0.15110898,-0.17889746,-0.18107021,-0.12334364,-0.039621166,0.010610289,0.040019759,0.031976506,0.062660474,0.033605438,0.01052601,0.023625378,0.031354545,-0.0075731993,0.036051236,0.010880541,-8.2645902E-4,0.010053976,-0.020523704,-0.042807134,-0.082433769,-0.1246271,-0.14191813,-0.18763324,-0.23730427,-0.28157133,-0.33299938,-0.38881404,-0.45203867,-0.52107335,-0.60790435,-0.69393942,-0.80321421,-0.88456982,-0.98792837,-1.0716188,-1.1376564,-1.1253644,-1.0997262,-1.0695578,-1.0161329,-0.95533819,-0.90625712,-0.88158425,-0.84498201,-0.83486375,-0.80009616,-0.78104675,-0.77053687,-0.73748267,-0.74214022,-0.73060635,-0.72088921,-0.7027978,-0.69451674,-0.67900586,-0.67088431,-0.65084038,-0.65040522,-0.65068736,-0.66166467,-0.68009736,-0.70706157,-0.79073458,-0.85658819,-0.94329756,-0.95646245,-0.96058938,-1.0040356,-1.0851095,-1.1684305,-1.2421106,-1.3268676,-1.4022403,-1.4815755,-1.5572223,-1.6362734,-1.7086413,-1.7539275,-1.7103634,-1.6469758,-1.6887606,-1.6215309,-1.5948395,-1.567178,-1.4747709,-1.3781466,-1.3253239,-1.2717457,-1.2048886,-1.1255874,-1.048149,-0.97400115,-0.89286488,-0.78425289,-0.71398561,-0.61230902,-0.53913266,-0.44243707,-0.36119974,-0.27035084,-0.21297687,-0.14175532,-0.069613215,-0.020920481,0.048990066,0.09696732,0.10002778,0.14663599,0.24597113,0.30686107,0.36559052,0.41238364,0.44259798,0.45664479,0.40359364,0.32062039,0.28332235,0.30541281,0.36117105,0.44643061,0.44278037,0.39906161,0.36400297,0.32123278,0.28552166,0.24479755,0.19925845,0.14757613,0.093467044,0.033776314,-0.021489518,-0.07585147,-0.11613708,-0.15681243,-0.19389837,-0.21147281,-0.23597219,-0.20336303,-0.14186366,-0.079030121,-0.0098681502,0.064523623,0.14618339,0.23718912,0.30575123,0.3961359,0.46815693,0.55661364,0.63812203,0.71734034,0.79362947,0.87437573,0.95187472,1.0276689,1.0994062,1.1673036,1.2352795,1.2998761,1.3661615,1.4263286,1.4924517,1.5529396,1.6122504,1.6643866,1.6813473,1.6705116,1.6495137,1.6280235,1.5946737,1.5651157,1.519334,1.4639037,1.3923643,1.3228787,1.2569971,1.2085691,1.1933669,1.1956273,1.2124961,1.2400097,1.2681022,1.2889792,1.3077111,1.3180729,1.3187322,1.3039778,1.2863706,1.2367808,1.1590527,1.0706851,0.98612199,0.90219873,0.81346119,0.72354492,0.64132034,0.56994516,0.49763061,0.43905203,0.43747054,0.49214045,0.54837203,0.62234212,0.69193309,0.75143987,0.81622041,0.81735714,0.84623356,0.86094727,0.85474809,0.79224709,0.72841472,0.64802229,0.5801402,0.50069742,0.43038847,0.34955899,0.27329189,0.20033686,0.21264771,0.26695748,0.30854048,0.36121726,0.40307163,0.44307601,0.47409678,0.4959258,0.49754303,0.46299268:2
2.8463176,2.7474699,2.6496116,2.5584107,2.4623838,2.3671877,2.2803828,2.1845898,2.0922287,2.0013925,1.9104357,1.8166547,1.7220874,1.6316293,1.5397286,1.445071,1.3479826,1.2578484,1.1659828,1.0758626,0.98411863,0.89326857,0.79721228,0.70717888,0.60673011,0.51593663,0.43298162,0.37613984,0.27611973,0.18986989,0.093279541,0.0031764223,-0.085371696,-0.17406448,-0.27215149,-0.37222357,-0.46084409,-0.55248252,-0.64366601,-0.73394239,-0.84085502,-0.92880496,-1.0179273,-1.1091586,-1.2159943,-1.3093015,-1.3979508,-1.4851316,-1.5740948,-1.6799897,-1.7222553,-1.7965569,-1.843182,-1.7939227,-1.6933613,-1.6284048,-1.554377,-1.5624214,-1.4936924,-1.4237694,-1.4270253,-1.3674957,-1.3202029,-1.2354188,-1.2085945,-1.1474427,-1.106072,-1.0537314,-0.988493,-0.94675262,-0.95575565,-0.9104105,-0.83057384,-0.76457934,-0.69601095,-0.63816506,-0.63087732,-0.70013977,-0.64537705,-0.56915688,-0.52788544,-0.51085322,-0.43918999,-0.39490061,-0.42010887,-0.54231965,-0.66611007,-0.78774066,-0.84886345,-0.76466398,-0.77933166,-0.70860946,-0.63088419,-0.5981615,-0.52310446,-0.45038534,-0.3734429,-0.29336636,-0.23266553,-0.30590752,-0.33871317,-0.25612654,-0.15944612,-0.080024063,-0.0046146384,5.5489121E-4,0.057948219,0.13492003,0.072163811,-0.027858813,-0.11327642,-0.086153491,0.0037648249,0.075830207,0.16602577,0.16419765,0.26626339,0.3759315,0.46616107,0.50479889,0.45846078,0.54779218,0.62989796,0.7028973,0.74128373,0.82795001,0.88988792,0.94932812,0.90052831,0.81130902,0.7239861,0.62687724,0.56408103,0.4710144,0.36515174,0.26622081,0.1754582,0.068041022,-0.011582837,-0.069884135,-0.039604364,-0.036490935,-0.11421646,-0.21944903,-0.32464444,-0.40075765,-0.49906098,-0.51450577,-0.58475051,-0.67749635,-0.77827855,-0.8571162,-0.95861703,-1.0645861,-1.1109327,-1.0487914,-0.98394599,-0.91493295,-0.83040592,-0.73895079,-0.67177199,-0.58381485,-0.54723633,-0.46183183,-0.37643318,-0.36296369,-0.27953497,-0.18554691,-0.14598018,-0.20422572,-0.28347585,-0.23067661,-0.15136064,-0.07080906,0.025754147,0.10963367,0.19891725,0.26668896,0.34751806,0.33711424,0.30578822,0.3899656,0.43068811,0.48777502,0.56600584,0.61153792,0.55049352,0.43827088,0.35155395,0.29775687,0.35776685,0.43588847,0.52690962,0.61354881,0.69084769,0.78939012,0.87959648,0.95577199,0.93755634,0.94807996,1.04585,1.1251551,1.2200011,1.2682018,1.3490158,1.432882,1.4739379,1.5647463,1.6091695,1.5522633,1.4679916,1.3641632,1.3297671,1.2666007,1.1733919,1.0773126,0.99127326,0.89768564,0.80692849,0.87974372,0.92649058,0.88997619,0.79932614,0.70372445,0.62380798,0.5396152,0.49595588,0.40936713,0.32798291,0.24341945,0.19254858,0.26156751,0.33260231,0.40173412,0.44905861,0.49087671,0.5853016,0.64873433,0.57760765,0.49963065,0.43815785,0.35371096,0.27393986,0.18524189,0.18556591,0.21019697,0.13148948,0.042261599,-0.055713287,-0.1557642,-0.24254904,-0.35010003,-0.44668762,-0.46642697,-0.39181142,-0.39045739,-0.46326395,-0.53124481,-0.61592399,-0.70802774,-0.77518407,-0.85279666,-0.92635864,-1.0144869,-1.0937312,-1.1701845,-1.2373684,-1.2637921,-1.1622081,-1.0302554,-0.94246551,-0.86484963,-0.77665741,-0.6862162,-0.55934588,-0.45215115,-0.32169511,-0.24634713,-0.11551644,-0.019672616,-0.011572413,-0.041499758,0.065823686,0.1949396,0.31435342,0.36721295,0.48153276,0.60760448,0.69160218,0.76546514,0.81265391,0.91494447,1.0270704,1.0722871,1.0109545,0.96683833,0.91226244,0.9270747,0.84692373,0.75520356,0.71206639,0.62605845,0.517009,0.52168777,0.58767746,0.53185467,0.42872663,0.34584186,0.24928186,0.19942789,0.12549486,0.025131429,0.034184943,0.11394417,0.19226787,0.27755859,0.31699061,0.23658839,0.14348256,0.081579669,-0.019728625,-0.082378921,-0.18036251,-0.19662632,-0.09420613,-0.13383469,-0.22473787,-0.30470779,-0.39656352,-0.48570675,-0.57674506,-0.64721943,-0.69503698,-0.69922376,-0.59878973,-0.49727534,-0.39857981,-0.2834218,-0.17501745,-0.20162628,-0.26546028,-0.32795141,-0.39622891,-0.44889958,-0.38085518,-0.44822653,-0.53340216,-0.61649381,-0.68146513,-0.7603507,-0.83856708,-0.91671249,-0.96199898,-0.89229797,-0.91801535,-0.98326869,-1.038036,-1.1226409,-1.2086914,-1.2776965,-1.3517791,-1.4057037,-1.458454,-1.5177128,-1.5744133,-1.621985,-1.6714093,-1.744993,-1.7963792,-1.8300598,-1.8305479,-1.8611339,-1.9021095,-1.9262282,-1.9756364,-1.9465479,-1.8483341,-1.7561154,-1.6680046,-1.5830835,-1.4879274,-1.3988809,-1.3090341,-1.2104085,-1.1154713,-1.0243582,-0.93158263,-0.83793916,-0.74742763,-0.66003819,-0.56738011,-0.46975468,-0.37548306,-0.29018266,-0.20021951,-0.10303478,-0.0029559086,0.085105584,0.17610539,0.26957118,0.36566778,0.46249819,0.55184081,0.6431074,0.73697154,0.8408971,0.92762727,1.0185299,1.1076709,1.2007348,1.2916932,1.3868543,1.4793062,1.5757114,1.6676383,1.7581171,1.8500715,1.9439444,2.0394136,2.133456,2.2269048,2.3144924,2.4105016,2.5028044,2.5989595,2.6928208,2.7862192:3
1.8695431,1.8508788,1.8183382,1.7955034,1.7605141,1.7155661,1.6734868,1.6209098,1.5647515,1.4899583,1.4409779,1.3694341,1.3120402,1.2279967,1.1391478,1.0476994,0.97791333,0.9058837,0.83284216,0.74519926,0.67282623,0.65388238,0.64825403,0.66972659,0.69133021,0.72957765,0.773694,0.80361929,0.83727237,0.85517293,0.85336947,0.85213459,0.84396396,0.81945649,0.79606879,0.75281908,0.68438377,0.60733346,0.54421114,0.47901485,0.4057089,0.33551087,0.26069216,0.20999397,0.13909701,0.06819059,0.017774859,-0.050787257,-0.11913665,-0.17421079,-0.23975806,-0.29677417,-0.35562249,-0.42349717,-0.49253952,-0.55876589,-0.62038092,-0.69601087,-0.76050355,-0.824634,-0.88975463,-0.95507887,-1.0239398,-1.082875,-1.1506932,-1.2111948,-1.2358716,-1.216059,-1.1712395,-1.1285146,-1.0644073,-1.0128977,-0.92679004,-0.84226857,-0.78214035,-0.697024,-0.64118709,-0.58244851,-0.52714547,-0.50403295,-0.46822026,-0.39668866,-0.3491827,-0.32167587,-0.31335487,-0.31383828,-0.31039395,-0.30573115,-0.30663768,-0.31331176,-0.33421219,-0.35630381,-0.39099739,-0.41667422,-0.45429754,-0.49124951,-0.5275366,-0.56984594,-0.58425986,-0.61510921,-0.63313902,-0.66244921,-0.68700574,-0.71200008,-0.74145555,-0.77296951,-0.80391625,-0.84429773,-0.86782223,-0.92960012,-0.94626513,-0.99512633,-1.0499421,-1.0966795,-1.1665454,-1.2138083,-1.2747963,-1.3151916,-1.3537749,-1.4070243,-1.4646382,-1.4978615,-1.5147054,-1.4744484,-1.4122026,-1.3483952,-1.3263982,-1.2609703,-1.1922823,-1.1333043,-1.0581392,-0.9977649,-0.9439454,-0.86850116,-0.80590821,-0.73833759,-0.67119403,-0.60746531,-0.54200477,-0.46104872,-0.39353598,-0.35108593,-0.30244788,-0.27205566,-0.23787214,-0.2084154,-0.18629562,-0.17488837,-0.15911696,-0.15173518,-0.1611214,-0.13968103,-0.12773668,-0.10800937,-0.092429356,-0.078047522,-0.069049428,-0.05832233,-0.043873346,-0.025739714,-0.015010827,-0.0043105687,0.017728972,0.036180613,0.065557676,0.085480397,0.109812,0.11085378,0.12527644,0.13998147,0.16811103,0.18278062,0.20660924,0.2388032,0.28008421,0.33672359,0.39277016,0.46676175,0.52547903,0.60729403,0.68797359,0.75698726,0.82556657,0.90157066,0.98893671,1.0592069,1.1332295,1.222239,1.291282,1.3868173,1.4550557,1.5503684,1.6191889,1.6928703,1.7821581,1.8634979,1.9449048,2.0393274,2.1097434,2.175192,2.2017989,2.2168665,2.2021347,2.1812831,2.110958,2.0302218,1.9568139,1.8870458,1.8172027,1.7428305,1.6578605,1.5803062,1.5111858,1.4348265,1.3462372,1.2770303,1.1833483,1.1133457,1.0213908,0.92939053,0.86269742,0.78479947,0.71653097,0.67209346,0.63689573,0.571562,0.48908534,0.46336317,0.44371308,0.43475526,0.42469755,0.4246007,0.47287782,0.51995195,0.53678931,0.52870498,0.5208122,0.50684012,0.4999415,0.50838402,0.51332079,0.51102314,0.5061964,0.49656353,0.48654041,0.45864198,0.42037962,0.38174193,0.3457606,0.28922988,0.24545531,0.1642333,0.10151839,0.037265048,-0.03632294,-0.10143329,-0.16629093,-0.23604639,-0.2924361,-0.36503538,-0.42555379,-0.49969061,-0.54806164,-0.58337984,-0.60743213,-0.65291994,-0.7260396,-0.76408179,-0.79087302,-0.80760937,-0.81456704,-0.81945665,-0.82717604,-0.83671402,-0.84012358,-0.828894,-0.82317315,-0.81907068,-0.80218734,-0.79214768,-0.79257392,-0.7955183,-0.803695,-0.81993529,-0.84651407,-0.87498214,-0.87629439,-0.88132547,-0.89164991,-0.89166734,-0.89159854,-0.88786666,-0.9071766,-0.92386667,-0.952818,-0.99214618,-1.0330419,-1.0864322,-1.1514535,-1.2176918,-1.3006868,-1.3726473,-1.4342491,-1.4997412,-1.5693636,-1.6621247,-1.7075393,-1.7910915,-1.8532341,-1.8968372,-1.9015963,-1.934617,-1.9723158,-2.0131408,-1.9917535,-1.9559093,-1.911258,-1.8525295,-1.7886931,-1.7320516,-1.6684253,-1.6057434,-1.5422139,-1.4751524,-1.4160484,-1.3585178,-1.2930794,-1.2293655,-1.1663084,-1.0938277,-1.0328348,-0.97270078,-0.91889848,-0.84949353,-0.79165031,-0.73385816,-0.67060524,-0.61104639,-0.55071906,-0.49594333,-0.42838242,-0.367049,-0.33628539,-0.32620075,-0.29366537,-0.27180061,-0.22796991,-0.17263008,-0.096004699,-0.024204962,0.032326,0.071982772,0.098054816,0.11191296,0.11238137,0.10229309,0.085703449,0.069434612,0.05372982,0.014866881,-0.036994913,-0.084578066,-0.13484736,-0.18722793,-0.23871398,-0.28406081,-0.34106011,-0.38452467,-0.43547551,-0.47927171,-0.50429905,-0.55206105,-0.56608587,-0.5671153,-0.50503993,-0.4131932,-0.36814927,-0.31202959,-0.25208325,-0.18760922,-0.1132555,-0.042246398,0.030651201,0.099998451,0.19380557,0.28491464,0.374611,0.42831,0.43600901,0.48945834,0.58153415,0.67309019,0.76556557,0.81520604,0.88738882,0.97668379,1.0393266,1.1008821,1.1567444,1.1953245,1.2185757,1.2309444,1.2375602,1.2324156,1.2062724,1.2023021,1.1751056,1.1750257,1.1522328,1.1427935,1.1468962,1.1901679,1.2372547,1.295521,1.3666702,1.4241482,1.4834009,1.548457,1.6153745,1.6655774,1.7189982,1.761062,1.7940772,1.8220976,1.8427355,1.858711,1.8770236:2
1.9607282,2.013255,2.0043787,1.9426637,1.8306454,1.7916106,1.6968264,1.5823921,1.479675,1.3521729,1.2494329,1.1356565,1.0270202,0.91826877,0.79457306,0.71153828,0.59185066,0.47199321,0.36869522,0.27185833,0.17224843,0.069158936,-0.062055294,-0.1723948,-0.26550156,-0.35991539,-0.4706212,-0.58856123,-0.59479678,-0.65927763,-0.65369621,-0.63031183,-0.65839825,-0.70670078,-0.79537777,-0.88337643,-0.99916496,-1.0666315,-1.1564426,-1.24509,-1.3286273,-1.4045404,-1.4937706,-1.5964759,-1.6857241,-1.7805868,-1.8609493,-1.8483017,-1.8077691,-1.8079598,-1.8341776,-1.869056,-1.9229894,-1.9499815,-1.9943584,-2.0255012,-2.0575411,-2.1010929,-2.0983109,-2.0248471,-1.9542275,-1.8586483,-1.7518398,-1.6396938,-1.4936491,-1.3562466,-1.2308866,-1.1438247,-1.0626967,-0.94425318,-0.7817163,-0.68637894,-0.5289548,-0.4212351,-0.31526403,-0.21368582,-0.058079873,0.09668217,0.1957945,0.34176506,0.45801002,0.61498549,0.70040368,0.80174199,0.95064326,1.1048362,1.2168673,1.357946,1.369965,1.3678925,1.3615599,1.3155844,1.27003,1.2027809,1.1056552,1.057461,0.98257801,0.90635772,0.79704666,0.70071901,0.61289638,0.56787153,0.50636439,0.4344503,0.32291035,0.27425811,0.22133851,0.13699558,0.18188208,0.24699876,0.22666263,0.21006114,0.17476875,0.13597314,0.096808337,0.10687688,0.0953564,0.085357623,0.036815607,0.025180871,-0.025484444,-0.021665323,0.026531179,0.14787044,0.19096503,0.18420275,0.19051287,0.17820807,0.15888305,0.14581471,0.10611621,0.14162715,0.17454129,0.1666499,0.13334758,0.066484894,0.022603754,-0.0090062013,0.011619955,0.11577056,0.13668266,0.083698682,0.056940632,0.016432768,-0.039276306,-0.087047964,-0.13912536,-0.20484101,-0.25310679,-0.2751933,-0.28310063,-0.2869356,-0.27776078,-0.15444369,-0.060527923,0.047200877,0.15218289,0.2707059,0.32883552,0.36966267,0.41996433,0.46079084,0.51080407,0.54975725,0.58418568,0.65398899,0.75679627,0.77771667,0.80277676,0.77229122,0.75529542,0.72930007,0.82394073,0.90208794,0.9342,0.92776816,0.90950852,0.87279949,0.84554197,0.83444362,0.79958916,0.77899,0.78071119,0.76507109,0.72974488,0.80762088,0.89905047,0.943249,0.93597337,0.9104406,0.87101313,0.8102587,0.86049203,0.80988362,0.68575464,0.60850202,0.56798469,0.49751853,0.433429,0.37018523,0.30790917,0.2596714,0.2128275,0.19082335,0.15835609,0.13048108,0.087621822,0.045791584,-0.0019383291,-0.072945633,-0.083646629,-0.0223543,0.096553377,0.18373893,0.24625923,0.30959205,0.34369633,0.39614189,0.42980181,0.4650984,0.49637974,0.52643568,0.58400282,0.61580016,0.66840734,0.70358687,0.75237839,0.78097598,0.81379222,0.84138628,0.88018448,0.91231275,0.9376259,0.9502613,0.97682181,1.0647806,1.1106363,1.1545107,1.2090346,1.2478254,1.2754647,1.2895232,1.2364193,1.151551,1.0917735,1.1167454,1.1483409,1.1755328,1.1955783,1.2155946,1.2326363,1.2207877,1.1431727,1.1065966,1.1216355,1.1379761,1.094835,1.0689283,1.0655074,1.0530389,0.95067213,0.79530888,0.63970465,0.48473347,0.32910518,0.18133335,0.095593268,0.040093488,-0.080391189,-0.073552033,-0.029351713,0.0034607554,0.035179221,0.070294147,0.094550157,0.1375438,0.1712387,0.19450955,0.22557788,0.17777345,0.16947045,0.23618568,0.28887639,0.35469924,0.36567604,0.30354904,0.32412456,0.34960198,0.39267107,0.37761001,0.39835135,0.40242778,0.39646524,0.26511215,0.11057396,2.6755988E-4,-0.047190872,-0.01581551,0.0097057048,0.028718798,0.040642443,0.048396154,0.073687231,0.091670101,0.14587839,0.18087589,0.23601283,0.238042,0.17269371,0.067027519,0.075643298,0.11038155,0.16664559,0.22380913,0.25862449,0.24936461,0.29382613,0.34113538,0.38855295,0.47088192,0.51739862,0.55699787,0.59739373,0.62294507,0.62093054,0.52459237,0.41328421,0.29593803,0.1875202,0.054097249,-0.043817384,-0.12987491,-0.19893882,-0.24094323,-0.35962622,-0.49661832,-0.57961008,-0.73314997,-0.82522522,-0.94374413,-1.0359752,-1.1510448,-1.2676508,-1.3971058,-1.5095348,-1.6178269,-1.7229282,-1.8234954,-1.9405537,-2.0585357,-2.1598947,-2.2478664,-2.3742357,-2.4333938,-2.4262664,-2.393653,-2.3641062,-2.3158992,-2.2695723,-2.2401501,-2.1791724,-2.143277,-2.10055,-2.0462459,-1.9778653,-1.9129069,-1.8493123,-1.7733208,-1.7485946,-1.8255028,-1.8368313,-1.7689275,-1.6978912,-1.6308835,-1.5494937,-1.4569605,-1.36168,-1.2815202,-1.2734255,-1.3227748,-1.2375785,-1.1698969,-1.0914719,-1.0228126,-0.94292521,-0.87778168,-0.81191758,-0.82672954,-0.88622882,-0.92829797,-1.0442793,-1.0830628,-1.086281,-1.026053,-0.95571899,-0.87553111,-0.77974173,-0.68067043,-0.59115466,-0.50446274,-0.41168973,-0.31214134,-0.22604565,-0.11663377,-0.012228694,0.077850101,0.16709387,0.23787742,0.22191381,0.17671641,0.27584075,0.37515333,0.46263114,0.57200778,0.67494033,0.76852721,0.87661508,0.99825076,1.0945629,1.1905208,1.2850694,1.3894685,1.50001,1.5927688,1.6976253,1.7997193,1.9253253:3
0.87727779,0.81439857,0.75198831,0.74766555,0.72361658,0.71474868,0.67820777,0.59276173,0.48658145,0.58848014,0.45402622,0.45823588,0.55552572,0.43523326,0.48800098,0.42033784,0.26944118,0.17480209,0.21389855,0.057508066,-0.093843714,-0.030944236,-0.19703778,-0.20820015,-0.30413551,-0.38306836,-0.4887914,-0.61631813,-0.5992753,-0.76143011,-0.7836469,-0.86557641,-0.97589038,-0.79250657,-0.93254019,-1.047398,-0.93263671,-0.77489533,-0.67053934,-0.64700648,-0.54922572,-0.38189951,-0.19670259,-0.022102294,0.16324229,0.35165468,0.44229357,0.63427206,0.82780514,1.0113536,1.1860186,1.3614445,1.5600401,1.586258,1.4763226,1.3502062,1.2294906,1.1516955,1.0281531,0.99400758,0.95062579,0.8190207,0.95834794,0.93674362,0.88942027,0.7913402,0.74788254,0.65741316,0.51290507,0.39109878,0.24257128,0.12825409,0.050446864,-0.11122848,-0.14873128,-0.21324934,-0.28979495,-0.36195282,-0.33678006,-0.25038284,-0.25297927,-0.11193657,0.063402662,0.17859502,0.41633043,0.24230023,0.44595216,0.6135567,0.50743654,0.4440733,0.31953627,0.25118634,0.12414867,0.072006782,0.0024994762,-0.082433417,-0.17627035,-0.13926488,-0.13593323,-0.24425916,-0.30583507,-0.34126444,-0.33213401,-0.43159785,-0.49830295,-0.54341484,-0.59435739,-0.65447871,-0.63864956,-0.68318982,-0.58432887,-0.42999516,-0.2085385,0.0082772144,-0.011594885,-0.094839491,-0.11530876,-0.11722367,-0.076774942,-0.067028574,-0.14414736,-0.16932898,-0.23544916,-0.30836403,-0.45831924,-0.4811204,-0.54003594,-0.63914262,-0.72284528,-0.74926889,-0.85756999,-0.93755965,-1.0634097,-1.249953,-1.3245633,-1.4729289,-1.5837523,-1.751925,-1.8713184,-2.0079304,-2.1387705,-2.2104283,-2.3061634,-2.4095846,-2.429081,-2.4736518,-2.5094475,-2.3508657,-2.136545,-1.9862807,-1.7770275,-1.5745144,-1.3612635,-1.1811592,-0.96989003,-0.76901422,-0.58987688,-0.3858549,-0.1877117,0.0041332401,0.19515769,0.40300421,0.58378051,0.78379261,0.9811309,1.1417704,1.3635794,1.5640169,1.7660957,1.9548782,2.1388774,2.3616735,2.579463,2.7856678,3.0125578,3.1481556,3.214162,3.2279892,3.0816195,2.8908818,2.6901966,2.4713093,2.2637009,2.0716133,1.8485893,1.6338013,1.4413274,1.2297629,1.0335191,0.82534066,0.62677707,0.41322551,0.21829581,0.0039634162,-0.18967989,-0.38635586,-0.59806014,-0.78242943,-0.98634152,-1.1947202,-1.3879054,-1.5896892,-1.7879106,-1.9211176,-2.1160326,-2.3329416,-2.2466304,-2.1544582,-1.9665515,-1.8402872,-1.7192774,-1.8001923,-1.6549746,-1.4970691,-1.4772982,-1.3297898,-1.1834446,-1.0526824,-0.89021149,-0.76567837,-0.66064333,-0.59281638,-0.47433444,-0.30970707,-0.23197475,-0.18795537,-0.096812599,-0.084508856,-0.033450458,-0.0306404,0.04297802,0.1264377,0.10250327,0.17872556,0.17303561,0.21796897,-0.0018807226,-0.21897426,-0.41154793,-0.38932532,-0.3531704,-0.32147501,-0.2074926,-0.15788449,-0.056219783,0.0017222035,0.06375403,0.15140599,0.24087467,0.22419463,0.21596773,0.35644121,0.31952406,0.39084318,0.4764985,0.47926086,0.50817709,0.55280695,0.63938163,0.64421821,0.48504596,0.30838718,0.12855374,-0.010057489,-0.1951837,-0.37304339,-0.55275915,-0.75185418,-0.80689488,-0.63348053,-0.71370454,-0.58293393,-0.46639017,-0.43159975,-0.36809646,-0.35654294,-0.27272833,-0.18414287,-0.082004795,0.033529895,0.12163597,0.21563105,0.30750194,0.14958756,0.15092395,0.28401188,0.41843758,0.39780814,0.49151734,0.59737318,0.67354233,0.74967789,0.87450576,0.82656756,0.88423946,0.98942593,1.1112091,1.242361,1.1153046,1.2208237,1.3694835,1.4072392,1.4857152,1.4535711,1.253427,1.1143677,1.0618644,0.84392591,0.68992539,0.52448489,0.57620568,0.40195891,0.24092428,0.073954656,-0.14004618,-0.22198776,-0.42472019,-0.57530714,-0.78596045,-0.82667438,-0.69344936,-0.57553084,-0.46475537,-0.34456474,-0.22369835,-0.10806587,0.024285175,-0.083267058,0.060578079,0.18749468,0.32608524,0.45336324,0.58739853,0.71414524,0.58835858,0.67410406,0.81326485,0.93792105,1.0519107,1.141193,1.2785882,1.4059234,1.5843887,1.6908199,1.4888163,1.3412473,1.151226,0.97943799,0.81960148,0.70996124,0.51861708,0.37566832,0.25154166,0.10722201,0.057890067,-0.031090993,-0.10567263,-0.19921541,-0.35862574,-0.55239503,-0.70446289,-0.84035317,-0.92611271,-1.1090975,-1.3043597,-1.2900321,-1.1241241,-0.98360021,-0.79166157,-0.59896578,-0.40294378,-0.22458853,-0.074361621,0.017762279,7.5616621E-4,0.15959904,0.19346326,0.39299779,0.44849846,0.65435358,0.77610129,0.74126086,0.63020243,0.49894231,0.4432253,0.34751585,0.31287309,0.17100718,0.11001649,7.6822709E-4,-0.094876257,-0.26753884,-0.12718922,-0.035996074,-0.15149482,-0.34143027,-0.38760622,-0.57687389,-0.72786644,-0.87922389,-0.96122299,-1.1627772,-1.2469225,-1.3764283,-1.362865,-1.481926,-1.5484272,-1.5090185,-1.3250438,-1.1515475,-0.96215327,-0.79945961,-0.78420768,-0.69443573,-0.49346925,-0.53016254,-0.35868612,-0.17991073,0.043050833,0.20728298,0.19359618,0.38918516,0.45221117,0.55834854,0.69814292,0.72379404,0.77458575:1
2.1369221,2.0522873,1.9087838,1.7146314,1.5393774,1.3580091,1.180143,0.99424039,0.80940803,0.61831562,0.43871205,0.26541387,0.10648615,-0.043021259,-0.23649053,-0.41188361,-0.58508681,-0.76699987,-0.91350511,-1.0996526,-1.2595879,-1.369937,-1.5402613,-1.7062494,-1.8948225,-1.9625399,-1.9898864,-2.1656636,-2.3007925,-2.172918,-2.0979937,-2.015159,-1.8338892,-1.9225554,-1.9323305,-1.7855908,-1.6254071,-1.6039141,-1.5089308,-1.4250613,-1.3989733,-1.3412248,-1.2167047,-1.0662837,-0.9180585,-0.76913195,-0.62977869,-0.52094414,-0.53209967,-0.58786121,-0.59077773,-0.56169355,-0.56968241,-0.41639412,-0.3581472,-0.38019082,-0.27358127,-0.15221256,-0.05785085,-0.039126808,0.022596212,0.090740023,0.1489276,0.19566439,0.21931048,0.26919929,0.3522501,0.3077674,0.30486033,0.28371015,0.14474505,0.059418457,-0.065277245,-0.11352054,-0.16697904,-0.12898619,-0.16002013,-0.13553189,-0.032297417,-0.06255835,-0.019095026,0.016818042,0.056241803,0.043680826,0.13475372,0.13786336,0.14054114,0.15835693,0.20876768,0.32097982,0.39635387,0.4829617,0.52390221,0.4878434,0.39370105,0.27695996,0.16693844,0.14585121,-0.027517754,-0.010801975,0.010546953,0.031865649,0.16788977,0.25585131,0.36843991,0.48962536,0.59936855,0.69870839,0.80235264,0.89669332,0.97598961,1.0313144,1.1012166,1.1077369,1.0986143,1.1194342,1.1075018,1.1443867,1.1071986,1.1462553,1.2875689,1.2676031,1.261942,1.3877379,1.4589216,1.6014955,1.7292867,1.6975173,1.8149826,1.9746154,2.1252334,2.2702983,2.3350701,2.2831063,2.1059822,1.9565931,1.7817405,1.6140179,1.457574,1.3683346,1.2131155,1.0520769,0.87052633,0.72713473,0.55669895,0.41191858,0.45041866,0.3132779,0.17660363,0.0097532926,-0.13168487,-0.26768561,-0.30986344,-0.13185265,-0.0056312309,0.15144323,0.25756888,0.35764407,0.47453638,0.60680627,0.66900811,0.66360415,0.78746706,0.80479608,0.9365406,1.0199053,1.1580875,1.1573278,1.2308885,1.189838,1.2003115,1.2056526,1.23053,1.2028228,1.1541229,1.0952633,1.0379036,0.9266858,0.78040185,0.63649503,0.60343455,0.51999984,0.39424401,0.28481462,0.13767923,0.011530367,-0.12805154,-0.25476306,-0.38044928,-0.54016414,-0.67482522,-0.83941329,-0.94160698,-0.87201844,-0.71500823,-0.64875879,-0.57859462,-0.43905761,-0.30832299,-0.20275374,-0.080247498,-0.0076659102,0.088269371,0.17282838,0.2046983,0.18933647,0.10415096,0.18947711,0.3217564,0.45386384,0.59594079,0.75424756,0.80335851,0.9322766,1.0425259,1.1675274,1.1744901,1.1700027,1.0093133,0.89782454,0.81885388,0.66042696,0.49648106,0.35511343,0.35912182,0.34742098,0.18788467,0.063295101,-0.11357322,-0.25893794,-0.38269892,-0.48582975,-0.35623417,-0.38956418,-0.20755709,-0.13876486,0.035209763,0.16433149,0.24347419,0.34938785,0.52117647,0.6902635,0.66938455,0.82706368,0.95456734,1.1327118,1.2690131,1.386158,1.4251921,1.2623561,1.1088992,0.9506292,0.8128354,0.66289775,0.55004708,0.42153465,0.50394003,0.60793208,0.49619575,0.37192919,0.32117618,0.19948092,0.084417353,0.073543475,0.072659846,-0.063906163,-0.19487609,-0.30653117,-0.43326884,-0.54674818,-0.58595967,-0.65286915,-0.58462376,-0.43464921,-0.48071484,-0.43250655,-0.54951599,-0.39462553,-0.2361837,-0.29593276,-0.31401182,-0.093540128,0.05723005,0.12497082,0.29165491,0.4440563,0.55189458,0.68671682,0.77892201,0.92713075,0.94379459,1.0976542,1.1391167,1.2896713,1.1876,1.0708099,0.94615503,0.8084667,0.67328487,0.55672668,0.40024555,0.40928424,0.29827329,0.25366776,0.25972412,0.13027661,0.014455562,-0.11905443,-0.21526982,-0.33690805,-0.30989858,-0.33925883,-0.32747217,-0.37240971,-0.42796079,-0.50300556,-0.3847672,-0.41674912,-0.47001006,-0.54942803,-0.631118,-0.73910101,-0.8358792,-0.92030974,-1.0145457,-1.0028504,-1.1202419,-1.1636957,-1.004743,-0.8513662,-0.69276786,-0.55070656,-0.44318869,-0.29913899,-0.26283541,-0.10274074,0.064897174,0.19142915,0.079542128,0.027836456,-0.040821275,-0.14637242,-0.14582331,-0.19519154,-0.23272046,-0.35318379,-0.25067956,-0.3313815,-0.23078701,-0.27533547,-0.35554919,-0.43844636,-0.53875948,-0.64665306,-0.72742226,-0.80200713,-0.88859095,-0.9106987,-1.0514029,-1.0342774,-0.84403404,-0.64459801,-0.47303494,-0.28925509,-0.10762771,-0.098495888,-0.22919838,-0.32665127,-0.31988858,-0.29520588,-0.33815719,-0.36984178,-0.42484842,-0.48203383,-0.56610614,-0.53016749,-0.49066355,-0.58948203,-0.65175378,-0.78465207,-0.85835516,-0.94750442,-0.99697269,-1.1004477,-1.2149555,-1.3033772,-1.466781,-1.5605306,-1.6998158,-1.8542725,-2.0376544,-2.2001991,-2.3179991,-2.4825414,-2.6458577,-2.8667255,-3.0455029,-3.0254692,-2.8602303,-2.6721746,-2.4867965,-2.3146891,-2.1563003,-1.9659498,-1.7800236,-1.634135,-1.4473151,-1.2577443,-1.099313,-0.92376445,-0.74482812,-0.5592573,-0.38157875,-0.20409927,-0.03820246,0.14425139,0.33050185,0.51706564,0.7044195,0.8937037,1.1107373,1.2924781,1.519894,1.692075,1.8211481,1.981272,2.1102077:1
1.9474002,1.8671435,1.7785731,1.704775,1.6413793,1.5688437,1.4618992,1.3820528,1.3012379,1.2203591,1.1545293,1.1068192,1.1460421,1.1945146,1.2512211,1.3045302,1.3573518,1.2972628,1.2178574,1.1167463,1.0331403,0.94372286,0.8545042,0.77327792,0.69413948,0.61673261,0.53957709,0.46266692,0.38593832,0.30962072,0.23329232,0.13233687,0.051932091,-0.031346349,-0.11259799,-0.19652045,-0.27528867,-0.3397263,-0.40420797,-0.43351092,-0.40820422,-0.36694917,-0.31856425,-0.26724267,-0.21552463,-0.14939479,-0.092343792,-0.027507505,0.023918578,0.092001896,0.15310891,0.22046328,0.29676399,0.36652274,0.43433028,0.52163998,0.60279896,0.67249168,0.69194258,0.59495409,0.49670828,0.42145366,0.32290657,0.22629794,0.13504323,0.076219177,0.038654529,0.055396227,0.074613617,-0.0074310009,-0.095950155,-0.17856763,-0.25800758,-0.3252345,-0.40714904,-0.48910108,-0.57113834,-0.65575032,-0.7339544,-0.81408626,-0.89468959,-0.97480213,-1.0544745,-1.1239886,-1.1965546,-1.2793872,-1.3580516,-1.4383522,-1.515638,-1.5915103,-1.6508836,-1.7270912,-1.7885963,-1.8509067,-1.9113757,-1.9582482,-1.9960302,-2.0119814,-2.0292529,-2.0301906,-2.027466,-2.0206828,-1.9924701,-1.9381779,-1.8604242,-1.7540605,-1.6476573,-1.5413336,-1.4349514,-1.3347946,-1.2497205,-1.1479323,-1.0640169,-0.98164327,-0.87793889,-0.79868053,-0.69203809,-0.58754881,-0.53415467,-0.42843563,-0.35923546,-0.44166319,-0.51674664,-0.59300093,-0.64711434,-0.70226798,-0.75021124,-0.78516151,-0.82768052,-0.84561832,-0.83247949,-0.83641231,-0.8662519,-0.91239039,-0.95094596,-0.98133302,-1.011795,-1.0420612,-1.0437533,-1.0632067,-1.0756958,-1.0970582,-1.1153467,-1.1233696,-1.1356528,-1.1380048,-1.1383933,-1.1239819,-1.0985389,-1.065452,-1.0225178,-0.98456839,-0.93310689,-0.88594187,-0.83922633,-0.77553782,-0.70620831,-0.62079035,-0.53378738,-0.44439804,-0.3522764,-0.27553448,-0.18779815,-0.12955112,-0.064224678,0.0036399894,0.06983725,0.12983232,0.19952136,0.26085588,0.33158036,0.39726676,0.46428092,0.46529964,0.45710159,0.45792363,0.4648659,0.48257848,0.5042353,0.56458588,0.61569808,0.67081761,0.65928272,0.62430092,0.63621274,0.64297935,0.66565085,0.67662321,0.69681327,0.71257696,0.73236051,0.76265678,0.78788541,0.82594261,0.88078703,0.92874651,0.98079086,1.0249288,1.0683411,1.0936288,1.1239074,1.1556194,1.1761347,1.1976131,1.2247058,1.2472279,1.2708884,1.2828889,1.2819926,1.2856512,1.2792429,1.2857336,1.3280591,1.41845,1.5051314,1.6107373,1.6892353,1.7951093,1.9010977,2.0070419,2.1129697,2.1915315,2.2973678,2.4004277,2.4778052,2.4792507,2.3923775,2.2862371,2.2074757,2.1014246,1.9952812,1.9165943,1.8104007,1.7042147,1.5979264,1.4914348,1.4121698,1.330224,1.2360667,1.1750244,1.1252742,1.0730183,1.0463699,1.0155187,0.97455682,0.93105266,0.88111874,0.82715031,0.76752076,0.70127434,0.64352307,0.55814924,0.49064013,0.43093856,0.38467466,0.35120581,0.30195293,0.21230452,0.15714388,0.10435491,0.10323605,0.082195974,0.052448222,7.4251458E-4,-0.022113424,-0.054920334,-0.11882934,-0.19892564,-0.26134225,-0.32806842,-0.39065424,-0.42722888,-0.40158057,-0.35226624,-0.38451666,-0.41834579,-0.4670551,-0.50152875,-0.53002532,-0.54312011,-0.54950177,-0.55684663,-0.54830568,-0.54853509,-0.52762472,-0.5205731,-0.52096272,-0.50276973,-0.49378631,-0.47917066,-0.47689183,-0.4719933,-0.46862969,-0.45879047,-0.4507692,-0.42735064,-0.39839911,-0.37244013,-0.34398595,-0.34311073,-0.37315178,-0.36272482,-0.32934709,-0.28378949,-0.24678186,-0.18257046,-0.11300544,-0.17642201,-0.25076213,-0.33172969,-0.42733118,-0.51378205,-0.59397041,-0.69443664,-0.79750595,-0.87803276,-0.96290461,-1.049271,-1.1215659,-1.1836762,-1.2421722,-1.290781,-1.3362483,-1.3742271,-1.408305,-1.4262152,-1.4268051,-1.422471,-1.3984879,-1.3639515,-1.3292156,-1.2948032,-1.2529676,-1.215768,-1.1724054,-1.1264598,-1.0774978,-1.0323552,-0.98770608,-0.93661461,-0.88700525,-0.82268899,-0.75888732,-0.6964327,-0.66428275,-0.62041517,-0.57017105,-0.49818772,-0.42606818,-0.34526206,-0.25841745,-0.16528905,-0.079901451,0.012089604,0.054903963,-0.017184105,-0.080492963,-0.14197486,-0.188568,-0.24619197,-0.27853517,-0.36492866,-0.45163683,-0.53538881,-0.62016541,-0.70586471,-0.79059258,-0.85959915,-0.93037192,-0.96581728,-0.9943787,-0.99951023,-0.99581441,-0.97420143,-0.95045653,-0.92414833,-0.89843164,-0.84887865,-0.77486219,-0.71358906,-0.61841285,-0.53400794,-0.44072072,-0.35574507,-0.26223406,-0.16268442,-0.074760308,0.015832808,0.11622184,0.20403399,0.29687764,0.39297336,0.47809463,0.54942107,0.6465622,0.73214574,0.81837793,0.89724672,0.93757649,0.86684782,0.80465254,0.74889547,0.69391056,0.63638335,0.58369689,0.53131828,0.50446029,0.50808955,0.53900041,0.58639261,0.65236396,0.72663865,0.80457072,0.90183625,0.97620037,1.0576148,1.1565826,1.2601765,1.365634,1.4453595,1.4118039,1.4756908,1.5812151,1.6879033,1.7942325,1.8752842,1.9518298:4
1.9155624,1.827731,1.826321,1.8061374,1.7455285,1.6757305,1.6159692,1.5354028,1.452924,1.3925301,1.3281668,1.2732015,1.2033101,1.1959367,1.2336917,1.2715326,1.2482662,1.181137,1.149729,1.1474702,1.1453832,1.0992938,1.0403905,0.98784289,0.9144538,0.88164603,0.8655127,0.87780001,0.89358377,0.87378582,0.83356221,0.80275759,0.7877523,0.73205336,0.67680421,0.59981698,0.54454248,0.47744225,0.39855453,0.30511092,0.20957082,0.13020635,0.043254865,-0.029659783,-0.11177546,-0.20325157,-0.27094433,-0.33824754,-0.41008312,-0.49578284,-0.56186872,-0.62416272,-0.68730877,-0.76927002,-0.83946709,-0.92676552,-0.99670492,-0.98284665,-1.016612,-0.99289406,-0.95581283,-0.92965933,-0.89683093,-0.87522956,-0.84486944,-0.81225357,-0.7843825,-0.78538156,-0.75505908,-0.74205904,-0.75539581,-0.73420151,-0.70046136,-0.66161759,-0.63730411,-0.64431873,-0.63627156,-0.58675077,-0.53841087,-0.50232705,-0.45335138,-0.47530446,-0.42303961,-0.41007829,-0.37970999,-0.36906942,-0.3324362,-0.29720848,-0.2598301,-0.2010466,-0.15836907,-0.16430285,-0.15227862,-0.11835531,-0.077367615,-0.034089637,3.5571246E-4,0.047042549,0.10260055,0.12714424,0.16857592,0.2664876,0.29072006,0.34993886,0.42092386,0.50341178,0.57098024,0.65535616,0.61259206,0.5384633,0.45376988,0.36510403,0.26667853,0.18982215,0.12913353,0.048812119,-0.035552593,-0.10196741,-0.15859317,-0.22239667,-0.25862511,-0.33880466,-0.40647082,-0.48951484,-0.57262022,-0.62468428,-0.65009366,-0.75036824,-0.8329961,-0.89794918,-0.97763516,-1.0045451,-1.1039015,-1.1862287,-1.2650883,-1.3551459,-1.4288345,-1.488265,-1.5500797,-1.6319905,-1.6985585,-1.7741991,-1.8577436,-1.9117646,-1.9502804,-1.9217323,-1.8555675,-1.7859882,-1.7160391,-1.6537398,-1.59655,-1.5248659,-1.4546947,-1.380662,-1.3181309,-1.2431823,-1.170268,-1.1125815,-1.0884386,-1.0362766,-1.0804352,-1.1265327,-1.1908975,-1.2568299,-1.2872319,-1.3342162,-1.3717804,-1.4159754,-1.4395429,-1.4600428,-1.4541698,-1.4598791,-1.4597857,-1.4592954,-1.4459395,-1.4262437,-1.4820191,-1.5433615,-1.6172425,-1.6817497,-1.7357887,-1.7561663,-1.7576483,-1.7321647,-1.6726031,-1.6058351,-1.5573261,-1.507878,-1.4379098,-1.3647388,-1.3260574,-1.2749088,-1.2030651,-1.1397844,-1.0620815,-0.98897353,-0.90758645,-0.83492988,-0.76117736,-0.68909679,-0.62251518,-0.55518661,-0.48432182,-0.41371792,-0.33896764,-0.27285978,-0.182904,-0.10275022,-0.10479975,-0.14036083,-0.18538664,-0.254996,-0.27949179,-0.34304038,-0.34036642,-0.37756788,-0.40639988,-0.44536779,-0.47492378,-0.48931823,-0.54015202,-0.55017842,-0.48018233,-0.40691156,-0.34117676,-0.27209821,-0.20289977,-0.15149044,-0.084907488,-0.0059572282,0.065709578,0.12360826,0.16997695,0.2527493,0.32905027,0.41396047,0.47283009,0.55189746,0.63213926,0.70222282,0.76604317,0.8606495,0.9320746,1.0042211,1.0752214,1.1466882,1.2185022,1.2989471,1.3714038,1.442993,1.5149243,1.5873381,1.6600471,1.7315441,1.8052851,1.8888314,1.9575916,1.9090714,1.8546937,1.7999695,1.7398436,1.6696346,1.6047367,1.5829715,1.5179375,1.4415661,1.4626821,1.407187,1.3292375,1.2645624,1.2817773,1.2257352,1.1531925,1.117532,1.0599018,1.0135131,0.95431725,0.94023073,0.89042472,0.82480413,0.80394118,0.7475258,0.76661966,0.81718412,0.81841828,0.76225314,0.70833938,0.6446218,0.63698651,0.57733867,0.56787184,0.57165341,0.57933034,0.53489877,0.4660413,0.42764493,0.41210303,0.35614985,0.29961828,0.28585259,0.18898213,0.14739085,0.12154133,0.089400322,0.022965604,0.05361698,0.13349509,0.19173252,0.26152426,0.33394994,0.37627236,0.43348441,0.51086912,0.56179322,0.64429834,0.70498239,0.77297064,0.83217881,0.8357676,0.74151345,0.65941088,0.59282641,0.5226432,0.47190459,0.42063386,0.35160387,0.32568167,0.34521371,0.26670989,0.18747779,0.1642249,0.18687675,0.10803611,0.058765799,0.016053245,-0.03704248,-0.085624066,-0.15896279,-0.22148673,-0.27290823,-0.3148795,-0.38587826,-0.4642956,-0.53152767,-0.60832153,-0.67810552,-0.73683246,-0.80769153,-0.87945055,-0.95202534,-1.0285346,-1.0999241,-1.1760928,-1.2421796,-1.2743072,-1.2786336,-1.290811,-1.3034707,-1.3019254,-1.2946435,-1.2806031,-1.2443065,-1.2499337,-1.222658,-1.194259,-1.157172,-1.1144746,-1.058323,-1.004687,-0.94772183,-0.8893763,-0.82667179,-0.75859996,-0.67370703,-0.59109507,-0.52683524,-0.4609573,-0.40502629,-0.33495974,-0.26211969,-0.18664531,-0.11588021,-0.053955279,0.012917302,0.084841075,0.156039,0.21300394,0.28460967,0.35272609,0.42696376,0.46587339,0.52997578,0.59648532,0.6144377,0.66793821,0.73035025,0.78642371,0.79751525,0.86745293,0.90390592,0.97636729,0.99730638,1.0400127,1.0885583,1.1280617,1.1520283,1.1849746,1.2322181,1.267994,1.3165735,1.2999175,1.3571954,1.4333585,1.473604,1.5062957,1.5609104,1.5975225,1.5587268,1.5533451,1.5800922,1.6098051,1.6653191,1.7319323,1.8045504,1.8202789,1.8403056,1.9041209:6
2.5809245,2.5322028,2.4429632,2.3222768,2.2209968,2.1263386,2.0489932,1.9689263,1.8939757,1.7954754,1.7133022,1.6156301,1.5202512,1.4206144,1.3183174,1.2277371,1.1227819,1.0262895,0.92192249,0.82047496,0.72589857,0.61710195,0.5081523,0.38526548,0.29929187,0.18713532,0.076820741,-0.045954059,-0.13764305,-0.24637256,-0.35318543,-0.47570035,-0.59760061,-0.70522821,-0.8266886,-0.93364059,-1.0544039,-1.1754177,-1.2859076,-1.4043538,-1.5109769,-1.5700677,-1.6187067,-1.5986901,-1.5721219,-1.5093589,-1.4489952,-1.3806074,-1.3066552,-1.2298193,-1.1526218,-1.0823205,-1.0051364,-0.95822066,-0.88461705,-0.80722684,-0.72784968,-0.69571307,-0.63526266,-0.5917578,-0.53969174,-0.45488315,-0.3734192,-0.31479776,-0.26005219,-0.2243823,-0.19637727,-0.18028081,-0.19840738,-0.26949244,-0.33729707,-0.4188138,-0.50375366,-0.59170698,-0.68087648,-0.77107972,-0.81308508,-0.88464697,-0.96007296,-1.00222,-1.0233312,-1.0615612,-1.0299724,-0.98972563,-0.95007372,-0.89758878,-0.86009627,-0.80807091,-0.74895239,-0.67017771,-0.60019304,-0.52082473,-0.45626291,-0.38281891,-0.30472506,-0.23344706,-0.16440951,-0.11368341,-0.066489078,-0.0014277483,0.060663139,0.1277445,0.21235583,0.28531713,0.3562008,0.4151669,0.45809481,0.4635645,0.42422748,0.37750408,0.35379309,0.33308255,0.29727715,0.29869355,0.31463019,0.36530693,0.4290152,0.47164962,0.53500776,0.60633655,0.67040419,0.72602162,0.79150152,0.86197855,0.90826378,0.94494185,0.9930724,1.0658355,1.1499743,1.2189914,1.2651539,1.3286358,1.4119513,1.4773293,1.5597566,1.5563606,1.5018048,1.4142028,1.3300299,1.2443118,1.157869,1.0685976,0.99284312,0.90444696,0.82092326,0.73714274,0.65083811,0.56989239,0.51060428,0.45649901,0.37899033,0.29873602,0.21807449,0.13174825,0.0466799,-0.036443023,-0.12322342,-0.20858098,-0.29234118,-0.38305832,-0.47055671,-0.55490875,-0.64529148,-0.73074682,-0.8193646,-0.90794617,-0.99480359,-1.078734,-1.1395082,-1.2027141,-1.2277554,-1.211755,-1.2450475,-1.154731,-1.078305,-1.0198938,-0.93244492,-0.81450599,-0.73353569,-0.6336763,-0.55596383,-0.45306592,-0.36998145,-0.3018239,-0.21562781,-0.12475113,-0.021182674,0.082134212,0.15427867,0.25921594,0.36135153,0.42753217,0.49359215,0.54302177,0.53066036,0.50607728,0.50591907,0.52180499,0.57450515,0.64319494,0.67753248,0.74225472,0.8123826,0.89759447,0.96292047,1.03276,1.0764576,1.1440981,1.2011486,1.2433072,1.3008256,1.365599,1.4433056,1.5106176,1.5743724,1.6288803,1.6952559,1.7597131,1.8187101,1.7727467,1.6710424,1.5842897,1.509528,1.4294793,1.3335913,1.2580054,1.2228773,1.1822681,1.106457,1.0089176,0.91562283,0.81914535,0.75172929,0.64521076,0.54125923,0.4762378,0.43676372,0.41616736,0.41256591,0.41804811,0.38274189,0.28754747,0.20164025,0.11269708,0.024239345,-0.067211277,-0.15508004,-0.23835434,-0.32666746,-0.41568331,-0.49837677,-0.58256492,-0.67203818,-0.75513631,-0.83814942,-0.92099648,-1.0022052,-1.0876812,-1.176768,-1.2536066,-1.3372012,-1.4191734,-1.4637436,-1.5413856,-1.6271674,-1.686175,-1.6462747,-1.6042947,-1.5772238,-1.48628,-1.4645884,-1.4016874,-1.3649424,-1.279146,-1.2366062,-1.1529696,-1.0456188,-0.95907818,-0.87042363,-0.83774219,-0.75419943,-0.6558903,-0.58092252,-0.48559953,-0.38997257,-0.35178734,-0.23665503,-0.12574595,-0.066472211,0.018744028,0.1183019,0.22260081,0.32967918,0.41174002,0.5006375,0.6017796,0.71781271,0.80614938,0.91522998,0.98856408,1.0050655,0.93456754,0.87506104,0.81594264,0.7588412,0.70316362,0.64875833,0.58462968,0.51824184,0.45415188,0.41915963,0.37686017,0.32139837,0.26205158,0.20229171,0.13471546,0.088522811,0.039996501,-0.0066436086,-0.064281294,-0.11016995,-0.112547,-0.059139779,0.0039177118,0.068162508,0.13239322,0.15258369,0.10640413,0.043166133,-0.0098094536,-0.0642769,-0.065861042,-0.14011586,-0.16833718,-0.2391887,-0.32212061,-0.42015674,-0.49186262,-0.58782488,-0.6719986,-0.75526714,-0.8142318,-0.890166,-0.95776093,-0.98503815,-1.0409267,-0.99871276,-0.91715441,-0.82618479,-0.73887036,-0.6497172,-0.5558332,-0.46172707,-0.36792655,-0.3050676,-0.33578088,-0.37638491,-0.42754498,-0.49958,-0.55061015,-0.5603599,-0.61384324,-0.65028601,-0.67327541,-0.74244607,-0.8214008,-0.88054738,-0.90985585,-0.98070227,-1.0255542,-1.0488096,-1.1177201,-1.144337,-1.196963,-1.2483648,-1.3168738,-1.3434818,-1.4208383,-1.4549323,-1.4865447,-1.5515842,-1.5677852,-1.6284367,-1.6360778,-1.6458508,-1.734086,-1.7143462,-1.6058131,-1.496659,-1.3863112,-1.2651797,-1.1573186,-1.0343735,-0.92644019,-0.80356,-0.69547993,-0.57247036,-0.46465474,-0.34981444,-0.23376192,-0.11106073,-0.0027026865,0.1184087,0.22864286,0.33704606,0.44564084,0.55432019,0.66320503,0.77201787,0.8814521,0.97609299,1.0847264,1.1810068,1.2761462,1.3844132,1.4805056,1.5763127,1.6732121,1.7785031,1.877349,1.9723868,2.0816048,2.1776077,2.2734256,2.3956686,2.498052,2.5484936:5
0.91176735,0.80925877,0.6882953,0.59111439,0.49501325,0.3849659,0.30599949,0.24004199,0.18558099,0.12777196,0.044488451,-0.026424076,-0.092357857,-0.15933425,-0.24587588,-0.33705552,-0.43802816,-0.52878628,-0.61060045,-0.70272775,-0.76213892,-0.81081799,-0.85147902,-0.87699683,-0.88229756,-0.89576209,-0.89670326,-0.88547836,-0.88382258,-0.87263756,-0.85778477,-0.84510922,-0.82051247,-0.79505833,-0.7565336,-0.71745968,-0.68195242,-0.64233682,-0.61011662,-0.5598742,-0.50978656,-0.45643521,-0.4113039,-0.34604946,-0.28139874,-0.21895571,-0.16060007,-0.25370113,-0.33284235,-0.2768252,-0.21022584,-0.13721812,-0.061414576,0.0091081799,0.085442885,0.16862743,0.2573698,0.33608031,0.27651134,0.17123672,0.076326081,-0.017450949,-0.12659084,-0.2143291,-0.3123798,-0.40117376,-0.50283015,-0.54299108,-0.64263835,-0.73342048,-0.82631302,-0.91595141,-1.0041203,-1.092943,-1.1748225,-1.2692308,-1.3643042,-1.4542866,-1.5505815,-1.6372809,-1.7325215,-1.844736,-1.9694368,-2.1000955,-2.1905356,-2.2551107,-2.3014435,-2.3236102,-2.3184255,-2.2782846,-2.2046742,-2.1135634,-2.0316002,-1.9366655,-1.8477667,-1.7429819,-1.6464331,-1.5524324,-1.4477695,-1.344232,-1.2522416,-1.1362346,-1.0404293,-0.94798461,-0.84548927,-0.74605037,-0.65270211,-0.54176102,-0.455854,-0.36412301,-0.27396026,-0.21771679,-0.27452939,-0.34708573,-0.37121839,-0.29054569,-0.18537206,-0.079053844,0.025414863,0.12008268,0.17340637,0.27295946,0.3886873,0.32609451,0.22374116,0.12630397,0.055881727,-0.042756512,-0.13048671,-0.21447134,-0.29517957,-0.36374266,-0.44764673,-0.50870433,-0.58035823,-0.64236447,-0.70386247,-0.75575775,-0.8062285,-0.85479155,-0.88291394,-0.87790608,-0.81782617,-0.74515713,-0.64126181,-0.53877365,-0.43553033,-0.30205705,-0.198944,-0.065018763,0.036882146,0.15473834,0.27474472,0.37789823,0.48175776,0.58638144,0.69070211,0.81411653,0.92657444,1.0326218,1.1113213,1.202229,1.1522294,1.0568326,0.97636187,0.91400485,0.91048421,0.95415636,1.0344646,1.137672,1.2520423,1.3520026,1.4455982,1.5665914,1.6966016,1.7872768,1.9127096,1.931861,1.8890292,1.8336145,1.7660768,1.6795903,1.5884358,1.4644645,1.3725134,1.4111232,1.5003956,1.5627439,1.4436552,1.3180743,1.1899151,1.064262,0.94106386,0.81686034,0.71772594,0.59183272,0.49265899,0.36401724,0.26366077,0.14500899,0.062495441,-0.0059550525,-0.034393309,-0.014103728,0.02943546,0.080871568,0.1513285,0.23831984,0.3318072,0.41909156,0.50936659,0.5933123,0.69427367,0.77780422,0.87072576,0.97058474,1.0399902,0.97106699,0.88329791,0.78756244,0.69209082,0.59596968,0.5025838,0.41499232,0.3174252,0.22821258,0.13403798,0.13512873,0.21160117,0.28525175,0.18549126,0.096922273,0.0049482698,-0.091372408,-0.18486155,-0.2742884,-0.37635648,-0.46451332,-0.55033158,-0.64268732,-0.74197641,-0.82469753,-0.92480583,-1.0067685,-1.0952816,-1.1891717,-1.2664136,-1.3664865,-1.4413521,-1.5169376,-1.5996214,-1.6808233,-1.7633288,-1.8311547,-1.9145748,-1.9739421,-2.0296872,-2.0871779,-2.1246632,-2.1497158,-2.1502973,-2.1178784,-2.0626932,-1.984327,-1.9012355,-1.8113999,-1.7186008,-1.620565,-1.4928456,-1.3926856,-1.2900506,-1.1799395,-1.089926,-0.99931234,-0.90798116,-0.8212914,-0.74560231,-0.66164508,-0.5792306,-0.50026136,-0.38910163,-0.26010932,-0.13904248,-0.032152642,0.065048541,0.1616505,0.25874121,0.36119325,0.34426485,0.25619103,0.18527862,0.11351944,0.042444814,-0.010297401,0.038006718,0.01100307,-0.033965586,-0.070640378,-0.1149282,-0.16711418,-0.22837967,-0.27352424,-0.32048215,-0.35210618,-0.38843165,-0.41329844,-0.44380007,-0.46112936,-0.47222021,-0.48562714,-0.50906508,-0.52202102,-0.53324509,-0.55049707,-0.56065832,-0.5549924,-0.55220774,-0.55002615,-0.55115804,-0.55289084,-0.54423517,-0.5403432,-0.52035578,-0.50010394,-0.47057292,-0.43474955,-0.38844307,-0.35276877,-0.30173732,-0.22547557,-0.13747996,-0.039651455,0.065709167,0.14925526,0.23476322,0.29850752,0.3736117,0.44065762,0.51611196,0.59377038,0.66509297,0.74143677,0.81768528,0.89160237,0.95961389,1.0373111,1.061886,1.0928345,1.0701505,1.0456795,1.0321265,1.0276453,1.0256394,1.0322967,1.0415293,1.0507917,1.0635381,1.0801436,1.0974321,1.1246214,1.1614679,1.1888365,1.2342048,1.2883255,1.3304099,1.3779518,1.4105029,1.4506389,1.4802143,1.5095575,1.5356977,1.5551631,1.5691556,1.5758979,1.5759295,1.5576637,1.5322557,1.5109174,1.502893,1.5349589,1.6032067,1.5450516,1.4453246,1.5246269,1.5021317,1.4355499,1.4019845,1.3834638,1.3614114,1.3450291,1.3244834,1.2987138,1.2683644,1.2350746,1.2010916,1.161119,1.1166331,1.0895919,1.0551779,1.0241125,0.99558946,0.94950385,0.91581026,0.87789773,0.83484469,0.80079978,0.77440767,0.74770816,0.72602531,0.70395912,0.685839,0.6753236,0.66639566,0.65301416,0.65096546,0.65740392,0.64201481,0.61024704,0.59576485,0.59978727,0.59849099,0.61260613,0.64010919,0.6893266,0.73508746,0.80373317,0.889742:4
3.6382147,3.6694938,3.5335519,3.3160772,3.126319,2.8653383,2.6498176,2.4373987,2.2237307,2.0075316,1.7884925,1.5317567,1.321496,1.0984898,0.84153604,0.62945179,0.41212623,0.19741839,-0.015400175,-0.18259098,-0.4111901,-0.64453872,-0.82891452,-1.0539954,-1.2390301,-1.4369663,-1.6573742,-1.8527012,-2.1142453,-2.2768083,-2.4256035,-2.3466173,-2.2608881,-2.1880568,-2.0485849,-2.019023,-1.9387179,-1.8790352,-1.7965412,-1.6598643,-1.6187946,-1.5318578,-1.4863918,-1.3773329,-1.3334103,-1.1871426,-1.0900578,-0.98527028,-0.92270057,-0.85028002,-0.74951564,-0.65063844,-0.50477201,-0.36167809,-0.44284825,-0.34501854,-0.34494748,-0.27259104,-0.22453742,-0.13449475,-0.043380088,-0.13296542,-0.33447571,-0.5129663,-0.67509779,-0.78185561,-0.91330156,-0.86342841,-0.80861581,-0.69899319,-0.58258034,-0.53249876,-0.57669713,-0.49350782,-0.40441697,-0.42011062,-0.29188541,-0.15630688,-0.16230125,-0.20884551,-0.16845535,-0.1103856,-0.0038058811,-0.06105476,0.008861061,0.082077943,0.14962045,0.26038195,0.34431191,0.40802705,0.1793606,-0.03291114,-0.18526885,-0.30715546,-0.55174906,-0.78021504,-1.0155618,-0.93739066,-0.87738879,-0.79079467,-0.68124893,-0.57707994,-0.44268092,-0.41740569,-0.3331368,-0.2408036,-0.15857753,-0.18801934,-0.084214401,0.021934913,0.14558636,0.12769251,0.20624305,0.3069179,0.4396729,0.45640262,0.57465651,0.71133142,0.8814369,1.0155532,1.1670264,1.2034796,1.0484931,0.85590322,0.72758859,0.53969481,0.37298618,0.29009243,0.23198938,0.096856626,-0.091181752,-0.29325527,-0.40569658,-0.59000346,-0.70710691,-0.79972946,-1.0121879,-0.94133803,-1.1524697,-1.331708,-1.2008587,-1.2840857,-1.4464148,-1.3191229,-1.1335181,-1.0223187,-0.83798572,-0.6445277,-0.58335523,-0.71501006,-0.87004655,-1.0574315,-1.153166,-1.1728784,-1.1235303,-0.98589094,-0.99738283,-0.81621633,-0.73086697,-0.58758821,-0.4109566,-0.41051117,-0.31726066,-0.32830196,-0.34224975,-0.21209321,-0.21787081,-0.1359992,-0.025863148,-0.18550012,-0.016486484,0.14422379,0.2858322,0.25454433,0.22309854,0.35370671,0.29975631,0.399501,0.51786638,0.62281534,0.79764515,0.87783066,0.81417304,0.92335727,1.0883516,1.2261201,1.4078665,1.5846129,1.6995497,1.7197528,1.6061935,1.4313243,1.2608947,1.0701309,0.96102531,0.76644209,0.6013653,0.47094664,0.59181176,0.48296779,0.27325647,0.1363436,-0.030033962,-0.20362111,-0.37597884,-0.52000089,-0.71309576,-0.71640184,-0.83116809,-0.99312474,-1.2075328,-1.1599183,-0.9921726,-0.90473051,-0.9041324,-0.74856119,-0.6930339,-0.6508789,-0.53164228,-0.41332387,-0.41020426,-0.31709768,-0.28856699,-0.17245356,-0.21774752,-0.1723855,-0.025063609,0.11342943,0.13594716,0.023606365,-0.13027075,0.037104379,0.066483021,-0.093658325,-0.037305906,0.14490143,0.054073142,-0.081103318,-0.065310942,-0.10108171,-0.19903861,-0.19059671,-0.35275533,-0.46505991,-0.59139392,-0.75330893,-0.89725182,-1.0912746,-1.1054715,-1.2004694,-1.2650418,-1.0652307,-0.919198,-0.78974741,-0.59719541,-0.50789562,-0.39618339,-0.3152566,-0.38646265,-0.34563649,-0.25328919,-0.11852975,0.040566693,0.078490928,0.031427498,0.19502847,0.33481326,0.43893591,0.60150951,0.80110074,0.97286002,1.1648438,1.2517841,1.327556,1.4329495,1.4677785,1.4001052,1.2281625,1.1387305,1.1378538,1.0191623,0.83297143,0.7531105,0.83637837,0.84715788,0.69546264,0.55533097,0.41449893,0.56840311,0.46938085,0.33472977,0.19930838,0.054133368,-0.085975439,-0.12806806,-0.28034098,-0.39545933,-0.53141739,-0.66343074,-0.65587412,-0.77579705,-0.71287659,-0.46274372,-0.20486556,-0.013436377,0.20199237,0.33562524,0.38263981,0.50762622,0.72574139,0.88738315,1.123765,1.2950348,1.1797973,1.0476148,0.9595807,0.8288213,0.7828175,0.66673287,0.57767485,0.54822209,0.61646338,0.50939542,0.38411619,0.27589594,0.1512221,0.21804478,0.10865687,0.033672085,-0.038052433,-0.17565328,-0.26216117,-0.34278455,-0.44195652,-0.54296211,-0.6607998,-0.68846087,-0.62801471,-0.43888713,-0.25162001,-0.061474661,0.11471255,0.28701116,0.37621213,0.54619002,0.72919777,0.67909464,0.5945597,0.50660034,0.53691733,0.48240732,0.37228993,0.29454249,0.23743622,0.39138103,0.25788875,0.21399405,0.15859111,0.059442587,-0.042423711,-0.1384423,-0.24067656,-0.34128682,-0.48418319,-0.43348914,-0.44195652,-0.24617777,-0.045442835,0.14853317,0.34535731,0.51734266,0.43686244,0.399501,0.35929776,0.38592298,0.2748745,0.26926691,0.17762808,0.30918671,0.31635063,0.50843356,0.65160288,0.56327537,0.54844757,0.54020124,0.44920735,0.33535576,0.20888121,0.086199352,-0.071407214,-0.2496309,-0.34988608,-0.45682616,-0.59244548,-0.6543432,-0.80681837,-0.93391824,-1.0592707,-1.1809751,-1.3575996,-1.5013254,-1.6864768,-1.7247121,-1.5137166,-1.3025805,-1.0915552,-0.87941012,-0.66766286,-0.45598634,-0.21622491,0.020149919,0.23051262,0.44265268,0.68983211,0.91685112,1.1294315,1.3416692,1.6018605,1.8167997,2.029075,2.2496355,2.5029528,2.7178568,2.9318764,3.144475,3.3561195,3.5820403:1
1.6953351,1.6316846,1.5296643,1.4389423,1.3640588,1.3074017,1.2497066,1.1535454,1.0671633,0.99940772,0.92645433,0.85396396,0.7671664,0.7242197,0.80193771,0.76860291,0.67971815,0.58677547,0.46349748,0.37397653,0.31823465,0.41298334,0.4633082,0.37517179,0.24860981,0.12595604,0.012473276,-0.023414341,0.036341408,0.092056097,0.20194941,0.24726397,0.18357241,0.08290047,0.020308813,-0.060926967,-0.11313928,-0.2075106,-0.29812632,-0.38372717,-0.39512014,-0.31182102,-0.24002657,-0.23749334,-0.31032889,-0.39933311,-0.45806082,-0.52645075,-0.59618909,-0.66235994,-0.69767643,-0.75144518,-0.8223675,-0.81447643,-0.71427959,-0.56932718,-0.49618322,-0.34471104,-0.23535821,-0.21170062,-0.24862957,-0.2609662,-0.30615566,-0.312428,-0.33340172,-0.31942862,-0.36599788,-0.44760978,-0.49148823,-0.58035188,-0.56960118,-0.6470954,-0.63516861,-0.65637757,-0.70840941,-0.7298084,-0.82257851,-0.9092817,-0.9436462,-0.96594076,-1.038089,-1.112749,-1.2034745,-1.2506073,-1.3326539,-1.388977,-1.4343719,-1.493589,-1.5218703,-1.5805326,-1.5638078,-1.5827217,-1.608348,-1.6232528,-1.6252573,-1.6702195,-1.6098728,-1.5098126,-1.3846906,-1.2872934,-1.2012817,-1.1162494,-1.0004971,-0.90505854,-0.815212,-0.72491602,-0.6155852,-0.514991,-0.40148723,-0.29148375,-0.18050601,-0.067809904,0.035075407,0.14441073,0.2603645,0.36711427,0.47014058,0.57923589,0.70092461,0.80482817,0.90998113,1.0249353,1.1359023,1.2439929,1.3488219,1.4614072,1.5748662,1.6781878,1.7921484,1.9026171,2.0051759,2.1171667,2.1759117,2.2916007,2.3961344,2.4986957,2.6225277,2.7338792,2.6958823,2.581757,2.4783723,2.3750228,2.2613561,2.1579005,2.0406924,1.9350231,1.8272164,1.7159429,1.6056039,1.5063988,1.3928578,1.2720478,1.1701531,1.062848,0.94930022,0.84626932,0.73640203,0.6215079,0.51623208,0.41473833,0.30250665,0.19162071,0.082131352,-0.025354392,-0.13494564,-0.24021375,-0.34907193,-0.46251239,-0.56873104,-0.67605629,-0.7907452,-0.89382737,-1.0047718,-1.1119492,-1.2228959,-1.3251956,-1.4291052,-1.5500403,-1.6619664,-1.7598872,-1.7876641,-1.8047031,-1.7216636,-1.6997415,-1.6696337,-1.6345528,-1.5921538,-1.5648284,-1.5522582,-1.5401567,-1.5770642,-1.5607456,-1.5361626,-1.4987712,-1.4404397,-1.3788674,-1.3169014,-1.2289575,-1.1479635,-1.048641,-0.98139739,-0.91574189,-0.8413603,-0.81077019,-0.85643054,-0.8471354,-0.76532538,-0.68262421,-0.59782256,-0.50401469,-0.4494066,-0.3681644,-0.34245964,-0.43434077,-0.35470481,-0.26999838,-0.19115221,-0.15615546,-0.096015439,-0.1407455,-0.08170391,-0.072466111,-0.016701072,0.03168679,0.020908804,-0.10059241,-0.21094209,-0.33914831,-0.46056448,-0.57986858,-0.6840522,-0.6764887,-0.5898795,-0.52238052,-0.42227869,-0.31507961,-0.23158702,-0.18917694,-0.079520744,-0.0080653411,0.0039132211,-0.094521644,-0.022553272,0.084740931,0.13958182,0.22630797,0.31365726,0.31745986,0.38372446,0.46742489,0.54810448,0.63308504,0.6238205,0.51601318,0.42782648,0.33993549,0.37678099,0.41631628,0.47378002,0.56573304,0.67083799,0.71647299,0.68180216,0.78415422,0.89200312,0.9865498,1.061554,1.1287953,1.0597859,1.0589352,1.1559585,1.2385161,1.3034795,1.3831492,1.43872,1.4885667,1.5574812,1.6108191,1.6524325,1.6907234,1.6658786,1.5723774,1.4555946,1.3564852,1.2565756,1.1441743,1.0540146,0.94510998,0.82067683,0.6737439,0.5453082,0.39046059,0.23572444,0.082310201,0.02448616,0.077955443,0.016040987,-0.085306279,-0.24041971,-0.31654266,-0.4100961,-0.52375804,-0.6458118,-0.75711807,-0.8694308,-0.93610028,-1.009801,-1.156244,-1.2006936,-1.1322984,-1.0473727,-1.0073785,-0.9959207,-0.91230137,-0.82847467,-0.75070259,-0.65230788,-0.5672761,-0.49836056,-0.52171575,-0.41610976,-0.32132126,-0.2211058,-0.17842267,-0.12077353,-0.031070666,0.048147305,0.14399628,0.15823884,0.095583327,-0.039183136,-0.11918947,-0.15999634,-0.056468075,0.0438704,0.14350254,0.24433689,0.35049244,0.45876132,0.56259303,0.56831323,0.62927114,0.73761372,0.84751725,0.95620054,1.0604827,1.1802256,1.2905742,1.3938507,1.3114866,1.2093741,1.1005938,1.0060894,0.89714429,0.79341607,0.69141232,0.6364711,0.5613319,0.57748114,0.5513303,0.46156483,0.36822391,0.30335571,0.22118191,0.14474319,0.11213507,0.027171442,-0.076241403,-0.17946694,-0.29034535,-0.36357447,-0.34751646,-0.30599621,-0.2060372,-0.15202312,-0.13553458,-0.20897392,-0.2505928,-0.3246986,-0.33137933,-0.36650713,-0.47561729,-0.59390851,-0.64697815,-0.66077753,-0.77042393,-0.88379104,-0.98825353,-1.0650246,-1.1725772,-1.2457888,-1.3364625,-1.4210938,-1.5037955,-1.5207966,-1.6332232,-1.6926006,-1.573138,-1.4499225,-1.329546,-1.2289456,-1.1100922,-1.0017211,-0.89371515,-0.79432001,-0.69830683,-0.57670202,-0.45356965,-0.33422686,-0.23043416,-0.15753977,-0.12631478,-0.075721722,0.079012925,0.22784962,0.37727757,0.51921339,0.62307819,0.67918882,0.82704067,0.94931503,1.0993785,1.2213445,1.3531316,1.4538695,1.5522828,1.6602544:3
1.3445146,1.3404972,1.2732816,1.2834702,1.2348975,1.1621996,1.1262311,1.0527463,0.9844914,0.90208422,0.79917663,0.69559374,0.64553977,0.57654736,0.55334724,0.58691839,0.59438165,0.64019739,0.67952266,0.63437679,0.55685429,0.46983482,0.36470083,0.25485746,0.10228422,-0.031457425,-0.13126201,-0.2654553,-0.42146905,-0.5442741,-0.68882729,-0.8202012,-0.95225706,-1.0916546,-1.2220057,-1.3540968,-1.473475,-1.6121593,-1.7227811,-1.8498426,-1.9857479,-2.1181786,-2.2230432,-2.3532458,-2.4233298,-2.5364079,-2.6653065,-2.7942209,-2.9045597,-3.0254067,-3.0748909,-2.9656255,-2.8441854,-2.7149816,-2.5850245,-2.4587258,-2.3702711,-2.2984646,-2.1874048,-2.0587308,-1.93564,-1.8009124,-1.6823169,-1.6037857,-1.5232596,-1.3997969,-1.2722663,-1.1357291,-1.0328887,-0.94821938,-0.81076096,-0.74068503,-0.63797658,-0.57887809,-0.48006546,-0.35368097,-0.21636424,-0.073339208,0.050668036,0.19661153,0.34495201,0.49207334,0.63442434,0.67050754,0.70475519,0.7089823,0.69510521,0.6792093,0.65404421,0.63125767,0.5957357,0.56042832,0.51594991,0.51895803,0.4821179,0.46534465,0.47680066,0.53519837,0.58268097,0.62282507,0.64502154,0.64153618,0.60649467,0.57554243,0.5181274,0.4501618,0.3796258,0.29696385,0.2226807,0.142236,0.052772856,-0.01409577,-0.086651264,-0.17122879,-0.20959472,-0.23079253,-0.19704618,-0.11086128,-0.039671531,0.054777975,0.130014,0.20190217,0.27057061,0.32993641,0.36314452,0.41623087,0.45504828,0.50455869,0.58827758,0.66436496,0.72246965,0.77661888,0.83013421,0.88863633,0.93004048,0.97500573,1.0138762,1.0523918,1.0763378,1.0979663,1.1010292,1.1024881,1.0831375,1.0452451,1.0769287,1.2033909,1.3256776,1.4687123,1.5949458,1.7358485,1.8280485,1.8521497,1.8358674,1.7799203,1.658043,1.5072503,1.3755364,1.2419575,1.1196157,0.99004661,0.92714783,0.90463234,0.93001368,0.96315629,0.99566432,1.0188498,1.0431527,1.0357601,1.0356303,1.0410805,1.0424318,1.032295,1.0450901,1.037062,1.0529858,1.0522953,1.0838223,1.0920223,1.0983998,1.1265263,1.1504912,1.1626604,1.1684082,1.1555042,1.0918168,0.94912634,0.76992649,0.62252655,0.48013299,0.33961056,0.21567541,0.20898136,0.27714393,0.18987672,0.16698605,0.18947725,0.15068192,0.1442524,0.14678952,0.22812387,0.248451,0.25953587,0.31636294,0.29833933,0.32481129,0.3306412,0.39246504,0.40453007,0.39847989,0.43166735,0.43493852,0.4644544,0.46929499,0.48948142,0.49404396,0.49025174,0.48030819,0.4628474,0.45376328,0.44800518,0.43704286,0.41342086,0.39016765,0.3539099,0.31959041,0.25746045,0.16828622,0.018361038,-0.11066666,-0.24051814,-0.37014787,-0.47548864,-0.51244939,-0.58322605,-0.63072839,-0.76403498,-0.76105486,-0.68262266,-0.63532663,-0.53160531,-0.42205034,-0.32338384,-0.24057557,-0.1682266,-0.27857922,-0.19861513,-0.12993783,-0.064162187,0.0056669152,0.084182983,0.15758664,0.19811343,0.2880832,0.33272478,0.4218619,0.4740838,0.52019711,0.50930727,0.43291566,0.31111426,0.19504238,0.086426845,-0.02891055,-0.095056579,-0.070057768,-0.020854979,0.039172088,0.093636736,0.1588096,0.22524772,0.30031886,0.35611372,0.40978245,0.44506093,0.48198212,0.51070342,0.54041315,0.55849463,0.555043,0.52788616,0.43041409,0.31460489,0.20063025,0.086602556,-0.02404007,-0.036097798,-0.13110662,-0.18565481,-0.32412877,-0.42919475,-0.57732112,-0.69819231,-0.79791031,-0.92575045,-1.0734822,-1.2261515,-1.3740594,-1.4914748,-1.6088454,-1.7574587,-1.8701612,-1.9491449,-2.0246427,-2.1731879,-2.283827,-2.2153736,-2.1428646,-2.0322506,-1.9225711,-1.797341,-1.6674678,-1.5743962,-1.5668639,-1.4390943,-1.361985,-1.2316083,-1.1599969,-1.0617706,-0.96054646,-0.87522697,-0.82770973,-0.85939972,-0.90423526,-0.90153657,-0.8142298,-0.7081283,-0.5980982,-0.55507601,-0.45536494,-0.33716775,-0.23233619,-0.12089948,-0.017474795,0.074466336,0.16667012,0.25070726,0.30819492,0.2807309,0.21965813,0.14747721,0.11900379,0.070393014,0.0022975747,-0.067676467,-0.1604204,-0.23748812,-0.33980928,-0.45499246,-0.5929041,-0.73168077,-0.83774356,-0.92632983,-1.0462228,-1.1369136,-1.0956761,-0.95643538,-0.82775323,-0.70553375,-0.58295702,-0.45018185,-0.32325886,-0.19792003,-0.065207423,0.063428577,0.19095282,0.32907728,0.4799182,0.60075295,0.70651123,0.85130666,0.99352625,1.0955133,1.1590779,1.2229223,1.2390661,1.2515895,1.2439226,1.2522013,1.2102623,1.1285826,1.0411393,0.98557847,1.0340018,1.0608328,1.0667015,0.99319616,0.91117437,0.81456433,0.71845721,0.62133834,0.51707636,0.40672283,0.35193731,0.27428719,0.16840062,0.046717393,-0.068201812,-0.17976409,-0.31828417,-0.43746079,-0.56978137,-0.71037427,-0.79802513,-0.94175711,-1.037315,-0.98395561,-0.87653623,-0.7662508,-0.65881972,-0.52213974,-0.40467234,-0.25993963,-0.14844881,-0.0034333777,0.12417069,0.25327763,0.36985743,0.47939804,0.58129985,0.67823054,0.77406879,0.87788315,0.96855891,1.068981,1.1560544,1.2481636,1.3227594:2
1.5902506,1.5869856,1.5785508,1.5637163,1.5344468,1.5212749,1.4852624,1.4408271,1.385764,1.3501501,1.3037369,1.255582,1.2225888,1.1553899,1.1055912,1.0461236,1.0030969,0.94260215,0.89109608,0.81953624,0.77066424,0.70070997,0.65550834,0.58056301,0.54737146,0.51425641,0.46121163,0.43107403,0.39940383,0.35937252,0.37106266,0.42815966,0.38070036,0.34656842,0.40563058,0.44658369,0.51505237,0.5742009,0.62248973,0.64350829,0.69975052,0.75030062,0.77616569,0.82251198,0.88520735,0.94842937,0.9624289,1.0175721,1.0571645,1.0648411,1.0924013,1.1082874,1.1542814,1.2073093,1.2242733,1.2410437,1.2585104,1.26917,1.2591802,1.242753,1.2273433,1.1831192,1.1660543,1.1319933,1.0889696,1.0355225,0.99883354,0.97739857,0.92043657,0.89957781,0.84999356,0.81232026,0.7543624,0.6994108,0.64154352,0.59749529,0.53104711,0.47538575,0.43047461,0.36731874,0.3192655,0.25496889,0.20697109,0.14306444,0.097599055,0.037735602,-0.034485491,-0.078655004,-0.13968667,-0.19915701,-0.24978608,-0.29936208,-0.37184672,-0.42779215,-0.48353276,-0.53857336,-0.59664257,-0.66251604,-0.71387788,-0.75963281,-0.81842187,-0.87217349,-0.91680968,-0.97266563,-1.0288604,-1.0822798,-1.1244976,-1.1760395,-1.2237703,-1.2609819,-1.3032492,-1.3247246,-1.3565997,-1.3277503,-1.3423401,-1.3129386,-1.3191839,-1.2754372,-1.2991688,-1.2899683,-1.3043593,-1.3176766,-1.3108508,-1.3426196,-1.3550863,-1.3930328,-1.4440905,-1.4902972,-1.5473022,-1.5774242,-1.6046358,-1.6656113,-1.7098294,-1.6856498,-1.7074437,-1.6455133,-1.5884137,-1.5007802,-1.4540829,-1.3703414,-1.3091467,-1.2399583,-1.1630224,-1.0866796,-1.0037115,-0.9471388,-0.86219624,-0.78680159,-0.75361843,-0.69702291,-0.65786019,-0.5900722,-0.54335276,-0.4941456,-0.4565996,-0.41785904,-0.35857676,-0.30299158,-0.25614129,-0.20044957,-0.19592733,-0.17522752,-0.11746719,-0.071365133,-0.02860292,-0.0013598471,0.017158725,0.043300934,0.075264929,0.12283834,0.17233915,0.19483293,0.24154575,0.26015906,0.28149122,0.31055726,0.31183679,0.31388906,0.33930654,0.34504698,0.36500399,0.38270517,0.41642359,0.4839443,0.53654107,0.6091696,0.63330816,0.70987377,0.74886647,0.76736762,0.83803309,0.87425938,0.90270332,0.9371618,1.0204994,1.0649083,1.0997344,1.1457842,1.2004408,1.2325665,1.2638475,1.259974,1.2526816,1.2539536,1.2838106,1.2930708,1.2844783,1.2779821,1.2581303,1.2635498,1.299146,1.2932488,1.3090033,1.3225233,1.350877,1.3767702,1.353416,1.3078435,1.2623265,1.2455945,1.2039867,1.1818609,1.1809598,1.1361354,1.0769136,1.0017859,0.92970344,0.9029385,0.8865448,0.84748315,0.77543329,0.69346641,0.64357305,0.55919154,0.49510334,0.43912283,0.37479797,0.31534927,0.23622332,0.18336487,0.12544947,0.06808733,0.067221714,0.14540114,0.20632067,0.26834799,0.3315484,0.40033345,0.46465693,0.51805427,0.58988477,0.61681866,0.64731061,0.67902195,0.69206331,0.64890942,0.63081179,0.56236076,0.54415954,0.48598132,0.44915371,0.4052388,0.33437118,0.2726483,0.21592645,0.17805582,0.15553376,0.1737631,0.11697113,0.062515636,0.029775351,-5.196929E-4,-0.0072720855,-0.057110948,-0.12007903,-0.18568827,-0.24818684,-0.29945821,-0.3593889,-0.4080471,-0.48993343,-0.53477423,-0.58648874,-0.6446375,-0.70581083,-0.77190108,-0.83420901,-0.89205491,-0.95525359,-1.0197352,-1.0765255,-1.1416681,-1.194807,-1.2882454,-1.345254,-1.4323924,-1.4721684,-1.4611837,-1.5261038,-1.5786335,-1.6173091,-1.5757444,-1.6454543,-1.6850956,-1.6960902,-1.7019746,-1.7076949,-1.756303,-1.7525459,-1.7643904,-1.7625575,-1.8272229,-1.7936842,-1.8070479,-1.8716338,-1.854035,-1.8364839,-1.8367489,-1.8150539,-1.8186412,-1.7922623,-1.7941239,-1.7825485,-1.7645672,-1.7563977,-1.7444566,-1.7225088,-1.7045231,-1.6830977,-1.6513262,-1.6402312,-1.6250657,-1.5976845,-1.5630243,-1.5109713,-1.5260042,-1.4645862,-1.4063597,-1.3434312,-1.2901002,-1.2441587,-1.1932881,-1.142821,-1.0884806,-1.0361777,-0.97997892,-0.93013123,-0.88755082,-0.83835738,-0.78066172,-0.73828333,-0.68164424,-0.64295691,-0.58630285,-0.53914654,-0.48827211,-0.44296206,-0.41968739,-0.37803838,-0.34608325,-0.2997951,-0.24508286,-0.18764133,-0.15467626,-0.1061787,-0.077966565,-0.032707309,0.0047947009,0.068069445,0.095415515,0.13837692,0.18760799,0.25226182,0.30904233,0.33771548,0.33373315,0.32151351,0.29402716,0.2793201,0.24489465,0.19902618,0.23630582,0.23491136,0.20242855,0.18076585,0.17390307,0.13393782,0.092762807,0.05757485,1.6445325E-4,-0.064635379,-0.10834322,-0.11979631,-0.091328578,-0.033573345,0.012264797,0.098818587,0.16996824,0.23594695,0.32350876,0.37230857,0.46036855,0.52120456,0.59797842,0.66592256,0.73646608,0.78649797,0.85856509,0.92144217,0.97316685,1.0253268,1.0741891,1.1247085,1.1776415,1.2219002,1.2818357,1.3091055,1.3497395,1.39147,1.4178192,1.4455895,1.4743568,1.5145035,1.5195195,1.5553728,1.5654425,1.5992857:2
0.83855268,0.76488792,0.67869866,0.59036866,0.50610635,0.40633433,0.31864195,0.24262174,0.16478807,0.069620125,-0.025233918,-0.13936664,-0.25291586,-0.35765653,-0.47161427,-0.57550382,-0.66681166,-0.7533733,-0.80330902,-0.85864063,-0.88769321,-0.83483957,-0.76246803,-0.68880534,-0.61662469,-0.53617368,-0.46512041,-0.38951393,-0.31621313,-0.24255297,-0.18009303,-0.11827954,-0.04512144,0.011063825,-0.057211133,-0.14776348,-0.24371169,-0.3282444,-0.42020532,-0.51108826,-0.60579458,-0.70416073,-0.79115182,-0.8395772,-0.93179389,-1.0304938,-1.1184651,-1.1965341,-1.2839682,-1.3752111,-1.459945,-1.5464716,-1.6384694,-1.7058506,-1.7236254,-1.7381799,-1.6986182,-1.6420575,-1.5715219,-1.4990867,-1.4232344,-1.347363,-1.2778185,-1.2062606,-1.1320897,-1.0632512,-0.98842174,-0.91597885,-0.84420154,-0.77403827,-0.70813647,-0.63131603,-0.56748571,-0.49565178,-0.41360186,-0.34016202,-0.25959995,-0.19739059,-0.11586735,-0.041778605,0.040846714,0.12453778,0.20319873,0.28288709,0.36285154,0.43825478,0.51252586,0.591514,0.65600918,0.74189528,0.82079907,0.9069522,0.99302073,1.075101,1.1570187,1.2366758,1.3150535,1.3991016,1.4698277,1.5547907,1.6241622,1.6792619,1.7565737,1.8315779,1.9130657,1.9977309,2.0839253,2.1732146,2.2437314,2.3286053,2.4183063,2.4913665,2.5511183,2.5290211,2.4767413,2.4185167,2.356238,2.2662507,2.1823338,2.0946514,2.0095374,1.9237093,1.8376631,1.7538983,1.6680804,1.58354,1.499964,1.4182184,1.3353578,1.2527125,1.1680874,1.0887456,1.0042533,0.92450477,0.83930258,0.75511682,0.67515512,0.59539742,0.50968846,0.42898487,0.34694421,0.2617797,0.18177309,0.098412671,0.013740238,-0.063552692,-0.1453181,-0.19993497,-0.28363547,-0.36418967,-0.44093835,-0.521729,-0.59361125,-0.67487235,-0.75252477,-0.83879068,-0.89921054,-0.98026813,-1.0541758,-1.1352151,-1.2066653,-1.2853958,-1.3239242,-1.3872595,-1.4542069,-1.5417493,-1.6586844,-1.7513598,-1.8145842,-1.8402826,-1.8136468,-1.7748114,-1.7197252,-1.6761615,-1.6434213,-1.6114673,-1.548014,-1.4947579,-1.4534577,-1.4011989,-1.3298402,-1.2599529,-1.2161139,-1.1512101,-1.0743934,-1.0015482,-0.93893346,-0.89858293,-0.83220316,-0.77733648,-0.68765765,-0.61713181,-0.54004463,-0.45398464,-0.36828325,-0.35856516,-0.42444171,-0.50177874,-0.58249078,-0.63526371,-0.69055666,-0.77186197,-0.85061118,-0.9342134,-1.0163499,-1.0967419,-1.1775575,-1.2565378,-1.3303389,-1.3889982,-1.3837423,-1.3228152,-1.2400973,-1.1675359,-1.0903927,-0.99949004,-0.88534707,-0.80277892,-0.72068456,-0.63773736,-0.53397569,-0.42984928,-0.33707001,-0.2709949,-0.2360161,-0.19136443,-0.1052325,1.5114397E-4,0.098486867,0.18363621,0.26866815,0.36071116,0.45010315,0.48525145,0.4190925,0.34889863,0.28268086,0.21655989,0.15357463,0.090057445,0.053259266,0.058571526,0.13309095,0.21087291,0.27583641,0.34712239,0.39747796,0.45240313,0.49778447,0.52373058,0.59628873,0.66817728,0.7285204,0.80448023,0.88432477,0.950547,0.8743899,0.78495009,0.69725485,0.62748687,0.54283442,0.45469779,0.40145423,0.39172365,0.42332346,0.36468757,0.28209621,0.19841398,0.10878351,0.023629766,-0.062070924,-0.15037615,-0.23343032,-0.3181494,-0.4035953,-0.48819397,-0.57297926,-0.6546563,-0.74368258,-0.82755898,-0.9080091,-0.99319655,-1.0427678,-1.0934484,-1.1290735,-1.1760586,-1.2601673,-1.323249,-1.3455165,-1.4049863,-1.3868949,-1.3908232,-1.3499163,-1.2806556,-1.2558839,-1.1627053,-1.1267764,-1.0621693,-0.97931139,-0.89706922,-0.80185289,-0.69953471,-0.59735049,-0.49993611,-0.39357357,-0.27938757,-0.17537376,-0.06103137,0.034173038,0.12933695,0.23916406,0.33755774,0.44708035,0.52855385,0.62802111,0.73888667,0.75577831,0.70575466,0.65015442,0.63249656,0.67069336,0.74246931,0.82779206,0.92107189,1.010862,1.0862584,1.1332816,1.2091587,1.2906158,1.3524795,1.4236957,1.4947441,1.563287,1.5385754,1.4377892,1.3628478,1.295373,1.2237786,1.182312,1.1882708,1.1371119,1.0429892,0.95691541,0.88231073,0.80169532,0.7250717,0.69245389,0.68949054,0.73909364,0.80452649,0.81535482,0.71929336,0.61837269,0.51341159,0.41589275,0.31569598,0.21945162,0.124314,0.030184603,-0.060215118,-0.14968413,-0.23833191,-0.32922605,-0.41830737,-0.48840027,-0.56702578,-0.63197403,-0.72829645,-0.81423357,-0.90801066,-0.96778752,-1.0124012,-0.95979143,-0.86922449,-0.84954976,-0.82176113,-0.73976761,-0.65486253,-0.57460105,-0.48612941,-0.40402079,-0.35248754,-0.29251078,-0.21600263,-0.12898176,-0.052489008,0.019669828,0.081513346,0.16755979,0.25642619,0.34366852,0.42855321,0.46802521,0.45971367,0.50820725,0.56411814,0.63816341,0.72185215,0.81286933,0.90572197,1.0004656,1.0720555,1.1700492,1.2671423,1.3281243,1.3497442,1.2965794,1.2212504,1.1477832,1.0799516,1.0175514,1.0079946,0.96129794,0.91775521,0.847503,0.77077992,0.69788582,0.6229885,0.54910361,0.49273747,0.44916746,0.46771155,0.52396189,0.59671336,0.66556699,0.73770085,0.81248442:5
1.8439196,1.81196,1.7723555,1.7532888,1.7197963,1.6756226,1.594859,1.5053632,1.4744329,1.4557097,1.3979043,1.3238339,1.2454798,1.1865016,1.1372347,1.0494336,0.97309129,0.8958362,0.8182318,0.7483427,0.68065732,0.60503249,0.52429644,0.45238357,0.38804689,0.34999561,0.34403487,0.36860752,0.39483245,0.43451528,0.47731493,0.52737225,0.58804323,0.6484079,0.70043043,0.74614172,0.66011511,0.5704416,0.4979207,0.43932949,0.37578742,0.34547844,0.27755996,0.18058525,0.085040503,-0.0092362209,-0.10349073,-0.19815852,-0.29350358,-0.36931604,-0.46189379,-0.54429459,-0.62219598,-0.69858596,-0.76115937,-0.8387083,-0.91665949,-0.99342545,-1.0895795,-1.1690324,-1.2293089,-1.2952728,-1.3621437,-1.4296212,-1.5004644,-1.5804841,-1.640988,-1.7021966,-1.7405461,-1.7932635,-1.8067537,-1.7685676,-1.7066868,-1.6362215,-1.5709967,-1.5112588,-1.4408095,-1.3696469,-1.3058248,-1.2367959,-1.1744827,-1.1037343,-1.0317021,-0.96520869,-0.90035487,-0.83775003,-0.87378892,-0.81917718,-0.74858473,-0.67734327,-0.61445305,-0.54215097,-0.46731951,-0.47054353,-0.53521623,-0.57522524,-0.63519453,-0.69784131,-0.75999459,-0.8153674,-0.86751966,-0.92355283,-0.98112774,-1.0304099,-1.0607111,-1.0522111,-1.0898081,-1.1389315,-1.1901833,-1.2348934,-1.2846191,-1.3234998,-1.3552277,-1.3774505,-1.3921367,-1.3994874,-1.4021336,-1.3936467,-1.376268,-1.3565143,-1.3335899,-1.3048617,-1.2728943,-1.234786,-1.207647,-1.1849186,-1.1221891,-1.052711,-0.96900977,-0.91002737,-0.85546803,-0.79944709,-0.74935735,-0.70670522,-0.65800824,-0.59574611,-0.54931201,-0.49476429,-0.43345568,-0.3885771,-0.37757366,-0.38083798,-0.36855306,-0.32771466,-0.29730365,-0.28213111,-0.25893061,-0.23597894,-0.20540427,-0.18109147,-0.15620051,-0.13372446,-0.11245337,-0.091232905,-0.076887139,-0.052926017,-0.028933849,0.0090854189,0.051050342,0.095038444,0.13558514,0.16105873,0.20257406,0.26593185,0.33333003,0.40172191,0.44930587,0.471871,0.49104092,0.5509278,0.62488885,0.68515619,0.74731935,0.79921042,0.8477127,0.89512143,0.92936664,0.97349647,1.0042079,1.0362836,1.0590982,1.081192,1.1025152,1.1221675,1.1592446,1.1910385,1.2504649,1.3413095,1.4127778,1.4795899,1.561239,1.6278867,1.7059668,1.7677546,1.8510328,1.9127245,1.9888672,2.0578088,2.1337315,2.1998737,2.2791565,2.2804782,2.241428,2.1665625,2.0848246,2.0223806,1.9419433,1.8771751,1.7984021,1.7337754,1.6558799,1.5741805,1.510066,1.4386376,1.3674086,1.2944849,1.2316368,1.17789,1.1268223,1.0897219,1.0664018,1.0449828,1.0164681,1.0016071,0.97752229,0.9469059,0.91782896,0.88135818,0.84847859,0.80588597,0.76878853,0.73151009,0.69404846,0.65731191,0.62543934,0.58499806,0.5439018,0.4986696,0.44438279,0.35719555,0.30075093,0.25295026,0.21255709,0.16322043,0.13411752,0.10458596,0.08604376,0.0601099,0.036836092,0.010423015,0.001093378,-0.0133945,-0.038161075,-0.057080641,-0.080664509,-0.0994333,-0.096659113,-0.090228577,-0.10277432,-0.10503537,-0.072260096,-0.034022882,-0.045985878,-0.051267356,-0.10731332,-0.15814881,-0.21765413,-0.27801209,-0.32910211,-0.38325875,-0.44158146,-0.49848947,-0.55776891,-0.61442289,-0.67818618,-0.75001103,-0.84165934,-0.93210573,-0.99757291,-1.0547219,-1.0864298,-1.1174222,-1.1384095,-1.1628672,-1.1849498,-1.205342,-1.2163205,-1.2150753,-1.2103958,-1.2011376,-1.1815033,-1.1679573,-1.1549527,-1.1263167,-1.1026916,-1.0646942,-1.0347222,-1.0065247,-0.98295098,-0.94438566,-0.90890933,-0.87852926,-0.84586967,-0.81243788,-0.77315293,-0.73791963,-0.68944249,-0.63453821,-0.58857291,-0.5354644,-0.48467815,-0.43970192,-0.38722891,-0.32624339,-0.27604909,-0.23317586,-0.29446662,-0.29083791,-0.2635567,-0.23306742,-0.19146556,-0.15085696,-0.10672137,-0.056617588,-0.010852225,0.043034869,0.096393257,0.12896936,0.17787474,0.22385758,0.27736614,0.23190161,0.17155244,0.10181454,0.028119561,-0.052933076,-0.148678,-0.22152366,-0.2691465,-0.34743173,-0.44190839,-0.53896366,-0.61579669,-0.71056653,-0.80637418,-0.90123359,-0.98455111,-1.0261981,-1.1025781,-1.1895286,-1.2757335,-1.3536592,-1.4161318,-1.4508161,-1.4525946,-1.446582,-1.434844,-1.4150745,-1.3859283,-1.3340522,-1.2832671,-1.2156243,-1.1548349,-1.0888276,-1.0286242,-0.96069237,-0.89442479,-0.82159414,-0.75008711,-0.68332673,-0.61062349,-0.54950465,-0.47204255,-0.40758163,-0.33299197,-0.26279878,-0.19698288,-0.12217684,-0.050080634,0.024378274,0.09159724,0.17064774,0.24250906,0.32259502,0.39219089,0.47498153,0.54751074,0.62337366,0.67953952,0.73959006,0.81469041,0.81767554,0.8715296,0.93234017,1.0212311,1.092691,1.1798806,1.2326412,1.1669859,1.1001709,1.0325231,0.97515833,0.91653226,0.86449825,0.81398113,0.76217452,0.71985708,0.68800358,0.69128149,0.7250982,0.77084292,0.84050095,0.90361605,0.97313328,1.040449,1.1320453,1.2262238,1.3026139,1.3969723,1.4683782,1.5627382,1.6223954,1.6757903,1.7293408,1.7691611,1.8075731,1.842624:4
2.8823287,2.720435,2.5807589,2.4389053,2.2787959,2.1166315,1.9945368,1.8337147,1.6717502,1.5501151,1.3879866,1.2651291,1.104481,0.96893647,0.81858133,0.67574123,0.56618195,0.40400552,0.28026349,0.11732456,-0.0040967056,-0.13624136,-0.2929276,-0.41737301,-0.54351421,-0.70281879,-0.83171393,-0.9478175,-1.0390295,-1.163766,-1.3196355,-1.3056987,-1.2570136,-1.2314322,-1.2096449,-1.1735266,-1.1497232,-1.0817692,-1.0008082,-0.90084102,-0.82803265,-0.77523465,-0.675308,-0.59325627,-0.49814842,-0.47678937,-0.39982947,-0.34065325,-0.30581572,-0.34533579,-0.24190986,-0.13424859,-0.077843302,-0.059005918,-0.034702989,0.032013803,0.090503468,0.1464653,0.11696667,0.070474116,0.077452514,0.10711911,0.1403441,0.12003104,0.15792526,0.18962445,0.15797575,0.043287711,-0.073535988,-0.18301765,-0.28476878,-0.34197773,-0.40614569,-0.35982932,-0.32682555,-0.27625931,-0.24587936,-0.23437833,-0.17159881,-0.13837958,-0.10619984,-0.047131639,-2.7123652E-4,0.043600159,0.11789672,0.19142551,0.25013676,0.2673484,0.33410277,0.38333662,0.4373827,0.47559354,0.414527,0.3328163,0.25711801,0.26832832,0.30834225,0.36421707,0.42068098,0.48332355,0.54671032,0.61889472,0.68882151,0.76827564,0.75290094,0.68415219,0.75786289,0.8432709,0.91759349,0.99894663,1.0856536,1.1636078,1.2415023,1.3195183,1.3997531,1.4353132,1.4601139,1.4907343,1.4879627,1.4331213,1.3332363,1.2190852,1.1049179,0.99403434,0.88102242,0.7520234,0.63560359,0.52035971,0.46271852,0.42582775,0.31474059,0.19944164,0.07680974,-0.038905169,-0.14522911,-0.26508556,-0.35233745,-0.34789857,-0.37448346,-0.43227787,-0.56563938,-0.68801852,-0.79059329,-0.90935719,-1.0251347,-1.1548226,-1.2544451,-1.3877819,-1.4885878,-1.6144945,-1.7284458,-1.8430191,-1.8530218,-1.7660199,-1.7474417,-1.6846479,-1.5794199,-1.4522212,-1.3476132,-1.2180372,-1.0972277,-1.0021643,-0.94438848,-0.94339016,-0.98516976,-0.94468474,-0.87012713,-0.73424989,-0.63847298,-0.59140227,-0.50834318,-0.42624171,-0.34014819,-0.28991736,-0.25662258,-0.31989456,-0.444141,-0.51257407,-0.50879166,-0.42197891,-0.31356221,-0.20354163,-0.14028558,-0.055064925,0.058331625,0.14198998,0.20188216,0.30995988,0.38527075,0.40923088,0.39667811,0.39083244,0.41826304,0.49721956,0.50016726,0.61579216,0.71755676,0.85295623,1.0136694,1.1343226,1.2539172,1.3333501,1.4130116,1.4128074,1.3283766,1.2084332,1.0838473,1.0126891,0.90375299,0.83124647,0.79023329,0.68741075,0.58041841,0.47633605,0.39726423,0.45778206,0.48414327,0.41300828,0.3178679,0.20119066,0.053683508,-0.056596673,-0.098575164,-0.21205351,-0.3323482,-0.44977204,-0.55229478,-0.48064551,-0.3765938,-0.2959145,-0.28338383,-0.33233646,-0.40584359,-0.48527155,-0.52686229,-0.60198259,-0.73377726,-0.71860392,-0.79079213,-0.91809318,-1.0347092,-1.1650922,-1.2705481,-1.3754976,-1.2963218,-1.2966036,-1.425416,-1.5277001,-1.6506536,-1.7526525,-1.86166,-1.9641733,-2.0602239,-2.122113,-2.1284582,-2.0501426,-1.9987436,-1.9408304,-1.8270961,-1.6957791,-1.5427109,-1.4292679,-1.3074347,-1.1866184,-1.0943755,-0.99559795,-0.87397361,-0.75526359,-0.6376804,-0.58286431,-0.56019384,-0.44895436,-0.32034687,-0.19063629,-0.079512356,0.044590445,0.15921766,0.27692305,0.40345205,0.50792966,0.61416311,0.72925521,0.83328579,0.96612746,1.0962766,1.1899887,1.3097705,1.4114033,1.5319683,1.6534283,1.7781236,1.8539332,1.8212428,1.7627065,1.7326953,1.6549597,1.5735922,1.5163608,1.4187004,1.3288582,1.2395179,1.1457506,1.1129139,1.0543211,0.97993944,0.90039694,0.81654561,0.8017618,0.72279783,0.61729586,0.54575724,0.5790402,0.58155799,0.5362956,0.46385397,0.38378967,0.313903,0.27293523,0.20669369,0.12785418,0.05695162,0.0045691519,-0.057430069,-0.083004499,-0.0082778444,0.085822608,0.22105503,0.31059758,0.28544546,0.22199454,0.17930228,0.14591018,0.068242058,0.056503115,-0.014200008,-0.12605635,-0.22722576,-0.26010168,-0.30079459,-0.36444783,-0.42485499,-0.46728433,-0.52150876,-0.55460975,-0.6199817,-0.65266762,-0.6962181,-0.74931187,-0.79106466,-0.82412256,-0.71660434,-0.6056788,-0.48448575,-0.3737554,-0.27447516,-0.14815119,-0.036917921,-6.4261421E-4,-0.017705079,-0.030847053,-0.053015498,-0.034107126,-0.094186575,-0.16177354,-0.19771868,-0.1762957,-0.12777816,-0.18150982,-0.25656146,-0.3274303,-0.42382343,-0.51911765,-0.58812167,-0.55392967,-0.59327945,-0.65692719,-0.72599065,-0.79327162,-0.84999874,-0.95989845,-0.97531921,-1.063586,-1.1253995,-1.1520632,-1.2062236,-1.2845101,-1.3261216,-1.3167323,-1.3105157,-1.328725,-1.3573363,-1.390534,-1.4345041,-1.4858709,-1.4652579,-1.3022679,-1.1792821,-1.0539574,-0.91720964,-0.76849316,-0.6439118,-0.51946171,-0.38340449,-0.23424264,-0.10723276,0.016667859,0.17351253,0.30383679,0.43644013,0.58136352,0.71473527,0.85560798,1.0012943,1.1281963,1.2875588,1.41088,1.5735424,1.6989792,1.8579985,2.0101887,2.1435462,2.3041447,2.4282536,2.5887784,2.7517047,2.8620844,2.8860114:3
1.896867,1.8033166,1.678907,1.5558146,1.4315986,1.3066097,1.2005996,1.096671,0.99971966,0.90933953,0.78986551,0.6971574,0.65205896,0.68889883,0.74415313,0.77453769,0.80168696,0.77247249,0.7510688,0.75624016,0.75468967,0.75808358,0.78933167,0.80095055,0.80650924,0.80155016,0.77638014,0.7584647,0.74286655,0.65092927,0.55091657,0.4619239,0.45977957,0.48165619,0.51727644,0.55744949,0.61000686,0.62324815,0.65389975,0.64958044,0.65386627,0.6670369,0.66341374,0.65158158,0.64218171,0.62579289,0.60489649,0.56398217,0.52490175,0.47523777,0.3855531,0.27739988,0.1705859,0.076820225,-0.039853214,-0.15041439,-0.22013993,-0.28969002,-0.37114146,-0.46400279,-0.5763191,-0.68473046,-0.80175726,-0.91589401,-1.0201898,-1.088307,-1.1834801,-1.2840644,-1.3486297,-1.3693017,-1.4529946,-1.4406647,-1.4997991,-1.493022,-1.4423322,-1.3939066,-1.3623731,-1.3218639,-1.2696732,-1.1872076,-1.1162679,-1.0332883,-0.99411549,-0.88742745,-0.82718166,-0.74161583,-0.64918626,-0.55267572,-0.45458869,-0.35625359,-0.25450674,-0.19323756,-0.12601154,-0.044403675,0.027553084,0.088017905,0.16120507,0.23201605,0.30414148,0.39246072,0.46238186,0.53534535,0.60742258,0.67874527,0.74308207,0.80683944,0.84765952,0.87882654,0.89122077,0.8894992,0.85996765,0.82768589,0.81462037,0.83249958,0.86399632,0.90153606,0.93186472,0.94787038,0.95289624,0.92442596,0.88646046,0.82654829,0.7215123,0.61462202,0.50963151,0.40549629,0.25927604,0.110723,0.010058767,-0.089778909,-0.17459757,-0.28277599,-0.37531019,-0.49003943,-0.56087504,-0.70806435,-0.83407464,-0.95752419,-1.0440681,-1.166349,-1.1882127,-1.2455007,-1.364947,-1.4703343,-1.5946325,-1.5506648,-1.6416213,-1.7352547,-1.8386959,-1.9312196,-1.9974104,-2.0426922,-2.1074204,-2.1971762,-2.2627651,-2.245314,-2.1448365,-2.0502191,-1.9368164,-1.839078,-1.7255478,-1.6134998,-1.5060406,-1.3992998,-1.2955439,-1.185916,-1.0782975,-0.97264803,-0.85416691,-0.75314665,-0.64323058,-0.52488582,-0.41913627,-0.30977475,-0.20770527,-0.091780754,0.02142501,0.13698788,0.26629113,0.37979054,0.48606467,0.61030084,0.73205154,0.82763662,0.89377335,0.95480068,0.96586478,0.9580072,0.94592985,0.9091126,0.8433322,0.75742213,0.67336281,0.59590377,0.50793804,0.42277587,0.32719283,0.23898293,0.14380708,0.068639705,0.12413854,0.22323916,0.33829107,0.48303975,0.59639685,0.70838513,0.83790822,0.94103823,1.0307153,1.1034263,1.1966109,1.2717696,1.3376832,1.3900832,1.4578289,1.5173637,1.5463608,1.5480746,1.5057335,1.450606,1.3733269,1.2910548,1.2018482,1.108163,1.0154138,1.0281292,1.0902887,1.1480703,1.21603,1.2676376,1.2628446,1.2221146,1.1618379,1.0994225,1.0271602,0.94923401,0.84433408,0.73466824,0.62621729,0.52343114,0.4117209,0.27349582,0.15767121,0.0091299504,-0.13580589,-0.28306289,-0.42152562,-0.56618992,-0.68692839,-0.8353571,-0.95756673,-1.0822213,-1.2048169,-1.335056,-1.4732172,-1.5870883,-1.7111867,-1.8522866,-1.8806173,-1.8245754,-1.7528272,-1.6592071,-1.558883,-1.5010849,-1.3977476,-1.2890334,-1.2312419,-1.171689,-1.0910835,-1.0111373,-0.89938322,-0.79354566,-0.71792741,-0.67379763,-0.61325223,-0.49726665,-0.39816888,-0.28162064,-0.18269478,-0.066988324,0.032146438,0.14171883,0.27172182,0.3324837,0.44561918,0.53374517,0.61883069,0.72790904,0.84765369,0.97566791,1.0842709,1.1281452,1.1920814,1.2005184,1.199035,1.169485,1.1307782,1.0806294,1.0025239,0.92702757,0.83442699,0.74477593,0.66140257,0.56535402,0.47724098,0.38914062,0.36577362,0.40535379,0.44450932,0.45275283,0.43817627,0.38076099,0.29513395,0.21528189,0.12470916,0.039414569,-0.033523117,-0.11483605,-0.19960396,-0.29597988,-0.37698542,-0.46970458,-0.55490521,-0.65046064,-0.73046953,-0.81422766,-0.89151589,-0.97193703,-1.0500044,-1.1371812,-1.2123533,-1.2945855,-1.3855221,-1.4726951,-1.5548545,-1.6232418,-1.6940575,-1.7583457,-1.8198165,-1.8788529,-1.9271921,-1.9582681,-1.9976422,-2.0241309,-2.0331066,-1.93376,-1.8338529,-1.7156402,-1.6206917,-1.5279323,-1.4226846,-1.3173945,-1.2106436,-1.1255154,-0.99730549,-0.91508388,-0.80822795,-0.66575716,-0.51548814,-0.38627489,-0.24051145,-0.11464833,0.012589893,0.12531997,0.24134034,0.3305189,0.3970563,0.44427242,0.45084015,0.4598452,0.45705502,0.45102723,0.43222607,0.41159338,0.40047457,0.37466489,0.3409648,0.31343652,0.28671683,0.25106239,0.20549714,0.13953949,0.099146987,0.037124937,-0.024770506,-0.097977748,-0.093797313,0.02102548,0.12987717,0.24618683,0.3145424,0.37379995,0.39853947,0.42442893,0.4382063,0.44896042,0.44405331,0.44386907,0.44075194,0.43653671,0.42446127,0.42985825,0.43702195,0.43826531,0.44616691,0.46394636,0.47524358,0.46239259,0.50867084,0.57106779,0.63767302,0.70420865,0.77722186,0.83904576,0.88341692,0.94440201,1.0191218,1.1717521,1.2953267,1.4215561,1.5482852,1.6579122,1.7818154,1.8917756,1.9172065,1.9254419,1.9351279:2
1.3972795,1.3303611,1.2808233,1.2416987,1.1853851,1.1247347,1.0886122,1.0919876,1.0478862,1.0072909,0.95268255,0.91463496,0.87526894,0.82233725,0.77091517,0.7195864,0.62606924,0.59421807,0.54740899,0.46673529,0.40883071,0.42754389,0.52526528,0.6004763,0.67779696,0.7749595,0.84787913,0.82288508,0.76346079,0.68508247,0.59340016,0.49628764,0.42201466,0.36219686,0.27395795,0.18443551,0.10394794,0.045369858,-0.04057353,-0.12516468,-0.19202163,-0.26069861,-0.33780293,-0.41761292,-0.49345447,-0.54208921,-0.58684444,-0.5429761,-0.50053232,-0.45436461,-0.33848229,-0.34769678,-0.23485818,-0.12029312,-0.0095162612,0.10787604,0.22329832,0.33658844,0.45853335,0.57472342,0.71908639,0.83032873,0.95024759,1.0534707,1.176017,1.2988018,1.3635949,1.4264278,1.5275398,1.6130399,1.6985813,1.8227796,1.8703844,1.801748,1.7095576,1.6138683,1.5190871,1.4459521,1.3881734,1.3142064,1.2333812,1.1580726,1.0615705,0.95470156,0.87988798,0.83760315,0.79843028,0.74227681,0.69635206,0.66240699,0.59481732,0.57942713,0.56708255,0.49620213,0.39913159,0.32792343,0.3314802,0.27242546,0.22262562,0.13889248,0.054486771,-0.034222419,-0.11907733,-0.19257827,-0.25094901,-0.2044333,-0.13219822,-0.064004169,0.01235597,0.069945889,0.13877711,0.12103513,0.085230217,0.012772955,-0.075864091,-0.19151124,-0.30452447,-0.41610995,-0.53572076,-0.6075184,-0.65300664,-0.62310835,-0.55555263,-0.46136932,-0.35603524,-0.25554171,-0.16097658,-0.10702823,-0.086015615,-0.093082238,-0.16919049,-0.26354108,-0.35603865,-0.33906973,-0.37148617,-0.31724466,-0.26018695,-0.2101656,-0.14166777,-0.094180786,-0.02590785,0.054867175,0.11581516,0.17323202,0.2260731,0.25887955,0.2814695,0.28240769,0.26542724,0.29727347,0.36102054,0.4138848,0.47119843,0.51604335,0.54117922,0.59835459,0.66358494,0.72080546,0.7511187,0.76619748,0.82643706,0.91877969,1.010001,1.0572,1.1303395,1.1948357,1.2084801,1.1024391,0.98659209,0.86957867,0.72457274,0.59874551,0.47340174,0.36523754,0.23973222,0.11399779,-0.0054860372,-0.11129949,-0.22202552,-0.33873922,-0.43673225,-0.54610791,-0.66134584,-0.78229546,-0.84346016,-0.87271839,-0.86177416,-0.82711235,-0.76853226,-0.7180334,-0.67562798,-0.63172451,-0.5548855,-0.4761165,-0.40478695,-0.31808445,-0.23108186,-0.16114773,-0.10457398,-0.025757819,0.061517297,0.11805392,0.14322141,0.20552219,0.29426907,0.36535066,0.45069809,0.54093405,0.63047877,0.72610479,0.81225142,0.90703117,0.90527853,0.82926698,0.71884921,0.60661944,0.51575993,0.438556,0.40873145,0.43658278,0.49039971,0.54670007,0.62191139,0.71987682,0.80066651,0.86455725,0.92077277,0.94325788,0.96604968,1.019505,1.0739911,1.1431392,1.1898943,1.2379239,1.2919034,1.3620873,1.4675851,1.5479242,1.5054273,1.4080766,1.2942527,1.1899912,1.0907413,0.99472684,0.90112928,0.80033649,0.6938654,0.60063774,0.50833818,0.41306994,0.31247574,0.21760573,0.11310343,0.011590065,-0.1038331,-0.21973123,-0.31802077,-0.41130303,-0.48926615,-0.57245908,-0.63443445,-0.72252519,-0.82146797,-0.93583573,-1.0643241,-1.1893917,-1.3333636,-1.4442278,-1.5868322,-1.6908827,-1.7757044,-1.8994931,-2.0140935,-2.1408153,-2.277775,-2.3764191,-2.5091503,-2.5737856,-2.6172622,-2.5351061,-2.5238109,-2.4503579,-2.4173685,-2.3444518,-2.2962238,-2.2127279,-2.1133684,-2.0325591,-1.9923825,-1.9080776,-1.8048287,-1.6797683,-1.5586728,-1.4679317,-1.3871787,-1.2843806,-1.1735747,-1.056995,-0.95592019,-0.86980515,-0.79953536,-0.69393822,-0.5796803,-0.48210439,-0.38093511,-0.28306709,-0.1929345,-0.1002155,0.0043881467,0.086162732,0.06275074,0.0040087199,-0.050951356,-0.1143153,-0.16857706,-0.20593428,-0.23386167,-0.22182633,-0.1634393,-0.079874519,0.012639542,0.099994279,0.19751526,0.28317624,0.37141792,0.45934717,0.53959419,0.6113048,0.69066796,0.76731081,0.85816126,0.94447605,1.0298886,1.1186991,1.1808202,1.2667063,1.3581979,1.382889,1.3202475,1.2178747,1.1576514,1.0515615,0.9832958,0.93614112,0.88877232,0.8328637,0.76439829,0.66236861,0.57154451,0.47435379,0.36968307,0.27853042,0.18630632,0.086334701,-0.0039018135,-0.069684991,-0.15173645,-0.23865888,-0.26918086,-0.2469657,-0.22188866,-0.19838283,-0.17973582,-0.25012017,-0.33733312,-0.42070108,-0.51444607,-0.6039223,-0.69637605,-0.78304541,-0.87115772,-0.96162596,-1.0698434,-1.156578,-1.2342019,-1.2956238,-1.370018,-1.4551544,-1.533726,-1.6040918,-1.6777658,-1.7466658,-1.8031296,-1.8706057,-1.959037,-2.0453993,-2.1439672,-2.2269947,-2.2969342,-2.3208596,-2.3252982,-2.3563161,-2.2641281,-2.1390732,-2.0175857,-1.8939927,-1.7962397,-1.681792,-1.5703737,-1.4608169,-1.3603763,-1.2404124,-1.1393941,-1.0218934,-0.89542407,-0.77098603,-0.64433408,-0.50805358,-0.38687282,-0.27836561,-0.1987893,-0.11274321,-0.027493096,0.088204964,0.19919776,0.31568618,0.43785063,0.55534347,0.66964047,0.77559248,0.86740505,0.96869946,1.0821974,1.1818237,1.291573,1.3374897,1.3773754:5
0.74773989,0.65805783,0.5893236,0.51978248,0.46092019,0.41501213,0.37149244,0.44481005,0.4197706,0.37402994,0.32427622,0.28016156,0.24083509,0.22121629,0.20732658,0.19347117,0.18268615,0.18160561,0.18171993,0.19178733,0.21625125,0.2390289,0.25658063,0.27939842,0.31839742,0.44915127,0.55733051,0.65665344,0.75328763,0.83920286,0.92972095,1.0387589,1.1475143,1.2528966,1.2060706,1.128896,1.1276001,1.140752,1.1447448,1.1695582,1.1937492,1.2175095,1.2563484,1.3056194,1.3520361,1.396799,1.4287575,1.4518122,1.4683078,1.4740849,1.475192,1.4590115,1.4366712,1.4255661,1.4417409,1.5286362,1.6086536,1.4983442,1.6446771,1.6271315,1.5075227,1.4126654,1.349495,1.354071,1.3934582,1.4328824,1.4560428,1.4662012,1.4846487,1.5044874,1.514963,1.513391,1.5015039,1.4905361,1.4774759,1.4641645,1.4636226,1.4656591,1.3761871,1.3111923,1.2174508,1.1098136,0.99647201,0.91003035,0.87408059,0.85635211,0.82836512,0.81766519,0.78259339,0.75900943,0.76192347,0.77109893,0.79108181,0.81321175,0.84105272,0.80957731,0.80698312,0.83639565,0.86116723,0.89187536,0.93324949,0.91236874,0.84499179,0.75585141,0.65457375,0.56586888,0.47584013,0.37718683,0.28518373,0.20251322,0.10772505,0.022031234,-0.076455558,-0.181144,-0.29761053,-0.41787366,-0.50987275,-0.59808772,-0.64543902,-0.69578672,-0.71578135,-0.75087908,-0.77964966,-0.79982518,-0.80273818,-0.80582504,-0.79495518,-0.7888528,-0.78024915,-0.7646184,-0.744441,-0.71337982,-0.67688637,-0.64447384,-0.61361057,-0.57001355,-0.52335048,-0.45989658,-0.39064136,-0.31896618,-0.23830549,-0.1606776,-0.070624866,-0.11605755,-0.21632533,-0.21779713,-0.17094666,-0.1089347,-0.047502205,0.022506132,0.10352566,0.2071999,0.29688012,0.3761663,0.49941144,0.59853762,0.58221011,0.43342025,0.2847303,0.16092005,0.048944835,-0.063201664,-0.20936845,-0.26229225,-0.35955539,-0.45764603,-0.55762294,-0.67601937,-0.79787235,-0.92103106,-1.0682882,-1.204773,-1.336153,-1.4339447,-1.5658548,-1.6874049,-1.767833,-1.8464674,-1.9075081,-1.9476925,-1.9591323,-1.9367878,-1.8843507,-1.8393881,-1.801272,-1.7278614,-1.6532566,-1.5756546,-1.4941278,-1.4043895,-1.3108882,-1.212391,-1.1241613,-1.0327964,-0.92728528,-0.83208435,-0.72931636,-0.6271625,-0.53157602,-0.42300136,-0.32240698,-0.21617,-0.11386369,-0.081995093,-0.1701284,-0.15078722,-0.050075726,0.062634034,0.16589744,0.27474131,0.38315766,0.4888533,0.60171092,0.60234253,0.49716927,0.39384213,0.29287154,0.22652365,0.12706072,0.018769779,-0.086698677,-0.18360541,-0.28892018,-0.38726144,-0.4774278,-0.57856838,-0.66147381,-0.73765055,-0.78424135,-0.77643117,-0.73112099,-0.66866408,-0.58378207,-0.47194339,-0.35793911,-0.21408702,-0.072315459,0.073304416,0.19127723,0.27287703,0.39866183,0.49912443,0.62285956,0.74644661,0.89175859,1.000375,1.108832,1.2131315,1.3036277,1.231215,1.1610484,1.0857769,1.0293067,1.0393431,1.1270375,1.2525023,1.3990177,1.5242087,1.6726251,1.7591868,1.8050041,1.7889291,1.679619,1.6577591,1.5522605,1.427162,1.3235662,1.223845,1.1321881,1.053067,1.0342206,1.1054119,1.2028852,1.3011847,1.3431133,1.2218635,1.1210971,0.99257158,0.84387937,0.73733909,0.62180493,0.50146497,0.40087667,0.27861131,0.15631693,0.053232166,-0.06249906,-0.18275002,-0.26047238,-0.31120394,-0.32110991,-0.28482379,-0.22988285,-0.1450279,-0.060535144,0.02740786,0.11677592,0.21290467,0.31187619,0.42134591,0.52461264,0.61140329,0.72702202,0.83667076,0.94612578,1.0427045,0.92614101,0.78417845,0.66223815,0.53970433,0.39632438,0.27412149,0.14114102,0.1357453,0.23504033,0.21127641,0.090318248,-0.016686319,-0.12944971,-0.24687198,-0.36394747,-0.47479923,-0.58049151,-0.69258124,-0.81062241,-0.92396271,-1.0362283,-1.1535497,-1.276599,-1.3983218,-1.5125272,-1.6323598,-1.7435897,-1.8500679,-1.9569388,-2.0742568,-2.1868886,-2.2867771,-2.4031672,-2.4704026,-2.5083954,-2.4855049,-2.4184736,-2.2856258,-2.2159843,-2.0975431,-1.9836852,-1.8693286,-1.7686538,-1.6542307,-1.5499707,-1.4341802,-1.3265884,-1.2264078,-1.1151717,-1.0043794,-0.88634412,-0.78414608,-0.67904136,-0.57284368,-0.46992939,-0.45504927,-0.3474115,-0.24180347,-0.13718521,-0.040920862,0.070466321,0.16955344,0.26815195,0.16583152,0.075351371,0.024492228,-0.070320495,-0.16236933,-0.24922809,-0.32961597,-0.40642194,-0.48252894,-0.48741421,-0.38575636,-0.25965105,-0.29637313,-0.40650733,-0.48652057,-0.51414249,-0.58734005,-0.66126166,-0.73891695,-0.81209389,-0.88083844,-0.93896849,-0.99783606,-1.0503256,-1.1031032,-1.1507252,-1.1875556,-1.2214823,-1.2534204,-1.2732,-1.295495,-1.3213712,-1.3256352,-1.3321968,-1.3223166,-1.3173099,-1.3123069,-1.3026515,-1.2765707,-1.1977231,-1.0939538,-0.98790752,-0.87528125,-0.7745562,-0.6635598,-0.56158055,-0.45508425,-0.33041651,-0.24382361,-0.14129539,-0.050278428,0.070461644,0.16800331,0.29618599,0.38904405,0.48144477,0.57849289,0.67924236:4
1.3830042,1.2807208,1.0804744,0.86620792,0.68250539,0.57396489,0.39703042,0.27326631,0.17450313,0.077855184,-0.025602406,-0.17544716,-0.30162344,-0.4504974,-0.65300462,-0.81112813,-0.88594792,-0.96479312,-0.83605737,-0.70010624,-0.5709887,-0.43460263,-0.28805017,-0.20538621,-0.062810747,0.039707637,0.15139565,0.27648456,0.21399889,0.27090315,0.35108098,0.49799211,0.56598187,0.6484156,0.82881573,0.92147014,0.88399063,1.0211392,1.2114525,1.3671858,1.5145075,1.5684346,1.7331146,1.9059728,2.0895818,2.0812081,1.9388342,1.7936161,1.6302895,1.4838148,1.3467992,1.2032068,1.0642991,0.92537604,0.79671152,0.66834514,0.51580757,0.38722676,0.23669633,0.10818543,-1.2288872E-4,-0.12136168,-0.18013954,-0.31024483,-0.43820677,-0.58931631,-0.73575182,-0.8610157,-0.9793829,-1.0759937,-1.1263235,-1.2536578,-1.4110739,-1.4607508,-1.3731467,-1.3712737,-1.3070067,-1.246998,-1.0916288,-0.95100127,-0.88612599,-0.72159843,-0.72461648,-0.62792579,-0.50352498,-0.42715087,-0.32608245,-0.23215413,-0.16177122,-0.077224474,0.031040477,0.15717444,0.19515346,0.30713719,0.40205105,0.27208006,0.18084603,0.11326191,0.065236158,0.06822369,-0.037750008,-0.18252791,-0.11498771,-0.2992227,-0.27085949,-0.37055482,-0.43511986,-0.52392148,-0.62271243,-0.6181967,-0.71792483,-0.83258193,-0.91712739,-1.0883601,-1.2301467,-1.3254802,-1.4651256,-1.4323486,-1.3200087,-1.152741,-1.0288429,-0.98291916,-0.8767931,-0.81649349,-0.63640038,-0.50856022,-0.34867922,-0.2066926,-0.054453907,0.098223049,0.2500824,0.40719067,0.54702368,0.70589881,0.73971434,0.86805234,1.0198396,1.1612198,1.332855,1.4807791,1.620742,1.782001,1.9479404,2.0575809,1.9603374,1.8035524,1.6268973,1.4824315,1.3550795,1.3051134,1.1483223,1.0121072,0.96556066,0.90344253,0.77359528,0.68336814,0.56796052,0.52859059,0.40935298,0.34804141,0.24364425,0.22290072,0.26343548,0.11719099,0.0094753011,-0.1253506,-0.25925498,-0.36663895,-0.49440201,-0.62958147,-0.73821922,-0.87789567,-0.85131846,-0.9792027,-0.86715382,-0.73988207,-0.52797184,-0.36382732,-0.21421433,-0.032175806,0.13374176,0.23430497,0.18566019,0.37800049,0.60307317,0.78208882,0.94703614,1.168479,1.3690428,1.337923,1.2157858,1.0924685,1.0291359,0.91428559,0.77764151,0.65933268,0.68406207,0.58230666,0.46353004,0.35982545,0.35708607,0.35832653,0.30108348,0.20267511,0.11956311,0.017778399,-0.090987188,-0.030799999,0.087523211,-0.010873796,-0.10312832,-0.1811314,-0.2799239,-0.30122609,-0.31284809,-0.41245579,-0.5042461,-0.61498642,-0.75245844,-0.88149055,-0.93098668,-1.0156567,-0.93840512,-0.83117683,-0.69817315,-0.63079168,-0.45987087,-0.35802065,-0.29865242,-0.15350921,-0.0098662233,-0.042340839,0.07338539,0.22491627,0.35389428,0.47586525,0.64754378,0.69797038,0.57165954,0.4723943,0.36515611,0.21506563,0.34733689,0.27154753,0.12672757,0.055675111,0.11389462,0.05232952,-0.02334196,-0.14774617,-0.23570416,-0.1661325,-0.28168647,-0.41110473,-0.54262413,-0.692063,-0.82339141,-0.95602146,-0.8083526,-0.6333052,-0.5157992,-0.40610729,-0.32191408,-0.39933159,-0.51440979,-0.62687636,-0.74186409,-0.82031084,-0.93068164,-1.0432421,-1.170901,-1.2894848,-1.4079094,-1.314451,-1.3666898,-1.4459591,-1.5262323,-1.6398709,-1.7481706,-1.8614073,-1.8416069,-1.7278031,-1.5996057,-1.3733724,-1.1471073,-0.92828869,-0.79648943,-0.6210614,-0.39475024,-0.16860054,0.057523763,0.23262584,0.45883773,0.68503064,0.91119244,1.1374044,1.3635497,1.5897839,1.816058,2.002522,2.2177943,2.3934135,2.6196434,2.7955666,2.9566597,2.9513595,2.9645531,2.8175709,2.6983675,2.4762782,2.2842947,2.1169998,1.9874377,1.7860305,1.582801,1.4051933,1.1786234,0.95395259,0.72781414,0.50237162,0.29281734,0.10272859,-0.072847458,-0.29841854,-0.47213148,-0.69789956,-0.92206736,-1.1461205,-1.3697321,-1.563145,-1.4079234,-1.428745,-1.655999,-1.6774419,-1.897421,-2.1126659,-2.1813807,-2.2110586,-2.0704178,-1.9298271,-1.8415697,-1.7168528,-1.5786534,-1.5275882,-1.4105338,-1.2909849,-1.1746866,-1.1279028,-1.0338979,-0.8970465,-0.79806465,-0.67146126,-0.70938736,-0.79316797,-0.97542237,-0.98286064,-0.82067319,-0.66490621,-0.57802847,-0.45030782,-0.34301813,-0.25368557,-0.2133329,-0.076576404,0.014890581,0.10583207,0.047619917,-0.069042244,0.089985477,0.18023639,0.24155466,0.29850732,0.37444695,0.45088696,0.37069529,0.4259527,0.50040072,0.6077231,0.68128553,0.73974862,0.84602546,0.9367398,0.80019173,0.62495738,0.45498689,0.31545083,0.12805285,-0.01100447,-0.074138908,-0.22339597,-0.40559776,-0.59039257,-0.73772547,-0.91605043,-1.0221799,-1.1843211,-1.2860858,-1.1932128,-1.0718904,-0.94590656,-0.87220401,-0.80821437,-0.72136583,-0.59495483,-0.47864566,-0.37853098,-0.26719058,-0.18463672,-0.27269942,-0.19023929,-0.17330665,-0.065635143,0.019186891,0.0084743899,0.12029451,0.22392974,0.34515495,0.34958667,0.46914761,0.57093205,0.67645932,0.75665772,0.88749732,1.0248803,1.1108439,1.2415076,1.3554705:1
1.7479866,1.6654565,1.5687803,1.4719573,1.3948188,1.3607257,1.3689848,1.3788617,1.391683,1.3962204,1.39056,1.3796317,1.3690579,1.3529887,1.3439121,1.3222036,1.3075557,1.292191,1.2730605,1.2574636,1.232033,1.1844045,1.0991118,1.0120821,0.93557646,0.85191821,0.77723739,0.71464166,0.65558707,0.61948928,0.58824414,0.56180538,0.53055745,0.50374781,0.50991914,0.55925344,0.59781659,0.62549303,0.63842442,0.68911591,0.741183,0.64610148,0.56635765,0.46773625,0.40046478,0.3187136,0.25588766,0.18551381,0.12766575,0.07308295,0.025492846,-0.008677951,-0.046106775,-0.092812672,-0.1782831,-0.25096038,-0.34072326,-0.41813172,-0.48801153,-0.55186886,-0.62244693,-0.68476449,-0.73659231,-0.78221594,-0.80262864,-0.81726981,-0.83162767,-0.8398866,-0.83483215,-0.82231951,-0.81056013,-0.78210998,-0.75659707,-0.73069629,-0.7049705,-0.67082753,-0.62688464,-0.57830842,-0.5282078,-0.47375534,-0.43531112,-0.40018851,-0.342914,-0.28022227,-0.205298,-0.12714492,-0.045454388,0.033389378,0.10484148,0.18129815,0.25647355,0.20417699,0.086978553,-0.010693767,-0.10621675,-0.19541022,-0.28165171,-0.38204088,-0.45943396,-0.53563884,-0.62653204,-0.70771029,-0.80029936,-0.8838494,-0.97800093,-1.0604011,-1.146958,-1.2232937,-1.3079914,-1.3858017,-1.4724913,-1.5583504,-1.643395,-1.7442363,-1.8321027,-1.8750896,-1.9269717,-1.9477834,-1.9808556,-2.0218425,-2.0398398,-2.0473937,-2.0301511,-2.0036125,-1.9591428,-1.8949855,-1.8261576,-1.7360005,-1.650619,-1.5443236,-1.4370108,-1.3247192,-1.2099771,-1.0928293,-1.0021059,-0.88205877,-0.78762612,-0.69182641,-0.57337078,-0.48006958,-0.35814697,-0.30945291,-0.32728689,-0.32238939,-0.2664027,-0.17997481,-0.061133649,0.05786513,0.1769725,0.27317217,0.36838109,0.48710445,0.60781293,0.70463576,0.70058446,0.59465479,0.49737039,0.40033948,0.30279546,0.20436879,0.12682319,0.074331989,0.004580042,-0.059462815,-0.13209851,-0.19825402,-0.24329961,-0.2829515,-0.30327968,-0.27573754,-0.21519985,-0.14286032,-0.0719123,0.0091784754,0.095827757,0.179605,0.25902817,0.34905145,0.44591272,0.5248071,0.61900532,0.70262747,0.79013769,0.88639409,0.96672107,1.059204,1.1571445,1.2546002,1.3505541,1.4704423,1.5761985,1.5149886,1.4804662,1.4249148,1.347966,1.3079934,1.3665425,1.4382923,1.5190129,1.6163729,1.6920681,1.7750747,1.8719484,1.9609295,2.0210223,2.0185595,1.9339138,1.83381,1.7376734,1.6670618,1.6494867,1.5327338,1.4391392,1.3429676,1.2376759,1.1325636,1.0150677,0.92304616,0.81187166,0.70325115,0.62249938,0.52002306,0.44828871,0.406824,0.37525979,0.40508289,0.48311989,0.55908711,0.63644629,0.72232039,0.80639899,0.89084128,0.96242048,1.0466371,1.0440805,0.9496669,0.8630397,0.77006567,0.68441254,0.59681466,0.5067805,0.5192561,0.43562632,0.34921288,0.26494224,0.16932057,0.081815207,0.0041896961,-0.091395912,-0.1706447,-0.26676942,-0.34899522,-0.43723846,-0.52895571,-0.6072579,-0.70249251,-0.78282921,-0.87751407,-0.95720335,-1.0400111,-1.1301722,-1.2104931,-1.3026673,-1.3832403,-1.4597392,-1.5488936,-1.6287715,-1.7125223,-1.7821339,-1.8537278,-1.9095175,-1.964193,-1.9984951,-1.9838486,-1.9508004,-1.888106,-1.8041521,-1.6833233,-1.5622218,-1.4681127,-1.3463907,-1.2252296,-1.1047202,-0.98436255,-0.89116358,-0.76989966,-0.69429385,-0.60962335,-0.5169377,-0.45595833,-0.38893032,-0.29522728,-0.2014243,-0.1030975,0.011870354,0.10818794,0.2027939,0.27306596,0.24218647,0.14755869,0.026395997,-0.071568245,-0.18499635,-0.25706403,-0.21869787,-0.13668296,-0.2175054,-0.30686014,-0.3859218,-0.47206439,-0.55905419,-0.64895266,-0.74082555,-0.82071201,-0.88689783,-0.94991515,-0.99284136,-1.0499718,-1.0898096,-1.1315186,-1.180596,-1.2249275,-1.2739807,-1.3188938,-1.3583243,-1.3848951,-1.4073064,-1.4248823,-1.4486046,-1.4514344,-1.4517632,-1.4471051,-1.433937,-1.4242881,-1.4048965,-1.3779657,-1.3531658,-1.3196653,-1.2885047,-1.2415651,-1.1866777,-1.1282875,-1.0711907,-0.98600001,-0.89616068,-0.80342953,-0.70607253,-0.62238207,-0.54950286,-0.49969027,-0.44045212,-0.38511359,-0.33127654,-0.26211218,-0.2035751,-0.14169944,-0.070109378,-0.0026505695,0.063425693,0.13023418,0.21138122,0.27937184,0.36616218,0.44869506,0.53621766,0.62078592,0.70098541,0.78051839,0.86693778,0.94439778,0.97896905,0.89981074,0.82057682,0.74753727,0.66896216,0.59601828,0.52702777,0.45336347,0.39295068,0.3366352,0.31998642,0.30298508,0.28514897,0.27533967,0.28185662,0.2948834,0.31525635,0.34848474,0.41198449,0.5014103,0.59966596,0.66759193,0.73299196,0.68147644,0.61918172,0.58866048,0.58120359,0.5825824,0.60726151,0.63192249,0.66133187,0.69368676,0.72785104,0.76980538,0.81683795,0.85427616,0.88703496,0.919836,0.94875603,0.98660935,1.0136152,1.0523113,1.0790659,1.0888741,1.1047303,1.1157132,1.1217784,1.1169974,1.1142736,1.155942,1.2308558,1.3120318,1.3917076,1.4902079,1.5727241,1.6662417,1.735929:4
-0.49011338,-0.55857712,-0.62765675,-0.68911713,-0.70620182,-0.76936001,-0.83145302,-0.89047253,-0.93495736,-0.98508404,-1.0225235,-1.052205,-1.0530069,-1.0357741,-0.97450026,-0.96421461,-1.0130679,-1.0593836,-1.0828034,-1.1039278,-1.1263273,-1.1441982,-1.1596787,-1.1620514,-1.1596819,-1.1659002,-1.1675762,-1.1573312,-1.1519219,-1.1466109,-1.1437615,-1.1368567,-1.124055,-1.1110863,-1.0877436,-1.0524596,-1.0167576,-0.96948386,-0.92104351,-0.87306554,-0.82339807,-0.76058459,-0.67228906,-0.60521849,-0.50971405,-0.4089177,-0.33349408,-0.24463231,-0.17308022,-0.093523412,-0.029187422,0.030774289,0.093432894,0.16245465,0.21751878,0.2845665,0.34480081,0.410476,0.46204161,0.52779317,0.58526384,0.64493344,0.7048004,0.72561825,0.71038895,0.70303935,0.69470978,0.70597382,0.72936756,0.77671381,0.84054449,0.81867337,0.8053507,0.79832123,0.79592194,0.79475049,0.79695646,0.80886939,0.83026269,0.86173291,0.90096522,0.94543244,0.9965319,1.0573676,1.1218216,1.1997455,1.2468473,1.3252731,1.4013468,1.473576,1.5045791,1.5357374,1.5987822,1.6074633,1.6190695,1.6267736,1.6297476,1.625339,1.6227038,1.6209787,1.6167442,1.6102665,1.6030691,1.5921165,1.5691459,1.5606001,1.5584922,1.5813829,1.6231196,1.6895704,1.7394814,1.7910226,1.7286151,1.6432617,1.6219645,1.5996156,1.5707165,1.5442436,1.5144132,1.4759102,1.425899,1.3824537,1.3336574,1.2947781,1.2489224,1.2211972,1.1587042,1.1356462,1.0854535,1.0524508,0.98390914,0.95407408,0.87487254,0.84980731,0.82131724,0.80350599,0.75820035,0.72195821,0.67543505,0.6103862,0.53982622,0.46250288,0.4167663,0.38836445,0.36170892,0.34506967,0.34799866,0.34054533,0.34203881,0.3409627,0.34774391,0.3377721,0.31397208,0.31494011,0.31092159,0.31193415,0.31332865,0.31412396,0.30655936,0.24332466,0.17890077,0.17579297,0.19909304,0.2261826,0.2747424,0.23649622,0.21214186,0.12706563,0.035639173,-0.038875606,-0.11553481,-0.19027168,-0.27480482,-0.35155656,-0.42789487,-0.49859794,-0.56444798,-0.63709211,-0.70566853,-0.75967693,-0.81784119,-0.86084106,-0.90419484,-0.91975195,-0.93235395,-0.94119748,-0.95127701,-0.95564447,-0.94539952,-0.94303313,-0.94001559,-0.91961355,-0.90216269,-0.89071668,-0.86684769,-0.84158576,-0.80836402,-0.77170475,-0.74478373,-0.70775473,-0.66791238,-0.64138851,-0.69119255,-0.67020096,-0.63124598,-0.58559335,-0.5324152,-0.48284743,-0.43086274,-0.37346576,-0.31717478,-0.25737458,-0.30092391,-0.38074717,-0.4458884,-0.52191375,-0.60504873,-0.68651357,-0.73603989,-0.76887233,-0.84951021,-0.91737349,-0.99458583,-1.0864898,-1.1701982,-1.2644705,-1.3264494,-1.4115218,-1.4660482,-1.5192067,-1.5688431,-1.5972607,-1.6219374,-1.632268,-1.6413461,-1.6517995,-1.6444475,-1.6289059,-1.5900613,-1.5469325,-1.4972413,-1.4205454,-1.3365115,-1.277222,-1.1952489,-1.1061208,-1.0124199,-0.92021735,-0.82509774,-0.73009168,-0.65661422,-0.56061745,-0.46449741,-0.38811316,-0.28622923,-0.21197829,-0.11237199,-0.013926898,-0.0073002225,0.0062900851,0.048786583,0.12211364,0.19229721,0.28877621,0.38951662,0.4793406,0.56713961,0.6684059,0.70265785,0.64898011,0.58212821,0.51935805,0.45379137,0.38173286,0.31908724,0.25261304,0.20242703,0.15797783,0.12327673,0.10285822,0.10822641,0.14136333,0.18567745,0.23188933,0.2977928,0.36098075,0.419205,0.48724732,0.55279794,0.61797758,0.6944995,0.76221899,0.82724092,0.90217632,0.97249021,1.0319332,1.0859725,1.1574735,1.2306445,1.1957271,1.1627969,1.2021464,1.2662068,1.3425809,1.4183057,1.4912304,1.5711136,1.6709631,1.7389416,1.8250983,1.9060875,1.9496696,1.8591222,1.784005,1.6822124,1.6147121,1.5467703,1.444769,1.3442739,1.2450937,1.1752896,1.1087704,1.0878973,1.1217297,1.1691821,1.2388635,1.2123408,1.1140501,1.0158233,0.94339428,0.84627244,0.79806502,0.75550037,0.67517464,0.59475893,0.51618994,0.43726113,0.35989501,0.25674812,0.18040115,0.091579995,0.0076515226,-0.078843418,-0.14823101,-0.20470538,-0.23666947,-0.25105125,-0.2302014,-0.1744465,-0.11230763,-0.052138281,0.01049594,0.083185959,0.14674786,0.22078637,0.29811652,0.36560199,0.43072904,0.50297021,0.58049518,0.65952196,0.73390889,0.75821242,0.67329594,0.58483776,0.51422416,0.42364634,0.3510619,0.30640198,0.23321548,0.15897791,0.082989697,0.0090668559,-0.0818027,-0.14591567,-0.21322125,-0.25111527,-0.19497041,-0.2479864,-0.32368318,-0.40216079,-0.48149566,-0.54192648,-0.61421056,-0.69031775,-0.76228129,-0.82745109,-0.91253382,-0.97364386,-1.0468742,-1.1148313,-1.1832126,-1.2503421,-1.3193944,-1.3941616,-1.4612359,-1.5187398,-1.5903406,-1.6555796,-1.7144067,-1.7697559,-1.8208972,-1.8810288,-1.9140654,-1.9420987,-1.938862,-1.9304393,-1.9025456,-1.872712,-1.8366531,-1.7908141,-1.7400222,-1.6836062,-1.6127314,-1.5349526,-1.4576589,-1.3786513,-1.2764964,-1.1836248,-1.0973686,-1.046219,-0.96503561,-0.88853205,-0.80402956,-0.71394743,-0.61241717,-0.51071719:4
2.8690456,2.7611631,2.6585194,2.5302284,2.4073112,2.2863293,2.1763651,2.0487948,1.924373,1.7998734,1.6726027,1.5472063,1.4239382,1.297328,1.1740733,1.0485305,0.9255009,0.80218973,0.67382982,0.54854143,0.42268533,0.31660455,0.19387492,0.064466645,-0.041473731,-0.16534028,-0.2877467,-0.40691346,-0.52460883,-0.64682268,-0.77200101,-0.89013664,-0.99857899,-1.0846803,-1.2079795,-1.3165361,-1.4339495,-1.5440554,-1.6674454,-1.7859057,-1.8472341,-1.8529517,-1.8790021,-1.8858646,-1.9581135,-1.9185117,-1.8010504,-1.7022523,-1.6101761,-1.537211,-1.4698641,-1.4178389,-1.3377313,-1.3000695,-1.3197677,-1.1977892,-1.1372953,-1.0109814,-0.92907321,-0.81816393,-0.71829424,-0.68532109,-0.69842255,-0.73768124,-0.67778204,-0.62332008,-0.58733682,-0.53029886,-0.43976506,-0.38213785,-0.40489868,-0.39180319,-0.31871956,-0.2482178,-0.1922624,-0.14185054,-0.091609659,-0.039468459,-0.0338842,-0.11133243,-0.26019281,-0.38357003,-0.47152538,-0.59305679,-0.69292681,-0.77876276,-0.86869308,-0.90694251,-0.83846826,-0.75907456,-0.72700599,-0.69834329,-0.62863975,-0.55640278,-0.47239003,-0.39085025,-0.35261032,-0.47528367,-0.54545733,-0.47779673,-0.38615073,-0.29327233,-0.21096079,-0.13834858,-0.061390809,0.023802076,0.12052113,0.18883697,0.18869364,0.087261034,-0.004220713,-0.016960421,0.046357291,0.14245287,0.21951623,0.27800292,0.37647984,0.47459216,0.53258945,0.62888316,0.72896727,0.83332816,0.94402699,1.0585163,1.1640167,1.2516589,1.3489526,1.386916,1.3773485,1.279801,1.1667107,1.044933,0.94457622,0.84025018,0.72114074,0.67419392,0.56677088,0.44405322,0.33715314,0.23609168,0.12472698,0.011951977,0.029097783,0.013318518,-0.084606891,-0.18948153,-0.29353739,-0.4102095,-0.50998019,-0.62417516,-0.66013486,-0.71583185,-0.828618,-0.93477381,-1.0278862,-1.0888098,-1.1785326,-1.214771,-1.1241491,-1.0058536,-0.9009009,-0.79348124,-0.69273864,-0.58861418,-0.51752614,-0.47202141,-0.55949635,-0.56237573,-0.44954121,-0.30889009,-0.2383519,-0.15528948,-0.087427143,-0.13423373,-0.066645719,-0.014093086,0.067490239,0.14558563,0.23474346,0.29673828,0.23674725,0.16892797,0.078054913,0.032440889,0.030533818,0.11152587,0.216744,0.32385809,0.34526919,0.43844431,0.58673854,0.71829209,0.80609289,0.83461379,0.77354896,0.75344434,0.87876406,0.97648623,1.1018315,1.227481,1.2064369,1.2937389,1.4094121,1.5277246,1.638926,1.7596316,1.8637653,1.8628807,1.7835687,1.6742985,1.5307329,1.4627373,1.3118693,1.1924745,1.12394,1.0586552,0.93581985,0.81087133,0.78987482,0.75908614,0.62996025,0.48622436,0.36573649,0.3240661,0.20876335,0.073963912,-0.057809038,-0.044146065,-0.0029500097,0.055858301,0.14520814,0.25023109,0.29018827,0.23501645,0.15272878,0.050912538,-0.032634417,-0.15925687,-0.17225818,-0.2888433,-0.39652627,-0.50931916,-0.61355923,-0.6073288,-0.65060576,-0.74865698,-0.85464153,-0.95501071,-1.0503754,-1.1471171,-1.2280358,-1.2860489,-1.1527299,-1.0376991,-0.94258656,-0.7971777,-0.6695941,-0.5475605,-0.42508232,-0.30307502,-0.20344085,-0.1366127,-0.16171539,-0.0540727,0.072800966,0.19534309,0.32780047,0.44899619,0.57442135,0.65339793,0.72763401,0.85444277,0.96842101,1.1082717,1.2328808,1.3364937,1.4643106,1.4943742,1.465719,1.3978101,1.3070596,1.2254967,1.1415667,1.0460892,0.9788246,0.94824665,0.8647881,0.76835173,0.69820131,0.60182848,0.64580741,0.65717906,0.56258441,0.48598294,0.42434941,0.33413094,0.26359458,0.34847751,0.29971297,0.21164256,0.12477651,0.061696412,-0.0059919489,-0.042863984,0.032619197,0.13107242,0.23061731,0.2537662,0.18919026,0.1256342,0.091064785,0.080154768,-0.015191956,-0.10608614,-0.070404242,-0.13048159,-0.21131579,-0.30725537,-0.37224089,-0.45008402,-0.370235,-0.31949233,-0.37243179,-0.46033922,-0.53408204,-0.60337434,-0.61759164,-0.68467618,-0.73434554,-0.79503592,-0.83558511,-0.8752656,-0.77104772,-0.65862282,-0.54734968,-0.4403404,-0.33685544,-0.21983947,-0.17546539,-0.075190832,0.028262826,0.1446002,0.25715686,0.3248625,0.2668658,0.17359612,0.12404328,0.09958172,0.030069702,-0.0028198581,-0.065659696,-0.11598541,-0.14770781,-0.18115489,-0.2645811,-0.31301813,-0.41363122,-0.4964833,-0.55119813,-0.56091144,-0.65036,-0.74004822,-0.81054593,-0.88016815,-0.77050532,-0.69055269,-0.73912158,-0.81165409,-0.91022336,-0.99141765,-1.0842862,-1.1555926,-1.2757071,-1.3592057,-1.3889021,-1.470246,-1.5366245,-1.614268,-1.6958741,-1.7724158,-1.8318865,-1.8596609,-1.8646261,-1.8610022,-1.8925029,-1.9466354,-1.8880841,-1.7788538,-1.6607131,-1.5450775,-1.4353927,-1.311236,-1.2045132,-1.0808028,-0.95138688,-0.85090601,-0.71750915,-0.60979656,-0.49321595,-0.36536188,-0.23920265,-0.13579568,-0.0062803937,0.12351788,0.23460141,0.34834836,0.47591534,0.60406237,0.72672779,0.83801811,0.96696445,1.0827876,1.2089101,1.334758,1.4610929,1.5875124,1.7128682,1.8392321,1.9628015,2.0894429,2.215929,2.3428917,2.4709174,2.594986,2.7179003,2.7967042,2.8455441:3
1.7839997,1.6788846,1.5824298,1.6078854,1.5062782,1.4011666,1.294735,1.2023035,1.1036881,1.051552,1.1203504,1.2056072,1.2959216,1.397257,1.4940596,1.4242769,1.2890819,1.3050767,1.1922689,1.0514582,0.93182182,0.79759838,0.68624997,0.58172863,0.47922889,0.39248375,0.30368582,0.20935116,0.12050514,0.037552714,-0.057662995,-0.12912695,-0.18968687,-0.19966858,-0.17236306,-0.11134273,-0.04385193,0.034264832,0.12227831,0.2289201,0.33171066,0.39904875,0.4407928,0.52967452,0.6346096,0.7395561,0.82327273,0.74112029,0.62426046,0.51393399,0.49437522,0.37171269,0.26841263,0.13007534,0.019247826,-0.056856975,0.0052556995,-0.11880554,-0.22373726,-0.34548077,-0.45018415,-0.5886003,-0.70836558,-0.83024673,-0.94595384,-1.0389572,-1.1710985,-1.2981071,-1.4026171,-1.4995414,-1.5977645,-1.7179228,-1.8270859,-1.9385403,-2.0496522,-2.1561299,-2.2284659,-2.2615497,-2.2519609,-2.2270165,-2.1867186,-2.1339114,-2.0721095,-1.9599567,-1.8393973,-1.7164451,-1.6109896,-1.5232126,-1.4285638,-1.3260033,-1.2354212,-1.1290921,-1.0348195,-0.94201618,-0.84813104,-0.75373192,-0.66682223,-0.57979477,-0.53588813,-0.53848751,-0.49499399,-0.51456433,-0.47403876,-0.36694732,-0.27222674,-0.16798132,-0.078364124,0.020578212,0.081621557,0.17762945,0.29923368,0.41967717,0.48045142,0.37151167,0.2652835,0.17709748,0.17681852,0.08437814,-0.0029763398,-0.082435108,-0.1566385,-0.22649865,-0.293708,-0.34335234,-0.31184125,-0.1715791,-0.029458612,0.11185306,0.051949711,-0.054965567,-0.14901203,-0.22784311,-0.3052263,-0.36931075,-0.43332002,-0.50205386,-0.57494804,-0.63316733,-0.67106921,-0.70101237,-0.73624097,-0.78097778,-0.81602803,-0.85346685,-0.89042964,-0.92436128,-0.91279915,-0.88120519,-0.85635752,-0.83272663,-0.80477643,-0.7842375,-0.7579393,-0.73885802,-0.70867392,-0.61431969,-0.5046853,-0.40401633,-0.30777685,-0.21227702,-0.11154583,-0.0080548725,0.059496085,0.11904578,0.18039628,0.25063551,0.30887927,0.36234788,0.4386077,0.55367037,0.63975514,0.72625881,0.8317939,0.9460519,0.90156966,0.83558836,0.77925415,0.74828926,0.72405872,0.769168,0.74431813,0.7388696,0.73786321,0.74768668,0.76136934,0.77221675,0.77890585,0.79558282,0.80119991,0.82044566,0.84782053,0.88815441,0.96870601,1.0743536,1.1677128,1.2146299,1.2290099,1.2191057,1.2131468,1.2046987,1.1862903,1.1905284,1.1918023,1.191384,1.2040516,1.2174094,1.2507204,1.3136714,1.356769,1.3566985,1.3637066,1.3392567,1.3057101,1.2840523,1.316402,1.3888348,1.5031357,1.6423302,1.7648079,1.9046761,2.0249053,2.0720639,1.9912752,1.8552511,1.733619,1.6163922,1.5417091,1.4583858,1.4042988,1.3617093,1.3212139,1.2743391,1.2174278,1.1789445,1.1351833,1.0958175,1.0495179,1.0146139,0.97546826,0.95268469,0.93035012,0.90172281,0.86562504,0.83258869,0.80661421,0.78229934,0.76590884,0.75550179,0.75315471,0.75851336,0.7838663,0.79358835,0.80150792,0.82209093,0.78916497,0.71601478,0.63339001,0.53407317,0.45528926,0.3923628,0.33338155,0.26058625,0.18899822,0.12414765,0.051618064,-0.026513834,-0.1051008,-0.1969721,-0.31893889,-0.44100301,-0.539118,-0.62133131,-0.68739941,-0.75484854,-0.80416532,-0.84075517,-0.85261574,-0.86082259,-0.87472585,-0.88530988,-0.88610783,-0.88760967,-0.87097794,-0.84617209,-0.82225219,-0.79585381,-0.76644296,-0.73773882,-0.70255264,-0.6593475,-0.60352828,-0.54340556,-0.48192006,-0.41335367,-0.31542897,-0.19344622,-0.19788041,-0.30578194,-0.42571255,-0.52311147,-0.54892164,-0.51037167,-0.45958822,-0.39460915,-0.30809201,-0.21132617,-0.12506536,-0.053780275,-0.096102389,-0.024221126,0.061988513,0.13657386,0.22172077,0.29759229,0.23360149,0.13634351,0.022515116,-0.074473689,-0.19564435,-0.30993263,-0.44294682,-0.48100752,-0.46929677,-0.58218777,-0.696151,-0.78095686,-0.86646735,-0.96623949,-1.0795505,-1.2177984,-1.3285369,-1.4383816,-1.5710878,-1.7074282,-1.8406553,-1.9707983,-2.0806818,-2.1725239,-2.2509807,-2.2978015,-2.3011754,-2.2758996,-2.2212978,-2.1618446,-2.0970899,-2.0178659,-1.9426485,-1.8547313,-1.7761656,-1.6884512,-1.5984862,-1.503801,-1.4099109,-1.3128404,-1.2148781,-1.1166405,-1.0177952,-0.91811902,-0.81324086,-0.70994829,-0.61032538,-0.50773015,-0.40413666,-0.30207169,-0.19898965,-0.28466664,-0.24713398,-0.15083623,-0.045713702,0.057653564,0.15618962,0.2517812,0.35142933,0.43092109,0.33622333,0.23653448,0.13899878,0.03204406,-0.051241089,-0.058434272,-0.16172122,-0.27038589,-0.38361253,-0.47936093,-0.59097172,-0.68121513,-0.74312377,-0.78686978,-0.7891581,-0.76165699,-0.70206246,-0.6271998,-0.51408139,-0.39765538,-0.28235997,-0.17849622,-0.069220136,0.03781961,0.14253779,0.25100323,0.3718265,0.47675903,0.58100788,0.68808409,0.80044149,0.90345243,0.93310598,1.0501575,1.1571159,1.2754515,1.2594397,1.1446775,1.0497125,0.95609456,0.87550239,0.80996494,0.82251513,0.94695163,1.0675775,1.185976,1.3086264,1.4295456,1.4153111,1.4644735,1.5692392,1.6910681,1.7795332:4
1.2335051,1.1959266,1.115291,1.0559721,1.056006,1.0733077,1.0308278,0.96996393,0.93448713,0.90294538,0.86245968,0.79948162,0.77415398,0.85607744,0.9542705,1.0625694,1.1673699,1.2687383,1.3668595,1.3262118,1.2157828,1.14175,1.0723136,0.99704563,0.89728641,0.80010529,0.71297498,0.62120146,0.52798014,0.42517775,0.33640678,0.25643196,0.18724237,0.10028276,0.0023887674,-0.091385574,-0.16744226,-0.23483721,-0.31409425,-0.37653893,-0.4167827,-0.29296392,-0.2313992,-0.14514185,-0.085488053,-0.011284314,0.053864881,0.17953918,0.22455119,0.32087214,0.44126421,0.53919752,0.63535212,0.71033476,0.83577455,0.87945964,0.95332293,1.0825026,1.2219665,1.309295,1.4566521,1.5838613,1.6705725,1.7244439,1.6882836,1.5966499,1.4957655,1.3951584,1.3189496,1.2421589,1.1725643,1.1071285,1.0342369,0.95847802,0.9021542,0.84805509,0.77555877,0.69763358,0.62382669,0.53872283,0.45361958,0.38502728,0.35432847,0.37338654,0.34117763,0.27372174,0.20348899,0.10738732,0.021683727,-0.054530938,-0.18118134,-0.26086848,-0.33443025,-0.42206425,-0.50233706,-0.57221745,-0.56869174,-0.48852161,-0.41230031,-0.38155057,-0.41213201,-0.47239596,-0.55662992,-0.62962091,-0.72661016,-0.82860609,-0.9229136,-0.95799153,-1.0515026,-1.10411,-1.0407784,-1.0371487,-1.1361952,-1.2449726,-1.2353406,-1.3150071,-1.3382723,-1.2433901,-1.1374837,-1.0557804,-0.97626341,-0.87307378,-0.76283312,-0.65707119,-0.5570791,-0.46412168,-0.379729,-0.31416632,-0.27728562,-0.31718577,-0.4109296,-0.50175115,-0.46324002,-0.41739411,-0.32875214,-0.27278553,-0.17862674,-0.076199249,0.030189586,0.10046443,0.18286269,0.25471879,0.32771073,0.39416206,0.43676666,0.39821287,0.32789558,0.34371752,0.41568178,0.47291422,0.5377382,0.57373095,0.64330233,0.74332559,0.81516636,0.87687433,0.90551212,0.88746392,0.93812305,1.0046175,1.0529934,1.0919879,1.1386558,1.218867,1.2990926,1.3628568,1.4294672,1.4480769,1.343558,1.1943739,1.0447285,0.89497578,0.7456003,0.61219647,0.48259781,0.3774658,0.2424722,0.10900694,-0.0083436322,-0.14214831,-0.26026102,-0.37744046,-0.51137639,-0.63185156,-0.70595759,-0.67731475,-0.5680945,-0.49899776,-0.44329688,-0.36175863,-0.27183728,-0.19450839,-0.12636895,-0.070988127,0.0015533077,0.074116292,0.15464521,0.23858214,0.28469773,0.35543306,0.44414352,0.53403871,0.60545349,0.68326379,0.77359646,0.86298633,0.95945153,1.0465195,1.131549,1.1335518,1.0293119,0.91042876,0.79060609,0.67528371,0.5587825,0.4838329,0.47534065,0.50235631,0.5269591,0.561736,0.6200376,0.70264522,0.78464065,0.85060867,0.91774067,0.98403962,1.0125583,0.96412831,0.96737858,1.0231654,1.0769911,1.1381967,1.1629357,1.2097825,1.261976,1.3387498,1.4236515,1.5101032,1.5534099,1.4767238,1.3750438,1.2646459,1.1666294,1.0702669,0.97434115,0.86651067,0.76386954,0.66320057,0.57515679,0.47835779,0.38530888,0.28126268,0.17644464,0.07465569,-0.04442443,-0.14058601,-0.21511065,-0.27716564,-0.32808503,-0.43342281,-0.56295741,-0.70169933,-0.83537816,-0.88150158,-0.96264757,-0.99220197,-1.1016054,-1.2263683,-1.3450842,-1.457887,-1.5641847,-1.6803462,-1.7760349,-1.9041836,-2.0184643,-2.1313409,-2.2650441,-2.3731696,-2.4705663,-2.4970469,-2.5990184,-2.5449514,-2.5526893,-2.5098683,-2.4235705,-2.3303389,-2.1987627,-2.1108759,-2.0210736,-1.9259545,-1.8180852,-1.6873052,-1.5628742,-1.4450136,-1.363664,-1.2683227,-1.1663901,-1.0573831,-0.96984208,-0.88951192,-0.8148948,-0.71599189,-0.62345118,-0.53524213,-0.46485258,-0.37842135,-0.28483281,-0.18552629,-0.099637822,-0.0044420135,0.089548328,0.16648094,0.1319239,0.067737089,0.0078724392,-0.048745589,-0.098641942,-0.13541031,-0.1537107,-0.1326909,-0.05408576,0.036590518,0.12315953,0.22293828,0.30680421,0.40298531,0.4911217,0.57435245,0.57690193,0.60119225,0.68514238,0.77576475,0.87569354,0.9712801,1.0448705,1.1415929,1.2429369,1.2633573,1.181246,1.0676377,0.97174746,0.86933072,0.81057263,0.71200426,0.62222107,0.60082256,0.59591085,0.51853663,0.42507746,0.33614008,0.24742927,0.15999401,0.074344169,-0.024461605,-0.11459815,-0.17264186,-0.17088363,-0.15847589,-0.123097,-0.089030191,-0.043417415,0.028255741,0.079857244,0.035888639,-0.010616368,-0.11536288,-0.2078985,-0.2951471,-0.36980023,-0.44735107,-0.52656338,-0.60918965,-0.71814507,-0.82387036,-0.91695179,-0.95603269,-0.99408856,-1.0846824,-1.1773462,-1.2568712,-1.3719885,-1.4866351,-1.6011649,-1.6981573,-1.7380758,-1.7727026,-1.8437248,-1.9295854,-2.0310642,-2.1630356,-2.2365373,-2.2387476,-2.2865755,-2.3418024,-2.2954319,-2.1830932,-2.0560186,-1.9163051,-1.7734597,-1.6317057,-1.490852,-1.3685158,-1.2243005,-1.0879803,-0.95542097,-0.83011428,-0.69774107,-0.57743999,-0.44336957,-0.32455686,-0.20500513,-0.12823904,-0.063684001,0.015464705,0.11414,0.22235763,0.31673502,0.41483418,0.52296498,0.63189349,0.72856122,0.81132662,0.90678616,1.0026118,1.0663049,1.1266903,1.1898957:5
2.5500581,2.4737775,2.4007383,2.3298242,2.2539811,2.1813149,2.105655,2.0326715,1.957451,1.8849436,1.8098146,1.7375933,1.6638839,1.5781217,1.4912909,1.4145153,1.3413721,1.2707975,1.1930718,1.106028,1.0251514,0.9506872,0.87978557,0.78849057,0.70530233,0.63637943,0.53505199,0.44547719,0.40384487,0.32762743,0.2941088,0.28956134,0.29228602,0.28392273,0.30085745,0.30055854,0.31038427,0.31476259,0.32825378,0.31594182,0.30572699,0.29321896,0.28212955,0.26809918,0.24968744,0.23450066,0.22457703,0.21058487,0.18858725,0.17113709,0.16424408,0.14775861,0.14557004,0.12428223,0.12148391,0.11124283,0.10227584,0.085009601,0.069419691,0.059079057,0.056014081,0.048156201,0.041089157,-0.0015138748,-0.065789895,-0.11842391,-0.17597501,-0.21573724,-0.23800148,-0.23879785,-0.21657518,-0.18457327,-0.24150733,-0.30379698,-0.39016163,-0.48514544,-0.56107779,-0.63319475,-0.70716908,-0.76740674,-0.83050767,-0.89693268,-0.96265068,-1.0133618,-1.0524841,-1.0965179,-1.1385892,-1.1646774,-1.1916826,-1.2118816,-1.217186,-1.2194355,-1.2158839,-1.2171159,-1.2195336,-1.208785,-1.198963,-1.1864239,-1.168614,-1.1466181,-1.1209976,-1.0893694,-1.0507085,-1.0082011,-0.96891297,-0.93313676,-0.89574747,-0.84306582,-0.82224669,-0.77325846,-0.75263459,-0.70340213,-0.7483268,-0.8136223,-0.80981344,-0.78405381,-0.72849165,-0.69096068,-0.62905526,-0.55860862,-0.48119052,-0.40335676,-0.33590822,-0.29389458,-0.36554358,-0.44399795,-0.52007838,-0.58009752,-0.65972362,-0.72936618,-0.7953069,-0.87102996,-0.94682294,-1.0034486,-1.0724829,-1.1434331,-1.2109065,-1.2801408,-1.3511509,-1.3961049,-1.4255787,-1.4513339,-1.4501869,-1.4444293,-1.4307333,-1.4088503,-1.3735355,-1.3418841,-1.3027163,-1.2746894,-1.2387341,-1.1895611,-1.1435205,-1.0853514,-1.0226916,-0.96061032,-0.89795073,-0.83132875,-0.76008647,-0.67860691,-0.60692462,-0.54161353,-0.47635615,-0.41073168,-0.34489931,-0.27838985,-0.21171534,-0.1476604,-0.079200225,-0.012901902,0.040262521,0.10639701,0.17658254,0.24181477,0.30755196,0.36807738,0.3645067,0.41034128,0.47447209,0.53733219,0.62324017,0.6917721,0.79412006,0.89393061,0.99312114,1.0327879,0.97233834,0.90050272,0.82194268,0.76136223,0.67949006,0.60836025,0.54814678,0.49137951,0.44511805,0.41276452,0.39746246,0.40270159,0.43606862,0.48302425,0.54461755,0.60379114,0.66259228,0.72916985,0.79849958,0.87027862,0.92617244,1.0029449,1.0780583,1.1516151,1.2259481,1.3006917,1.3765243,1.4553917,1.4692501,1.5203567,1.5956446,1.6721432,1.7411789,1.8400126,1.9062618,2.0054788,1.9916035,1.9380597,1.848963,1.7847144,1.6904733,1.5992087,1.5133524,1.4592334,1.4162208,1.3720211,1.3081904,1.2121762,1.147381,1.0474927,0.98286508,0.88840729,0.81415686,0.72297464,0.65911182,0.5653822,0.47616134,0.44942153,0.40742347,0.40500693,0.44920724,0.52344482,0.59199593,0.66014241,0.73207752,0.79984548,0.83081596,0.77324318,0.70100385,0.63388327,0.54694908,0.4804595,0.4118494,0.33177462,0.25923845,0.1799301,0.10975605,0.036393834,-0.02828105,-0.10150697,-0.16953073,-0.24193066,-0.31771914,-0.39167794,-0.46474752,-0.5320709,-0.59688068,-0.66397687,-0.7370209,-0.81568692,-0.86655898,-0.94404338,-0.99267831,-1.0041827,-0.98800826,-0.98519511,-0.97694239,-0.96098848,-0.9341224,-0.91012768,-0.87693265,-0.83022853,-0.77153537,-0.68338819,-0.62100497,-0.52754854,-0.44718408,-0.38477318,-0.29029849,-0.22441638,-0.16096048,-0.12210949,-0.17935313,-0.23311578,-0.28471936,-0.34890814,-0.40842238,-0.45434392,-0.49293819,-0.47596375,-0.52834958,-0.57898095,-0.64329328,-0.70588202,-0.75171116,-0.79839091,-0.85356113,-0.90435064,-0.95329184,-1.0092738,-1.0531191,-1.1022314,-1.1377241,-1.1901705,-1.2306212,-1.2654246,-1.305352,-1.3421551,-1.3663516,-1.4012741,-1.4282123,-1.4567212,-1.4718081,-1.4934875,-1.5095973,-1.5207796,-1.5241284,-1.5256633,-1.5100415,-1.4897914,-1.4634332,-1.4343247,-1.3789736,-1.3083648,-1.2400079,-1.1667656,-1.0915495,-1.0221174,-0.94755555,-0.88339561,-0.86212904,-0.86416357,-0.8605094,-0.85100972,-0.82033575,-0.78351925,-0.74351544,-0.68892701,-0.67717242,-0.66876711,-0.66304934,-0.65589091,-0.64415012,-0.63187466,-0.61710834,-0.60768432,-0.59535074,-0.58541541,-0.56676258,-0.54335853,-0.51197791,-0.48459014,-0.46294174,-0.42385257,-0.39725803,-0.36981725,-0.34494894,-0.31206762,-0.28827282,-0.25609247,-0.22498692,-0.20843076,-0.18395285,-0.15849261,-0.12613316,-0.10465937,-0.077795891,-0.055083405,-0.023575517,-0.003111328,0.0083725157,0.015098666,0.058018577,0.071000775,0.092484146,0.12528683,0.16584677,0.22363773,0.28488336,0.35438369,0.36232049,0.34778751,0.44708218,0.5078089,0.59641938,0.66966033,0.74187214,0.81222414,0.89408557,0.97734438,1.0630256,1.1366045,1.2057486,1.2770127,1.3686495,1.4439332,1.5283017,1.6011677,1.6729507,1.7456695,1.8246599,1.9039041,1.9786671,2.0678727,2.14355,2.2159578,2.2902883,2.3604562,2.4325523,2.5002317,2.5414057:4
1.7163641,1.6664601,1.5280292,1.3959907,1.2610754,1.148502,0.99556664,1.0490402,0.96906437,0.83823345,0.70538332,0.57149691,0.39793956,0.26270211,0.10149407,0.01292593,-0.016136726,0.082034009,0.12431345,0.032032646,-0.071013448,-0.21782564,-0.34548527,-0.4731295,-0.54241928,-0.68637336,-0.78988651,-0.94222832,-1.0597175,-1.175272,-1.1177116,-1.0811157,-0.9821254,-0.86253124,-0.74612877,-0.64288005,-0.66098169,-0.76546411,-0.90707615,-0.96057757,-1.0952381,-1.178863,-1.203677,-1.3527589,-1.466219,-1.553457,-1.6322656,-1.6800544,-1.6886574,-1.8030248,-1.9014476,-1.965108,-2.0667055,-2.1733352,-2.2170599,-2.3008333,-2.3913259,-2.4492933,-2.4216931,-2.2894096,-2.1424591,-2.1673579,-2.0425773,-1.9236772,-1.7828321,-1.6650787,-1.5890835,-1.4751626,-1.3510234,-1.2369207,-1.0995546,-0.98962095,-0.8779086,-0.74900867,-0.62316796,-0.49308618,-0.34619353,-0.28075743,-0.17422977,-0.17493855,-0.087121643,0.045060085,0.17723481,0.24824847,0.32844848,0.43732143,0.55696935,0.66683046,0.78453156,0.93222783,1.0682686,1.0551667,1.033601,0.95689084,0.89999644,0.829248,0.74738372,0.68619217,0.59904268,0.51414566,0.450905,0.38587293,0.36774709,0.30459474,0.20406323,0.18079388,0.12097552,0.087853673,0.0047441986,-0.062215834,-0.045703827,-0.10909567,-0.11085679,-0.03813705,-0.012486692,0.031504036,-0.016284327,-0.050203668,-0.020276441,-0.079218648,-0.13927228,-0.2019121,-0.26166461,-0.30182351,-0.37577067,-0.39060444,-0.40492131,-0.43235159,-0.36245345,-0.29800572,-0.29826338,-0.32117223,-0.33009117,-0.35079299,-0.35812861,-0.38242229,-0.35534802,-0.2843372,-0.30032372,-0.22255367,-0.08347146,0.034422347,0.17001068,0.31274778,0.43243103,0.5588682,0.67696064,0.71267586,0.70620923,0.71415499,0.77567708,0.83521003,0.86025636,0.87306139,0.84114714,0.87416064,0.89464097,0.96528603,1.0350171,1.0347008,1.0555227,1.0261901,1.007206,0.96259298,0.9683084,0.98686423,0.98346919,0.93912316,0.90754396,0.85153329,0.86079466,0.80502483,0.76531819,0.86924796,0.90951339,0.89305599,0.86579804,0.90679563,0.8419359,0.78242621,0.82370776,0.75616599,0.67540103,0.58412228,0.50555755,0.41413125,0.33973307,0.2623076,0.20950524,0.18540537,0.14303727,0.086711323,0.10053927,0.22503023,0.36329002,0.54259799,0.72188236,0.85957103,1.0386099,1.1770964,1.3149169,1.4952425,1.6752518,1.7665108,1.7734444,1.7025846,1.5534379,1.3728223,1.1921113,1.0525695,0.9375794,0.77382441,0.59317312,0.45380341,0.27319727,0.16512104,0.14333012,0.15860928,0.17670438,0.22904912,0.23762518,0.29512263,0.35871912,0.43115953,0.46835059,0.50871647,0.58828619,0.64914284,0.70850824,0.78258416,0.8302448,0.90811144,0.96596732,0.98409587,0.97277957,0.88785138,0.77012465,0.63800111,0.61917096,0.63667542,0.68514099,0.71975899,0.761412,0.80976208,0.87236249,0.758811,0.79716672,0.8210545,0.83278104,0.84095061,0.83958019,0.70630977,0.63920299,0.65258471,0.65068767,0.65153667,0.65229864,0.6236016,0.49313757,0.46851092,0.45009279,0.4057588,0.43909725,0.35994726,0.22525084,0.10557865,-0.03148489,-0.15305605,-0.29011028,-0.4118751,-0.53675262,-0.54536378,-0.5557188,-0.5516497,-0.53519042,-0.53395424,-0.50890983,-0.49313639,-0.47502779,-0.46006225,-0.42867673,-0.3983894,-0.35622254,-0.3731157,-0.48269812,-0.55861202,-0.53042215,-0.47686424,-0.4339656,-0.37595576,-0.37499793,-0.39655991,-0.34732045,-0.38458471,-0.37686608,-0.32304534,-0.25785474,-0.19258541,-0.1463326,-0.20124836,-0.36071025,-0.39048869,-0.3140841,-0.25105148,-0.17360984,-0.099711175,-0.030925878,0.052528417,0.14046516,0.22850924,0.30364591,0.32138922,0.26226306,0.34834974,0.45068692,0.47529057,0.58764237,0.68974694,0.78788413,0.85794936,0.96751448,1.0733919,1.1920074,1.3054838,1.4255636,1.5197807,1.5816817,1.4824705,1.3385989,1.1950372,1.0518545,0.91768767,0.78769509,0.65995416,0.52579123,0.39713904,0.26347376,0.17292865,0.11637755,0.068009685,-0.029876145,-0.13884081,-0.18079895,-0.29503354,-0.45786862,-0.57713843,-0.67552194,-0.69315142,-0.72921606,-0.75985677,-0.91538238,-1.0109741,-1.0997232,-1.2367089,-1.3122819,-1.4489202,-1.54545,-1.6960568,-1.8242637,-1.9530542,-2.0855833,-2.1480304,-2.2327299,-2.3214681,-2.4321618,-2.5064221,-2.505692,-2.4638766,-2.4138445,-2.3514002,-2.283038,-2.1705556,-2.0369931,-1.8919826,-1.8145245,-1.8099165,-1.8006759,-1.6614027,-1.5140147,-1.3950727,-1.2554167,-1.1019432,-1.0426236,-0.99380631,-0.88316404,-0.80716269,-0.71712256,-0.64762363,-0.59927768,-0.55450738,-0.61046139,-0.70132923,-0.75284377,-0.84261705,-0.73300671,-0.62100283,-0.5181882,-0.38794857,-0.25691317,-0.15299037,-0.031083275,0.08863225,0.1568849,0.19327453,0.28486162,0.46514293,0.63430565,0.74312148,0.87652633,0.97266756,1.1528836,1.2617476,1.3818617,1.265948,1.1717978,1.0998408,1.1130771,1.200423,1.3145778,1.4938503,1.6737581,1.7584626,1.7465824,1.7365223,1.7170788,1.7320891,1.7317317:3
1.7313868,1.6343528,1.7014845,1.5772134,1.4823538,1.3409727,1.4147433,1.294134,1.1857126,1.0537073,0.93019979,0.80112744,0.66893456,0.54314329,0.39776232,0.27225617,0.13335509,0.0036447579,-0.12659031,-0.2649338,-0.39329274,-0.53386284,-0.66789845,-0.79967897,-0.93841296,-1.0761546,-1.2030014,-1.3465603,-1.4833179,-1.6148631,-1.7545815,-1.7058986,-1.5884754,-1.4662662,-1.4468489,-1.3228882,-1.2083326,-1.1886401,-1.0931564,-0.97433811,-0.946412,-0.88133329,-0.75797677,-0.73301465,-0.62093829,-0.54767215,-0.47342838,-0.38392334,-0.32926914,-0.3414679,-0.2598467,-0.21859167,-0.10016952,-0.11025088,-0.06433827,0.037662017,0.0045746458,0.078188001,0.12526342,0.033004334,-0.061357693,-0.12783764,-0.096516931,-0.017502038,0.018863098,0.11866874,0.15668184,0.21787236,0.27295825,0.20389245,0.15767372,0.21975137,0.26799006,0.36273237,0.41072859,0.43289961,0.40701873,0.49522713,0.5597156,0.62858556,0.67869283,0.64688078,0.72204997,0.79993597,0.85319316,0.9050189,1.0035812,1.0610876,1.1550195,1.2428869,1.3390947,1.4391829,1.342525,1.2182261,1.0975802,0.99482112,0.88333591,0.82378639,0.69830199,0.57764995,0.52453717,0.40294343,0.28760182,0.18188269,0.096655585,0.055199729,-0.06895116,-0.17288303,-0.26105388,-0.33895261,-0.43345485,-0.54689883,-0.61353895,-0.72391973,-0.84624118,-0.94315472,-1.0592486,-1.1674953,-1.2724435,-1.3494341,-1.4454953,-1.5524588,-1.5614668,-1.4488742,-1.3460047,-1.2761889,-1.1877173,-1.0768762,-0.94976474,-0.86712904,-0.77690161,-0.67624698,-0.66611904,-0.5895717,-0.45073933,-0.338839,-0.27797622,-0.14034082,-0.064553855,0.06558287,0.17107947,0.29425061,0.27526871,0.15426199,0.026035503,-0.051746779,-0.18276452,-0.20423946,-0.31383883,-0.43101484,-0.55058612,-0.5360834,-0.52168678,-0.386852,-0.32301113,-0.1790367,-0.11957917,-0.09437161,0.0061640839,0.15979949,0.26057913,0.41813415,0.56258601,0.63019499,0.75177781,0.8546417,0.83755709,0.85585644,0.98765578,1.0891441,1.1954815,1.301624,1.3099389,1.3647601,1.468805,1.5841472,1.6079914,1.7378367,1.8743508,1.9537693,2.1286528,2.2505688,2.4010948,2.5218167,2.6417417,2.5777417,2.4241322,2.3122935,2.1601185,2.1264642,1.9869304,1.8369955,1.8403927,1.7172967,1.6113402,1.5210504,1.5509745,1.4618728,1.3998933,1.2831564,1.2122696,1.2596515,1.2752569,1.1569034,1.0937348,0.9420831,0.88871985,0.79623538,0.66264918,0.72147965,0.7181658,0.70796549,0.61650867,0.53927562,0.46869525,0.33994881,0.31417109,0.18875938,0.053833672,0.12599173,0.14675403,0.14561936,0.046568884,-0.025825404,-0.13235758,-0.14453249,-0.26959316,-0.39648836,-0.46189094,-0.56096819,-0.54907374,-0.67027438,-0.79192343,-0.89146819,-1.0166753,-1.1075501,-1.1181924,-1.2128469,-1.3314661,-1.4247721,-1.5261903,-1.5849148,-1.7105244,-1.8300799,-1.8590331,-1.9542891,-2.0680846,-2.176725,-2.145913,-2.0539578,-1.9633555,-1.8334222,-1.7799841,-1.7028826,-1.5626808,-1.4322895,-1.3873727,-1.2433306,-1.1952582,-1.124132,-0.96047205,-0.91619766,-0.89756106,-0.73776931,-0.68436944,-0.53072418,-0.43070981,-0.38058879,-0.27933742,-0.13566038,-0.065964738,-0.042701724,0.13097904,0.21889275,0.37114251,0.33966084,0.25067358,0.12697148,0.13251198,0.018496559,-0.11722759,-0.17859284,-0.14704848,-0.28113633,-0.39379473,-0.44119646,-0.43070849,-0.52935638,-0.62759051,-0.65854161,-0.82025539,-0.8868241,-0.85441167,-0.94905395,-1.0776634,-1.1362528,-1.2916026,-1.2988173,-1.4300515,-1.5280375,-1.6223818,-1.5643009,-1.6559547,-1.7540668,-1.6202594,-1.5537616,-1.4064401,-1.3055113,-1.2056215,-1.1034662,-0.97122021,-0.87614197,-0.80526542,-0.6756748,-0.55253388,-0.47810748,-0.33298275,-0.21246377,-0.071519592,-0.0014826384,0.08640038,0.19798114,0.29254824,0.39732206,0.52777946,0.59984726,0.69852814,0.84036709,0.9429456,1.0511146,1.1821927,1.2829708,1.4238085,1.5533599,1.5691196,1.4498738,1.3406801,1.2785184,1.1408888,1.054491,1.0642648,0.95661994,0.8807967,0.9043522,0.87255866,0.77968868,0.75786869,0.63411171,0.64811572,0.70450115,0.64152796,0.64602394,0.54452044,0.53275725,0.41677957,0.41920027,0.48889458,0.57872094,0.51022897,0.43880448,0.40088935,0.30601631,0.33406143,0.24619929,0.14006639,0.10166014,0.24367804,0.31481699,0.37003323,0.30940987,0.30832889,0.2775142,0.18359379,0.21882241,0.13996351,0.042660637,-0.02620745,-0.02383963,-0.096463777,-0.16400968,-0.2397106,-0.27586697,-0.23446101,-0.23405514,-0.29773936,-0.31130263,-0.40206743,-0.47555816,-0.50079385,-0.59668935,-0.65394258,-0.70266125,-0.77817468,-0.91500842,-0.95243607,-1.0982933,-1.1316081,-1.2211063,-1.3472354,-1.4614107,-1.546226,-1.4278348,-1.2895789,-1.1485157,-1.0190331,-0.88262477,-0.74100352,-0.61904985,-0.55951999,-0.43493224,-0.29154952,-0.16405152,-0.029148773,0.10424983,0.24453145,0.37642981,0.50323392,0.63528641,0.77392717,0.91420611,0.97599801,1.1085386,1.2404032,1.3413561,1.4282786,1.5501568,1.6611282:6
1.0480547,0.92419309,0.83313896,0.71860789,0.58749597,0.4624186,0.3468949,0.23451063,0.1282063,0.049830869,0.039394815,0.11809122,0.20775332,0.13467796,0.019465034,-0.13234174,-0.26099993,-0.39646155,-0.51944918,-0.66433525,-0.78377064,-0.8941025,-1.0166742,-1.164346,-1.2922394,-1.4289287,-1.5596314,-1.7071719,-1.8535766,-1.9682259,-2.0753707,-2.1650902,-2.2311193,-2.2909489,-2.3289792,-2.3434271,-2.3068322,-2.224465,-2.121117,-2.0123514,-1.8983112,-1.7936687,-1.6793081,-1.5739341,-1.4674365,-1.3565605,-1.2503618,-1.1483053,-1.0433245,-0.928377,-0.82497004,-0.71509476,-0.6110309,-0.49889295,-0.38941523,-0.34885868,-0.32980281,-0.22148823,-0.11747488,-0.0088115474,0.10168464,0.21107899,0.31136291,0.42877092,0.53836884,0.50377109,0.39597242,0.29389417,0.18915322,0.076493372,-0.029328788,-0.12214795,-0.19666826,-0.19689614,-0.10789799,-0.0065498623,0.10162991,0.036284104,-0.058687507,-0.15025834,-0.229154,-0.31425725,-0.39998413,-0.4746146,-0.55055274,-0.62023634,-0.68834658,-0.74929176,-0.80595203,-0.846906,-0.86942037,-0.86861293,-0.86971131,-0.87046521,-0.86424598,-0.86293992,-0.87274024,-0.79110861,-0.70050392,-0.59339673,-0.48218405,-0.34528498,-0.23527772,-0.14141215,-0.04935467,0.035735831,0.11767802,0.19586697,0.27975056,0.36158771,0.42799142,0.49397108,0.5551724,0.59810371,0.56712818,0.53510974,0.50972782,0.50793387,0.57882475,0.65707336,0.63257854,0.59343602,0.54510378,0.53187758,0.53891376,0.56750177,0.59576393,0.61466577,0.63363706,0.65865206,0.67393262,0.68379489,0.71832041,0.8014311,0.8733752,0.925075,0.96833913,1.0016748,1.0540442,1.090492,1.1218435,1.1384006,1.1472562,1.1426768,1.1467933,1.1932296,1.289254,1.3981083,1.5064954,1.607471,1.7235862,1.8292242,1.9383682,2.0436529,2.1528669,2.2591653,2.2027846,2.0969123,1.9851921,1.8748778,1.7634242,1.6675232,1.5563522,1.4496308,1.3495167,1.4342872,1.4107989,1.3242206,1.2961634,1.2677542,1.2353736,1.2120092,1.1718373,1.1246178,1.0660747,1.0191789,0.96839748,0.91631225,0.85049773,0.80611831,0.7463502,0.71597384,0.70073963,0.68810113,0.66218049,0.64286638,0.62355982,0.6155554,0.61612589,0.61634166,0.64012811,0.67013462,0.61818191,0.51458595,0.40636486,0.37756333,0.38051961,0.38969063,0.40716722,0.42545964,0.41797238,0.41124915,0.40138578,0.35016717,0.31156363,0.26198205,0.20061641,0.13331945,0.077507446,0.035392427,-0.023925613,-0.093210848,-0.16468975,-0.25259145,-0.33277203,-0.45340555,-0.57810358,-0.72473938,-0.79505284,-0.84399785,-0.88258716,-0.88719052,-0.88387354,-0.86627363,-0.83221115,-0.82235281,-0.78754921,-0.74842838,-0.69139834,-0.64033484,-0.58641272,-0.52948807,-0.46833582,-0.40515685,-0.32499579,-0.23965798,-0.16033079,-0.077278259,0.0084682965,0.095067352,0.19329159,0.18643422,0.079587627,-0.025966802,-0.08193571,-0.033765086,0.033159258,0.099893305,0.20625175,0.31210572,0.36627289,0.4716972,0.50324439,0.39910785,0.29055226,0.17809441,0.067640675,-0.034570342,-0.14470146,-0.25078188,-0.36092995,-0.38825794,-0.35616343,-0.39879292,-0.50984493,-0.6169892,-0.72642137,-0.83890686,-0.94550477,-1.0461184,-1.1522487,-1.2609756,-1.3610957,-1.4315675,-1.4036667,-1.3933509,-1.4777257,-1.5154061,-1.6010562,-1.6986287,-1.8088084,-1.9176581,-2.0250117,-2.1439598,-2.2320366,-2.2901777,-2.3000156,-2.2584608,-2.2175724,-2.1725729,-2.1035071,-2.029285,-1.9532846,-1.8603664,-1.7681901,-1.6743324,-1.5629988,-1.4614777,-1.3641472,-1.2618941,-1.1571059,-1.0346269,-0.89140848,-0.77030915,-0.62410032,-0.49003942,-0.35881358,-0.26658409,-0.30147881,-0.36379987,-0.42864176,-0.42588957,-0.33891933,-0.23067208,-0.12215935,0.0090829077,0.11851937,0.24964636,0.40267045,0.49328734,0.48715856,0.35870484,0.25345926,0.18409398,0.21196778,0.11055019,0.0059221999,-0.11179133,-0.21407808,-0.32810828,-0.43468632,-0.52904143,-0.60011611,-0.66756835,-0.74140538,-0.80950572,-0.87349807,-0.9441688,-1.0026795,-1.0130423,-0.99098242,-0.93004463,-0.84815497,-0.74592225,-0.63939387,-0.53409181,-0.42389645,-0.31364562,-0.20653663,-0.096326562,0.011696516,0.12077755,0.22196523,0.32992845,0.44088676,0.55472683,0.67154791,0.77365104,0.89506856,0.94809053,1.0615389,1.1733371,1.0832208,1.0003939,0.93852416,0.93200282,0.94991398,1.0293813,1.1445526,1.2441521,1.3512378,1.4611436,1.5656051,1.673083,1.718276,1.8001087,1.8995196,1.8629942,1.7554476,1.657147,1.5405011,1.443118,1.342307,1.2618831,1.2575839,1.2943344,1.4169484,1.5187253,1.4250196,1.3103116,1.2089672,1.1097731,1.0820335,1.1523986,1.0527017,0.9476318,0.83910367,0.73829117,0.63654739,0.54053345,0.44605068,0.3462017,0.24068855,0.1377118,0.035520029,-0.063195417,-0.15319334,-0.22988725,-0.2961006,-0.32277012,-0.31028465,-0.28150448,-0.2185183,-0.14521326,-0.062560005,0.016564312,0.11304472,0.22177316,0.33785394,0.46334856,0.41321908,0.3709889,0.45006539,0.57679547,0.68693458,0.8347076,0.98721653:4
2.3320913,2.2119628,2.1002147,1.9937456,1.8738098,1.7566154,1.6564407,1.5586198,1.4396013,1.34228,1.2454697,1.1493596,1.075039,1.0194638,0.98611037,0.95637374,0.93967571,0.90895007,0.88623685,0.85373766,0.8198,0.79394863,0.7528152,0.71448343,0.67966588,0.65308787,0.60845315,0.57107983,0.54020746,0.50904724,0.49140075,0.46675814,0.4451108,0.43204709,0.42124212,0.40750573,0.39271244,0.38288019,0.38457837,0.40292289,0.41265258,0.43562001,0.38545157,0.3226783,0.31111669,0.3349804,0.34960229,0.29441242,0.23814711,0.15312175,0.070218014,-0.0037984469,-0.091486026,-0.16930047,-0.24895773,-0.33518537,-0.42101915,-0.5106682,-0.60173618,-0.65792144,-0.69276695,-0.70958257,-0.71445315,-0.71296049,-0.70685464,-0.69553596,-0.68022872,-0.66317194,-0.63598747,-0.61372649,-0.59167381,-0.56965445,-0.53834876,-0.51453514,-0.49093796,-0.46341718,-0.4245089,-0.36774649,-0.31740085,-0.25622612,-0.19425393,-0.13385791,-0.085423015,-0.10813328,-0.064143051,-0.0040541093,0.075653465,0.1456637,0.22718422,0.31620192,0.38401386,0.28666776,0.18699,0.088056527,-0.010788412,-0.10958066,-0.20815528,-0.30665408,-0.35158643,-0.43735108,-0.53658301,-0.63558442,-0.72544509,-0.8108932,-0.89733993,-0.98423888,-1.0809091,-1.1754768,-1.2529783,-1.3299301,-1.3885482,-1.4540953,-1.5344024,-1.6324246,-1.711166,-1.7652626,-1.8125404,-1.8527533,-1.8767537,-1.8804146,-1.8696967,-1.8684093,-1.9394233,-1.9196169,-1.8379666,-1.7666464,-1.6958752,-1.6107865,-1.538119,-1.453183,-1.3743447,-1.2846755,-1.1971317,-1.1089415,-1.0217926,-0.94440654,-0.85284349,-0.75667786,-0.67553962,-0.58854844,-0.49711569,-0.3995411,-0.31649369,-0.22881161,-0.13594248,-0.10330057,-0.02532284,0.072377675,0.15899173,0.24697034,0.32835726,0.36885498,0.28971842,0.21789811,0.13078636,0.052747332,-0.026346675,-0.10174941,-0.17567211,-0.24540612,-0.30975338,-0.38041573,-0.45052872,-0.51729441,-0.56938873,-0.62364549,-0.65988209,-0.6461984,-0.57481706,-0.49950755,-0.41621257,-0.33560469,-0.24467927,-0.16885878,-0.077187455,0.022822664,0.12011196,0.23974397,0.36000586,0.48025058,0.60007685,0.72056037,0.84101707,0.94028544,1.0400693,1.1403794,1.2265176,1.3367878,1.4106585,1.3616776,1.2524347,1.1570932,1.0942295,1.0396865,0.98028034,0.93565462,0.90207738,0.9275872,1.0047985,1.0840147,1.1647032,1.2502486,1.3250472,1.405457,1.486677,1.570345,1.650144,1.7361453,1.8328033,1.9240818,1.8798838,1.9411339,2.0182355,2.1052004,2.0418476,1.9650924,1.8734186,1.7709602,1.6707186,1.5700929,1.4704743,1.3505722,1.3148333,1.3571243,1.4179091,1.3495034,1.2563378,1.1661579,1.0514016,0.94877617,0.87296866,0.75484911,0.63649629,0.52049406,0.40522892,0.3083545,0.2324314,0.16652301,0.13077468,0.12492272,0.14200514,0.16676485,0.22564363,0.29353276,0.35853253,0.42602069,0.50506275,0.57625306,0.64569893,0.71890735,0.79669197,0.74846829,0.66608557,0.57801266,0.49876227,0.41021693,0.32988415,0.23689996,0.15607664,0.06784048,-0.019635179,-0.11063799,-0.19835981,-0.28520796,-0.36972446,-0.45417635,-0.54728199,-0.6409173,-0.72514815,-0.81314757,-0.9021013,-0.98466368,-1.0793106,-1.1679634,-1.2560064,-1.3501695,-1.4330954,-1.518512,-1.6165509,-1.6972978,-1.7892727,-1.8709499,-1.9569007,-2.036101,-2.0860402,-2.1141073,-2.1039439,-2.0548975,-1.9916798,-1.8768789,-1.7577327,-1.6579541,-1.55911,-1.4721051,-1.3735432,-1.2692364,-1.1828455,-1.0872994,-0.98420198,-0.88886776,-0.79910326,-0.71118531,-0.6267893,-0.60513943,-0.54237633,-0.44281478,-0.32213834,-0.22207281,-0.12272517,-0.003695989,0.062732168,-0.017928258,-0.10062358,-0.18410487,-0.2677435,-0.34731042,-0.43093836,-0.49434738,-0.55894853,-0.60785937,-0.6147823,-0.56568362,-0.50483983,-0.55577632,-0.6294217,-0.68872614,-0.75162512,-0.81277534,-0.87017258,-0.92456804,-0.97264706,-1.0180944,-1.0564138,-1.0997033,-1.1360018,-1.1691956,-1.2061867,-1.2312075,-1.2508674,-1.2698834,-1.2776809,-1.2876658,-1.2914139,-1.2945705,-1.2726754,-1.2449743,-1.2164848,-1.1698422,-1.1045455,-1.056996,-0.98117719,-0.87493126,-0.7760545,-0.69680836,-0.62660556,-0.56380999,-0.49324304,-0.42204573,-0.34951737,-0.27248549,-0.19721678,-0.12573025,-0.044344763,0.033140933,0.090852065,0.13953908,0.19337593,0.26246776,0.27986404,0.25579624,0.22440962,0.18773378,0.164786,0.15320552,0.16704419,0.15999715,0.15828532,0.16533885,0.17346827,0.17877833,0.18165202,0.18987629,0.1949959,0.21156668,0.23141019,0.25260671,0.28177279,0.31331351,0.3395676,0.37560787,0.40063405,0.43845252,0.4711274,0.50567003,0.54265682,0.58304941,0.61815432,0.65946054,0.70326641,0.74382923,0.77674012,0.80690718,0.84546533,0.88221865,0.93338409,0.99765422,0.9822364,0.88417781,0.78701129,0.66777988,0.72582183,0.83127915,0.9227839,1.0205707,1.0971089,1.1997497,1.2925515,1.3906155,1.4884149,1.6080076,1.7059742,1.8119196,1.9240445,2.0440497,2.1503071,2.2255131,2.329622:4
1.2262656,1.128196,1.0037478,0.85584925,0.72371083,0.61100037,0.624012,0.49386378,0.41654051,0.33104415,0.23560534,0.1247645,0.043512547,0.17665261,0.27453092,0.12527584,0.015475009,-0.096983494,-0.15012575,-0.26869348,-0.35992182,-0.45754906,-0.55594208,-0.66091376,-0.78395369,-0.88483524,-1.0306444,-1.0775965,-0.90785673,-0.72803387,-0.56472706,-0.42982576,-0.26831434,-0.053751822,0.082670271,0.067613744,0.077308155,0.037184984,-0.01986299,-0.079135102,-0.17314569,-0.27252391,-0.267114,-0.13506278,-0.16886054,-0.32223222,-0.41362933,-0.48236878,-0.45264803,-0.41156532,-0.51215334,-0.66155988,-0.7864608,-0.80462573,-0.81517644,-0.87322321,-0.96904524,-1.074032,-1.1726319,-1.2767927,-1.3859644,-1.4863997,-1.6312035,-1.5493945,-1.3886895,-1.2344636,-1.0805473,-0.98164326,-0.81231694,-0.72725089,-0.77445294,-0.78337501,-0.83766392,-0.89253191,-0.95719397,-1.1081949,-1.0178427,-0.99289366,-1.0558593,-1.1978532,-1.3046008,-1.3292375,-1.4307649,-1.5212102,-1.6340057,-1.7353318,-1.8604659,-1.8614752,-1.9438739,-1.8930519,-1.8668013,-1.7175053,-1.5603777,-1.3436667,-1.3698843,-1.3364166,-1.1222516,-0.96793036,-1.073222,-0.91026751,-0.7404719,-0.52022254,-0.30266844,-0.085463671,0.1325083,0.25123565,0.43379885,0.61508784,0.79590039,0.94087789,0.98597768,1.1303835,1.2349832,1.3434711,1.5408999,1.7354071,1.9513565,2.1303803,2.2601042,2.40704,2.5570611,2.6075129,2.6103535,2.5522495,2.4483376,2.3290278,2.1800633,2.0852993,1.9186429,1.9734548,1.8178605,1.6506918,1.4731088,1.2667905,1.0830929,0.88225528,0.71996813,0.50218536,0.3356394,0.11669652,-0.10213597,-0.26854485,-0.48672292,-0.68947371,-0.87204668,-1.0387864,-1.257678,-1.476686,-1.4785132,-1.6394723,-1.8596979,-2.025447,-2.1926056,-2.3579973,-2.5768712,-2.4830321,-2.3761143,-2.3077757,-2.2110627,-2.0880503,-1.9634774,-1.8513343,-1.7527867,-1.6411685,-1.5447801,-1.4289391,-1.3374435,-1.2457493,-1.1497637,-1.0640634,-0.97644918,-0.90258864,-0.81377057,-0.71110303,-0.70523182,-0.70955954,-0.70263548,-0.66129947,-0.6235952,-0.57297534,-0.55878279,-0.5834243,-0.73390556,-0.83657063,-0.97797858,-0.98549271,-0.89805073,-0.75220602,-0.63379406,-0.54774903,-0.46577555,-0.41642638,-0.41158176,-0.34837907,-0.27365271,-0.30257644,-0.39175947,-0.28020876,-0.17471157,-0.0035252654,0.047286014,0.15895658,0.3241587,0.38761991,0.30712211,0.17070241,-0.012205742,-0.15335068,-0.25486836,-0.16985762,-0.30726057,-0.43114786,-0.55269613,-0.66571069,-0.80962477,-0.95390897,-1.0891273,-1.072133,-0.89794757,-0.89019305,-0.77821162,-0.58897806,-0.5595786,-0.47684941,-0.41535078,-0.29464849,-0.18447528,-0.093735573,-0.14139943,-0.027591779,0.10188874,0.23142441,0.33732375,0.42353561,0.47452906,0.55626002,0.64524319,0.54220466,0.47656238,0.36224182,0.55479745,0.51223509,0.55096589,0.65234008,0.73109189,0.82131039,0.90526064,0.93341243,0.85599642,0.88384892,0.9062414,1.0444819,1.1684638,1.2163141,1.2749616,1.389242,1.4894075,1.5861365,1.5720404,1.3959258,1.2146831,1.0811441,0.91631842,0.74604723,0.53690665,0.60876563,0.57677901,0.58606085,0.4277097,0.22505246,0.066047964,-0.089544426,-0.28470175,-0.475743,-0.60920252,-0.57364673,-0.42841604,-0.3023474,-0.17339344,-0.12135238,-0.0070557864,0.12656458,0.27356513,0.32118108,0.45788631,0.60554458,0.68916875,0.77563675,0.68981655,0.75265896,0.8555808,0.99622178,1.1604327,1.3023082,1.3374252,1.4474807,1.4997732,1.5286812,1.5569185,1.4267038,1.281942,1.1281079,1.0873293,0.94952428,0.78796589,0.65330774,0.69398515,0.56564702,0.45189478,0.31805209,0.174043,0.073183753,-0.073076747,-0.19386242,-0.336256,-0.47434574,-0.60913399,-0.74445697,-0.88586951,-0.84857879,-0.70562539,-0.56542325,-0.42727181,-0.29543721,-0.17250185,-0.050902637,0.048389191,0.16378346,0.25026407,0.34027808,0.37601457,0.29801626,0.39038284,0.50875011,0.61402856,0.74932661,0.74636784,0.79192054,0.92585859,0.88370745,0.83496934,0.86946566,0.90931837,0.77562413,0.63763004,0.52400259,0.40208554,0.51835788,0.45759682,0.32758461,0.21393321,0.10615398,-0.021539788,-0.13683582,-0.25623296,-0.39684788,-0.5389753,-0.62219301,-0.78286215,-0.77980019,-0.65827247,-0.52207259,-0.38459907,-0.25687151,-0.12955545,-0.014067051,0.10469573,0.23085642,0.29525314,0.33150882,0.46511013,0.58905563,0.73466719,0.8864737,0.95621916,0.82050193,0.95077228,1.1061791,1.2495356,1.2248791,1.3668319,1.5266086,1.65294,1.8055852,1.8550366,1.6628391,1.5218286,1.4060298,1.3122956,1.1584738,0.98292475,0.90424273,1.021911,0.89379104,0.79453106,0.67324039,0.57406983,0.55516272,0.57392869,0.4661337,0.3496552,0.20511355,0.06466379,-0.010888128,-0.12582201,-0.2210983,-0.31183676,-0.45120516,-0.58712858,-0.74109048,-0.8846319,-0.99941927,-0.80757624,-0.62635136,-0.49885492,-0.3749849,-0.19119618,-0.065531207,0.076673357,0.26550561,0.29757748,0.46600121,0.67257585,0.68103544,0.84534211,1.0462985,1.2332653:1
1.2928959,1.1821024,1.1128548,1.018391,0.94302985,0.8406433,0.76833594,0.756525,0.65340666,0.54752791,0.45059775,0.41934388,0.32508204,0.27966577,0.31171588,0.23415821,0.14244903,0.048171012,-0.051542628,-0.15784556,-0.11285878,-0.038709516,-0.098205263,-0.19765762,-0.28076945,-0.37384665,-0.43708856,-0.33869596,-0.23111576,-0.13717317,-0.055867906,-0.085834231,-0.17848954,-0.26362943,-0.31411585,-0.34354084,-0.45296121,-0.53949973,-0.62653435,-0.71301858,-0.64673592,-0.64436878,-0.72171174,-0.79246667,-0.87600299,-0.96235536,-1.0341329,-0.9775703,-0.86945497,-0.75764362,-0.64403487,-0.52554272,-0.41890257,-0.301314,-0.19226688,-0.072905093,0.035506427,0.14976478,0.25954318,0.26274888,0.18031906,0.1133107,0.065630259,0.025680773,-0.081815219,-0.14419644,-0.26375806,-0.2606449,-0.19328828,-0.28259669,-0.37873361,-0.48043845,-0.55082757,-0.61020003,-0.69771687,-0.78127463,-0.84866146,-0.91466926,-0.95271119,-0.81732177,-0.8201794,-0.89631077,-0.95903185,-1.0216354,-1.0664419,-1.1518768,-1.2640315,-1.3528522,-1.4516848,-1.5515997,-1.6389935,-1.7335392,-1.8314217,-1.9146834,-1.975527,-1.9910779,-1.9914365,-1.8761828,-1.7609699,-1.5980401,-1.4675346,-1.3314031,-1.1694215,-1.0388089,-0.92320866,-0.80738814,-0.67445442,-0.54273128,-0.40946464,-0.27914127,-0.153899,-0.0094530121,0.12575228,0.25554244,0.39081194,0.49591269,0.63059724,0.76511339,0.88702286,0.99702657,0.97567058,1.0832703,1.2023712,1.3361276,1.4686592,1.6036166,1.7365151,1.8700363,2.0024641,2.162086,2.2710681,2.4036427,2.5664763,2.6977666,2.8533067,2.9380073,2.9437005,2.8606783,2.7331935,2.5976657,2.4539766,2.3087202,2.1888321,2.1704349,2.0637663,1.9837449,1.8690899,1.7377872,1.5999702,1.465987,1.3330137,1.2261022,1.1055049,0.99516505,0.86457712,0.75498805,0.61744255,0.48446561,0.35086259,0.2168676,0.081635108,-0.049440343,-0.17983518,-0.26433973,-0.38643332,-0.52113361,-0.68228835,-0.72976026,-0.83331855,-0.97644866,-1.0363542,-1.1483298,-1.2833573,-1.3947604,-1.4923744,-1.6198387,-1.7355464,-1.8864736,-1.9972221,-2.0038488,-1.9420507,-1.8848275,-1.790474,-1.6887994,-1.5890628,-1.4894998,-1.4252244,-1.3322961,-1.2370107,-1.1153576,-1.0061536,-0.92944838,-0.81603932,-0.75817645,-0.66910841,-0.60065305,-0.69758815,-0.77923323,-0.69013965,-0.55759923,-0.45712369,-0.36795678,-0.2713555,-0.16748559,-0.10670834,-0.17781413,-0.12620678,-0.031812388,0.044955507,0.11795992,0.19199557,0.23008328,0.30241975,0.35970067,0.42640929,0.48157372,0.40940484,0.28267318,0.12204289,-0.011313675,-0.097359121,-0.19369404,-0.32614924,-0.45897689,-0.62197716,-0.7552421,-0.88687996,-0.93687649,-0.8492513,-0.78230368,-0.71035383,-0.64777878,-0.61813485,-0.54567211,-0.49789508,-0.42858088,-0.41716879,-0.52425411,-0.56820283,-0.48283649,-0.42640227,-0.34670724,-0.29735796,-0.2164566,-0.14559357,-0.063837452,-1.2821101E-4,-0.054088721,-0.18132709,-0.26481399,-0.2206378,-0.18696966,-0.13954009,-0.035460734,0.032011466,0.14208826,0.23635913,0.33231717,0.42558261,0.36926085,0.34928155,0.44555763,0.52402336,0.61459857,0.72983803,0.74597867,0.85041161,0.95673739,1.0543769,1.1376877,1.2480182,1.3669203,1.4758388,1.4843421,1.3702916,1.2546669,1.1353654,1.0303503,0.90746278,0.79131709,0.68122202,0.65805618,0.54797624,0.43457013,0.31558921,0.2019805,0.089091574,-0.019768254,-0.13177233,-0.14757642,-0.15662079,-0.26075533,-0.39115577,-0.49544683,-0.61031302,-0.73473448,-0.84643397,-0.9376427,-1.0140265,-1.1256586,-1.2351956,-1.3508838,-1.4336328,-1.312389,-1.2187833,-1.1126416,-0.99337059,-0.91313494,-0.81258869,-0.76118575,-0.71879438,-0.67902595,-0.5824844,-0.42988626,-0.27041933,-0.17397636,-0.09592387,-0.097757682,0.020128136,0.10684965,0.1456889,0.22524116,0.2799324,0.3100813,0.20410978,0.087284917,0.019185295,-0.022995411,0.060453975,0.15509101,0.24874258,0.34932016,0.39006473,0.45346185,0.55767086,0.68769973,0.79699984,0.80045514,0.81224485,0.94037549,1.0676551,1.1849557,1.2805175,1.3089647,1.4113848,1.5461598,1.6536759,1.763843,1.8749274,1.9209065,1.8431106,1.6904562,1.5538139,1.447813,1.3229438,1.2201796,1.1087074,1.0428506,0.88423106,0.86898727,0.95131319,0.88539821,0.77940833,0.64584287,0.52479966,0.40396139,0.26119714,0.17398593,0.092552734,0.15477229,0.23970933,0.27811502,0.37530535,0.48980848,0.54399534,0.47269499,0.36516561,0.27274441,0.20531475,0.077973821,-0.04334153,-0.045083902,-0.11320883,-0.21719874,-0.33534204,-0.4485746,-0.57958544,-0.67313326,-0.74863791,-0.79054621,-0.68492724,-0.77445179,-0.86840195,-0.97445202,-1.0365529,-1.1525562,-1.2497091,-1.3581235,-1.4577874,-1.5417526,-1.4152944,-1.2858682,-1.1608948,-1.0545263,-0.92829486,-0.77711147,-0.64347071,-0.51440094,-0.38169462,-0.24890276,-0.14445898,-0.18375958,-0.13128302,-0.014256234,0.1127181,0.22816743,0.34311726,0.47396315,0.45780414,0.5671581,0.68592086,0.79430435,0.91161638,1.0417932,1.1620009,1.2876869,1.3484799:3
2.856939,2.8777143,2.8423675,2.7437562,2.644302,2.5343503,2.4302789,2.3282991,2.2279481,2.1200482,2.0202751,1.912306,1.809758,1.7122601,1.6013772,1.4976802,1.3928101,1.295471,1.1834223,1.0837226,0.9765032,0.86892322,0.766845,0.6619892,0.56196575,0.45815649,0.35055459,0.24525804,0.14888184,0.040495262,-0.061333079,-0.15998609,-0.26482964,-0.37041237,-0.47305067,-0.58111826,-0.68260078,-0.78724846,-0.88873201,-0.98944127,-1.0880885,-1.2028868,-1.3008148,-1.3819559,-1.3837438,-1.3762094,-1.3110484,-1.2824601,-1.2200076,-1.1847594,-1.1165198,-1.0749942,-0.96894632,-0.87490992,-0.78918848,-0.71796771,-0.69297122,-0.64175801,-0.59746732,-0.56028248,-0.5761751,-0.62859859,-0.61320346,-0.57860117,-0.52030438,-0.47652195,-0.44504061,-0.42555668,-0.3859829,-0.34095985,-0.34960991,-0.37836256,-0.33667694,-0.30352793,-0.26585541,-0.26426354,-0.3013118,-0.30031066,-0.33236402,-0.34456099,-0.356045,-0.40925515,-0.51763077,-0.62672954,-0.71117253,-0.76186857,-0.85201587,-0.94563648,-1.0016604,-0.92969036,-0.91614178,-0.85610976,-0.81256429,-0.77722398,-0.73391184,-0.65963845,-0.62429594,-0.67672939,-0.73244036,-0.67274758,-0.5882004,-0.48048245,-0.39927041,-0.3492222,-0.28527483,-0.21107468,-0.21208179,-0.20500429,-0.18608372,-0.2101611,-0.31751023,-0.34403644,-0.2661419,-0.18881157,-0.10539424,-0.032730593,0.032319944,0.097297466,0.16493692,0.23643587,0.31473956,0.33264441,0.26136714,0.36140678,0.30361449,0.39942612,0.45750195,0.37331395,0.454572,0.54253562,0.59011421,0.66539337,0.73712096,0.73466955,0.82816088,0.87440678,0.95329765,1.0644397,1.1499308,1.213226,1.2561914,1.205301,1.0794073,0.93503489,0.79028449,0.6827759,0.56021151,0.46137669,0.31485682,0.27349233,0.19059333,0.055550329,-0.082056913,-0.20742894,-0.3531056,-0.47831908,-0.51620818,-0.60759524,-0.75447974,-0.87192092,-0.97088703,-1.0757338,-1.1809472,-1.3280384,-1.4528,-1.5775303,-1.7031433,-1.8283669,-1.9448789,-2.0782038,-2.1393919,-2.0839379,-2.0048779,-1.9255957,-1.8354219,-1.7405242,-1.6576591,-1.5595089,-1.4861811,-1.3756039,-1.2695577,-1.181671,-1.1394188,-1.1808222,-1.1590894,-1.1425672,-1.0451382,-0.94241045,-0.83640237,-0.75082654,-0.65874611,-0.62546012,-0.55375108,-0.44494485,-0.35168439,-0.28949575,-0.23738532,-0.16988335,-0.079881386,0.003707809,0.060566207,0.047462107,-0.041519568,-0.098469059,-0.14127503,-0.074345479,0.025406905,0.11701405,0.21426691,0.24959055,0.33715514,0.43071142,0.53813164,0.63404311,0.68231463,0.69332556,0.80096568,0.90174705,0.99388823,1.0992171,1.1875824,1.2452525,1.3397359,1.4457385,1.5615587,1.6598106,1.7647597,1.8059907,1.7076863,1.6067235,1.5075165,1.4015689,1.3011487,1.1876645,1.1318506,1.025176,0.92468817,0.82894371,0.82829849,0.81295288,0.71237766,0.6155661,0.51545882,0.42951031,0.34098438,0.26611941,0.32364934,0.37813117,0.44881824,0.49877559,0.43846733,0.36674676,0.27655839,0.24194595,0.15048205,0.055618842,-0.0077990384,0.014929009,-0.075452243,-0.17301092,-0.26439811,-0.35355922,-0.44924638,-0.48677281,-0.46444612,-0.53975635,-0.61626867,-0.68656948,-0.75939724,-0.84088888,-0.92355815,-0.99212712,-1.0013737,-0.96820247,-0.86847684,-0.74525056,-0.64322579,-0.49876791,-0.40701182,-0.33469869,-0.24122947,-0.11989597,0.0042719311,0.15145372,0.28630114,0.37412687,0.43633703,0.5622907,0.67438104,0.81070359,0.91547566,1.0391007,1.1859219,1.311886,1.4148736,1.5080278,1.4580697,1.3601662,1.291418,1.2051509,1.1121639,1.0035785,0.96091867,0.85599701,0.74382041,0.67310373,0.59471349,0.50015854,0.4867889,0.52379284,0.43487821,0.32029992,0.24663675,0.15010728,0.18739883,0.11007205,0.023685988,-0.071694181,-0.17090983,-0.24280339,-0.22995662,-0.14183412,-0.1743693,-0.24197018,-0.26453386,-0.34469398,-0.33373664,-0.41113256,-0.4669213,-0.53260126,-0.50033749,-0.46491834,-0.51300517,-0.5700782,-0.61501193,-0.67500251,-0.75075665,-0.74712351,-0.63081004,-0.51412478,-0.40329976,-0.3259601,-0.221541,-0.13049182,-0.15867624,-0.20282471,-0.23941872,-0.26090564,-0.29705003,-0.36476543,-0.40450026,-0.35407969,-0.36269429,-0.38011672,-0.44445418,-0.48997175,-0.51404668,-0.5845247,-0.64916424,-0.66584197,-0.6319944,-0.55071776,-0.56549259,-0.60662603,-0.63517107,-0.68344399,-0.75678035,-0.78674458,-0.8534091,-0.88468711,-0.94499983,-0.99106662,-1.0481366,-1.0995921,-1.1635187,-1.2135892,-1.2475823,-1.2865355,-1.3270873,-1.3328875,-1.359998,-1.3599583,-1.3744203,-1.3765712,-1.3489189,-1.38608,-1.3352886,-1.2294474,-1.1356543,-1.0333608,-0.92936347,-0.82843563,-0.72188653,-0.61992194,-0.52398899,-0.41672799,-0.32284252,-0.21331196,-0.11067581,-0.0085454853,0.095792465,0.1952614,0.30309893,0.40391999,0.50949507,0.61466657,0.71546266,0.81706635,0.91854823,1.0281783,1.1321088,1.232342,1.3348446,1.4456398,1.5485428,1.649727,1.7535485,1.8585141,1.9584705,2.0601074,2.1681527,2.2700787,2.3703829,2.4745989,2.5833264,2.6835618,2.7886845:3
1.2387857,1.1448567,1.044258,0.98042018,0.89163173,0.80795449,0.72192476,0.62127512,0.48543123,0.34018586,0.21885435,0.083781579,0.02318857,-0.049104301,-0.19084648,-0.30355831,-0.43373595,-0.55453483,-0.67345963,-0.79611006,-0.91201077,-1.0412096,-1.0531399,-0.97193507,-0.91415898,-0.81080986,-0.71285573,-0.60607565,-0.49576551,-0.39546937,-0.29018528,-0.18823709,-0.11201959,-0.018283986,0.081839293,0.19524309,0.29708061,0.39599678,0.50150781,0.57076453,0.68358263,0.74459349,0.83631416,0.8869582,0.95472376,0.95302751,0.93794184,0.87219881,0.81107355,0.72873455,0.65468745,0.60827211,0.64696589,0.56034202,0.63201384,0.66407956,0.74426675,0.85692888,0.96328329,1.0936783,1.1913451,1.2623481,1.3404234,1.3848587,1.4949757,1.5549485,1.5969031,1.6551219,1.6881447,1.740347,1.7939895,1.8395877,1.9189614,1.9720217,1.9685892,1.9618968,1.8949252,1.8105752,1.7236745,1.6469788,1.5632972,1.4672756,1.3757919,1.298752,1.1881848,1.0943146,1.0171891,0.9416851,0.8480191,0.80523322,0.6878628,0.60291417,0.5370373,0.43512216,0.3615574,0.32039519,0.30201896,0.26773792,0.33573183,0.41753955,0.46181491,0.52138294,0.57586288,0.60280889,0.61873851,0.5442704,0.43851288,0.32140939,0.21076171,0.097815298,-0.017247669,-0.065459179,-0.094383338,-0.23472379,-0.34828992,-0.46628601,-0.57988589,-0.70282257,-0.77933671,-0.89059324,-0.99078582,-1.0624956,-1.1746096,-1.2784722,-1.4075664,-1.5149832,-1.6452934,-1.6922737,-1.7864524,-1.8621597,-1.9735522,-2.0729497,-2.1830423,-2.2925526,-2.3963317,-2.5064512,-2.5455212,-2.5919478,-2.6848058,-2.7122402,-2.6969682,-2.6102857,-2.5798858,-2.5282081,-2.5193553,-2.4436757,-2.4601106,-2.3956024,-2.3238688,-2.2210043,-2.1693566,-2.0603197,-1.9567497,-1.9222953,-1.8251017,-1.7464691,-1.6523815,-1.5971794,-1.5280432,-1.447604,-1.3476583,-1.2425991,-1.1364966,-1.0355445,-0.9260538,-0.8249275,-0.71559335,-0.60514197,-0.50293903,-0.39371152,-0.28640295,-0.16810526,-0.11089065,-0.06035404,-0.0068332326,0.089418796,0.17149322,0.3064841,0.42547334,0.54165518,0.66029924,0.79286329,0.89734729,0.99847441,1.1195942,1.2027883,1.28173,1.2747757,1.1881231,1.0949349,1.01126,0.98205425,0.92078607,0.83875338,0.75543524,0.72286368,0.69412905,0.66533029,0.61436069,0.52689763,0.43502408,0.34380976,0.24688937,0.14986189,0.081868592,0.15271083,0.19064833,0.25052219,0.32435845,0.29748778,0.20080263,0.1089582,0.015564825,-0.073124155,-0.17691863,-0.27893913,-0.36111856,-0.48043481,-0.60511886,-0.72664419,-0.79513986,-0.86493178,-0.87136141,-0.89506211,-0.91173573,-0.88870191,-0.83083705,-0.86406212,-0.82052946,-0.75260464,-0.68541532,-0.56218697,-0.53899672,-0.44905632,-0.32816921,-0.28774636,-0.15627616,-0.045852652,0.081172467,0.18615223,0.28711402,0.39734107,0.44359565,0.54093133,0.62845452,0.70891993,0.78172339,0.88850591,0.97201695,0.90124702,0.80381484,0.72970803,0.68004472,0.62888953,0.5519561,0.49831124,0.44797413,0.40594721,0.35787671,0.28959614,0.21229943,0.14574348,0.041110581,-0.013668287,-0.010229444,0.0035763096,-0.044866471,-0.095899851,-0.15199807,-0.20759286,-0.29617004,-0.37558706,-0.4678269,-0.55382698,-0.62498144,-0.70814317,-0.73173924,-0.65064171,-0.65378129,-0.57116369,-0.5271598,-0.5355466,-0.63963522,-0.73925836,-0.84286613,-0.92991548,-1.0213791,-1.0695584,-0.94840984,-0.87755634,-0.83756225,-0.72242563,-0.64170519,-0.52239648,-0.41286972,-0.29142739,-0.16784153,-0.12225136,-0.015077128,0.10785597,0.20395231,0.30004472,0.42315132,0.43841287,0.56166458,0.6562834,0.73199663,0.82652666,0.94235558,1.0215951,1.1172749,1.2203261,1.3186354,1.3979457,1.4805686,1.5760996,1.6863065,1.7833862,1.8551072,1.8941299,1.8012145,1.6928366,1.5945576,1.4969059,1.4023135,1.3033032,1.1861135,1.082064,0.96241719,0.86482947,0.7458523,0.62453273,0.50349464,0.38667104,0.27628931,0.14143175,-0.0084802378,-0.10472046,-0.2279225,-0.34890656,-0.49691134,-0.59761387,-0.72341595,-0.87284663,-0.98000951,-1.1222369,-1.1276687,-1.0929078,-1.0081003,-0.91386813,-0.82003087,-0.72811907,-0.64902923,-0.54690065,-0.45964026,-0.40691352,-0.45563109,-0.47147343,-0.40971883,-0.31699681,-0.22359778,-0.13456989,-0.046029429,0.033922892,0.1157481,0.17508227,0.22385856,0.33506421,0.28295448,0.19839191,0.098487524,0.021025541,-0.069383089,-0.17190214,-0.20736411,-0.31190635,-0.40943066,-0.52219093,-0.62647775,-0.73023905,-0.84281193,-0.94406642,-1.0387516,-1.0364791,-1.1234953,-1.1685157,-1.197098,-1.0949591,-0.98112808,-0.859353,-0.73960869,-0.6458602,-0.54040406,-0.42673129,-0.33552755,-0.19149925,-0.085110155,0.033272001,0.17060775,0.27262447,0.38188929,0.46811442,0.42315069,0.36477392,0.34629553,0.33377921,0.33403921,0.27405225,0.26341933,0.18946286,0.14952856,0.19106716,0.26488279,0.33835125,0.43011397,0.52310041,0.61018559,0.6544883,0.70394311,0.76025358,0.82103655,0.88719462,0.94655381,0.99885064,1.0528028,1.1235071,1.2187345:5
0.92314958,0.85120137,0.73093282,0.60516852,0.52851052,0.45902196,0.34764249,0.28663778,0.15920162,0.019360344,-0.11639309,-0.23597492,-0.36649992,-0.46306484,-0.53179051,-0.65098232,-0.79887206,-0.93643538,-1.0497698,-1.1298402,-1.2212374,-1.2396856,-1.2894592,-1.3249852,-1.4036458,-1.4706823,-1.5308413,-1.5700832,-1.5475549,-1.5348005,-1.5096893,-1.4600979,-1.369015,-1.3004334,-1.1883536,-1.1168499,-1.0562827,-0.98920126,-0.91249101,-0.86075965,-0.80892855,-0.69249846,-0.59696526,-0.47485384,-0.35263982,-0.23055139,-0.10790071,0.011441576,0.11715632,0.24019878,0.36300467,0.48630194,0.54909053,0.52703509,0.45936559,0.40648887,0.42889884,0.43040933,0.50067053,0.61127232,0.70463182,0.82782307,0.92612853,1.008696,1.1133961,1.1991081,1.3024465,1.4285131,1.5458055,1.4918377,1.3951578,1.3135421,1.2246034,1.125551,1.0771603,1.0160094,0.9441984,0.8810738,0.77920406,0.68570586,0.59545213,0.55772271,0.60126857,0.6444512,0.68996816,0.7593063,0.84925724,0.93993531,1.0008775,0.91352452,0.79244503,0.67112423,0.53687958,0.45250075,0.34529074,0.23649883,0.13100145,-0.0045072127,-0.11788712,-0.26102955,-0.40608366,-0.47618121,-0.58107555,-0.69536534,-0.829265,-0.9455167,-1.0232656,-1.1351622,-1.1754441,-1.2688097,-1.3886428,-1.4632392,-1.5033266,-1.5886894,-1.671419,-1.6694069,-1.6310342,-1.5386488,-1.4846793,-1.3935531,-1.3582518,-1.2261413,-1.1423617,-1.0518448,-0.93337253,-0.81455086,-0.70159633,-0.59669104,-0.49205685,-0.38724199,-0.29446033,-0.20108248,-0.10301194,0.020739506,0.10841243,0.21575025,0.34167991,0.45572516,0.55248259,0.61225073,0.72068855,0.83803928,0.93460136,1.019458,1.1201955,1.2191726,1.3308022,1.4553877,1.572328,1.6831568,1.6189866,1.4917302,1.3600639,1.2630386,1.1605295,1.105893,1.0520087,0.997124,0.87126419,0.75076514,0.66565106,0.56353125,0.47948122,0.52405479,0.60593393,0.73617755,0.87003842,0.97924652,1.0839058,1.1076892,0.99519716,0.88722168,0.77233074,0.67484397,0.59514149,0.48909972,0.37552158,0.26050265,0.15285036,0.059281914,-0.036595467,-0.14669668,-0.26898475,-0.3896317,-0.51126222,-0.62975804,-0.74828265,-0.85324156,-0.94714759,-1.059701,-1.1024819,-1.1516547,-1.1970773,-1.2254337,-1.1222045,-0.9922603,-0.86911407,-0.72201742,-0.56723239,-0.39452157,-0.27465846,-0.15258689,-0.018732407,0.13712242,0.26805479,0.40002629,0.52942225,0.6661901,0.82121824,0.9583585,0.90033253,0.79511514,0.69796651,0.61526837,0.5313323,0.44362203,0.36483241,0.29817033,0.21235975,0.10587377,-0.0027793992,-0.10649853,-0.21885982,-0.31478943,-0.37971816,-0.40637067,-0.3975934,-0.38747428,-0.4669693,-0.62702739,-0.77256635,-0.91402868,-1.062846,-1.1961612,-1.3341557,-1.323552,-1.3314718,-1.3869226,-1.5041706,-1.6127048,-1.7002022,-1.7831046,-1.7840803,-1.7684818,-1.6583804,-1.5490762,-1.4217732,-1.3161576,-1.1839475,-1.1194577,-1.0211102,-0.93796234,-0.83826967,-0.78673295,-0.71442156,-0.59309428,-0.48039654,-0.34889641,-0.20836523,-0.05425042,0.053172246,0.16231306,0.26806879,0.42130488,0.56371088,0.68467661,0.80331916,0.92493443,1.0457803,1.1282551,1.2738087,1.3985937,1.5176373,1.6489319,1.7996449,1.9312959,2.0591815,2.1661172,2.260085,2.3431149,2.4253594,2.5363051,2.5793392,2.5669853,2.5172631,2.4634896,2.3889742,2.314387,2.2000053,2.0645853,1.9171166,1.8288118,1.7044958,1.5932717,1.4600845,1.3548983,1.2256538,1.0714875,0.92271015,0.86721394,0.7331674,0.6006712,0.45916522,0.32451034,0.20526298,0.066822411,-0.059572582,-0.120866,-0.22872115,-0.31126953,-0.44563256,-0.57680419,-0.71891786,-0.77170017,-0.90703911,-1.0149541,-1.0561584,-1.1649757,-1.2383439,-1.348447,-1.4710138,-1.5379744,-1.4963329,-1.5960972,-1.5720695,-1.5291803,-1.5279273,-1.5212737,-1.4558139,-1.4720715,-1.4428466,-1.4002473,-1.3438085,-1.3253257,-1.2674826,-1.2002281,-1.1759104,-1.1189158,-1.0783422,-1.0419829,-0.99057579,-0.93525199,-0.88552603,-0.80700899,-0.71468913,-0.63226706,-0.5629038,-0.45857579,-0.34713807,-0.25830333,-0.2787912,-0.27292351,-0.17654265,-0.074735676,0.035159873,0.12980328,0.16087051,0.20206957,0.3031948,0.39027868,0.50919044,0.61717102,0.73961977,0.86637924,0.99143736,0.97142744,0.889085,0.81664306,0.70929617,0.63676192,0.54831519,0.45795819,0.4298361,0.32325469,0.20086598,0.085101923,-0.0031734785,-0.070637284,-0.096364556,-0.17589052,-0.2495557,-0.3610719,-0.48015038,-0.57904484,-0.65459301,-0.70348861,-0.76929026,-0.82390602,-0.84887515,-0.91864903,-0.96374768,-0.98625278,-0.95047791,-0.82892811,-0.74643762,-0.6915313,-0.60191279,-0.49148084,-0.37421902,-0.25102264,-0.13977213,-0.021287162,0.097451551,0.20402149,0.3330842,0.44344907,0.56283652,0.69375883,0.78879664,0.76239364,0.66932369,0.59066282,0.49882445,0.38350833,0.28643807,0.2872912,0.32464686,0.38150032,0.48126538,0.62116533,0.69654969,0.74123132,0.77620511,0.80496896,0.8264088,0.85493646,0.89042367:5
0.69198911,0.60965857,0.52648521,0.45054073,0.37021862,0.29157413,0.21700154,0.14392119,0.064887893,-0.0060466199,-0.06923534,-0.052460197,0.015284215,0.05563335,-0.044011247,-0.12803211,-0.21162482,-0.29426702,-0.37784633,-0.46413555,-0.53560068,-0.60948965,-0.69397454,-0.78013475,-0.85225224,-0.92975024,-1.0135493,-1.0750309,-1.1476721,-1.2194818,-1.287768,-1.349904,-1.4197536,-1.4755606,-1.5343678,-1.5870404,-1.637409,-1.683494,-1.7156912,-1.7238404,-1.7078689,-1.6534126,-1.5817191,-1.5052216,-1.4349709,-1.3528611,-1.2706939,-1.2023087,-1.1185397,-1.0329926,-0.956509,-0.88200035,-0.79558776,-0.71155728,-0.64471018,-0.56382324,-0.48177861,-0.42194409,-0.34489184,-0.27696365,-0.20721891,-0.13698415,-0.064360421,0.0021096872,-0.021798543,-0.095935361,-0.17772426,-0.21167422,-0.13866159,-0.16776469,-0.25593833,-0.33811689,-0.41393275,-0.50056863,-0.57072958,-0.63268871,-0.70351532,-0.75940014,-0.83165166,-0.87682884,-0.92280617,-0.97925531,-1.017395,-1.0522622,-1.0828788,-1.1172799,-1.1431534,-1.181179,-1.2148123,-1.2368739,-1.2458683,-1.2554692,-1.2594454,-1.2490196,-1.2366937,-1.2024843,-1.1460759,-1.0677167,-0.99984756,-0.89683158,-0.80887375,-0.75313082,-0.70138674,-0.65144319,-0.60428948,-0.55501374,-0.50229064,-0.44588245,-0.39278037,-0.33595945,-0.28887351,-0.24473853,-0.18482333,-0.20865453,-0.2316691,-0.24553142,-0.26381454,-0.26563764,-0.26541235,-0.25471222,-0.23175201,-0.19911232,-0.17138955,-0.12683031,-0.086286734,-0.047285319,-0.0040540944,0.034121311,0.058042859,0.080912444,0.09645453,0.11065169,0.11168493,0.1048679,0.10658823,0.14095581,0.21197103,0.28225392,0.35178454,0.42600399,0.50350411,0.57551973,0.64567334,0.72713691,0.80127679,0.87538391,0.94831644,1.0220407,1.1055746,1.1735458,1.247581,1.3231479,1.400733,1.4712505,1.542924,1.6187251,1.693587,1.765029,1.8383556,1.9088757,1.9872839,2.0613635,2.1377726,2.208014,2.2828734,2.3569932,2.4310399,2.5035705,2.5808964,2.6452489,2.6901844,2.6149871,2.5458576,2.4673081,2.4013672,2.3189093,2.2502548,2.1759845,2.103539,2.0275438,1.954524,1.8833043,1.805219,1.7305884,1.6539952,1.5890801,1.5116485,1.4355948,1.3638123,1.2859256,1.213982,1.1409019,1.0650891,0.99003208,0.91442742,0.83914473,0.76961156,0.69480165,0.61856897,0.54490478,0.47719895,0.40303481,0.32824505,0.25038552,0.17175616,0.12812028,0.065892139,0.059393868,0.080611245,0.070504704,0.051559733,0.036158763,0.026155861,0.003546849,-0.025294204,-0.062731596,-0.11096998,-0.16521452,-0.21100438,-0.25096118,-0.28830114,-0.30818112,-0.31408876,-0.31767278,-0.31908932,-0.30639024,-0.28198213,-0.26122937,-0.25124942,-0.23481672,-0.20741015,-0.23880749,-0.28528141,-0.33886737,-0.39223757,-0.44090206,-0.4942016,-0.55392019,-0.59913895,-0.67176027,-0.73863599,-0.81348306,-0.89647483,-0.96139568,-1.0267699,-1.0840164,-1.1284048,-1.1669965,-1.1918236,-1.2060046,-1.2054106,-1.2048082,-1.1868514,-1.1741468,-1.1525854,-1.1173459,-1.0805717,-1.051804,-1.0096268,-0.954772,-0.88895858,-0.83359711,-0.76247415,-0.68824212,-0.72279962,-0.66425283,-0.59064041,-0.51322233,-0.43936895,-0.36745321,-0.35329574,-0.42611706,-0.49779154,-0.56835325,-0.6450638,-0.72566099,-0.79533895,-0.86310573,-0.94189896,-1.0115487,-1.0967459,-1.1669446,-1.2401799,-1.3156264,-1.3870176,-1.4617348,-1.5363153,-1.6046918,-1.6720774,-1.6993304,-1.7023764,-1.6874119,-1.6571311,-1.6087483,-1.5475908,-1.4989857,-1.4251882,-1.349795,-1.275461,-1.1946788,-1.1161783,-1.0371483,-0.95774577,-0.85505379,-0.77338094,-0.69153801,-0.58858983,-0.50855697,-0.40384768,-0.29913296,-0.19441421,-0.089720062,-0.010347354,-0.0041919715,-0.04732987,-0.060245153,-0.0036698715,0.073490548,0.16227701,0.23891617,0.30679397,0.37900985,0.33337096,0.27519902,0.22678226,0.15781489,0.11338701,0.040702911,-0.033948998,-0.10749357,-0.16539775,-0.22570882,-0.28788384,-0.33981956,-0.38646772,-0.4077137,-0.40515094,-0.35621039,-0.29774926,-0.22884279,-0.15603367,-0.084103388,-0.015910482,0.053764997,0.13742101,0.20960424,0.2832117,0.35368473,0.42431553,0.49235289,0.5662043,0.6407778,0.71235353,0.79040589,0.86495325,0.93457434,1.0152475,1.0883571,1.1698226,1.2250943,1.1676818,1.0962842,1.0246495,0.98335668,1.0066071,1.0679909,1.1481302,1.2208187,1.2961406,1.3677676,1.4378498,1.5115391,1.5123666,1.5760742,1.6431324,1.5883274,1.5135744,1.4419322,1.4029286,1.408796,1.3396014,1.2691535,1.1945149,1.1200456,1.0357577,0.95746987,0.88550554,0.83762168,0.86624171,0.94184617,1.0092686,1.0794751,1.1368152,1.0968485,1.0148023,0.93889869,0.87519676,0.79285862,0.71926536,0.64599522,0.57494966,0.50462525,0.42481318,0.34909883,0.28176347,0.20637168,0.12815263,0.061692355,-0.017983101,-0.086826153,-0.15549356,-0.22629536,-0.2581478,-0.24615235,-0.20444282,-0.15113995,-0.09448344,-0.03537332,0.052554953,0.1449764,0.22319255,0.30606016,0.35276424,0.39729201,0.47842515,0.57710063,0.67161553:4
2.5303236,2.2590547,2.0347292,1.7769031,1.5873871,1.3158439,1.0449675,0.82100434,0.64460251,0.45816511,0.19748816,-0.073859133,-0.34506278,-0.56983806,-0.84152345,-1.0185779,-1.1923074,-1.419191,-1.689942,-1.9597505,-2.2302709,-2.4768601,-2.6650912,-2.81252,-2.8207373,-2.6708857,-2.5934483,-2.5435827,-2.3830481,-2.2629337,-2.1653355,-2.1471632,-1.9829398,-1.9440875,-1.785894,-1.7442666,-1.6530418,-1.5551654,-1.4623774,-1.330702,-1.3104052,-1.1838257,-1.0148553,-0.89415153,-0.80163599,-0.65275391,-0.55946881,-0.48289405,-0.32148674,-0.19977402,-0.096617096,-0.076775989,-0.15021542,-0.10073501,-0.10739249,-0.054315888,-0.027303898,0.023619251,-0.0069245262,-0.021731856,-0.040845165,-0.047049207,-0.15847377,-0.32616605,-0.50422794,-0.46237202,-0.44471493,-0.31629579,-0.33826148,-0.3370008,-0.23035402,-0.19988056,-0.21115874,-0.24590268,-0.21780005,-0.1772624,-0.12993294,-0.075132977,-0.065780506,0.012464674,0.085472049,-0.014647451,0.051549165,0.15866456,0.11858266,0.24066172,0.31300451,0.39376369,0.49207898,0.57639778,0.6716838,0.79173715,0.84773387,0.79693271,0.65236968,0.50074164,0.34171742,0.21928873,0.071383695,-0.041441001,-0.17361858,-0.1996504,-0.30159462,-0.48340938,-0.65687787,-0.55194562,-0.45218511,-0.39565055,-0.35336268,-0.20513706,-0.045144801,0.052248458,0.10614291,0.18020213,0.21808607,0.24804522,0.30835344,0.4218196,0.56663392,0.67534986,0.79000388,0.91260172,1.0363908,1.1653321,1.2869599,1.4290228,1.5571974,1.707379,1.7820231,1.9371829,1.9919523,1.9557316,1.7434057,1.5609517,1.4147643,1.2816555,1.1314388,0.94390128,0.77918681,0.60211444,0.40568498,0.25320113,0.24757214,0.064711804,-0.12117135,-0.34199795,-0.52300864,-0.72212444,-0.91242154,-1.1068387,-1.2157706,-1.0953174,-0.95783812,-0.95788016,-0.79152023,-0.66289735,-0.53568685,-0.41679008,-0.32887352,-0.15033593,-0.061937129,-0.050326893,0.049010561,0.16151825,0.30323639,0.32863989,0.35102358,0.5096784,0.66234934,0.68712754,0.69031673,0.85067448,0.94445298,0.97320978,1.0800684,1.1897702,1.2620542,1.3639257,1.4547541,1.6087337,1.5834131,1.3832854,1.1899752,1.0274495,0.91480709,0.74098314,0.72500528,0.60815848,0.47251812,0.30249844,0.11373116,-0.0056536648,-0.12417444,-0.28751099,-0.48216504,-0.6788755,-0.83865124,-1.0227133,-1.1849628,-1.3437571,-1.5314432,-1.6899873,-1.6984188,-1.578331,-1.4045048,-1.3558968,-1.1840961,-0.98811843,-0.81984644,-0.65292016,-0.49941965,-0.3138701,-0.35013881,-0.42034911,-0.20751897,-0.2652835,-0.1240681,0.10034555,0.27145329,0.42895206,0.57226061,0.6715969,0.59919456,0.6684248,0.76659708,0.94740097,1.0265258,1.187732,1.1967215,1.0972254,0.90396597,0.79723556,0.6973842,0.78333604,0.61069262,0.41841671,0.2212053,0.22882215,0.10860307,-0.082382955,-0.27345075,-0.45723194,-0.63651512,-0.66768055,-0.54951078,-0.41603787,-0.24861512,-0.12646571,0.02387269,0.19496355,0.35136079,0.51865643,0.68035675,0.86892636,1.0509049,1.1070735,1.2348283,1.3337095,1.4671615,1.2728159,1.1135815,0.99356124,0.84478184,0.81771479,0.72197696,0.51713383,0.56156193,0.39654691,0.20694941,0.029393751,-0.14783519,-0.15779883,-0.17918328,-0.33116699,-0.43330081,-0.58522673,-0.72829381,-0.89366497,-1.0232034,-1.166771,-1.3241077,-1.3090415,-1.1513198,-0.92638135,-0.73574471,-0.53225252,-0.31084801,-0.10348389,0.050310335,0.21465656,0.44358648,0.70506345,0.852771,0.9356928,1.1028172,1.3421291,1.5467393,1.7286015,1.7298367,1.5881665,1.4450741,1.3347433,1.1890107,1.0707669,0.95767203,0.8367321,0.72228702,0.80206342,0.72964996,0.63652283,0.56114045,0.46265032,0.34467353,0.23286231,0.28169654,0.30397008,0.21629821,0.11935769,0.040371848,-0.051837326,-0.13529059,-0.11267321,-0.21223191,-0.28895947,-0.37555209,-0.46054631,-0.5543194,-0.67149936,-0.72122273,-0.80163418,-0.84074417,-0.67400634,-0.49037693,-0.30894236,-0.12964473,0.038805262,0.1478174,0.25615711,0.39838091,0.60169938,0.79515286,0.92994204,0.85370499,0.7624764,0.65467827,0.54939058,0.46471036,0.36922671,0.30428402,0.26824386,0.17122221,0.10928062,0.2359267,0.20365312,0.13467756,0.068695168,0.11656078,0.039635448,0.06790969,-0.015817961,-0.1299296,-0.080389009,-0.046039201,-0.13697698,-0.21192805,-0.010046153,0.13765548,0.297557,0.43493102,0.39173618,0.39137793,0.36450191,0.45022663,0.36547009,0.34290025,0.34316253,0.30080115,0.25189115,0.12434353,0.23728915,0.097875659,0.1547783,0.072412065,-0.035001207,-0.13409748,-0.17816054,-0.25827333,-0.24806343,-0.3768482,-0.48966607,-0.66152324,-0.81446927,-0.8700361,-1.0467502,-1.0789458,-1.3100007,-1.4570615,-1.4975314,-1.6843638,-1.8053247,-1.9874546,-2.1539402,-2.1374128,-2.2352147,-2.3628513,-2.4713325,-2.2757067,-2.0051425,-1.774702,-1.5116561,-1.2410919,-0.97052002,-0.69980282,-0.47621341,-0.20541136,0.065379231,0.28900215,0.55987223,0.83077399,1.101655,1.3725217,1.6434525,1.9143379,2.1852952,2.4092251,2.5462665,2.5463537:1
0.5863988,0.46673624,0.35479374,0.26941834,0.17557111,0.079804925,-0.011190323,-0.097703664,-0.17850871,-0.25903845,-0.26986017,-0.18277278,-0.17590659,-0.087474095,-0.20305266,-0.30716066,-0.40285572,-0.49658628,-0.59868499,-0.69324567,-0.78137802,-0.86573408,-0.94881484,-1.02981,-1.1106561,-1.1873051,-1.2648988,-1.3405338,-1.4132126,-1.4813612,-1.5357236,-1.5994807,-1.6475942,-1.699085,-1.7535318,-1.7749474,-1.7950687,-1.7943708,-1.7954083,-1.753597,-1.6674625,-1.5806291,-1.4893736,-1.3906652,-1.2966838,-1.2050031,-1.0993521,-1.0034373,-0.90251325,-0.79118675,-0.68324562,-0.58126033,-0.53462126,-0.60730596,-0.65416926,-0.65054484,-0.56683094,-0.49406306,-0.40373629,-0.31260613,-0.2595234,-0.21283159,-0.23524898,-0.26381814,-0.29049949,-0.32450601,-0.34559821,-0.35348273,-0.36357421,-0.36977762,-0.3690876,-0.37070479,-0.36341802,-0.35026136,-0.31762411,-0.27133986,-0.21714757,-0.14745126,-0.048227453,0.059451575,0.14924781,0.22520507,0.29342319,0.36006546,0.42081704,0.47984584,0.53932922,0.59020383,0.65947856,0.73145524,0.77886018,0.84202974,0.91580161,0.95525848,0.89994935,0.85948706,0.84150174,0.84098846,0.85005458,0.90111436,0.99772878,0.99161497,0.97018637,0.96285227,0.95704347,0.95885604,0.96685484,0.98040162,0.99918438,1.0182197,1.0391047,1.064318,1.0874523,1.1120174,1.136764,1.1618781,1.1898787,1.2146971,1.2440956,1.2801696,1.3106305,1.3306831,1.3409764,1.3462757,1.3953397,1.4788708,1.5757159,1.6818835,1.7943176,1.9072222,1.8658827,1.753628,1.6835434,1.6244113,1.5676128,1.5288608,1.4368472,1.3157388,1.257213,1.2326336,1.2013374,1.1579039,1.117154,1.0729357,1.0188412,0.96558685,0.92488903,0.88212252,0.84110789,0.80086865,0.77744387,0.74085049,0.70772235,0.68354348,0.65065675,0.62553006,0.59069896,0.57211192,0.56119541,0.5556868,0.54324261,0.53490799,0.52523003,0.51113215,0.42018627,0.35692657,0.33596497,0.32979349,0.3340567,0.35930221,0.34501965,0.29374921,0.26153582,0.20776542,0.18878189,0.17696581,0.14627383,0.10916606,0.061028982,0.025174914,-0.0067146256,-0.033027151,-0.069957993,-0.12840132,-0.20871834,-0.2997047,-0.39312732,-0.48998272,-0.4745525,-0.37569572,-0.42627026,-0.42086237,-0.43981102,-0.51000144,-0.57886918,-0.63825761,-0.71167473,-0.77596132,-0.83409372,-0.88126627,-0.91797975,-0.94030957,-0.95947992,-0.95119553,-0.90235213,-0.80359783,-0.73208509,-0.6698717,-0.63692975,-0.62112726,-0.60042049,-0.57229035,-0.53984708,-0.50266574,-0.4630186,-0.41117773,-0.33244486,-0.28620768,-0.3821273,-0.48136724,-0.48806971,-0.46054952,-0.42571759,-0.40374172,-0.37243632,-0.31089348,-0.24214854,-0.17169393,-0.085304353,0.0028257514,0.10091405,0.037170458,-0.080387144,-0.16014367,-0.24000725,-0.33153292,-0.41114973,-0.49527701,-0.59801575,-0.63872386,-0.70851919,-0.77202204,-0.84270387,-0.9088744,-0.98341308,-1.0591458,-1.134591,-1.2204161,-1.2909584,-1.3748741,-1.4537094,-1.5285008,-1.6147793,-1.7045291,-1.8073834,-1.9035227,-2.0128478,-2.1084935,-2.1969253,-2.2600774,-2.3038402,-2.3100192,-2.290955,-2.2519844,-2.1924662,-2.1308121,-2.0452699,-1.9667023,-1.8830513,-1.7896978,-1.7049322,-1.6125626,-1.5192696,-1.4259243,-1.3268631,-1.2341213,-1.1395477,-1.0423893,-0.94343623,-0.8538023,-0.75145243,-0.65831143,-0.58737452,-0.67039922,-0.72678281,-0.69361235,-0.58530846,-0.47906246,-0.37696952,-0.2806132,-0.17884611,-0.074817017,-0.025500191,0.072531722,0.19000467,0.10313278,0.0032994137,-0.095937612,-0.18832998,-0.28204273,-0.28184754,-0.36192302,-0.45520618,-0.54812213,-0.63746646,-0.7220333,-0.79964229,-0.87376066,-0.95203377,-1.0084059,-1.0576711,-1.0561077,-1.0332404,-0.98928336,-0.92298104,-0.83650437,-0.73652926,-0.63596773,-0.50311012,-0.36999436,-0.26928627,-0.15255228,-0.03638318,0.096383224,0.22919748,0.34517848,0.46136497,0.58294579,0.60111912,0.60742787,0.71795804,0.85041544,0.966485,1.0821573,1.0868108,0.99783552,0.90309512,0.81886514,0.74136637,0.66621538,0.62133811,0.60335863,0.64527893,0.70776546,0.79001721,0.88617044,0.99045807,1.0959621,1.1888877,1.2828811,1.3882358,1.4891641,1.585707,1.6904529,1.7962909,1.7535552,1.6897631,1.740254,1.8312155,1.9177514,2.0214791,2.1171083,2.1460103,2.0298945,1.9171682,1.8850643,1.8860644,1.7784774,1.6856325,1.5909927,1.4736551,1.361354,1.247157,1.139507,1.0278883,0.93205458,0.91694988,0.96833806,1.0381593,1.1209867,1.2020312,1.2882116,1.3727942,1.4460998,1.4042179,1.3157519,1.2295994,1.1337014,1.0441991,1.0690372,0.97783131,0.88518867,0.79278005,0.69622838,0.59321699,0.49861895,0.395548,0.30045937,0.19398924,0.091904917,-0.010093198,-0.10246436,-0.20700706,-0.30809569,-0.40475251,-0.49855932,-0.59704133,-0.68253393,-0.73852033,-0.78003603,-0.78262989,-0.7632216,-0.72050633,-0.65281127,-0.55790832,-0.45079856,-0.34464883,-0.24202259,-0.14002416,-0.13526294,-0.088208776,0.025874549,0.11913373,0.21595453,0.31482949,0.42651409,0.52194366:4
2.2061064,2.1752907,2.1261019,2.0856797,2.0437019,1.9868363,1.8988469,1.8082763,1.7223609,1.6347684,1.5655439,1.6082787,1.5875467,1.5058137,1.4644898,1.3960532,1.3219446,1.2770595,1.3275056,1.2420094,1.2002708,1.1110288,1.0249807,0.96161332,0.95793634,0.92341392,0.83671408,0.76837701,0.71156323,0.61858993,0.53430241,0.44798844,0.44560899,0.41343475,0.3161304,0.21194144,0.17125125,0.059352342,-0.010404787,-0.10394503,-0.074948084,-0.051244171,-0.055782687,-0.076067801,0.014140467,0.077688193,0.091961579,0.19971918,0.21905287,0.16814275,0.061061346,0.036544985,0.035670686,0.060146677,0.033020316,-0.03860478,-0.12156151,-0.19158175,-0.25703359,-0.34408922,-0.43450944,-0.51643669,-0.60094489,-0.68487293,-0.76498241,-0.85902043,-0.94782002,-1.0303157,-1.1278876,-1.2361039,-1.3154192,-1.4134544,-1.4997192,-1.595976,-1.6734413,-1.7801411,-1.8766017,-1.9498734,-2.0441527,-2.1408325,-2.2761282,-2.3992399,-2.5134886,-2.5463088,-2.5315059,-2.4890425,-2.4170388,-2.3249063,-2.2662555,-2.2368023,-2.2224183,-2.2192242,-2.2176593,-2.1257676,-2.1061095,-2.0578675,-2.0062166,-1.9158677,-1.8711828,-1.8030051,-1.7479638,-1.6617346,-1.555474,-1.4621122,-1.3964801,-1.3022164,-1.237081,-1.148597,-1.0540175,-1.0300093,-0.94890913,-0.87734283,-0.76879906,-0.68857454,-0.60608938,-0.51631347,-0.4067459,-0.31503123,-0.23691294,-0.14995129,-0.045355722,0.044649747,0.13471278,0.21102532,0.32438204,0.38738118,0.47310127,0.54550126,0.60456194,0.67255834,0.74601697,0.83961176,0.95894237,0.94624362,0.89818569,0.8708404,0.82683996,0.80558284,0.77250244,0.75029647,0.76025476,0.73916914,0.71251546,0.69950507,0.67826032,0.61686251,0.58209349,0.57731712,0.59127135,0.60571734,0.59367248,0.53635423,0.53727919,0.48354651,0.47674049,0.45335646,0.51473904,0.56289354,0.51401785,0.47085656,0.44373484,0.3803633,0.37360347,0.31880428,0.25922733,0.31954361,0.36206524,0.3188665,0.29777912,0.26079216,0.22769021,0.16052173,0.12544377,0.1018571,0.033814047,0.016208823,-0.081336817,-0.092572128,-0.14844921,-0.2230437,-0.26530796,-0.30058251,-0.33742595,-0.42292101,-0.45618816,-0.48872477,-0.59147339,-0.69087125,-0.69021053,-0.79486167,-0.91174207,-0.92654837,-0.80877916,-0.6744246,-0.53940888,-0.40432436,-0.26939765,-0.13413787,0.0011946903,0.13662669,0.28764945,0.42328959,0.55892069,0.67915939,0.80312547,0.93529709,1.0865064,1.1928851,1.3116328,1.4286254,1.5029739,1.4247493,1.4386684,1.5424884,1.6170389,1.6224362,1.6464071,1.5763319,1.5412176,1.5673362,1.5749877,1.5919579,1.6406665,1.6272471,1.567522,1.5377802,1.5336563,1.5237475,1.4931962,1.4334717,1.4047458,1.3064596,1.1797966,1.0950659,0.98470467,0.90955353,0.78279266,0.65185223,0.50425991,0.42592096,0.2893835,0.15303795,0.0077407188,-0.044180591,-0.1472788,-0.28331321,-0.41937094,-0.57070668,-0.70544813,-0.76436211,-0.81062201,-0.94374346,-1.0016731,-0.92891134,-0.85595633,-0.79181195,-0.70726403,-0.63541315,-0.56310404,-0.58927726,-0.50195667,-0.49038033,-0.43773098,-0.39018447,-0.38361582,-0.40289789,-0.31916968,-0.2722437,-0.26122162,-0.23763506,-0.14808659,-0.16117828,-0.12582215,-0.069222689,-0.12563456,-0.21444094,-0.12998607,-0.074738868,-0.090432629,-0.053676447,0.026345776,0.033732596,0.053018256,0.10467404,0.035076463,-0.012331964,-0.093832666,-0.067987953,0.0062160506,0.022061025,0.042937847,0.12667202,0.0997826,0.18546274,0.23123789,0.13331774,0.072813987,0.093005123,0.16731873,0.14122092,0.18442647,0.19314843,0.2385442,0.19823752,0.16828396,0.1848792,0.24383407,0.31284879,0.21647052,0.2859972,0.33502628,0.32790047,0.38645255,0.45828162,0.48309313,0.53432198,0.47684515,0.3751658,0.27631327,0.18023008,0.12017446,0.023623603,-0.06421456,-0.15030645,-0.2198101,-0.33705368,-0.42847405,-0.52606282,-0.58484886,-0.71034451,-0.81439835,-0.9203461,-0.98488573,-1.0841924,-1.1761863,-1.2797667,-1.3505218,-1.427632,-1.4044751,-1.2940488,-1.2525526,-1.1613635,-1.0703416,-1.0477092,-1.0243964,-0.91234122,-0.85527633,-0.77224892,-0.67876423,-0.71990299,-0.72761453,-0.6512061,-0.53825443,-0.511551,-0.44521616,-0.34115634,-0.32860549,-0.25535313,-0.16735561,-0.075144263,-0.067058291,-0.15528372,-0.22683094,-0.33539963,-0.36672851,-0.47710348,-0.52950873,-0.54423926,-0.62809127,-0.66809583,-0.77214879,-0.82866872,-0.92890891,-0.96476279,-1.0216325,-1.1243776,-1.1720894,-1.2313691,-1.1603626,-1.0459897,-0.96414038,-0.875142,-0.78569776,-0.68494028,-0.63166272,-0.54965503,-0.46617681,-0.35983843,-0.33548113,-0.23379996,-0.15755326,-0.11739328,-0.15426775,-0.14308604,-0.08789916,-0.034882012,0.079885471,0.11654571,0.20402637,0.29280866,0.36798901,0.45839599,0.53429013,0.51725461,0.57997899,0.69783598,0.73630558,0.82342238,0.92416236,0.98730998,1.0013374,1.0530402,1.1510407,1.2372443,1.3094992,1.3984842,1.3946926,1.4691463,1.5568799,1.6600073,1.7139676,1.8144547,1.8873146,1.9492799,2.0201988,2.0868646,2.1609808:6
0.42366198,0.37282745,0.30363661,0.27578327,0.19795445,0.12396345,0.063966345,-0.0020430874,-0.042139402,-0.10040594,-0.11519197,-0.17829307,-0.2387011,-0.31231555,-0.38205209,-0.40187408,-0.4699927,-0.51981624,-0.61134301,-0.67786498,-0.7536597,-0.84805271,-0.97313471,-1.0935669,-1.2024037,-1.3193026,-1.3182875,-1.2141018,-1.193782,-1.1032765,-1.0961848,-1.0052383,-0.91219305,-0.81936645,-0.72880432,-0.67916921,-0.62070126,-0.52713624,-0.43244867,-0.3342241,-0.32346868,-0.22660086,-0.13448875,-0.041273842,0.063628875,0.11051092,0.20449374,0.30046113,0.39540687,0.49390293,0.55902434,0.61025531,0.67741402,0.7524363,0.77420873,0.80635383,0.87313355,0.88142372,0.91740738,0.94138138,0.99253945,1.0878409,1.1802063,1.0832256,0.9915161,0.91168016,0.825081,0.92754922,1.0232397,1.1211982,1.2190919,1.3145894,1.3539419,1.2600143,1.1626762,1.0662603,0.96871886,0.86764877,0.77082533,0.72714955,0.69642509,0.68355712,0.67586349,0.66043093,0.64405206,0.65782778,0.62088815,0.59249817,0.59893932,0.62592298,0.66091768,0.68938305,0.69702983,0.6032389,0.50796713,0.44869704,0.34877494,0.25459301,0.15772888,0.061445937,-0.012367722,-0.11307104,-0.20738957,-0.28479302,-0.37996128,-0.472927,-0.54803331,-0.64576077,-0.73523767,-0.83245643,-0.92944066,-1.0235838,-1.1265606,-1.2110045,-1.3075614,-1.4066037,-1.452118,-1.3584847,-1.261419,-1.2036727,-1.1367086,-1.0924781,-1.0514366,-0.99094693,-1.0002486,-0.9495126,-0.90613287,-0.87734853,-0.84534272,-0.79469759,-0.77042423,-0.72679105,-0.69168474,-0.67305259,-0.68238073,-0.65172732,-0.64935477,-0.58469756,-0.55690499,-0.5533198,-0.54187461,-0.47729191,-0.44279918,-0.3717026,-0.33344262,-0.40707788,-0.40452158,-0.33968276,-0.26561565,-0.20908524,-0.20614105,-0.16549598,-0.088497652,-0.032161398,0.038656873,0.10951924,0.20886774,0.31166084,0.41636646,0.50158849,0.56677027,0.46715926,0.3703783,0.27064616,0.17340145,0.082797041,0.029617439,0.023430747,-0.070223237,-0.16159078,-0.20959921,-0.30109074,-0.29664863,-0.38189875,-0.42432132,-0.456094,-0.53695962,-0.59481312,-0.56322668,-0.47256342,-0.36944477,-0.26533505,-0.19231733,-0.09563882,2.2685518E-4,0.11154811,0.13674221,0.1848011,0.29139289,0.39075547,0.48265943,0.55207414,0.64522043,0.75890652,0.80621157,0.78818724,0.85283952,0.97163301,1.0592381,1.1413933,1.1657947,1.2572421,1.3664539,1.4210061,1.4765194,1.5563359,1.6733184,1.783734,1.906192,2.0262173,2.1199674,2.2551713,2.2938758,2.2155735,2.1224631,2.0588025,1.9574562,1.8556925,1.8610283,1.7542369,1.6730628,1.6058125,1.6072317,1.5144975,1.4227301,1.3819242,1.3650232,1.3454175,1.2457465,1.1852611,1.1325523,1.0327783,0.92976135,0.87383986,0.88121725,0.91535687,0.98551754,0.91692701,0.81621587,0.73919565,0.69932003,0.6917256,0.74143479,0.79385138,0.70445728,0.64292892,0.56719734,0.51274882,0.42842495,0.35768478,0.27306122,0.19369982,0.20000136,0.08621528,0.019284675,-0.079927955,-0.17378848,-0.22743311,-0.27202085,-0.37654596,-0.47789219,-0.57898083,-0.63173784,-0.66789969,-0.76327108,-0.73098669,-0.63702144,-0.5657532,-0.46757261,-0.37386024,-0.29988336,-0.19918598,-0.16799304,-0.072571303,-0.013640479,0.048443656,0.15394333,0.21222363,0.2928377,0.37368233,0.43289909,0.49361058,0.59037183,0.64472988,0.72548689,0.82844154,0.9168311,1.0248038,0.95437623,0.86468689,0.76924146,0.70645605,0.6295965,0.57068319,0.47866964,0.49977395,0.43048168,0.36416905,0.27726928,0.27034057,0.21179615,0.14273002,0.05173072,0.046294937,-0.0087724371,-0.10206134,-0.19703488,-0.25535893,-0.36960407,-0.3621714,-0.44905841,-0.54892395,-0.63711643,-0.70324339,-0.82858687,-0.9422509,-1.0428637,-1.1309518,-1.2531135,-1.3557138,-1.473116,-1.5897082,-1.6731928,-1.7758202,-1.8427109,-1.9172876,-1.9774946,-2.0274879,-2.0763717,-2.1328953,-2.2049199,-2.2767463,-2.333722,-2.3830923,-2.4136016,-2.4226829,-2.4056198,-2.3652576,-2.3347627,-2.2535367,-2.2063863,-2.1326374,-2.0436911,-1.9594166,-1.986081,-2.027419,-2.0650782,-2.0724986,-2.0758999,-2.0534708,-2.0428491,-1.9786646,-1.8930552,-1.8165506,-1.7416231,-1.667198,-1.5913419,-1.4887079,-1.4261477,-1.343699,-1.2353125,-1.1600691,-1.0575115,-0.96170441,-0.8896534,-0.7934547,-0.71846517,-0.66450948,-0.56487679,-0.46329714,-0.38762845,-0.31856977,-0.2408436,-0.14691162,-0.051740974,-0.029669605,0.036572147,0.12408806,0.20701057,0.30471489,0.38037225,0.43382915,0.50942521,0.60644445,0.66243347,0.73267906,0.83119085,0.92565167,1.0058157,1.1050693,1.2003688,1.2928783,1.3958512,1.4886216,1.4475705,1.3507964,1.2725489,1.1730829,1.1374318,1.0472233,0.97735316,0.9806198,0.92120821,0.85830306,0.81664104,0.84655226,0.76444726,0.7409316,0.66947167,0.6503124,0.69165983,0.62262143,0.60397614,0.5180038,0.48130934,0.45325785,0.55094983,0.53408018,0.47210207,0.39648018,0.39704527,0.31511059,0.26045881,0.25388629,0.1784335,0.2635078,0.35386268:6
1.094855,0.97195001,0.88413249,0.70092897,0.54451431,0.41938927,0.28673195,0.14299677,-0.046126778,-0.24799456,-0.37488446,-0.44446084,-0.47089105,-0.37763311,-0.30631951,-0.18914071,-0.089956909,0.045138774,0.10007741,0.14875425,0.13547998,0.24530232,0.30446681,0.41661409,0.49427712,0.54312939,0.46729568,0.49203107,0.58728564,0.63064289,0.69870194,0.7890161,0.87221956,0.95897913,0.98398813,1.0919119,1.1715711,1.2104074,1.3427598,1.4528131,1.5443444,1.6607668,1.6808247,1.5406722,1.4070753,1.2639444,1.1119499,0.9593893,0.8103729,0.69990431,0.57707994,0.3950517,0.26811803,0.18961921,0.094062458,-0.052117188,-0.19422449,-0.33711104,-0.37084723,-0.51026183,-0.60089096,-0.48977601,-0.40502026,-0.36767208,-0.28422033,-0.17854676,-0.13438792,-0.092422155,-0.036182086,0.03145644,0.12494559,0.16380528,0.29207495,0.29648748,0.33328545,0.40074434,0.47777371,0.56343878,0.64272922,0.72285709,0.81511851,0.7802622,0.85481719,0.94217254,1.0121291,1.1044095,1.1961863,1.3065034,1.3917223,1.468318,1.275294,1.1520526,1.0384972,0.92721664,0.76592248,0.66745649,0.47860282,0.27414661,0.18356972,0.11226668,-0.073811796,-0.21059869,-0.41123408,-0.58947584,-0.7443999,-0.95052004,-1.1147776,-1.0476944,-0.9519005,-1.0781506,-0.98072353,-0.9001707,-0.85902618,-0.73158669,-0.60786648,-0.46144266,-0.35307107,-0.23902338,-0.10272774,-0.045282359,0.050707939,0.16421767,0.29648439,0.44032419,0.56669592,0.63274455,0.72716073,0.79043138,0.86980434,0.84531658,0.75327004,0.66024117,0.64971122,0.62740224,0.50672059,0.43586182,0.29867201,0.15031114,0.12707682,0.1777449,0.070744943,-0.063000398,-0.19004508,-0.33026256,-0.38740436,-0.51998714,-0.64136578,-0.75158885,-0.88701052,-1.0345423,-1.1848509,-1.10666,-0.99520085,-0.8074243,-0.62791159,-0.47865266,-0.34683399,-0.19537623,-0.044715071,0.079354425,0.20994747,0.34090455,0.42793242,0.56286298,0.6876021,0.80245025,0.97209225,1.1078908,1.2821738,1.4132403,1.5341677,1.4922604,1.3778841,1.2632429,1.1860943,1.1019307,0.9815657,0.85909724,0.78754274,0.72573576,0.64462383,0.55712135,0.4521382,0.48012664,0.5044758,0.43204511,0.30331226,0.21130904,0.1157282,0.02419561,-0.067008015,-0.19205512,-0.28842563,-0.41766837,-0.55232706,-0.63634372,-0.60774359,-0.45752315,-0.31963167,-0.15789611,-0.061371796,0.070902384,0.23466489,0.3806872,0.53268151,0.6654157,0.84498483,0.94690571,1.0856434,1.2385275,1.380215,1.5468286,1.6836054,1.8409142,1.9735671,2.1036787,2.124598,2.1033984,2.0295512,1.9603486,1.8580619,1.7550961,1.6582645,1.5904776,1.4655837,1.4030424,1.3422796,1.1727348,1.0541183,0.92155912,0.90449462,0.7857644,0.6928516,0.60722954,0.52827911,0.42711923,0.28980878,0.21510811,0.21657574,0.12516351,0.0071675105,-0.13137702,-0.21658817,-0.33999973,-0.48370733,-0.60400355,-0.7381293,-0.76158453,-0.59176194,-0.43205343,-0.27982635,-0.079479707,0.076645195,0.2645052,0.43575636,0.54879931,0.46021416,0.37171375,0.27222976,0.20177829,0.11802811,0.028787934,-0.029257786,0.032487249,-0.039762344,-0.086938094,-0.081980878,-0.12644622,-0.20293828,-0.26995948,-0.34183929,-0.43482504,-0.50981033,-0.60083715,-0.69375198,-0.63045769,-0.45773562,-0.29364479,-0.3868202,-0.44097411,-0.50044596,-0.57011893,-0.6419364,-0.69232114,-0.74852305,-0.79129694,-0.83346414,-0.89228902,-0.96039884,-1.0314671,-1.1357225,-1.2179784,-1.3494349,-1.4705332,-1.6434459,-1.7748229,-1.9102461,-2.0724819,-2.1972321,-2.3042288,-2.4058298,-2.5228029,-2.4996774,-2.395408,-2.255688,-2.0976505,-1.9594351,-1.7855145,-1.6253387,-1.4777301,-1.3095297,-1.1411425,-1.007413,-0.81722081,-0.67122739,-0.52375064,-0.36956483,-0.19777175,-0.031801845,0.12406681,0.29961771,0.46989562,0.63576635,0.79289167,0.95823084,1.0990807,1.1737391,1.1434784,1.1756722,1.2530953,1.1803282,1.0855059,1.0902395,0.93727066,0.79089011,0.62575635,0.48767791,0.33163516,0.15705993,0.0073886944,-0.12813789,-0.31179527,-0.46736335,-0.59548269,-0.76792428,-0.93758663,-1.0774016,-1.2520856,-1.4092699,-1.4219914,-1.5077679,-1.6083021,-1.7554852,-1.9425601,-2.0849166,-2.2305453,-2.4107231,-2.4903865,-2.6221506,-2.7981963,-2.8337474,-2.8584388,-2.8886469,-2.818732,-2.6640574,-2.5065431,-2.3604138,-2.2120362,-2.0550728,-1.8963761,-1.7375949,-1.5578393,-1.3941992,-1.2446466,-1.0730693,-0.96370296,-0.79955227,-0.68687609,-0.52833087,-0.41043741,-0.29879612,-0.22663594,-0.14116256,-0.056384319,-0.021335521,0.024634111,0.096079786,0.15254237,0.14824978,0.20623693,0.25761598,0.30963836,0.3603623,0.41405103,0.3163753,0.17899223,0.028129499,-0.1339325,-0.27909039,-0.40355723,-0.51774314,-0.54765387,-0.45281459,-0.35488968,-0.27803697,-0.20358878,-0.11240441,-0.026830132,0.051420307,0.12786841,0.18789701,0.27579395,0.35203607,0.37562199,0.38230229,0.46043066,0.53583248,0.63002822,0.66206346,0.70322102,0.71480727,0.73966195,0.86390601,0.88901766,0.96469354,0.99811762,1.0937644:1
1.9090158,1.9143424,1.8946607,1.8787108,1.8457454,1.8282468,1.7679347,1.7126904,1.6427192,1.5795847,1.5280602,1.462205,1.4092244,1.3862727,1.3791613,1.3195101,1.2488782,1.174315,1.0970001,1.0262625,0.97149276,0.88800186,0.82588847,0.74726922,0.67583362,0.61168795,0.54226141,0.4748535,0.40156637,0.33961885,0.26147208,0.20208479,0.11488783,0.033289797,-0.030749963,-0.052669878,-0.12644075,-0.16859905,-0.22681462,-0.2478739,-0.24233235,-0.28756033,-0.28333734,-0.31745263,-0.34130467,-0.36766059,-0.43774106,-0.459155,-0.4969109,-0.52166577,-0.55535946,-0.56103374,-0.58705977,-0.57146813,-0.57054105,-0.5767617,-0.57453737,-0.58322296,-0.5953121,-0.60484335,-0.62038996,-0.64704205,-0.6780262,-0.68320658,-0.69328694,-0.6974228,-0.70856031,-0.71248983,-0.69755893,-0.69172354,-0.6730377,-0.66107709,-0.65458503,-0.64928966,-0.66121514,-0.64013335,-0.63632455,-0.63217897,-0.64330048,-0.64209121,-0.6460871,-0.65515648,-0.66500194,-0.68270122,-0.69549436,-0.71417689,-0.73667911,-0.76025457,-0.78198509,-0.80135608,-0.83313898,-0.86741146,-0.90488817,-0.93844562,-0.99293305,-1.0382827,-1.0895728,-1.1424248,-1.1818141,-1.241531,-1.276032,-1.3244043,-1.3895806,-1.4544193,-1.4911115,-1.5726029,-1.6455613,-1.678871,-1.7469991,-1.7701465,-1.7819126,-1.7140543,-1.6748317,-1.6278305,-1.5869856,-1.5370568,-1.4864867,-1.4385733,-1.3947494,-1.3525364,-1.3258406,-1.2811692,-1.2646913,-1.2408785,-1.2238709,-1.2132552,-1.1737812,-1.1417936,-1.1110041,-1.0549886,-1.0109058,-0.96302246,-0.90708244,-0.86434676,-0.82104529,-0.7768629,-0.71412064,-0.65783876,-0.61463287,-0.56342081,-0.49596846,-0.46822038,-0.40415064,-0.36418956,-0.32871513,-0.28293688,-0.21867767,-0.16597038,-0.071396408,0.0040881286,0.074013625,0.16601876,0.24004056,0.32945322,0.39896742,0.46441315,0.52185224,0.58343197,0.6177114,0.69824462,0.75982963,0.849863,0.9212213,1.0209877,1.089392,1.1904686,1.2584622,1.3572423,1.4532443,1.5473513,1.6395857,1.7299696,1.7939815,1.8701273,1.9271544,1.9730417,2.0326097,2.0908937,2.1137163,2.1516715,2.1632429,2.1708306,2.1500025,2.1986498,2.2082341,2.198669,2.1762665,2.1577785,2.1543879,2.1136063,2.1093201,2.0445618,2.0074754,1.9694265,1.9130933,1.8655873,1.8180318,1.7659086,1.7014587,1.6551044,1.591078,1.5511629,1.5063667,1.4629261,1.4116938,1.3650205,1.3233331,1.2821624,1.2695486,1.2525707,1.2168684,1.1907763,1.2076099,1.1382541,1.0990587,1.0539835,1.0071709,0.95619338,0.91076386,0.86535141,0.8093236,0.75549207,0.7193868,0.68858318,0.63452242,0.5765621,0.51865714,0.46708412,0.40908345,0.33518999,0.27331175,0.18092626,0.11328242,0.029959207,-0.043594914,-0.12219731,-0.21115901,-0.26976313,-0.32722507,-0.38858904,-0.43830883,-0.52250144,-0.57619931,-0.65054223,-0.69913881,-0.66883989,-0.66890577,-0.63600242,-0.61467903,-0.57418165,-0.51266464,-0.45795118,-0.40585564,-0.3530495,-0.32366686,-0.29580985,-0.25892476,-0.22668703,-0.19355026,-0.19228432,-0.16917771,-0.15581561,-0.13885665,-0.14898476,-0.11368544,-0.13583039,-0.11827833,-0.10400727,-0.094727279,-0.0990659,-0.099807801,-0.099882011,-0.10397841,-0.10705755,-0.11152154,-0.11626351,-0.12208472,-0.12676527,-0.14826658,-0.16672398,-0.20342489,-0.25301305,-0.28467297,-0.32377087,-0.3558699,-0.39433323,-0.42854869,-0.47893877,-0.51998342,-0.56280191,-0.60318638,-0.64955251,-0.69200019,-0.7358296,-0.79308111,-0.83586685,-0.88803808,-0.92752988,-0.98936492,-1.0251436,-1.0736332,-1.1154157,-1.1657232,-1.2074107,-1.2655105,-1.3136793,-1.3671132,-1.4304458,-1.472519,-1.5256865,-1.5448561,-1.5942882,-1.6364283,-1.5917601,-1.5517891,-1.4952768,-1.427924,-1.3634079,-1.2911518,-1.2278959,-1.1575583,-1.0860288,-1.0235926,-0.95269586,-0.88191373,-0.87437485,-0.80114974,-0.72754032,-0.66625531,-0.60521905,-0.5454442,-0.49566139,-0.44367561,-0.4025938,-0.36815212,-0.34459953,-0.33167025,-0.31923694,-0.31205511,-0.31523349,-0.32285775,-0.32828534,-0.34344455,-0.35443689,-0.36465717,-0.36496515,-0.37876104,-0.39118112,-0.39556867,-0.40313244,-0.41269518,-0.3912796,-0.37621067,-0.35649409,-0.33624327,-0.32943276,-0.30575271,-0.28965296,-0.25174711,-0.23766531,-0.22957376,-0.20297783,-0.18468629,-0.16480873,-0.14781374,-0.13898246,-0.11679409,-0.093520713,-0.082260181,-0.064523232,-0.053350257,-0.048796349,-0.045625365,-0.043001654,-0.031094164,-0.011778728,0.007985946,-0.03232342,-0.035194972,-0.029523414,0.0099503926,-0.033342221,-0.0070003327,-0.0089397162,-0.034742415,-0.044612054,-0.051989966,-0.078012363,-0.12083659,-0.17199736,-0.20624589,-0.24430786,-0.28893608,-0.30887325,-0.29470233,-0.24045105,-0.19727664,-0.12502795,-0.053090102,0.012559188,0.073635675,0.13479361,0.2072428,0.28001434,0.34605146,0.41341503,0.47606139,0.54452957,0.61744852,0.68992635,0.75857235,0.82718047,0.89614957,0.96414801,1.0298672,1.1067219,1.1808916,1.2556852,1.3317474,1.4230249,1.4949811,1.5655849,1.6648891,1.7352757,1.8115992,1.8798826,1.9077469:2
1.8444954,1.7790485,1.6734002,1.5817754,1.5057673,1.4275496,1.3164958,1.2470148,1.2177339,1.1142711,1.0098056,0.9003323,0.79557597,0.69109019,0.76429264,0.72400966,0.64887791,0.56668058,0.47105301,0.37915039,0.3157094,0.22345911,0.14819401,0.064527886,0.03815007,-0.04547522,0.015191433,0.0054579908,0.080639136,0.19268827,0.24419709,0.21289803,0.16992428,0.15666001,0.11847886,0.037586727,-0.012490544,-0.086865439,-0.16465078,-0.23564957,-0.30055363,-0.34935515,-0.37062954,-0.27544412,-0.27864689,-0.32425332,-0.40886821,-0.48662004,-0.54885997,-0.63730802,-0.71732858,-0.78439923,-0.84276323,-0.91675569,-0.8858117,-0.77355688,-0.6574006,-0.54824001,-0.43184516,-0.33275397,-0.23515701,-0.13342704,-0.0065328715,0.035075079,-0.014177766,-0.081278986,-0.14111558,-0.15914296,-0.19762454,-0.28403925,-0.36447011,-0.43864541,-0.46323425,-0.44230692,-0.46936695,-0.54178502,-0.64827866,-0.69371954,-0.7807876,-0.86255426,-0.92842527,-0.97293377,-0.99982247,-1.0433371,-1.0921397,-1.1434051,-1.190501,-1.2582799,-1.3161421,-1.3863583,-1.4349944,-1.4896512,-1.5322591,-1.5589153,-1.5769416,-1.5908935,-1.5899064,-1.5066165,-1.3881222,-1.2904953,-1.1734582,-1.0709051,-0.9515377,-0.84222299,-0.73857401,-0.63536093,-0.53615671,-0.43531631,-0.34312276,-0.23916781,-0.15161058,-0.042663506,0.055586179,0.14744184,0.25010076,0.3466422,0.45366801,0.55528631,0.66055124,0.75586215,0.86813142,0.9705698,1.0719668,1.185177,1.2997836,1.4111304,1.5058572,1.5907479,1.7053788,1.8068636,1.9229696,2.0418125,2.1614197,2.2661722,2.3847048,2.5017082,2.6185938,2.746579,2.864298,2.9786142,3.0281317,2.9328787,2.8094299,2.697655,2.5743704,2.4507523,2.3266625,2.2119656,2.1036072,1.9794541,1.8587924,1.7382244,1.6258122,1.5133912,1.4032865,1.2854933,1.1682546,1.0540328,0.95982186,0.83929996,0.72538748,0.62466138,0.51099132,0.40919035,0.29694019,0.20133633,0.090414273,-0.012517939,-0.10670003,-0.21825449,-0.32305481,-0.41998628,-0.52412487,-0.61538913,-0.72536358,-0.82604346,-0.93560342,-1.0518597,-1.1510301,-1.1730573,-1.2652405,-1.2782671,-1.3570025,-1.4183577,-1.4476503,-1.5151685,-1.5337623,-1.5617031,-1.5288712,-1.553698,-1.5541613,-1.5196218,-1.470501,-1.4289432,-1.3518478,-1.2958649,-1.2694139,-1.2368053,-1.2043696,-1.1786355,-1.1531415,-1.1213148,-1.0938017,-1.0803549,-1.0241625,-0.94826119,-0.89490803,-0.86255437,-0.76901912,-0.6826171,-0.59286844,-0.56527732,-0.50238,-0.56467683,-0.6278847,-0.58136332,-0.50719175,-0.46177383,-0.43185389,-0.36444877,-0.4164806,-0.36582972,-0.33898063,-0.28263132,-0.25714447,-0.24097083,-0.34281445,-0.47072395,-0.57196373,-0.70225277,-0.84346536,-0.99162844,-1.1264226,-1.1441186,-1.1412236,-1.0921849,-1.0639407,-0.98511894,-0.91567332,-0.84302631,-0.8865936,-0.8218163,-0.76618539,-0.79644843,-0.73441163,-0.64812075,-0.6164728,-0.66424713,-0.71904798,-0.63002528,-0.52846542,-0.42757652,-0.32301843,-0.28373071,-0.28402317,-0.20593939,-0.17323772,-0.085250223,-0.032176633,-0.11636959,-0.22734311,-0.31368821,-0.22959055,-0.14618327,-0.057525166,-0.01008816,-0.02267046,0.041355412,0.12978327,0.20799707,0.29877173,0.37720722,0.33561927,0.39062608,0.51190002,0.65402719,0.72216085,0.84138972,0.9547885,1.0644396,1.2057118,1.3384256,1.4260951,1.3292841,1.2299233,1.1318296,1.0162887,0.91592914,0.79563163,0.69030726,0.5776634,0.46809719,0.44515666,0.40931882,0.28418132,0.16780406,0.060177371,-0.049917132,-0.1587154,-0.27535285,-0.3744996,-0.33588265,-0.37559582,-0.47601596,-0.59170518,-0.70642363,-0.81969404,-0.9420581,-1.0581507,-1.1737023,-1.2791794,-1.3888345,-1.4927718,-1.5887218,-1.6088964,-1.5159583,-1.4400282,-1.3621193,-1.2724512,-1.1784639,-1.0926205,-0.98276001,-0.87242932,-0.7764586,-0.82737882,-0.78459144,-0.67255966,-0.55907745,-0.4316333,-0.30715962,-0.2168776,-0.24581741,-0.14763257,-0.04080904,-0.0084476089,0.071181846,0.15092726,0.16272578,0.081996694,-0.011457934,-0.075084498,-0.12710212,-0.12291294,-0.029514233,0.074332273,0.13504463,0.22143653,0.32903675,0.44040585,0.49681061,0.50783597,0.52757348,0.65092878,0.7506572,0.88819791,0.98967648,1.1042221,1.2148722,1.3230799,1.4378056,1.4094895,1.2717178,1.1635772,1.0587971,0.9883996,0.86839321,0.77561849,0.64631777,0.70910487,0.72975291,0.63460502,0.51106163,0.40333824,0.34448642,0.28440974,0.17741305,0.082133695,0.12525646,0.17693999,0.28980136,0.41181916,0.40104262,0.3094571,0.21281729,0.15411959,0.050604408,0.0050386995,-0.035554736,-0.030474806,-0.11355438,-0.21850111,-0.29150897,-0.39622443,-0.49348566,-0.44819397,-0.49896134,-0.55077122,-0.65326515,-0.75655155,-0.85743916,-0.94033319,-1.0414632,-1.0210897,-0.86348297,-0.70866928,-0.55525167,-0.46317666,-0.32726132,-0.19016249,-0.045789035,0.089142971,0.14896341,0.24285239,0.38042707,0.53757358,0.64866469,0.78823418,0.91494287,0.96258694,1.080387,1.2116227,1.3467139,1.4646107,1.5984756,1.7164621,1.8329698,1.8867078:3
1.3656687,1.2040941,1.2678918,1.0855269,0.95686203,0.87407,0.72948174,0.63598847,0.58865869,0.47605887,0.3607388,0.27456137,0.089037269,0.20697246,0.21393694,0.18492319,0.15051026,-0.026545963,-0.061209716,-0.25449418,-0.36101655,-0.36587132,-0.41587218,-0.5093215,-0.63939908,-0.71228576,-0.80495832,-0.96417682,-1.0561579,-1.2869714,-1.3844199,-1.5372072,-1.6300199,-1.4396506,-1.222815,-1.001531,-0.75800915,-0.55293111,-0.50897031,-0.37504418,-0.14399295,0.019134059,0.21315418,0.43976769,0.67446436,0.89435492,0.9719868,1.0766627,0.94445083,0.87813825,0.71559877,0.56368937,0.45565697,0.31597165,0.26378263,0.31506487,0.23615661,0.22768679,0.15633251,0.15823536,0.018094321,-0.11908442,-0.17732698,-0.33760738,-0.43326635,-0.54987749,-0.68730146,-0.82846316,-0.78437829,-0.95166548,-1.047747,-0.83976634,-0.65886789,-0.40406275,-0.15591067,-0.062172917,0.1976499,0.36659881,0.52272609,0.71388844,0.67873962,0.74395124,0.65267089,0.59991675,0.5142755,0.4567193,0.35100974,0.3301726,0.32583606,0.30203018,0.25457159,0.19114371,0.11738095,0.1158128,0.11333836,0.098708104,0.16779642,0.17853689,0.20296242,0.16370404,0.10284574,0.10681107,-0.01292318,-0.035524377,-0.1439257,-0.18784273,-0.31369831,-0.52253286,-0.43443508,-0.40433095,-0.28616321,-0.20692203,-0.12209992,-0.0049562967,0.20195167,0.41211515,0.39980056,0.66793501,0.90033025,1.1511352,1.3671555,1.6416201,1.8387882,2.1039442,2.3351702,2.5256752,2.7476002,2.9243506,3.0487869,3.1457136,3.1339274,2.9565863,2.7248049,2.465034,2.2945327,2.0682021,1.8399109,1.6082373,1.3854503,1.2121311,1.1260673,1.0384991,0.87441406,0.66050529,0.40730454,0.17945888,-0.081194644,-0.25038623,-0.34987718,-0.61431163,-0.87688211,-1.0861285,-1.2231106,-1.3850959,-1.6274101,-1.7750287,-2.0002483,-2.2352296,-2.3744861,-2.512867,-2.6443767,-2.4994348,-2.3067089,-2.123197,-1.903536,-1.6796866,-1.445563,-1.2065923,-0.96318609,-0.85621114,-0.65959872,-0.55286724,-0.49919949,-0.42518235,-0.33315152,-0.19442513,-0.026582434,0.14068114,0.18686497,0.33709014,0.40376059,0.47295496,0.60823335,0.67908098,0.80400133,0.81474516,0.87362845,0.93797791,0.9360608,0.94910317,0.83279451,0.71620116,0.53527941,0.28555973,0.061735947,-0.1564865,-0.23414337,-0.17501211,0.013983808,0.11696997,0.23472935,0.17097529,0.28905351,0.22808996,0.38941005,0.37487424,0.48266698,0.38087684,0.28015277,0.28436536,0.37999509,0.48791575,0.50200649,0.53747541,0.57083353,0.70774117,0.74884228,0.87543155,0.87427748,0.8574627,0.79141972,0.59111755,0.34862178,0.12024879,-0.13875452,-0.19808012,-0.44315312,-0.67391736,-0.99021234,-1.2014402,-1.1594161,-1.0761631,-0.9515778,-0.80466278,-0.65999112,-0.64756056,-0.54127311,-0.46262437,-0.42809278,-0.26152734,-0.077250501,-0.13295944,-0.16676376,0.050667046,0.1739287,0.30340893,0.44095901,0.48722673,0.50562971,0.60465326,0.79858012,0.81754243,0.95664515,1.1350121,1.2083681,1.3732466,1.4999497,1.5678785,1.6202133,1.4618036,1.197248,0.98754694,0.84382301,0.67999843,0.48732661,0.27284692,0.070010377,-0.16319147,-0.35972716,-0.5943229,-0.72345875,-0.78972854,-0.77242451,-0.59073858,-0.64566898,-0.48079413,-0.31150767,-0.32929644,-0.22255843,-0.26818744,-0.23526116,-0.15554905,0.0032353739,0.17287723,0.31328235,0.47216354,0.37503763,0.35878052,0.55632947,0.52883573,0.70053968,0.62235273,0.73253829,0.90518338,1.0168403,1.1494216,1.3170901,1.3881674,1.112776,0.88216904,0.63127353,0.48309483,0.30637117,0.18254793,-0.0075993712,0.051391701,-0.19095819,-0.25632816,-0.4725762,-0.72988418,-0.92785058,-1.1422524,-1.348017,-1.3722526,-1.6543731,-1.7981417,-1.9797233,-1.836933,-1.6737067,-1.5908898,-1.5037907,-1.3243219,-1.1417746,-0.97540259,-0.83199123,-0.78516981,-0.71193691,-0.52205832,-0.33443627,-0.14582384,0.0099350016,0.015538401,0.10718113,0.28599536,0.5107947,0.53681126,0.71588609,0.88909067,1.1058812,1.2836323,1.208724,1.0417886,0.86548648,0.68971454,0.67188176,0.48801938,0.26980802,0.12662058,0.0026457683,-0.24001027,-0.47383072,-0.60279985,-0.59790067,-0.75776499,-0.88178195,-1.0326837,-1.2439602,-1.2137177,-1.4276347,-1.5990185,-1.6307674,-1.838164,-2.0685613,-2.1838731,-1.9380494,-1.7259151,-1.4688424,-1.2287878,-1.0213477,-0.78593452,-0.58291173,-0.66325575,-0.42659226,-0.1952935,0.082336093,0.24544992,0.38218739,0.56915125,0.77530275,1.0169335,1.2795306,1.2358027,1.1205842,0.96240221,0.88636944,0.68724852,0.52802656,0.66992121,0.50567667,0.35310345,0.23554427,0.069602623,0.23118677,0.18529085,0.04203503,-0.11651447,-0.25146882,-0.42427356,-0.61162567,-0.57667147,-0.65025664,-0.64446828,-0.76021492,-0.93138428,-1.0285429,-1.131319,-1.3418368,-1.4891812,-1.6075754,-1.8291296,-2.0394371,-2.1064824,-2.0157494,-1.7593666,-1.5026733,-1.2380312,-0.98813473,-0.70512122,-0.47176336,-0.2385368,-0.20460843,0.054971551,0.37628739,0.57649581,0.89432526,1.0893328,1.3499791:1
1.0728035,0.95699344,0.84531671,0.76208758,0.65201042,0.51771212,0.45176081,0.3883158,0.32491486,0.21418104,0.086110168,-0.01228637,-0.14202904,-0.2834821,-0.40487851,-0.5406649,-0.64372395,-0.76902267,-0.86112691,-0.96177111,-1.0841433,-1.1334075,-1.1559217,-1.1675212,-1.1301583,-1.0087406,-0.876171,-0.74485159,-0.59903435,-0.45841094,-0.32694268,-0.18795804,-0.061463789,0.057370257,0.18106199,0.29987601,0.41743142,0.53913064,0.65942043,0.77730001,0.89553224,1.0214306,1.137607,1.0882301,0.94150416,0.79782932,0.67169881,0.6028244,0.49593248,0.35802298,0.27843007,0.22867572,0.18404481,0.14893738,0.030975697,-0.072225565,-0.16382012,-0.22551154,-0.22206692,-0.20769419,-0.17099077,-0.14409067,-0.14778757,-0.24800447,-0.36739693,-0.47531966,-0.59752074,-0.68991616,-0.78711393,-0.88281585,-0.97931156,-1.0963963,-1.1735781,-1.2473001,-1.2290478,-1.2338098,-1.2324236,-1.2848964,-1.3445009,-1.4109968,-1.4749478,-1.5682147,-1.6845586,-1.6865134,-1.6461259,-1.547155,-1.4485317,-1.3267285,-1.2254149,-1.0993137,-1.0177433,-0.8982222,-0.76123662,-0.64151279,-0.51347303,-0.42581292,-0.30080596,-0.16662278,-0.077718975,0.057118099,0.188811,0.33329892,0.45652814,0.54662066,0.65782062,0.769598,0.93082856,1.0405326,1.1912223,1.3476704,1.5126885,1.6711417,1.8273915,1.9467446,2.0408438,2.1772867,2.2833682,2.4473162,2.5328834,2.5518186,2.4297852,2.3359956,2.2489618,2.115321,1.9733946,1.9054021,1.8060513,1.7147403,1.5729534,1.4176427,1.2666449,1.1712785,1.0183838,0.88856495,0.7651064,0.69755785,0.55586951,0.4101006,0.30789326,0.20632039,0.10956267,-0.012930459,-0.14659315,-0.24573594,-0.35646257,-0.43415596,-0.55092085,-0.65977458,-0.78354058,-0.91708978,-1.0410929,-1.1359343,-1.2183941,-1.3374555,-1.4500235,-1.4263639,-1.3378392,-1.2384705,-1.1494752,-1.0642149,-0.96291061,-0.90524919,-0.84247088,-0.80847598,-0.82107262,-0.82335095,-0.82654226,-0.70354604,-0.58576643,-0.53269797,-0.47833,-0.40889257,-0.28679237,-0.16761452,-0.069179755,-0.013044199,0.03233065,0.10346961,0.2342213,0.33525949,0.44591941,0.52133162,0.59424441,0.71158445,0.84474722,0.9370015,0.85166849,0.72995141,0.60182209,0.49202685,0.36634231,0.23893176,0.10990717,-0.016365269,-0.13306717,-0.25384339,-0.38628248,-0.52181637,-0.66145638,-0.80556276,-0.94856608,-1.0817845,-1.1931228,-1.2259208,-1.2088363,-1.1695143,-1.0733997,-0.94444525,-0.86973964,-0.73324006,-0.58532846,-0.47858942,-0.38788159,-0.26077937,-0.11680343,-0.0090956343,0.079451542,0.1812442,0.28607996,0.3923866,0.48812961,0.56931676,0.67073609,0.76723014,0.86531391,0.95294502,1.0480222,0.9814996,0.84092067,0.73858772,0.63328816,0.47665989,0.35468259,0.3230432,0.41722857,0.50349063,0.57238134,0.65858172,0.74795043,0.84834255,0.95393943,0.90790471,0.95651826,0.99688569,1.0808177,1.1437417,1.2120901,1.248941,1.2990914,1.1742166,1.0320235,0.89208007,0.79971224,0.67756343,0.54259212,0.41522107,0.2824247,0.1902584,0.19284524,0.21586211,0.22394949,0.095531886,-0.028705846,-0.1517165,-0.27827265,-0.4043584,-0.53080229,-0.65609068,-0.75245583,-0.8767735,-0.99289486,-1.0653441,-1.1754323,-1.2338203,-1.3604634,-1.4861361,-1.6120446,-1.6939254,-1.7806041,-1.867267,-1.9457046,-1.966482,-1.8840629,-1.7728874,-1.6430218,-1.5423655,-1.4031271,-1.2670382,-1.1291768,-1.0154014,-0.91333876,-0.78044393,-0.64465673,-0.55509869,-0.42660267,-0.35070512,-0.20740331,-0.05599793,0.070881981,0.22627897,0.35513193,0.47026675,0.60522253,0.7136342,0.62995268,0.53522383,0.4326053,0.33651041,0.31664505,0.39756317,0.51068164,0.63575492,0.73053967,0.81124577,0.89897135,0.94473526,0.99500412,1.0768641,1.1828812,1.2703289,1.3608538,1.4505232,1.5441642,1.633516,1.5175256,1.3742309,1.2931553,1.1954657,1.0948009,1.0330043,1.043297,0.97638568,0.85125725,0.78486025,0.62805043,0.45409681,0.31278552,0.30718009,0.36611309,0.4591231,0.55488471,0.64830467,0.60072132,0.44300575,0.30236635,0.17060356,0.045703394,-0.08648241,-0.21628218,-0.35941966,-0.49143248,-0.59888638,-0.71669301,-0.84726602,-0.97290197,-1.0951845,-1.1877231,-1.2930544,-1.4114715,-1.4665228,-1.5991425,-1.6357579,-1.7176298,-1.7610102,-1.8567226,-1.9510332,-2.022828,-2.0280619,-1.9248538,-1.8035372,-1.6937786,-1.6490518,-1.6362041,-1.6020996,-1.5297288,-1.4750184,-1.4274557,-1.3692178,-1.2419783,-1.1165444,-1.0408076,-0.93252026,-0.85722373,-0.74579308,-0.63495731,-0.50061671,-0.40905106,-0.28809154,-0.22906405,-0.10226173,-0.010864283,0.11400781,0.24094863,0.36809379,0.47289508,0.43688596,0.39519298,0.41587431,0.54490456,0.67531391,0.80857306,0.94316377,1.0692853,1.2083603,1.3524492,1.4856573,1.5991472,1.4848811,1.3712525,1.2936218,1.2005883,1.1258888,1.0888781,1.0215572,0.91535061,0.81890462,0.73017024,0.62337434,0.56019212,0.51409541,0.50327764,0.58147594,0.6790066,0.77603806,0.8716432,0.96273121,1.0499903:5
1.6350296,1.5886319,1.4430359,1.2974758,1.2210343,1.0888543,0.96881937,0.95785636,0.82821517,0.69692056,0.61537389,0.53830694,0.61017405,0.63928047,0.5844043,0.50058782,0.37430341,0.24056211,0.12234864,0.041573597,-0.087515159,-0.1989733,-0.31074343,-0.42550398,-0.53687657,-0.63849564,-0.74374846,-0.85645096,-0.96802775,-1.0680938,-1.1774783,-1.2956363,-1.4030527,-1.5063828,-1.5970037,-1.6707038,-1.7203852,-1.8202826,-1.8719295,-1.8718198,-1.9318202,-1.9144098,-1.8019369,-1.6864165,-1.5660368,-1.4329876,-1.3085345,-1.2229945,-1.1126715,-0.99519342,-0.92651168,-0.81372041,-0.68834596,-0.57113139,-0.51662339,-0.40782224,-0.30066802,-0.18370026,-0.077435749,0.062279912,0.19611479,0.31667712,0.41798689,0.3757299,0.36626977,0.48139953,0.58428286,0.67676393,0.76890446,0.88287753,0.97454439,1.003236,1.0695141,1.1884051,1.2859017,1.3692714,1.4770998,1.5174643,1.4354391,1.3134088,1.2049689,1.1245283,1.0624887,0.97969115,0.89498413,0.82161037,0.73727354,0.68335507,0.64788228,0.58016655,0.58762816,0.6431977,0.62553864,0.5642395,0.48465739,0.41818157,0.35207637,0.28917757,0.18444227,0.060886178,-0.020603986,-0.077061943,-0.078072586,-0.12518602,-0.20270557,-0.30760685,-0.40919276,-0.53014463,-0.62733303,-0.60609542,-0.66880303,-0.78707223,-0.87847674,-0.90592863,-0.94456724,-0.98438252,-0.99043756,-1.0293592,-1.0451481,-1.0337738,-0.95219299,-0.93261572,-0.84711797,-0.72847911,-0.66569957,-0.61324015,-0.52491971,-0.47377215,-0.37248654,-0.2711438,-0.20796655,-0.14754092,-0.066632407,0.042739221,0.13222329,0.24147614,0.33613714,0.26727327,0.17339356,0.086704755,0.051915716,-0.010632565,-0.091398765,-0.18468937,-0.23821916,-0.24767552,-0.34069688,-0.38562293,-0.47089064,-0.54412055,-0.56439437,-0.52397372,-0.44856301,-0.5137249,-0.60139872,-0.68974038,-0.78872548,-0.88046334,-0.98464649,-1.0774821,-1.177966,-1.2698643,-1.3495854,-1.3995817,-1.3399523,-1.2439758,-1.2790857,-1.1991139,-1.0520644,-0.91719235,-0.794901,-0.64124946,-0.501558,-0.35052454,-0.21353937,-0.05987448,0.077347672,0.21468734,0.35194148,0.48922179,0.62690344,0.76437962,0.88570935,1.0234936,1.1451639,1.2665792,1.4048851,1.5265365,1.6485712,1.7855326,1.9089184,2.0471793,2.1845833,2.3370578,2.4419362,2.5196424,2.5100601,2.4569379,2.372904,2.2535465,2.1169844,1.9634413,1.8262307,1.6884481,1.551793,1.4144105,1.2772303,1.1400651,1.0029709,0.88265638,0.74573308,0.60891923,0.47221553,0.3512348,0.19902315,0.062497746,-0.074036813,-0.2272841,-0.36375356,-0.51700438,-0.67020619,-0.80650762,-0.95958605,-1.0962076,-1.248039,-1.3831435,-1.5182347,-1.6408425,-1.7472534,-1.8769686,-1.7988878,-1.7358446,-1.6389917,-1.599411,-1.5328846,-1.4507682,-1.397651,-1.3017635,-1.2720905,-1.2189755,-1.1717987,-1.086188,-0.97747226,-0.8904609,-0.79489648,-0.69398101,-0.58916135,-0.57935756,-0.61956831,-0.62357897,-0.58710614,-0.51312219,-0.42133221,-0.31205554,-0.2453993,-0.1643149,-0.087302287,0.0014402614,0.10605119,0.21644225,0.31705721,0.41514352,0.38076659,0.2721629,0.16977782,0.068016964,-0.031356492,-0.1275713,-0.21075732,-0.3117758,-0.41984369,-0.49543517,-0.61088466,-0.7161557,-0.82211218,-0.87526354,-0.95894721,-1.0548112,-1.1449469,-1.2120275,-1.1790255,-1.1265658,-1.055001,-0.94674537,-0.84971764,-0.75358959,-0.68695296,-0.57115102,-0.46433619,-0.3624696,-0.27774977,-0.1757936,-0.12377944,-0.029222002,0.0070645786,0.11720896,0.21975285,0.28980343,0.35894205,0.43644975,0.54292118,0.62853221,0.71284539,0.80470589,0.91423606,1.0079334,1.1173161,1.1529883,1.0586438,0.94684254,0.83469826,0.74166779,0.6398429,0.56743149,0.49911816,0.48779563,0.54977695,0.63314666,0.71818048,0.8074229,0.89715823,0.9903304,1.0743006,1.1046859,1.091515,1.1152583,1.2062105,1.2992878,1.3918924,1.4822068,1.5765186,1.6854628,1.7848622,1.7390849,1.6174554,1.4996193,1.3770449,1.2653794,1.1519163,1.092147,0.9940004,0.88247856,0.79416455,0.71023496,0.60344632,0.51617938,0.49944929,0.51908527,0.48964344,0.38021834,0.27678023,0.16845208,0.063972554,-0.045403819,-0.15036742,-0.26096503,-0.38049947,-0.49264341,-0.54768836,-0.612265,-0.71715736,-0.82524635,-0.92098685,-1.0307259,-1.1343146,-1.2479798,-1.3519681,-1.4692486,-1.5794116,-1.6894358,-1.7932928,-1.9069836,-1.85691,-1.793487,-1.689232,-1.5574113,-1.4396461,-1.3140636,-1.1789282,-1.0387002,-0.90669793,-0.93306135,-0.97250316,-0.91322423,-0.79588515,-0.68211649,-0.59283825,-0.49555853,-0.40010436,-0.32482459,-0.20805921,-0.069403713,0.053004938,0.16162662,0.17304292,0.12045735,0.068712067,0.16447557,0.29630689,0.43579808,0.57374487,0.70112946,0.81351807,0.83336334,0.75125705,0.68027211,0.61554542,0.54043032,0.47149444,0.4046686,0.43680693,0.51641618,0.59518691,0.68617231,0.76119403,0.87206784,0.96090617,0.99541099,1.0865366,1.1132454,1.1443788,1.2257872,1.3011114,1.3520281,1.3871913,1.4711461,1.5777986:5
1.8139292,1.7859139,1.7617123,1.726803,1.705809,1.6648147,1.6390237,1.6017677,1.5630804,1.5309941,1.4942318,1.4554925,1.4036564,1.3716938,1.3289932,1.2969567,1.2578187,1.2188615,1.165166,1.1164221,1.0658329,1.0151014,0.94730016,0.87336183,0.79339913,0.72740969,0.68325487,0.63496287,0.59631689,0.56894004,0.54145732,0.52252771,0.49965482,0.48821667,0.46981222,0.45032363,0.43977592,0.42889605,0.41790063,0.40985597,0.4120885,0.41761748,0.40452158,0.33621814,0.25057176,0.20307744,0.16036637,0.12938001,0.095292538,0.06975972,0.054184377,0.052686685,0.049845289,0.0082753428,-0.025021644,-0.042753123,-0.069264744,-0.10114879,-0.14319278,-0.18074984,-0.23520632,-0.29981049,-0.36007967,-0.42710403,-0.48489561,-0.5531867,-0.63032169,-0.70375105,-0.77147065,-0.84840238,-0.90111333,-0.96039077,-1.0125394,-1.0578261,-1.092164,-1.1104967,-1.1334229,-1.1442,-1.1540078,-1.1533336,-1.1359563,-1.1266256,-1.1208393,-1.1203485,-1.1165456,-1.1111092,-1.0993699,-1.0793953,-1.0580021,-1.0275626,-0.9957208,-0.96254076,-0.92896189,-0.88664776,-0.84867245,-0.90348087,-0.93779637,-0.92483231,-0.89271863,-0.86109812,-0.81846478,-0.7821406,-0.74600127,-0.7058179,-0.66002627,-0.62268489,-0.57913073,-0.53531806,-0.49230936,-0.44041727,-0.46636719,-0.52638553,-0.5836115,-0.63950925,-0.70539769,-0.76714523,-0.82756001,-0.89233187,-0.9607751,-1.032823,-1.1022451,-1.1676878,-1.2330351,-1.3116931,-1.3911809,-1.4684483,-1.5436073,-1.6354415,-1.7150968,-1.787726,-1.8410807,-1.8774967,-1.8885661,-1.8834015,-1.8709577,-1.8410916,-1.806749,-1.7663187,-1.7032628,-1.6473164,-1.5819688,-1.4961279,-1.4216823,-1.3487289,-1.2751631,-1.1979084,-1.119826,-1.0433597,-0.97068357,-0.89139586,-0.81666934,-0.75058542,-0.67408528,-0.59642754,-0.52264791,-0.44425933,-0.36684778,-0.28851701,-0.22354945,-0.14937575,-0.078658107,-0.10017592,-0.097185676,-0.059778131,0.0037167788,0.09000734,0.18072584,0.2558735,0.34997864,0.42800404,0.48164896,0.41777527,0.35324561,0.28614514,0.22603635,0.16446603,0.10696399,0.055099894,0.016493754,-0.0027103091,0.015961261,0.053957574,0.10439323,0.17584348,0.26931145,0.34882776,0.43751883,0.51298481,0.56805218,0.66333049,0.72215163,0.81355415,0.90924303,1.0043911,1.0999857,1.1758487,1.2526074,1.3480832,1.3337866,1.2571917,1.201102,1.2220693,1.2907187,1.3725026,1.4500091,1.5358862,1.612825,1.7063498,1.8015461,1.8759669,1.9503849,2.0306579,2.0994262,2.1090937,2.0343079,1.9390067,1.8433378,1.7671636,1.6800761,1.6049225,1.5350232,1.4630072,1.3870686,1.3111988,1.2365272,1.1799816,1.1492045,1.2051806,1.2370706,1.1553114,1.0672358,0.99261403,0.92653326,0.86504143,0.79090273,0.71654369,0.64011952,0.5701446,0.480604,0.40360597,0.3302476,0.25654072,0.18350022,0.09132937,0.033266329,-0.022355944,-0.036941454,-0.012886309,0.023327359,0.065636611,0.11029427,0.16069294,0.21534114,0.27180389,0.33088442,0.39724414,0.45638658,0.52798015,0.56417526,0.47047886,0.39618394,0.30610871,0.2170716,0.14449565,0.057862165,-0.0096061537,-0.083166221,-0.12646363,-0.13484231,-0.12068547,-0.18932596,-0.26563367,-0.3329679,-0.41082247,-0.48705252,-0.54852418,-0.63784423,-0.71331325,-0.78683938,-0.85413451,-0.92539296,-0.99705484,-1.0795593,-1.1484071,-1.2253554,-1.3018406,-1.3674042,-1.4398306,-1.4938565,-1.5463159,-1.5819078,-1.6068791,-1.6139746,-1.6015959,-1.571856,-1.5191041,-1.4555443,-1.3653732,-1.291024,-1.2021982,-1.120202,-1.042712,-0.96612862,-0.89579117,-0.82515407,-0.76434594,-0.71638233,-0.63696315,-0.57623792,-0.51651439,-0.45592181,-0.39938699,-0.33997977,-0.336127,-0.378286,-0.43098412,-0.47519422,-0.52030978,-0.56406078,-0.60214511,-0.64367461,-0.67809968,-0.67215985,-0.61911368,-0.632842,-0.67960183,-0.72311859,-0.76131993,-0.80004977,-0.84128823,-0.87433285,-0.91009523,-0.94530264,-0.97287221,-0.99639622,-1.0187675,-1.0381415,-1.0583534,-1.0733996,-1.0843064,-1.0909192,-1.0954578,-1.0897866,-1.0715412,-1.0581662,-1.0171005,-0.95487722,-0.88419804,-0.816309,-0.75046021,-0.68583903,-0.61676475,-0.54580249,-0.47432466,-0.40672644,-0.33514756,-0.26530104,-0.25463768,-0.24071392,-0.22463756,-0.20284775,-0.18163775,-0.18677917,-0.15899402,-0.13769684,-0.12201808,-0.11237632,-0.10646192,-0.092117702,-0.084888031,-0.072373154,-0.064948445,-0.055225249,-0.038575504,-0.020922434,-9.9560354E-4,0.030317757,0.06954223,0.10972105,0.16546941,0.20956256,0.27403607,0.36491393,0.44030323,0.51924413,0.57401774,0.62976869,0.67708615,0.73056882,0.77771876,0.80000914,0.82422756,0.85925643,0.88222503,0.90217638,0.93953005,0.96876201,1.0070294,1.0535227,1.0914482,1.1278879,1.1583475,1.1895362,1.2213314,1.2486538,1.2739662,1.3041781,1.3317584,1.3665583,1.4014781,1.4345585,1.4634797,1.4984602,1.5328896,1.5673963,1.6028129,1.6359651,1.6708901,1.7085957,1.7429865,1.7836,1.8180927,1.8209446,1.8178235,1.8156936,1.8182862,1.8182444:4
1.8770258,1.7272731,1.6054288,1.5081829,1.4590312,1.455914,1.4682022,1.4665364,1.4365304,1.3977101,1.3529871,1.3217325,1.2859835,1.2595994,1.2245773,1.1763827,1.1242696,1.0665782,1.0074696,0.96592269,0.92951518,0.9018025,0.88189225,0.86506795,0.84656171,0.82922262,0.81293769,0.80738273,0.79549533,0.80046095,0.76389488,0.75268732,0.74607876,0.72749097,0.72547538,0.70129018,0.69052644,0.67025822,0.64516143,0.61814875,0.5791334,0.52771103,0.48603817,0.43599512,0.37657626,0.3246798,0.22665867,0.11202458,-0.009109787,-0.084225469,-0.13711664,-0.17522857,-0.19369951,-0.19831659,-0.20755427,-0.21650577,-0.21955287,-0.22930417,-0.23751938,-0.22626459,-0.21164296,-0.19357451,-0.17666304,-0.146752,-0.10481338,-0.05741237,-0.0094752878,0.03956065,0.10758942,0.17129102,0.24284083,0.37003197,0.37092554,0.23654637,0.13637325,0.18117299,0.2550516,0.3453861,0.43419885,0.53462286,0.64535094,0.75457505,0.79419147,0.67189115,0.52477893,0.40081577,0.25624554,0.1438123,0.01621039,-0.10497462,-0.21331435,-0.26820053,-0.36054869,-0.45174278,-0.54367359,-0.63926035,-0.73926713,-0.81813467,-0.91250522,-1.0204214,-1.1296653,-1.2499537,-1.3587001,-1.471245,-1.5846278,-1.6871482,-1.7845313,-1.8712888,-1.9416644,-1.9733412,-1.9705781,-1.9467227,-1.9184177,-1.8697559,-1.8251774,-1.7665809,-1.7069464,-1.6387997,-1.5639092,-1.4984199,-1.4365281,-1.3627186,-1.2733785,-1.1932659,-1.1060006,-1.0174885,-0.93263178,-0.84670341,-0.75173079,-0.65298449,-0.56232051,-0.45543059,-0.3529662,-0.24820078,-0.13987971,-0.034193208,-0.04922958,-0.087884029,-0.20297893,-0.21208196,-0.11023453,-0.0079934128,0.10612411,0.20509228,0.3235397,0.42724985,0.54459391,0.63489742,0.53707135,0.41775362,0.31582009,0.20912555,0.09897914,-0.0077488396,-0.11663499,-0.21801904,-0.27260694,-0.19013582,-0.27360634,-0.38118502,-0.49275677,-0.59797668,-0.70900987,-0.81736057,-0.92200885,-1.0228493,-1.1257008,-1.2404732,-1.3406795,-1.4406986,-1.5369878,-1.6146579,-1.6858206,-1.7122583,-1.6850491,-1.6320052,-1.5433466,-1.4469989,-1.3239403,-1.2115737,-1.0682181,-0.94116085,-0.79161035,-0.64182896,-0.49077781,-0.36193227,-0.27421337,-0.16612724,-0.036421734,0.095510908,0.22832458,0.33964904,0.45962625,0.40701095,0.41653262,0.54281634,0.69356166,0.8443016,0.93490221,1.0817653,1.1417998,1.0134746,0.89963984,0.77789984,0.68434107,0.59289447,0.51271894,0.45111028,0.39363188,0.36653472,0.35883082,0.38990988,0.46513057,0.56512378,0.66219052,0.77926806,0.8928517,1.0074516,1.1242024,1.2546206,1.3803919,1.4557226,1.3614552,1.287738,1.2206342,1.191596,1.2779071,1.3828882,1.4871949,1.6024438,1.7055233,1.7246697,1.7348295,1.8404507,1.9383041,1.9748436,1.8578728,1.7440837,1.6182869,1.6163186,1.5681171,1.4511692,1.3212058,1.2178551,1.1027271,0.9749687,0.9417812,0.98181149,1.069177,1.1554296,1.0946033,0.97512159,0.88572649,0.77802611,0.66059598,0.54245815,0.42756241,0.3130117,0.19776206,0.085082988,-0.032006384,-0.14573703,-0.25679077,-0.36597101,-0.48619385,-0.55684236,-0.60231127,-0.60267574,-0.57251629,-0.56471482,-0.45853896,-0.35560044,-0.23722065,-0.13055928,-0.020891863,0.087947093,0.19603154,0.31118596,0.41946695,0.52940752,0.63461454,0.57098877,0.46633942,0.39549957,0.3517596,0.24936131,0.13849311,0.039773326,-0.064936774,-0.16917429,-0.26877659,-0.36397979,-0.33957539,-0.24725225,-0.11994854,-0.16940634,-0.26926578,-0.36169812,-0.46163956,-0.56099603,-0.66367182,-0.76180925,-0.86462886,-0.96248743,-1.0615447,-1.1578708,-1.2601529,-1.3457734,-1.4512743,-1.5540398,-1.6559641,-1.7523636,-1.8442561,-1.927997,-2.0161485,-2.0967414,-2.1726216,-2.2540551,-2.3142923,-2.3467446,-2.3789636,-2.3912351,-2.3448879,-2.2594954,-2.1600802,-2.0629893,-1.9600336,-1.8634991,-1.7452897,-1.636932,-1.5141145,-1.4140985,-1.309622,-1.1918068,-1.0726026,-0.96055318,-0.84992981,-0.73863517,-0.60726376,-0.52472594,-0.53131488,-0.41815479,-0.2910261,-0.14710487,-0.020819754,0.096649745,0.1870011,0.20344153,0.15207293,0.092181129,-0.012100913,-0.1203991,-0.20656494,-0.28472877,-0.35432247,-0.40419054,-0.39026048,-0.28787805,-0.17654565,-0.097454572,-0.20210657,-0.27806385,-0.34427976,-0.3982581,-0.4418668,-0.47778309,-0.5193249,-0.54327876,-0.56996087,-0.58350165,-0.59460071,-0.61501563,-0.62666014,-0.63257903,-0.64681187,-0.64405571,-0.61758086,-0.57696949,-0.50688791,-0.41939226,-0.30251317,-0.15866559,-0.045898455,0.041001779,0.10661904,0.16710223,0.23299083,0.30933038,0.38514369,0.45930583,0.54567474,0.63267155,0.72866684,0.81997501,0.91474446,1.0122228,0.96751443,0.89295491,0.83715969,0.78269268,0.7502454,0.72976053,0.7274036,0.75710869,0.78945489,0.81373827,0.83981029,0.86667713,0.90007961,0.92438945,0.95162348,0.98309948,1.0349598,1.085345,1.1287205,1.1835309,1.2511757,1.3107391,1.3865284,1.4584872,1.5166124,1.5651463,1.6119917,1.6366561,1.6270547,1.6670612,1.759213:4
1.7223691,1.6599632,1.5848329,1.4864902,1.3983922,1.3196592,1.3730162,1.2846803,1.3306365,1.2789072,1.2245418,1.1458169,1.0606473,1.0342687,0.94226766,0.8978689,0.87393293,0.82349365,0.78434861,0.7442132,0.70064795,0.63394336,0.59121702,0.54819373,0.47049884,0.41222569,0.38812681,0.40711807,0.34858459,0.24874856,0.14661161,0.068291645,0.012150313,0.087847554,0.13764842,0.17187335,0.19644258,0.26934388,0.34848414,0.43188595,0.56011347,0.67858781,0.74764793,0.77340999,0.7079242,0.63343894,0.56685234,0.50873138,0.43299157,0.34037349,0.24750946,0.15655992,0.052134665,-0.04236558,-0.10161689,-0.20162379,-0.32111053,-0.46116973,-0.5882596,-0.61285146,-0.70429244,-0.80024344,-0.76125021,-0.80523347,-0.84322969,-0.92463114,-0.93062536,-0.89300199,-0.79542194,-0.66553685,-0.52555606,-0.40300516,-0.27093297,-0.11441124,0.041158965,0.17167059,0.30498204,0.41975693,0.56545208,0.74359147,0.89738957,1.0446647,1.0744777,1.0218602,0.95847308,0.93176273,0.86583851,0.82140831,0.77867764,0.7265683,0.66983723,0.60726287,0.5667385,0.53952467,0.52666728,0.47258307,0.41862386,0.34028831,0.24785594,0.16717733,0.086201863,0.010811392,-0.044644168,-0.02044146,-0.023309592,-0.087547629,-0.12618432,-0.155213,-0.17666879,-0.21519775,-0.34026936,-0.39424068,-0.40793541,-0.4584218,-0.57127713,-0.70384161,-0.84243518,-0.94242123,-0.94870271,-0.99634072,-1.0788017,-1.2074359,-1.3357988,-1.4621105,-1.5762327,-1.6927273,-1.7459774,-1.817927,-1.8088592,-1.6989813,-1.5599882,-1.4652609,-1.3390079,-1.2010603,-1.0777338,-0.93845349,-0.80678288,-0.66586306,-0.54813366,-0.41121766,-0.28608149,-0.14890136,-0.016180171,0.10823756,0.24174035,0.37377332,0.51566673,0.6396128,0.7799972,0.90364696,1.0349413,1.1633925,1.2937787,1.4291022,1.5542636,1.6886428,1.8132679,1.9468213,2.0271507,1.9423022,1.8213187,1.6845982,1.562852,1.4246744,1.3027782,1.1672929,1.0410314,0.90652756,0.77965218,0.64215939,0.52179641,0.39224444,0.26048385,0.13608034,0.0015133498,-0.13229207,-0.25545533,-0.39172547,-0.52464943,-0.64701785,-0.78919295,-0.91264935,-1.0463576,-1.1824671,-1.1566766,-1.0692575,-0.982298,-0.95099174,-0.94969008,-1.0259427,-1.0779036,-1.0798761,-0.91377094,-0.77256153,-0.64906464,-0.54657228,-0.44938304,-0.35669442,-0.2605219,-0.17633611,-0.12706934,-0.11890848,-0.09452981,-0.065427528,-0.015488823,0.051036432,0.14285134,0.20854302,0.29661193,0.3393552,0.40695396,0.46797716,0.545706,0.63034956,0.69207478,0.55448185,0.38117963,0.20781961,0.067082861,-0.08104106,-0.23068124,-0.37183814,-0.52469571,-0.67524738,-0.81189063,-0.87915914,-0.85673416,-0.75244326,-0.69699751,-0.65935095,-0.59894762,-0.53531399,-0.430532,-0.33388407,-0.21873643,-0.10187062,-2.4098198E-4,0.11111431,0.18595913,0.21720558,0.32355256,0.40993141,0.48123399,0.55745061,0.63548803,0.74007776,0.65598581,0.54081122,0.41649238,0.29192925,0.17588275,0.1833244,0.25503659,0.3465771,0.41061742,0.50643312,0.61312912,0.686265,0.70866821,0.76184707,0.82211282,0.90367803,0.96389781,1.0403032,1.1507858,1.2363464,1.1572254,1.0195791,0.89555617,0.76615692,0.64471645,0.54027237,0.4343481,0.30862439,0.17686113,0.038337206,-0.078176541,-0.1490419,-0.21391915,-0.27495481,-0.41011524,-0.56538612,-0.6945349,-0.83179967,-0.94753876,-1.123558,-1.2790666,-1.433969,-1.554787,-1.6753595,-1.733912,-1.7779278,-1.8935344,-1.8970982,-1.946272,-1.9687271,-1.9366821,-1.8735926,-1.8006924,-1.6857766,-1.5560176,-1.4346544,-1.2981341,-1.1749115,-1.0517582,-0.93700255,-0.84306225,-0.72529298,-0.6120407,-0.48637267,-0.36050801,-0.23355275,-0.1320584,-0.0078685811,0.10057082,0.20480582,0.30200272,0.32023221,0.26743295,0.19971003,0.14609143,0.13800673,0.24427782,0.34331118,0.4556333,0.55623616,0.64843091,0.72391615,0.84107301,0.94502551,1.0505003,1.1427687,1.2481103,1.3108454,1.3751329,1.4695173,1.5663012,1.6768164,1.772071,1.891494,2.0136628,2.1280608,2.1457494,2.0328268,1.9138936,1.8004211,1.6556112,1.5131062,1.3874667,1.3057598,1.1948582,1.0871007,1.0298215,0.95451311,0.84625227,0.71694395,0.59910909,0.48481871,0.36259438,0.23992072,0.10570567,-0.020069713,-0.10437564,-0.16322998,-0.12844864,-0.065838304,-0.033262678,-0.088506921,-0.18461927,-0.30352675,-0.40463747,-0.51418317,-0.63397767,-0.75061986,-0.86982972,-0.97830621,-1.0956827,-1.214637,-1.3214925,-1.4390593,-1.6006675,-1.7134856,-1.7399757,-1.7529128,-1.8370781,-1.9423304,-2.0765392,-2.2099071,-2.3140179,-2.4167238,-2.4534245,-2.4600972,-2.5326688,-2.4311528,-2.3231911,-2.1681516,-2.0136263,-1.882228,-1.7290483,-1.5769783,-1.3986924,-1.2501046,-1.0821909,-0.91959539,-0.77093528,-0.59237284,-0.46944239,-0.32214605,-0.2304432,-0.18628111,-0.14467539,-0.12819439,-0.034618204,0.090485025,0.21525222,0.33560397,0.47749664,0.61786652,0.74196397,0.83472156,0.91895812,1.0315547,1.1533022,1.2818554,1.4123896,1.5405428,1.6737209:5
1.2669414,1.1744132,1.0714968,0.9808427,0.95342992,0.87172937,0.79834394,0.64947258,0.68926651,0.6603635,0.52936816,0.44835307,0.37801903,0.24865287,0.11641845,0.10043668,0.02757598,0.0023858073,-0.11527966,-0.16410725,-0.27322343,-0.29755274,-0.36613154,-0.43877455,-0.50229688,-0.59673574,-0.69666774,-0.685893,-0.84799905,-0.68415843,-0.50075375,-0.28628441,-0.12528088,0.094394218,0.29649643,0.3944196,0.56516468,0.74005158,0.95956835,1.1485538,1.3650331,1.5027599,1.4419108,1.3318424,1.2466489,1.2115054,1.1792089,1.2140551,1.1696538,1.1921888,1.1025712,1.1044864,1.1251332,1.086927,0.96446258,0.84564347,0.84310079,0.68415648,0.60042857,0.48758936,0.36229755,0.30286937,0.17993674,0.0038124515,-0.035872635,-0.15648916,-0.26923061,-0.37732316,-0.49284852,-0.59218419,-0.57055274,-0.744034,-0.5331256,-0.35849255,-0.15092779,-0.10764101,-0.14700175,-0.23306733,-0.30678291,-0.31754767,-0.37791546,-0.43993405,-0.4598203,-0.56049177,-0.63289316,-0.72049974,-0.83675649,-0.88194298,-0.93371502,-0.98774077,-1.1391115,-1.2125034,-1.3349744,-1.479732,-1.5658292,-1.7474274,-1.8096288,-1.9082044,-2.0142954,-2.1384548,-2.0065216,-1.8318175,-1.6626118,-1.4771392,-1.3125214,-1.1343907,-0.92487438,-0.74051952,-0.58601581,-0.38757175,-0.23941461,-0.0030119983,0.18135364,0.35981204,0.56062296,0.7359464,0.92651162,1.1366705,1.308905,1.5083112,1.7121223,1.8957484,2.160101,2.3637864,2.5262854,2.6854666,2.7863465,2.8699916,2.8477259,2.6701876,2.5070403,2.3053281,2.1156423,1.9288358,1.741215,1.5472918,1.3381495,1.1743904,0.97443803,0.76577054,0.58029851,0.41544721,0.19311611,-0.004372369,-0.18300628,-0.38676925,-0.57586583,-0.75251585,-0.97227494,-1.1541954,-1.3642387,-1.5456606,-1.7665552,-1.9339662,-2.1520558,-2.0008102,-2.1214791,-2.1254188,-1.947204,-1.7772902,-1.6222615,-1.53811,-1.3805896,-1.2289059,-1.1344537,-0.9606927,-0.86920283,-0.74869694,-0.61324212,-0.62631671,-0.6923325,-0.89547294,-1.0760788,-1.0535206,-1.0182893,-0.87885894,-0.77596212,-0.75476279,-0.55012565,-0.4930597,-0.38506414,-0.29981572,-0.19994676,-0.16033727,-0.081775533,0.0050976599,0.069248328,0.13514945,0.19332824,0.25921775,0.35445086,0.36719656,0.25705741,0.25760613,0.34885214,0.36273357,0.41042692,0.40139172,0.51164634,0.37052186,0.31476342,0.45187177,0.36030201,0.09342421,-0.16960533,-0.31054253,-0.47258368,-0.69702529,-0.96860752,-1.0928661,-1.0608546,-0.95250973,-0.89359845,-0.70267984,-0.65151053,-0.54559489,-0.41298474,-0.32003197,-0.22661963,-0.11796253,-0.13064075,-0.053940532,0.088186159,0.17004644,0.2739576,0.40778198,0.40662545,0.33583876,0.45631587,0.4466569,0.58773659,0.66630284,0.69478289,0.76927419,0.90904319,1.057611,1.1095705,1.2729133,1.2306527,1.0597244,0.85262827,0.63568533,0.44728907,0.26585206,0.11265808,-0.089886135,-0.31854925,-0.44268368,-0.59937893,-0.79862236,-1.0089741,-1.1450628,-1.0313886,-0.97011751,-0.85885471,-0.86216699,-0.73723182,-0.54751428,-0.53821481,-0.39420814,-0.36257656,-0.2230875,-0.10593298,-0.075117076,0.099697595,-0.063194255,0.035199991,0.18031665,0.33167927,0.39519264,0.4709327,0.53763855,0.64448431,0.80650704,0.85403213,0.94355445,0.73334776,0.69857221,0.87529216,1.0820479,1.2398888,1.2365377,1.3919812,1.5631714,1.6947424,1.8372828,1.7593339,1.5878647,1.3932754,1.2386341,1.022241,0.87739417,0.81718968,0.60825464,0.42530031,0.31347208,0.09482671,-0.063210885,-0.2482825,-0.42691962,-0.60741783,-0.73171842,-0.95604092,-1.0871782,-1.2245002,-1.3871909,-1.5538703,-1.4972603,-1.4074997,-1.38579,-1.2416243,-1.120571,-1.0133938,-0.8736756,-0.75359432,-0.64478704,-0.6712109,-0.78851819,-0.74328664,-0.58593414,-0.45565571,-0.29759999,-0.17373656,-0.25670346,-0.104671,0.069800558,0.24353527,0.40646212,0.5591282,0.77629997,0.77954391,0.60524373,0.41385742,0.29037629,0.12868504,0.23025511,0.11529562,-0.11307016,-0.19163357,-0.35465377,-0.45889172,-0.62918336,-0.68237376,-0.61226733,-0.73496338,-0.83405744,-0.86335826,-0.9609447,-0.99893823,-1.1593895,-1.2825357,-1.4838539,-1.411967,-1.2420373,-1.076252,-0.87960518,-0.80914503,-0.60865215,-0.43846663,-0.24145076,-0.059897166,-0.044639142,-0.10934744,0.093304646,0.27677697,0.45790547,0.66598996,0.82365239,0.81518732,1.0202949,1.23947,1.4408419,1.6304225,1.8135157,1.859981,1.6825227,1.6337218,1.5778703,1.4575526,1.3418236,1.244463,1.1522165,1.0281939,0.92815698,0.86151649,0.79079162,0.67599397,0.58789836,0.51558899,0.39317471,0.21490928,0.058690198,-0.054371617,0.042274878,0.10429518,-0.011168447,-0.20021878,-0.33383465,-0.48320496,-0.56385484,-0.68570789,-0.87874958,-0.98614982,-1.10234,-1.2571299,-1.3715593,-1.3535217,-1.5477477,-1.7164908,-1.6461777,-1.3872666,-1.4989246,-1.3969868,-1.1201521,-0.86840308,-0.64887494,-0.45221549,-0.20399184,-0.13171871,0.14036332,0.41816111,0.61761132,0.89353941,1.0243956,1.0805039,1.0965218,1.274072:1
2.5931913,2.512891,2.4046598,2.3139217,2.2338269,2.1466492,2.0608463,1.9545959,1.8397098,1.7375597,1.6416386,1.5342604,1.4659434,1.35857,1.2546934,1.1189488,1.0073254,0.89512362,0.7914591,0.68470898,0.61862105,0.6789851,0.68821598,0.64376169,0.56112511,0.45797727,0.36859027,0.28299271,0.15142566,0.041187621,-0.051191804,-0.14231133,-0.27750138,-0.3426344,-0.49511496,-0.45365998,-0.49433729,-0.56866375,-0.52261212,-0.45000237,-0.46596757,-0.51047552,-0.59311399,-0.67698631,-0.74415191,-0.83579261,-0.88894273,-0.93484265,-0.99615023,-1.0425359,-1.1452398,-1.2360083,-1.3770271,-1.4276193,-1.4521758,-1.5108452,-1.5777756,-1.6557475,-1.7359547,-1.7759955,-1.8540615,-1.8953436,-1.9397317,-1.9844736,-2.0184112,-2.0661537,-2.0854823,-2.1204521,-2.0363242,-1.919929,-1.8292974,-1.7150406,-1.6161742,-1.5079154,-1.4121679,-1.2991175,-1.1815793,-1.0779033,-0.97826392,-0.89296881,-0.78439578,-0.66778204,-0.57021009,-0.46657687,-0.35463696,-0.22781325,-0.13552894,6.0380061E-4,0.085960028,0.21698357,0.31599668,0.35673063,0.35597594,0.32022162,0.2660107,0.18469015,0.083911151,0.048036045,0.01590533,-0.086220408,-0.20199161,-0.21888281,-0.24829536,-0.33117153,-0.41768751,-0.48548892,-0.56315874,-0.63524902,-0.52147576,-0.49857623,-0.50281217,-0.5426606,-0.55504815,-0.53156386,-0.5715049,-0.57826549,-0.62601898,-0.5012269,-0.46310244,-0.42645875,-0.44540367,-0.47992548,-0.48755623,-0.53303043,-0.59513671,-0.64691099,-0.67997479,-0.7023785,-0.73793833,-0.74341146,-0.77031824,-0.79082272,-0.77915493,-0.74868471,-0.66089435,-0.55412734,-0.41438484,-0.44796244,-0.29768044,-0.19570233,-0.092546273,-0.002419007,0.1365099,0.19742276,0.27254353,0.26981892,0.25480512,0.23062774,0.2468416,0.26211463,0.35292528,0.34817057,0.33461244,0.30607422,0.34730815,0.42786698,0.45757659,0.44786285,0.41577229,0.39032129,0.33789876,0.29469095,0.27422411,0.21844965,0.14561683,0.094705915,0.10884823,0.22369097,0.2820563,0.26440547,0.23607274,0.19128908,0.16475164,0.095488741,0.056715199,0.011650539,-0.040718755,-0.092334695,-0.18522975,-0.26834645,-0.35114558,-0.43106228,-0.50038848,-0.55507075,-0.57319417,-0.50540122,-0.40219006,-0.30516494,-0.19562003,-0.13646227,-0.061131216,0.043952141,0.15465733,0.24717013,0.34417966,0.46039498,0.54122584,0.66099056,0.7439185,0.84547149,0.94816402,1.0342315,1.1275776,1.2471417,1.3372936,1.4221701,1.536398,1.6258428,1.7185586,1.8330224,1.9313737,1.9983879,2.0791983,2.209542,2.3043987,2.382773,2.4339673,2.3826135,2.3085568,2.2173222,2.1245137,2.0389179,1.9539259,1.8595724,1.7511399,1.6603795,1.5571352,1.465338,1.359997,1.277267,1.1564592,1.0854519,0.96458135,0.88188622,0.78477776,0.69025243,0.5908299,0.49515146,0.40292035,0.30221275,0.21087075,0.098114929,0.017408007,-0.080271624,-0.19211611,-0.29226512,-0.40479278,-0.49870974,-0.60706701,-0.70590006,-0.82221522,-0.925317,-0.85308271,-0.76625497,-0.82210156,-0.89475402,-0.87050821,-0.90909923,-0.94322434,-0.94388401,-0.91577799,-0.90071858,-0.85574657,-0.81106224,-0.74202976,-0.67674794,-0.62760658,-0.58225769,-0.5458142,-0.48507754,-0.43558157,-0.42969252,-0.41839526,-0.45455727,-0.45168492,-0.37382231,-0.30903161,-0.26349133,-0.26194121,-0.29918406,-0.36887713,-0.32855869,-0.31300422,-0.27931866,-0.2806507,-0.33998618,-0.34542596,-0.3399487,-0.35979845,-0.3568242,-0.39287397,-0.51100565,-0.60003642,-0.70990049,-0.82208031,-0.86620093,-0.83407529,-0.81260759,-0.76283102,-0.70272412,-0.65471757,-0.5959618,-0.54335788,-0.50379706,-0.45413173,-0.40390706,-0.35818169,-0.38588773,-0.36886229,-0.30928742,-0.26402246,-0.22310757,-0.27169251,-0.25811953,-0.22337195,-0.2025104,-0.15339929,-0.13463525,-0.1270315,-0.23145653,-0.36016508,-0.41311063,-0.35407048,-0.30132419,-0.2480378,-0.19412633,-0.13269632,-0.11653002,-0.072030565,-0.013253502,0.03179979,0.06721945,0.017695878,0.039735464,0.1129929,0.17552264,0.24165047,0.27002686,0.34450472,0.42098024,0.4775194,0.55023663,0.62377808,0.71427648,0.7801281,0.83541826,0.80327639,0.66644796,0.55481359,0.45011146,0.32994896,0.19494658,0.091867654,-0.014311215,-0.12079199,-0.20113935,-0.30951695,-0.43234843,-0.51049145,-0.56406815,-0.67916988,-0.76961498,-0.86837635,-0.99076723,-1.0553672,-1.1670952,-1.265981,-1.4128058,-1.5627613,-1.698349,-1.6834092,-1.6122332,-1.5464683,-1.4634269,-1.3801463,-1.2865563,-1.1927978,-1.1070284,-1.0190843,-0.98097435,-1.0356933,-0.98330099,-0.87854376,-0.78056319,-0.67671006,-0.58704536,-0.55752731,-0.47621326,-0.36958825,-0.29249017,-0.16829398,-0.077779636,0.021201058,0.094409711,0.081415236,-0.027496501,-0.042307234,0.082244944,0.18035139,0.30578753,0.39851215,0.52565247,0.62930323,0.67163016,0.80734384,0.87263137,0.97704676,1.0922163,1.1494662,1.1514325,1.0873272,1.137528,1.2788363,1.377695,1.5032815,1.621496,1.726148,1.7861047,1.9260287,2.0398397,2.1451703,2.2574435,2.3570695,2.4979453,2.6231916,2.666324,2.6449975:3
2.918244,2.7738738,2.60163,2.4246644,2.2477333,2.0699616,1.9311246,1.7538422,1.576201,1.3998953,1.2227683,1.0717958,0.90749359,0.76670819,0.64080796,0.52638496,0.34916355,0.1734025,-0.0030935253,-0.18099184,-0.34495939,-0.49848466,-0.67722397,-0.81914922,-0.9561091,-1.0662644,-1.2455891,-1.3876978,-1.5563873,-1.6670469,-1.6942388,-1.6416159,-1.5918051,-1.5433101,-1.5014431,-1.4628477,-1.4200889,-1.371414,-1.3230581,-1.2730757,-1.2137791,-1.1435772,-1.0638633,-0.98912707,-0.8918179,-0.80500682,-0.70418305,-0.62377615,-0.54903444,-0.5918179,-0.6973095,-0.61478585,-0.57008024,-0.46789566,-0.34588921,-0.26296844,-0.16338492,-0.049034748,-0.03206662,-0.089350194,-0.072322114,0.0034743913,0.060673088,0.12199184,0.1411219,0.18430769,0.27012828,0.3273131,0.25074944,0.11547686,-0.0017560018,-0.12169582,-0.1707165,-0.20635932,-0.33756895,-0.47376408,-0.5794958,-0.65486024,-0.7306895,-0.76904747,-0.80210659,-0.76529997,-0.67886524,-0.6360297,-0.56928759,-0.50437781,-0.41770637,-0.34839963,-0.30876004,-0.29469587,-0.33645649,-0.30805218,-0.23436603,-0.14047912,-0.11619136,-0.031881456,-0.0067288074,0.0506742,0.10350169,0.16928552,0.20978448,0.12727423,-0.012150121,-0.12726454,-0.14293866,-0.22788595,-0.16891408,-0.16628473,-0.090139315,-0.0275002,0.094178056,0.11330538,0.17890125,0.20304452,0.19957559,0.29099623,0.39537498,0.4783676,0.57876988,0.65628029,0.64913524,0.63495049,0.74369975,0.83240051,0.8911073,0.97746173,1.0737964,1.1564615,1.1610916,1.1821481,1.2949877,1.3798597,1.4467634,1.5472347,1.6171408,1.5834927,1.4462925,1.2948569,1.1582121,1.0320619,0.88332133,0.74626189,0.62014291,0.61951326,0.56298819,0.4747028,0.32597892,0.20688671,0.079308974,-0.0061811978,-0.016272649,-0.13702807,-0.26715456,-0.40593708,-0.52512501,-0.53038741,-0.57405781,-0.58152504,-0.66335184,-0.80389122,-0.94882505,-1.0901332,-1.2373037,-1.3590131,-1.5002451,-1.6478808,-1.7712707,-1.9113152,-2.0545529,-2.2211139,-2.3820213,-2.4564636,-2.3973116,-2.300598,-2.1804367,-2.0616798,-1.9427672,-1.8280748,-1.6938337,-1.575308,-1.4404481,-1.3207565,-1.1873729,-1.0655206,-0.97751316,-1.0545871,-0.93222406,-0.81522983,-0.68838239,-0.54385373,-0.41544564,-0.2887515,-0.22414511,-0.27999989,-0.17958964,-0.029871342,0.042322167,0.081568684,0.12967853,0.14655577,0.043834195,-0.055032318,-0.16068332,-0.24209875,-0.21026372,-0.17350252,-0.1770962,-0.01348749,0.067860169,0.20455313,0.2087092,0.22675607,0.37548023,0.52810544,0.64992086,0.70086347,0.66281923,0.65591152,0.75609505,0.92825717,1.0605383,1.1660507,1.1640791,1.3010234,1.4301848,1.526156,1.5073129,1.4178926,1.2928182,1.1811889,1.0806767,0.96990681,0.89632624,0.78933475,0.68667827,0.55980432,0.51899978,0.43464103,0.31635966,0.23139506,0.13128833,0.10225428,0.15030685,0.24402848,0.31922024,0.29891439,0.26578837,0.21710627,0.12235222,0.026889744,0.022323609,-0.015125915,-0.13035557,-0.26990021,-0.32340453,-0.4617855,-0.59478604,-0.64747905,-0.54796611,-0.5231245,-0.59113152,-0.69931737,-0.75922074,-0.88262952,-1.0022114,-1.0755728,-1.1810081,-1.3117389,-1.4027447,-1.4953751,-1.5781899,-1.5672149,-1.5479466,-1.4758957,-1.3750809,-1.3718702,-1.2480564,-1.1242912,-0.99512407,-0.86819328,-0.73287928,-0.61410066,-0.48848836,-0.36231655,-0.23545463,-0.11653187,0.015122224,0.041922736,0.035090406,0.093290372,0.19592514,0.29401759,0.42071762,0.55243754,0.67415836,0.79350933,0.92866491,0.98041965,1.0023644,1.1212484,1.2408878,1.3854411,1.5058729,1.6270085,1.7602506,1.7099728,1.6055692,1.4866091,1.3822536,1.3151258,1.2820665,1.1729081,1.0758403,1.021299,0.98589132,1.0241967,0.97512589,0.87226235,0.77203597,0.69286572,0.61560624,0.589003,0.49347961,0.39541573,0.31262024,0.38139922,0.5181461,0.64803997,0.65590496,0.62613381,0.58720965,0.57154055,0.49148678,0.4676736,0.44957109,0.36356979,0.26376337,0.16270398,0.077427687,-0.0044669126,0.078142171,0.14916868,0.081494599,-0.02317462,-0.11985728,-0.18860188,-0.26710018,-0.36758396,-0.45159676,-0.53546135,-0.43592756,-0.29017078,-0.17274927,-0.025433821,0.089641364,0.2308432,0.34705399,0.45451191,0.48673459,0.41743989,0.37558941,0.31515392,0.25084999,0.28048262,0.28139731,0.19428248,0.096159982,-0.0050779322,-0.095585305,-0.056728613,0.014887971,-0.023317188,-0.10728155,-0.14627621,-0.29537132,-0.42518267,-0.40671963,-0.38988712,-0.41378061,-0.49325376,-0.58629646,-0.66198969,-0.74134454,-0.79432698,-0.83827444,-0.89880616,-0.96441722,-1.0229825,-1.1098744,-1.1347701,-1.1837282,-1.2195012,-1.2573888,-1.2746215,-1.3589132,-1.4348951,-1.5185638,-1.5002254,-1.4916824,-1.3184741,-1.1759976,-1.0006164,-0.85893554,-0.68181217,-0.54069093,-0.36386187,-0.18998539,-0.015950463,0.15803492,0.33231627,0.50680472,0.68174573,0.85638923,1.031877,1.2046051,1.3416309,1.5172875,1.6925805,1.8680738,2.0168354,2.1798268,2.3560185,2.5319905,2.6684699,2.8450515,2.9735661,2.9549793:3
-0.54035597,-0.59134276,-0.57639751,-0.56943593,-0.53702469,-0.51375437,-0.48519433,-0.55656183,-0.55233848,-0.5088435,-0.50410253,-0.51215372,-0.49539736,-0.49594205,-0.49307194,-0.50273085,-0.47380972,-0.44146675,-0.39220713,-0.32509141,-0.25678919,-0.19622382,-0.12308007,-0.095848311,-0.075808194,-0.034034092,-0.015096733,0.029037301,0.062901273,0.07422811,0.12858579,0.09799854,0.15242886,0.18184088,0.19768366,0.24073539,0.27186625,0.30862621,0.34018487,0.36842514,0.38561776,0.41218832,0.43118292,0.42980998,0.42874933,0.41046726,0.38044798,0.37384242,0.38939173,0.42097187,0.45855884,0.51259066,0.58469403,0.63739731,0.696579,0.77732805,0.83799441,0.89486438,0.98071963,1.0500998,1.1450502,1.213614,1.2550602,1.3048613,1.3723485,1.4531088,1.5387627,1.6028099,1.6803912,1.6427157,1.553503,1.4789127,1.3905004,1.3368354,1.331209,1.4098367,1.4756731,1.4864302,1.5272342,1.5275233,1.5122076,1.5068218,1.4781533,1.419288,1.3605518,1.3323278,1.2931957,1.2898456,1.2991512,1.2827788,1.2136739,1.2251828,1.2081173,1.1872714,1.1582904,1.1242355,1.0654373,1.0131798,0.9593237,0.92018571,0.94449263,0.97055925,0.91676195,0.82345153,0.76274557,0.68886634,0.59967452,0.52239578,0.43647397,0.36936135,0.30010899,0.23310901,0.16372633,0.10587545,0.033492504,-0.016325273,-0.077844068,-0.10549364,-0.12132529,-0.13211092,-0.12368793,-0.13298807,-0.14864876,-0.17292993,-0.20479973,-0.24566615,-0.3078629,-0.37221836,-0.44360112,-0.52012591,-0.55236864,-0.61192367,-0.67549328,-0.74576145,-0.76699172,-0.79271576,-0.79278822,-0.77814679,-0.76766085,-0.74940139,-0.72076514,-0.6898495,-0.66641056,-0.65131577,-0.62406006,-0.62023709,-0.62386089,-0.62936306,-0.62811344,-0.64593742,-0.66223217,-0.65523734,-0.67138277,-0.6826344,-0.70953073,-0.7395042,-0.76220734,-0.78323842,-0.81090534,-0.83642589,-0.8972531,-0.95108463,-0.99877227,-1.0598982,-1.1373652,-1.1958558,-1.2541125,-1.2747435,-1.2669706,-1.251386,-1.2403044,-1.2026002,-1.1702933,-1.1293893,-1.0953137,-1.0595874,-1.038584,-1.013891,-0.99201223,-0.96186897,-0.93790578,-0.91932373,-0.88336978,-0.87247234,-0.85200698,-0.81357509,-0.80829435,-0.78674109,-0.77489804,-0.75705788,-0.7548143,-0.72631881,-0.72573181,-0.71339648,-0.70992821,-0.7272023,-0.74986831,-0.70356761,-0.74373134,-0.76448967,-0.80366552,-0.83030946,-0.86233305,-0.89835284,-0.93337058,-0.98064185,-1.0232217,-1.0649186,-1.1144822,-1.1640729,-1.2167865,-1.2812363,-1.3422562,-1.3991585,-1.3663349,-1.350149,-1.2897612,-1.2616882,-1.214893,-1.1583153,-1.0904944,-1.028938,-0.96618416,-0.90402072,-0.8381815,-0.76644603,-0.7099793,-0.64969908,-0.58740799,-0.52048516,-0.45394911,-0.38691872,-0.33559754,-0.26133136,-0.20610894,-0.14196978,-0.068237395,-0.0059730914,0.052803539,0.12534712,0.17887903,0.24281266,0.31154765,0.38158301,0.44456701,0.51264955,0.5776222,0.65050829,0.71200117,0.78701543,0.83702954,0.90923708,0.94504271,1.0061467,1.0341383,1.0746374,1.1009663,1.1475053,1.1413439,1.1324282,1.1151216,1.08156,1.0584073,1.0135239,1.0014179,0.97687112,0.9566719,0.97285285,1.0132782,1.0501826,1.1142796,1.1969063,1.24763,1.3223681,1.399623,1.4449497,1.5208443,1.5663183,1.611814,1.6559164,1.6998031,1.7523865,1.785028,1.8448474,1.8725213,1.9113978,1.9377243,1.9666663,1.9976038,2.0168746,2.0557487,2.0575973,2.02275,1.9955411,1.9690936,1.9335855,1.8969876,1.8496287,1.8087687,1.7793865,1.7421259,1.7337935,1.7400343,1.6896172,1.6447908,1.5942647,1.5531636,1.5154871,1.4675639,1.4169434,1.3658828,1.3221242,1.258711,1.1983225,1.1513763,1.1009646,1.0402444,0.97992415,0.92891522,0.87400733,0.82668765,0.76847965,0.708976,0.64564774,0.58268182,0.52046399,0.46149691,0.40689952,0.32648556,0.25494308,0.19138359,0.12426888,0.043859331,-0.015175284,-0.085713243,-0.16627782,-0.25171471,-0.2941016,-0.38037128,-0.47399703,-0.54546957,-0.62346735,-0.718702,-0.80670991,-0.86591548,-0.90620125,-0.94950945,-0.92544857,-0.87418172,-0.82061828,-0.76795426,-0.71865208,-0.66481006,-0.61237833,-0.56708547,-0.51566732,-0.47041077,-0.42099278,-0.38193111,-0.34935239,-0.31220073,-0.27020372,-0.2875822,-0.3170567,-0.32937726,-0.35232643,-0.37332287,-0.41431865,-0.45566976,-0.48167791,-0.50922197,-0.54587835,-0.598116,-0.63389118,-0.68212955,-0.72266594,-0.75970261,-0.78771349,-0.82644712,-0.85566011,-0.91554116,-0.96111756,-0.98864128,-1.0255082,-1.0783107,-1.0926294,-1.1395405,-1.197726,-1.2217196,-1.2472971,-1.2890367,-1.3330778,-1.3798675,-1.4222982,-1.4666047,-1.5087429,-1.5466498,-1.5760464,-1.6196136,-1.6552431,-1.6599604,-1.7069036,-1.7323007,-1.7288764,-1.7029418,-1.6556369,-1.5584169,-1.49283,-1.3992668,-1.3040158,-1.2406863,-1.145171,-1.0516498,-0.98408336,-0.90199408,-0.85569007,-0.8176432,-0.77957121,-0.74745941,-0.72001031,-0.69037524,-0.65972431,-0.65908698,-0.63344442,-0.60738387,-0.58783934,-0.54936284:2
3.4768174,3.365992,3.178487,2.9707978,2.7617772,2.6069175,2.460241,2.2944802,2.0842156,1.891881,1.7137787,1.5033738,1.2930859,1.1320277,0.94362973,0.75719161,0.54107658,0.38362546,0.16612912,1.3485147E-4,-0.16533025,-0.32982544,-0.49880987,-0.7107148,-0.87124421,-1.0516571,-1.2510193,-1.4108689,-1.6222499,-1.7839008,-1.8637775,-1.9957673,-1.9793059,-1.8505699,-1.7642204,-1.6585453,-1.5165655,-1.4096759,-1.2829999,-1.2146968,-1.1945925,-1.1967231,-1.1864018,-1.1066991,-1.0613294,-0.9617546,-0.89941923,-0.83458569,-0.73877111,-0.64221044,-0.80900081,-0.75071971,-0.72468813,-0.72280097,-0.62327113,-0.48469447,-0.37978474,-0.31603961,-0.36021569,-0.29320013,-0.29702462,-0.39478093,-0.28062386,-0.16133295,-0.043514393,0.026425584,0.075493056,0.11193566,0.078206485,0.035434675,0.11188189,0.11056263,0.13618443,0.18870337,0.21727819,0.25959812,0.20385859,0.085526213,-0.08068279,-0.25111151,-0.4135921,-0.50386212,-0.52759404,-0.49992248,-0.4122285,-0.44358155,-0.37142728,-0.30510138,-0.25897593,-0.20356637,-0.18483424,-0.14333117,-0.10348377,-0.014483685,-0.0013650494,0.08443756,0.16035628,0.23360343,0.30763248,0.3511366,0.43474201,0.5252051,0.59377047,0.55016591,0.65103667,0.65133637,0.73895159,0.76271183,0.82060315,0.88488503,0.97526932,1.0781617,1.1544127,1.2015835,1.0879186,0.91564367,0.75131344,0.60703669,0.56346122,0.48665999,0.32666596,0.25261928,0.18445319,0.22802009,0.1030175,-0.059832985,-0.15435738,-0.24239031,-0.081945468,-0.2391074,-0.39012127,-0.31327452,-0.47025269,-0.65978242,-0.69063281,-0.59624683,-0.70623552,-0.65595426,-0.53683003,-0.5232312,-0.43287092,-0.3393035,-0.25647482,-0.14963885,-0.10723739,-0.084936967,0.026466952,-0.078727958,0.012326375,0.068262383,0.14881317,0.19921334,0.28057998,0.37536287,0.45542846,0.50326355,0.46959815,0.56626901,0.62292836,0.75411,0.68621219,0.8217528,0.91740878,0.98542221,1.0480338,1.0680287,1.0518151,0.93775744,0.77587894,0.60947347,0.46898106,0.32899842,0.28892714,0.23420542,0.075083931,-0.058031528,-0.21207123,-0.30227986,-0.29855682,-0.45643195,-0.60608752,-0.7409363,-0.91085625,-1.0300511,-0.95932151,-0.88068191,-0.74147795,-0.64771539,-0.57752508,-0.39845762,-0.29390669,-0.16145738,-0.039972123,-0.065743728,-0.087994749,0.027030873,0.14326818,0.28027796,0.38795476,0.50299617,0.48547299,0.59210717,0.75038985,0.78114961,0.8920173,1.0093502,0.92075777,0.77816488,0.69836599,0.56232549,0.44801222,0.54726888,0.45425909,0.30962778,0.21023637,0.077594608,-0.033403142,0.068355333,-0.031410268,-0.1629561,-0.29928599,-0.46704933,-0.4729883,-0.62883056,-0.8022414,-0.99811187,-1.0769379,-0.99148768,-0.94509794,-0.80632214,-0.67235896,-0.56031468,-0.44372427,-0.27881705,-0.13312639,-0.013580411,0.021901035,0.074640049,0.2134288,0.34432718,0.47595469,0.62035506,0.66726131,0.81901849,0.97284569,1.1211674,1.2452203,1.3955725,1.5439181,1.4645026,1.3161184,1.1558574,0.98342861,0.97495036,0.82974869,0.64801638,0.51061511,0.61230396,0.50320542,0.35663302,0.25839326,0.1481872,0.0027439728,-0.13389025,-0.27270387,-0.25142439,-0.32749129,-0.43556237,-0.57403464,-0.67504116,-0.76334672,-0.86812696,-0.9861998,-1.1254532,-1.2332693,-1.2631958,-1.2139064,-1.0444818,-0.84733478,-0.68533962,-0.48136622,-0.33474453,-0.24550641,-0.085352852,0.11655115,0.31490252,0.28416397,0.30276521,0.45452986,0.64151389,0.82771657,1.000464,1.162784,1.2693952,1.1730729,1.0564255,0.95806082,0.85676793,0.92758068,0.84737616,0.75078365,0.67233984,0.60558344,0.71463567,0.62573478,0.5218367,0.44547663,0.34852964,0.25660541,0.39103789,0.33657218,0.26797845,0.17705522,0.084821341,-0.010657799,-0.089863644,-0.18569263,-0.3059241,-0.3502035,-0.33393255,-0.40436544,-0.47197715,-0.5404532,-0.63218996,-0.69023719,-0.76329137,-0.77210592,-0.87433347,-0.85813988,-0.85313174,-0.89885857,-0.94555572,-0.91175925,-0.74174941,-0.58948186,-0.44235247,-0.29281055,-0.17697849,-0.12668385,0.047794171,0.19118425,0.34444027,0.50128086,0.54050866,0.42139637,0.34780305,0.31025109,0.2394831,0.11544394,0.22888029,0.18108954,0.11285493,0.052825702,-0.019811631,-0.15374002,-0.14051121,-0.16297908,-0.19572411,-0.26723247,-0.21247931,-0.21610395,-0.34238937,-0.48209216,-0.50075028,-0.53803829,-0.59820426,-0.69127406,-0.74160912,-0.79578779,-0.65340497,-0.66798831,-0.79251534,-0.87472263,-0.95118871,-0.98485607,-1.0452131,-1.0727779,-1.0416923,-1.0039378,-1.0629605,-1.1688642,-1.2675884,-1.3577121,-1.4476513,-1.5317473,-1.592667,-1.6848912,-1.7731481,-1.8169838,-1.8947815,-1.9244867,-2.0319956,-2.2189353,-2.286413,-2.4075672,-2.2346874,-2.0712514,-1.8569314,-1.6950462,-1.5317047,-1.3185024,-1.1558621,-0.94152545,-0.77968345,-0.56652667,-0.40433016,-0.19293285,-0.029245634,0.18297283,0.37668581,0.55767524,0.76922432,0.97263872,1.1434235,1.3550999,1.5661566,1.7776885,1.9886761,2.2008272,2.4112562,2.6218173,2.831215,2.9855669,3.1968874,3.3167597,3.3931099,3.4787648:1
1.3387632,1.2609112,1.1864476,1.1179541,1.0911611,1.0085605,0.92153284,0.83255304,0.76130472,0.67786473,0.59675146,0.53675114,0.47040074,0.38483966,0.42818757,0.50395701,0.56241254,0.64490995,0.72416765,0.81666249,0.89961811,0.8244494,0.73818671,0.6384775,0.53138673,0.4585559,0.36748335,0.28775299,0.17016983,0.05906224,0.0011249953,-0.0783807,-0.19111339,-0.30747362,-0.42900615,-0.53942033,-0.63798144,-0.75960168,-0.86640006,-0.90558541,-0.9991551,-1.0869777,-1.1603817,-1.1619358,-1.1004354,-1.0135902,-0.9055667,-0.78982762,-0.67235881,-0.56003379,-0.44713385,-0.33608435,-0.22413924,-0.11007278,-9.9908167E-4,0.10468186,0.21326147,0.32179383,0.4339111,0.54161237,0.65696613,0.765011,0.86995088,0.81990429,0.73439265,0.61896014,0.50980523,0.39673072,0.30853898,0.23314992,0.14204936,0.037710757,-0.036196504,-0.12643607,-0.20750083,-0.28506129,-0.38055998,-0.4382715,-0.48469227,-0.55295129,-0.58397194,-0.64010084,-0.71142553,-0.78569493,-0.8472561,-0.89247602,-0.95594073,-1.040013,-1.09409,-1.1583666,-1.128892,-1.1302596,-1.1480923,-1.2050778,-1.2593204,-1.320981,-1.3702676,-1.4129747,-1.4696165,-1.454997,-1.3783849,-1.2722966,-1.1516095,-1.0124827,-0.95353555,-0.88411148,-0.77435579,-0.6557999,-0.55574662,-0.43330152,-0.3205586,-0.20611317,-0.087733061,0.020750843,0.13697863,0.24168001,0.35816402,0.47420264,0.58995005,0.70515482,0.82057075,0.94444942,1.0082679,1.0936508,1.1748095,1.2615587,1.3854982,1.5107497,1.6116759,1.742271,1.8719016,1.9890659,2.117555,2.2645678,2.3276303,2.3266795,2.2033591,2.0651291,1.9565901,1.8591047,1.7369826,1.6020808,1.472344,1.3626783,1.239662,1.1152334,0.99177904,0.87267593,0.76756768,0.65184468,0.56913382,0.44773057,0.33461042,0.21477634,0.10008792,-0.017126259,-0.13547438,-0.25337953,-0.35485634,-0.46690373,-0.54623241,-0.65064677,-0.75535227,-0.87571428,-0.96045144,-1.0283802,-1.1365501,-1.2697576,-1.3777483,-1.4139806,-1.5478398,-1.6418012,-1.7007999,-1.6864778,-1.6295748,-1.5315659,-1.4795821,-1.3831043,-1.2846687,-1.1875814,-1.0890281,-1.0306435,-1.0306687,-1.0072295,-0.91106227,-0.79822555,-0.70891119,-0.60432082,-0.49066013,-0.38305687,-0.27420933,-0.2550137,-0.26098448,-0.18817097,-0.065790439,0.017867182,0.11131239,0.21286617,0.28711592,0.43113785,0.57376217,0.70461221,0.80426945,0.8804138,0.89608628,0.79444277,0.69009707,0.58189379,0.48536068,0.38304087,0.29224307,0.19092742,0.094963449,-0.017359624,-0.12357422,-0.24412723,-0.37437877,-0.49949279,-0.61735165,-0.73727186,-0.84593959,-0.89551013,-0.86563798,-0.78100925,-0.70047105,-0.63667097,-0.54899604,-0.46941762,-0.36492474,-0.24719206,-0.1573836,-0.069268115,0.018879982,0.093405701,0.16739233,0.2509453,0.33891341,0.42656887,0.50808791,0.58255408,0.65886831,0.70933477,0.79292929,0.86723867,0.79590835,0.69980028,0.60854219,0.49311195,0.43099048,0.4222824,0.45905382,0.53400127,0.62457439,0.70301193,0.78338574,0.87499538,0.95206334,1.0395255,1.0327505,1.054779,1.1166915,1.2091049,1.3056791,1.3701041,1.4548379,1.5738756,1.663335,1.6294073,1.5153158,1.404818,1.2940605,1.2021202,1.0943633,0.98559561,0.89653122,0.79440291,0.67925968,0.56963345,0.46719442,0.35671519,0.25139626,0.17035409,0.10989781,-0.0031251632,-0.11212408,-0.22757818,-0.34699716,-0.46618391,-0.57999358,-0.69573339,-0.81201091,-0.93111803,-1.0528953,-1.1507285,-1.2748973,-1.3949184,-1.4779445,-1.5744762,-1.5713048,-1.6891655,-1.6363158,-1.5774735,-1.4927136,-1.4047706,-1.2798499,-1.1570081,-1.0535115,-0.93435172,-0.82226756,-0.68135954,-0.58736186,-0.48815459,-0.35467554,-0.22828374,-0.090573728,0.01204069,0.13927979,0.26779466,0.36721468,0.38589646,0.31343029,0.2428652,0.19706001,0.16363949,0.20416267,0.28866829,0.38598512,0.48534821,0.57898536,0.67503994,0.76403135,0.86178668,0.96102396,0.95333523,0.98542035,1.0759413,1.1690788,1.2547615,1.3204564,1.393716,1.4818319,1.5733772,1.6763396,1.7805964,1.8423637,1.7052664,1.5867972,1.4655592,1.3758865,1.2686201,1.1669281,1.0754695,1.0086952,0.93187877,0.80448251,0.68841956,0.56284192,0.45348138,0.35621565,0.24362188,0.12244079,0.022922557,0.0022036466,0.05986161,0.11143878,0.051186773,-0.050130025,-0.1687401,-0.26452804,-0.38594307,-0.48048693,-0.59241139,-0.70553653,-0.82046262,-0.93140123,-1.0425933,-1.1557686,-1.2643309,-1.3600967,-1.462875,-1.5347029,-1.6114959,-1.6779722,-1.7556579,-1.8662877,-1.9576381,-2.0447892,-2.1529345,-2.2028672,-2.2608174,-2.2868261,-2.1974068,-2.1228264,-2.030725,-1.9254614,-1.8116645,-1.6999106,-1.6035009,-1.4900981,-1.3778582,-1.2639445,-1.1503915,-1.0358626,-0.9188309,-0.80082357,-0.6800616,-0.56660378,-0.44987848,-0.33140559,-0.22016587,-0.095654805,0.024671484,0.14749631,0.26746601,0.36952681,0.41893576,0.53500853,0.6629325,0.78503366,0.92084794,1.0484393,1.1307058,1.2528157,1.3888469,1.4731226,1.425234,1.3811872:5
0.92338117,0.82904364,0.76687933,0.6691883,0.57267936,0.52108821,0.42891928,0.38422699,0.30378231,0.25069987,0.21399456,0.19777964,0.18781433,0.17945971,0.17614031,0.17695095,0.18483422,0.19865294,0.2089848,0.2332598,0.25423746,0.28031215,0.29713131,0.3195021,0.3357059,0.36444334,0.41090283,0.45368656,0.49402562,0.53109134,0.57093243,0.60396124,0.63665394,0.67978529,0.70122924,0.73683356,0.77818958,0.81491168,0.84756153,0.89404887,0.92978614,0.96199838,0.99578946,1.0348961,1.0551715,1.0670691,1.0725976,1.0636463,1.0536351,1.0615366,1.0976569,1.1603185,1.2430382,1.3413391,1.3086642,1.2405064,1.166868,1.0817585,1.0843631,1.1232763,1.1819555,1.2289419,1.2858521,1.3374568,1.392257,1.4373158,1.476685,1.5146481,1.5445686,1.5658495,1.5869425,1.6015492,1.6176019,1.6372652,1.6689101,1.7030783,1.7610879,1.7502589,1.6602729,1.5584561,1.4727155,1.3831449,1.2787358,1.1847462,1.1042648,1.0003614,0.8887646,0.78507351,0.7105344,0.64002428,0.56468349,0.50462072,0.45130028,0.40675155,0.38320882,0.41787413,0.38389594,0.38306935,0.38188111,0.37600368,0.38958687,0.37478516,0.37983829,0.38101873,0.38069802,0.37481334,0.37814438,0.39088079,0.42009286,0.46072612,0.50973792,0.56429187,0.62507206,0.71419195,0.74358618,0.64501024,0.55582681,0.44283876,0.35082491,0.24576471,0.16291748,0.054752363,-0.045807928,-0.1339652,-0.24124786,-0.33660418,-0.42078719,-0.50698405,-0.60245703,-0.69161759,-0.77860252,-0.8728433,-0.95563512,-1.0376925,-1.1210694,-1.2053066,-1.2767911,-1.3276315,-1.3536397,-1.3740303,-1.3955851,-1.382316,-1.3616414,-1.3603646,-1.3449804,-1.3330706,-1.3072014,-1.2852165,-1.2504999,-1.2131151,-1.1775556,-1.1381187,-1.0981183,-1.0473111,-0.99895041,-0.9411291,-0.88353861,-0.83003213,-0.77109666,-0.70813862,-0.64869012,-0.5740818,-0.5075388,-0.43599663,-0.37162881,-0.38603055,-0.34970465,-0.27940385,-0.2130167,-0.12285771,-0.03679402,0.05002185,0.13859534,0.22874911,0.28047459,0.15906989,0.062635111,-0.033432899,-0.13077926,-0.22884976,-0.34581877,-0.41866136,-0.51062081,-0.6039612,-0.70399381,-0.78903693,-0.89739087,-1.0079759,-1.0991216,-1.204575,-1.3226788,-1.4312937,-1.4930468,-1.5267077,-1.5421478,-1.5455429,-1.5391611,-1.5130117,-1.4732653,-1.4262053,-1.3788845,-1.3213856,-1.2537837,-1.1584773,-1.1007696,-1.0048611,-0.90274652,-0.80758592,-0.72218841,-0.61605139,-0.520874,-0.42936797,-0.31757165,-0.24070229,-0.12355089,-0.034406667,0.08775602,0.19051948,0.30708912,0.42199447,0.52302383,0.603289,0.594668,0.67289638,0.76157257,0.86917721,0.94455363,1.0419956,1.1337441,1.0867774,1.0018597,0.93535696,0.8606972,0.77754854,0.71424051,0.64394684,0.59304482,0.5663893,0.58204057,0.6270955,0.70808472,0.79625287,0.88468058,0.9732554,1.0697932,1.1765129,1.2779361,1.3691792,1.4904376,1.5535863,1.6453679,1.7252431,1.6725133,1.7176208,1.8344471,1.9523498,1.9914988,1.8659854,1.7724096,1.6443728,1.587588,1.6331116,1.7479115,1.6849818,1.5926812,1.5004581,1.4080139,1.2876247,1.1894645,1.0975861,1.0067915,0.91228996,0.82480757,0.71315223,0.60888187,0.51854929,0.42910112,0.34171329,0.28149123,0.24451581,0.22428108,0.24501145,0.27598144,0.33089334,0.39019528,0.46242534,0.52249923,0.60677262,0.68188018,0.75194603,0.83692134,0.91726931,0.99914716,1.0946891,1.0143194,0.91270702,0.8112329,0.71179497,0.61411291,0.51652632,0.39453575,0.34210365,0.2950987,0.19741323,0.097587608,0.0017540265,-0.07495409,-0.17921445,-0.27855698,-0.37558572,-0.47260602,-0.59208713,-0.6974924,-0.78871362,-0.88678858,-1.0052206,-1.1052313,-1.2010344,-1.316685,-1.4067968,-1.473835,-1.5739901,-1.689696,-1.7959172,-1.9005609,-1.9998423,-2.0604174,-2.1051444,-2.1351669,-2.1485324,-2.1434336,-2.1237563,-2.0711443,-2.0048816,-1.8998722,-1.7857551,-1.670465,-1.5521962,-1.4549469,-1.3352571,-1.240435,-1.1306551,-1.0198198,-0.92079349,-0.82382659,-0.72637891,-0.62505623,-0.52518637,-0.42489525,-0.33065498,-0.2607836,-0.1727492,-0.05774369,0.048649473,0.14623325,0.16517942,0.094666035,0.021096358,-0.062488807,-0.1508096,-0.22951463,-0.30593209,-0.38010849,-0.45582956,-0.52193872,-0.58589395,-0.62795094,-0.59705551,-0.52485114,-0.44079334,-0.43294853,-0.37831103,-0.4790066,-0.56390076,-0.6429613,-0.70687301,-0.76388755,-0.83039608,-0.89116466,-0.94380713,-1.0064421,-1.0703399,-1.1221355,-1.1712254,-1.2328019,-1.2648357,-1.3091606,-1.3519703,-1.3886669,-1.4174824,-1.4452617,-1.4569936,-1.4817044,-1.4784829,-1.4819361,-1.4932872,-1.491292,-1.4923336,-1.443778,-1.4188496,-1.3741989,-1.330544,-1.2916764,-1.199768,-1.0898741,-1.0133011,-0.92055927,-0.83171278,-0.74427477,-0.66170562,-0.5749904,-0.48381505,-0.38728817,-0.29000001,-0.19825487,-0.10551555,-0.017955876,0.072069452,0.16371729,0.26356004,0.36667103,0.45964548,0.55457872,0.65150933,0.7284025,0.78418782,0.89535803:4
1.3203835,1.2207752,1.107498,1.018554,0.90101784,0.80594372,0.68242334,0.57964728,0.47156888,0.34803136,0.18856782,0.029097576,-0.08945398,-0.068254991,-0.033921812,-0.0998876,-0.2217203,-0.34619804,-0.50574508,-0.65938229,-0.78554573,-0.90769711,-1.0285065,-1.1849682,-1.2660195,-1.3840663,-1.4163149,-1.4915225,-1.4872238,-1.4039011,-1.3385262,-1.2637562,-1.1801604,-1.1532868,-1.0591758,-0.98459819,-0.88865645,-0.80417367,-0.72414565,-0.73164697,-0.62970165,-0.52265534,-0.41315217,-0.31796743,-0.23408068,-0.12193773,-0.029703147,0.068912654,0.1560299,0.16365613,0.097737587,0.047631611,-0.021237426,-0.027879668,0.082925686,0.18641627,0.29496113,0.31196785,0.4295329,0.52419693,0.6424083,0.75756526,0.74891986,0.74186241,0.76674989,0.87839593,0.99624717,1.1279104,1.2506565,1.3085852,1.3813768,1.4929155,1.5959298,1.7063165,1.8265179,1.9439927,2.0249329,1.9487886,1.8473891,1.7366495,1.6409372,1.5399813,1.4305313,1.3456978,1.2283443,1.1309988,1.0284207,0.93856706,0.8371344,0.84188866,0.8889857,0.81006146,0.72032205,0.64193282,0.51559182,0.42042444,0.32330052,0.28647307,0.28048743,0.19148284,0.083924309,-0.011076232,-0.10123786,-0.12902537,-0.08004445,-0.030277579,0.015919747,0.083877667,0.13443443,0.068963739,-0.021579747,-0.12045223,-0.19487547,-0.29771581,-0.38662736,-0.43144002,-0.54502523,-0.66669948,-0.7884021,-0.81592034,-0.87293012,-0.89484386,-0.8962942,-1.0199782,-1.1482818,-1.2841627,-1.3976639,-1.4341237,-1.5556264,-1.5266505,-1.5915436,-1.6650982,-1.6994579,-1.6245102,-1.6048957,-1.5378647,-1.4313209,-1.338374,-1.2341695,-1.1142645,-0.99296019,-0.94006219,-0.84153309,-0.72040158,-0.58921399,-0.46861781,-0.35702074,-0.22909936,-0.11936175,-0.029613011,-0.013065989,0.028742635,0.1011745,0.19382985,0.31327208,0.42552536,0.53925972,0.64592365,0.74779973,0.86523152,1.0101618,1.1206272,1.2650579,1.3954282,1.4823467,1.5051773,1.469181,1.4159102,1.3416552,1.2989133,1.2277404,1.1425312,1.051517,0.935082,0.80085279,0.76758611,0.71512683,0.62807086,0.5113279,0.39730809,0.27836411,0.31179462,0.35993543,0.28758375,0.1829836,0.098319752,0.032993052,0.054601802,0.022825535,-0.080565494,-0.17685899,-0.27315393,-0.23257448,-0.1401322,-0.025332422,0.065437036,0.038028306,-0.038240763,-0.075339447,-0.16637443,-0.20017967,-0.26164121,-0.34243695,-0.42799481,-0.43790265,-0.47641121,-0.55070846,-0.62816753,-0.6951496,-0.80220289,-0.86900187,-0.89651823,-0.82729793,-0.70874664,-0.61783277,-0.50909939,-0.43366306,-0.3024474,-0.21676914,-0.23100399,-0.24230604,-0.22150208,-0.28133278,-0.32760773,-0.38161654,-0.29870072,-0.28132939,-0.34398623,-0.4122741,-0.49384638,-0.56535051,-0.53772829,-0.61795379,-0.68736462,-0.76946593,-0.74493618,-0.78671545,-0.83856426,-0.88243265,-0.93128809,-0.95883191,-0.99939398,-1.0543588,-1.117752,-1.1871601,-1.2493352,-1.3062828,-1.356517,-1.4127113,-1.4710274,-1.5219914,-1.5757739,-1.6285935,-1.6709025,-1.5899995,-1.471294,-1.3634489,-1.2813309,-1.1706567,-1.0574838,-0.93233598,-0.81831616,-0.74324795,-0.6637125,-0.5653192,-0.4524907,-0.33956278,-0.21780203,-0.11412563,0.010897505,0.13156861,0.18508248,0.30827203,0.42929427,0.54045263,0.66717403,0.6857164,0.79129106,0.89980097,1.0160216,1.1389948,1.2444785,1.3558407,1.4879224,1.5920733,1.7260377,1.7653313,1.8311448,1.9479122,2.0656561,2.182937,2.2922304,2.4073906,2.5333105,2.661152,2.7914267,2.7554134,2.6751551,2.5696184,2.4595863,2.329187,2.2096017,2.0928482,1.9774518,1.8515855,1.7465654,1.6205784,1.5035873,1.3960778,1.2787282,1.154642,1.0515902,0.93297243,0.81140781,0.70366795,0.59579917,0.45741394,0.35306294,0.24290939,0.11205744,0.012863558,-0.1260031,-0.23286209,-0.33935401,-0.47473649,-0.5818717,-0.69238167,-0.80045007,-0.92958097,-0.96361916,-1.0538857,-1.1617472,-1.1526353,-1.2472037,-1.2895249,-1.3659129,-1.4805438,-1.5925882,-1.6877503,-1.7570749,-1.723089,-1.6966653,-1.6487677,-1.6015816,-1.5415615,-1.4730816,-1.4116394,-1.3288926,-1.2517702,-1.1684597,-1.0896718,-1.0132702,-0.92575998,-0.84979373,-0.81254008,-0.76197662,-0.71391686,-0.6750398,-0.77087551,-0.74609351,-0.66506876,-0.59762499,-0.50187071,-0.44132907,-0.34563078,-0.27119601,-0.22773196,-0.28722971,-0.21882883,-0.13411722,-0.1065778,-0.043850319,0.021810935,0.062297165,0.018905202,-0.071158238,-0.16156961,-0.23460574,-0.30754699,-0.41108304,-0.49851022,-0.61419132,-0.55871611,-0.48362961,-0.42143882,-0.37823454,-0.36708505,-0.35448359,-0.36055949,-0.39849475,-0.32362461,-0.24556049,-0.17907751,-0.1788539,-0.090045855,-0.052877478,1.7910378E-4,0.07092877,0.10111397,-0.011611439,-0.046384965,-0.11300726,-0.069642581,-0.015858837,0.06555352,0.14091151,0.15569998,0.24951948,0.33048617,0.39819794,0.43992041,0.3703459,0.41651786,0.49146155,0.58723972,0.66760654,0.74655096,0.84168112,0.90690984,0.93720175,1.0118651,1.0762757,1.1234284,1.1781195,1.2412533,1.2920107,1.3317902:3
1.5474376,1.4354944,1.3292051,1.1877848,1.0456424,0.89257913,0.77029965,0.65632045,0.52295149,0.51055476,0.52775119,0.45051171,0.27051006,0.13447296,-0.0063388277,-0.16627804,-0.31291001,-0.19966311,-0.21140807,-0.24394567,-0.13592477,-0.16960878,-0.26947503,-0.35245785,-0.50048854,-0.65104706,-0.75632204,-0.90194866,-1.0521311,-1.190584,-1.1979926,-1.1210008,-0.98771045,-0.8509456,-0.77534207,-0.64585919,-0.50086353,-0.37452799,-0.29591003,-0.36879642,-0.49203038,-0.60201825,-0.71231636,-0.81089859,-0.77762471,-0.75958834,-0.86821107,-0.97683772,-1.0980817,-1.1630335,-1.259856,-1.2924984,-1.3856231,-1.3879773,-1.4514829,-1.5216822,-1.6085966,-1.7051625,-1.7973226,-1.7894459,-1.8891467,-1.8957933,-1.9948612,-2.0513729,-2.1481581,-2.1684972,-2.1002995,-2.0184144,-2.0745366,-2.0027571,-1.8897094,-1.7456655,-1.5576968,-1.370905,-1.183085,-1.0375575,-0.85658084,-0.66831298,-0.55302055,-0.51147365,-0.40116424,-0.22560595,-0.084765333,0.016643062,0.14289277,0.25049328,0.35130024,0.52693037,0.62430604,0.76186524,0.85095954,1.0078362,1.1466188,1.3028281,1.4269029,1.5223718,1.6923026,1.837188,1.9388858,1.9882848,1.957236,1.8991606,1.8221668,1.7331777,1.6383232,1.5647146,1.4447874,1.3555842,1.3503311,1.2682874,1.1829627,1.0765533,0.99830746,0.95982869,1.0259119,1.0039623,0.9482665,0.88537192,0.82394798,0.72032865,0.64899685,0.65480609,0.59161893,0.52930645,0.45473047,0.44991808,0.4202273,0.35169831,0.33347191,0.39985877,0.49232568,0.64358184,0.75792225,0.76917954,0.72120322,0.64867437,0.63941868,0.582337,0.53575757,0.60631868,0.56743499,0.5029285,0.46054377,0.44050693,0.49940453,0.51392404,0.44243919,0.33712299,0.27716127,0.1938484,0.15580324,0.1266411,0.19303719,0.23681398,0.3737868,0.51450449,0.68826679,0.84269245,0.98845194,1.1320857,1.2610413,1.3974664,1.388611,1.2929352,1.1968789,1.1145294,1.0337175,1.0205288,0.98064818,0.89298075,0.77499699,0.70363686,0.70742186,0.75643038,0.68833615,0.63699237,0.58519781,0.49785581,0.4237698,0.35533169,0.28236667,0.18802066,0.12144031,0.083964151,0.22425029,0.39615515,0.4676671,0.57179879,0.52740361,0.4758952,0.3995865,0.3597457,0.24634584,0.16265673,0.055607468,-0.076238688,-0.20565699,-0.30174363,-0.40410817,-0.50741552,-0.62013922,-0.69935932,-0.78180352,-0.74473718,-0.61100217,-0.5624249,-0.4733371,-0.51249052,-0.59761318,-0.74833216,-0.86927705,-0.74976508,-0.79718082,-0.7085446,-0.75273091,-0.71488753,-0.71679589,-0.79825638,-0.71220623,-0.70226693,-0.64038109,-0.5067054,-0.39758913,-0.32775425,-0.3354051,-0.22855453,-0.17093453,-0.042887761,0.058889628,0.12991046,0.23510086,0.30382703,0.36536121,0.40837004,0.43794471,0.30424636,0.18186103,0.18468362,0.24961652,0.3155598,0.3956465,0.49647246,0.59006153,0.66546691,0.71809561,0.67956167,0.55170545,0.4563948,0.50757203,0.58581907,0.63182684,0.7184414,0.79297547,0.73662948,0.73069152,0.79424085,0.87828862,0.95368374,0.99686364,1.0716979,1.1187091,1.1097395,0.98554673,0.84162276,0.69600671,0.5756044,0.45296473,0.29891046,0.15943556,0.061383846,-0.12348593,-0.26719783,-0.35928747,-0.44957488,-0.44824036,-0.43824173,-0.40453025,-0.34598313,-0.29453515,-0.25296138,-0.2152518,-0.14237353,-0.085176915,-0.11405412,-0.13739356,-0.064168646,0.046805243,0.15862598,0.24011819,0.30933739,0.39981039,0.45456763,0.53824766,0.6050213,0.61261891,0.49925526,0.31594365,0.18227347,0.10164152,0.053929163,0.12141094,0.20117784,0.28021877,0.36051685,0.35417129,0.45539152,0.5556463,0.67107822,0.7431707,0.8373411,0.86627626,0.81826987,0.75533011,0.71792351,0.81817846,0.9240173,1.0099473,1.0481632,1.1579286,1.2801597,1.3684219,1.3731644,1.4547605,1.5290518,1.6288607,1.7437375,1.810691,1.7830978,1.6512236,1.5224187,1.3901416,1.2620434,1.124728,1.0009956,0.85445083,0.72447373,0.62355718,0.57276229,0.45755009,0.3106383,0.19036415,0.05629895,-0.068271977,-0.19653443,-0.2925664,-0.40099453,-0.47103742,-0.5988465,-0.64463308,-0.70066045,-0.84016367,-0.9768034,-1.1050863,-1.1900801,-1.276275,-1.365913,-1.5045695,-1.6540307,-1.7871643,-1.9184751,-2.054126,-2.1704856,-2.3076884,-2.4181145,-2.5666557,-2.6944678,-2.7165389,-2.5937199,-2.4596041,-2.3183408,-2.1862653,-2.0335703,-1.8982383,-1.84306,-1.8532263,-1.8213523,-1.9006758,-1.7351258,-1.5912335,-1.418468,-1.2452184,-1.0931149,-1.0677868,-1.067691,-0.91517241,-0.81730796,-0.74241394,-0.6046833,-0.52559038,-0.46380656,-0.49331385,-0.60832661,-0.73256669,-0.85682432,-0.93459166,-1.0235713,-1.1087849,-1.1481506,-1.1786592,-1.0557581,-0.95245392,-0.82511611,-0.7111242,-0.6141439,-0.61731874,-0.60111766,-0.4854846,-0.37731871,-0.23981116,-0.1224642,-0.0034290044,0.096855489,0.056155392,0.070060339,0.19970624,0.31467513,0.45262005,0.58451194,0.7077074,0.80062115,0.83838964,0.93540887,1.0548881,1.1410169,1.2696229,1.401671,1.496725:3
2.6337711,2.4961967,2.3698068,2.2356303,2.091093,1.9572664,1.8125923,1.6725398,1.541884,1.3995954,1.2591943,1.1162923,0.97978084,0.85818702,0.72950447,0.58766052,0.44325983,0.32322767,0.17504838,0.064667975,-0.08718275,-0.20330676,-0.29358456,-0.41431544,-0.53595794,-0.66765003,-0.82477191,-0.93616579,-1.0924117,-1.1385234,-1.2732265,-1.357254,-1.4396308,-1.4437274,-1.5049321,-1.4679645,-1.4094499,-1.3437852,-1.2860388,-1.2150417,-1.0889151,-1.0126151,-0.99341759,-0.89950633,-0.79410015,-0.71566052,-0.64990064,-0.6216329,-0.60565854,-0.6133734,-0.62060131,-0.64869327,-0.66606257,-0.54993783,-0.55632644,-0.45917734,-0.36825965,-0.29112376,-0.22686294,-0.15543965,-0.098044479,-0.043944952,-0.030461762,0.049345988,0.10772291,0.20365781,0.31333366,0.40172382,0.48650318,0.58895398,0.6660369,0.76754897,0.82012611,0.7029237,0.57011807,0.45106197,0.38359203,0.23653966,0.052843335,-0.09428316,-0.19532849,-0.1313936,-0.074260609,-0.02509939,0.030810515,0.094646982,0.075683866,0.01249229,-0.13688606,-0.18774918,-0.14140098,-0.10559427,-0.059424151,-0.097676011,-0.034771765,0.022389041,0.085500419,0.14706993,0.11938307,0.055437998,-0.021358379,-0.12359479,-0.13571992,-0.14667711,-0.10331298,-0.0089225858,0.15234878,0.25369175,0.29165336,0.46400646,0.5817936,0.69994918,0.77637642,0.78301016,0.67401396,0.55463064,0.57924455,0.68976251,0.76065981,0.86544001,0.94682955,1.028447,1.1418513,1.2939727,1.4183678,1.5285116,1.5941485,1.5525477,1.4390569,1.3037314,1.1173,0.9891224,0.84706864,0.72710142,0.5839272,0.47699471,0.37609161,0.21685888,0.029255875,-0.13880309,-0.26956494,-0.2781851,-0.34669709,-0.47043166,-0.6245479,-0.76995896,-0.92535681,-1.1179063,-1.2719089,-1.4154373,-1.5443955,-1.7380139,-1.8702604,-2.0075482,-2.0014594,-1.925946,-1.8309143,-1.7302121,-1.5775886,-1.4744717,-1.3511701,-1.2090708,-1.1179265,-1.0199144,-0.95742483,-0.99278794,-1.0589643,-1.065097,-1.0336956,-0.92794388,-0.82174378,-0.69271857,-0.56644234,-0.44359233,-0.37727639,-0.3863003,-0.25435395,-0.12439247,-0.10722189,-0.074278211,0.043327537,0.12490748,0.10890942,0.0013732449,-0.04433088,-0.062266987,-0.11114432,-0.16029083,-0.15451767,-0.030498198,0.074302754,0.19251088,0.30569817,0.38834507,0.5309338,0.59589887,0.64804769,0.61483391,0.59194596,0.70600901,0.85719656,0.94257464,1.0619976,1.2000005,1.2742531,1.3092336,1.4192174,1.5661935,1.6882031,1.843745,1.9717503,2.1000726,2.1183126,1.9952318,1.8600914,1.7239236,1.5839864,1.4361458,1.3037359,1.2166865,1.1777192,1.0500885,0.91234828,0.78402194,0.77281002,0.73116172,0.59714856,0.47814705,0.34066178,0.21931164,0.10114105,0.05744386,-0.066534035,-0.18093395,-0.30944867,-0.41557972,-0.51572859,-0.57685782,-0.65932872,-0.77816507,-0.783253,-0.73349209,-0.68149006,-0.67996682,-0.72328508,-0.76613804,-0.87342934,-0.95690679,-1.0600829,-1.1756332,-1.2334444,-1.2775509,-1.352079,-1.4616173,-1.5676319,-1.6578168,-1.7452588,-1.8231671,-1.9068618,-1.9740381,-1.9180665,-1.8250757,-1.691234,-1.5734363,-1.4441265,-1.3136993,-1.1807658,-1.0519659,-0.93886731,-0.78410531,-0.63680422,-0.50605164,-0.43127218,-0.41490455,-0.42712149,-0.28233575,-0.1371226,0.035802921,0.16820085,0.34742466,0.50182766,0.62180423,0.72028033,0.74843626,0.88070473,1.0399424,1.1716141,1.3473837,1.5305632,1.7002061,1.8287031,1.8412924,1.766737,1.6868681,1.622704,1.5454504,1.4310908,1.2618345,1.144644,1.0313825,0.91375456,0.78672271,0.6749039,0.60568242,0.72052939,0.73237997,0.67327217,0.55625161,0.46393546,0.37697304,0.29020192,0.26014032,0.19096639,0.11462289,-0.0024108791,-0.090495842,-0.047936733,0.097415394,0.23901713,0.19049856,0.12412874,0.051569305,-0.011892571,-0.11241249,-0.19913827,-0.3186912,-0.37787997,-0.49076924,-0.41384585,-0.39365413,-0.38936462,-0.4251593,-0.49276202,-0.50096265,-0.50331704,-0.53614082,-0.36479859,-0.22220385,-0.052403649,0.080783151,0.24393818,0.30972812,0.44962852,0.58480026,0.70439969,0.69456583,0.63148196,0.56230172,0.5919306,0.48097209,0.39491335,0.4103281,0.3743188,0.27420504,0.17427265,0.089133218,0.19495157,0.20967678,0.13438649,0.041497895,-0.080394766,-0.1707544,-0.28984173,-0.39147743,-0.49296056,-0.55111798,-0.40539946,-0.35817229,-0.38003311,-0.42543756,-0.50335304,-0.53815292,-0.5976587,-0.64854066,-0.75160701,-0.83940326,-0.91587179,-1.0304585,-1.1037713,-1.2046313,-1.2496953,-1.3363149,-1.3849872,-1.3122734,-1.4265592,-1.4649926,-1.5137577,-1.4798042,-1.5489421,-1.5567448,-1.5796045,-1.6246969,-1.6197804,-1.5685016,-1.5413586,-1.5760452,-1.5239066,-1.4202907,-1.2841197,-1.1426899,-0.99581336,-0.87204176,-0.72611659,-0.59301121,-0.45476039,-0.32360014,-0.19007097,-0.060693196,0.079377113,0.23219043,0.34531258,0.49468262,0.631629,0.75829657,0.89943369,1.0417895,1.1837926,1.315449,1.4498598,1.5953803,1.742287,1.882361,2.0393994,2.1756381,2.3081278,2.4563604,2.5787332:3
1.7340471,1.6992727,1.6781273,1.6316501,1.5427534,1.4681943,1.363736,1.2734896,1.1858271,1.1130108,1.0553432,0.99719726,0.9279331,0.83976186,0.73863728,0.65112511,0.58929582,0.48983025,0.39033214,0.30289304,0.23591223,0.22636927,0.28445193,0.30645233,0.22502094,0.15163047,0.0834721,-0.0035815461,-0.10052587,-0.20299419,-0.30134858,-0.39594048,-0.48523928,-0.58408992,-0.61916277,-0.68070812,-0.73938528,-0.82676086,-0.92548554,-0.99058136,-1.0448314,-1.1187308,-1.1778078,-1.2620282,-1.347293,-1.4329509,-1.4799777,-1.5540428,-1.6170859,-1.5486603,-1.4908831,-1.4819556,-1.4269937,-1.3152434,-1.2303641,-1.2081038,-1.1168014,-1.0438571,-0.94158884,-0.8343458,-0.71856848,-0.61146501,-0.50432405,-0.39879556,-0.26713378,-0.14759331,-0.095286715,-0.03347812,0.088154025,0.18859526,0.29305204,0.41940058,0.52175931,0.59862439,0.68169019,0.74745455,0.81663039,0.91014906,0.9864208,1.084397,1.110676,1.240713,1.3143468,1.4318141,1.4892402,1.5905902,1.663381,1.7232746,1.7180478,1.6606694,1.6064482,1.5613634,1.505294,1.4730677,1.4188924,1.3742394,1.348684,1.2704854,1.1993439,1.1461103,1.1074033,1.0572028,0.9823412,0.91844536,0.88034805,0.81967821,0.79168991,0.73650478,0.64596114,0.60458697,0.55420013,0.60064237,0.67048258,0.73578657,0.74674299,0.7161312,0.69951981,0.65160979,0.5584715,0.49239185,0.38253283,0.28105445,0.19287661,0.11713659,0.05962637,-0.034084899,-0.098585934,-0.19712007,-0.26297206,-0.34304857,-0.41731602,-0.51992144,-0.57779312,-0.63962109,-0.60386337,-0.65245039,-0.63520096,-0.61807492,-0.55259365,-0.46248589,-0.36206874,-0.28468339,-0.18306746,-0.11942196,-0.014654558,0.034564148,-0.018545289,-0.095931859,-0.1834798,-0.26949839,-0.3146024,-0.39725558,-0.46599456,-0.55079163,-0.60964185,-0.67477157,-0.73854345,-0.8216997,-0.90960894,-0.99728277,-1.104773,-1.090203,-1.1559791,-1.1761555,-1.2390378,-1.3080767,-1.374449,-1.4543173,-1.5473815,-1.6233155,-1.715777,-1.8264915,-1.7921071,-1.8012753,-1.7230651,-1.6162803,-1.5862637,-1.5074424,-1.4814687,-1.4220709,-1.3766359,-1.2945367,-1.2620377,-1.2049121,-1.127655,-1.0570516,-0.96874872,-0.87757909,-0.78719866,-0.72193849,-0.65957974,-0.56473439,-0.47188387,-0.38244868,-0.27045889,-0.19673854,-0.08935659,0.0030020352,0.062156734,0.15398062,0.22218542,0.29580627,0.38948405,0.48122821,0.59262073,0.69320403,0.79801685,0.90376694,1.0160068,1.1012643,1.2011241,1.2972795,1.4067664,1.5031738,1.589034,1.6764463,1.7156804,1.7061627,1.6688408,1.5921198,1.500651,1.4042962,1.31191,1.2118106,1.1111512,1.0165485,0.92355353,0.82073355,0.7170972,0.62936492,0.52514128,0.42648008,0.33135892,0.23811044,0.1434618,0.052528998,-0.042575749,-0.13921283,-0.2402243,-0.33416275,-0.42618317,-0.52144725,-0.61749539,-0.71326175,-0.81532749,-0.90273223,-0.9912965,-1.0953044,-1.1952409,-1.2896911,-1.3878117,-1.4825348,-1.4970608,-1.4616944,-1.4534879,-1.406143,-1.343787,-1.2699284,-1.2194447,-1.1677468,-1.0990686,-1.0559679,-1.0122311,-0.96961005,-0.8966763,-0.81270458,-0.76248485,-0.68634212,-0.73143026,-0.65806749,-0.59536248,-0.50772989,-0.44450428,-0.43518711,-0.51803737,-0.61150384,-0.70470949,-0.7915759,-0.89272084,-0.97444021,-1.0656974,-1.1619655,-1.2488271,-1.3357928,-1.3643061,-1.3828965,-1.3657313,-1.3262207,-1.2716913,-1.1936821,-1.1222968,-1.0360369,-0.94574948,-0.85120377,-0.75392154,-0.65630375,-0.55791227,-0.45935409,-0.35585415,-0.2698851,-0.18525871,-0.095751557,-0.024371642,0.050371478,0.12683955,0.1924323,0.25729599,0.3394519,0.42176796,0.48919293,0.56326599,0.60422946,0.55245364,0.49903633,0.45777748,0.42645726,0.39786522,0.37755928,0.41555148,0.4864788,0.56517958,0.64233053,0.71881929,0.7924193,0.86561445,0.94431298,1.0198754,1.0846696,1.1285222,1.1652021,1.2206454,1.2871794,1.3428886,1.4006565,1.3995499,1.4827449,1.5778236,1.6505021,1.7425526,1.7707003,1.7001354,1.5910687,1.5029171,1.4117867,1.3061577,1.2036762,1.1130716,1.0094707,0.90049312,0.80130057,0.70603888,0.59983271,0.52936733,0.45642657,0.38151803,0.30090772,0.19531396,0.10669656,0.012085429,-0.085516236,-0.18009316,-0.27967588,-0.37323428,-0.45794877,-0.5528589,-0.64900092,-0.74100218,-0.83042751,-0.93243181,-1.0297549,-1.0885762,-1.1413258,-1.2327756,-1.3235142,-1.4156905,-1.5022759,-1.5945908,-1.6388948,-1.6350019,-1.7010169,-1.6495064,-1.5835266,-1.4881578,-1.4023756,-1.2807764,-1.1729808,-1.0763179,-0.96401992,-0.86738625,-0.73903151,-0.61446188,-0.48974481,-0.3658894,-0.2716802,-0.15353769,-0.084656228,0.0089155112,0.13717088,0.2511396,0.34452958,0.44621621,0.5255015,0.60147901,0.6838122,0.76081684,0.81400573,0.79676959,0.76176872,0.76552955,0.76523446,0.752599,0.81263597,0.83504931,0.92525717,1.0189513,1.1135743,1.1920205,1.2650585,1.3297779,1.3861122,1.4280568,1.4940442,1.5345112,1.6110715,1.6716524,1.6969351,1.7276787:5
2.140268,2.09542,2.0021869,1.9131375,1.8079227,1.7511469,1.7327034,1.714192,1.7046942,1.6985812,1.6842055,1.6629272,1.6344796,1.612967,1.5989681,1.5775499,1.5652414,1.5408133,1.5113566,1.4830835,1.4430079,1.4023204,1.3692835,1.315208,1.2626307,1.2121168,1.149629,1.0640634,1.0319416,1.0070764,0.93487482,0.86347622,0.77967839,0.70586205,0.63017356,0.59339837,0.5402918,0.47881375,0.4221504,0.35654262,0.31112873,0.25888378,0.21005126,0.14977176,0.11606133,0.094482518,0.085694426,0.095701559,0.106756,0.12377574,0.14151134,0.16205082,0.18513667,0.19958454,0.12022429,0.058410639,0.023497831,0.015496095,0.016828354,0.027392389,0.049410512,0.081456377,0.045443435,-0.014786281,-0.080494,-0.14384002,-0.20307211,-0.27321832,-0.37155646,-0.46178256,-0.48995473,-0.53145095,-0.57946989,-0.6395275,-0.70099507,-0.75793536,-0.81599579,-0.8591723,-0.92667188,-1.0081876,-1.0993554,-1.1722614,-1.2441542,-1.3258695,-1.391044,-1.4592287,-1.5168062,-1.5786572,-1.6285883,-1.6670273,-1.7065672,-1.7334747,-1.7195546,-1.6931972,-1.6641041,-1.6263646,-1.581999,-1.527246,-1.4702514,-1.4146939,-1.3568327,-1.3017585,-1.2534871,-1.2083154,-1.1606745,-1.1116399,-1.0607516,-1.009206,-0.95340935,-0.89004141,-0.82066405,-0.77452841,-0.83945795,-0.84717607,-0.81003698,-0.74290496,-0.67081866,-0.60608647,-0.52494457,-0.45255948,-0.37605627,-0.31291942,-0.24756314,-0.20762091,-0.11911025,-0.10045764,-0.09467993,-0.1894568,-0.26652782,-0.34824625,-0.4293912,-0.50456568,-0.58248183,-0.58758015,-0.5995512,-0.68020553,-0.76206601,-0.83044855,-0.91939272,-0.99280818,-1.0717406,-1.1531206,-1.2282501,-1.300326,-1.3783774,-1.451746,-1.5318259,-1.6044215,-1.6649382,-1.6786819,-1.6674996,-1.6471423,-1.6228156,-1.5819792,-1.5122761,-1.4183022,-1.3123878,-1.2037325,-1.0968996,-1.0149949,-0.93168678,-0.84736495,-0.73806762,-0.62610387,-0.51467196,-0.4260435,-0.31431473,-0.20349276,-0.093299825,-0.035233299,-0.10727955,-0.061915941,-0.11666967,-0.082049995,-0.020158534,0.061509345,0.1490207,0.23706825,0.34887882,0.44472453,0.52725827,0.61796857,0.72870059,0.6966279,0.60827693,0.54084338,0.46199493,0.3997851,0.40246436,0.35611052,0.28584567,0.21028239,0.15132508,0.092226472,0.03582244,-0.0036539799,-0.040062755,-0.067731709,-0.099940487,-0.10389062,-0.058863808,0.011725591,0.078867655,0.15494054,0.24809317,0.3354938,0.41549922,0.50536565,0.59662721,0.68829245,0.7728286,0.7687394,0.76077796,0.82284808,0.90189877,0.97330717,1.0486013,1.1332079,1.1697594,1.1805007,1.0790167,1.0607591,1.1259251,1.1973311,1.265079,1.3414647,1.4230663,1.4999556,1.5673173,1.6280144,1.6970013,1.7733121,1.8344776,1.779912,1.7070966,1.6250786,1.5483346,1.4690795,1.3793231,1.316191,1.3351254,1.2432264,1.1614512,1.0799169,0.99173854,0.90115434,0.79805764,0.71019524,0.62320478,0.53573437,0.44931893,0.34855327,0.28931011,0.2390742,0.25385283,0.31501523,0.37936289,0.46403753,0.54239711,0.61516207,0.69052055,0.76972256,0.84049551,0.77102747,0.69806165,0.61007355,0.52627617,0.44415917,0.35871918,0.28964794,0.20672609,0.12580521,0.05091341,0.082712195,0.047011124,-0.026722396,-0.10759243,-0.17718211,-0.26409782,-0.33615078,-0.41113843,-0.48880756,-0.56828847,-0.64288937,-0.71708104,-0.79934488,-0.87427336,-0.9512952,-1.0198293,-1.1004812,-1.1644561,-1.2258853,-1.2733225,-1.2870897,-1.2921669,-1.2868413,-1.2658744,-1.2322992,-1.1606588,-1.0852954,-1.0167822,-0.93719806,-0.85892714,-0.77109904,-0.69218739,-0.58252115,-0.47153916,-0.36026029,-0.26939407,-0.19524261,-0.24633112,-0.28575457,-0.35405449,-0.42361263,-0.48903348,-0.55119126,-0.60935321,-0.66328639,-0.70674178,-0.75997221,-0.80474366,-0.83136635,-0.80829985,-0.73676155,-0.79865113,-0.88029251,-0.95759624,-1.0175668,-1.0753524,-1.1209404,-1.1670577,-1.2151247,-1.2577615,-1.2920525,-1.3320319,-1.3618308,-1.3835552,-1.401069,-1.4149383,-1.420009,-1.4260123,-1.4274792,-1.4083924,-1.3845826,-1.3487432,-1.3122069,-1.2677461,-1.2207294,-1.137439,-1.0443691,-0.96514455,-0.88193948,-0.80487473,-0.73339981,-0.65756441,-0.5934175,-0.5099372,-0.44824078,-0.38127245,-0.30606193,-0.30384554,-0.30912376,-0.31663063,-0.31389668,-0.30894429,-0.29516466,-0.2723028,-0.21797476,-0.15580496,-0.16976208,-0.17351565,-0.17131956,-0.16878746,-0.15893282,-0.14617353,-0.12738211,-0.10164003,-0.077194353,-0.057154728,-0.0099832308,0.032234033,0.07031188,0.1168094,0.16340914,0.21908969,0.28152129,0.36708079,0.47756094,0.54722589,0.60005354,0.65282554,0.69323297,0.73021513,0.77283231,0.80219154,0.82756726,0.86179294,0.90188315,0.9484878,0.9932875,1.0485058,1.0908212,1.1359467,1.1781227,1.2220072,1.2656151,1.3064299,1.3388478,1.3810374,1.4118018,1.4422869,1.4801855,1.5139624,1.5524276,1.5897825,1.6260587,1.6641776,1.6986748,1.7224514,1.7418921,1.7634406,1.8008815,1.847257,1.9025526,1.9785202,2.0657469,2.1227804:4
1.4936254,1.4626348,1.4020754,1.3650404,1.3101026,1.2621036,1.2129512,1.1595493,1.0946711,1.0348053,0.97532002,0.90276919,0.82601705,0.74531655,0.67675414,0.58210746,0.49206437,0.38195396,0.27479046,0.17863401,0.084269531,-0.044027673,-0.17640152,-0.30855086,-0.43882237,-0.56871435,-0.70551867,-0.80811844,-0.89973416,-0.95330361,-0.86190272,-0.76643187,-0.67108915,-0.57091498,-0.48378835,-0.38930183,-0.30020391,-0.20418858,-0.099127343,-0.021399649,0.074366246,0.15957659,0.25685135,0.35062167,0.42907153,0.51495962,0.6142234,0.70432563,0.76317297,0.72322364,0.67899654,0.59647511,0.49953118,0.43600231,0.34759325,0.23530528,0.1539027,0.083721431,0.12715027,0.17715713,0.19284637,0.12610965,0.03256182,-0.057670299,-0.14219082,-0.24201212,-0.32865859,-0.42071122,-0.51117274,-0.60205093,-0.69150148,-0.78452492,-0.87618229,-0.97479854,-1.0468398,-1.1412992,-1.2335825,-1.3265762,-1.4202317,-1.5103755,-1.6052499,-1.6811604,-1.7642815,-1.8460623,-1.9173746,-1.9889324,-2.0572162,-2.1084596,-2.1139327,-2.1680118,-2.0931123,-1.9835685,-1.8824169,-1.7709856,-1.6630356,-1.5672484,-1.4584934,-1.3716598,-1.2577028,-1.1222918,-1.0193973,-0.90147375,-0.79172072,-0.68297003,-0.54207146,-0.41953066,-0.29238416,-0.15207503,-0.012902842,0.088467991,0.18594991,0.23967578,0.23532974,0.20490474,0.16939606,0.13444854,0.10299149,0.059595825,0.013101974,-0.033556054,-0.093603965,-0.13876622,-0.1659263,-0.12965302,-0.04677381,0.0011888486,-0.0079337375,-0.036983122,-0.08083534,-0.1319596,-0.17998327,-0.25211685,-0.2910075,-0.3670904,-0.4273656,-0.48817832,-0.56167102,-0.5939632,-0.62580421,-0.68744109,-0.71366095,-0.70760744,-0.75539674,-0.72858448,-0.65475132,-0.5479622,-0.4439861,-0.34507447,-0.2606492,-0.17177662,-0.075527576,-0.012792997,0.042588108,0.06077813,0.049283378,0.10397794,0.17164992,0.22349943,0.2881782,0.34239046,0.38149361,0.43835321,0.49035682,0.51507921,0.53208354,0.56189122,0.58229899,0.58055306,0.63584164,0.76057554,0.89154474,0.98159355,1.0691669,1.1196624,1.1461057,1.1679702,1.2081836,1.2407721,1.2745068,1.2836785,1.3283388,1.3534294,1.3550839,1.3636236,1.3643417,1.4567073,1.595682,1.7069112,1.8134734,1.9264706,2.0355774,2.1754983,2.3115328,2.3828228,2.4591014,2.4743649,2.4655181,2.4274658,2.3591494,2.298088,2.2168924,2.125125,2.0489508,1.9704624,2.0153996,1.9597423,1.8967911,1.7568837,1.6173341,1.5132359,1.387973,1.2820375,1.2365765,1.2142918,1.1900649,1.1322422,1.0947135,1.0496145,0.99497044,0.94952332,0.91135911,0.8538322,0.81456714,0.76064617,0.69921096,0.64216101,0.60406799,0.5576284,0.50973594,0.463794,0.42423995,0.3858872,0.35005767,0.29427226,0.26958704,0.23253424,0.18212788,0.14655253,0.12537574,0.10740924,0.088975472,0.082028314,0.066629096,0.050828082,0.026856692,-0.002743719,-0.056211571,-0.11087206,-0.23233429,-0.33148166,-0.34673922,-0.36177943,-0.36438168,-0.37209897,-0.37193155,-0.38105397,-0.38344539,-0.40395638,-0.41881377,-0.44627021,-0.48494026,-0.56041039,-0.61450345,-0.69670459,-0.7951347,-0.91305162,-1.0209957,-1.1276584,-1.2295565,-1.3488433,-1.4578417,-1.5557055,-1.6294409,-1.7140851,-1.775297,-1.823344,-1.9058017,-1.8912827,-1.8906337,-1.8223305,-1.8391552,-1.794841,-1.7395498,-1.6832731,-1.6494557,-1.5901083,-1.5478347,-1.4813171,-1.4084918,-1.336526,-1.2781555,-1.200019,-1.1154631,-1.0267791,-0.93952387,-0.84915057,-0.79013549,-0.73036113,-0.6866876,-0.6577889,-0.62742459,-0.57051267,-0.49263129,-0.41228321,-0.33290098,-0.24391216,-0.1432839,-0.058526261,0.026919715,0.10974147,0.17865344,0.23985318,0.2998972,0.34148458,0.34005862,0.27203221,0.18661586,0.11584256,0.086056652,0.15144898,0.22310739,0.29081237,0.35645934,0.40998828,0.45248594,0.48989846,0.49930412,0.49970882,0.41503946,0.32858495,0.20503778,0.11746012,-0.016250708,-0.11814677,-0.25019007,-0.37674922,-0.49236556,-0.60168674,-0.7139321,-0.82290955,-0.93231725,-1.0446718,-1.136973,-1.2482938,-1.3592529,-1.4601274,-1.5619912,-1.6588694,-1.5849623,-1.532877,-1.4654938,-1.3970446,-1.36895,-1.2647493,-1.1712879,-1.0755518,-0.98306629,-0.88779759,-0.7916948,-0.69781178,-0.60358868,-0.50617864,-0.41813708,-0.3355336,-0.22561888,-0.14659957,-0.093304049,-0.052234937,0.0086615803,0.084408372,0.19870361,0.30069445,0.40450354,0.49707225,0.56514795,0.60207012,0.6403932,0.63122093,0.55386546,0.46685401,0.38477704,0.29803777,0.21254741,0.12899953,0.033564514,-0.052850673,-0.14425176,-0.24829442,-0.31791706,-0.41446075,-0.50809969,-0.58138849,-0.65662991,-0.62413519,-0.49283707,-0.39688309,-0.28666765,-0.17732725,-0.062142708,0.047429875,0.15192343,0.28911458,0.4234171,0.5610566,0.69407717,0.82861132,0.94633778,1.0480108,1.1165005,1.1974974,1.2582574,1.2365682,1.1676302,1.1031465,1.0435557,1.0628737,1.1246445,1.2167506,1.282994,1.3569621,1.4119227,1.4689277,1.5033353,1.5155896,1.5247643,1.5244118,1.5197842:2
2.8500275,2.7703986,2.6805682,2.5855602,2.4806669,2.3876724,2.2936615,2.1843962,2.0739397,1.9635413,1.852442,1.7413978,1.6298229,1.5339521,1.4220635,1.3197458,1.213633,1.1173156,1.0048269,0.90849328,0.81218768,0.72002102,0.66035574,0.63025436,0.60710225,0.58671472,0.55759547,0.53600346,0.50374058,0.46618804,0.42191971,0.39406767,0.36433509,0.35209831,0.34459637,0.33909812,0.33071459,0.3205745,0.30074656,0.21375904,0.12827417,0.065232857,0.0068805271,-0.037239671,-0.075026254,-0.097245862,-0.10614912,-0.11078867,-0.1150652,-0.11255422,-0.095188186,-0.07505022,-0.041375651,-0.0102507,0.022895907,0.035388431,0.033257905,0.055350523,0.06489379,0.070377731,0.059813199,0.0016403153,-0.058081939,-0.1290852,-0.21292526,-0.2700609,-0.33280084,-0.39450439,-0.45310889,-0.52929041,-0.60354818,-0.6739527,-0.76497536,-0.84970118,-0.93510728,-1.018527,-1.0927413,-1.1736951,-1.2408205,-1.2946913,-1.317017,-1.3165078,-1.3117098,-1.2993126,-1.2883586,-1.2768168,-1.2682819,-1.253653,-1.2297417,-1.1915823,-1.1560813,-1.1202127,-1.069844,-1.0204168,-0.96143746,-0.89967504,-0.836311,-0.77658247,-0.71317023,-0.64964528,-0.58832542,-0.58672023,-0.67627849,-0.67048016,-0.61211486,-0.54648757,-0.47021674,-0.39869102,-0.321,-0.26612875,-0.19187525,-0.1167499,-0.042539647,-0.070698015,-0.1539637,-0.23215043,-0.30879382,-0.39080271,-0.46751531,-0.55840995,-0.62758807,-0.61483714,-0.69285754,-0.78408338,-0.86090022,-0.94267115,-1.0265382,-1.1051408,-1.1964898,-1.2826497,-1.364236,-1.449433,-1.5396443,-1.62632,-1.6774996,-1.7083046,-1.7171183,-1.6933901,-1.6559004,-1.6049032,-1.5370591,-1.4567557,-1.3540744,-1.2608494,-1.1544695,-1.046419,-0.9538714,-0.86666025,-0.76843335,-0.67126744,-0.57647484,-0.46978059,-0.38053803,-0.28362248,-0.19600729,-0.11081752,-0.011330128,0.074633179,0.16122591,0.13574237,0.17885669,0.27140329,0.35776178,0.45516417,0.54390173,0.63624522,0.72902365,0.80064422,0.73822509,0.66159819,0.59203912,0.53564121,0.4552046,0.38920549,0.31691691,0.24978092,0.19625849,0.13851502,0.085098767,0.035692516,-0.0039440829,-0.012800722,0.025950784,0.079477627,0.15726815,0.23509386,0.31480452,0.40315788,0.50093231,0.5985495,0.70301322,0.79420872,0.89231452,0.98999055,1.1033414,1.0828888,1.1527562,1.2244905,1.3071914,1.3911073,1.3239508,1.2529079,1.2743606,1.3445488,1.421974,1.4925783,1.5589799,1.6304716,1.6739291,1.7116118,1.7681579,1.69622,1.6275277,1.5651639,1.4788995,1.3885339,1.280678,1.1722591,1.1163418,1.1432996,1.2070594,1.2620967,1.1795694,1.0922847,0.98685196,0.9302476,0.84270012,0.76029091,0.67163613,0.57278204,0.47416815,0.3946491,0.30267902,0.20661686,0.11796491,0.042639348,-0.0016360972,-0.0104304,0.0043593331,0.059671821,0.12008374,0.18447899,0.25155246,0.32230196,0.39651931,0.47519737,0.54418918,0.55674293,0.61947294,0.69190162,0.76265244,0.80491274,0.72867727,0.64847462,0.57085214,0.49832765,0.41258682,0.33251629,0.25458552,0.16564765,0.097517247,0.10062975,0.15703816,0.080091697,5.3630728E-4,-0.079791797,-0.15717213,-0.23845855,-0.32385128,-0.4022684,-0.48373875,-0.56424003,-0.64323902,-0.7296911,-0.80780714,-0.88745416,-0.96802451,-1.0435889,-1.1336659,-1.2082373,-1.2882685,-1.3704165,-1.4528571,-1.5264137,-1.5978924,-1.6463071,-1.6699659,-1.6782211,-1.6751796,-1.6562161,-1.6131045,-1.5451599,-1.4711246,-1.3800608,-1.2688638,-1.1555535,-1.0572401,-0.96899286,-0.87505602,-0.7907818,-0.7049602,-0.61713472,-0.64104394,-0.56017801,-0.47515871,-0.39590011,-0.32300937,-0.25140194,-0.17705901,-0.10478574,-0.064041018,-0.13764386,-0.19743337,-0.25699877,-0.31483616,-0.34664328,-0.41243839,-0.48681329,-0.54775833,-0.60490972,-0.65555432,-0.70279112,-0.72142097,-0.67384016,-0.60325938,-0.67774143,-0.74218469,-0.79988236,-0.85874039,-0.91608402,-0.96885037,-1.026808,-1.0787431,-1.1262937,-1.1765575,-1.2161266,-1.2527992,-1.2891878,-1.3225805,-1.3430202,-1.3672201,-1.3696127,-1.3613053,-1.3506994,-1.3379763,-1.3142866,-1.2786082,-1.2400805,-1.1662403,-1.064331,-0.97681683,-0.8925596,-0.81058827,-0.74838129,-0.68214339,-0.62222643,-0.5609397,-0.49066698,-0.43859644,-0.36940552,-0.30177627,-0.24374738,-0.18437497,-0.10559509,-0.14630421,-0.18001418,-0.20299256,-0.2155704,-0.23384687,-0.23869519,-0.2135294,-0.13145904,-0.10251292,-0.12733031,-0.13456444,-0.14135501,-0.1512811,-0.14727645,-0.13898958,-0.12640655,-0.11950355,-0.10182704,-0.091834923,-0.060555456,-0.022852702,0.03015069,0.10063583,0.17678336,0.28115887,0.36996754,0.40750361,0.4339974,0.45551591,0.47708786,0.49025395,0.51036299,0.53750082,0.56380135,0.59663675,0.62765663,0.6622451,0.68252046,0.65457668,0.61889232,0.68433322,0.75679165,0.83079004,0.90453894,1.002042,1.099192,1.1969619,1.3096021,1.4057796,1.5183878,1.6139799,1.7263168,1.8379069,1.9498802,2.0606697,2.1716273,2.2821334,2.3758398,2.485573,2.5789316,2.6719861,2.7643524,2.8374643:4
1.5780817,1.5530289,1.5189091,1.4721629,1.4342943,1.3334097,1.2467477,1.1598316,1.1910558,1.163491,1.0762268,0.98331745,0.8867101,0.8122172,0.72425057,0.63347492,0.54777751,0.46257532,0.38708391,0.28870022,0.2124204,0.1284917,0.046362301,-0.029841743,-0.098407216,-0.17312378,-0.2501718,-0.24820475,-0.19286662,-0.12514211,-0.060044331,0.018946739,0.11498637,0.19141895,0.30106851,0.38601185,0.50138479,0.59788123,0.70442733,0.80739891,0.74354122,0.8073593,0.81911931,0.72525939,0.63287368,0.53862774,0.45411578,0.38058249,0.28497512,0.19911313,0.12352769,0.048310678,0.042747195,0.11132415,0.072494125,0.061957253,0.09305425,0.0072439677,-0.082471892,-0.17389806,-0.26429632,-0.35485965,-0.44434751,-0.53363661,-0.62281214,-0.71210371,-0.80151089,-0.89051729,-0.97934447,-1.046076,-1.1253995,-1.2127126,-1.2991963,-1.3822853,-1.4461998,-1.5242477,-1.5983582,-1.6697966,-1.7384674,-1.8002771,-1.8619373,-1.9256116,-1.9772541,-2.0211832,-2.0493776,-2.0682746,-2.080369,-2.0274932,-1.9607696,-1.8786939,-1.7921923,-1.7236697,-1.6308923,-1.5522564,-1.4686335,-1.381804,-1.2987154,-1.2169907,-1.1328333,-1.0552413,-0.97430746,-0.89030693,-0.7954474,-0.72187136,-0.64066359,-0.55557742,-0.46908035,-0.39263238,-0.30425906,-0.22047966,-0.13518017,-0.055280859,-0.016802582,-0.096254505,-0.17727831,-0.2673009,-0.34598128,-0.3771982,-0.377149,-0.44476338,-0.52303489,-0.6042269,-0.68862642,-0.76236603,-0.83069912,-0.89850795,-0.95825906,-1.0088918,-1.0366841,-1.0692624,-1.0845723,-1.1069767,-1.1110654,-1.1223217,-1.1169083,-1.1089349,-1.0958677,-1.0785429,-1.0530591,-1.0220338,-0.98760634,-0.94558082,-0.89897291,-0.83763218,-0.76997112,-0.69878947,-0.62981574,-0.51977391,-0.43848502,-0.35810864,-0.27865082,-0.20663949,-0.14564388,-0.0672071,0.022431687,0.10544903,0.1880341,0.27246774,0.3569254,0.44167547,0.45816021,0.44122461,0.41638282,0.38182336,0.35344739,0.34114617,0.33649545,0.33520506,0.34493058,0.35954504,0.36766397,0.39489333,0.43336809,0.47632399,0.49833572,0.53100076,0.55638848,0.60568442,0.67140842,0.73208877,0.80180286,0.87487745,0.95523361,1.0255861,1.0867586,1.129941,1.1689921,1.1941188,1.2163379,1.2150883,1.2053578,1.2140049,1.2300387,1.2709835,1.3673658,1.4434732,1.5304846,1.6164587,1.7030368,1.7852515,1.8638408,1.9463563,2.0276107,2.1104615,2.1940786,2.2822335,2.3112844,2.2225583,2.1401042,2.0613739,1.9805024,1.8960219,1.8100895,1.7301434,1.6467665,1.5628603,1.4757393,1.3900706,1.3797927,1.3367216,1.3382376,1.3811316,1.4078941,1.4333153,1.4359881,1.4465286,1.4568735,1.4565936,1.4611603,1.4451485,1.4223658,1.3809437,1.3560998,1.310272,1.2611965,1.2069503,1.1662733,1.1180964,1.0730359,1.0323478,0.99485636,0.95762107,0.92891557,0.90479806,0.88970058,0.88892736,0.89704165,0.92597277,0.87666333,0.82686901,0.77888705,0.72923746,0.67792176,0.62929056,0.56749058,0.47570719,0.38390115,0.31083891,0.25273204,0.18436818,0.13284073,0.083045342,0.038059657,-0.0043074576,-0.033186105,-0.065452834,-0.088511281,-0.10266752,-0.11077465,-0.11567737,-0.11624941,-0.11680169,-0.11305273,-0.11739528,-0.096123523,-0.068946958,-0.022696683,0.01965916,0.060739826,0.075434303,-0.0022758911,-0.067344831,-0.12458528,-0.20064709,-0.27728554,-0.3370956,-0.39926748,-0.47216394,-0.54205491,-0.61144725,-0.68997413,-0.76446379,-0.84966141,-0.96337462,-1.0377473,-1.0881912,-1.1520194,-1.1980119,-1.2342152,-1.2607913,-1.2805575,-1.2957579,-1.3107785,-1.3119016,-1.3075625,-1.3013492,-1.2799019,-1.2702419,-1.2372354,-1.1968192,-1.1607913,-1.1098124,-1.0597457,-1.0020446,-0.91472272,-0.85096271,-0.78799627,-0.72785704,-0.66101334,-0.56749071,-0.61784601,-0.69631869,-0.70434405,-0.65767263,-0.59637285,-0.51320119,-0.43043531,-0.35259197,-0.27599895,-0.19313331,-0.090003779,0.021968628,-0.017637447,-0.12471964,-0.24248635,-0.34760228,-0.44216192,-0.56078653,-0.65763123,-0.69236092,-0.76821076,-0.8689515,-0.95870091,-1.0512385,-1.1429324,-1.2339781,-1.324524,-1.4023915,-1.4821819,-1.5523452,-1.600275,-1.6476409,-1.6632982,-1.6453958,-1.6116637,-1.5546674,-1.5065703,-1.4528868,-1.3829334,-1.3136106,-1.239875,-1.1632434,-1.0912165,-1.0258566,-0.9483735,-0.86531735,-0.78016108,-0.70182001,-0.62707898,-0.55165853,-0.47684793,-0.3903555,-0.30855084,-0.23493888,-0.13800695,-0.062602126,0.012549051,0.0711275,0.15293595,0.22929221,0.31151414,0.394288,0.47128486,0.54675131,0.5912152,0.50346551,0.41138181,0.33286541,0.22878988,0.15900289,0.081840205,-0.015953986,-0.10021451,-0.15885451,-0.20741752,-0.23758883,-0.23073787,-0.14373202,-0.076874434,0.0089806076,0.091324698,0.18148272,0.26535335,0.34335651,0.42292785,0.50684891,0.59972145,0.68317631,0.7649746,0.84613877,0.92931055,1.0192446,1.1022,1.1126801,1.032074,1.0183939,1.0805515,1.1586407,1.2631533,1.3365652,1.4049621,1.4822851,1.5193168,1.5558812,1.581942,1.5975314,1.5923888:4
2.4004828,2.295967,2.2192462,2.1148296,2.0379735,1.937313,1.8546375,1.7638076,1.6707656,1.593019,1.4968006,1.4090296,1.3299371,1.2258321,1.1479369,1.0467513,0.96492974,0.8800894,0.78250448,0.70299514,0.60612342,0.51927588,0.44095487,0.3618948,0.25575967,0.17786694,0.09843365,0.018700416,-0.065684008,-0.14513445,-0.22245105,-0.2799773,-0.29115675,-0.2749568,-0.23910686,-0.20476608,-0.16199599,-0.13260074,-0.098351948,-0.060589423,-0.034210282,-0.016069237,0.0097666372,0.029188837,0.036798057,0.037020575,0.033642137,0.027362873,0.014847123,0.0056954158,-0.0023022594,-0.013581022,-0.026951069,-0.035889357,-0.039613593,-0.050428502,-0.052234303,-0.060913093,-0.062488894,-0.059922614,-0.057325644,-0.04926052,-0.028202355,-0.01874392,-0.078625359,-0.14151476,-0.22000668,-0.29259156,-0.36708115,-0.44759202,-0.51409492,-0.59464457,-0.67417884,-0.74629086,-0.83598007,-0.92370205,-1.0012437,-1.050622,-1.1029339,-1.1652891,-1.2067771,-1.2662014,-1.3025622,-1.3282171,-1.349863,-1.3675719,-1.3789062,-1.3854263,-1.3842082,-1.3821793,-1.370154,-1.3571948,-1.3418829,-1.3178768,-1.2919946,-1.2528801,-1.2123247,-1.1753965,-1.1398815,-1.1077261,-1.0667687,-1.0162153,-0.95806803,-0.90575321,-0.85447819,-0.80482665,-0.7543069,-0.69625734,-0.64740597,-0.58073824,-0.51544132,-0.43864785,-0.37307262,-0.30129142,-0.22975424,-0.16572968,-0.10583755,-0.076587731,-0.016376586,0.047515791,0.11091445,0.16646255,0.22802502,0.26463934,0.18376837,0.10930281,0.021099262,-0.076688141,-0.16199924,-0.24504341,-0.32004897,-0.42302223,-0.49921491,-0.59810215,-0.69503926,-0.75009186,-0.81632638,-0.90147786,-0.99538482,-1.0612526,-1.1374016,-1.1902819,-1.2162009,-1.2391961,-1.2544127,-1.2572471,-1.2500713,-1.2273149,-1.1898979,-1.1613532,-1.1381787,-1.0877489,-1.0404076,-0.96571108,-0.89643877,-0.81279016,-0.73647772,-0.66787801,-0.58899207,-0.51103201,-0.42338976,-0.34298668,-0.27265114,-0.17692921,-0.10538332,-0.022386334,0.062569683,0.14938794,0.23049667,0.31054754,0.39876317,0.49036301,0.58134585,0.67312464,0.76814285,0.84676785,0.93270783,1.029311,1.1252319,1.2158644,1.2785848,1.3042586,1.3855122,1.4666729,1.524191,1.4523497,1.3886754,1.3294152,1.287688,1.2938922,1.3587106,1.4593502,1.5606917,1.6576457,1.7582214,1.8358838,1.9161437,2.0186791,2.0966891,2.1976535,2.2849828,2.2301683,2.1639017,2.0807334,2.0093599,1.952958,1.8896926,1.8191411,1.7351339,1.6530739,1.5775705,1.5024181,1.4323964,1.3503424,1.2855125,1.2110016,1.127713,1.0639097,0.99211506,0.91348546,0.86107097,0.82479972,0.8333587,0.86376284,0.91279195,0.97449884,1.046169,1.1198178,1.2230598,1.2998511,1.2990312,1.2258033,1.1449298,1.0434119,0.96559863,0.86059219,0.78352934,0.68911788,0.60106033,0.52365366,0.43919074,0.36182363,0.2630282,0.185521,0.10815068,0.017012968,-0.073808098,-0.1505118,-0.25468408,-0.34003347,-0.40863543,-0.48557911,-0.56213678,-0.63838795,-0.71468141,-0.79314736,-0.86519533,-0.93993354,-1.0145093,-1.092622,-1.162011,-1.2310785,-1.2941434,-1.3646952,-1.4198251,-1.4827247,-1.5215226,-1.5606758,-1.5900943,-1.606189,-1.6072345,-1.6052541,-1.5890288,-1.5752631,-1.549219,-1.5243056,-1.4877811,-1.4262878,-1.3594162,-1.2829768,-1.2107379,-1.1374312,-1.0613605,-0.99353736,-0.91374963,-0.8456818,-0.76534066,-0.69722811,-0.62235503,-0.5388587,-0.47556735,-0.39357946,-0.34483125,-0.2880389,-0.20803424,-0.13685096,-0.063589866,0.013735709,0.085826406,0.12501825,0.061942988,-0.016204369,-0.084408972,-0.15469609,-0.2230205,-0.2973438,-0.36555162,-0.43140661,-0.49424924,-0.57257595,-0.63745803,-0.70448204,-0.76924668,-0.82951694,-0.88949224,-0.93564029,-0.98431363,-1.0310533,-1.0721016,-1.1148974,-1.1499618,-1.1830642,-1.2132707,-1.2481522,-1.2669151,-1.2924266,-1.3145008,-1.314713,-1.3060904,-1.2952769,-1.2846741,-1.270499,-1.2442894,-1.2016184,-1.16028,-1.1007113,-1.0506265,-0.99155023,-0.92809545,-0.86506696,-0.78092204,-0.70033358,-0.62540495,-0.52703129,-0.42960245,-0.36383747,-0.29077088,-0.19827385,-0.1158784,-0.046480423,0.015738563,0.052666175,0.064944586,0.034973785,0.015377701,0.0035666588,0.0020651066,-0.0076333922,-0.018539442,-0.013777504,-0.014517391,-0.012718659,-0.0072276517,-0.0047047904,-0.0030258099,-0.0013423695,-0.0056904985,0.0039232685,0.0090409553,0.01299302,0.025749516,0.041581885,0.061074024,0.072506262,0.093717897,0.10997518,0.1306562,0.14583214,0.16122063,0.16959089,0.17171218,0.18503378,0.18302828,0.18061037,0.1724538,0.16185389,0.12543939,0.10783803,0.07348616,0.032595212,-0.012040275,-0.058430473,-0.074613682,-0.07064067,-0.017786596,0.048469415,0.030133225,-0.016794347,0.032731141,0.10272374,0.18274714,0.26444166,0.36366419,0.44513686,0.52301178,0.62835563,0.70589521,0.79797123,0.88946478,0.97299368,1.0731049,1.1509154,1.256017,1.3337786,1.414303,1.516873,1.5954629,1.6803251,1.7793393,1.8561691,1.9490188,2.0407014,2.1187694,2.2219387,2.3034557,2.3831756,2.4218155:4
-0.2449993,-0.24508041,-0.2514635,-0.27668369,-0.29173477,-0.30343669,-0.31985939,-0.33531725,-0.34354955,-0.36698354,-0.40290628,-0.38218082,-0.33031845,-0.37517181,-0.42340689,-0.42313413,-0.3911046,-0.39693037,-0.40217227,-0.41394462,-0.42025477,-0.44135736,-0.45936682,-0.44580531,-0.46052818,-0.45871004,-0.47395919,-0.47657115,-0.48861113,-0.51942823,-0.54564002,-0.51535528,-0.52246251,-0.5947846,-0.65266948,-0.61671305,-0.52362774,-0.44321113,-0.37553423,-0.28946123,-0.2414373,-0.19753907,-0.14330452,-0.1083499,-0.080637042,-0.031810652,0.044889439,0.061301963,0.064399358,0.13511802,0.16919663,0.20362811,0.1956019,0.21414059,0.23581356,0.22892826,0.2552503,0.25750948,0.24773267,0.23699652,0.22933031,0.21465569,0.20125479,0.18694182,0.20276859,0.21678689,0.21039641,0.22596001,0.27187732,0.32335955,0.37164,0.47421278,0.57940366,0.68797158,0.7951998,0.90299142,1.0110067,1.1186682,1.2250662,1.333743,1.3903677,1.4878137,1.559674,1.6120212,1.658199,1.7651406,1.8114514,1.870587,1.9516897,2.019742,2.0543322,2.0677167,2.0924327,2.100756,2.1030387,2.0815586,2.0550375,2.0258142,1.9719314,1.8639737,1.8090992,1.7453634,1.6529663,1.5448899,1.4943272,1.3858322,1.2776919,1.1692059,1.0609516,0.95296709,0.90011278,0.83879834,0.74102509,0.67946731,0.59948566,0.52799166,0.46882567,0.3958629,0.33517151,0.28410348,0.24671535,0.2197112,0.18220874,0.17249933,0.17284718,0.1733952,0.16743667,0.17362992,0.16155884,0.15048627,0.15196569,0.1551082,0.1722088,0.15595971,0.14902285,0.14173293,0.13547086,0.12241346,0.13421303,0.13204532,0.11112414,0.080139447,0.055510893,0.031055267,8.3993976E-4,-0.015167423,-0.065538463,-0.12189076,-0.1541915,-0.22445333,-0.30992781,-0.38561561,-0.4274221,-0.48265728,-0.5507297,-0.62968686,-0.7082895,-0.78600263,-0.86577169,-0.9465665,-0.96782116,-1.0084738,-1.0869838,-1.1441638,-1.1495715,-1.2285076,-1.2985859,-1.3722306,-1.4393527,-1.4489298,-1.4146652,-1.3485135,-1.3171532,-1.3449937,-1.2837096,-1.2213881,-1.1996784,-1.1422711,-1.1189507,-1.106421,-1.0746077,-1.0543426,-1.0317926,-1.0044282,-0.9919923,-0.98077264,-0.97103616,-0.95132393,-0.92228027,-0.89297801,-0.86864969,-0.85996576,-0.82216281,-0.81077765,-0.8028776,-0.8010969,-0.83114024,-0.87420578,-0.91664733,-0.97477377,-1.0352908,-1.090609,-1.1431596,-1.1962198,-1.2567411,-1.3144401,-1.3943515,-1.4510471,-1.5296462,-1.6040469,-1.6611602,-1.7578387,-1.8625194,-1.9685699,-2.0598481,-2.1221419,-2.2127978,-2.1922129,-2.133241,-2.0562993,-1.9948841,-1.9094472,-1.826449,-1.744227,-1.6570704,-1.5594051,-1.4899922,-1.3835265,-1.2720323,-1.2189385,-1.104355,-1.0409493,-0.94274066,-0.87296384,-0.79756696,-0.71810049,-0.66777358,-0.56822423,-0.50639099,-0.47141263,-0.38353068,-0.32215757,-0.25628426,-0.20970436,-0.15143341,-0.10181621,-0.052523419,-0.039626682,-0.0046137568,0.061911431,0.12549803,0.1299028,0.17552458,0.22070013,0.17198907,0.21081756,0.25279493,0.22705826,0.21606723,0.19098573,0.18815618,0.22169448,0.23132435,0.25773697,0.27591941,0.29285681,0.28162484,0.29989129,0.22305968,0.22305968,0.27776511,0.35411034,0.44882704,0.51417879,0.60832324,0.67318699,0.76759977,0.79849669,0.84196181,0.94411178,0.98772171,1.0368479,1.0784619,1.1211306,1.1867002,1.2549633,1.3051993,1.3380307,1.3509097,1.3973643,1.4328217,1.4646261,1.4513366,1.4824232,1.5388813,1.5901245,1.6161384,1.624258,1.6242683,1.6371661,1.6258598,1.5950699,1.5537159,1.5101893,1.4541113,1.4176499,1.3595533,1.3255685,1.2834284,1.2200889,1.1602346,1.1049187,1.0436096,0.98008808,0.91913181,0.83869662,0.77931045,0.72490753,0.66923311,0.59155781,0.5478199,0.4859319,0.50993401,0.57048898,0.61452747,0.60619066,0.59838957,0.67188273,0.69412597,0.76376861,0.80901604,0.85902148,0.92327226,0.98919417,1.0452185,1.0972754,1.1304637,1.1844472,1.2165828,1.2376651,1.2635847,1.2654666,1.2637947,1.2516602,1.237892,1.2149744,1.1995522,1.1747986,1.1498427,1.1202706,1.0920376,1.0627189,1.0215204,0.97065569,0.9242567,0.88120654,0.80671865,0.71714224,0.67900724,0.5980706,0.53823585,0.48080316,0.42162176,0.3701913,0.2978099,0.20450445,0.15538912,0.11608707,0.03151604,-0.046890824,-0.1214111,-0.14828109,-0.21974301,-0.30121172,-0.37936952,-0.45274859,-0.5361899,-0.60714953,-0.71261287,-0.76065029,-0.83835239,-0.91733101,-0.982107,-1.0591868,-1.1084167,-1.1927775,-1.2539513,-1.3165975,-1.3702071,-1.3364343,-1.3344467,-1.4260658,-1.4271299,-1.446393,-1.496774,-1.4971077,-1.5066383,-1.6099629,-1.6528723,-1.6797008,-1.6136205,-1.5294754,-1.5055593,-1.4164582,-1.3353582,-1.2494699,-1.159198,-1.0848546,-0.97466696,-0.87516511,-0.81392425,-0.73760013,-0.66728629,-0.56650784,-0.50388531,-0.43197091,-0.38948233,-0.3502177,-0.30791046,-0.28514967,-0.26005604,-0.243957,-0.24556066,-0.2454392,-0.23624492,-0.22368528,-0.23706311:2
2.4757871,2.3905944,2.3001164,2.2020525,2.1064567,2.020636,1.9193126,1.8238075,1.7257331,1.6287376,1.5291251,1.4356471,1.3267884,1.2330874,1.1260607,1.0093928,0.92163515,0.87957052,0.85387567,0.8253444,0.80319797,0.76559085,0.73301896,0.69765605,0.66342409,0.63779931,0.59462275,0.5439237,0.49467996,0.43668226,0.37870803,0.32502606,0.26152105,0.22646755,0.19843583,0.16522757,0.16174812,0.16517104,0.15156413,0.083489498,0.0049076035,-0.081476897,-0.15088927,-0.23097956,-0.32143414,-0.38419041,-0.4868883,-0.59567952,-0.67306671,-0.58683785,-0.50156632,-0.42865692,-0.49085838,-0.58764164,-0.67346818,-0.76680327,-0.85401257,-0.94848231,-1.0027776,-1.0177605,-1.0090197,-0.99623543,-0.98599724,-0.96870705,-0.9586594,-0.94590933,-0.92545184,-0.90226288,-0.87140407,-0.84276498,-0.81410907,-0.79068718,-0.7512322,-0.70229061,-0.64685736,-0.5902988,-0.52083129,-0.4491194,-0.36953643,-0.26738152,-0.18571777,-0.084294569,-0.13117485,-0.23642527,-0.36468807,-0.43897189,-0.57001902,-0.64480966,-0.74528835,-0.83715961,-0.94295411,-1.0385921,-1.1295425,-1.2342763,-1.3145263,-1.442259,-1.5507725,-1.6804476,-1.7730376,-1.8415568,-1.9007467,-1.9457373,-1.9656327,-1.963794,-1.9286626,-1.8585425,-1.7728936,-1.6836947,-1.6010363,-1.5113892,-1.4268285,-1.3258134,-1.2326275,-1.1396943,-1.0435033,-0.94942022,-0.85310307,-0.75286727,-0.6666105,-0.55713758,-0.46262532,-0.36176329,-0.26031973,-0.15380016,-0.069633981,0.041185348,0.12838868,0.22021176,0.19847554,0.11315011,0.044391582,0.080872318,0.17125573,0.28737553,0.40739118,0.52856767,0.62948333,0.74632596,0.81930595,0.89480428,0.88122173,0.75804277,0.6363775,0.53997159,0.46533558,0.43909597,0.3449407,0.24440038,0.15047873,0.059465779,-0.024392193,-0.105508,-0.18508421,-0.26345068,-0.34280857,-0.41335928,-0.48142288,-0.52655705,-0.54362949,-0.52181093,-0.4708617,-0.41261955,-0.32758288,-0.22646299,-0.12442688,0.0055311867,0.10764473,0.23784731,0.34014874,0.47042614,0.57285377,0.67537668,0.80579923,0.93614323,1.0416213,0.9914621,1.078951,1.2092985,1.3136992,1.2708579,1.1415038,1.041399,0.96555529,0.90394271,0.86465884,0.87559286,0.93991413,1.0177666,1.101088,1.1977975,1.3042772,1.3982622,1.4510596,1.4736185,1.4252477,1.3403398,1.3940671,1.4924898,1.5790285,1.4699165,1.3747308,1.2718939,1.166045,1.0718427,1.0113231,1.0097662,1.0615556,1.1354999,1.2274849,1.3146934,1.42413,1.4368468,1.3335534,1.230401,1.1243441,1.0257363,0.91097663,0.80560202,0.69977948,0.5975761,0.47086013,0.37114596,0.26712603,0.15944847,0.051348078,-0.064897223,-0.14253956,-0.16855494,-0.15326035,-0.10296209,-0.030844673,0.031257154,0.11448466,0.19439311,0.2764642,0.3743816,0.45740324,0.54027652,0.60321306,0.67922859,0.77828664,0.82324922,0.7261257,0.63246098,0.54034663,0.45028391,0.35256117,0.26345746,0.17396275,0.083216279,-0.008513819,0.010845101,0.10691442,0.19559165,0.11040978,0.00700158,-0.079845199,-0.17335957,-0.2674233,-0.36056105,-0.4515387,-0.54254338,-0.63820228,-0.73057263,-0.82514726,-0.91077722,-1.0035125,-1.0935149,-1.1817171,-1.2736523,-1.3631503,-1.4494442,-1.539718,-1.6316669,-1.714542,-1.7974347,-1.8907964,-1.9662876,-2.0403798,-2.102111,-2.1438474,-2.1225765,-2.0750834,-2.0100562,-1.9313506,-1.8514273,-1.7777303,-1.6738336,-1.542646,-1.4398599,-1.3095622,-1.2054271,-1.0787731,-0.9773279,-0.89697372,-0.80132511,-0.69894154,-0.62325031,-0.54261715,-0.46336311,-0.37323382,-0.27063661,-0.1752072,-0.093032438,-0.064885559,-0.14511468,-0.2211644,-0.25977574,-0.33539597,-0.4047368,-0.47201831,-0.52760812,-0.58758468,-0.65235922,-0.71611903,-0.73679434,-0.69403091,-0.59817462,-0.47109875,-0.36429349,-0.39735579,-0.49735809,-0.58533668,-0.66183794,-0.7286558,-0.78540532,-0.83832258,-0.88348003,-0.92841266,-0.97605458,-0.99740197,-1.0232087,-1.0529599,-1.0867028,-1.1288471,-1.1736588,-1.1958486,-1.2124414,-1.232982,-1.2477955,-1.268293,-1.266384,-1.2545263,-1.2353501,-1.2034652,-1.1550258,-1.0778401,-0.98840671,-0.89298345,-0.7876412,-0.69961601,-0.62088046,-0.55349872,-0.47601265,-0.41732069,-0.34661473,-0.27719333,-0.20695963,-0.13935121,-0.075229102,0.0037684656,0.037744928,0.12267243,0.18578576,0.1288832,0.10065468,0.09001992,0.13098266,0.11608988,0.083924438,0.089414699,0.097852375,0.11589199,0.13004407,0.14986595,0.15824888,0.17828677,0.20422111,0.24156698,0.2775565,0.31474352,0.36851039,0.43478981,0.52212769,0.62177024,0.68686727,0.7281281,0.75673801,0.85266657,0.88071147,0.90266834,0.93078442,0.96141176,0.99396356,1.0191214,1.044968,1.0644007,1.0717641,1.0781075,1.0821137,1.0682582,1.0568635,1.0707809,1.1401043,1.102875,1.0191133,0.91347791,0.80561423,0.73828219,0.82121419,0.91637776,1.0213705,1.1141717,1.2219449,1.3290523,1.4136916,1.5250686,1.61665,1.719701,1.8044747,1.9013887,1.999958,2.0895439,2.1916036,2.2821307,2.370162,2.4564044:4
1.8254679,1.7350099,1.6563132,1.5983345,1.5753806,1.4837265,1.3809142,1.2949472,1.2839275,1.1996071,1.119807,1.0577406,1.009914,0.9443407,0.88380741,0.82999299,0.7236284,0.69526451,0.65982499,0.5658273,0.46359304,0.39334745,0.33799351,0.28019792,0.19406136,0.1492989,0.11271582,0.013442428,-0.086415847,-0.17999366,-0.26469422,-0.33404959,-0.34637944,-0.35509865,-0.37377905,-0.39243036,-0.40713592,-0.39511346,-0.34505614,-0.29805927,-0.27525259,-0.26785577,-0.26942949,-0.26939318,-0.26671755,-0.26392908,-0.26517592,-0.25522317,-0.23571078,-0.214172,-0.21162225,-0.25211114,-0.31085661,-0.38165172,-0.46058345,-0.51947135,-0.54853862,-0.54367884,-0.52542711,-0.51935675,-0.52069063,-0.52647522,-0.53064227,-0.52120732,-0.50500697,-0.49062614,-0.46595406,-0.4548048,-0.45429383,-0.4545495,-0.47692023,-0.50540861,-0.5329102,-0.5409555,-0.54256456,-0.54321769,-0.54437134,-0.54228694,-0.55012078,-0.56686344,-0.59229033,-0.61556822,-0.63394988,-0.64819434,-0.65869867,-0.66325175,-0.67788473,-0.70506921,-0.74970821,-0.75466809,-0.80121444,-0.88954164,-0.98273795,-1.077252,-1.1712461,-1.264074,-1.3549311,-1.4115426,-1.4566478,-1.5006583,-1.5349124,-1.5374395,-1.51887,-1.4867641,-1.4506033,-1.4096366,-1.3645241,-1.3158808,-1.2643587,-1.2168075,-1.1733434,-1.1326225,-1.08776,-1.0369998,-0.98060337,-0.9224663,-0.87045215,-0.81765781,-0.76159623,-0.7082549,-0.67947548,-0.65869865,-0.63434087,-0.59472913,-0.5782489,-0.5802087,-0.5961447,-0.64063193,-0.67013636,-0.68288435,-0.68052219,-0.6419663,-0.5771352,-0.49452201,-0.42289909,-0.3472732,-0.27352554,-0.20880188,-0.19968751,-0.1502669,-0.08149363,-0.0050302165,0.069489579,0.094329511,0.11985245,0.20189043,0.28402748,0.34025139,0.3747818,0.39566588,0.47440395,0.54563132,0.59799076,0.62274695,0.70103385,0.79165023,0.88306893,0.97400067,1.0622255,1.1486426,1.2337389,1.3204857,1.3782442,1.423144,1.4685094,1.5556363,1.6432033,1.7307045,1.8188753,1.8470748,1.8950243,1.9679198,2.0586749,2.1500285,2.2328793,2.2983018,2.3089714,2.3813286,2.4588691,2.5168995,2.5401461,2.5596038,2.5630208,2.5401536,2.5224703,2.4646954,2.3807988,2.2870509,2.2580474,2.2072137,2.1318908,2.0385179,1.9694096,1.9231472,1.8850697,1.7921798,1.6993876,1.6419616,1.6228381,1.5435008,1.4551252,1.3761401,1.3186196,1.2868267,1.2697287,1.2409618,1.1700877,1.0760652,0.9817569,0.8884653,0.79668605,0.70614476,0.66396437,0.64821291,0.5596109,0.50711214,0.50283617,0.5348253,0.48741109,0.47242202,0.44069488,0.36749012,0.28063821,0.19216535,0.12219325,0.090686732,0.046147103,-0.011688252,-0.060857685,-0.064491285,-0.13366297,-0.21382291,-0.29574835,-0.37003403,-0.38734628,-0.40232556,-0.4093187,-0.30893636,-0.24498848,-0.23219065,-0.27254931,-0.27660148,-0.30246869,-0.35027268,-0.42177403,-0.49108462,-0.5600722,-0.61071819,-0.61665429,-0.63851575,-0.65286567,-0.66124434,-0.67084536,-0.72216002,-0.79488486,-0.87818788,-0.941065,-0.95484414,-0.95447114,-0.95090094,-0.93861701,-0.97752051,-1.0437664,-1.1244188,-1.2063906,-1.2337146,-1.2507355,-1.3054459,-1.34414,-1.4048845,-1.4720074,-1.5118722,-1.5491573,-1.5794782,-1.6091506,-1.6627001,-1.663247,-1.6482311,-1.6206407,-1.5299677,-1.435868,-1.3461203,-1.2675674,-1.2535975,-1.2369512,-1.2007139,-1.1277123,-1.0642911,-1.0205159,-0.97141239,-0.87521705,-0.78334754,-0.72873579,-0.70436341,-0.68307421,-0.70186578,-0.73009699,-0.75874074,-0.77609205,-0.76380292,-0.7380554,-0.70932205,-0.734379,-0.75831745,-0.76200742,-0.72982059,-0.71563244,-0.6518586,-0.5825166,-0.5668102,-0.61828496,-0.65591442,-0.67528441,-0.67843168,-0.6723393,-0.66894155,-0.66795468,-0.65868225,-0.57675714,-0.49216361,-0.43042497,-0.40442221,-0.39325133,-0.38976391,-0.39039121,-0.40610576,-0.41198443,-0.40941798,-0.39904138,-0.36340312,-0.33390545,-0.31580994,-0.31788303,-0.34638735,-0.36295746,-0.37002517,-0.39481101,-0.4194346,-0.38648781,-0.28984333,-0.20965464,-0.14826832,-0.11168102,-0.10355318,-0.10371625,-0.098743835,-0.09142521,-0.084052658,-0.06664623,-0.052687601,-0.044318747,-0.045184432,-0.036608503,-0.027914692,-0.028661124,-0.064598134,-0.11393791,-0.15001121,-0.16849052,-0.17953842,-0.17487011,-0.16239579,-0.14743472,-0.16118044,-0.17057155,-0.18189333,-0.19992084,-0.22255194,-0.26293805,-0.31083934,-0.35312664,-0.38529712,-0.42103984,-0.46216557,-0.51114695,-0.57288389,-0.61135555,-0.63363208,-0.69898795,-0.72842927,-0.70390632,-0.62437502,-0.55738619,-0.52045938,-0.4789433,-0.41271513,-0.38396547,-0.31142047,-0.2314114,-0.18336243,-0.13274827,-0.054226035,0.024650337,0.047359648,0.1205086,0.17212093,0.20756841,0.28092481,0.37390197,0.42755054,0.44219413,0.54316057,0.61547867,0.66877957,0.71014572,0.80930851,0.87306948,0.92354018,0.9794062,1.0804985,1.1310761,1.1678642,1.2527888,1.32267,1.3729209,1.4212983,1.5203018,1.6151383,1.6672887,1.6836444,1.7521873,1.8161394,1.8637948,1.8881183,1.8728702,1.8459093,1.8268777:3
2.7672631,2.6407742,2.5088439,2.3643599,2.2464167,2.0964422,1.9485897,1.8383499,1.7292542,1.6213729,1.5154626,1.4162888,1.3288459,1.2066773,1.1314371,1.0808214,0.99201863,0.89287616,0.8156421,0.76785694,0.71079482,0.63733006,0.55869548,0.47385512,0.38629041,0.30282347,0.2408612,0.1198804,0.037310231,-0.076781121,-0.12264442,-0.18446858,-0.29547526,-0.37478304,-0.4871615,-0.5579576,-0.50333769,-0.4630548,-0.42687672,-0.36955633,-0.2906133,-0.18284527,-0.17785491,-0.14835308,-0.10563338,0.0042360876,0.035886355,0.15009612,0.22392945,0.26664356,0.20238158,0.11438006,0.025481432,-0.063644317,-0.13766419,-0.21742686,-0.29402678,-0.36021106,-0.43571268,-0.52446551,-0.59834052,-0.6730056,-0.74418914,-0.82635793,-0.91146895,-0.98664766,-1.0841505,-1.1515751,-1.2299851,-1.2972793,-1.3910702,-1.4528348,-1.5064971,-1.5505274,-1.6227489,-1.6424761,-1.5489211,-1.4565461,-1.3367483,-1.247392,-1.1514832,-1.0688381,-1.031112,-0.94902836,-0.87333531,-0.76791387,-0.63848414,-0.55805317,-0.45930433,-0.37688969,-0.3098304,-0.26667751,-0.18860768,-0.11194487,-0.015244968,0.11242655,0.21196266,0.30940661,0.38112529,0.48359761,0.59096757,0.69011375,0.79932093,0.9079975,1.0218454,1.1662651,1.2309972,1.1545586,1.0724607,1.0105908,0.93970988,0.91646316,0.871826,0.84300283,0.81330197,0.78292096,0.77445494,0.767572,0.72379589,0.68337555,0.66660177,0.67272049,0.67196457,0.66658922,0.61475034,0.59088178,0.51913529,0.46601492,0.46511236,0.45579982,0.48575883,0.45336521,0.4002191,0.39337146,0.2873742,0.32328993,0.24670472,0.20274752,0.13763347,0.16464874,0.064671589,0.047098672,-0.019066225,-0.025992467,-0.037770042,-0.10526079,-0.11286927,-0.17150853,-0.1285883,-0.20413376,-0.26892308,-0.32791793,-0.3329513,-0.33542181,-0.3696553,-0.43877245,-0.43840408,-0.5075034,-0.60634309,-0.58628174,-0.66652954,-0.75808833,-0.85508759,-0.87007801,-0.98301503,-1.1040008,-1.2092154,-1.1672421,-1.073302,-0.95174134,-0.80614117,-0.67719586,-0.53685426,-0.38610274,-0.23535732,-0.10304639,0.047772317,0.1801361,0.31253893,0.44506921,0.57890132,0.72855832,0.86109988,1.0119194,1.1628547,1.2618829,1.3851078,1.4483571,1.5601525,1.6134895,1.6679623,1.67817,1.7280834,1.632439,1.5241277,1.4748541,1.4611213,1.4641304,1.4561236,1.4387026,1.4215913,1.4247063,1.4239049,1.3341889,1.2035762,1.0706235,0.93725175,0.78615734,0.65299765,0.50439246,0.43540674,0.3096593,0.17661861,0.08724497,-0.033416815,-0.18484852,-0.31748119,-0.45031572,-0.60139713,-0.74623066,-0.88492537,-1.0047499,-1.1121358,-1.2604044,-1.197664,-1.1096276,-1.0322124,-0.95864101,-0.87984388,-0.80397379,-0.77941517,-0.69744684,-0.64765835,-0.56459677,-0.62308751,-0.57049087,-0.5337306,-0.44900181,-0.46929824,-0.37525481,-0.34438785,-0.24747209,-0.27105331,-0.24010737,-0.17212095,-0.12232012,-0.033625132,-0.12454389,-0.03650879,0.036568124,0.043099942,0.10336839,0.13940882,0.21766221,0.20258334,0.095270353,0.053147605,-0.02482315,-0.087206169,-0.01116267,0.046373733,0.0061696924,0.088936097,0.10335632,0.16512968,0.14550229,0.047293935,-0.028142946,-0.030005539,0.034845031,0.042923887,0.12180563,0.14303607,0.18545348,0.2526791,0.16327414,0.13292277,0.19309389,0.21004013,0.26327443,0.23207874,0.25819262,0.32860797,0.39916762,0.32746689,0.42682179,0.52401229,0.55498957,0.65455914,0.72997926,0.81420476,0.88584673,0.81971919,0.67726228,0.55768605,0.45690266,0.33280829,0.26187041,0.21036151,0.12582814,0.023372659,-0.043379421,-0.10270271,-0.21701029,-0.26665887,-0.35512231,-0.43429622,-0.48012197,-0.602803,-0.71688286,-0.81873619,-0.91506078,-0.9871229,-1.1016185,-1.1869635,-1.2626805,-1.3289472,-1.3614712,-1.4692041,-1.5518533,-1.6080366,-1.6966868,-1.7881266,-1.8835937,-1.9833979,-2.0667372,-2.1429532,-2.2482059,-2.3256668,-2.4145894,-2.4332585,-2.3266545,-2.2178444,-2.1839786,-2.0908105,-2.0092405,-2.0009217,-1.8872013,-1.8245551,-1.7150778,-1.6087422,-1.5662939,-1.4835041,-1.4022065,-1.393944,-1.4032079,-1.3225608,-1.2400692,-1.1575416,-1.1565618,-1.0448207,-1.0091721,-0.92962319,-0.8392862,-0.85875284,-0.87164318,-0.7633736,-0.72259259,-0.61762116,-0.57322196,-0.59886796,-0.49679262,-0.41118312,-0.3813171,-0.30253857,-0.19692182,-0.086800106,-0.16799426,-0.26498146,-0.34769869,-0.38997151,-0.46240276,-0.56414245,-0.60207428,-0.57285135,-0.65994856,-0.68050043,-0.67185599,-0.58889167,-0.47655903,-0.44028417,-0.35850988,-0.26019361,-0.14869005,-0.12791779,-0.15528878,-0.19073808,-0.094854518,-0.045524659,0.065610592,0.17523442,0.20553567,0.31213134,0.37502016,0.49901392,0.50209375,0.50104914,0.47021986,0.55377062,0.66666236,0.6960248,0.81357532,0.88606509,0.99408505,0.99424829,0.99200654,1.0209029,1.0989133,1.2402526,1.3343695,1.354251,1.3975213,1.5395047,1.5394952,1.6483084,1.707904,1.6970393,1.8031792,1.9094677,1.9942884,2.0435645,2.178925,2.2665095,2.3840903,2.495903,2.6015057,2.7028984:6
1.4615181,1.3757674,1.2784603,1.1771892,1.0679229,0.98092005,0.89025414,0.79673501,0.7081979,0.61900362,0.56727602,0.46727395,0.37055158,0.27078207,0.15766105,0.052445277,-0.063302049,-0.18979543,-0.22688622,-0.36346988,-0.4739768,-0.57594638,-0.68283085,-0.74101516,-0.78205981,-0.84407147,-0.81079527,-0.71207249,-0.58333202,-0.4529449,-0.3186633,-0.19025052,-0.074844659,0.043619541,0.16053959,0.27701758,0.38491805,0.46760797,0.56353716,0.66271565,0.7810268,0.88414621,0.98320327,1.093139,1.2058091,1.3173307,1.2865273,1.1628056,1.0231083,0.89096471,0.75671508,0.6666178,0.58860031,0.49464853,0.37752855,0.26976429,0.20750919,0.20318657,0.14787228,0.027258336,-0.086594209,-0.19600087,-0.30628297,-0.41818355,-0.52659231,-0.63969838,-0.72236244,-0.71534845,-0.75371078,-0.77235414,-0.86081952,-0.95660722,-1.0092981,-1.050485,-1.1177613,-1.1445896,-1.0962252,-0.95746399,-0.87837121,-0.77462168,-0.62720441,-0.51051503,-0.38022935,-0.26572561,-0.15254112,-0.030323814,0.063011993,0.18737606,0.32611421,0.43168254,0.5455318,0.67498863,0.80259391,0.94702332,1.0439193,1.0506017,0.95031627,0.87518337,0.74421393,0.6264915,0.49907479,0.44975171,0.41116027,0.29715576,0.15197034,-0.0080394514,-0.10902314,-0.23707065,-0.37345754,-0.50155726,-0.62453618,-0.77345448,-0.89487525,-1.0311341,-1.1681981,-1.2882259,-1.3972941,-1.4611918,-1.472545,-1.5486992,-1.470219,-1.4942647,-1.3762471,-1.2754468,-1.2263538,-1.1814661,-1.1680724,-1.1015328,-1.0188208,-0.91986352,-0.80626361,-0.71470281,-0.60680891,-0.53487821,-0.44779656,-0.34230313,-0.23526646,-0.14650718,-0.066708697,-0.057048451,-0.077197854,-0.050132327,0.035296945,0.12959784,0.22534549,0.32845329,0.43662244,0.53248564,0.54759382,0.59922222,0.69944223,0.79428653,0.90205633,1.0039642,1.0987122,1.2113749,1.3173614,1.416066,1.305954,1.1872051,1.0696724,0.95099904,0.8357563,0.7186312,0.60216008,0.48824694,0.38560184,0.27298741,0.15912791,0.040609301,-0.072849948,-0.18893456,-0.30725973,-0.42445665,-0.53611354,-0.61576281,-0.7036758,-0.79290729,-0.84855193,-0.83934273,-0.81369065,-0.73413441,-0.63671993,-0.52710183,-0.44577441,-0.36192736,-0.27475757,-0.15449559,-0.02890577,0.10957111,0.22675906,0.33640809,0.44837,0.53464961,0.59424524,0.64872731,0.75020534,0.85403837,0.95033026,1.0181125,1.0864914,1.1798341,1.2721844,1.3581134,1.2856172,1.1687749,1.0539886,0.94047724,0.82809209,0.71333972,0.61465316,0.52819865,0.50561402,0.57063085,0.65680341,0.74293358,0.79401806,0.89757177,0.92977128,0.94950602,0.99696324,1.0802821,1.1546616,1.2343083,1.3185428,1.4154482,1.5035192,1.5812174,1.4542244,1.3238079,1.1832144,1.0576383,0.97153091,0.94163524,0.81107444,0.66812073,0.54328334,0.40623979,0.31610283,0.26492575,0.24973105,0.23172691,0.10026699,-0.027975513,-0.15224924,-0.2747706,-0.39625162,-0.50964848,-0.61856325,-0.73212998,-0.84944779,-0.96272958,-1.0703893,-1.1834785,-1.2903301,-1.4056844,-1.5129266,-1.5436915,-1.6275348,-1.7320385,-1.8176382,-1.8599882,-1.9289884,-1.9128854,-1.8265674,-1.7567454,-1.6630056,-1.559968,-1.4593942,-1.347552,-1.2426155,-1.1306346,-1.0199069,-0.90888703,-0.79271168,-0.67600189,-0.56441852,-0.46115419,-0.37280496,-0.25774873,-0.14212665,-0.026548318,0.094427529,0.20863784,0.32532396,0.44978985,0.56735095,0.6821496,0.77987538,0.68468766,0.57842224,0.48615311,0.45464651,0.42885785,0.41768654,0.49700691,0.62283197,0.71408666,0.81451074,0.91482018,0.9794606,0.96452968,0.99371894,1.0674075,1.1546006,1.2215121,1.3086928,1.385712,1.3360892,1.2211098,1.1197798,1.0332696,0.94577903,0.86072817,0.7624,0.68832984,0.63570389,0.5348182,0.43021134,0.32308825,0.22458578,0.12112656,0.012764478,-0.089756596,-0.14270634,-0.086367665,-0.020895607,0.038167264,0.1214895,0.14899738,0.009226564,-0.13376953,-0.24967271,-0.38897682,-0.54352293,-0.69416416,-0.83588345,-0.95425419,-1.0247026,-1.1275999,-1.2663948,-1.3847946,-1.5104178,-1.5585565,-1.6989787,-1.8321605,-1.937081,-2.04486,-2.1622338,-2.2735049,-2.3466714,-2.3720598,-2.4425558,-2.4961208,-2.4792185,-2.5155943,-2.536844,-2.458718,-2.3441669,-2.2842049,-2.2130467,-2.1587548,-2.0434941,-1.9259508,-1.8107644,-1.7166643,-1.5960899,-1.5047988,-1.4224987,-1.3543908,-1.2645676,-1.1414697,-1.0245801,-0.96994172,-0.85050029,-0.73308299,-0.62197158,-0.50789269,-0.39035949,-0.2715639,-0.15489193,-0.043355214,0.074808563,0.18965449,0.26816315,0.2490248,0.22395282,0.21589366,0.32080705,0.4326308,0.52674339,0.64270114,0.76366238,0.87366476,0.94522348,1.0541691,1.1711844,1.2908681,1.4169554,1.5360721,1.6532628,1.7742122,1.7767364,1.695083,1.5903114,1.5038262,1.4350416,1.3591917,1.2991704,1.2349129,1.2364936,1.1817403,1.0838563,0.99535742,0.9025234,0.80971388,0.7139885,0.65132287,0.63790357,0.67706789,0.75197001,0.82922967,0.93757319,1.0773032,1.166209,1.2823821,1.4106102:5
0.33856963,0.30519324,0.28339219,0.27086421,0.27997022,0.30460821,0.35618382,0.39707574,0.4282562,0.45387173,0.46746945,0.48602131,0.49145289,0.48773033,0.47291822,0.41577203,0.34555711,0.27576543,0.18945422,0.098739401,0.028629905,-0.060236746,-0.12484033,-0.21054732,-0.28778064,-0.36996977,-0.45038349,-0.52512378,-0.60818149,-0.67312794,-0.76533117,-0.82842778,-0.91280986,-0.99237522,-1.0671746,-1.1445397,-1.2235867,-1.2988858,-1.3785925,-1.4566131,-1.5277484,-1.6079038,-1.6932047,-1.7676172,-1.8465319,-1.9252438,-1.9606552,-1.9971141,-1.9682845,-1.8823045,-1.8220896,-1.7653393,-1.6788032,-1.6057455,-1.5100364,-1.4353537,-1.3441855,-1.2644225,-1.168593,-1.0702299,-0.99264832,-0.8911029,-0.80532526,-0.7412265,-0.6572896,-0.58180847,-0.47730227,-0.39927182,-0.30967045,-0.21827996,-0.14038291,-0.062195061,0.015859983,0.094920112,0.16774597,0.21963492,0.27027257,0.34883537,0.41297819,0.44748409,0.46327635,0.45316651,0.44344547,0.43903854,0.47632043,0.55100255,0.6261045,0.70843273,0.79310758,0.87822075,0.96300577,1.0335596,1.1083146,1.1686275,1.246513,1.3025352,1.3576547,1.41816,1.4591306,1.4998673,1.5413978,1.5800946,1.6025391,1.6301193,1.6536898,1.6694937,1.6792446,1.6813444,1.6738435,1.6580867,1.6166877,1.5974996,1.5637166,1.5150664,1.4599884,1.3956179,1.3605653,1.3192169,1.2996925,1.2349456,1.1734876,1.1031262,1.0167752,0.92511687,0.85065729,0.76384643,0.67744837,0.58037406,0.48168675,0.39685507,0.33392511,0.27960451,0.29647432,0.37015004,0.43273048,0.50587225,0.57698311,0.65145549,0.73070484,0.80965645,0.87802164,0.95143143,1.0191369,1.0966087,1.1460438,1.1811345,1.2119861,1.1706623,1.1685133,1.0941837,1.0201638,0.94760427,0.87611514,0.80668748,0.73871566,0.67232157,0.60787545,0.54570715,0.48532108,0.42694195,0.370202,0.30836519,0.24360595,0.16906317,0.098003884,0.024388132,-0.049669647,-0.12545057,-0.18914958,-0.26027063,-0.32908282,-0.40697809,-0.48765374,-0.56324714,-0.63823639,-0.71047285,-0.78300809,-0.85469833,-0.93449009,-1.0144826,-1.0903185,-1.1746391,-1.2486639,-1.3329122,-1.409593,-1.4857886,-1.5624517,-1.6307883,-1.7209653,-1.7858679,-1.8615346,-1.941117,-2.009263,-2.0849821,-2.1402149,-2.0838368,-2.0281844,-1.9159973,-1.8301441,-1.7445225,-1.6591505,-1.5500754,-1.462132,-1.3550748,-1.2674477,-1.1573192,-1.0473164,-0.93872207,-0.83717657,-0.79515946,-0.7224821,-0.64715612,-0.59178156,-0.52349018,-0.47614239,-0.43985132,-0.42031289,-0.45197824,-0.48820987,-0.51424692,-0.54048645,-0.57687076,-0.60764074,-0.63283809,-0.59635783,-0.54627416,-0.51765095,-0.53413953,-0.55679041,-0.57388889,-0.5939836,-0.6138453,-0.63475247,-0.66861555,-0.69886532,-0.72858193,-0.75346466,-0.77600581,-0.7921591,-0.82879985,-0.8498382,-0.87305288,-0.89214336,-0.90426791,-0.93350876,-0.9552031,-0.98474484,-1.013934,-1.0285012,-1.0483083,-1.0775012,-1.0889227,-1.102572,-1.1208106,-1.1347621,-1.1428392,-1.1453969,-1.1449229,-1.1057368,-1.0476953,-0.99024332,-0.89576023,-0.79675256,-0.72396219,-0.64604335,-0.56117845,-0.50885373,-0.4395458,-0.37319546,-0.30876564,-0.25618846,-0.19752674,-0.21328818,-0.20400173,-0.16623746,-0.14740641,-0.091140755,-0.017441889,0.020577618,0.051418576,0.087825971,0.13097698,0.19320312,0.2537662,0.33622462,0.39300724,0.46904153,0.54767158,0.60343939,0.6797418,0.72901439,0.78246454,0.82924185,0.87500033,0.92909047,1.0088491,1.0943367,1.2007671,1.2831036,1.3636175,1.4409801,1.5016901,1.5030824,1.5862981,1.6323347,1.7260524,1.8129384,1.8947578,1.9500742,1.9716419,2.0096163,2.0081523,1.9483294,1.8780188,1.7891615,1.7322109,1.6617936,1.5954989,1.5155715,1.4048389,1.3491403,1.2688445,1.2265033,1.1746878,1.1819552,1.2147359,1.2526193,1.2864549,1.3122386,1.3286118,1.3342226,1.3227806,1.3104034,1.2842525,1.261725,1.2260438,1.1863217,1.1381877,1.0964397,1.0302234,0.9718336,0.9368657,0.90423254,0.88484608,0.86212373,0.83894694,0.8169911,0.80213019,0.78013198,0.75837778,0.72500708,0.69661692,0.66112581,0.63268367,0.59827363,0.57914768,0.54557482,0.50079668,0.45792329,0.43617164,0.40855548,0.3761571,0.34030462,0.3019707,0.26232286,0.22053033,0.14398846,0.073012492,-3.9257356E-4,-0.07816402,-0.14809921,-0.22540595,-0.30427917,-0.37643604,-0.45152156,-0.53130146,-0.61503008,-0.69679526,-0.78938735,-0.83567818,-0.90708916,-0.9475292,-0.96140149,-0.96052765,-0.95212118,-0.93750917,-0.92789835,-0.9101927,-0.89008431,-0.86689941,-0.84882499,-0.83085435,-0.81509796,-0.81022917,-0.78891927,-0.77471112,-0.75296932,-0.72534397,-0.7067324,-0.67151664,-0.64154721,-0.61399999,-0.58133564,-0.5488852,-0.52235588,-0.48499794,-0.44378651,-0.3976907,-0.35951227,-0.30082574,-0.25327714,-0.2032999,-0.16423616,-0.1487441,-0.18284297,-0.20484851,-0.16624503,-0.10613533,-0.061714796,-2.6137642E-4,0.047306798,0.09815155,0.15174509,0.2033661,0.25243906,0.29653223,0.32873733:2
1.3831894,1.3481051,1.2905262,1.2477764,1.1804854,1.1210795,1.037229,0.96390241,0.90387049,0.84374651,0.78207494,0.74067905,0.68691265,0.64220362,0.58707846,0.53911055,0.48497295,0.43565842,0.41247764,0.35324223,0.36031523,0.39343707,0.44626684,0.49663472,0.55335977,0.5977538,0.64330674,0.68107744,0.72020941,0.76680858,0.80467628,0.83287541,0.86610322,0.88832358,0.8925729,0.86844774,0.852429,0.83844012,0.80240542,0.78078864,0.74690709,0.720587,0.67533797,0.61261225,0.55557862,0.50930405,0.46212609,0.41434845,0.37361073,0.33070515,0.2884766,0.24078544,0.16379151,0.11836376,0.061048919,-0.0055662441,-0.084840349,-0.16706573,-0.25102167,-0.33548842,-0.41348036,-0.49676384,-0.57769763,-0.66204358,-0.714576,-0.79625394,-0.87922388,-0.94668153,-1.0110268,-1.0733476,-1.1409057,-1.2231742,-1.284965,-1.3517997,-1.4321995,-1.4915724,-1.5616234,-1.6361172,-1.7042956,-1.7669945,-1.7782996,-1.7852947,-1.7709734,-1.7160365,-1.6738813,-1.6121639,-1.5440369,-1.4907233,-1.4151433,-1.3426283,-1.354559,-1.3290251,-1.2917985,-1.2233851,-1.1744988,-1.0922688,-1.0326294,-0.95567251,-0.88458188,-0.82551895,-0.74586868,-0.69031516,-0.6411539,-0.59706716,-0.56241126,-0.54634111,-0.53501566,-0.52642986,-0.52191679,-0.52246036,-0.54110902,-0.54168979,-0.56276517,-0.58069615,-0.60018744,-0.62172901,-0.63933854,-0.65979558,-0.67294261,-0.68839994,-0.69681106,-0.71102949,-0.71932805,-0.74174365,-0.75252803,-0.7629487,-0.78720073,-0.79100737,-0.79633864,-0.78583312,-0.77178465,-0.76741439,-0.77195441,-0.75238575,-0.74553124,-0.72296242,-0.70874008,-0.67993422,-0.64618048,-0.62129274,-0.58196265,-0.54562148,-0.51828745,-0.47528364,-0.45053075,-0.40340246,-0.35887446,-0.32920855,-0.28393074,-0.25281196,-0.2262184,-0.1879553,-0.15405151,-0.14594653,-0.12289332,-0.099663294,-0.079696897,-0.042695433,-0.025397936,-0.0059133729,0.015891806,0.0294383,0.054061741,0.11545384,0.15487836,0.23511752,0.31447739,0.39657937,0.46571799,0.53439816,0.60157338,0.67686512,0.75016021,0.81247405,0.87834077,0.96403975,1.0303588,1.1022946,1.1749442,1.2437091,1.3113051,1.3911003,1.4580193,1.5230449,1.6126959,1.6702702,1.7386324,1.8103653,1.8717402,1.9402465,2.0268775,2.0910121,2.1164014,2.1454894,2.1440381,2.1374788,2.1525204,2.1157813,2.1095848,2.0729505,2.0181902,1.941368,1.8531629,1.7677493,1.6835381,1.5965757,1.506827,1.4361299,1.3565968,1.2753497,1.2039964,1.141078,1.0698567,0.99794207,0.91914356,0.86983936,0.81463135,0.75693385,0.70593125,0.65973688,0.63209655,0.61426692,0.61708398,0.63339932,0.66803085,0.62650485,0.66263212,0.71091884,0.74757702,0.7329728,0.76284996,0.77963074,0.7654705,0.72726375,0.71729706,0.70978876,0.68014332,0.65686104,0.62417748,0.59062733,0.5510817,0.5018935,0.45546849,0.40566336,0.35012161,0.29231203,0.23592595,0.17670726,0.12361997,0.067432615,0.021435126,-0.019860302,-0.058029643,-0.087730575,-0.11505558,-0.13176543,-0.15474662,-0.18445257,-0.20571478,-0.24885317,-0.26857173,-0.2935094,-0.32070565,-0.34916733,-0.38012781,-0.42242376,-0.44509409,-0.49812662,-0.5317814,-0.54875395,-0.57900937,-0.61391052,-0.65421424,-0.7309607,-0.79437378,-0.8784635,-0.94171309,-1.0068297,-1.0731786,-1.1275782,-1.2021318,-1.2628716,-1.3193761,-1.3744639,-1.4358329,-1.5104807,-1.5645277,-1.611143,-1.6626876,-1.7042645,-1.7591148,-1.7647443,-1.7894091,-1.7864413,-1.7695347,-1.7516249,-1.7278695,-1.6999743,-1.659369,-1.6165305,-1.5762559,-1.5362413,-1.4823783,-1.4418814,-1.3873952,-1.3649369,-1.3367513,-1.3234666,-1.2973207,-1.2708367,-1.2411253,-1.2215346,-1.1763456,-1.145394,-1.1009527,-1.0600435,-1.0300178,-1.0014123,-0.96478555,-0.93034697,-0.89536904,-0.86679549,-0.82915847,-0.78688142,-0.75359348,-0.7231394,-0.6818227,-0.64142409,-0.60574516,-0.56860171,-0.52641686,-0.48539591,-0.44782647,-0.41345606,-0.36870202,-0.33815571,-0.3097956,-0.27785587,-0.25014628,-0.22852726,-0.20232889,-0.17008925,-0.15726431,-0.15080167,-0.15657559,-0.17091049,-0.2058304,-0.23228139,-0.26400301,-0.30312661,-0.34491498,-0.38477632,-0.44423151,-0.48123579,-0.51612085,-0.58725004,-0.65814893,-0.70281648,-0.77389891,-0.85082482,-0.89271896,-0.89359809,-0.94756215,-0.96700131,-0.89850753,-0.83981935,-0.77828279,-0.70753067,-0.6576188,-0.57726559,-0.51470198,-0.45801337,-0.38569779,-0.3229803,-0.2609027,-0.18979012,-0.13724143,-0.069589975,-0.010447318,0.059280189,0.12509387,0.18723759,0.25152472,0.31717022,0.38771257,0.44974711,0.51143342,0.58553284,0.65044309,0.71338168,0.78433964,0.85355497,0.92274347,0.99148942,1.0660088,1.1453352,1.219936,1.2928846,1.3680047,1.4273512,1.4579524,1.4699045,1.4651054,1.4508244,1.4384867,1.3950655,1.3489206,1.2895339,1.248706,1.2075741,1.246982,1.3079708,1.3495659,1.3889928,1.423511,1.452948,1.4712861,1.4897202,1.5139434,1.5519062,1.5078049,1.4823569,1.4398827,1.411926,1.394568,1.4409353,1.4079231:2
1.3465626,1.3315417,1.326586,1.298188,1.2291566,1.1595012,1.0850442,0.98730538,0.88040299,0.77356963,0.66183514,0.55543934,0.44166594,0.3300376,0.20895947,0.10188598,-0.014159782,-0.12165159,-0.22517653,-0.33393015,-0.44193401,-0.5610417,-0.67682593,-0.79746554,-0.90525894,-1.0249691,-1.1415323,-1.2621383,-1.3802983,-1.4767398,-1.5661956,-1.4733592,-1.3833794,-1.2807487,-1.2015001,-1.1887579,-1.1028492,-1.0634944,-0.98691951,-0.98428418,-0.89354495,-0.88850444,-0.82605865,-0.77756798,-0.74830051,-0.74847026,-0.64964891,-0.64519573,-0.60424889,-0.55456724,-0.50638196,-0.53145478,-0.56067099,-0.53628705,-0.4802372,-0.41399596,-0.39449696,-0.37396334,-0.33612028,-0.30278638,-0.25357652,-0.21647753,-0.18128079,-0.13440512,-0.093788291,-0.10555189,-0.14869575,-0.1806248,-0.15948158,-0.13380559,-0.1047685,-0.068540535,-0.012258087,0.021444832,0.06650496,0.092269507,0.079612848,0.039125469,0.031764205,0.065855061,0.10056758,0.12627757,0.12292955,0.14094176,0.18588717,0.21935034,0.23643709,0.24428202,0.29497828,0.33424317,0.39587695,0.466569,0.53740349,0.61997912,0.69358638,0.76286513,0.79797244,0.70670264,0.60896444,0.51014183,0.41057207,0.32733288,0.23270234,0.12775652,0.0799939,-0.030279981,-0.12416188,-0.19648179,-0.29905992,-0.3355982,-0.41703295,-0.51821478,-0.6133506,-0.70641154,-0.76964672,-0.86616938,-0.955218,-1.0121433,-1.0874937,-1.0589703,-1.0064919,-0.92293083,-0.84119542,-0.75617142,-0.67396033,-0.57737842,-0.4855329,-0.41899447,-0.32496686,-0.21694537,-0.11615511,-0.022084381,0.083018928,0.1520237,0.24066866,0.24749772,0.14623158,0.067300801,-0.036436609,-0.064298245,-0.11032244,-0.21101735,-0.27174124,-0.3675994,-0.36484725,-0.37432317,-0.48071374,-0.55317528,-0.59816238,-0.67661323,-0.7568197,-0.73331838,-0.74175753,-0.64113787,-0.53573186,-0.41512601,-0.2874278,-0.1538016,-0.04409624,0.047197843,0.077192283,0.081882484,0.096454566,0.17564612,0.27257089,0.36611147,0.46963647,0.54493285,0.60792682,0.66070678,0.6111432,0.66330282,0.77274278,0.86303236,0.97891772,1.059621,1.1337286,1.2015634,1.1609333,1.1748909,1.229186,1.31522,1.3985929,1.4794985,1.4982191,1.5281719,1.6391201,1.7257393,1.8129697,1.8620678,1.963334,2.0765732,2.1745674,2.280345,2.3926898,2.5035418,2.60652,2.5214483,2.3924683,2.2612661,2.1294009,2.0367216,1.9357093,1.8758073,1.7632029,1.6851132,1.6475203,1.5428705,1.4106136,1.4157894,1.4074235,1.2942116,1.2333063,1.1197527,1.1402121,1.1598825,1.0538175,0.98757688,0.87404853,0.82104603,0.6996643,0.62935527,0.64749055,0.67083627,0.62003874,0.52604469,0.46060679,0.37948549,0.26733049,0.22961733,0.15780911,0.045408545,0.0032156942,-0.10761328,-0.11073419,-0.10487955,-0.10785955,-0.20951774,-0.29425452,-0.32848444,-0.43292978,-0.54119518,-0.58699269,-0.69335774,-0.79180101,-0.85389017,-0.93931078,-0.98014189,-1.0910344,-1.1788441,-1.2759273,-1.3846655,-1.4088718,-1.5073124,-1.6113155,-1.7153371,-1.7345457,-1.8346378,-1.9425437,-2.0297111,-2.1304949,-2.2388119,-2.2682461,-2.2510084,-2.207069,-2.161477,-2.102933,-2.0422634,-1.973929,-1.908604,-1.8508323,-1.7773229,-1.7093367,-1.6366268,-1.5527311,-1.4597871,-1.3648525,-1.2756096,-1.1808859,-1.0858978,-0.99802546,-0.90919416,-0.85616272,-0.93457783,-0.90818299,-0.92361346,-1.0004486,-1.1025089,-1.0598556,-1.0967466,-1.0803009,-1.0971619,-1.1605529,-1.1299283,-1.1683267,-1.125906,-1.0685315,-0.99413821,-0.8955083,-0.79333719,-0.72847557,-0.62343419,-0.53304634,-0.40093458,-0.35546971,-0.25233071,-0.15104822,-0.065109439,0.044577135,0.12580417,0.24512458,0.28311267,0.40857739,0.50441736,0.56877695,0.6554447,0.77069583,0.79552312,0.9010154,0.97578211,1.1055592,1.1976982,1.3218094,1.4076617,1.5129247,1.6221246,1.7411081,1.8510705,1.7713846,1.6737425,1.576435,1.5148712,1.3844207,1.3622747,1.2836315,1.1870463,1.252777,1.185891,1.0821363,1.0475127,0.97743171,1.0198693,1.0393572,0.96740429,0.86567491,0.85441127,0.7521562,0.7957919,0.82932638,0.82345593,0.74436692,0.73004414,0.64039485,0.55834884,0.57165961,0.47381907,0.40296671,0.37518709,0.44022647,0.52589175,0.46763291,0.37935471,0.40499063,0.33508852,0.24046557,0.27235693,0.21143117,0.12555743,0.035183545,0.12772219,0.16833001,0.2715404,0.19338874,0.17362159,0.081975944,0.076694881,-0.0073807358,-0.047458337,-0.045758205,-0.120223,-0.19798862,-0.28295375,-0.37285222,-0.33379256,-0.41383306,-0.50272952,-0.57795735,-0.66039655,-0.71557971,-0.81359214,-0.89806686,-0.96195987,-1.0321972,-1.0631382,-1.1679076,-1.2961914,-1.4256511,-1.5739937,-1.576583,-1.4662777,-1.34877,-1.2925779,-1.1867054,-1.0730454,-0.96701468,-0.84801268,-0.73612836,-0.62662714,-0.50599881,-0.4002251,-0.28536411,-0.16529943,-0.06199045,0.05865848,0.16131035,0.28093985,0.39524405,0.47941835,0.58844202,0.6932628,0.81259357,0.92470068,1.0032561,1.1000758,1.1455011,1.215535,1.3124764:6
1.4130974,1.3642052,1.2978906,1.2655223,1.2028719,1.1764892,1.1198976,1.0549843,1.0533149,1.0001435,0.98709728,0.94940196,1.0222203,0.98247584,0.9497633,0.91576062,0.86056983,0.79244858,0.87033096,0.85276682,0.82187383,0.78210247,0.82559336,0.80007137,0.75956966,0.73024103,0.69555711,0.65599853,0.70615032,0.68504498,0.63355648,0.62718334,0.624766,0.61301416,0.55897765,0.50822316,0.53777799,0.55295859,0.49059175,0.46607424,0.4451384,0.37899614,0.33511516,0.30564902,0.23845922,0.16818695,0.089548647,0.030357576,-0.045368364,-0.13926497,-0.21294273,-0.29341731,-0.38282873,-0.393987,-0.34137301,-0.30401438,-0.19663681,-0.0674916,0.065100773,0.19769623,0.34364106,0.47352158,0.50869572,0.4085475,0.29812677,0.16552553,0.029760991,-0.071447967,-0.17797031,-0.2754612,-0.33601504,-0.39963774,-0.32799293,-0.22198572,-0.11446084,-0.04281038,0.057308106,0.13849137,0.19933797,0.28045246,0.33477568,0.40145716,0.39130952,0.46149186,0.53498756,0.61394675,0.67620311,0.664074,0.75532195,0.83651857,0.83578222,0.92176589,0.91461328,0.98165261,0.95423075,0.88225309,0.84652283,0.94770676,0.94806954,1.0385685,1.0560975,1.1131488,1.1268977,1.0308382,1.0348051,1.110701,1.150752,1.1949275,1.2402487,1.1889637,1.2172844,1.2781785,1.287951,1.3336111,1.3798591,1.286893,1.3379386,1.3965719,1.4055047,1.4499273,1.5102265,1.5356326,1.5872553,1.6086308,1.5139558,1.4180371,1.3355999,1.2417155,1.1694235,1.0741062,1.0043706,0.93283849,0.83417648,0.76548386,0.68475805,0.60873493,0.51587274,0.42775978,0.34043248,0.27911414,0.18979087,0.11139217,0.047544399,-0.03348315,-0.11448206,-0.18431282,-0.27533274,-0.33902284,-0.41387524,-0.49325963,-0.58234162,-0.65573919,-0.69333522,-0.77667463,-0.83167586,-0.87746407,-0.95535262,-1.0426987,-1.0944529,-1.169866,-1.1727277,-1.2065925,-1.2427151,-1.2254726,-1.2466416,-1.3189629,-1.3012483,-1.2859249,-1.298423,-1.2281734,-1.2465069,-1.1760737,-1.1069237,-1.0085625,-0.95660835,-0.95371945,-1.085555,-1.2144106,-1.3418103,-1.4687382,-1.5546618,-1.6761812,-1.7930037,-1.8895935,-1.9612775,-1.9692705,-1.9068924,-1.7802705,-1.6557063,-1.5500393,-1.4320941,-1.3480975,-1.2926654,-1.1907285,-1.1628649,-1.0950092,-1.036708,-0.9930561,-0.90368545,-0.81740967,-0.78625756,-0.67969072,-0.6406344,-0.5411702,-0.49507957,-0.4820192,-0.38384382,-0.34742234,-0.29890623,-0.20169433,-0.12666878,-0.04047015,-0.093986886,-0.012840233,0.082545117,0.16132712,0.14483511,0.23252414,0.330423,0.36534366,0.44099215,0.38954019,0.28568333,0.23223688,0.12691621,0.088802701,0.0092638221,-0.086615695,-0.16024272,-0.20085401,-0.29791651,-0.3549631,-0.35375964,-0.25568031,-0.17521815,-0.1068502,0.006602376,0.060785221,0.14795739,0.2621886,0.22562233,0.29852979,0.38062513,0.48148725,0.52597375,0.65718218,0.71914235,0.79890965,0.90505765,0.86344009,0.85210062,0.96870647,1.0112486,1.0995654,1.1639436,1.1668653,1.2752485,1.3279138,1.4237537,1.4573728,1.5364088,1.6420375,1.6980289,1.8029879,1.88929,1.9328948,2.0416446,2.1158034,2.2026164,2.1991394,2.0890772,2.0138876,1.9150754,1.823589,1.71755,1.6663575,1.5539784,1.4627775,1.4215975,1.3575392,1.2775966,1.1575968,1.1574855,1.081159,0.9807908,0.91776962,0.81875197,0.83052131,0.79905965,0.69236493,0.63130512,0.52685907,0.48588321,0.36533187,0.28294835,0.26506633,0.27730996,0.17947576,0.076175521,0.032131672,-0.075830277,-0.16174399,-0.21188478,-0.31245255,-0.41842764,-0.52477566,-0.59816144,-0.69980854,-0.80101199,-0.88400864,-0.8493345,-0.74830344,-0.69400692,-0.59641158,-0.62671119,-0.55837919,-0.51280067,-0.41306578,-0.36572359,-0.3387879,-0.27076968,-0.16860076,-0.11317911,-0.0092828695,-0.041873091,-0.097108712,-0.19732057,-0.18551129,-0.27940887,-0.37470785,-0.41030761,-0.42465102,-0.51773315,-0.58051125,-0.65511879,-0.61126693,-0.69925382,-0.77339934,-0.84578398,-0.91266142,-0.99529821,-1.0946494,-1.1560489,-1.2263843,-1.3129571,-1.3999811,-1.4815081,-1.5948798,-1.6723725,-1.7386085,-1.7296546,-1.8124634,-1.8305151,-1.8934953,-1.9530911,-1.9861109,-2.0047381,-1.9805653,-1.8626769,-1.742549,-1.6311096,-1.5042231,-1.3889939,-1.2589777,-1.1417259,-1.0166521,-0.91472845,-0.89116089,-0.99991206,-1.1279843,-1.2315447,-1.3389331,-1.3719358,-1.3631814,-1.3609341,-1.2797215,-1.2044589,-1.1014597,-1.049075,-1.0933571,-1.1758992,-1.2785243,-1.3580058,-1.4738483,-1.5041816,-1.5766685,-1.54011,-1.5354594,-1.4719939,-1.3833883,-1.3781013,-1.3381864,-1.2871348,-1.2078878,-1.1828942,-1.1035182,-1.0653805,-0.99070868,-0.91783602,-0.8396725,-0.77227086,-0.6872139,-0.63343807,-0.56012321,-0.47294581,-0.39178362,-0.31416811,-0.22978202,-0.15655357,-0.079792656,-0.006721848,0.071480802,0.16565161,0.24587311,0.2912395,0.36310363,0.44782813,0.52022225,0.61025746,0.71679047,0.77619093,0.86142009,0.95097429,1.0424203,1.134023,1.2286238,1.3310997:6
0.74500014,0.63543783,0.53894077,0.42801391,0.32344257,0.21812593,0.11683518,0.032337941,0.039280916,-0.035633885,-0.14161563,-0.22709836,-0.31971396,-0.42854656,-0.53638652,-0.60380552,-0.70584971,-0.77975627,-0.84942249,-0.92360289,-0.98038552,-1.0107218,-1.0285494,-1.0217672,-0.97374706,-0.91718087,-0.81889081,-0.72473343,-0.62490884,-0.52207448,-0.41575236,-0.32423425,-0.22860774,-0.12470206,-0.032355788,0.055812927,0.16759851,0.25079246,0.36152651,0.44801219,0.55978034,0.64693375,0.74951546,0.77537952,0.85762968,0.95914981,1.0537053,1.1597281,1.2505651,1.2518072,1.1697088,1.0814578,0.9932002,0.9057203,0.80546227,0.72925634,0.66701513,0.65455372,0.65869963,0.68415604,0.74218793,0.83812079,0.93192368,1.0517265,1.1761087,1.3021245,1.4089203,1.5352231,1.6613865,1.7452161,1.6532966,1.6636711,1.7896538,1.8889164,1.8287742,1.8354305,1.7729414,1.6673663,1.5609229,1.4568381,1.368548,1.2697244,1.2019113,1.1801483,1.2075685,1.2559311,1.3170101,1.3947826,1.4690669,1.5449677,1.5794211,1.477232,1.3702297,1.2409302,1.1391704,1.0083236,0.87484909,0.74319459,0.63153678,0.52111775,0.41459319,0.2951773,0.19057728,0.057547928,-0.074073235,-0.20583203,-0.33201331,-0.41885592,-0.48374795,-0.50141667,-0.48267629,-0.46340486,-0.45700492,-0.45577367,-0.40786637,-0.33389331,-0.27603507,-0.20803334,-0.13005697,-0.035631445,0.055316238,0.14352278,0.24058235,0.33299274,0.38034437,0.41075428,0.49639965,0.59520886,0.64081725,0.53966591,0.4104254,0.30769752,0.1962761,0.081844492,0.02402644,0.024304193,-0.086191724,-0.18705489,-0.28613114,-0.39005866,-0.48781088,-0.58276575,-0.68932447,-0.8090438,-0.93199118,-1.0298258,-1.1324079,-1.2353746,-1.3405012,-1.4512891,-1.5576245,-1.6338256,-1.6657855,-1.6953033,-1.6993651,-1.7110967,-1.6936623,-1.6608004,-1.6052895,-1.53479,-1.4196893,-1.318216,-1.2127773,-1.1170518,-1.0223039,-0.92143859,-0.80358863,-0.67821687,-0.57905184,-0.48709726,-0.3802737,-0.29313702,-0.24127974,-0.176178,-0.25675402,-0.34210428,-0.42706833,-0.50841317,-0.58569868,-0.6626616,-0.66892518,-0.62940904,-0.70940407,-0.78667222,-0.86534463,-0.94640788,-1.0213555,-1.0890128,-1.1614673,-1.2182409,-1.2765113,-1.3225226,-1.3659292,-1.4163376,-1.4639127,-1.515574,-1.568519,-1.6038219,-1.6400969,-1.6649916,-1.6729005,-1.6328438,-1.5590001,-1.4818526,-1.3939423,-1.2996883,-1.2018354,-1.0928436,-1.0014094,-0.89691885,-0.79750089,-0.68886177,-0.60150677,-0.52857843,-0.46428327,-0.38701802,-0.33177162,-0.24780239,-0.12422078,-0.036809494,0.032067591,0.076820684,0.14097496,0.17546976,0.13912309,0.12111003,0.059017656,-7.8557391E-4,-0.042821056,-0.041776958,-0.07821616,-0.11213087,-0.12586516,-0.14367036,-0.14627487,-0.14373931,-0.13143735,-0.13607357,-0.12347986,-0.10313096,-0.086975586,-0.072793164,-0.062621952,-0.059917047,-0.046686549,-0.02413734,0.033784878,0.13104709,0.22232159,0.30762455,0.39203767,0.47508648,0.50215662,0.42240564,0.40711065,0.50194228,0.6046986,0.66448131,0.73079454,0.7930163,0.82808659,0.84918199,0.88952702,0.91613804,0.94704955,0.96801328,0.98957718,1.0144623,1.0326047,1.0497113,1.0582628,1.0690426,1.097954,1.1182724,1.1329143,1.1583748,1.1842729,1.242964,1.3635723,1.4943186,1.6010083,1.706353,1.8118049,1.9424036,2.0466199,2.177013,2.2824674,2.4007495,2.3365565,2.2368334,2.1369346,2.005385,1.9015674,1.7926069,1.6817387,1.5596293,1.4705794,1.3979523,1.3697194,1.370656,1.3837472,1.3968478,1.3880847,1.3689489,1.3402198,1.3048299,1.2651402,1.2103847,1.1585062,1.1187144,1.066928,1.0048126,0.96545271,0.91149557,0.80060238,0.70688361,0.63100765,0.58232913,0.53723786,0.49892057,0.46918201,0.44487409,0.43189496,0.41739747,0.41385261,0.40147403,0.39262983,0.40211627,0.37174671,0.36151052,0.37438408,0.40417068,0.38011479,0.38359739,0.3252258,0.26095704,0.19933935,0.13207911,0.061122774,-0.019846508,-0.096776119,-0.17124694,-0.25088896,-0.34147431,-0.42387135,-0.53497186,-0.63852832,-0.70160613,-0.76676594,-0.82146337,-0.86160891,-0.8987915,-0.91595451,-0.92237117,-0.92294751,-0.88575806,-0.84970902,-0.81030676,-0.77058023,-0.73321282,-0.69128473,-0.65239143,-0.64479703,-0.67697973,-0.72199709,-0.70144113,-0.66141206,-0.6057497,-0.56504536,-0.50177495,-0.46503604,-0.42052022,-0.43871732,-0.52588595,-0.62417808,-0.73328484,-0.85000513,-0.94296145,-1.0602294,-1.1543986,-1.2469732,-1.3418978,-1.4331055,-1.5265056,-1.6173729,-1.7127396,-1.7880261,-1.8630496,-1.9018658,-1.922431,-1.9204171,-1.9062188,-1.8758049,-1.8268178,-1.7821337,-1.7165638,-1.6498975,-1.5870547,-1.5077212,-1.4384573,-1.3617569,-1.2887364,-1.209065,-1.121658,-1.0410435,-0.96196937,-0.88366209,-0.7988164,-0.71371054,-0.6264684,-0.54105002,-0.44906451,-0.35077643,-0.25736839,-0.21853859,-0.1896866,-0.19199428,-0.10879769,-0.01485259,0.0719458,0.16684262,0.24644785,0.33941042,0.42288785,0.51808713,0.60465634,0.70200825:4
1.9734796,1.9267335,1.8404754,1.7303949,1.573078,1.4555544,1.3495969,1.3799847,1.2526648,1.2028278,1.0598305,1.0805723,1.0001584,0.95036301,0.8984615,0.8011093,0.74936118,0.81752844,0.65945554,0.61941013,0.63691054,0.62843482,0.56337189,0.48438896,0.30091595,0.23270868,0.092562857,-0.066379338,-0.23755099,-0.30391673,-0.4169384,-0.43281481,-0.44336076,-0.34964337,-0.29240123,-0.09143311,0.091638299,0.092341877,0.10818288,0.19579073,0.4009115,0.57545044,0.73667797,0.69577715,0.88020039,1.080538,1.1535959,1.2759141,1.4699336,1.6517588,1.8403021,1.927084,1.8650931,1.7540589,1.6524862,1.5184864,1.424476,1.2837555,1.1533182,1.0386621,0.93607203,0.78068654,0.62342224,0.45409501,0.33314479,0.17650144,0.15481268,0.11195301,0.028619141,-0.046386153,-0.080236019,-0.15758014,-0.23260869,-0.27522094,-0.32150727,-0.41032749,-0.24987096,-0.22891687,-0.36922318,-0.18552797,0.029352989,0.20469953,0.2043388,0.42488728,0.62018817,0.76257793,0.94858831,1.1735992,1.1886651,1.0930409,0.96681802,0.89080667,0.8082508,0.67918659,0.721185,0.62912805,0.53071506,0.421741,0.37375069,0.38651193,0.32340443,0.20806966,0.21338347,0.10188016,-0.0050601558,-0.1039213,-0.14533816,-0.057419912,-0.098418292,-0.16968178,-0.26702875,-0.33818116,-0.41352626,-0.42232716,-0.48880375,-0.59000072,-0.71535336,-0.84324653,-0.89614602,-0.82030214,-0.70508105,-0.60009367,-0.49932302,-0.40981143,-0.35813427,-0.33215818,-0.31503243,-0.37509483,-0.47141637,-0.58618058,-0.63761351,-0.65312928,-0.78405475,-0.91450016,-0.95139824,-1.0338887,-1.1225507,-1.2684889,-1.3844648,-1.4396643,-1.377796,-1.4050162,-1.5576098,-1.7040378,-1.8771293,-1.8787821,-1.7312124,-1.5618697,-1.350799,-1.1898521,-1.0286572,-0.79048579,-0.60559005,-0.43041883,-0.29361696,-0.1296538,0.068997676,0.24608804,0.42293372,0.54509896,0.77750645,0.95247964,1.1428962,1.333999,1.3926187,1.5645873,1.77839,1.9475333,2.1348745,2.3060397,2.4148824,2.2950764,2.1224269,1.9467928,1.7353212,1.5218874,1.3035272,1.0954574,0.91218754,0.70839197,0.50250458,0.27823715,0.092405726,-0.099277744,-0.3163903,-0.49809615,-0.70320804,-0.89275078,-1.0916807,-1.3079143,-1.4873851,-1.6828729,-1.9055795,-2.0727158,-2.1435995,-1.9414559,-1.8440925,-1.6012513,-1.5219636,-1.4037712,-1.2930696,-1.1691262,-1.0644387,-1.0943465,-0.98251079,-0.88748187,-0.95427791,-0.83851448,-1.0004381,-1.1719521,-0.97666063,-1.001867,-1.0094832,-0.92688362,-0.90485612,-0.95706058,-1.0211923,-0.98754483,-0.85334075,-0.7469381,-0.675161,-0.58310029,-0.49500411,-0.39695135,-0.26419627,-0.33580067,-0.29828463,-0.27439917,-0.29543778,-0.20023531,-0.12918538,-0.136296,-0.0035161363,-0.042578318,-0.078425806,-0.13023968,-0.068546562,0.079669925,0.10059375,0.20411111,0.21619661,0.37697945,0.40752751,0.52682621,0.56929191,0.45431329,0.54944071,0.68624778,0.74754277,0.89741066,0.92885036,1.1095675,1.2446635,1.3959699,1.1930726,1.0200219,0.82610775,0.64000238,0.61966487,0.4613348,0.28156652,0.10056284,-0.074701922,-0.15794876,-0.34505594,-0.32920422,-0.23527791,-0.15542521,-0.13820893,-0.0021695092,0.022810364,0.1149212,0.26725394,0.31681703,0.40345097,0.48075302,0.62751769,0.54577057,0.64470248,0.71844236,0.85494316,0.9232689,0.99028521,1.1471033,1.245164,1.3456773,1.4522715,1.4266324,1.5566889,1.5748805,1.4878295,1.3785231,1.199083,0.99490271,0.87156819,0.75328149,0.55315157,0.34239174,0.13283781,0.17178249,0.054024352,-0.092972368,-0.24650218,-0.47919449,-0.59328358,-0.79412155,-0.63844023,-0.69829718,-0.79205515,-0.68284168,-0.54594735,-0.4426703,-0.31458543,-0.21989935,-0.078973802,0.013314911,-0.17296121,-0.061207982,0.060331866,0.21625763,0.30132379,0.42131641,0.514672,0.59370472,0.67802196,0.79681968,0.93040713,1.108877,1.1084424,1.0803279,1.256155,1.3076636,1.3267286,1.2157261,1.0687626,0.97194277,0.80760741,0.77185886,0.55560518,0.4056185,0.36607289,0.34707771,0.16934045,0.061307592,-0.10765699,-0.33136421,-0.47911782,-0.5954531,-0.71469735,-0.6936521,-0.89541705,-0.84605558,-0.93854075,-1.134368,-1.0493466,-1.2214951,-1.4353115,-1.502692,-1.5353455,-1.6242294,-1.7730352,-1.7347487,-1.8371746,-2.0184918,-2.0261813,-2.1299501,-1.9439401,-1.7752213,-1.5851319,-1.3632672,-1.1806106,-1.0750744,-0.92489726,-0.80860919,-0.66553368,-0.69424933,-0.83897644,-0.76872914,-0.56363711,-0.49603386,-0.38079965,-0.53455374,-0.64575325,-0.49042612,-0.58945072,-0.7333338,-0.74621939,-0.54665054,-0.48738208,-0.61462743,-0.74144362,-0.85486417,-0.99236684,-1.1316469,-1.2628627,-1.3384947,-1.5078946,-1.5706967,-1.7216549,-1.7389294,-1.8627695,-1.7951472,-2.0212474,-1.9904019,-1.7234056,-1.4784178,-1.2576871,-1.0662306,-0.87812265,-0.65723187,-0.38960497,-0.38444321,-0.24806825,-0.054848015,0.12556937,0.31306716,0.33473787,0.51828359,0.69762526,0.82775151,0.97416757,1.1678513,1.3242972,1.4764873,1.6855963,1.8142804,1.99716:1
1.348022,1.2822136,1.1940038,1.125385,1.0396996,0.96063392,0.88467812,0.80374327,0.72846894,0.64507714,0.56098993,0.48203375,0.40645893,0.32955472,0.25192818,0.17354942,0.093490521,0.01765621,-0.0704948,-0.14607683,-0.24177418,-0.32758761,-0.409016,-0.49753922,-0.58922204,-0.6832804,-0.76888901,-0.85943535,-0.9451916,-1.0333114,-1.1208924,-1.2097926,-1.2959738,-1.3634927,-1.2777101,-1.179875,-1.0539768,-0.92838887,-0.80281439,-0.69932589,-0.58314823,-0.48495887,-0.38832768,-0.29021534,-0.19334307,-0.11379014,-0.043672822,0.031912113,0.093251921,0.1594297,0.21451937,0.26306012,0.30293602,0.2575319,0.2116707,0.16951565,0.12204931,0.06990293,0.017176915,-0.034405576,-0.083556759,-0.11253946,-0.097025237,-0.11320732,-0.14329378,-0.17863472,-0.20884104,-0.24584627,-0.28012937,-0.32642608,-0.37204393,-0.42063273,-0.46543754,-0.52487821,-0.57638916,-0.6291806,-0.6856834,-0.74814179,-0.81335874,-0.87283943,-0.93804783,-1.0076566,-1.063353,-1.1156316,-1.1742673,-1.2327557,-1.2898276,-1.3408965,-1.3793815,-1.4293088,-1.5014798,-1.4937817,-1.4142637,-1.3297191,-1.2330031,-1.1454153,-1.0571096,-0.96555822,-0.87711223,-0.7825506,-0.70246791,-0.63477156,-0.60129124,-0.54649723,-0.52042808,-0.50134647,-0.47781847,-0.47876508,-0.45528892,-0.44603068,-0.44222797,-0.43840329,-0.42321455,-0.41672525,-0.41048262,-0.40526115,-0.39760903,-0.38871495,-0.38835696,-0.37654034,-0.37461029,-0.37626431,-0.37351201,-0.36727311,-0.3613892,-0.35468255,-0.35215884,-0.3518661,-0.34357745,-0.33118058,-0.34302729,-0.30938321,-0.20999945,-0.1346026,-0.034502982,0.068204049,0.14622596,0.21324432,0.27475999,0.32518903,0.36269303,0.40688344,0.46841632,0.52443792,0.58568659,0.64673964,0.71719393,0.79215112,0.85573588,0.93199281,0.98297494,1.0545791,1.1047019,1.1500374,1.1991018,1.2351559,1.2601013,1.2792921,1.2855716,1.2781652,1.2588356,1.2431996,1.2438208,1.2540295,1.2849771,1.357517,1.4329071,1.5257465,1.6137299,1.7032932,1.7907468,1.8829148,1.9732222,2.0672114,2.1594862,2.250913,2.3514503,2.4226234,2.5042852,2.5372263,2.4974024,2.3994121,2.3055323,2.2079259,2.1312447,2.0353388,1.9513036,1.8572036,1.7694128,1.675499,1.5858036,1.4959712,1.3987508,1.3095686,1.2704165,1.2531837,1.2558461,1.2137804,1.1806406,1.1042989,1.0306642,0.99259449,0.95584115,0.91730118,0.87220451,0.83153685,0.75703708,0.72617117,0.68099241,0.62292113,0.57906771,0.51031639,0.45912129,0.41339316,0.36889505,0.32966893,0.27216302,0.23820971,0.17695472,0.10345827,0.037481074,-0.041189341,-0.11147588,-0.18522817,-0.24964415,-0.3394693,-0.42236595,-0.5253516,-0.61113605,-0.63882475,-0.63455649,-0.62836496,-0.60217978,-0.5749996,-0.54364206,-0.51179179,-0.47447219,-0.44273124,-0.40507565,-0.3838695,-0.35968829,-0.36019337,-0.3244185,-0.32088679,-0.30730359,-0.30078906,-0.28431421,-0.28019883,-0.25766757,-0.23478991,-0.22017741,-0.20692881,-0.17619488,-0.17740448,-0.15710534,-0.15168929,-0.1491069,-0.15236047,-0.15009889,-0.14838253,-0.16130646,-0.17670977,-0.26242506,-0.35967081,-0.46348138,-0.5539558,-0.64677761,-0.7408143,-0.83139622,-0.91850046,-1.0088253,-1.0925285,-1.1833403,-1.2602896,-1.3467795,-1.4285487,-1.4956898,-1.5710966,-1.6514906,-1.7261666,-1.8054724,-1.8798141,-1.9496961,-2.0176828,-2.0842711,-2.1477598,-2.1657873,-2.1579979,-2.1171593,-2.0710282,-2.0232399,-1.9657678,-1.9122782,-1.8478612,-1.7806351,-1.7067351,-1.6323325,-1.5637414,-1.4744745,-1.4050505,-1.3084222,-1.2229457,-1.1344568,-1.0455124,-0.95198876,-0.86871105,-0.76474855,-0.68226746,-0.58391819,-0.50134647,-0.42598917,-0.3521315,-0.26727918,-0.1967827,-0.12355564,-0.083444114,-0.044994897,-0.019565869,-0.0018614344,-0.028707488,-0.088309159,-0.15717711,-0.23048443,-0.26142932,-0.20806015,-0.14421712,-0.06150962,-0.0037781356,0.060177685,0.14650895,0.22355711,0.29483801,0.36175825,0.43162801,0.49195661,0.54274172,0.60593562,0.65951529,0.70164431,0.74491403,0.77705342,0.74200645,0.68490676,0.61069518,0.53656698,0.46977243,0.39210591,0.31237645,0.2273699,0.1340523,0.031364391,-0.048307028,-0.13709593,-0.22256421,-0.32388484,-0.40807353,-0.49940588,-0.599981,-0.69502935,-0.77871841,-0.87217835,-0.96295641,-1.0415796,-1.1326979,-1.207815,-1.2816034,-1.3678412,-1.424936,-1.3668787,-1.2959738,-1.2074316,-1.1292608,-1.0483518,-0.96196363,-0.88015315,-0.79128615,-0.7111767,-0.61985786,-0.5346062,-0.44718008,-0.36246985,-0.28174845,-0.1970514,-0.10934007,-0.03278211,0.061481928,0.13708807,0.2130165,0.30284844,0.38076001,0.4595632,0.53688386,0.61676116,0.68670326,0.77181692,0.83974094,0.9185315,0.99553486,1.0687074,1.1410559,1.2173071,1.2885352,1.3519342,1.4036365,1.4665022,1.5087426,1.5296951,1.5562725,1.56393,1.5460197,1.4997764,1.4553148,1.3991996,1.3363229,1.2751923,1.2080958,1.1760581,1.152149,1.1850232,1.2438577,1.3096451,1.3763056,1.439162,1.492335,1.5295196,1.4877794,1.4211259:2
1.3676294,1.3168471,1.2700177,1.2120893,1.1491983,1.0856216,1.0102924,0.93739526,0.86385564,0.81369859,0.86126734,0.92468427,0.96986059,1.0090339,0.9917343,0.94907471,0.89453216,0.80478425,0.74032538,0.66342563,0.57055395,0.479088,0.37480627,0.26886876,0.16393668,0.058203313,-0.047488096,-0.15249939,-0.25667543,-0.36102553,-0.4650707,-0.57461874,-0.69349019,-0.80539122,-0.93132925,-1.0416147,-1.1433161,-1.2505953,-1.3693019,-1.4703671,-1.5665271,-1.6694872,-1.794986,-1.9044036,-2.0336089,-2.1456091,-2.2689432,-2.388465,-2.5067683,-2.5747855,-2.5892484,-2.4793377,-2.363396,-2.2557285,-2.1491192,-2.0516732,-1.9425171,-1.8414631,-1.7383226,-1.6428403,-1.5431022,-1.4435322,-1.3375049,-1.2354808,-1.1429413,-1.0497735,-0.95398249,-0.86410711,-0.75666638,-0.65704133,-0.56657735,-0.46110769,-0.37304034,-0.28396916,-0.17251395,-0.080680678,0.010764017,0.097377741,0.19666098,0.28945376,0.37354185,0.46511809,0.53325629,0.55058822,0.54414707,0.52660242,0.48946487,0.45518184,0.41159414,0.33834201,0.26864856,0.17696232,0.10462554,0.04272833,-0.034430337,-0.11317981,-0.16958643,-0.077759889,-0.10908151,-0.024982145,0.017379626,0.080840974,0.073035112,0.038469933,-0.019879191,-0.10548511,-0.19639855,-0.28104496,-0.37921317,-0.42478373,-0.45922483,-0.50401186,-0.55504661,-0.61290479,-0.67385417,-0.72399086,-0.77653448,-0.82847998,-0.87516446,-0.92478642,-0.97146926,-1.0094406,-1.0465634,-1.0858898,-1.1088108,-1.1359406,-1.1676473,-1.2029725,-1.2402048,-1.2821744,-1.3348763,-1.3545935,-1.346996,-1.3430534,-1.3437923,-1.2932424,-1.2700647,-1.2283043,-1.1845466,-1.1389329,-1.0794378,-1.0356862,-0.98718874,-0.93311425,-0.86716867,-0.81032933,-0.74148937,-0.66459009,-0.58591277,-0.50149792,-0.40698321,-0.30194289,-0.19582867,-0.057293554,0.04075141,0.10331583,0.15931536,0.2113362,0.25698543,0.30089904,0.33197025,0.36760782,0.38411097,0.39400909,0.40741346,0.41905652,0.431802,0.44819943,0.4765734,0.52416749,0.5900088,0.66200373,0.74087223,0.81005862,0.85799484,0.896299,0.93623537,0.96886239,1.0072337,1.0503693,1.0731534,1.1082111,1.1455336,1.1786544,1.1908649,1.1989862,1.215343,1.2113863,1.2174334,1.2190747,1.2183057,1.2123535,1.1845609,1.1730062,1.1848201,1.264556,1.3682158,1.4680835,1.5665339,1.6586233,1.7634681,1.8458608,1.7740995,1.7500906,1.7393984,1.6805637,1.5841251,1.49138,1.3909372,1.2825742,1.1724953,1.0461927,0.95202184,0.84146078,0.75554547,0.7765092,0.82929145,0.86161345,0.86343376,0.85524761,0.84502725,0.83215596,0.80898949,0.77401345,0.72645775,0.70564292,0.7189578,0.71853692,0.70405317,0.69083361,0.65262407,0.63981764,0.64730053,0.67357127,0.71393339,0.753682,0.78551102,0.80421408,0.80577442,0.82829467,0.80950562,0.81445074,0.79303551,0.76122885,0.72132317,0.67748363,0.54895411,0.41054596,0.30038785,0.18835166,0.075632811,-0.028791376,-0.047604168,-0.036974681,-0.020196712,-0.018044822,-0.0089137954,0.004055702,0.012242573,0.019045357,0.027508628,0.03156467,0.024867371,0.017421371,0.015508702,0.0060514605,-0.0057648045,-0.022045071,-0.055866425,-0.079482453,-0.11350224,-0.14482348,-0.19606117,-0.26595725,-0.33325058,-0.4300313,-0.52938955,-0.62986419,-0.72805283,-0.84202561,-0.93118705,-1.0205807,-1.1211188,-1.2249976,-1.3042968,-1.398269,-1.451912,-1.5226651,-1.5900657,-1.6617364,-1.6911143,-1.6526699,-1.620574,-1.5808917,-1.5430769,-1.4926143,-1.4483404,-1.4046121,-1.3494552,-1.2928632,-1.2308927,-1.1743492,-1.1084569,-1.0446013,-0.97123358,-0.89876477,-0.82747988,-0.74715592,-0.66894815,-0.57208286,-0.47119048,-0.3828218,-0.29377135,-0.20957869,-0.13255036,-0.068685205,0.014556494,0.077691335,0.13417973,0.17262243,0.18723111,0.14879178,0.088521968,0.01548289,-0.057346939,-0.11449252,-0.027465979,0.073455065,0.1519157,0.23897041,0.30460852,0.38000415,0.45161169,0.51565827,0.589521,0.65546041,0.7193279,0.78150342,0.8399515,0.8991154,0.94436058,0.97122514,0.9856846,0.95257181,0.89047072,0.81815721,0.74445958,0.65190955,0.58072624,0.4827072,0.35006064,0.24887391,0.11667608,-0.017075271,-0.15329482,-0.26429087,-0.40124573,-0.51100179,-0.62390949,-0.6985048,-0.83748947,-0.94331395,-1.0776128,-1.1587699,-1.2616173,-1.3954053,-1.4724146,-1.5834887,-1.5154081,-1.4248424,-1.3322957,-1.2448238,-1.1432633,-1.0586407,-0.96964079,-0.87479244,-0.77721871,-0.69204098,-0.59771588,-0.50597231,-0.4122687,-0.31793767,-0.23065376,-0.14095189,-0.044586782,0.040734283,0.13992819,0.23069058,0.31340941,0.41166296,0.51022251,0.59329049,0.69386905,0.78785846,0.88195558,0.97211951,1.0731343,1.1650615,1.2722366,1.3714316,1.4454516,1.4923454,1.5221125,1.4696583,1.3776943,1.2819556,1.2005688,1.1180535,1.0273934,0.93860489,0.98541192,1.0890636,1.1942119,1.3106537,1.3852282,1.4444532,1.509633,1.5679353,1.6069777,1.6327273,1.647242,1.6351303,1.5967304,1.5483726,1.501519,1.4543923,1.4090623:2
2.6909342,2.5364886,2.3624736,2.2116047,2.0714167,1.921422,1.7374304,1.5959781,1.413298,1.2692068,1.0819608,0.94105694,0.75377698,0.60607616,0.43184099,0.24391925,0.1369416,0.027234976,-0.15848377,-0.34690082,-0.42708966,-0.56321996,-0.74261918,-0.92252024,-1.0691273,-1.2307092,-1.3834251,-1.5721633,-1.5538886,-1.5546958,-1.6246615,-1.5464014,-1.500469,-1.4346405,-1.355427,-1.2685115,-1.1485354,-1.0727173,-0.99170936,-0.88636489,-0.75935448,-0.63569693,-0.57983779,-0.55718185,-0.48847992,-0.46762312,-0.44229988,-0.45385012,-0.51041627,-0.62796516,-0.66227316,-0.74021753,-0.65905096,-0.6856494,-0.61084804,-0.55390746,-0.48216881,-0.3945565,-0.2983894,-0.21121023,-0.16988314,-0.19963253,-0.11105915,-0.011315936,0.064152261,0.10826648,0.073921421,-2.9620152E-4,0.046476648,0.090699609,0.14512316,0.14745897,0.12573126,0.13293422,0.12148857,0.081162927,-0.026496185,-0.18875796,-0.37707637,-0.56173697,-0.61259288,-0.63199791,-0.66986841,-0.65599526,-0.5610283,-0.50719091,-0.4054508,-0.33932919,-0.36550631,-0.27303557,-0.17120105,-0.078477865,-2.29607E-4,0.075714553,0.13346754,0.16550186,0.2503336,0.28490533,0.2708353,0.18261683,0.14685091,0.13311801,0.24155475,0.3419475,0.4392882,0.52600872,0.62544432,0.75062849,0.84515793,0.90071469,0.89961656,1.0222168,1.1422457,1.2667821,1.3703113,1.4802889,1.606776,1.7204718,1.8141344,1.8210871,1.7341289,1.5853555,1.4608796,1.3251009,1.1799936,1.0732457,0.91055288,0.77532404,0.65163498,0.52358742,0.38857805,0.2481924,0.099214285,-0.018814396,-0.032006535,-0.082120239,-0.20570286,-0.35045016,-0.48181664,-0.61788292,-0.75200658,-0.88880737,-1.0129253,-1.152291,-1.2663434,-1.4059862,-1.5213696,-1.3906263,-1.3496586,-1.2471578,-1.1120387,-1.0087735,-0.92171504,-0.83762247,-0.76465811,-0.65481449,-0.60706544,-0.56056186,-0.54207701,-0.65455663,-0.77737995,-0.74490213,-0.62986048,-0.45783038,-0.34962197,-0.25615639,-0.25010662,-0.14817602,-0.16426641,-0.054168208,-0.0083650046,0.10842117,0.19690453,0.31965406,0.34420665,0.25281851,0.15719899,0.24922546,0.34337439,0.45407037,0.57883265,0.66399549,0.85150532,0.98571212,1.0717885,1.032563,1.0773699,1.1943308,1.2782678,1.4220857,1.5786103,1.7679408,1.9102672,2.0969276,2.2005911,2.3152943,2.3418829,2.2978424,2.2079444,2.0356599,1.9023964,1.7174353,1.5858038,1.5100686,1.4867183,1.3708942,1.2343497,1.104047,0.97820592,0.85251796,0.73120789,0.77082627,0.69714117,0.55211285,0.42542566,0.28548659,0.19722056,0.047324581,-0.054874353,-0.14990316,-0.10623337,-0.054959198,0.052160963,0.1599761,0.20085327,0.17695689,0.098298102,0.0040465538,-0.084627846,-0.17578573,-0.20810209,-0.29189199,-0.4252151,-0.59223935,-0.55776854,-0.60113657,-0.74349056,-0.88620771,-1.0378258,-1.1601768,-1.2229188,-1.3616777,-1.492479,-1.6236058,-1.7539083,-1.8729246,-2.0070396,-2.1049186,-2.2154437,-2.1381889,-2.0014293,-1.9140076,-1.8035619,-1.6518509,-1.4860202,-1.3217875,-1.2034959,-1.0621992,-0.88616548,-0.71120111,-0.57256745,-0.46829685,-0.35036389,-0.28199427,-0.23516476,-0.15414267,-0.01004568,0.14853805,0.28591938,0.4730677,0.61087855,0.74018715,0.84887162,0.99442908,1.1393959,1.3018988,1.4659694,1.6004079,1.6771422,1.6314575,1.5324009,1.4502035,1.3515447,1.2507214,1.1666782,1.0742034,1.0801257,1.0544151,0.94789445,0.84199327,0.74369513,0.65399517,0.57353837,0.67499061,0.71145502,0.62105847,0.49420954,0.38744103,0.26880503,0.17990124,0.099268467,0.0028824384,-0.095188437,-0.18758834,-0.092736468,-1.2648178E-4,0.11607617,0.16693986,0.11194349,0.034371577,-0.034500043,-0.11374031,-0.17789028,-0.27682288,-0.36741817,-0.45745812,-0.53597842,-0.60059493,-0.62315779,-0.50004215,-0.36326915,-0.27392143,-0.30464486,-0.37277576,-0.47384768,-0.56966091,-0.61063525,-0.69595426,-0.7450783,-0.81902421,-0.87303396,-0.89902686,-0.93202468,-0.96813203,-1.0146882,-1.0430938,-0.90163176,-0.7658274,-0.63679007,-0.4927361,-0.36107296,-0.23688652,-0.11009407,0.032214013,0.13077808,0.073398094,-0.0080800249,0.019258569,0.014360997,-0.039276611,0.012153155,0.085705969,0.037239651,-0.020802969,-0.080644394,-0.21319023,-0.30864615,-0.36431078,-0.38087242,-0.24010602,-0.086818158,-0.039138273,-0.1134996,-0.15248068,-0.23291131,-0.31965241,-0.3388953,-0.39935043,-0.46263511,-0.51564904,-0.54465848,-0.60456335,-0.46590982,-0.31778095,-0.25051673,-0.26887846,-0.30932005,-0.32904231,-0.43317886,-0.47048969,-0.55205614,-0.64628589,-0.73066068,-0.8172202,-0.90603485,-0.9786752,-1.0316583,-1.1258466,-1.1535571,-1.2450215,-1.3329957,-1.375304,-1.4623644,-1.5050446,-1.5544204,-1.6150992,-1.5730043,-1.6482564,-1.7005478,-1.560272,-1.4185763,-1.2558983,-1.0878328,-0.90260893,-0.75979686,-0.60026635,-0.42943214,-0.23966528,-0.10298401,0.082807389,0.27259901,0.41026649,0.59745687,0.74003018,0.92826314,1.0787381,1.256583,1.4439378,1.587659,1.729054,1.9197261,2.0604172,2.2189149,2.3925772,2.5351573,2.6482655,2.6841933:3
0.11889247,0.03123835,-0.11174095,-0.12347077,-0.23901574,-0.29446837,-0.4229607,-0.5420947,-0.65370308,-0.77703678,-0.87504891,-1.0291878,-1.1624603,-1.1340255,-0.92499517,-0.77474199,-0.55331661,-0.3805927,-0.27030689,-0.35529696,-0.39098194,-0.44192736,-0.55127475,-0.55735959,-0.66802661,-0.78042701,-0.85141197,-0.78483997,-0.71013265,-0.74279137,-0.79529451,-0.89883919,-0.96260283,-1.0107051,-0.989967,-1.0051478,-1.1158924,-1.1705226,-1.2365467,-1.3565421,-1.4566122,-1.5126791,-1.3624075,-1.1955384,-1.0197127,-0.8701947,-0.89423689,-0.96826208,-1.0904139,-1.2315266,-1.3322018,-1.4958911,-1.5637713,-1.6081728,-1.6681276,-1.8136768,-1.9561263,-2.1248871,-2.0797223,-1.9275702,-1.9355517,-1.8173475,-1.6522287,-1.4654928,-1.3080891,-1.1334238,-0.96843453,-0.7778797,-0.60343715,-0.44515625,-0.26869323,-0.097332324,0.070243028,0.23615489,0.421864,0.59672682,0.73786885,0.93367018,1.1038025,1.254905,1.440532,1.6163638,1.7702011,1.9350409,2.1122978,2.2673021,2.4158856,2.5816732,2.7401567,2.859847,2.884895,2.7914999,2.7372071,2.6048779,2.4729528,2.2451197,2.1023553,1.9307873,1.7527174,1.5785984,1.4173515,1.2303671,1.080251,0.9019617,0.72885325,0.58038089,0.4843857,0.33085564,0.15570294,-0.046399833,-0.21671942,-0.3989357,-0.54788097,-0.68897238,-0.79130326,-0.95685076,-1.1126568,-1.2872488,-1.4694263,-1.6567674,-1.6512305,-1.7881997,-1.7362601,-1.7031011,-1.4949282,-1.3894532,-1.2164018,-1.176196,-1.0642847,-0.94919811,-0.8259762,-0.77865915,-0.89796136,-1.0712461,-1.1524074,-1.2769636,-1.3767942,-1.3819712,-1.3260952,-1.2584742,-1.1521463,-1.07636,-1.1183015,-0.99735664,-0.91632831,-0.82550847,-0.78767442,-0.66025886,-0.61196715,-0.47333041,-0.37128824,-0.29123109,-0.15213463,-0.049534745,0.067940245,0.17104667,0.29549496,0.39577312,0.45127266,0.32369509,0.1437768,-0.025547104,-0.24199799,-0.41185144,-0.5088719,-0.62697884,-0.8536034,-0.99700631,-1.0035407,-0.87630604,-0.78423696,-0.69555508,-0.58951948,-0.48981307,-0.36686716,-0.34467697,-0.24840478,-0.2223311,-0.22583118,-0.11255396,-0.011362097,0.12814998,0.1858482,0.19057064,0.25773884,0.29476125,0.21850713,0.17999922,0.26899116,0.37946137,0.48288998,0.53436848,0.56395212,0.6715683,0.73081614,0.83892914,0.94976555,0.99257965,1.114936,1.0368996,0.85708992,0.68662057,0.53541863,0.38288084,0.21224015,0.031989517,-0.11085993,-0.29455315,-0.43749894,-0.42899091,-0.59364033,-0.76498798,-0.91177055,-1.094132,-1.257706,-1.3334772,-1.1963535,-1.0599262,-0.95720954,-0.83324678,-0.74493916,-0.6294685,-0.52632828,-0.44137183,-0.36393018,-0.25259158,-0.15507642,-0.072404607,0.062631017,0.15548177,0.28550767,0.27042109,0.37809764,0.47038173,0.37485685,0.36764712,0.50832949,0.66822386,0.73955126,0.85415356,0.9416534,1.0339051,0.95126156,0.86320522,0.98214122,1.1408342,1.1838356,1.3371563,1.4828503,1.6485779,1.7530292,1.820748,1.7088207,1.5695429,1.3540308,1.136191,1.0348665,0.87934166,0.76182636,0.57239501,0.36171537,0.44638501,0.54173052,0.5309643,0.36931186,0.1987748,-0.021526155,-0.1300151,-0.22329284,-0.41829893,-0.57407887,-0.78423696,-0.95464776,-1.1268004,-1.3097831,-1.4817934,-1.6054775,-1.4816998,-1.3285708,-1.1540007,-0.97949722,-0.83611093,-0.66700705,-0.59901346,-0.5485447,-0.50770454,-0.49021351,-0.31267952,-0.1646034,-0.080914838,-0.019986768,0.04644955,-0.10092107,0.0016098686,0.20172624,0.35001115,0.36846218,0.49289687,0.60591728,0.78672761,0.86189856,0.79528755,0.67242785,0.57835973,0.71700877,0.86447784,0.88228385,0.73472911,0.88911779,0.93933013,0.84493705,0.73359222,0.61425915,0.49532018,0.59484459,0.71122246,0.6134491,0.50776395,0.39051912,0.24464012,0.10892579,-0.017114158,-0.13778595,-0.27884163,-0.40209583,-0.57222535,-0.70274041,-0.8584861,-1.0075488,-0.92490278,-0.78729413,-0.63332097,-0.47233181,-0.34439539,-0.22304839,-0.053692936,0.116319,0.23670299,0.3920024,0.40613932,0.49807814,0.66565619,0.79056493,0.96154413,0.99942087,0.95396825,1.1150886,1.2875326,1.4695234,1.5948686,1.8212759,1.9980492,1.9126158,1.8334789,1.7587236,1.6585839,1.5218087,1.3298293,1.3919827,1.3957867,1.305666,1.1940908,1.0472595,0.90744306,0.81409774,0.95529246,0.90667933,0.76396807,0.68320484,0.60130658,0.48016381,0.36793892,0.33883264,0.20500937,0.13810269,0.059322089,-0.059578888,-0.19069945,-0.34272964,-0.38023542,-0.46041532,-0.52632828,-0.65014506,-0.82672483,-0.93201009,-1.082612,-1.177295,-1.1619988,-1.0045134,-0.83784399,-0.67461747,-0.50026934,-0.45417286,-0.44811204,-0.34047864,-0.17903478,-0.007550374,0.16443655,0.33665763,0.51478543,0.70500759,0.88002548,1.0582228,1.1894614,1.0827019,0.96884505,1.0402797,0.92035828,0.82110055,0.78128231,0.68720993,0.68879937,0.58836241,0.43788394,0.28725215,0.23707945,0.12846807,0.27630527,0.26666108,0.26958323,0.23211739,0.30489971,0.27082816,0.28443229,0.25441743,0.17827316,0.16081683:1
1.7624494,1.6770939,1.5697021,1.4809106,1.3988622,1.3199009,1.1796599,1.0409994,0.94741978,0.98258202,1.0030634,0.97588533,0.8500002,0.72160704,0.59786832,0.47536887,0.40604151,0.38197896,0.41132234,0.50343593,0.63355108,0.76640887,0.87185944,0.91435078,0.80547275,0.67472414,0.56479727,0.45140152,0.34794031,0.25680362,0.16308757,0.079981781,-0.037409176,-0.15956547,-0.2649256,-0.36104884,-0.42387443,-0.45542647,-0.5237998,-0.580701,-0.63176012,-0.70263643,-0.74629273,-0.77264853,-0.72174879,-0.62372241,-0.49746716,-0.32729772,-0.18978454,-0.09393294,-0.071215219,0.068949535,0.21198734,0.33834676,0.43739934,0.55662996,0.69496974,0.81825817,0.85535036,1.0330998,1.1886206,1.2232069,1.2065187,1.0609018,0.88106641,0.87149777,0.77839001,0.70351119,0.64137729,0.56097168,0.45596527,0.35438338,0.25179302,0.18623705,0.073951318,-0.015387037,-0.097332838,-0.14457193,-0.22670887,-0.35400943,-0.39339842,-0.37327693,-0.39813248,-0.50592351,-0.60074101,-0.72516418,-0.82398155,-0.93737623,-1.0317695,-1.1419256,-1.2224809,-1.3339734,-1.3852771,-1.4772503,-1.6081318,-1.574759,-1.4635842,-1.3531666,-1.2239175,-1.100891,-1.0089227,-0.87483256,-0.7351243,-0.60684473,-0.46842298,-0.34071105,-0.22293752,-0.090378978,0.04725578,0.18720298,0.31749478,0.45743303,0.59280964,0.72779879,0.86283533,0.9799939,1.1110353,1.2448828,1.3903884,1.5237319,1.668785,1.8109387,1.9519368,2.0895959,2.2322515,2.3660988,2.4975287,2.4189184,2.2822074,2.1370972,1.9958804,1.8528326,1.7167151,1.5762405,1.4360397,1.2962987,1.1562401,1.0237801,0.88421421,0.75121609,0.6104231,0.47623568,0.33963813,0.20280323,0.068448978,-0.062225863,-0.19819739,-0.33322167,-0.4672122,-0.60267152,-0.73716636,-0.86833227,-1.0021448,-1.133662,-1.2642403,-1.4011107,-1.5359449,-1.6645072,-1.7855119,-1.8132215,-1.6745361,-1.5872965,-1.5590273,-1.5062269,-1.4346098,-1.2958054,-1.2327016,-1.2895401,-1.3172841,-1.3727391,-1.424189,-1.3963739,-1.3340862,-1.2323846,-1.1502753,-1.0738655,-0.99465034,-0.89159117,-0.752573,-0.61387862,-0.49837521,-0.39043995,-0.34364053,-0.4007876,-0.47333957,-0.42490482,-0.3469775,-0.23217789,-0.17357878,-0.087284111,0.046322515,0.16108493,0.2458424,0.24545506,0.27052524,0.30674767,0.3485646,0.43787578,0.54354671,0.65314364,0.77049587,0.88638679,0.94664727,0.81359106,0.67477842,0.5400067,0.40173935,0.2610734,0.11970869,-0.01630882,-0.15068432,-0.27933154,-0.41096053,-0.52021927,-0.6361972,-0.7244593,-0.85804565,-0.98036893,-1.0641396,-1.1743067,-1.1956136,-1.1409851,-1.0695557,-1.0089377,-0.88476386,-0.79646757,-0.68183441,-0.54557414,-0.41720282,-0.29074466,-0.22085419,-0.090856307,0.037854977,0.11800786,0.16668614,0.24097216,0.27912992,0.39647483,0.50925203,0.63583798,0.75175404,0.79020771,0.69263851,0.59160556,0.48405569,0.38284844,0.26586566,0.20043979,0.16008742,0.17685896,0.31610581,0.36601316,0.44242752,0.5332016,0.67659462,0.71744431,0.82899621,0.89002089,0.9555714,0.92284596,0.96176142,1.0558383,1.1205271,1.1732363,1.2631235,1.3003738,1.3898397,1.4857245,1.5768931,1.666627,1.7318404,1.6387647,1.4926755,1.339888,1.2022345,1.0903249,0.92033695,0.76338077,0.7041707,0.57817471,0.45879154,0.32276839,0.17094604,0.039249,-0.025914511,-0.01830494,-0.0036845045,-0.030804733,-0.13235526,-0.22328741,-0.34373477,-0.4838755,-0.60282128,-0.74404552,-0.83077052,-0.94703404,-1.0692333,-1.1632408,-1.2330663,-1.3216493,-1.360396,-1.475218,-1.5812835,-1.6746105,-1.6080605,-1.5613372,-1.4910877,-1.4006233,-1.2937286,-1.2010634,-1.1502868,-1.0897586,-0.98414449,-0.91559055,-0.86269382,-0.76981153,-0.64350344,-0.52505413,-0.4419007,-0.31883274,-0.20166364,-0.081857045,0.038317469,0.14301386,0.22396887,0.16188022,0.08334953,-0.0064767053,-0.077372404,-0.050236736,0.015326507,0.14519456,0.28207747,0.41222076,0.5538691,0.68991797,0.82479637,0.87830431,0.97236551,1.1176153,1.269,1.4107499,1.5521136,1.5819804,1.4866718,1.3682706,1.2624393,1.1776775,1.0689919,1.0510133,0.9382147,0.82870302,0.82203679,0.779182,0.69167969,0.58436238,0.47954597,0.36260398,0.25742239,0.20281162,0.1177593,0.15150244,0.20297161,0.26287727,0.29732551,0.22282097,0.12341121,0.052179472,-5.7569751E-4,-0.11567312,-0.22006627,-0.32390133,-0.4478352,-0.58199183,-0.70507543,-0.80189728,-0.93297857,-1.0725374,-1.1939851,-1.3075019,-1.4272608,-1.5191097,-1.639111,-1.7812588,-1.7720577,-1.8596945,-1.9573164,-2.0698928,-2.2313035,-2.3342406,-2.3676254,-2.2730238,-2.1425256,-2.0740921,-1.9493018,-1.8081048,-1.7459278,-1.6069406,-1.5112959,-1.3739869,-1.2093182,-1.0428855,-0.89353503,-0.76439588,-0.63434317,-0.47448775,-0.34597398,-0.21652323,-0.092959641,-0.0039574847,-0.024638218,-0.10613005,0.0090636628,0.13391281,0.26838144,0.39586428,0.51875073,0.64566097,0.77303849,0.89651042,0.92352683,1.0521276,1.1816728,1.3041387,1.4206973,1.5356936,1.6635946:5
0.20467886,0.17608124,0.15240973,0.18759617,0.1464607,0.09904241,0.12603139,0.21431407,0.21322961,0.11412234,0.01492314,-0.061691479,-0.17168178,-0.26046958,-0.36504432,-0.43815888,-0.50866159,-0.51701433,-0.36970793,-0.31604936,-0.31907437,-0.33945141,-0.35621871,-0.43746706,-0.52022383,-0.48822658,-0.51010328,-0.56708679,-0.59859422,-0.62805051,-0.70503081,-0.77695492,-0.82894386,-0.87638704,-0.94914446,-0.96742593,-1.0017623,-1.0027186,-1.016149,-0.97688385,-1.0204497,-0.94534348,-0.79759601,-0.72964912,-0.65177992,-0.52744885,-0.39370714,-0.2720171,-0.11300608,0.026937659,0.14882143,0.28022086,0.37167613,0.52652617,0.67351508,0.79680255,0.94564127,1.0993952,1.2581837,1.4095642,1.5621056,1.7149994,1.8607439,2.0089002,2.1578735,2.3141547,2.458602,2.4800549,2.4195689,2.3153397,2.1643339,1.997124,1.8616676,1.6770045,1.6411308,1.542107,1.408373,1.3180148,1.1929152,1.0839017,0.94364826,0.79369671,0.6641673,0.52189023,0.39691693,0.24798332,0.16465153,0.02855745,-0.089413397,-0.21106314,-0.3737549,-0.48036291,-0.59418907,-0.68632561,-0.69517371,-0.63646251,-0.64681692,-0.58778437,-0.55260078,-0.56275392,-0.52494322,-0.51428319,-0.51026382,-0.46983202,-0.42030312,-0.34228234,-0.26966789,-0.16673261,-0.036654252,0.077237661,0.16220057,0.16479777,0.22303068,0.27224419,0.34082469,0.37866712,0.33237208,0.34394149,0.4337009,0.51825341,0.5800855,0.65660309,0.69526301,0.69237552,0.60304999,0.68028609,0.67655481,0.6742915,0.67599053,0.71328781,0.74144213,0.73151609,0.58180923,0.45911026,0.31803862,0.17458346,0.021527583,-0.11741945,-0.24992151,-0.38912441,-0.50870691,-0.65947508,-0.64816175,-0.63978415,-0.60083539,-0.55522973,-0.48771108,-0.45438913,-0.47210707,-0.45787029,-0.36741303,-0.26016507,-0.16152196,-0.08652021,-0.047669456,-0.087318238,-0.21955116,-0.24718028,-0.22575709,-0.16672983,-0.099506471,-0.059656032,-0.065720656,-0.078596923,-0.022832429,-0.0096505167,0.048259818,0.1026946,0.17339195,0.16986665,0.060331197,-0.023897672,-0.107896,-0.019367943,0.052275851,0.10322205,0.21357863,0.2675951,0.28644516,0.31227643,0.40043552,0.46353603,0.5438354,0.57676709,0.63148422,0.55070372,0.61753689,0.69902725,0.78647881,0.88020186,0.93672748,1.0144902,1.046861,1.1687172,1.2619213,1.3413826,1.4148001,1.5023921,1.566065,1.5340657,1.3660259,1.2245721,1.0840589,0.94667637,0.79419766,0.69955312,0.56390202,0.41499881,0.27657089,0.14250943,0.020015991,-0.11716004,-0.28280141,-0.38286653,-0.42276233,-0.56593932,-0.71564947,-0.86790137,-1.0208603,-1.1524995,-1.2848949,-1.4251642,-1.5624221,-1.7576017,-1.8527911,-1.9946898,-2.1339302,-2.2753544,-2.3793909,-2.421913,-2.3199139,-2.2597964,-2.1656985,-2.1309893,-2.0492033,-1.9439205,-1.8564701,-1.7622205,-1.7054821,-1.6463041,-1.5373503,-1.4129845,-1.2956063,-1.2298132,-1.3198695,-1.1819943,-1.0695985,-0.92420488,-0.78489243,-0.6487191,-0.64243113,-0.52419187,-0.37074307,-0.23877454,-0.08567926,-0.010644558,0.067113133,-0.028786662,-0.12033301,-0.2272942,-0.28665011,-0.27432634,-0.13625743,-0.028131302,0.090323813,0.1261569,0.29568512,0.4551883,0.55776837,0.70528901,0.73605598,0.80457691,0.97683385,1.138584,1.134036,1.2635223,1.3284951,1.3459838,1.4530615,1.5587458,1.6429155,1.8247752,2.0056458,2.1643727,2.264372,2.349225,2.275325,2.1776473,2.0707832,1.9533362,1.7987606,1.6909016,1.5490242,1.4218292,1.260681,1.1393724,1.0068782,1.009127,0.91351314,0.79991454,0.6542658,0.51492562,0.39446566,0.24431908,0.21071178,0.17487463,0.063583766,5.9291759E-4,-0.11437142,-0.23533323,-0.37699942,-0.41618083,-0.33407956,-0.25193219,-0.13593806,-0.096648918,-0.16336403,-0.24673912,-0.32746684,-0.41785273,-0.45213134,-0.56158538,-0.66975059,-0.8322215,-0.96016272,-1.0902473,-1.1581924,-1.1996517,-1.2753178,-1.3565052,-1.4981824,-1.5701972,-1.6509184,-1.7361793,-1.8432348,-1.9284133,-2.0218905,-2.132401,-2.2347764,-2.1695714,-2.1834908,-2.058949,-1.927782,-1.7910892,-1.6548136,-1.5167108,-1.4680397,-1.3276063,-1.1914715,-1.0594338,-0.92239878,-0.78359055,-0.64971476,-0.51628244,-0.38238467,-0.33099924,-0.26145355,-0.1226199,0.019168152,0.15268634,0.2877709,0.4169747,0.55138527,0.67518251,0.83115336,0.95800258,1.0957458,1.2373873,1.387046,1.4415264,1.4187124,1.367497,1.2457379,1.1838548,1.1209453,0.99433922,0.92688406,0.87195644,0.7680784,0.7028547,0.64693291,0.64564456,0.53954586,0.50837585,0.44400711,0.4481741,0.4929029,0.39809394,0.28951657,0.16934657,0.067457214,-0.015305891,-0.10201676,-0.060144654,-0.21055976,-0.21807619,-0.094721491,-0.064976779,-0.16104115,-0.24432612,-0.33331964,-0.36157804,-0.45449983,-0.49673734,-0.51994561,-0.59422724,-0.60734861,-0.62181363,-0.53890727,-0.49146839,-0.53870587,-0.5841176,-0.5978006,-0.60974659,-0.67936792,-0.74493505,-0.79753799,-0.84869836,-0.91593502,-0.82267992,-0.63226436,-0.44064672,-0.29038289,-0.14471202,0.003487459,0.12482563,0.21951189:3
1.2072619,1.0825522,0.96659436,0.8802268,0.77113824,0.6841659,0.57705193,0.53956273,0.46970258,0.37786015,0.27331801,0.1718959,0.14982794,0.089504083,-0.048163144,-0.14590202,-0.24080527,-0.22380518,-0.19918579,-0.13095958,-0.065048595,-0.10217685,-0.18710741,-0.27598383,-0.33215502,-0.43144287,-0.52615339,-0.60826087,-0.67294757,-0.66869304,-0.73387049,-0.81437629,-0.89716643,-1.013437,-1.1142874,-1.183061,-1.266745,-1.3426136,-1.4347655,-1.4309399,-1.3914137,-1.2985771,-1.1985886,-1.1014707,-0.98564785,-0.8868049,-0.78244507,-0.67831408,-0.57764798,-0.48522627,-0.4300151,-0.46581734,-0.43350557,-0.32637156,-0.23192113,-0.12921789,-0.02601504,0.091911885,0.18585885,0.28584501,0.39391103,0.50700649,0.53152649,0.62762911,0.72587129,0.824086,0.927799,1.0264558,1.1296488,1.226187,1.3273599,1.4323029,1.5390195,1.5640385,1.5285709,1.4701398,1.3754824,1.2867672,1.2125601,1.1281069,1.109815,1.0595517,0.98152445,0.89707789,0.82859844,0.75740748,0.68979977,0.65707074,0.65779532,0.67287871,0.61383885,0.52981703,0.44992405,0.37079003,0.28315885,0.23217319,0.17469276,0.10766552,0.049054715,-0.0082119697,-0.083955358,-0.078058069,0.021994279,0.086377604,0.084513626,0.042595619,2.2113577E-5,-0.035396524,-0.087736607,-0.13292561,-0.19853097,-0.22418306,-0.27727594,-0.34322351,-0.40196252,-0.47917019,-0.50627523,-0.58964098,-0.57066655,-0.59946122,-0.63542646,-0.65925655,-0.645451,-0.60791183,-0.61588524,-0.63801812,-0.66349719,-0.66119205,-0.58297131,-0.50575281,-0.40907993,-0.32653395,-0.23314596,-0.13318771,-0.053222637,-0.01693868,-0.056991819,-0.082660961,-0.10719084,-0.17766186,-0.17629142,-0.20730714,-0.27069325,-0.34080903,-0.4096313,-0.37300945,-0.41781605,-0.49410245,-0.55278877,-0.60826502,-0.68201125,-0.71986259,-0.76897754,-0.811732,-0.86437373,-0.91479331,-0.97501225,-0.96939573,-0.88409184,-0.75532491,-0.74919041,-0.80281596,-0.79799377,-0.8392817,-0.88149471,-0.90097285,-0.91698693,-0.93121447,-0.96186526,-1.0026646,-1.0579827,-1.106247,-1.1445367,-1.2196274,-1.2660303,-1.3243377,-1.3630208,-1.4129791,-1.3465374,-1.202124,-1.0909416,-0.94640656,-0.83536826,-0.69134743,-0.54733249,-0.40363704,-0.25980323,-0.11594146,0.027775194,0.17176263,0.31561128,0.43596552,0.56960484,0.71318571,0.85705568,0.96872885,1.1111672,1.2550681,1.3988118,1.5427375,1.6865133,1.7968712,1.8739556,2.017677,2.140484,2.2720215,2.4159487,2.5599088,2.7038494,2.8431273,2.9342183,3.0353976,3.1445926,3.2171594,3.2051681,3.1526041,3.0859365,2.9703502,2.8545765,2.7142895,2.570192,2.4264543,2.2825819,2.1390738,1.9955418,1.8521674,1.7083974,1.564962,1.4215736,1.3122778,1.1694183,1.0260483,0.88281912,0.76740829,0.63105907,0.48792008,0.34488389,0.20192254,0.058836029,-0.084046517,-0.21019495,-0.33577366,-0.47802256,-0.62068776,-0.76383164,-0.89698796,-1.0183804,-1.1610692,-1.3040263,-1.4455686,-1.4628279,-1.4239451,-1.4197503,-1.3869675,-1.384114,-1.3789756,-1.3446881,-1.2936476,-1.2309838,-1.1894785,-1.1957352,-1.20343,-1.2063399,-1.1624804,-1.1079174,-1.1128079,-1.0635085,-1.0143821,-0.98855048,-0.97706348,-0.99326931,-0.92840693,-0.91704642,-0.8623415,-0.78669628,-0.68123005,-0.64477347,-0.63705981,-0.56318361,-0.48473849,-0.40722197,-0.32742431,-0.29247193,-0.26072806,-0.20429936,-0.15902976,-0.14116711,-0.094256626,-0.067703177,-0.11468243,-0.21166603,-0.30365651,-0.39704218,-0.50450413,-0.6102347,-0.71697485,-0.78710967,-0.73038491,-0.68255688,-0.63114806,-0.58348049,-0.55199487,-0.5650388,-0.49917993,-0.44163408,-0.39223949,-0.33027515,-0.29297855,-0.33764495,-0.44151503,-0.39051474,-0.31485348,-0.25552328,-0.19967573,-0.14289963,-0.09409255,-0.022453835,-0.0068248857,0.011443446,-0.086638659,-0.16791954,-0.11329903,-0.052008372,0.0074045608,0.070194311,0.13947557,0.21186251,0.29591115,0.36333156,0.44010148,0.44984354,0.38338685,0.46677149,0.54426873,0.63528044,0.71703229,0.80812803,0.8768349,0.84220752,0.92040979,1.0087386,1.0913228,1.1712926,1.2563171,1.3431531,1.3859773,1.3156924,1.2154933,1.1114736,1.0161923,0.91654876,0.82562128,0.72641709,0.62539154,0.5321318,0.5307502,0.44327231,0.34725754,0.23680915,0.14009845,0.029907786,-0.063913294,-0.17720313,-0.27495877,-0.38027621,-0.43245377,-0.51404735,-0.60381086,-0.70590042,-0.77122394,-0.86614155,-0.96869293,-1.0776423,-1.1737663,-1.2416089,-1.3275009,-1.431212,-1.4609609,-1.4783905,-1.5353353,-1.4882304,-1.4248484,-1.34706,-1.2626113,-1.1903401,-1.0728862,-0.95620082,-0.84271111,-0.7961431,-0.88008954,-0.9231096,-0.82186523,-0.72567649,-0.59829161,-0.46918204,-0.44972974,-0.33502158,-0.24043766,-0.17746234,-0.12835341,-0.047787692,-0.0032390905,-0.026227144,-0.10709787,-0.17328478,-0.22290242,-0.23375914,-0.16036962,-0.07715642,0.034144057,0.095479458,0.12724737,0.23433082,0.342,0.4489432,0.53959145,0.58943321,0.56799301,0.67719138,0.76068289,0.86443149,0.96116755,1.0423094,1.1013923,1.177584,1.2051834,1.2162665:3
1.5968143,1.5116161,1.3943946,1.2579284,1.1553891,1.1044311,1.0222251,0.92305744,0.86160719,0.78567103,0.70656391,0.64810877,0.5922659,0.48653938,0.39801317,0.31291236,0.22717286,0.12491741,0.014346576,-0.039136865,-0.038339713,6.6909319E-4,0.035403989,0.082457288,0.16256586,0.13506056,0.031060024,-0.073364261,-0.204167,-0.32135404,-0.43410315,-0.55063299,-0.67185891,-0.78259923,-0.86896567,-0.98314569,-1.0975539,-1.1828688,-1.2913299,-1.3913064,-1.4779572,-1.5527209,-1.6157287,-1.7013471,-1.7621461,-1.8333196,-1.8760857,-1.8873415,-1.8502952,-1.8439425,-1.7735298,-1.662929,-1.6141528,-1.5330969,-1.450749,-1.4101063,-1.3112615,-1.2080487,-1.1130454,-1.0044439,-0.89841362,-0.78983278,-0.67765095,-0.56472217,-0.44461948,-0.33800911,-0.22537213,-0.11225521,0.0064927611,0.10678089,0.23693515,0.3750419,0.50223103,0.61293559,0.73215987,0.85528079,0.97195891,1.0577662,1.1790115,1.2901376,1.409684,1.52917,1.6089705,1.5227795,1.4410273,1.3783396,1.313412,1.2545131,1.1828623,1.121206,1.0842406,1.0324476,0.98806198,0.94618435,0.89337676,0.82743379,0.74802458,0.68023807,0.64934568,0.69656554,0.77280654,0.83714409,0.89442352,0.89042298,0.8484593,0.78556238,0.72442514,0.67520022,0.60454715,0.53126069,0.46284366,0.43907441,0.40671071,0.36270636,0.28800146,0.26399032,0.234766,0.17482173,0.13882166,0.089315312,0.042796929,-0.010856774,-0.05021093,-0.10764357,-0.19334432,-0.20664747,-0.17763892,-0.12376526,-0.072369393,0.0073772396,0.080957787,0.17655876,0.28850036,0.36189667,0.41539967,0.52533337,0.63176748,0.7338958,0.85642247,0.96167324,1.0553636,1.1559387,1.2408749,1.3522541,1.4177877,1.3679214,1.2957713,1.227464,1.1194135,1.0151184,0.93519719,0.8821185,0.79061485,0.69040279,0.56696124,0.49511258,0.46627835,0.41957973,0.35413629,0.29537148,0.23613566,0.12434689,0.088913287,0.010749651,0.013422216,-0.056869598,-0.085786529,-0.10876504,-0.20636398,-0.27976202,-0.30503701,-0.33745316,-0.40784593,-0.4819039,-0.57592651,-0.67289869,-0.75105242,-0.83730712,-0.92344275,-1.0217389,-1.0713267,-1.1782099,-1.2781015,-1.2253865,-1.2538072,-1.1849584,-1.0729082,-0.95131714,-0.86148825,-0.76621847,-0.70906744,-0.6671427,-0.58243404,-0.53032042,-0.45000229,-0.34098056,-0.29157242,-0.28772003,-0.25693106,-0.19941236,-0.14813457,-0.13030952,-0.057141882,0.0092434228,0.0027656635,0.0045703993,-0.050294916,-0.13860192,-0.21717592,-0.26910168,-0.24307857,-0.21981416,-0.14623335,-0.072274684,-0.006491383,0.058924262,0.055673645,0.10008184,0.17301714,0.23529421,0.33556732,0.42309704,0.50642624,0.5343991,0.59958961,0.64207359,0.67294348,0.65565136,0.62180715,0.63460623,0.68026857,0.73389661,0.80285284,0.87997695,0.96398016,1.0355775,1.0688275,1.1110459,1.1679689,1.2430288,1.3361893,1.4092614,1.4601575,1.5087864,1.579977,1.6679122,1.7222065,1.7563928,1.6573695,1.5446115,1.4206838,1.3008544,1.2374488,1.1134427,0.99401527,0.88188977,0.76013383,0.64372211,0.5285059,0.41330246,0.2927833,0.16450829,0.048371325,-0.043320936,-0.073354664,-0.20078994,-0.28554863,-0.3609851,-0.47761623,-0.57817843,-0.60720437,-0.69772135,-0.76831951,-0.83644557,-0.95451886,-1.0548665,-1.0852692,-1.0382314,-1.0726343,-1.08515,-1.0773397,-1.0491116,-1.0009785,-0.94763571,-0.95945,-0.93336516,-0.8966202,-0.86129944,-0.82514035,-0.76573534,-0.69597037,-0.64302843,-0.60259591,-0.51642416,-0.46628199,-0.38704234,-0.30927469,-0.25945944,-0.18982647,-0.13564148,-0.062844112,0.0099710556,0.061167056,0.087705796,0.15080521,0.21934411,0.29335578,0.37044171,0.4427662,0.51145143,0.59030365,0.66481381,0.74497185,0.81022657,0.83615003,0.72524031,0.62396738,0.50777928,0.38713664,0.25967776,0.1505383,0.19789297,0.27779548,0.3603548,0.43574714,0.51167841,0.59686586,0.67563501,0.76108803,0.82362272,0.81044141,0.86923254,0.96252439,1.0469642,1.1319481,1.1924017,1.2923609,1.3977708,1.5067079,1.6090725,1.6456721,1.5089591,1.3965655,1.2650137,1.1466374,1.0204234,0.9025271,0.76744617,0.68529298,0.57208953,0.45483345,0.32318493,0.20527385,0.084108074,-0.032642746,-0.12921219,-0.20141179,-0.30072007,-0.41493174,-0.52960228,-0.62356729,-0.73348296,-0.82345016,-0.94142283,-1.0107198,-1.1246553,-1.2379642,-1.3555707,-1.4720448,-1.5868495,-1.7013641,-1.7901181,-1.8779266,-1.9938648,-2.1096064,-2.1812935,-2.2647526,-2.3620188,-2.4703278,-2.5855926,-2.7006327,-2.7934287,-2.8445902,-2.7942519,-2.7322203,-2.5989583,-2.4677323,-2.3253633,-2.1970597,-2.0613073,-1.9137456,-1.800649,-1.669289,-1.5338399,-1.4784582,-1.3446285,-1.2053437,-1.0630577,-0.93062774,-0.81818752,-0.68496614,-0.53083743,-0.39741017,-0.27622702,-0.23354568,-0.26401967,-0.26589722,-0.23932112,-0.17576528,-0.064616711,0.04135081,0.15251171,0.2493426,0.34486141,0.4406001,0.53082752,0.57103517,0.62729172,0.72303858,0.82377219,0.93973428,1.0400372,1.1190587,1.2213768,1.3394166,1.4456589,1.5602699:5
0.50295015,0.43360735,0.3452599,0.28625113,0.332116,0.28603403,0.16494768,0.044880612,-0.089567445,-0.21030044,-0.24347081,-0.29683065,-0.31674828,-0.23686059,-0.17468891,-0.094970739,-0.16683023,-0.30314475,-0.46831915,-0.63455446,-0.78903183,-0.91768245,-1.05223,-1.1693183,-1.3121958,-1.4620991,-1.6050399,-1.6905883,-1.8170263,-1.9232235,-2.0270464,-2.135802,-2.2271378,-2.2389238,-2.267796,-2.2665491,-2.2382007,-2.193559,-2.0796139,-2.0047375,-1.8813076,-1.7540189,-1.6241904,-1.5206193,-1.3871626,-1.2589663,-1.1248016,-0.99334808,-0.85869658,-0.73846042,-0.60613852,-0.471234,-0.3792597,-0.2642999,-0.12661934,0.0035810992,0.099839702,0.20055801,0.29392023,0.32463474,0.35440619,0.38075681,0.45400599,0.56748558,0.62537618,0.68642527,0.79186843,0.92929079,0.98172471,1.0399151,1.1464083,1.256873,1.3241909,1.3929451,1.491729,1.6034394,1.7064338,1.8187059,1.7532549,1.6480759,1.5458716,1.445583,1.3564769,1.3180014,1.2873181,1.2284999,1.1319758,1.0349865,0.94964362,0.85740833,0.78371707,0.70421205,0.62587009,0.65170096,0.80009263,0.92713385,1.0594052,1.1788404,1.341739,1.4769445,1.6332767,1.5809891,1.4874029,1.3983204,1.3390656,1.2797527,1.2206011,1.1424433,1.0786637,0.95358373,0.86687549,0.76229096,0.7109852,0.64359401,0.54499585,0.45718001,0.41851671,0.34473305,0.27503366,0.20604689,0.28794549,0.36578997,0.42972392,0.49435436,0.52777591,0.605052,0.59215858,0.55368421,0.65224242,0.716019,0.76123393,0.87786486,0.9616946,1.104277,1.2509239,1.3926931,1.4635801,1.4715903,1.4186637,1.3159527,1.2660101,1.2162059,1.1966339,1.1315039,1.0602336,1.0047266,0.97458559,0.99459566,0.98866646,0.93099276,0.89430726,0.80812258,0.68330235,0.63358981,0.53174379,0.49554527,0.49545146,0.5595516,0.65182605,0.76915861,0.82295912,0.80930493,0.78099006,0.68278189,0.57188308,0.49565135,0.41176064,0.29788655,0.1729882,0.095570803,0.089270551,0.02912531,-0.0093736524,-0.072597504,-0.16055778,-0.28515004,-0.35875347,-0.36715221,-0.30665872,-0.31427437,-0.38311458,-0.45001092,-0.49196914,-0.55665481,-0.64136119,-0.73969725,-0.82522505,-0.85896014,-0.94123389,-0.98292167,-1.0180619,-1.0831546,-1.1658069,-1.2136314,-1.2554262,-1.3256928,-1.384036,-1.4575389,-1.4460456,-1.3340095,-1.2450256,-1.132881,-1.0193963,-0.91922158,-0.82429901,-0.70467396,-0.59638772,-0.53241858,-0.43392974,-0.3337276,-0.22136829,-0.10583164,0.0047366797,0.11647172,0.18714719,0.11792484,0.028464931,-0.065555166,-0.10910011,-0.16363154,-0.27393469,-0.30206786,-0.42143932,-0.44373125,-0.52751119,-0.5624802,-0.50477232,-0.42174675,-0.32970459,-0.2217262,-0.21560427,-0.16164638,-0.15599304,-0.22476203,-0.37983674,-0.51637529,-0.5441001,-0.52080193,-0.39895411,-0.2976959,-0.20771202,-0.12088274,-0.038167942,0.042011733,0.047208698,0.15047071,0.25605362,0.35712098,0.42719703,0.52390471,0.58344089,0.63949257,0.56648584,0.44988405,0.36095534,0.39778623,0.48863043,0.59099443,0.69464294,0.82389506,0.89184825,0.9214157,0.96729509,1.0229702,1.0315911,1.094718,1.1259322,1.1777559,1.1941496,1.3008161,1.4021535,1.4833333,1.4913684,1.3608971,1.2303676,1.1687901,1.0485936,0.95345305,0.85046048,0.70576553,0.59057604,0.44668991,0.32247287,0.20430035,0.16651449,0.058459725,-0.054902247,-0.19110382,-0.29362529,-0.36052057,-0.51076307,-0.6005245,-0.65444283,-0.77786207,-0.86580587,-0.94588823,-1.0519608,-1.1068127,-1.0485988,-1.0337169,-0.99196908,-0.9403049,-0.8900576,-0.83257324,-0.71130306,-0.62903774,-0.54893245,-0.45011059,-0.44000773,-0.38146579,-0.25894561,-0.16478001,-0.04289592,0.075817279,0.10580303,0.17190129,0.21020158,0.27400219,0.33536429,0.43823821,0.54377205,0.64950947,0.74560646,0.82103065,0.91464047,0.95307843,1.0567014,1.1657881,1.2659058,1.2181302,1.0670525,0.93899146,0.79225288,0.65491978,0.52256401,0.43895564,0.29267395,0.2521722,0.32312305,0.42766501,0.51607417,0.63272967,0.72627819,0.82729528,0.92957075,0.89858489,0.91582394,1.008065,1.0898595,1.1952067,1.3143447,1.431635,1.3514192,1.2122278,1.0640759,0.91751444,0.84668267,0.76372514,0.62222977,0.48767271,0.34742387,0.20414033,0.077736785,0.029495529,0.027679753,0.031314886,-0.09143694,-0.22829331,-0.3595896,-0.46401884,-0.53417489,-0.64598525,-0.70302491,-0.8078168,-0.88228556,-0.99205634,-1.1089933,-1.2429387,-1.3549657,-1.4918625,-1.6239002,-1.7458688,-1.8752567,-1.9924727,-2.0476411,-2.1083712,-2.2087203,-2.2762736,-2.4052815,-2.5159977,-2.5842983,-2.536605,-2.4819965,-2.3527957,-2.2193492,-2.0808217,-1.9467413,-1.8499378,-1.7931307,-1.7515147,-1.6282345,-1.4872572,-1.3435125,-1.2023895,-1.0625703,-0.90808989,-0.76666416,-0.61118954,-0.46088226,-0.29148135,-0.1403546,-0.20515792,-0.31203797,-0.41807219,-0.46495683,-0.57256869,-0.63771339,-0.52175744,-0.36716548,-0.19722986,-0.046383462,0.054872239,0.086123857,0.2081208,0.34782791,0.4740874,0.52525455:5
0.12964053,0.071765944,0.021143637,-0.04031037,-0.092217294,-0.076189803,-0.14623624,-0.21162983,-0.27659408,-0.33986009,-0.39355265,-0.43663687,-0.47139449,-0.42684623,-0.32929614,-0.4019025,-0.46804906,-0.54030821,-0.59931935,-0.65684508,-0.70909106,-0.75130324,-0.79084371,-0.82563975,-0.85664165,-0.88894208,-0.92895807,-0.97059467,-1.0100906,-1.0404553,-1.0587142,-1.0888504,-1.1194599,-1.1351377,-1.1574543,-1.1826626,-1.2019215,-1.1140864,-1.0181388,-0.92911,-0.82497571,-0.73369636,-0.64379067,-0.54796589,-0.4636681,-0.37559232,-0.2847885,-0.1911073,-0.11539225,-0.016977459,0.073497645,0.08298786,0.18051614,0.26375802,0.32392106,0.37459266,0.41894758,0.42818406,0.42507181,0.4180555,0.40790065,0.39982102,0.40260328,0.4036057,0.41111288,0.44252816,0.5101453,0.52649536,0.53662799,0.51299254,0.49269154,0.48080139,0.46940174,0.47766651,0.47589558,0.49839412,0.51893247,0.52702033,0.52496864,0.529476,0.52495505,0.55542681,0.5891272,0.64228704,0.69038021,0.73992529,0.79282499,0.84030049,0.88741529,0.92535144,0.96467974,1.0105944,1.0638938,1.0814086,1.0866055,1.1209239,1.1640296,1.2163844,1.256881,1.2811906,1.3007189,1.3274065,1.4215897,1.5514531,1.6675006,1.758702,1.8502985,1.9525686,2.0411529,2.1204833,2.0361386,1.9048916,1.7922089,1.679142,1.5645876,1.4703396,1.3922217,1.331972,1.2784673,1.2523457,1.2493016,1.2572723,1.251974,1.237453,1.2166375,1.1841459,1.1369533,1.0907643,1.0568039,1.0352858,1.0145286,1.0047789,0.99734046,0.98583596,0.9661252,0.95190252,0.92373752,0.88934605,0.85456137,0.82565873,0.79426198,0.7730214,0.72818931,0.67251385,0.60978189,0.54085235,0.47115423,0.40475707,0.33148437,0.25478501,0.1760156,0.077423496,0.021183504,-0.06410345,-0.12476698,-0.18931467,-0.22985903,-0.24352073,-0.23932306,-0.23912372,-0.22394058,-0.22324534,-0.20777871,-0.19678224,-0.18031558,-0.16414287,-0.15146604,-0.15565566,-0.15065108,-0.15123404,-0.1475502,-0.14788369,-0.14982407,-0.14095841,-0.12721925,-0.19097371,-0.22974827,-0.24193035,-0.24282591,-0.23996325,-0.23627986,-0.22312736,-0.19460029,-0.1232892,-0.072031196,-0.16592605,-0.28073551,-0.3742087,-0.44466149,-0.53223885,-0.63910025,-0.75069348,-0.85794513,-0.95067479,-1.0592567,-1.1584398,-1.2505989,-1.3431776,-1.4276049,-1.5198597,-1.5935209,-1.6575585,-1.6894641,-1.6976966,-1.6819975,-1.6518816,-1.6121485,-1.5884444,-1.5340703,-1.4792842,-1.448714,-1.400708,-1.3690395,-1.3235302,-1.2572402,-1.2148127,-1.152606,-1.0875872,-1.0238999,-0.95546029,-0.8836914,-0.81022642,-0.72466434,-0.70404908,-0.7264324,-0.73272774,-0.66218649,-0.57792442,-0.49936376,-0.42298506,-0.33382867,-0.24176489,-0.1501964,-0.080534476,0.0025993052,0.079235973,0.05778488,-0.03461327,-0.13178804,-0.23010779,-0.33641129,-0.44614507,-0.52961205,-0.58408385,-0.6861736,-0.78493322,-0.89011685,-1.0074411,-1.1241252,-1.2311113,-1.3169424,-1.4165529,-1.4980965,-1.5195978,-1.5212029,-1.4972348,-1.436489,-1.3635098,-1.2759153,-1.2097813,-1.123892,-1.0266294,-0.92390001,-0.81977666,-0.7167831,-0.61966684,-0.50890237,-0.41290206,-0.31439226,-0.2108866,-0.10827907,-0.011814205,0.093247832,0.19784179,0.29745532,0.39567595,0.49870551,0.59423558,0.69361068,0.77981833,0.75266639,0.85746641,0.95872692,1.0594287,1.158189,1.2800925,1.3013457,1.1870852,1.1001437,1.0082031,0.92353293,0.84651633,0.76285238,0.69383824,0.62384793,0.56281476,0.49700169,0.43587934,0.41810333,0.45438141,0.54097496,0.64979733,0.75439126,0.83416309,0.93161306,1.0302471,1.1076263,1.1893515,1.3162128,1.4284482,1.5502348,1.6484148,1.7518958,1.7317306,1.6679993,1.7411827,1.8332774,1.9347979,2.060654,2.0662395,2.0311224,1.9642609,1.8730902,1.7764868,1.6793899,1.5823544,1.4866364,1.3891997,1.3015614,1.2232397,1.1706792,1.1493968,1.1942548,1.2667023,1.3590102,1.4560375,1.412743,1.2818417,1.1888879,1.0964272,1.0605372,0.94912726,0.83757284,0.72266371,0.61505811,0.48792896,0.39344474,0.28340616,0.18996498,0.082203466,-0.027112885,-0.12392208,-0.19766271,-0.25530915,-0.30655151,-0.34085432,-0.32988645,-0.29284004,-0.24323163,-0.17826884,-0.11442869,-0.045502984,0.020647876,0.094415781,0.16456059,0.2498936,0.26468894,0.22843185,0.23148869,0.19108869,0.09986468,-0.0065175104,-0.092307996,-0.14872296,-0.1553109,-0.073174324,-0.1291788,-0.22599753,-0.33529311,-0.42559551,-0.52344037,-0.62061917,-0.71787077,-0.81226688,-0.90347562,-1.0005318,-1.0943476,-1.1935133,-1.2875224,-1.3831083,-1.4726122,-1.5660859,-1.6531383,-1.7535293,-1.8354479,-1.9270708,-2.0064194,-2.0868247,-2.168502,-2.2277738,-2.2376734,-2.2159328,-2.1652861,-2.109459,-2.0325418,-1.9427513,-1.8390824,-1.7303136,-1.618048,-1.5084171,-1.4061849,-1.3191935,-1.2046841,-1.0914068,-0.97789868,-0.86408058,-0.76459648,-0.6703214,-0.5661348,-0.51062234,-0.39694123,-0.30024476,-0.20302988,-0.10954997,-0.032230022,0.043170737,0.10940508:4
2.6740622,2.6169284,2.5393819,2.4411371,2.3499838,2.2586216,2.1535506,2.0609047,1.9627726,1.868391,1.7905991,1.693982,1.605736,1.4902884,1.3753334,1.3643311,1.3458855,1.2535703,1.1551118,1.0247673,0.9562166,0.81945249,0.73424825,0.78532847,0.84245093,0.85283569,0.7750008,0.67092233,0.61038378,0.49934722,0.40807314,0.35918158,0.291857,0.26730767,0.34801825,0.32864341,0.24487461,0.17011111,0.1164972,0.012402634,-0.012484343,-0.12850759,-0.23064634,-0.27198806,-0.36926301,-0.42639627,-0.34841582,-0.34088227,-0.26131383,-0.18560468,-0.17950365,-0.24989873,-0.34072097,-0.39702854,-0.4941083,-0.54352148,-0.65343975,-0.71738024,-0.7709656,-0.79675245,-0.89230348,-0.9807795,-1.0333118,-1.1043303,-1.1612104,-1.1425957,-1.2247991,-1.3069392,-1.3897803,-1.473516,-1.4867209,-1.5703193,-1.6569088,-1.6522121,-1.7057153,-1.7631148,-1.8168939,-1.8735836,-1.9381046,-1.960166,-2.0120185,-2.0495015,-2.0213478,-2.0436473,-2.0523981,-2.0923899,-2.1340503,-2.1074189,-2.0879808,-2.091274,-2.0647919,-1.9954192,-1.9547351,-1.9164442,-1.8685031,-1.778798,-1.6828943,-1.6261126,-1.5396281,-1.5104573,-1.447507,-1.377544,-1.2756839,-1.1922637,-1.0771073,-0.99388091,-0.87870618,-0.79377734,-0.71751148,-0.63888979,-0.55393253,-0.41957302,-0.3398913,-0.25374331,-0.16335735,-0.058461626,0.026282649,0.12270936,0.2479092,0.31393771,0.36573024,0.48527011,0.57439983,0.67593439,0.77473148,0.81153424,0.85343655,0.96656464,1.0307849,1.1266198,1.2391414,1.3429563,1.4559142,1.5563187,1.5147842,1.4517425,1.4088681,1.313683,1.225143,1.2382378,1.1867688,1.1008414,1.016218,1.0115769,1.0486702,1.006473,0.9319319,0.9212299,0.86171069,0.83431021,0.86411427,0.91716021,0.88030908,0.83306213,0.81513349,0.72991908,0.69142747,0.71780975,0.64450102,0.68374789,0.61785802,0.52873363,0.5383615,0.46803939,0.49197397,0.39989155,0.3243305,0.36459737,0.29005329,0.19694724,0.17021528,0.12763326,0.13335625,0.08434121,0.013720596,0.0064255075,-0.076167151,-0.13902996,-0.094072752,-0.18366768,-0.26598668,-0.36863579,-0.4722892,-0.54866795,-0.62107531,-0.70255637,-0.78504123,-0.85896422,-0.91548814,-0.90466317,-0.87680456,-0.83178907,-0.74111958,-0.62849088,-0.53049725,-0.45266707,-0.34207301,-0.24995001,-0.16596443,-0.067261113,0.02615032,0.12922561,0.22908562,0.32719954,0.42666958,0.52941225,0.6246318,0.72713415,0.82892213,0.92742249,1.0130683,1.0984376,1.1450886,1.1994149,1.2392439,1.2536086,1.2732014,1.2830414,1.2573574,1.226906,1.2231267,1.2081968,1.1875094,1.1486793,1.0652107,0.97434993,0.8782966,0.77851376,0.68214968,0.58244463,0.48786625,0.39646994,0.30783059,0.20552131,0.11092796,0.013232491,-0.081551263,-0.17501619,-0.20383632,-0.26112146,-0.36565152,-0.46313655,-0.56408148,-0.66261203,-0.76215469,-0.85425436,-0.94806188,-1.0172956,-1.0832392,-1.1965732,-1.2912149,-1.2262757,-1.1523501,-1.0792253,-1.0170052,-1.0019928,-0.97174427,-0.90337056,-0.86071475,-0.79934918,-0.84418878,-0.82466222,-0.78399198,-0.73325036,-0.72468747,-0.67429591,-0.59397136,-0.6328314,-0.59928007,-0.56998096,-0.5463446,-0.64905619,-0.7155531,-0.65844448,-0.5571897,-0.46799239,-0.36688669,-0.37934972,-0.29323949,-0.26145981,-0.2920523,-0.38511455,-0.37368735,-0.42992258,-0.34716788,-0.24045318,-0.24691944,-0.24069249,-0.12487511,-0.12886529,-0.073980975,-0.02198638,0.0061056701,-0.066600604,-0.12922402,-0.11369494,-0.063325061,-0.052659293,-0.059207317,0.044640484,0.044352101,0.10540124,0.15416575,0.15376077,0.074897217,0.060498893,0.12826023,0.089875661,0.19036157,0.21882165,0.26580838,0.23301707,0.17035044,0.24821798,0.30463596,0.37507735,0.38793597,0.38897522,0.46433788,0.5408917,0.55561446,0.64083241,0.69458348,0.75207893,0.6340687,0.51220629,0.40939054,0.31993454,0.23009336,0.16659545,0.062669681,-0.031331382,-0.082394022,-0.15128207,-0.26561273,-0.366097,-0.46364605,-0.52909514,-0.53327871,-0.6442884,-0.74279073,-0.817071,-0.88601531,-0.96114845,-1.0147595,-1.1020339,-1.1738185,-1.2398258,-1.3349082,-1.3820869,-1.3115269,-1.2397324,-1.2867895,-1.2740166,-1.1811794,-1.0958067,-1.0614652,-0.97222147,-0.9032554,-0.82016804,-0.75880888,-0.83145905,-0.86078067,-0.78256584,-0.71449413,-0.62846304,-0.65159501,-0.6043949,-0.51668332,-0.44553062,-0.42793275,-0.33269895,-0.26513172,-0.35638485,-0.44804085,-0.47340695,-0.5648223,-0.51715445,-0.53126574,-0.44275082,-0.32757543,-0.30769534,-0.29388219,-0.22083829,-0.11884232,-0.033782245,-0.070481382,-0.011668749,0.085323091,0.1793684,0.29801378,0.23201641,0.15512744,0.13100388,0.19314469,0.31014815,0.31794668,0.38098278,0.47841316,0.52626755,0.64791768,0.69575491,0.61892105,0.56588445,0.69210656,0.73256225,0.78813775,0.88856742,0.97544843,1.1113583,1.1160148,1.2035625,1.2942008,1.402569,1.4123745,1.5117273,1.5865894,1.6882343,1.7778549,1.8749865,1.9482066,2.0322134,2.1479728,2.2593314,2.3747662,2.5006298,2.6282076:6
2.7898662,2.6906132,2.5955547,2.4963117,2.3970536,2.3068938,2.2039364,2.1001429,2.0048982,1.9065976,1.8072155,1.7154808,1.6202282,1.5193963,1.4177662,1.3141173,1.2073542,1.1411044,1.1066619,1.0732348,1.0309206,0.98598008,0.94813135,0.87763727,0.80734697,0.71550895,0.65659661,0.56985659,0.49237766,0.4398498,0.39749778,0.35145786,0.30586136,0.23347489,0.16873009,0.13295526,0.083977603,0.058200708,0.040064464,0.0065111121,-0.0090953214,-0.023092906,-0.025608229,-0.021767318,-0.031699762,-0.026491229,-0.011170833,0.0054379012,0.0066611187,0.018999764,0.061935147,0.13435057,0.1013345,-0.0025607251,-0.08388173,-0.18273807,-0.2760248,-0.36563489,-0.45054425,-0.52975724,-0.60568404,-0.67556403,-0.72878304,-0.77741606,-0.84337436,-0.90850686,-0.98549225,-1.0775231,-1.1737521,-1.2759941,-1.3560572,-1.4224408,-1.4525061,-1.4683451,-1.4937594,-1.4972109,-1.4917464,-1.4752954,-1.4518032,-1.405166,-1.3631828,-1.3203549,-1.2752512,-1.2229544,-1.1636766,-1.0959477,-1.01695,-0.94183941,-0.86250039,-0.77877504,-0.69530123,-0.61613492,-0.52221558,-0.43870362,-0.47838018,-0.50951532,-0.52567684,-0.44380042,-0.34367105,-0.24346797,-0.15109452,-0.053869781,0.044570139,0.019755928,-0.075807239,-0.17689138,-0.27014262,-0.32109552,-0.42793722,-0.47592485,-0.57660189,-0.67220402,-0.77735664,-0.87965869,-0.9664782,-1.0689145,-1.1663681,-1.2596131,-1.3633823,-1.4514712,-1.55833,-1.6507991,-1.729752,-1.7762507,-1.7724313,-1.7440586,-1.7231227,-1.6824165,-1.6075472,-1.5109097,-1.4110804,-1.3129446,-1.1893665,-1.0866716,-0.98781243,-0.88808133,-0.78578497,-0.67086401,-0.55236059,-0.41814368,-0.30712644,-0.17719515,-0.040968197,0.013649083,0.0065639329,-0.014001523,0.031766792,0.12198619,0.21697451,0.34127808,0.44958427,0.52462087,0.6252082,0.7164891,0.82549685,0.93474249,0.87023027,0.75249764,0.64333416,0.50725389,0.42612279,0.37665353,0.28003869,0.18234414,0.083192643,-0.022737393,-0.12194481,-0.20075169,-0.25975744,-0.33115868,-0.38286846,-0.43051474,-0.45485747,-0.47467262,-0.46126023,-0.41551485,-0.33933361,-0.25408205,-0.15590284,-0.069824791,0.023684011,0.13009926,0.22762631,0.32689153,0.44111816,0.53659478,0.62796839,0.72935215,0.81351748,0.90374507,1.000036,1.098662,1.2021533,1.1190343,1.0260835,1.0069414,1.032372,1.1127035,1.1878284,1.280991,1.3802923,1.4825999,1.5640969,1.6129519,1.7046127,1.8034866,1.7727761,1.6750766,1.5826844,1.5421905,1.4405111,1.3318161,1.2265443,1.1363338,1.0204281,0.92440668,0.90557611,0.97733472,1.0623518,1.1595571,1.1129455,1.0210013,0.91955766,0.82262762,0.72090437,0.62588206,0.52130217,0.42694176,0.32541017,0.23255829,0.12892454,0.032939684,-0.064245299,-0.16543424,-0.25812514,-0.29671723,-0.31441563,-0.31050722,-0.29582571,-0.25455977,-0.1871305,-0.10755258,0.0071807466,0.11059529,0.21697797,0.3091966,0.37401328,0.45310335,0.55629632,0.68397212,0.69692055,0.58795157,0.48905602,0.39290668,0.29351683,0.19093282,0.10554009,0.0086882495,0.014444788,0.030727617,0.038489978,-0.076324398,-0.17246137,-0.27203192,-0.36464027,-0.45794576,-0.5415307,-0.63490587,-0.73232118,-0.8235538,-0.91161782,-1.0087983,-1.0909142,-1.1878782,-1.258993,-1.3361977,-1.4045415,-1.4658992,-1.5166919,-1.5376826,-1.5187093,-1.4859731,-1.4210184,-1.3536888,-1.2733612,-1.1845902,-1.0721691,-0.96198266,-0.83386408,-0.71394068,-0.60698935,-0.4701077,-0.3962923,-0.29573212,-0.18458093,-0.046868207,0.005143573,-0.12803869,-0.21311341,-0.32907996,-0.4139334,-0.50526449,-0.60213519,-0.6724241,-0.71946127,-0.66667434,-0.71032368,-0.80761466,-0.92226352,-1.024934,-1.1118016,-1.1805004,-1.2508161,-1.3076649,-1.3605777,-1.4107363,-1.4479447,-1.4895527,-1.506307,-1.4916172,-1.4798848,-1.4724598,-1.4495443,-1.36498,-1.262744,-1.1715122,-1.0666357,-0.96695276,-0.87550894,-0.78029063,-0.68401366,-0.58657738,-0.48403218,-0.39760279,-0.29933254,-0.20368765,-0.10576178,-0.042501778,-0.13170272,-0.23297129,-0.31564142,-0.41002501,-0.49400661,-0.57176341,-0.58697917,-0.49841447,-0.55140367,-0.61646496,-0.6860396,-0.75654131,-0.81444568,-0.8579549,-0.88764928,-0.90094305,-0.89530317,-0.86535303,-0.82716446,-0.78206987,-0.71824071,-0.58566902,-0.49170438,-0.38780047,-0.29557245,-0.21627,-0.13275708,-0.048276748,0.035606098,0.11220854,0.20347833,0.27856431,0.21592776,0.14835207,0.09680305,0.052684066,0.11033023,0.085300707,0.069527706,0.053508214,0.047778314,0.055332397,0.075120556,0.088534079,0.11241052,0.15322603,0.21897062,0.29172361,0.38948623,0.49356836,0.56526947,0.6238818,0.65703677,0.65307876,0.65461541,0.67235981,0.68596415,0.71739238,0.75899646,0.80549649,0.8567432,0.91009576,0.9558614,0.99107812,1.0192602,1.0593404,1.0774053,1.097095,1.1115287,1.1172489,1.1290432,1.1690194,1.2634647,1.3537066,1.4526063,1.5476752,1.6447273,1.746952,1.8483939,1.9393859,2.0381329,2.1348878,2.2324354,2.334554,2.4309784,2.5266322,2.6268203,2.7253897,2.8149274:4
1.7800898,1.7251726,1.6409078,1.5665126,1.4875279,1.3886302,1.3046054,1.2882193,1.2242218,1.165354,1.0726442,0.98807545,0.90839737,0.84492239,0.73458419,0.65931601,0.59496261,0.55853808,0.53726476,0.53876738,0.55819195,0.60414595,0.66047267,0.64126017,0.56442981,0.45705067,0.33956706,0.21845455,0.11412229,-0.0034176849,-0.12051102,-0.24502255,-0.35122977,-0.46349606,-0.58542297,-0.67562639,-0.79874257,-0.92210222,-1.0536793,-1.1523536,-1.2420678,-1.3640999,-1.3488082,-1.3111095,-1.2101979,-1.1148418,-1.0166949,-0.9184156,-0.81995776,-0.72269306,-0.6216536,-0.52812224,-0.42989563,-0.33116145,-0.23679608,-0.14032415,-0.041413224,0.041976415,0.093051226,0.19198104,0.28750764,0.38408682,0.48132992,0.57462818,0.67428394,0.77690195,0.87554009,0.97403489,1.0769041,1.1439332,1.1167573,1.0222579,0.94514251,0.85533258,0.76555455,0.68913159,0.64291554,0.56003895,0.49007018,0.41445986,0.39113345,0.35039391,0.27688704,0.19793958,0.18689087,0.15969234,0.13540837,0.1564853,0.1684577,0.18562227,0.22216556,0.2536024,0.23962084,0.18850412,0.12837401,0.053955822,-0.022186203,-0.09936148,-0.17705578,-0.25300532,-0.32428566,-0.35079656,-0.43214443,-0.49403532,-0.46289376,-0.50930024,-0.59686815,-0.66018173,-0.74559573,-0.86197268,-0.9295232,-0.99829157,-1.0362208,-1.0986812,-1.1425581,-1.1831666,-1.212836,-1.1637853,-1.1070471,-1.0026053,-0.94249721,-0.84087286,-0.71406857,-0.648752,-0.58988772,-0.53043081,-0.51669615,-0.46446431,-0.44213681,-0.37861371,-0.33304617,-0.27262824,-0.21509872,-0.20013192,-0.16261386,-0.065983003,0.015694164,0.0851508,0.11067338,0.079483372,-0.018419687,-0.10342175,-0.0052092128,-0.048862668,-0.072686826,-0.15613031,-0.22003119,-0.27560198,-0.36431534,-0.37718565,-0.44996098,-0.51148501,-0.59655604,-0.67429282,-0.77258001,-0.79435777,-0.79889373,-0.77470021,-0.82800538,-0.91329026,-0.98694583,-1.0747745,-1.1683954,-1.2500193,-1.3201493,-1.3885005,-1.4283216,-1.4808337,-1.5359584,-1.5792918,-1.5309752,-1.6144791,-1.6638171,-1.7134565,-1.7316125,-1.7752174,-1.8169044,-1.8712347,-1.8629535,-1.9297078,-1.9862827,-1.891387,-1.7839721,-1.6729408,-1.5491271,-1.4338189,-1.3187097,-1.2038562,-1.1018358,-0.9882161,-0.86987529,-0.75644627,-0.64127122,-0.52998939,-0.43016542,-0.3350556,-0.22206183,-0.10722235,-0.0036542671,0.11079724,0.22713392,0.34169267,0.45753449,0.56598811,0.68800301,0.80360644,0.91567629,1.0200727,1.1362548,1.2532703,1.3668127,1.4720605,1.5854387,1.6983194,1.8057965,1.9098303,2.0131276,2.1412543,2.2343962,2.3267209,2.4354507,2.4623451,2.4156307,2.3371618,2.2449992,2.1367321,2.0096326,1.8826617,1.7685885,1.6554521,1.5569624,1.4596426,1.3462943,1.2185792,1.1024244,0.98772158,0.87281072,0.75783348,0.64295213,0.52771334,0.4151922,0.30658852,0.19616565,0.080450466,-0.0329276,-0.14568033,-0.25277491,-0.36581961,-0.48092855,-0.58908716,-0.69635607,-0.81160329,-0.92154489,-1.0266241,-1.1404578,-1.2548884,-1.3672783,-1.476466,-1.5811528,-1.6943647,-1.8003344,-1.9040603,-2.0050437,-2.0078523,-1.898587,-1.8024168,-1.7385426,-1.6602554,-1.5793456,-1.5111408,-1.4416068,-1.3762683,-1.3490458,-1.3075478,-1.2213261,-1.1409359,-1.0622206,-0.96524488,-0.88052879,-0.80658175,-0.73648513,-0.64706755,-0.56794965,-0.54943853,-0.52885497,-0.46534216,-0.38043671,-0.3269216,-0.24875431,-0.17011724,-0.10232676,-0.021721458,0.052071895,0.11428968,0.20821124,0.30840095,0.39779752,0.33782739,0.24144875,0.14784451,0.062417732,-0.028461942,-0.12312343,-0.21485736,-0.31065084,-0.40092466,-0.48931572,-0.56902581,-0.59807414,-0.56724503,-0.52916783,-0.47251239,-0.4143503,-0.37225735,-0.32415497,-0.22477351,-0.19423112,-0.14760722,-0.066370918,0.032909073,0.12445283,0.21925317,0.30562443,0.37727339,0.45227544,0.52148886,0.58708038,0.65562674,0.74376704,0.8177277,0.80685107,0.72772433,0.67715204,0.63589831,0.61165969,0.67027693,0.73779663,0.79262491,0.8437317,0.90569252,0.96703664,1.0174855,1.0682437,1.132857,1.1981349,1.2563747,1.3173027,1.377924,1.4396064,1.5088124,1.5793628,1.587093,1.4837781,1.367286,1.2527137,1.1400281,1.0355969,0.91699009,0.80802592,0.67726156,0.55102551,0.47776353,0.399419,0.28504774,0.17578482,0.059090603,-0.027241995,-0.13947976,-0.23400903,-0.31507392,-0.39400497,-0.47862141,-0.52793936,-0.57805391,-0.63193741,-0.71653326,-0.82365031,-0.92727818,-0.98594351,-1.0920641,-1.1705557,-1.2657442,-1.2840966,-1.1988431,-1.1089796,-1.0136646,-0.92088787,-0.82119896,-0.72518319,-0.62153958,-0.52874406,-0.42835142,-0.32954349,-0.22881029,-0.12999683,-0.024585695,0.073050637,0.1806132,0.29060716,0.39288573,0.50025158,0.61885304,0.72537166,0.81864968,0.91438504,0.97641913,0.97063718,0.8962922,0.83145308,0.80168946,0.84100436,0.93248311,1.020637,1.0999316,1.1670117,1.2334036,1.3064387,1.3836162,1.3925852,1.4111555,1.468678,1.5219884,1.5914747,1.6022227,1.6590881,1.7156596,1.7596005:5
1.4299137,1.3549571,1.2720312,1.1722359,1.0854379,0.9956113,0.91290161,0.85273946,0.77468835,0.69479329,0.57389548,0.47481259,0.4426235,0.42597842,0.35202804,0.25231928,0.196438,0.085947658,0.011287939,-0.0055284465,-0.13028827,-0.21731422,-0.34263873,-0.4237891,-0.46358406,-0.5500787,-0.44823641,-0.31619572,-0.18842209,-0.049655265,0.062739475,0.075074703,0.17942803,0.29894969,0.43534789,0.50418321,0.44804614,0.37527807,0.29686782,0.21328292,0.12012571,0.11548874,0.054103547,-0.030862422,-0.066367355,-0.1274166,-0.15724452,-0.23818455,-0.31400582,-0.38690133,-0.45616643,-0.53033673,-0.59091745,-0.61545354,-0.71249586,-0.76550357,-0.83937724,-0.88740887,-0.9185704,-0.95830607,-0.87136947,-0.73023998,-0.60545987,-0.57124217,-0.61884224,-0.69987904,-0.78048003,-0.73880092,-0.7917891,-0.88099068,-0.91051778,-0.9179416,-0.96774221,-1.0254006,-1.0817659,-1.1367182,-1.1952562,-1.2650382,-1.3555686,-1.4317914,-1.504449,-1.5323851,-1.5911827,-1.5615781,-1.665908,-1.7416731,-1.8024039,-1.8669244,-1.9191998,-1.9759219,-2.0326346,-2.0704339,-2.103734,-2.1060382,-2.1543046,-2.1183036,-2.0235606,-1.873966,-1.7474704,-1.621953,-1.4921954,-1.3661544,-1.2357142,-1.1045489,-0.98388093,-0.90316662,-0.77140218,-0.64624199,-0.5142727,-0.39410628,-0.26036244,-0.1169683,0.013851896,0.139981,0.26871085,0.40285378,0.53400043,0.67063024,0.80756284,0.93725195,1.071295,1.1945675,1.3373087,1.4567037,1.594449,1.7320334,1.8577346,1.9917365,2.1253067,2.2907346,2.4212644,2.5464388,2.6872234,2.8095671,2.9270967,2.97484,2.925431,2.8236877,2.6923465,2.5567829,2.4252643,2.2889334,2.1520019,2.0170495,1.8885731,1.7581573,1.6190585,1.4976432,1.3548529,1.2159697,1.0897467,0.96936512,0.82727788,0.68617109,0.55980811,0.4364388,0.30207511,0.16176114,0.031942182,-0.099576833,-0.23131035,-0.35996117,-0.49256905,-0.62983153,-0.76212643,-0.89877803,-1.0234603,-1.1635209,-1.2928927,-1.4157452,-1.549607,-1.6955853,-1.8144894,-1.9382819,-2.0732345,-2.206939,-2.1823737,-2.1100617,-2.0005183,-1.8727443,-1.7611917,-1.6295328,-1.5031124,-1.4216975,-1.2840611,-1.1931897,-1.1092075,-0.99097661,-0.91269782,-0.83581236,-0.76721253,-0.73806094,-0.63502445,-0.5527402,-0.54389835,-0.51476656,-0.63668984,-0.61406489,-0.55325037,-0.49042341,-0.43322134,-0.38149648,-0.3330328,-0.31333101,-0.31262785,-0.27644561,-0.19256157,-0.19914062,-0.18119697,-0.11532381,-0.067980986,-0.030606747,0.052680537,0.019026792,-0.16642816,-0.31846876,-0.46951017,-0.62411177,-0.80242121,-0.89472359,-0.81623998,-0.73669003,-0.67277673,-0.60164147,-0.53948595,-0.47115887,-0.40091181,-0.38161915,-0.30323033,-0.23685047,-0.18085659,-0.24235173,-0.1588888,-0.08589724,-0.0092238096,-0.016733177,0.067403761,0.15395073,0.22709891,0.30953131,0.29641116,0.16316386,0.025995205,-0.065084511,-0.1717315,-0.31509433,-0.48517686,-0.63301272,-0.7609104,-0.91588873,-1.0304837,-0.94293493,-0.83368845,-0.72764013,-0.62432085,-0.51335072,-0.44516542,-0.36862477,-0.28922915,-0.19702681,-0.085371865,-0.068368298,-0.029517869,0.10131777,0.15621614,0.23235924,0.34435673,0.34290088,0.36022152,0.4792813,0.50378574,0.62538081,0.6945546,0.78346075,0.88762255,0.90964262,0.79045814,0.64450552,0.51225752,0.46265174,0.33731161,0.21083376,0.08939383,-0.02311388,-0.14683338,-0.18263108,-0.053954503,0.034470455,0.1077665,0.1592851,0.24917679,0.39312528,0.32117135,0.39136289,0.51336448,0.56578597,0.70290813,0.67261281,0.69477684,0.83176981,0.85054501,0.95277645,1.0467676,1.0256923,0.89276683,0.76960671,0.65460536,0.52008556,0.46106844,0.33628596,0.22411676,0.10889928,-0.0017689497,-0.013233858,-0.12495263,-0.27378405,-0.38403303,-0.50645014,-0.6400297,-0.76602386,-0.85735447,-1.0032258,-1.147922,-1.1807849,-1.0530316,-0.94007906,-0.83276031,-0.72513538,-0.62421,-0.51307471,-0.40517131,-0.29301929,-0.18407087,-0.15932106,-0.18490252,-0.084827804,0.024867439,0.11351697,0.22158609,0.28248101,0.36675883,0.49260666,0.60840714,0.53538699,0.54114268,0.64626716,0.73744448,0.66798411,0.5998607,0.57543197,0.56271196,0.48710964,0.37259506,0.27614079,0.35985518,0.25792619,0.14991674,0.0076433562,-0.077160805,-0.18045751,-0.29443224,-0.39417135,-0.51652403,-0.62692509,-0.51039695,-0.37287954,-0.23628832,-0.10171103,0.026512864,0.1553484,0.19232075,0.33804691,0.46881701,0.61143793,0.61998279,0.73822391,0.87745032,1.0240679,1.1653166,1.2757398,1.4110945,1.5595159,1.6788186,1.7400192,1.785947,1.7629965,1.6785467,1.5722136,1.4570249,1.353439,1.2386939,1.1374421,1.0378689,0.94217752,0.87286922,0.93148516,0.81641895,0.71855482,0.6125568,0.52502455,0.4142279,0.31118887,0.2030823,0.20732268,0.20826242,0.11310482,0.011791733,-0.072965628,-0.18460285,-0.21268125,-0.32546482,-0.36404536,-0.32017416,-0.17976,-0.025681723,0.11042202,0.22835096,0.34633623,0.4353965,0.4638485,0.61086471,0.77271488,0.88488204,1.0274343,1.2126284,1.3120544,1.4190392:1
0.75322832,0.61779287,0.41105963,0.21054031,0.096787169,-0.11081451,-0.3328062,-0.5180106,-0.65759185,-0.76873113,-0.66032308,-0.57503151,-0.47591705,-0.36927626,-0.29322482,-0.22822819,-0.13305413,-0.037280727,-0.028225595,0.04267355,0.083579404,0.17872322,0.30308097,0.3567888,0.47129423,0.56933845,0.69866081,0.78480658,0.88126406,0.99068417,1.1508151,1.1300989,1.0320375,0.81880713,0.6324667,0.4567116,0.2761068,0.092528081,0.0046210382,-0.13761363,-0.32209086,-0.41244852,-0.58884688,-0.73931354,-0.60169177,-0.52475092,-0.43323044,-0.30078554,-0.20818239,-0.12628383,0.013535502,0.060710769,0.19964006,0.32947942,0.44545353,0.40103946,0.30167643,0.41516854,0.54897327,0.68048461,0.76269344,0.97086186,1.1203582,1.1547959,1.0569373,1.2236941,1.3795218,1.4768286,1.7082917,1.8679638,1.9538502,1.791328,1.6382866,1.4892135,1.292543,1.1098831,0.97956768,0.78289441,0.63423385,0.49850296,0.33617591,0.30421577,0.21532245,0.071524476,-0.072796241,-0.26507749,-0.44764873,-0.52272677,-0.62766278,-0.75583514,-0.86165552,-0.97756882,-1.1133405,-1.2946,-1.3253294,-1.1891353,-1.2101097,-1.0549277,-1.0310586,-0.96737132,-0.81067347,-0.74139532,-0.73733806,-0.58039121,-0.47615973,-0.53996981,-0.31519288,-0.3800874,-0.27465394,-0.17322752,-0.060319995,0.0048414712,0.053833547,0.12884396,0.2667425,0.43236551,0.59737926,0.75066063,0.73529449,0.61802412,0.43390046,0.26769635,0.18057671,0.016108466,-0.061750438,-0.18210392,-0.33167042,-0.35655183,-0.4804529,-0.6246564,-0.46233688,-0.67123079,-0.87027562,-0.95661241,-1.1620906,-1.3484635,-1.4763215,-1.4929015,-1.3306951,-1.3656668,-1.3949313,-1.3500375,-1.2966289,-1.3223879,-1.209803,-1.090545,-1.0622762,-0.96613941,-0.80340821,-0.85196469,-0.68460315,-0.52594367,-0.35768337,-0.22757745,-0.019056702,0.14742259,0.25240818,0.45104183,0.65666489,0.76636496,0.854623,0.95872578,1.0565418,1.2188844,1.4081831,1.6038001,1.7886336,1.6222296,1.5509233,1.38352,1.2551637,1.0804413,1.0209794,0.96929771,0.80172708,0.68975836,0.70797605,0.55229998,0.49582011,0.38656438,0.33928819,0.1945805,0.041955226,0.0034305341,0.0032811811,0.057772612,-0.075288447,-0.18251896,-0.29838855,-0.42717108,-0.54905632,-0.6855316,-0.7149398,-0.78261044,-0.55502865,-0.35002386,-0.17778697,0.011170127,0.20344906,0.39002501,0.52158937,0.66634094,0.78931159,0.88895575,1.1228882,1.2621771,1.5135922,1.7105714,1.903735,1.7985258,1.6854879,1.6035159,1.5113115,1.3365221,1.2126779,1.2417232,1.0698518,0.93789532,1.0266355,0.93261459,0.77787521,0.64573696,0.60644056,0.49880104,0.37971463,0.23049176,0.37953328,0.32126274,0.2099595,0.10683885,0.02314497,-0.074137067,-0.16972161,-0.29549944,-0.32657934,-0.46064339,-0.5588993,-0.69124348,-0.60780959,-0.78458621,-0.87565325,-0.97800819,-1.1050922,-1.0597477,-0.83815751,-0.67282384,-0.50116765,-0.33229699,-0.16973748,0.007749148,0.18455393,0.36714829,0.34699404,0.53177615,0.71078241,0.88908596,1.0696124,1.1233404,1.000794,0.8993667,0.89231055,0.78659971,0.65646639,0.70769927,0.65222456,0.53851854,0.44918838,0.41409415,0.30705977,0.15175547,0.14426007,0.059774208,0.17333685,0.095738207,-0.041843336,-0.17096243,-0.31196779,-0.3558839,-0.48735151,-0.60157283,-0.74681742,-0.83671455,-0.77195087,-0.706092,-0.63997304,-0.51959471,-0.32783235,-0.31299012,-0.35660602,-0.44887673,-0.47843635,-0.5541564,-0.69424798,-0.66456683,-0.7383024,-0.82975364,-0.89330262,-1.0082082,-1.1136423,-1.2347147,-1.266873,-1.365224,-1.4767788,-1.5674219,-1.6680108,-1.7278344,-1.8317838,-1.94882,-2.0921887,-2.2049029,-2.365403,-2.5330588,-2.4084857,-2.3161375,-2.4813246,-2.5786291,-2.460245,-2.3014002,-2.1269893,-1.9618471,-1.791,-1.6167264,-1.4407133,-1.2554852,-1.078773,-0.90374951,-0.73503576,-0.53117251,-0.36731346,-0.19937923,-0.02868722,0.16677433,0.33814617,0.50951371,0.68498994,0.87662044,1.0528494,1.248473,1.4096573,1.5987768,1.7794541,1.9587302,2.1257868,2.3089316,2.4755857,2.6447831,2.7300364,2.7006617,2.6203263,2.5001623,2.3034073,2.1317179,1.9611288,1.7879304,1.5994555,1.424756,1.2402808,1.1664309,1.0675359,0.87468742,0.6759492,0.55765516,0.40304309,0.24362135,0.057368469,-0.10858189,-0.27484745,-0.48205754,-0.66430365,-0.8225519,-1.0038468,-1.2088546,-1.3840696,-1.5564576,-1.735834,-1.7470303,-1.5969818,-1.485231,-1.353509,-1.2634528,-1.2638028,-1.3367451,-1.185529,-1.0607949,-0.95965317,-0.87235951,-0.70950358,-0.58504219,-0.4723024,-0.4329903,-0.43600231,-0.39381618,-0.31472727,-0.29714237,-0.23978285,-0.42263795,-0.55944549,-0.70026796,-0.84676454,-0.75339329,-0.64343975,-0.56540966,-0.49479597,-0.42463914,-0.37321774,-0.27120909,-0.29552391,-0.21322196,-0.13452023,-0.013201045,0.066712801,0.11453519,0.19668271,0.23765706,0.39421244,0.32526082,0.39077277,0.46089023,0.48205928,0.39553,0.48979703,0.55113194,0.61666605,0.60228322,0.67278808,0.72074895,0.77390073:1
1.2614192,1.235011,1.1862033,1.1432787,1.0594662,1.0003114,0.92201556,0.8496445,0.74731186,0.67747728,0.61895304,0.55062919,0.47495385,0.4196198,0.33335255,0.24412699,0.15697889,0.04805648,-0.10572764,-0.2564232,-0.40978678,-0.55463018,-0.68392607,-0.7704497,-0.86441652,-0.88517151,-0.96409834,-0.96631201,-0.92258231,-0.91024612,-0.80512752,-0.68863789,-0.58260096,-0.47051574,-0.3650077,-0.25901177,-0.15547563,-0.05207992,0.044745293,0.080110681,0.042598286,-0.022591796,-0.088302789,-0.15642439,-0.24795229,-0.32135242,-0.3861169,-0.47136566,-0.54251146,-0.62957029,-0.71999924,-0.7924903,-0.86236559,-0.94164393,-1.0192649,-1.1043089,-1.1744859,-1.2615109,-1.3514905,-1.4080703,-1.4565053,-1.550535,-1.5949321,-1.6174897,-1.5375405,-1.4957931,-1.5561542,-1.5139681,-1.4510348,-1.4545636,-1.3326516,-1.2113105,-1.1080972,-0.99230447,-0.87205641,-0.75617444,-0.63261152,-0.50868066,-0.38436005,-0.25968158,-0.13554516,-0.058435843,0.039421705,0.12990523,0.25153347,0.27079802,0.3573231,0.48242144,0.60818576,0.73309873,0.85961683,0.99582759,1.1449181,1.2697205,1.3942341,1.5150913,1.6395689,1.7987983,1.9216562,2.082264,2.2042497,2.3005442,2.393443,2.4694805,2.4904446,2.5097037,2.4698815,2.3589955,2.2510379,2.1600603,2.1427294,2.0568019,2.0472131,1.9701109,1.8732388,1.7671077,1.6592207,1.5526669,1.4031722,1.2950949,1.1800517,1.0300617,0.89866121,0.7701492,0.63955216,0.51850333,0.39169453,0.26632726,0.13499024,0.012962106,0.0067061189,-0.089094823,-0.21390639,-0.36202024,-0.49858291,-0.58518942,-0.65535948,-0.72700348,-0.88277279,-0.93028601,-0.88244859,-0.84348731,-0.78796454,-0.74902403,-0.73072431,-0.66950665,-0.64175219,-0.60626937,-0.55464644,-0.46040068,-0.38916242,-0.33705587,-0.25578884,-0.22096862,-0.22120201,-0.29294851,-0.31121306,-0.36541489,-0.40963801,-0.46442943,-0.57796085,-0.67957241,-0.688265,-0.74353838,-0.79742545,-0.82239004,-0.93254585,-0.86747742,-0.83414579,-0.83261793,-0.78543086,-0.7415479,-0.69856246,-0.72312976,-0.62204839,-0.61891457,-0.53543886,-0.46117248,-0.34057025,-0.28841385,-0.24479676,-0.15107603,-0.15782585,-0.073175966,-0.050715599,-0.0063462622,0.045939812,0.080718203,0.086437126,0.064290803,0.065142374,0.12296768,0.12726517,0.13856389,0.21142119,0.20479383,0.25465431,0.27943905,0.29415124,0.32517111,0.38526287,0.47865585,0.45554778,0.52314788,0.59989438,0.64927512,0.72217231,0.76981792,0.84720571,0.90296743,0.9501048,0.99752516,1.085895,1.1397783,1.1196365,1.0076122,0.85361565,0.73405769,0.58389699,0.45934403,0.34805428,0.23528227,0.085450762,-0.064161371,-0.17785607,-0.2799112,-0.34824115,-0.46457987,-0.54905471,-0.67197513,-0.81327506,-0.95420643,-1.0790096,-1.2075846,-1.3183816,-1.4123596,-1.4494358,-1.578884,-1.7089756,-1.8364955,-1.9431714,-2.0650865,-2.1495763,-2.2569428,-2.1792903,-2.1979553,-2.1327684,-2.0603921,-1.9843301,-1.8818753,-1.7658536,-1.6573073,-1.5384434,-1.5687934,-1.517908,-1.4739429,-1.3978132,-1.3067022,-1.1828913,-1.0857228,-0.98183408,-0.85357274,-0.73509189,-0.62402024,-0.52019419,-0.42786781,-0.3469246,-0.32736527,-0.27604109,-0.38834145,-0.29267662,-0.190659,-0.31282742,-0.2840469,-0.25612334,-0.25492067,-0.26662428,-0.24546712,-0.19360913,-0.24140719,-0.16677945,-0.2327008,-0.15260604,-0.042324338,0.040533414,0.1316547,0.085382642,0.19616855,0.30076859,0.26596639,0.36744816,0.51486525,0.62222145,0.72214436,0.75415378,0.83185196,0.87834526,0.98061204,1.1301984,1.24531,1.3497409,1.4084521,1.5046032,1.5876613,1.7037287,1.8069957,1.7861643,1.7223172,1.643799,1.5862895,1.5046179,1.4288003,1.3790448,1.2995344,1.2058182,1.1102516,1.0440411,1.0317006,0.98429192,0.91657854,0.82828345,0.7286393,0.64059993,0.55636944,0.44782422,0.36471227,0.30668659,0.27908362,0.26187767,0.30350764,0.31930711,0.27575856,0.20619458,0.1511626,0.087849613,-0.014309937,-0.066988915,-0.14961296,-0.29068984,-0.3248553,-0.39319517,-0.4702758,-0.53842977,-0.59306099,-0.69860579,-0.79327135,-0.79043229,-0.87611103,-1.0132063,-1.1411532,-1.2674377,-1.395768,-1.5267705,-1.6022754,-1.6420551,-1.7457655,-1.6775246,-1.5833562,-1.4727121,-1.3473601,-1.3402593,-1.2224161,-1.1222211,-1.1722831,-1.2480191,-1.1393579,-1.0541023,-0.9628378,-0.8370492,-0.7553637,-0.67586966,-0.55633142,-0.44715343,-0.33179052,-0.23573054,-0.10730873,-0.038963315,0.061209854,0.096655482,0.14237611,0.19006718,0.24974169,0.36860669,0.48550622,0.56018532,0.65681038,0.75888897,0.88718805,0.86634177,0.85931855,0.87241228,0.82771308,0.77126017,0.84546886,0.86921854,0.84817504,0.79818631,0.77258328,0.79642263,0.7641881,0.73911665,0.74438038,0.72012131,0.73596956,0.71049794,0.65423093,0.65749191,0.68582285,0.67782576,0.63315862,0.66873075,0.72024623,0.68478918,0.68373001,0.73697776,0.70368947,0.71384769,0.70920438,0.74370127,0.75495288,0.80738016,0.8770164,0.9661479,1.0496747,1.1317862,1.2026749,1.2630347:5
2.0026737,1.9179065,1.843935,1.769935,1.7071099,1.646956,1.5747476,1.5162737,1.4763974,1.4897549,1.5737219,1.6212169,1.5684259,1.487385,1.4110605,1.3396947,1.2613483,1.1809464,1.1013426,1.0202417,0.93884368,0.83948255,0.76713823,0.69562808,0.61863615,0.55150192,0.48966359,0.4352416,0.40320104,0.38642602,0.40387695,0.44275566,0.49560412,0.55774302,0.63354761,0.6960032,0.7738712,0.84467361,0.92122837,1.0044876,1.010811,0.90455478,0.81937949,0.73366208,0.625801,0.53913981,0.44009511,0.43619162,0.35314422,0.26193721,0.17766496,0.099804694,0.012915761,-0.076492396,-0.16448948,-0.25049096,-0.33584959,-0.42526105,-0.52937228,-0.63214296,-0.70942721,-0.80934152,-0.89347054,-0.97334004,-1.0676865,-1.1571266,-1.2450114,-1.3202447,-1.3698465,-1.4294174,-1.4851536,-1.5449735,-1.584406,-1.6078783,-1.6238888,-1.6328032,-1.603005,-1.5368523,-1.4447163,-1.3661565,-1.2607993,-1.1773469,-1.0936994,-1.0066119,-0.91685331,-0.82665308,-0.74304,-0.65622467,-0.61834916,-0.5329197,-0.44334623,-0.35578157,-0.27009513,-0.27438816,-0.33558435,-0.4007903,-0.46313546,-0.53340602,-0.60064964,-0.65865076,-0.71108266,-0.72474006,-0.7211726,-0.73010825,-0.77584566,-0.82195367,-0.87544981,-0.92548494,-0.97673703,-1.0239113,-1.0654338,-1.1079767,-1.1422231,-1.1638943,-1.1993059,-1.2270078,-1.255239,-1.2816403,-1.3067077,-1.3281221,-1.3350681,-1.3342758,-1.3202888,-1.2781139,-1.2171709,-1.1458937,-1.0741129,-0.99916743,-0.92570847,-0.83493787,-0.74757451,-0.66359906,-0.58431586,-0.48251241,-0.40409272,-0.30149904,-0.2134527,-0.15030345,-0.085036625,-0.054704123,-0.062702613,-0.087789673,-0.084429738,-0.11448733,-0.089830887,-0.068759969,-0.085988424,-0.10476158,-0.12314533,-0.13168534,-0.13618141,-0.1412738,-0.14193922,-0.14095362,-0.13710878,-0.13283979,-0.11821622,-0.10122177,-0.08649675,-0.066200913,-0.064826695,-0.044994172,-0.019947683,0.011141753,0.031270636,0.063463758,0.10840555,0.1726311,0.24385685,0.3460149,0.43023762,0.51791538,0.60215557,0.66229939,0.70325018,0.7261204,0.77323882,0.8364434,0.87419864,0.90241177,0.92661245,0.9594665,0.96320742,0.97349993,0.99112779,0.99363557,1.0143833,1.0193215,1.045235,1.0523223,1.0704381,1.0737768,1.0784635,1.0648556,1.0490148,1.0240454,1.0160622,1.1136367,1.1967578,1.2787997,1.3621265,1.4727029,1.583681,1.6948465,1.8061477,1.9012359,2.0017816,2.1128804,2.2237482,2.3160079,2.3188421,2.2556,2.1713933,2.0604669,1.9494452,1.8382777,1.7537261,1.6425827,1.5370171,1.4595685,1.3889623,1.2829524,1.2185933,1.136419,1.0886164,1.0590149,1.034601,1.0130789,0.98304729,0.95131051,0.91415841,0.87096219,0.82272419,0.7881143,0.75423768,0.71743858,0.67808609,0.64175069,0.60594961,0.57100946,0.5352906,0.5004469,0.46254012,0.43664532,0.41133683,0.38688939,0.36733394,0.34770619,0.32860441,0.30919996,0.2898748,0.28932594,0.28319781,0.27883376,0.27366302,0.27079019,0.28578449,0.30030405,0.31270407,0.3341945,0.36156567,0.39488581,0.36637897,0.35843391,0.3574994,0.37208044,0.41153441,0.43628201,0.4764394,0.51809544,0.47299463,0.41150427,0.35308221,0.28182925,0.19564979,0.12253582,0.036872453,-0.041892538,-0.11589378,-0.19360242,-0.26690772,-0.34790608,-0.42521876,-0.49968529,-0.57658687,-0.65354658,-0.73233414,-0.81750943,-0.88870017,-0.97346936,-1.0519822,-1.1135783,-1.1806944,-1.2474152,-1.2975528,-1.3534405,-1.3733863,-1.3813339,-1.3896516,-1.3937916,-1.389488,-1.3878386,-1.3863218,-1.3799565,-1.3518731,-1.3294628,-1.3088538,-1.2943902,-1.270555,-1.246138,-1.2098081,-1.1733439,-1.1270434,-1.0855721,-1.0331357,-0.98121774,-0.92768555,-0.86733013,-0.81358196,-0.79104112,-0.74755829,-0.6868081,-0.62550746,-0.55293401,-0.48410072,-0.41449663,-0.34628278,-0.33925695,-0.41972963,-0.49581509,-0.58640448,-0.6767033,-0.75894255,-0.8438456,-0.89598108,-0.97884572,-1.0682282,-1.1538283,-1.2634096,-1.3532087,-1.4359407,-1.5211163,-1.592445,-1.6618439,-1.7124707,-1.7672754,-1.8045935,-1.8381162,-1.8532074,-1.8504854,-1.8307404,-1.7783003,-1.6990906,-1.6200172,-1.5336896,-1.4585124,-1.3714538,-1.3028642,-1.214561,-1.1312207,-1.0491368,-0.96357192,-0.88061784,-0.79465605,-0.70561775,-0.62288257,-0.54418376,-0.45680716,-0.3829549,-0.29459351,-0.22234798,-0.20543687,-0.17309242,-0.079634787,0.0052323418,0.088368116,0.17624641,0.26553387,0.35502162,0.44270309,0.53040515,0.61492726,0.64303816,0.56540086,0.4900065,0.41316751,0.33716499,0.26865922,0.20136841,0.13556707,0.067377988,-0.0031907647,-0.064134506,-0.11716023,-0.16774246,-0.21311238,-0.26042907,-0.30098642,-0.31207606,-0.27734235,-0.22376329,-0.15946634,-0.08603459,0.01856397,0.10026756,0.20930311,0.29274288,0.40189929,0.51163758,0.59591487,0.659528,0.76188248,0.87186198,0.96851716,1.0659822,1.1539671,1.258281,1.3487512,1.4347664,1.5215626,1.5542116,1.5718058,1.6562393,1.7418054,1.8275194,1.9106427,2.0016133:4
0.5863136,0.50144973,0.49166545,0.45389333,0.36705613,0.27267694,0.14216276,0.043317094,-0.025309324,-0.052666059,-0.099155669,-0.084372038,-0.086933826,-0.13019493,-0.17508018,-0.26001065,-0.2377395,-0.066485369,0.098085395,0.17718636,0.19280768,0.19696498,0.10807319,0.071901901,0.059915506,-0.033458447,-0.11614824,-0.18707473,-0.3183331,-0.42572047,-0.51875448,-0.63005953,-0.69279466,-0.79740373,-0.91463531,-0.97087213,-1.1358068,-1.2503925,-1.3745764,-1.5491999,-1.713744,-1.8960292,-2.0772781,-2.2408899,-2.422448,-2.562813,-2.634583,-2.521898,-2.5901692,-2.6480389,-2.735998,-2.6190778,-2.6065096,-2.6633428,-2.5418307,-2.4555505,-2.3154972,-2.1577037,-2.0963861,-1.9162414,-1.7721635,-1.5864021,-1.4392637,-1.2430966,-1.0735348,-0.90227154,-0.79944601,-0.7136845,-0.59615261,-0.49687008,-0.34825432,-0.19587274,-0.11076705,0.035964382,0.18382506,0.31508742,0.36374641,0.51506487,0.61423095,0.7808389,0.94442096,1.0680683,1.1985087,1.2903357,1.5050206,1.6648301,1.8666606,2.0499798,2.2106153,2.3434736,2.3810464,2.3447902,2.2741064,2.217712,2.1450404,2.0477946,1.9000296,1.765845,1.7050465,1.7764747,1.6187733,1.5040797,1.3398927,1.230748,1.0367237,0.91256984,0.80041755,0.80302494,0.84255753,0.8480546,0.88301,0.89589509,0.90042448,0.95383646,0.96174409,0.97652522,0.94414584,0.88885062,0.76575223,0.6669883,0.57963142,0.54963721,0.57063073,0.5844853,0.62381071,0.69241902,0.74418068,0.77965436,0.81313808,0.83728032,0.84546219,0.87010204,0.9362141,0.98901045,1.0627954,1.115889,1.1243497,1.0603192,0.92855979,0.74686012,0.55631044,0.42885541,0.29608552,0.19626005,0.010391799,-0.14988471,-0.21002382,-0.17638374,-0.33142408,-0.30969343,-0.25185587,-0.19221586,-0.087142149,0.0027612433,0.067626261,0.092182101,0.16927796,0.24894526,0.25710013,0.30311343,0.33557168,0.3835825,0.46805624,0.50978241,0.59110058,0.61108204,0.58280951,0.59848092,0.51235298,0.61570905,0.64604979,0.69630414,0.78463537,0.88834331,1.0416473,1.0947388,1.1940595,1.3620349,1.3081072,1.1722371,1.0127625,0.86847291,0.71073342,0.55489397,0.4142471,0.23293089,0.12444236,-0.052433752,-0.17505922,-0.31017944,-0.46273475,-0.62334814,-0.76116467,-0.94699234,-1.0834301,-1.2365801,-1.3908053,-1.5673296,-1.7314135,-1.8716231,-1.7693514,-1.6348514,-1.5031375,-1.3632903,-1.2333567,-1.1108866,-1.0278799,-0.93229845,-0.86922414,-0.79277354,-0.74993505,-0.68958464,-0.61319731,-0.49789653,-0.39951919,-0.35673038,-0.25244442,-0.31490739,-0.20486724,-0.18009212,-0.15082378,-0.19870785,-0.11657889,0.013454187,0.11410578,0.22610214,0.35733756,0.38615396,0.39605668,0.50378985,0.6145986,0.56487873,0.65288204,0.7185761,0.68236773,0.60718507,0.46663239,0.30551496,0.18385724,0.016257048,-0.19666837,-0.22799206,-0.24864336,-0.45349652,-0.66220548,-0.87173939,-0.8342427,-1.0224927,-1.2283311,-1.3568045,-1.486824,-1.6632361,-1.5275185,-1.4934351,-1.345705,-1.4489392,-1.3076596,-1.1856214,-1.0427713,-0.9282714,-0.79419651,-0.68138965,-0.61856429,-0.62406823,-0.54425395,-0.44214169,-0.30164488,-0.24906931,-0.15182795,-0.033309436,-0.090141058,-0.13143217,0.011328835,0.16886714,0.10368733,0.13011724,0.029962023,0.1104298,-0.029117207,-0.078573416,-0.058435581,-0.19818438,-0.25399128,-0.16131026,-0.22158229,-0.32997044,-0.46894174,-0.59615261,-0.72778862,-0.85489087,-0.77045985,-0.85216776,-0.98118356,-1.0942298,-1.2230474,-1.333675,-1.4515242,-1.5656189,-1.6843182,-1.8099649,-1.6632477,-1.595332,-1.4733858,-1.290407,-1.0847337,-0.97432518,-0.8272747,-0.67162,-0.50427422,-0.39737532,-0.2491916,-0.11975393,0.043317094,0.19780911,0.28299973,0.27929862,0.40965302,0.4703899,0.66337718,0.77780531,0.92207121,1.04949,1.1883279,1.3462286,1.3374442,1.1841784,1.1108369,0.9861138,0.94861528,0.90986115,0.79493389,0.73423052,0.71868282,0.60119614,0.47774948,0.41744936,0.30134893,0.19455734,0.074388863,0.040445181,0.1883726,0.11178423,0.011854015,-0.071418792,-0.13390248,-0.21137347,-0.29909924,-0.37772413,-0.46237715,-0.54569982,-0.62269562,-0.74382922,-0.72708735,-0.62036665,-0.58976713,-0.49892322,-0.36048059,-0.21686573,-0.10448619,-0.071777307,0.0055253586,0.1368117,0.23824047,0.36008351,0.52798237,0.56968035,0.70939559,0.85200903,0.99082025,1.0753034,1.241051,1.3984778,1.5277865,1.6945832,1.8089022,1.6573582,1.4878296,1.4402401,1.3257232,1.2827717,1.2591527,1.0922609,1.149658,1.0617621,0.97278567,0.88449096,0.74684417,0.79440569,0.66011011,0.53544267,0.55372418,0.64302443,0.67788181,0.57810666,0.48743268,0.46685572,0.48988639,0.41516341,0.35730933,0.2935057,0.18289689,0.15147909,0.033519392,0.077321072,-0.043656576,-0.085112892,-0.066187191,-0.15868422,-0.19977899,-0.3183437,-0.40962629,-0.4996209,-0.63168333,-0.61086281,-0.66790296,-0.67494486,-0.46683949,-0.25802373,-0.049411651,0.10984495,0.26685214,0.46537707,0.62608559,0.5978322,0.53429569,0.60434374,0.61654969:1
2.2139664,2.1467445,2.0766887,1.9945296,1.9178912,1.8311554,1.7587206,1.6731997,1.6169655,1.5316492,1.4476985,1.4004833,1.3386809,1.2592534,1.1926611,1.1149755,1.0877928,1.1307165,1.0813337,1.0186335,0.9293358,0.87595171,0.80786331,0.75222618,0.75742624,0.71294428,0.6435271,0.57433961,0.50606753,0.42821485,0.35575531,0.26951176,0.20102469,0.21003101,0.2736425,0.1995215,0.13623416,0.05696557,0.0053516506,-0.078752257,-0.19373601,-0.28516427,-0.32387555,-0.26042135,-0.18152887,-0.15770724,-0.067082239,0.02113346,0.098274138,0.088159414,0.15906949,0.25075204,0.31099712,0.33156776,0.42066503,0.48833151,0.57809884,0.61625424,0.55273506,0.46373251,0.37762587,0.30895322,0.26414005,0.20239589,0.11126494,0.068684276,0.15293371,0.24816187,0.26306441,0.3475329,0.43606663,0.51440755,0.5961121,0.68630907,0.78385701,0.84248576,0.77087383,0.70913239,0.6267253,0.54150785,0.50962547,0.42594381,0.34387996,0.39217586,0.33097023,0.26639,0.20646557,0.19350927,0.20340648,0.18421834,0.18069265,0.17031029,0.15458341,0.13449648,0.17754238,0.26244012,0.26878607,0.25031226,0.24851706,0.21190772,0.2233108,0.19576521,0.15754713,0.16403038,0.24829337,0.34769069,0.36207676,0.33118044,0.35595881,0.3280937,0.32447668,0.29606091,0.2478539,0.22385726,0.24853384,0.20914948,0.15456474,0.11567273,0.055141516,0.083964104,0.043322606,-0.01871124,-0.029490659,-0.088600054,-0.090929484,-0.15260808,-0.20200046,-0.29282265,-0.28968955,-0.36237344,-0.44953161,-0.54087958,-0.62161099,-0.70774783,-0.77989248,-0.72594009,-0.6411457,-0.54811041,-0.43553344,-0.333748,-0.21298782,-0.11464017,-0.038684364,0.079550763,0.19806295,0.31826406,0.42354579,0.51475083,0.61993608,0.72850215,0.85176071,0.97565553,1.0675532,1.1178744,1.238922,1.3446208,1.4538005,1.5399494,1.6004861,1.5249821,1.5616976,1.6675535,1.5847359,1.6448557,1.6008266,1.5122243,1.4732097,1.4088878,1.3218896,1.20399,1.1030052,0.98745475,0.86565936,0.81727451,0.73710891,0.61733971,0.52504243,0.40157866,0.27759802,0.1545871,0.04344591,-0.033675777,-0.090560997,-0.18559401,-0.27101276,-0.23287422,-0.18015897,-0.12457698,-0.082023123,-0.022711741,0.022384808,0.064426287,0.1076843,0.10971035,0.1641166,0.22524058,0.28033599,0.3411284,0.30020715,0.35676635,0.39922634,0.42213867,0.40887972,0.45441816,0.48460252,0.41762281,0.32406157,0.25739399,0.16324475,0.15784706,0.19424479,0.26113867,0.32208795,0.33122778,0.3240599,0.3908962,0.39523421,0.44383789,0.46879774,0.43501116,0.34959014,0.28687037,0.30921789,0.31624837,0.38822538,0.43391502,0.3591006,0.42250985,0.49942456,0.45822075,0.50393854,0.53634951,0.47050338,0.42163256,0.39350718,0.47779731,0.46325463,0.53666173,0.56903771,0.47693651,0.5222571,0.56248948,0.62079157,0.65806941,0.60350731,0.70126741,0.72413064,0.73623659,0.79345664,0.85375257,0.90145198,0.91843726,0.81783222,0.7099705,0.60013437,0.52190996,0.44905476,0.33726002,0.27533315,0.18103727,0.1247704,0.045286015,-0.051480004,-0.13436137,-0.21993297,-0.31186979,-0.35946893,-0.46653567,-0.5474739,-0.61996725,-0.67792069,-0.75388891,-0.8392832,-0.89867764,-0.9886041,-1.0676717,-1.1442074,-1.2151351,-1.2860833,-1.3274053,-1.3913711,-1.4859853,-1.5747072,-1.6226311,-1.6877311,-1.726624,-1.7893342,-1.8506477,-1.8936039,-1.8980297,-1.9360791,-1.9329107,-2.0155675,-2.0011908,-1.990399,-1.9681015,-1.9282009,-1.8506581,-1.8091755,-1.76415,-1.6827969,-1.6158229,-1.6705555,-1.7706515,-1.8494541,-1.9474025,-2.0437865,-2.0967095,-2.1020306,-2.1547461,-2.2461545,-2.3136115,-2.3784212,-2.3895796,-2.3972169,-2.4000049,-2.3728004,-2.3380179,-2.2909951,-2.2917931,-2.213352,-2.1232427,-2.0452285,-2.0605833,-2.0177409,-1.9311541,-1.8407614,-1.8251786,-1.7620632,-1.6919341,-1.6673585,-1.5808461,-1.5177952,-1.5545382,-1.5050303,-1.3863755,-1.3319785,-1.2909813,-1.1778964,-1.1527974,-1.0541753,-0.97824997,-0.99650521,-0.99378375,-0.90217271,-0.88130601,-0.79333668,-0.71226513,-0.67629028,-0.69751844,-0.6055064,-0.52550976,-0.44118968,-0.46112983,-0.40235288,-0.31057007,-0.28097914,-0.19834964,-0.11549947,-0.03284408,-0.058794904,-0.15362207,-0.23207263,-0.32561772,-0.3392692,-0.43529316,-0.52903931,-0.51221525,-0.55995031,-0.65222411,-0.69684395,-0.78770968,-0.78833993,-0.87420359,-0.9360201,-0.98738304,-0.92694583,-0.8679168,-0.80655974,-0.71780239,-0.65012159,-0.61345397,-0.52145788,-0.43120161,-0.40064611,-0.31096758,-0.25726671,-0.16673994,-0.13511991,-0.1621434,-0.14968151,-0.15957082,-0.10276467,-0.0086639154,0.054652377,0.12451543,0.21824342,0.26505233,0.36149996,0.33930445,0.35008719,0.40941241,0.48064387,0.53891425,0.62912456,0.69365706,0.77947173,0.87959136,0.84096271,0.89318759,0.99888352,1.0267916,1.1121869,1.1750491,1.2702373,1.2874019,1.3000545,1.3961197,1.5083957,1.5462538,1.622941,1.723566,1.8001026,1.8872512,1.9815425,2.0825013,2.1832137:6
1.9329847,1.8956436,1.8637694,1.7859294,1.7127834,1.6348723,1.558323,1.4990939,1.4503834,1.3919331,1.3336835,1.2818821,1.2113315,1.1496736,1.0707596,0.99844637,0.92324855,0.81823867,0.72922254,0.60466089,0.4814517,0.35646178,0.22986991,0.10429492,-0.020692085,-0.14159264,-0.21574632,-0.31206905,-0.3850419,-0.40006227,-0.34013665,-0.2579495,-0.18229394,-0.10643355,-0.065466193,0.0084320714,0.045768726,0.12713292,0.21003388,0.2968996,0.3785683,0.46867029,0.55226447,0.64923567,0.73001404,0.80514896,0.875428,0.91147548,0.98582538,1.0102748,0.95239814,0.95167181,0.92591916,0.89144001,0.85521811,0.79671462,0.74630966,0.67665349,0.59733533,0.51792086,0.43419803,0.35412142,0.26759933,0.19408784,0.10495799,0.044406347,-0.042595813,-0.12747007,-0.15826964,-0.20651849,-0.29664314,-0.36505931,-0.44732059,-0.51464935,-0.59475745,-0.67471177,-0.74856003,-0.81060779,-0.87935254,-0.93517843,-1.017977,-1.0747938,-1.1702469,-1.2369618,-1.3074472,-1.3705312,-1.3860867,-1.3779357,-1.4016206,-1.3679458,-1.2725572,-1.218074,-1.1905429,-1.0649762,-0.99872545,-0.91809391,-0.80524938,-0.68877992,-0.63436336,-0.56844016,-0.52125938,-0.4724292,-0.43594675,-0.41819823,-0.36810311,-0.36485736,-0.37757634,-0.34866183,-0.35869723,-0.34802202,-0.32713226,-0.33638986,-0.35732818,-0.38033629,-0.3907967,-0.39775887,-0.42259712,-0.487546,-0.49786919,-0.50319686,-0.50678241,-0.51660536,-0.53441865,-0.53282991,-0.57391552,-0.60597818,-0.60610835,-0.61453776,-0.66528416,-0.61885017,-0.69437512,-0.69533438,-0.69708863,-0.77835867,-0.88078989,-0.95774758,-0.99538029,-1.021277,-1.0888735,-1.1089068,-1.0185949,-1.0322651,-0.99508373,-0.91510032,-0.82103662,-0.69124423,-0.60382895,-0.51001959,-0.39132367,-0.27494967,-0.20936287,-0.098231733,0.0081462439,0.066031442,0.13930678,0.19703915,0.27108963,0.3217902,0.40768401,0.45094313,0.50497482,0.53577888,0.59801209,0.60044063,0.61968153,0.67080525,0.66047118,0.70623905,0.74979037,0.81521477,0.83369521,0.8045466,0.77833787,0.83657489,0.84696221,0.84100511,0.85203137,0.86767017,0.79906688,0.75066285,0.80871763,0.77321919,0.83354598,0.833298,0.82491513,0.88317541,0.92242288,0.98983457,1.118842,1.206763,1.2948994,1.3826831,1.4161795,1.4483236,1.4804065,1.4762413,1.5238895,1.5641498,1.6028326,1.6903054,1.740837,1.8018465,1.861459,1.8520854,1.7363768,1.6590462,1.5757173,1.4814732,1.3829869,1.3137131,1.1943857,1.0587914,0.97022615,0.90059811,0.83472647,0.76736481,0.71028795,0.65905518,0.60128099,0.5147944,0.42939279,0.35412218,0.28954233,0.21997938,0.17401932,0.11601895,0.050451161,-0.0087453715,-0.07277252,-0.11963687,-0.17439194,-0.22943315,-0.28168692,-0.3304373,-0.35183043,-0.39390087,-0.42253222,-0.51614436,-0.59103886,-0.65958651,-0.6629045,-0.69395206,-0.62291661,-0.66052294,-0.56768565,-0.45984534,-0.46202725,-0.39812531,-0.43248692,-0.45615519,-0.47264665,-0.41742578,-0.39169022,-0.36247497,-0.31398883,-0.33384762,-0.36408933,-0.36527866,-0.25553906,-0.16820662,-0.077415883,0.021695014,0.12635804,0.14840633,0.045318971,-0.04000897,-0.15635975,-0.23455196,-0.34133899,-0.44112712,-0.52076123,-0.61094617,-0.72184804,-0.80875331,-0.8866933,-0.98676076,-1.0461436,-0.97390902,-0.92547073,-0.88660293,-0.81234015,-0.68851865,-0.59184081,-0.48051348,-0.52534563,-0.62048215,-0.69917282,-0.79912517,-0.88389937,-0.96958261,-1.053979,-1.164894,-1.2356227,-1.3393549,-1.3256119,-1.3804667,-1.4584013,-1.4358428,-1.3896682,-1.433328,-1.4043013,-1.3791117,-1.3692622,-1.3484599,-1.3189883,-1.2962599,-1.2976284,-1.2906633,-1.3028349,-1.279183,-1.2639893,-1.248134,-1.2153864,-1.1813803,-1.1471474,-1.0989781,-1.0597581,-1.0202634,-0.97486562,-0.91737455,-0.86002606,-0.8286476,-0.802173,-0.80031169,-0.74696448,-0.67657245,-0.58985366,-0.52176337,-0.45849793,-0.39564845,-0.33441885,-0.28247236,-0.23576152,-0.22630177,-0.27192506,-0.30766497,-0.38398573,-0.4467579,-0.54672885,-0.65725271,-0.77024314,-0.85896688,-0.96526703,-1.0665002,-1.1390778,-1.2040541,-1.287531,-1.3793654,-1.4719661,-1.5776271,-1.6717021,-1.7807717,-1.8679662,-1.9705985,-2.0588222,-2.0286825,-1.9496601,-1.8414939,-1.7623156,-1.643155,-1.5538294,-1.4707331,-1.3436036,-1.250679,-1.1604638,-1.0577815,-0.94556089,-0.85674297,-0.73717355,-0.64419855,-0.52807937,-0.41706038,-0.30889045,-0.25323114,-0.19384496,-0.07556288,0.039702677,0.15546422,0.22300533,0.33900384,0.44486855,0.52658853,0.62576938,0.70623918,0.77730708,0.89234311,0.96926147,1.0532232,1.1418773,1.2197539,1.2981604,1.3531827,1.4125728,1.4582921,1.5167221,1.5117842,1.4890904,1.5570688,1.6300127,1.6407088,1.726169,1.7699127,1.8245121,1.7921042,1.7972463,1.7204623,1.6658293,1.6351801,1.5651596,1.5209203,1.4894032,1.4964361,1.5409822,1.6160299,1.6061552,1.56695,1.6124881,1.660271,1.7102819,1.7195508,1.7572822,1.7618923,1.8108258,1.8083847,1.8993646,1.9163386,1.9530478:2
2.0885722,2.0640212,2.0704458,2.0609498,2.0895169,2.0785891,2.0417743,1.9970712,1.9458965,1.865443,1.7699114,1.6937728,1.622734,1.5217391,1.4357128,1.3704332,1.3017207,1.2263693,1.1302653,1.031395,0.98358882,0.88707116,0.79227023,0.69733158,0.65093223,0.55478471,0.46256936,0.36574379,0.26656328,0.16929663,0.11339963,0.050615155,7.4938317E-4,-0.065010443,-0.1549402,-0.2556063,-0.29297116,-0.37355097,-0.40887817,-0.42485751,-0.44230741,-0.45556309,-0.44043458,-0.43443978,-0.44063828,-0.44012191,-0.45023059,-0.47817411,-0.48622273,-0.49153444,-0.49126495,-0.50882062,-0.52588861,-0.53641394,-0.56729139,-0.57100507,-0.57993767,-0.59011939,-0.62294124,-0.61729633,-0.63256883,-0.65057373,-0.66199185,-0.68486072,-0.7093125,-0.74037938,-0.77186727,-0.79349812,-0.82358054,-0.86798966,-0.91875803,-0.94412838,-0.98657681,-1.0438209,-1.0817456,-1.1327383,-1.1684727,-1.2119704,-1.2616392,-1.304464,-1.3559876,-1.4379135,-1.4994259,-1.5542233,-1.6549674,-1.7052766,-1.8081412,-1.9109926,-2.0136017,-2.0715737,-2.0949411,-2.0904647,-2.0761275,-2.0456925,-2.0122172,-1.9665572,-1.923371,-1.8675319,-1.8347556,-1.77736,-1.7160818,-1.6557626,-1.5943607,-1.5311126,-1.4661147,-1.4139966,-1.3844357,-1.31859,-1.2613118,-1.2180158,-1.1630712,-1.1121695,-1.067949,-0.99419482,-0.95318398,-0.88747938,-0.80104593,-0.7055439,-0.65530862,-0.54531501,-0.52688232,-0.45958537,-0.41557042,-0.35416074,-0.28390848,-0.2743841,-0.2959447,-0.24762888,-0.17948153,-0.11200807,-0.083293087,-0.013136014,0.054393818,0.109716,0.19264901,0.23531802,0.31618587,0.3800237,0.43609402,0.46359602,0.49918966,0.58461022,0.64768061,0.73532449,0.79224427,0.8692677,0.93986597,1.0054336,1.0788486,1.1509039,1.2277485,1.3081442,1.3969243,1.4510769,1.5429321,1.6277375,1.7068558,1.780711,1.8314435,1.8525931,1.8614157,1.8385051,1.8665928,1.8301337,1.8070355,1.7378143,1.6854171,1.6239457,1.5856938,1.5203966,1.4758042,1.4112317,1.3737298,1.3067508,1.2265027,1.2417797,1.2669708,1.2160232,1.1375037,1.085766,1.0310207,0.97438853,0.91899057,0.8647587,0.79889568,0.73283704,0.66839087,0.60296521,0.52459942,0.46355378,0.37998574,0.31620163,0.24178859,0.26572214,0.36158103,0.41807311,0.4911965,0.52513303,0.56588093,0.61820691,0.65597643,0.66473596,0.67772902,0.65436319,0.63384411,0.60452145,0.59990521,0.62943273,0.60413409,0.55137877,0.54027792,0.48597246,0.45625142,0.43322621,0.41525919,0.39475645,0.35557367,0.31185556,0.30954511,0.24535934,0.26154734,0.31094786,0.34410255,0.37583633,0.32267338,0.32184208,0.39891331,0.42753192,0.45400998,0.46733129,0.48346463,0.52775771,0.51978401,0.52032348,0.51754248,0.52121444,0.50785938,0.48830143,0.44813013,0.4148184,0.35923174,0.31669993,0.24694552,0.20978833,0.13054164,0.049204367,-0.032712101,-0.11288421,-0.19846795,-0.28802882,-0.36635519,-0.43321589,-0.49731028,-0.54942126,-0.58725374,-0.6306057,-0.66449742,-0.72057195,-0.74711273,-0.80568718,-0.87773114,-0.95320867,-0.98955697,-1.0168147,-1.0530686,-1.126399,-1.208361,-1.2522622,-1.3346788,-1.3816935,-1.4511126,-1.5414112,-1.6052039,-1.683766,-1.7319771,-1.7949009,-1.8574781,-1.9147558,-1.9093465,-1.8386039,-1.8114374,-1.7497814,-1.6891588,-1.6382172,-1.5588108,-1.4616002,-1.4154443,-1.3210357,-1.2259352,-1.1275455,-1.0746951,-1.0254153,-0.98303254,-0.88705074,-0.78803809,-0.68735434,-0.5901398,-0.53884363,-0.45690984,-0.40466193,-0.31983388,-0.26920929,-0.2232464,-0.17647398,-0.13023192,-0.10148669,-0.067290272,-0.033233159,0.017567259,0.048657301,0.078703874,0.11497813,0.13221127,0.13820157,0.14448257,0.14879019,0.15607369,0.15115648,0.12916505,0.1320422,0.12178907,0.11128108,0.10481511,0.089139437,0.070543162,0.044377887,0.016837835,9.1679291E-4,-0.034306521,-0.054993943,-0.08390915,-0.11712174,-0.14437742,-0.19080516,-0.23715994,-0.2810297,-0.34442986,-0.42691803,-0.50653687,-0.583776,-0.66534379,-0.7293813,-0.75298851,-0.81706398,-0.84316517,-0.89785433,-0.90120147,-0.85616582,-0.78877321,-0.72534974,-0.65345949,-0.58325168,-0.5146155,-0.42490549,-0.34212031,-0.26786638,-0.20223587,-0.17357376,-0.11966358,-0.089572056,-0.068738891,-0.056570047,-0.032579188,-0.018892013,0.0074510382,0.012932174,0.021811144,0.035763495,0.042869877,0.040959605,0.043514274,0.050412328,0.056432747,0.071044079,0.079880247,0.11361918,0.098981491,0.099473073,0.087569609,0.10142952,0.08395765,0.062950982,0.084674038,0.071090333,0.055772649,0.074618337,0.095409924,0.07360469,0.024760349,0.0068150923,-0.014478974,-0.073433601,-0.07678977,-0.034911831,0.0036645273,-0.071567332,-0.072443226,0.026988094,0.13175809,0.18237727,0.28484987,0.3875093,0.48945396,0.58876345,0.63849087,0.73840556,0.83848066,0.93902284,0.98884039,1.0860309,1.1351093,1.2059262,1.2808518,1.3399131,1.4295856,1.4899626,1.5452337,1.6017264,1.6553234,1.7254797,1.7758544,1.8657818,1.9226065,1.9820508,2.0570834,2.0840842,2.0933122:2
-0.060286022,-0.13798016,-0.19699423,-0.26947807,-0.40509926,-0.46646281,-0.53463365,-0.62691194,-0.72505905,-0.82889491,-0.94822746,-1.0745604,-1.1953765,-1.3034909,-1.4184465,-1.5209217,-1.6382483,-1.7360101,-1.8224008,-1.8648432,-1.8818772,-1.8701859,-1.8445095,-1.8059731,-1.7639406,-1.7174163,-1.6593115,-1.5990041,-1.5393815,-1.4781749,-1.4186835,-1.3464101,-1.2756886,-1.2086603,-1.1343508,-1.0598812,-0.98485943,-0.9038869,-0.82375133,-0.74785581,-0.65652552,-0.5687667,-0.4761819,-0.37507417,-0.27924642,-0.18251983,-0.31433642,-0.45177151,-0.47760151,-0.40367609,-0.30881459,-0.21906111,-0.12437814,-0.030198845,0.067381863,0.16930032,0.26078752,0.36300096,0.46158816,0.37101856,0.26448479,0.15570669,0.03826356,-0.06958087,-0.16962157,-0.22782641,-0.30856332,-0.41855985,-0.52841135,-0.64527479,-0.75404071,-0.86654257,-0.97061604,-1.0814696,-1.1942607,-1.3122652,-1.4156314,-1.5288207,-1.6286396,-1.6963544,-1.7493142,-1.7634879,-1.7465802,-1.7056703,-1.6233142,-1.5295202,-1.3870269,-1.2446902,-1.114732,-0.96598906,-0.8391315,-0.7112291,-0.57864465,-0.45158591,-0.33674405,-0.20324154,-0.073321785,0.039880365,0.16956788,0.28642929,0.41801398,0.52705196,0.47144514,0.44633693,0.5677469,0.71740393,0.86453355,0.98698707,1.1074025,1.2261685,1.316043,1.3847604,1.2776228,1.1288704,0.97600558,0.86706327,0.75535919,0.67971563,0.61076675,0.56254608,0.5360132,0.536767,0.57956543,0.66793634,0.77113291,0.87495656,0.99885746,1.1084163,1.2377679,1.3914114,1.5451619,1.5625559,1.4739264,1.3874161,1.3337421,1.3700295,1.459239,1.5644188,1.6791515,1.802502,1.9101189,2.0212133,1.9993853,1.8750119,1.7492345,1.6014764,1.5061886,1.5320562,1.5983383,1.5838609,1.4732081,1.3702318,1.2450999,1.1140869,1.0116811,0.86889733,0.75478486,0.66602462,0.6246467,0.60181163,0.60062573,0.64989869,0.72977053,0.81683804,0.91323207,1.0135092,1.1023849,0.98208048,0.85843398,0.74030222,0.63091453,0.52083947,0.41405418,0.43272681,0.388326,0.27129077,0.15580529,0.042722331,-0.074303722,-0.18678041,-0.30875158,-0.43166752,-0.53977283,-0.6478329,-0.77112119,-0.88468552,-0.99606027,-1.0468662,-1.0597032,-1.0596215,-1.0321953,-0.98026438,-0.92544022,-0.85660142,-0.75654407,-0.64855855,-0.53232277,-0.42248893,-0.31148318,-0.20313402,-0.091545632,-0.016877065,0.099247869,0.19834503,0.30781836,0.41796088,0.36627694,0.26921062,0.16436792,0.12108985,0.039103604,-0.062997975,-0.1671306,-0.27288147,-0.37305729,-0.47339166,-0.57071141,-0.45247393,-0.42112467,-0.44541619,-0.51103777,-0.63049852,-0.7320573,-0.83206851,-0.93060603,-1.0367032,-1.1311409,-1.2245282,-1.3194658,-1.4117414,-1.5042139,-1.5953074,-1.6901369,-1.7777874,-1.851407,-1.906526,-1.9507717,-1.9775923,-1.950788,-1.8959327,-1.8116716,-1.7244547,-1.6242301,-1.5219599,-1.4122759,-1.2811494,-1.149939,-0.99826464,-0.85588673,-0.81232646,-0.7205997,-0.59053141,-0.43740618,-0.30881758,-0.1828377,-0.052609467,-0.031708096,-0.15490379,-0.27479071,-0.37078708,-0.48229264,-0.56881211,-0.64488946,-0.68557154,-0.63973594,-0.62578888,-0.72994948,-0.82461109,-0.92945072,-0.99993511,-1.0491749,-1.0934923,-1.1242096,-1.1497636,-1.1675758,-1.1794617,-1.1927739,-1.2148022,-1.2165397,-1.2084654,-1.1829358,-1.1428881,-1.0924353,-1.0057453,-0.88752795,-0.77549839,-0.67122753,-0.56264219,-0.46666006,-0.36509846,-0.27344942,-0.16618853,-0.071124479,0.021370708,0.10726951,0.19847049,0.30845392,0.38246098,0.45078527,0.4914011,0.44990396,0.42131049,0.38652125,0.35139685,0.33214675,0.37711647,0.43778886,0.4029601,0.37299632,0.34058256,0.30909939,0.29523638,0.29250562,0.28738321,0.28369868,0.28082278,0.2919821,0.29549815,0.31282814,0.33776159,0.37334934,0.41615495,0.49669732,0.59019594,0.68153808,0.79675035,0.87836925,0.94820135,1.0178768,1.0921302,1.1519398,1.214187,1.3056171,1.3230126,1.296271,1.2692755,1.2625753,1.2741134,1.2997958,1.3236845,1.3430859,1.3760295,1.4132713,1.4495885,1.4859414,1.5218858,1.5510342,1.5724961,1.5865743,1.5875686,1.5794391,1.5611523,1.5503901,1.5837551,1.6623513,1.6995009,1.5720898,1.4971774,1.5033938,1.5287212,1.4479718,1.3931912,1.3961131,1.4084724,1.4029096,1.3879375,1.3670907,1.3468406,1.3200123,1.2810684,1.2378678,1.1965337,1.1614095,1.1198002,1.0694241,1.0504444,1.0128443,0.97554911,0.93954673,0.9138835,0.8790405,0.85188156,0.82509066,0.80606546,0.80301421,0.80034346,0.79859116,0.81248548,0.8486244,0.76445703,0.71352906,0.65101989,0.59947194,0.54252275,0.49529176,0.45372938,0.3998952,0.34766265,0.26051823,0.17330951,0.071238317,-0.045266083,-0.1407541,-0.20462505,-0.24966384,-0.27165424,-0.30383993,-0.32244642,-0.33789843,-0.35300356,-0.34978788,-0.35558166,-0.35227998,-0.35645712,-0.35392179,-0.34128769,-0.31311165,-0.27588762,-0.22920688,-0.19366278,-0.16886255,-0.22157423,-0.20843839,-0.17297044,-0.13222052,-0.10113408,-0.063875619:4
1.2746363,1.2359279,1.2302411,1.2263726,1.1707532,1.0818706,0.98718893,0.89884178,0.81137769,0.72267059,0.63545132,0.56854079,0.48459025,0.39253989,0.30340853,0.21762138,0.13490874,0.044917672,-0.041020748,-0.11529583,-0.1966838,-0.27838926,-0.36336783,-0.45110324,-0.53065588,-0.61527665,-0.67033422,-0.76037517,-0.84404777,-0.894539,-0.9288043,-0.83802841,-0.74348345,-0.66214864,-0.59070884,-0.50385827,-0.44913249,-0.41164465,-0.33343873,-0.31568577,-0.28777363,-0.23332556,-0.16799865,-0.11045972,-0.1352178,-0.065424446,0.012760746,0.040130129,0.032241337,0.096004222,0.1417244,0.12252701,0.086657962,0.16461937,0.20407971,0.22051647,0.26823853,0.30549064,0.32345565,0.30211941,0.34794387,0.39953999,0.42513778,0.45763788,0.49250477,0.55503351,0.60170053,0.66722125,0.61806404,0.63163949,0.68164017,0.74798162,0.78996045,0.8063264,0.76275365,0.80765698,0.88829729,0.8881668,0.93539845,1.030076,1.0721786,1.1328462,1.1872519,1.247517,1.2634883,1.181646,1.0999138,0.99381481,0.92367924,0.82924046,0.75295044,0.67732912,0.62686807,0.5584511,0.4649021,0.38182108,0.31543371,0.24511084,0.14359415,0.071450388,-0.012968603,-0.05953605,-0.13129964,-0.25582624,-0.35374576,-0.41648912,-0.49508578,-0.55840129,-0.65339907,-0.73836207,-0.82845816,-0.88919788,-0.9981325,-1.0838927,-1.1466098,-1.2298436,-1.3048758,-1.3414908,-1.4257476,-1.5040071,-1.5640524,-1.631394,-1.6537215,-1.6991068,-1.6748316,-1.6691777,-1.7147731,-1.6736887,-1.6336156,-1.656529,-1.7641223,-1.8721154,-1.9933703,-2.1095343,-2.1662591,-2.0940638,-2.0281799,-2.003459,-1.9361224,-1.8623751,-1.7381709,-1.6286508,-1.5398622,-1.4294862,-1.3465595,-1.2713501,-1.1938702,-1.0912525,-0.99875393,-0.88829612,-0.8076513,-0.73236738,-0.64843605,-0.58479421,-0.53123658,-0.45494122,-0.37353976,-0.28428271,-0.24457809,-0.16773126,-0.087446604,-0.018957361,0.048057336,0.12940794,0.16808706,0.2569415,0.32824753,0.26776297,0.1748823,0.13453377,0.066938243,-0.0057052659,-0.016520496,-0.062021274,-0.061759518,0.032280816,0.11723945,0.18058229,0.20578362,0.29048977,0.34660931,0.41091822,0.38487476,0.46091789,0.54026589,0.63766218,0.69938833,0.79617336,0.76463346,0.79982102,0.89150702,0.97996977,1.0197768,1.084393,1.1795179,1.2721472,1.350897,1.3830097,1.4843163,1.5570322,1.6507958,1.7468352,1.8247363,1.9012292,2.0036074,2.1080913,2.2104362,2.2818238,2.3367143,2.2856264,2.1816102,2.1097266,2.0074315,1.905839,1.8503645,1.7381489,1.6660818,1.5801472,1.5512402,1.4504111,1.3733826,1.4105537,1.3405027,1.2521107,1.1959565,1.0930236,1.1061078,1.0464643,0.96039743,0.87125664,0.79883048,0.71952809,0.73961362,0.7378048,0.64519219,0.57804113,0.52370636,0.43129412,0.44070979,0.46487435,0.36503656,0.27558668,0.22793147,0.1464528,0.022042516,0.036257976,0.10643897,0.1235086,0.16347111,0.24201918,0.29052941,0.32303575,0.30316303,0.26793009,0.17673933,0.12278206,0.073459789,-0.018159163,-0.085334734,-0.12004416,-0.15921827,-0.2463925,-0.3089334,-0.33602508,-0.42218745,-0.45702038,-0.50319457,-0.57107137,-0.65538599,-0.69739281,-0.77472196,-0.84013233,-0.92663261,-1.0158087,-1.1072612,-1.1968296,-1.2828478,-1.3736934,-1.4529578,-1.5407158,-1.6358771,-1.7267763,-1.818401,-1.8988251,-1.9398875,-1.9528527,-2.0436664,-2.1349329,-2.1816388,-2.1026887,-1.9846603,-1.8601548,-1.7698648,-1.6665592,-1.5628187,-1.4549628,-1.3561494,-1.2559465,-1.166957,-1.1289152,-1.2121053,-1.314419,-1.4079245,-1.4754589,-1.5247256,-1.5605584,-1.5832603,-1.5762397,-1.5608884,-1.5235121,-1.463376,-1.4273324,-1.3822994,-1.3248349,-1.2787483,-1.2104835,-1.1531777,-1.0822645,-1.0018147,-0.94157887,-0.86006258,-0.78854908,-0.7048672,-0.63241393,-0.55110162,-0.45459513,-0.41774728,-0.37393825,-0.28891442,-0.23194127,-0.15212496,-0.071686128,-0.0042354247,0.044092387,0.1177468,0.20849438,0.30472211,0.33131359,0.3957812,0.47561887,0.54999285,0.65038875,0.72699716,0.80197365,0.89855003,0.98395236,1.0772963,1.1886174,1.1900869,1.1277248,1.0593074,0.98156719,0.95297622,0.8756206,0.80259456,0.82746565,0.75709003,0.70441022,0.67487355,0.74239086,0.67334527,0.59017981,0.55658949,0.53141966,0.60327678,0.62836709,0.55192225,0.50931525,0.44481124,0.46096264,0.3632393,0.38701453,0.46276476,0.41890802,0.32398792,0.29739469,0.19113971,0.096223277,0.12991854,0.21617671,0.23299187,0.17606693,0.18436347,0.10017624,0.10517982,0.016468226,-0.068290069,-0.14753547,-0.22965511,-0.30690999,-0.38048906,-0.44169521,-0.42712759,-0.49494195,-0.5747544,-0.64045675,-0.64002619,-0.5510528,-0.46736072,-0.43067008,-0.34887892,-0.2648884,-0.17493263,-0.08880189,-0.001607175,0.087997843,0.17243609,0.26327852,0.35059305,0.43937249,0.52828641,0.61184703,0.70181844,0.78980152,0.87874223,0.97039218,1.0581677,1.1405298,1.2229847,1.2597044,1.3198883,1.3571206,1.3166904,1.285118,1.2597105,1.2618324,1.267603:6
0.52796385,0.41681411,0.30651437,0.19794235,0.11087807,0.010135265,-0.098561532,-0.20768506,-0.34504372,-0.48202416,-0.6184038,-0.75653256,-0.89576418,-1.012399,-1.1258246,-1.2574241,-1.3406586,-1.4076246,-1.4448068,-1.462469,-1.4453914,-1.4146189,-1.3802227,-1.3440561,-1.3070895,-1.2567585,-1.2134834,-1.1604088,-1.102458,-1.0408865,-0.97063469,-0.89682874,-0.82456357,-0.75044842,-0.67326418,-0.58194448,-0.49584033,-0.40746033,-0.3203339,-0.22224853,-0.23692121,-0.21433886,-0.23618809,-0.14945397,-0.050378513,0.049463027,0.14488009,0.23874539,0.33391001,0.43608079,0.47506226,0.37508329,0.28085272,0.17604596,0.079121055,-0.019816868,-0.11988347,-0.21628545,-0.24017803,-0.34291679,-0.44623878,-0.54189916,-0.64878581,-0.74273403,-0.8409923,-0.93822032,-1.0338825,-1.1286758,-1.2402529,-1.3277986,-1.4174006,-1.5000668,-1.5593278,-1.6290147,-1.697666,-1.7582421,-1.7642667,-1.727754,-1.6535986,-1.5551859,-1.4512466,-1.3159219,-1.1806481,-1.0753358,-0.94030354,-0.83245016,-0.69679017,-0.56376856,-0.45323806,-0.3444882,-0.20756789,-0.097226392,0.040928635,0.18019844,0.30404784,0.26072229,0.28324791,0.39202633,0.47840493,0.59064812,0.72836005,0.84392785,0.96778141,0.87156957,0.78755148,0.70213679,0.60830367,0.51085685,0.42930034,0.36360595,0.29987244,0.22765653,0.18318136,0.1488331,0.12357997,0.12697839,0.16465792,0.22493049,0.29651345,0.39177824,0.47484678,0.56837331,0.66590765,0.76178746,0.87959424,0.9737445,1.0718965,1.1725732,1.3024418,1.3889776,1.4811563,1.5897851,1.5467256,1.5509889,1.61885,1.7216159,1.8308239,1.9426181,1.8898744,1.8668692,1.7900078,1.6557759,1.5420105,1.4282228,1.3315032,1.2437956,1.2318401,1.2766261,1.3498729,1.433196,1.5130884,1.446164,1.3498692,1.24896,1.136285,1.0700913,1.0358241,0.94083033,0.82914448,0.72874581,0.61737677,0.50659563,0.39110812,0.27537886,0.16870322,0.058345995,-0.044991515,-0.16223168,-0.22733693,-0.22672604,-0.20896933,-0.17282138,-0.12561521,-0.073558902,-0.024111952,0.04318899,0.1444542,0.25457168,0.35391453,0.46004005,0.57431145,0.67324748,0.73652723,0.64325825,0.54436606,0.45110091,0.35202559,0.25838896,0.15618817,0.056227773,-0.034116627,-0.13689718,-0.15660164,-0.10818205,-0.050187902,0.021589808,-0.0081729786,-0.0302867,-0.077888723,-0.18522367,-0.29160489,-0.39358061,-0.49276459,-0.58514611,-0.68063906,-0.78254986,-0.87455077,-0.97508686,-1.066798,-1.1595228,-1.2563705,-1.3521658,-1.4491764,-1.5507218,-1.6362836,-1.7313291,-1.8194056,-1.9023425,-1.9804264,-2.0550167,-2.127311,-2.1792498,-2.2169457,-2.1958625,-2.1488345,-2.0776413,-1.9840946,-1.8725996,-1.7820096,-1.6757382,-1.574269,-1.4575241,-1.3408206,-1.2265358,-1.103826,-0.97163371,-0.84317717,-0.73721497,-0.61111138,-0.5005995,-0.45131639,-0.37956542,-0.26917175,-0.13010271,-0.025717568,-0.11987871,-0.19799817,-0.2751974,-0.34753375,-0.38610623,-0.4465238,-0.50295322,-0.56136859,-0.61495038,-0.68309208,-0.72841523,-0.70764231,-0.61644613,-0.50148917,-0.36615975,-0.44204621,-0.49824356,-0.58269048,-0.64760369,-0.72106327,-0.77969351,-0.83489972,-0.90927753,-0.97561746,-1.0280315,-1.095821,-1.1552798,-1.2055037,-1.2582852,-1.2877655,-1.3260771,-1.3587981,-1.4038866,-1.4467673,-1.4827497,-1.4965795,-1.4842673,-1.4624639,-1.4378828,-1.4175894,-1.37182,-1.307954,-1.2411527,-1.1656251,-1.0901864,-0.99500422,-0.9337381,-0.8779923,-0.80074462,-0.71304822,-0.63315213,-0.5512067,-0.4747874,-0.3947013,-0.30958008,-0.22636268,-0.1443512,-0.059194277,0.021795752,0.097519669,0.17686087,0.18025815,0.1789714,0.12137164,0.11283132,0.14053926,0.14746748,0.1175807,0.1000162,0.10100938,0.108402,0.11567566,0.13159595,0.14814079,0.17137927,0.18956514,0.21440366,0.24559,0.28698419,0.33366047,0.38560075,0.43384117,0.49299379,0.55832922,0.63539247,0.73979435,0.84056739,0.93531953,1.0086609,1.0631186,1.1078483,1.1405618,1.1827952,1.2422715,1.2644104,1.3084013,1.3595714,1.410394,1.4530324,1.504327,1.5429809,1.5779351,1.6122617,1.637574,1.6609718,1.6748882,1.68772,1.6826716,1.6685555,1.6569487,1.6285919,1.6024196,1.5745396,1.5452906,1.5211538,1.5424158,1.6313647,1.6770777,1.5679731,1.4592214,1.3617936,1.2950602,1.4044136,1.5110748,1.4693805,1.3550711,1.2790199,1.2399126,1.2316466,1.244692,1.2735895,1.3050269,1.3151146,1.3281085,1.3199431,1.2917729,1.2448687,1.1937162,1.1642587,1.1362214,1.1053493,1.0840032,1.0709305,1.0463956,1.0261691,1.0167103,1.0152619,1.0152208,1.015109,0.95204887,0.85960237,0.77612062,0.66557048,0.5708586,0.46769798,0.37509299,0.28608263,0.20158013,0.11290178,0.054995272,-8.2573927E-4,-0.040073503,-0.050304418,-0.062800776,-0.067279659,-0.070763535,-0.074341221,-0.065457213,-0.046834256,-0.032564393,-0.019930242,7.8146539E-4,0.027652469,0.059496939,0.093760282,0.1448686,0.20396841,0.23340274,0.28837387,0.35459406,0.42431783,0.50188558:4
2.3169077,2.2396203,2.1597465,2.0707179,1.9772099,1.8904934,1.8062509,1.7211303,1.6356959,1.554158,1.4634697,1.3777754,1.2857044,1.2054266,1.1211971,1.0287823,0.95315708,0.86531626,0.77509303,0.69861282,0.60644414,0.51672133,0.4389915,0.34945437,0.26177927,0.17311745,0.084234408,0.0076545456,-0.075341572,-0.14597566,-0.13471241,-0.11658949,-0.090615942,-0.071807233,-0.061137961,-0.053840736,-0.057026611,-0.092296457,-0.12096634,-0.17623608,-0.221283,-0.27603246,-0.32997139,-0.34974581,-0.37143556,-0.38469171,-0.37982623,-0.37402419,-0.36914696,-0.37175295,-0.37177098,-0.37731065,-0.38589893,-0.3992259,-0.40907519,-0.41854055,-0.41258396,-0.3948499,-0.3743202,-0.39061628,-0.44017899,-0.49258398,-0.53731848,-0.5955807,-0.66635517,-0.72456672,-0.79423287,-0.86418778,-0.92270677,-0.99450426,-1.0678591,-1.1881447,-1.2501454,-1.3012831,-1.3264467,-1.3409035,-1.3342938,-1.3182546,-1.2861081,-1.2655089,-1.2281141,-1.2005187,-1.1731827,-1.1417252,-1.107452,-1.0749692,-1.0221461,-0.95626737,-0.87801205,-0.79486712,-0.69716416,-0.63555862,-0.54461026,-0.44142966,-0.34553436,-0.37980242,-0.47562923,-0.56591705,-0.65802102,-0.75443501,-0.85148032,-0.92883661,-1.0192512,-1.1019597,-1.1937421,-1.2734762,-1.3669119,-1.4243652,-1.4297617,-1.4102228,-1.3973562,-1.3595295,-1.3090271,-1.2634639,-1.2008791,-1.1405515,-1.0645887,-0.98179707,-0.89040654,-0.79568177,-0.70301339,-0.61056014,-0.51812129,-0.54167199,-0.46326723,-0.37656191,-0.28883879,-0.20103458,-0.10809193,-0.02184532,0.055330783,0.013246384,-0.080010946,-0.20132147,-0.32246106,-0.41608968,-0.50904087,-0.58600375,-0.66867819,-0.74867746,-0.80595389,-0.86834944,-0.92256738,-0.95856028,-0.9557129,-0.89656747,-0.83705826,-0.75833816,-0.68437017,-0.59651743,-0.51479504,-0.43921011,-0.35595824,-0.269223,-0.18795377,-0.10750207,-0.031666496,0.041092184,0.12397265,0.21761452,0.29635862,0.3848971,0.46907603,0.55379296,0.6429324,0.72586657,0.80631287,0.88464716,0.96509258,1.0550801,1.0768695,1.0848533,0.99853102,0.90199429,0.80948351,0.72826438,0.67937867,0.67047187,0.73766058,0.82139715,0.89097512,0.98352976,1.0673433,1.1445239,1.2377825,1.3141293,1.4092563,1.4928662,1.5677256,1.6392259,1.635944,1.7186585,1.8051056,1.8863951,1.967251,2.0146737,1.9403391,1.8446664,1.759309,1.6834864,1.6156471,1.5926681,1.5000675,1.4190753,1.333959,1.243532,1.1612003,1.0766205,0.98902733,0.89662864,0.81869411,0.72623335,0.64809033,0.55655521,0.47603216,0.3886931,0.30293627,0.2199569,0.14659766,0.16967556,0.2535522,0.35380664,0.45485329,0.54374338,0.63257431,0.70687156,0.79070733,0.71714195,0.63711837,0.55113687,0.46535549,0.37641159,0.35181403,0.26919706,0.17563906,0.087704721,0.0023756746,-0.083822591,-0.17086008,-0.25532752,-0.34619996,-0.43342244,-0.50737189,-0.58831429,-0.6779172,-0.75698573,-0.8331056,-0.91552408,-0.98498041,-1.0639146,-1.1381417,-1.2053776,-1.2592988,-1.3081406,-1.3336099,-1.3366759,-1.3192878,-1.2855866,-1.2319925,-1.1637245,-1.1028164,-1.0260248,-0.96016971,-0.87119688,-0.78169845,-0.69214758,-0.60238203,-0.51233761,-0.40353498,-0.30057848,-0.17932473,-0.0573401,0.04003804,0.12060915,0.23913153,0.32606135,0.41317126,0.43635059,0.3705402,0.28689044,0.21391695,0.13446868,0.066918974,-0.022357006,-0.10878855,-0.21270819,-0.28968876,-0.34763434,-0.38382179,-0.30158187,-0.20743256,-0.23700522,-0.32047362,-0.40027152,-0.50338642,-0.58186779,-0.6818293,-0.76518282,-0.83958261,-0.91570355,-1.0032945,-1.0795729,-1.1501969,-1.2501085,-1.3125257,-1.3753351,-1.4617233,-1.517564,-1.5701503,-1.6064006,-1.6454336,-1.6771113,-1.6867818,-1.6792844,-1.653062,-1.6113524,-1.5572514,-1.4800825,-1.373172,-1.2889714,-1.2017406,-1.1240044,-1.0303914,-0.94891585,-0.87014169,-0.78869765,-0.70120412,-0.6313154,-0.54257482,-0.47659729,-0.39862814,-0.32156213,-0.24446258,-0.17640506,-0.10403888,-0.099286197,-0.18045912,-0.24911244,-0.31446027,-0.36801183,-0.42377741,-0.47602211,-0.52751056,-0.57506065,-0.61081026,-0.64674109,-0.67798134,-0.69966925,-0.71710357,-0.74307241,-0.75734351,-0.75883552,-0.75159349,-0.73840397,-0.70971761,-0.67648322,-0.63832133,-0.58329702,-0.53786368,-0.48624125,-0.45363079,-0.38954015,-0.33973583,-0.2882755,-0.25626918,-0.23764082,-0.21491689,-0.20436809,-0.19287843,-0.17856887,-0.17326181,-0.17381913,-0.15470209,-0.10013092,-0.18107379,-0.18939824,-0.10877648,-0.017620796,0.068347131,0.15731119,0.24078152,0.32434409,0.40567316,0.49636506,0.5828243,0.67119188,0.75837497,0.84177992,0.92516745,1.0064194,1.0992101,1.1880176,1.2832331,1.3588586,1.4517894,1.5339833,1.627311,1.7134299,1.7884849,1.8879854,1.9743638,2.0499787,2.1527204,2.1840701,2.0948789,2.0032439,1.9223266,1.8295191,1.7533731,1.6594182,1.567906,1.4964649,1.3956116,1.3111941,1.2521784,1.3348064,1.4249918,1.5113418,1.6033681,1.6815277,1.7753608,1.8538147,1.9462725,2.033123,2.1124014,2.1948859,2.292061:4
1.6582712,1.5474265,1.4422475,1.407004,1.3133744,1.2259851,1.1055257,0.97534932,0.82529636,0.780132,0.70303983,0.63721505,0.63556465,0.6774729,0.6583701,0.61343219,0.62998409,0.56220992,0.42298722,0.44431831,0.3516466,0.22299422,0.18572413,0.093256771,0.24434391,0.084606222,-0.096398442,-0.1046131,-0.21865408,-0.3424817,-0.45684737,-0.56392443,-0.69328429,-0.71481229,-0.8041864,-0.79954968,-0.88237642,-0.99544761,-0.88576185,-0.83030633,-0.78230275,-0.72155472,-0.69724701,-0.60676944,-0.52711302,-0.42823447,-0.31396604,-0.20448941,-0.13014467,-0.10344822,-0.02124625,0.010974843,0.063551301,0.13009016,0.22779378,0.18007367,0.28471868,0.30800714,0.43346124,0.50785929,0.60775636,0.64536964,0.76572543,0.89554517,0.9129092,1.0094254,1.034766,1.0584718,1.1260859,1.1910888,1.3153034,1.3394543,1.3246403,1.2866954,1.1788408,1.0698052,1.031522,0.92462118,0.87799187,0.77438647,0.74544688,0.69689146,0.60777433,0.59420106,0.55775425,0.50543392,0.44382487,0.36900805,0.38000012,0.46141733,0.44979734,0.47168236,0.54368724,0.48796139,0.54114544,0.44586933,0.36816495,0.31684946,0.23332738,0.13467673,0.06493998,-0.058673523,-0.16578392,-0.24555986,-0.31571671,-0.39107456,-0.319412,-0.45571969,-0.43872185,-0.56680415,-0.65103451,-0.65014799,-0.60152919,-0.44184106,-0.41722487,-0.27990331,-0.34544975,-0.17846396,-0.17152012,-0.18153355,-0.14802065,-0.087908513,-0.061743228,0.056906696,0.075208351,0.017216565,0.11108259,0.076530088,0.024447722,-0.050711537,-0.011329988,-0.049999348,-0.12863872,-0.087760374,-0.037916523,-0.12135677,-0.19291332,-0.21462333,-0.28717056,-0.2514305,-0.30162251,-0.36776296,-0.30478266,-0.20422997,-0.3009085,-0.30075455,-0.4011959,-0.49040304,-0.5800152,-0.53581832,-0.68747352,-0.74705586,-0.78087347,-0.94323173,-0.90229463,-1.0667261,-1.1842201,-1.2977312,-1.4131466,-1.4408632,-1.410065,-1.3143189,-1.3689981,-1.3389713,-1.1715215,-1.1642545,-1.1364982,-0.9831773,-0.89803115,-0.96884888,-0.8660056,-0.97655734,-0.99481098,-1.0078546,-0.90324491,-0.92143574,-0.77757272,-0.63910004,-0.58265273,-0.55770244,-0.62209132,-0.66309796,-0.5656406,-0.72026052,-0.55354056,-0.40664544,-0.34127021,-0.40921309,-0.26345142,-0.059890566,0.13268172,0.3242146,0.5177966,0.69334266,0.88859815,1.0647849,1.2402543,1.4129743,1.6044589,1.7931651,1.9131195,2.0853043,2.2715419,2.4499832,2.6634353,2.7971803,2.9501735,3.1278007,3.2990684,3.4360419,3.4593396,3.4111489,3.21815,3.0433092,2.8488449,2.6545014,2.4825327,2.2889785,2.116793,1.9494293,1.776124,1.5770226,1.3828214,1.1885757,0.99428314,0.82065043,0.64764117,0.45613398,0.25933282,0.065208893,-0.12803137,-0.2812134,-0.47514842,-0.66892607,-0.85796493,-0.87576094,-1.0828903,-1.2553568,-1.3452005,-1.5593277,-1.7255497,-1.7934401,-1.7880115,-1.5946103,-1.651239,-1.4842949,-1.490774,-1.4621827,-1.5052345,-1.459318,-1.4037153,-1.2970196,-1.1861596,-1.0280919,-1.0007275,-1.1189526,-1.0702849,-1.1444014,-1.0706664,-1.0118427,-0.94080271,-0.91877695,-0.83177975,-0.85084826,-0.79152718,-0.73354516,-0.76079238,-0.71722767,-0.69612515,-0.68169214,-0.75087028,-0.74063383,-0.69973363,-0.6421623,-0.52709993,-0.41590845,-0.38222013,-0.28645981,-0.19705635,-0.10484849,-0.10002348,-0.038038885,-0.068473258,-0.051542784,-0.090146656,-0.21352878,-0.27668207,-0.3690265,-0.48725477,-0.5621274,-0.64903461,-0.72590812,-0.80395192,-0.8470571,-0.93021389,-1.1001359,-0.99492595,-0.90396304,-0.86243456,-0.81888213,-0.89444377,-0.9846344,-1.0445999,-0.9812826,-1.0088433,-1.1146992,-1.2083665,-1.2142434,-1.2842864,-1.3476724,-1.3606701,-1.4602282,-1.5013045,-1.5450875,-1.5513739,-1.4590333,-1.5842476,-1.5191455,-1.4154648,-1.2392548,-1.1505815,-1.1086115,-0.99936223,-0.85062754,-0.84015103,-0.79943807,-0.67007815,-0.61246846,-0.49197265,-0.53765372,-0.43850386,-0.40726896,-0.30719134,-0.27425378,-0.17082183,-0.10517629,-0.088945961,0.057117048,0.18314966,0.30185275,0.36749983,0.23462161,0.10012349,0.042738539,-0.021280483,-0.059666941,-0.032002158,0.049859792,0.1672871,0.26705295,0.40147379,0.52573455,0.57332241,0.66356023,0.78317384,0.87562414,0.90203647,0.94246646,0.84155917,0.70464062,0.71365594,0.63335388,0.59217738,0.57854284,0.50174992,0.50338258,0.47964302,0.37069306,0.33791882,0.19181093,0.019302399,-0.088155424,-0.12943626,-0.14235698,-0.22192259,-0.22669735,-0.26680622,-0.34473074,-0.43947254,-0.53622352,-0.61012915,-0.71826448,-0.83450953,-0.86614121,-0.82720622,-0.84942621,-0.79495385,-0.68052955,-0.60646855,-0.54861481,-0.4636596,-0.34032784,-0.25687357,-0.13806705,0.020111175,0.13031903,0.27052802,0.43527735,0.58965292,0.63180734,0.70013068,0.60441055,0.51903874,0.4998238,0.5290425,0.62244473,0.70087238,0.67910932,0.67139862,0.54716777,0.44753066,0.37330526,0.42698235,0.47753458,0.66391581,0.85389189,1.016014,1.0925348,1.1341325,1.2353943,1.3788226,1.5127671,1.6546393,1.7959168,1.7689445,1.7284904,1.6945654:5
2.7428293,2.6916889,2.5522394,2.4032832,2.2520572,2.1463327,1.9947674,1.8907616,1.740403,1.6347695,1.4833903,1.4167084,1.3079339,1.1702176,1.0205731,0.91510806,0.82058986,0.71014714,0.56052672,0.41274728,0.26499148,0.11763837,-0.029366334,-0.17559476,-0.32137249,-0.46651692,-0.58155806,-0.71313815,-0.85463089,-0.95094897,-1.0344925,-0.99620178,-0.99086193,-0.97514001,-0.92035267,-0.85212303,-0.77617397,-0.70884686,-0.68212279,-0.61108924,-0.54248101,-0.47872589,-0.45095173,-0.42510224,-0.40651902,-0.3375705,-0.27920352,-0.33564012,-0.35133858,-0.34338136,-0.24386323,-0.14754303,-0.13626158,-0.12884159,-0.062180432,-0.022641636,0.035052865,0.043727477,-0.010092881,-0.11064373,-0.12902926,-0.083284065,-0.038190224,0.015677619,0.053094707,0.04117821,1.557478E-4,-0.014473239,-0.0046138501,-0.001421469,0.021476455,0.010207238,-0.03994646,-0.15589918,-0.26196473,-0.37285165,-0.49587931,-0.5764349,-0.71564216,-0.79892447,-0.86314714,-0.85851115,-0.84542591,-0.82019248,-0.78449244,-0.74678456,-0.71342828,-0.66111343,-0.58218386,-0.52600107,-0.50582612,-0.52511461,-0.49322513,-0.46271899,-0.40801292,-0.36482271,-0.33379884,-0.38124934,-0.34234186,-0.28914734,-0.24910901,-0.24824333,-0.35741171,-0.45880926,-0.55012498,-0.54767783,-0.48490359,-0.42005727,-0.36125744,-0.30760197,-0.24841035,-0.19832654,-0.15765817,-0.097249401,-0.04753363,-0.055796217,-0.045374702,0.027066109,0.098455119,0.20329964,0.27021276,0.3614868,0.45676418,0.54952389,0.62716681,0.70793459,0.73115737,0.67747948,0.57274059,0.45784803,0.35497384,0.24872294,0.13281182,0.031137266,-0.075353324,-0.19004075,-0.28708355,-0.39942649,-0.50198014,-0.60707799,-0.61136264,-0.69651599,-0.8180993,-0.91771242,-1.0239471,-1.1394585,-1.2472891,-1.3437177,-1.4576659,-1.5633228,-1.6402915,-1.6879126,-1.7482815,-1.8228051,-1.8965564,-1.9399767,-1.8909808,-1.8311549,-1.7914017,-1.715825,-1.6792797,-1.5887107,-1.5160716,-1.4590429,-1.3864895,-1.3068671,-1.2117088,-1.1140816,-1.04817,-1.0785318,-1.1614272,-1.2457808,-1.1725598,-1.0589372,-0.96432214,-0.83427096,-0.74725358,-0.64381892,-0.55365205,-0.46093299,-0.53106407,-0.44510993,-0.31575006,-0.23197105,-0.12083215,0.02317614,0.12293555,0.22587697,0.24720427,0.2045446,0.18894953,0.23505148,0.26880827,0.36724611,0.49414861,0.49141686,0.56892861,0.6617107,0.7227664,0.82709072,0.97712047,1.0809102,1.230628,1.317954,1.3222541,1.2881403,1.3830946,1.4917467,1.5978516,1.704256,1.8106593,1.918423,1.9961034,2.0946801,2.2005037,2.2989808,2.3847464,2.4678024,2.5581751,2.5696193,2.6263636,2.5806919,2.469144,2.3585385,2.2141961,2.0686872,1.9258727,1.8632974,1.7848773,1.7239547,1.6045511,1.5053171,1.4037681,1.3320768,1.2759539,1.267036,1.1993971,1.1292495,1.0203994,0.91109739,0.85883787,0.75436087,0.67165149,0.58935553,0.48000391,0.49287291,0.57888232,0.65281712,0.74814356,0.79274109,0.80001283,0.75212723,0.65608526,0.58110625,0.46443579,0.40841413,0.33039866,0.24750951,0.19750936,0.12333802,0.01714937,-0.10380863,-0.22848902,-0.327827,-0.44025541,-0.55314677,-0.64854402,-0.64828964,-0.60121999,-0.65311792,-0.75759449,-0.84943706,-0.93777107,-1.0547315,-1.1354242,-1.2292281,-1.3138031,-1.3937901,-1.4737316,-1.4707673,-1.3595563,-1.2570299,-1.145623,-1.0451402,-0.90842031,-0.77127192,-0.704801,-0.6607907,-0.55233251,-0.40324922,-0.2963021,-0.1637513,-0.043995628,0.057316385,0.16793084,0.28767878,0.40074014,0.48076844,0.5017449,0.46132532,0.40638021,0.33151528,0.24670649,0.18334025,0.20278595,0.14209627,0.079133066,0.022112958,-0.042575861,-0.10518086,-0.066023698,-0.073517887,-0.13479064,-0.18451752,-0.22627936,-0.27808674,-0.3174113,-0.34957002,-0.34409765,-0.24433387,-0.1670263,-0.099993027,-0.14422232,-0.16139939,-0.20698644,-0.25976208,-0.30882214,-0.27971519,-0.32511945,-0.41354914,-0.48456594,-0.56472034,-0.63831089,-0.55534558,-0.58793619,-0.63756752,-0.690655,-0.75211289,-0.81345594,-0.847863,-0.88379013,-0.9212027,-0.94233756,-0.94463577,-0.83766349,-0.72940239,-0.63002674,-0.50283584,-0.40909224,-0.29813215,-0.27242735,-0.28730967,-0.28262577,-0.28099567,-0.23503242,-0.199666,-0.21380589,-0.23244281,-0.19133674,-0.079957796,-0.058106093,-0.099200319,-0.1187449,-0.16127753,-0.15385506,-0.19535581,-0.24086911,-0.2817091,-0.3162089,-0.30323595,-0.20893241,-0.19314718,-0.21920957,-0.24241967,-0.31322098,-0.36751172,-0.43605397,-0.49972199,-0.52920132,-0.56436377,-0.60298304,-0.67633722,-0.70773247,-0.73908186,-0.79252502,-0.8367658,-0.86546569,-0.9174237,-0.85502107,-0.90005094,-0.9296651,-0.97081517,-1.0182047,-0.99455506,-1.0604593,-1.0490135,-1.1205267,-0.98997334,-0.88137371,-0.73287275,-0.6305963,-0.48332429,-0.33490922,-0.18655981,-0.03772146,0.11120962,0.26017483,0.40894851,0.55857099,0.64539986,0.7461166,0.86865345,1.0179011,1.1670526,1.3168166,1.4213212,1.5706777,1.7203953,1.8395461,1.9745777,2.1242088,2.2490116,2.378783,2.5279443,2.6734559,2.7346901,2.7649907:3
-0.039992276,-0.12796498,-0.21042168,-0.30433584,-0.36242432,-0.37519889,-0.43239194,-0.49897422,-0.55940872,-0.38511999,-0.27093225,-0.29754039,-0.28178929,-0.28671514,-0.3756753,-0.37222061,-0.39249295,-0.44848598,-0.52834585,-0.59911477,-0.66755821,-0.74776131,-0.82063194,-0.92063969,-0.86866165,-0.74761226,-0.58940012,-0.4578526,-0.3174418,-0.39429832,-0.47114172,-0.48236623,-0.55892966,-0.63775762,-0.68152002,-0.76475807,-0.82242299,-0.85613203,-0.99930376,-0.98492097,-0.81983414,-0.83132612,-0.99417141,-1.0488073,-1.1619541,-1.2616698,-1.4137565,-1.5722171,-1.7206621,-1.586854,-1.4587058,-1.2925437,-1.1399602,-0.99094842,-0.8423172,-0.67519057,-0.52794564,-0.39433692,-0.23965041,-0.080260271,0.072004873,0.22148272,0.3618472,0.51491356,0.67507617,0.82990737,0.98651051,1.1340022,1.2823471,1.4220559,1.6006396,1.7350637,1.8989602,2.0477379,2.2017794,2.3417457,2.5134043,2.6477035,2.8186273,2.9568996,3.1362397,3.2473109,3.1917108,3.043294,2.9305982,2.7398044,2.6106137,2.426662,2.2671489,2.1308841,1.9680324,1.7906532,1.655077,1.5159108,1.3468418,1.2064478,1.0451635,0.89976077,0.732722,0.58482508,0.42345006,0.28463029,0.12294923,-0.011542587,-0.17271142,-0.32410459,-0.4987226,-0.48489896,-0.61630522,-0.75958691,-0.84576701,-1.0005759,-1.1503573,-1.3006834,-1.4578858,-1.5507943,-1.6771224,-1.8464092,-1.9153683,-1.7489414,-1.8574255,-1.9163062,-1.7557866,-1.6338968,-1.533852,-1.4423898,-1.4389396,-1.4574369,-1.4751828,-1.3590774,-1.3104507,-1.2965673,-1.2000041,-1.1306958,-1.114486,-1.118525,-1.0510479,-0.98068858,-0.90018269,-0.83333276,-0.77212102,-0.72552391,-0.67999279,-0.65277781,-0.58581608,-0.52430786,-0.49921402,-0.47950455,-0.56764099,-0.60187849,-0.52068542,-0.45388133,-0.41757381,-0.39760083,-0.34157725,-0.36384258,-0.51372652,-0.6798575,-0.76806134,-0.85980094,-0.90559972,-0.82020306,-0.72014821,-0.67744747,-0.61823132,-0.53951683,-0.49731889,-0.50833325,-0.396159,-0.31878892,-0.23029275,-0.18085199,-0.14368694,-0.10716113,-0.014128224,0.067883901,0.20423621,0.16071004,0.24080636,0.36298936,0.42865843,0.40706525,0.47613918,0.5966027,0.61268054,0.76738046,0.81158596,0.79088117,0.7883645,0.93356458,0.89527427,1.0571405,1.1078032,1.2480889,1.3803329,1.4883817,1.6166212,1.6990191,1.5738119,1.4118716,1.247799,1.0996752,0.95211452,0.81242711,0.63062902,0.62268465,0.46571907,0.31904003,0.15054564,0.063712972,-0.07331464,-0.23972466,-0.36661504,-0.55434457,-0.66974631,-0.8163096,-1.0153158,-1.1465121,-1.3176656,-1.5155389,-1.3533286,-1.2444484,-1.0987645,-1.0504246,-0.95573827,-0.92553208,-0.83192004,-0.88141416,-0.80053698,-0.71690313,-0.59646004,-0.50938752,-0.40085106,-0.31230355,-0.18575759,-0.08570748,-0.019538654,0.13584993,0.20374956,0.27522929,0.22015731,0.20277202,0.33112272,0.43298712,0.53475576,0.65944456,0.6543151,0.80127454,0.94587974,1.068579,1.1931926,1.2896147,1.193481,1.0252551,0.93165219,0.79650365,0.61023616,0.55205876,0.38062476,0.17907683,0.044155416,-0.10316693,-0.28568128,-0.19103254,-0.29555611,-0.45327649,-0.64507671,-0.84006595,-0.84691437,-0.92983823,-1.1111127,-1.2846866,-1.460411,-1.5684323,-1.4303651,-1.3074047,-1.157595,-1.0753926,-0.95390215,-0.81744954,-0.679829,-0.59299009,-0.61623873,-0.47670122,-0.32829744,-0.18290131,-0.04377325,0.12602166,0.27133758,0.31963344,0.26921423,0.40399125,0.54718221,0.62442886,0.73111966,0.87618446,1.0388744,1.1933797,1.2895711,1.2123868,1.0696111,0.9408529,0.7970497,0.74608535,0.60337656,0.47819634,0.42832927,0.481244,0.33275387,0.22168931,0.11667412,-0.014215156,-0.14446281,-0.26346869,-0.16808839,-0.24146336,-0.35012008,-0.45132786,-0.5590024,-0.69914488,-0.72703137,-0.83560653,-0.9484463,-1.0327067,-0.83458188,-0.62444668,-0.47823694,-0.27004096,-0.13665674,0.015769612,0.16366877,0.32766818,0.47311282,0.46861625,0.64112603,0.79780385,0.96554554,1.1086366,1.199211,1.4048391,1.5997462,1.7311004,1.9243055,1.9679743,1.835703,1.7341923,1.5934881,1.4974027,1.3525206,1.3631109,1.2614085,1.1086607,1.0052968,0.86307612,0.79159644,0.91423013,0.86159849,0.76922506,0.63033534,0.55120468,0.42409493,0.32434421,0.24340347,0.23657406,0.41311949,0.38964892,0.28103198,0.20003351,0.085469398,-0.053514687,-0.026332498,-0.071664587,-0.17324286,-0.26820386,-0.35982567,-0.39765162,-0.26094659,-0.11819059,0.0039672338,0.11628179,0.19140454,0.34865997,0.50227702,0.64679776,0.80729438,0.72265869,0.6173044,0.51175247,0.36068695,0.26389458,0.2302706,0.13846755,0.038937161,-0.058047119,-0.046886915,0.020096548,-0.019172695,-0.080825367,-0.18696467,-0.22108547,-0.27185663,-0.37945568,-0.45397966,-0.44785995,-0.3448966,-0.38948699,-0.46923922,-0.56295309,-0.63360471,-0.61364219,-0.65792674,-0.75741896,-0.80993092,-0.87582704,-0.98672446,-1.0606509,-1.0945636,-1.1066475,-0.9020157,-0.73941874,-0.64275941,-0.67478862,-0.53526597,-0.39399155,-0.22419508,-0.086085253,-0.033425868:1
1.7964799,1.7729028,1.75451,1.7136734,1.6738568,1.6351316,1.5817765,1.5446411,1.4954888,1.4709218,1.4168741,1.3741647,1.3153088,1.2556359,1.1946016,1.1091945,1.0257692,0.93332966,0.85839992,0.76491553,0.66544527,0.5471903,0.45695909,0.35334985,0.2366064,0.12153015,0.043433627,-0.07199163,-0.14380144,-0.19695649,-0.18355082,-0.16259958,-0.11035253,-0.051195189,0.010503454,0.054494269,0.11430867,0.16400524,0.21951817,0.28686427,0.36028096,0.40117951,0.47457765,0.52538991,0.56907884,0.60402146,0.65623723,0.67159345,0.69275109,0.6920544,0.71659905,0.72822985,0.74402934,0.75118861,0.75013055,0.74050526,0.72082569,0.69828226,0.68417371,0.64767746,0.59909928,0.56708029,0.51220817,0.45192035,0.37256607,0.28985282,0.21993188,0.12725032,0.063149638,-0.022351758,-0.10293407,-0.18128214,-0.24941792,-0.32765526,-0.40527219,-0.4774897,-0.56200912,-0.63825214,-0.71559396,-0.80229136,-0.87280109,-0.94944506,-1.0271765,-1.1093272,-1.1869422,-1.2604454,-1.3546331,-1.4223478,-1.5055193,-1.5828199,-1.6616361,-1.7340121,-1.810709,-1.8766536,-1.9117428,-1.9211942,-1.8856099,-1.8324223,-1.7326673,-1.6548703,-1.5422663,-1.4259478,-1.3504254,-1.2335703,-1.151885,-1.0515238,-0.97710089,-0.89062982,-0.81306942,-0.73763591,-0.66347047,-0.61044341,-0.54141808,-0.46409728,-0.38642879,-0.32622382,-0.26762696,-0.21049763,-0.14554458,-0.094483453,-0.03611435,0.01597992,0.061680531,0.097525241,0.12161184,0.12357562,0.12472443,0.12142325,0.11442514,0.123334,0.10862232,0.10361498,0.092464463,0.064068949,0.050582554,0.019924291,-0.011155552,-0.036408627,-0.047126203,-0.089009802,-0.062505622,-0.10377624,-0.1287734,-0.21057603,-0.24980613,-0.29795136,-0.3342025,-0.3770907,-0.42133205,-0.48808871,-0.54100351,-0.61686228,-0.70092703,-0.75476832,-0.81897847,-0.76597268,-0.6780717,-0.5929751,-0.50916792,-0.41944814,-0.33425237,-0.25159457,-0.14692316,-0.062844536,0.0072108961,0.032890754,0.0483518,0.073164268,0.070132331,0.063612121,0.058305634,0.051336516,0.011206425,-0.021292189,-0.056413679,-0.080100634,-0.12914108,-0.17552889,-0.2491554,-0.26080378,-0.3216598,-0.37426442,-0.43860719,-0.49975916,-0.55729651,-0.60063737,-0.64704883,-0.61125036,-0.53666434,-0.4218141,-0.3469072,-0.22986965,-0.11177612,0.0078574414,0.12663201,0.24568672,0.36455702,0.4840523,0.57096985,0.6829968,0.76012605,0.83972719,0.95946671,1.0798995,1.1995338,1.2983183,1.3972176,1.443058,1.5257297,1.6293287,1.7489774,1.8619259,1.9499506,2.0682815,2.142655,2.2063099,2.2458064,2.2652221,2.2983793,2.2859543,2.2377621,2.1579951,2.0771508,1.9648069,1.8947497,1.8017005,1.712327,1.6043677,1.4848888,1.3654962,1.2874713,1.1677372,1.0737967,0.96941629,0.84915755,0.72908626,0.6319124,0.53015268,0.42207189,0.33140266,0.25184926,0.16339348,0.05486757,-0.023115035,-0.10187812,-0.17890196,-0.26358886,-0.3299583,-0.40581587,-0.48905984,-0.59370286,-0.64216696,-0.64887472,-0.66269728,-0.68644464,-0.7086032,-0.68697189,-0.64131337,-0.57301835,-0.63341375,-0.61860978,-0.5784079,-0.55864099,-0.58132302,-0.56496092,-0.5639085,-0.56187058,-0.55929468,-0.55378115,-0.54815113,-0.53146977,-0.51517222,-0.48164166,-0.46950782,-0.46934048,-0.47227566,-0.47150309,-0.48423783,-0.49262244,-0.50511402,-0.52514733,-0.54592183,-0.57384452,-0.60376172,-0.66636314,-0.75722501,-0.82104246,-0.8965071,-0.97867852,-1.055435,-1.1554882,-1.2186866,-1.3091088,-1.388623,-1.4728308,-1.557928,-1.653927,-1.7352109,-1.8230335,-1.8812889,-1.9801309,-2.0642937,-2.145773,-2.1945914,-2.178617,-2.0806546,-1.9704262,-1.8615099,-1.786244,-1.7740219,-1.7006299,-1.6384499,-1.5373792,-1.4958722,-1.4091166,-1.3075428,-1.2406731,-1.1440556,-1.0936575,-1.0137692,-0.9346583,-0.87922796,-0.82358716,-0.77408756,-0.70704773,-0.65082338,-0.60181114,-0.53726382,-0.48820982,-0.43302803,-0.37771321,-0.33550633,-0.28951461,-0.2497727,-0.19631217,-0.14933476,-0.11105801,-0.068954786,-0.028500206,-0.0014660277,0.029365277,0.044080771,0.054427737,0.068541588,0.068163285,0.051933976,0.025131943,-0.0083599047,-0.052371999,-0.086282098,-0.13538368,-0.1890149,-0.24483617,-0.3071356,-0.39700417,-0.45068309,-0.52135732,-0.60535682,-0.65505992,-0.75490685,-0.8535713,-0.91150734,-1.0007828,-1.0547205,-1.1095552,-1.1044564,-1.0456615,-0.96647698,-0.8670284,-0.79676649,-0.70983898,-0.62529308,-0.54043388,-0.45172279,-0.36825918,-0.28249395,-0.205296,-0.11613097,-0.043460022,0.047080511,0.12858194,0.20896359,0.30151183,0.39283514,0.46334157,0.55875974,0.64861785,0.73536895,0.82154182,0.8714003,0.95237535,1.0303784,1.0827701,1.123954,1.1552789,1.1584789,1.1608493,1.1541577,1.1516807,1.1437325,1.1353878,1.0949624,1.084435,1.0776721,1.0870683,1.130944,1.190087,1.2524078,1.3087721,1.3700283,1.4280579,1.4885496,1.5534362,1.5993113,1.637955,1.6610343,1.6910122,1.7216501,1.7522144,1.7803112,1.7821201,1.781982,1.7904241,1.8155708,1.8285466,1.8350351,1.8099866:2
3.6170548,3.6258977,3.5375565,3.3542192,3.1036395,2.8828603,2.6957106,2.4702985,2.2674729,2.1125633,1.8994716,1.6888105,1.490701,1.2743122,1.0727901,0.88399405,0.65581373,0.45222069,0.23431699,0.050382651,-0.17482076,-0.3421386,-0.49940573,-0.68688383,-0.91663411,-1.1275726,-1.3239043,-1.5115655,-1.6014714,-1.5637197,-1.4083738,-1.3547544,-1.1906446,-1.095562,-1.0364042,-0.90034513,-0.76941005,-0.92891622,-0.91679156,-0.79214076,-0.69578361,-0.59990033,-0.53927416,-0.46309028,-0.41913232,-0.3281342,-0.21251042,-0.22165842,-0.16201738,-0.10326345,-0.12116356,-0.012834595,-0.1299117,-0.31621849,-0.43338494,-0.55043785,-0.61484911,-0.70258791,-0.60304373,-0.53402764,-0.40717682,-0.34645275,-0.29418921,-0.13810474,-0.10331732,-0.056325936,-0.013527584,0.015606299,0.070166364,0.1452945,0.22104201,0.27237532,0.31852889,0.41640241,0.50134454,0.55012939,0.59258075,0.62971592,0.60320228,0.51199473,0.43313906,0.27666299,0.21640265,-0.034639766,-0.12921994,-0.046562616,-0.21054688,-0.32181174,-0.23656627,-0.15399047,-0.081355894,-0.17128561,-0.077082325,0.018830373,0.12735933,0.22017936,0.32204066,0.44006913,0.47443776,0.54900662,0.58601918,0.65001596,0.70635643,0.85937415,0.99513745,1.0775377,1.1792849,1.2422437,1.3231586,1.3290098,1.3424471,1.2956239,1.332041,1.264963,1.0681495,0.86193698,0.88084849,0.71896156,0.64589564,0.52298455,0.34346291,0.12464604,0.013850024,-0.10379905,-0.15508444,-0.27552049,-0.31297957,-0.34857032,-0.15922068,-0.15906264,-0.11441764,0.037051448,0.15191364,0.39085076,0.45520436,0.60494047,0.66755746,0.60617131,0.73237847,0.8099847,0.9602667,1.1153624,1.0423122,1.1735835,1.2713341,1.3334652,1.4462817,1.4970729,1.5258622,1.3699379,1.2405342,1.1600707,1.0348877,0.88484653,0.79211542,0.74795008,0.68268117,0.60341944,0.42951809,0.34083381,0.19785799,0.10804133,-0.063931408,-0.28779653,-0.31434564,-0.4008828,-0.36249461,-0.38074483,-0.51579987,-0.69827065,-0.62613423,-0.58613742,-0.81367877,-0.7332549,-0.8723001,-1.1423105,-1.3232403,-1.3956793,-1.248348,-1.1817744,-1.0001294,-0.98877335,-0.90985241,-0.86871725,-0.79495102,-0.62067038,-0.61344057,-0.68056076,-0.62054476,-0.51696364,-0.46853873,-0.38320105,-0.41199784,-0.35757756,-0.2918682,-0.43660499,-0.37024888,-0.22857846,-0.10187973,-0.20318621,-0.16787919,-0.060620151,-0.14664116,0.011489207,0.031105268,0.025508078,0.15055119,-8.5933721E-5,-0.16554488,-0.28289342,-0.29035969,-0.51138116,-0.59769583,-0.68193651,-0.80390505,-1.0268182,-1.2211005,-1.2981906,-1.4852146,-1.6604269,-1.9015361,-2.0256972,-2.0528346,-1.8790925,-1.7025951,-1.5271485,-1.3900509,-1.200765,-1.0862379,-0.93871816,-0.84109863,-0.68464522,-0.51698782,-0.31031954,-0.23853972,-0.11769768,0.06698902,0.26497967,0.4328511,0.45930764,0.67650789,0.77123925,0.88859215,0.94214978,0.94516276,0.77805648,0.66913942,0.54919004,0.35699167,0.36327649,0.30609774,0.13445531,0.049208866,0.072289898,-0.10389057,-0.26963367,-0.30899124,-0.37934899,-0.55999641,-0.70815476,-0.85707434,-0.7860614,-0.93338023,-0.98468016,-1.1620686,-1.1873778,-1.1936391,-1.2336472,-1.330646,-1.3926495,-1.5285106,-1.4683842,-1.333847,-1.3290056,-1.2113803,-1.2206866,-1.1489622,-1.0111479,-1.0499279,-0.82862676,-0.62483108,-0.42666019,-0.3378854,-0.37337941,-0.20518064,0.018139467,0.24127581,0.46731827,0.69658707,0.78897165,0.7709674,0.66928015,0.5620368,0.44397487,0.40012286,0.34236067,0.205767,0.13211073,0.25968808,0.10313903,0.0048630309,-0.089658039,-0.11718746,-0.21948332,-0.31383424,-0.26297128,-0.20344999,-0.31405809,-0.41018982,-0.49981418,-0.55625581,-0.51789602,-0.63310471,-0.69546969,-0.78479101,-0.92022782,-0.87716568,-0.75707001,-0.80814695,-0.655631,-0.52833974,-0.35755314,-0.49230516,-0.26542217,-0.21562915,-0.040456167,0.15821195,0.29068736,0.35697453,0.39080374,0.53879375,0.76871416,0.93971752,1.1074978,1.0095865,0.95966307,0.88403679,0.80536764,0.83737145,0.7130579,0.63587231,0.61776597,0.68660253,0.62681681,0.5763035,0.55044012,0.43195814,0.42481071,0.38710625,0.38823106,0.27649714,0.23534972,0.076187174,-0.0045040396,-0.085774292,-0.1261044,-0.16436759,-0.26643997,-0.39929215,-0.50321849,-0.64506742,-0.68199424,-0.46408477,-0.24883139,-0.055558237,-0.089094469,0.026637095,0.22471613,0.3476069,0.24209437,0.16500927,0.087699462,0.098511096,0.0034722994,-0.092288621,-0.070371801,-0.15759512,-0.2680693,-0.36896027,-0.4400235,-0.49208129,-0.51251915,-0.5642062,-0.63040244,-0.7366602,-0.8395131,-0.80607498,-0.87783046,-0.96301957,-1.0233969,-1.1163196,-1.2173893,-1.2527795,-1.3358752,-1.3994674,-1.5371946,-1.6119797,-1.7195769,-1.7524593,-1.8917009,-1.6893208,-1.5056059,-1.3014021,-1.0823996,-0.90032583,-0.67553024,-0.48275556,-0.27871907,-0.06285338,0.1229007,0.35735383,0.54385317,0.7690407,0.958326,1.1801153,1.3751994,1.6066926,1.7950946,2.0252635,2.2080975,2.4340608,2.6657116,2.8941895,3.1044182,3.3660031,3.5010076,3.4982509:1
3.1893961,3.1392847,3.0939312,2.9740066,2.7104724,2.4891358,2.2794596,2.0106812,1.7430832,1.4753577,1.3212929,1.055706,0.78991901,0.52504656,0.25952599,0.053302027,-0.20993421,-0.4161087,-0.67845864,-0.9436108,-1.1482701,-1.4100138,-1.6154205,-1.8238617,-2.0247584,-2.2474151,-2.4850292,-2.6784479,-2.8268907,-2.7103494,-2.4869595,-2.3113593,-2.1278282,-1.9570466,-1.7708167,-1.6201364,-1.429976,-1.2634886,-1.1168344,-0.97577506,-0.79795568,-0.64630961,-0.51324137,-0.37525023,-0.23311766,-0.37924874,-0.53331008,-0.47731404,-0.36921129,-0.23183709,-0.14057721,-0.030586981,0.13971026,0.22151909,0.19796981,0.29506682,0.41757561,0.59026177,0.46593331,0.27842881,0.13785448,-0.018250867,-0.19515257,-0.37565376,-0.47487055,-0.5863886,-0.74563041,-0.66077738,-0.55127715,-0.51958252,-0.40811146,-0.30355458,-0.22214548,-0.14748038,-0.051842708,0.049838418,0.15447305,0.28858693,0.32704551,0.29248552,0.44449975,0.50938745,0.61908647,0.71466049,0.75340484,0.84560774,0.81273432,0.85684351,0.93426313,0.90628412,0.97298949,0.88990877,0.69719256,0.46580417,0.49124535,0.29827256,0.18041488,0.016419623,-0.19904372,-0.37355151,-0.34853854,-0.25608001,-0.13416512,-0.011782341,0.10456288,0.21842288,0.30274299,0.40852088,0.51379098,0.62848935,0.74408734,0.79445589,0.82240316,0.86473098,1.001547,1.0349874,0.82776473,0.94264406,1.0823315,1.2360567,1.2907624,1.4290681,1.5819189,1.6994857,1.6828964,1.4908942,1.2732368,1.0923094,0.92562689,0.71775345,0.63915887,0.52011478,0.31032422,0.10201481,-0.049363562,-0.27745127,-0.48474346,-0.68291417,-0.86336069,-0.76774378,-0.71855691,-0.61200441,-0.47127803,-0.31351231,-0.21079081,-0.020059013,0.08461631,0.21395547,0.32643166,0.39145815,0.48844328,0.63265242,0.71948967,0.87338905,0.89394365,0.91602121,0.9996433,0.85081298,0.80021659,0.89952677,1.0177442,1.1775492,1.3306466,1.4724204,1.6495654,1.6918077,1.5127137,1.328481,1.1382971,1.0531513,0.90245463,0.7941437,0.6932647,0.52600303,0.39118629,0.24377602,0.087717273,0.057178519,0.080228194,-0.1069537,-0.26576764,-0.42697783,-0.48300069,-0.58606216,-0.61643046,-0.79669953,-0.99962767,-1.0956307,-1.2837003,-1.4842876,-1.3862093,-1.4871346,-1.3192934,-1.3201366,-1.2586241,-1.056407,-1.1361032,-0.95335646,-1.0166409,-0.81971038,-0.79867045,-0.73917182,-0.68227182,-0.50743281,-0.56792566,-0.57230677,-0.51435941,-0.3630321,-0.23935128,-0.24284153,-0.30371725,-0.20992192,-0.2119486,-0.03497466,-0.02054221,-0.0089365346,0.15770273,0.13567812,0.0017430231,0.063937663,0.15440502,0.27019436,0.1398592,0.30683506,0.343612,0.28319666,0.22114627,0.17674846,0.0407214,0.20483585,0.10503229,-0.082136903,-0.20638174,-0.3589765,-0.38117118,-0.33713523,-0.49195169,-0.61608156,-0.73990988,-0.91997725,-1.1119829,-1.2757697,-1.4431205,-1.6660101,-1.6829391,-1.575489,-1.4736283,-1.4522202,-1.2634037,-1.076072,-0.89125787,-0.70339146,-0.61427019,-0.45526895,-0.35755297,-0.36723264,-0.28180966,-0.076886841,0.02248436,0.19325376,0.22708883,0.22243574,0.43492349,0.40093896,0.56647426,0.71184109,0.88166046,1.0071951,1.1677259,1.2651517,1.4120905,1.4065552,1.2567861,1.2262005,1.0646331,0.89749254,0.95798803,0.89846676,0.73413064,0.59084818,0.42711511,0.36632976,0.48152969,0.29195899,0.16003431,0.021898593,-0.14746384,-0.26356998,-0.34149482,-0.48736843,-0.63191008,-0.76638772,-0.86068833,-0.94154483,-1.0732578,-0.94244101,-0.74367347,-0.48726376,-0.29140063,-0.068260848,0.07757754,0.21899226,0.37195763,0.56299856,0.76102147,0.81941865,1.0243034,1.2026597,1.3832348,1.4429754,1.3655134,1.2423003,1.113317,0.99457292,1.1021964,1.0085049,0.87421641,0.74629729,0.66128486,0.82033965,0.80430325,0.70083427,0.54694856,0.42840271,0.2897862,0.38871773,0.34983823,0.23627442,0.14412287,0.054379692,-0.036478181,-0.15067401,-0.20175171,-0.31981299,-0.43360059,-0.50528325,-0.57829597,-0.71079396,-0.79754957,-0.86882548,-0.92770873,-1.0395475,-0.87608727,-0.86514026,-0.77552827,-0.57813666,-0.38657596,-0.22167339,-0.023540311,0.17010551,0.34447853,0.27488259,0.20648167,0.14381322,0.060840532,0.097132256,0.050567431,-0.048231675,-0.10097384,-0.18285292,-0.02667391,-0.049800532,-0.14279243,-0.17935445,-0.27427481,-0.35390373,-0.43361301,-0.54216484,-0.62026478,-0.68025947,-0.77149892,-0.80400068,-0.80267323,-0.94712597,-0.74314338,-0.53588294,-0.31193412,-0.10434953,0.095384187,0.096152685,-0.037689452,-0.14430322,-0.26829829,-0.29160975,-0.36227677,-0.41732023,-0.42940798,-0.56278392,-0.64138659,-0.69631131,-0.66342983,-0.71759411,-0.81449114,-0.86679453,-0.94532751,-1.0064703,-1.1389002,-1.3006505,-1.4106199,-1.5537415,-1.7130544,-1.6434129,-1.8127849,-1.9483571,-2.0049372,-2.0057472,-1.7413696,-1.4764891,-1.2102424,-1.0019114,-0.73620549,-0.47022428,-0.26057299,0.0051725213,0.21622825,0.48159778,0.74815171,0.9583505,1.2251907,1.4394093,1.7023287,1.9131168,2.1801595,2.447635,2.7155323,2.9279722,3.1385537:1
1.2366839,1.1580954,1.076314,1.0109479,0.93890771,0.85525811,0.80842268,0.7394422,0.67025896,0.60921609,0.57580984,0.52262645,0.47447274,0.39267272,0.31191695,0.2451667,0.17656892,0.13473637,0.089274599,0.032979513,0.029136911,0.079605527,0.10674268,0.058175812,-0.0075802708,-0.06876689,-0.09146647,-0.15361222,-0.22881988,-0.30208566,-0.37590237,-0.46377374,-0.53019175,-0.61665784,-0.70855893,-0.78097778,-0.84680771,-0.93425463,-1.029556,-1.1194241,-1.1750112,-1.0833967,-1.0392063,-0.94912226,-0.84811907,-0.75776213,-0.67922478,-0.58105481,-0.48559225,-0.41215201,-0.42231558,-0.45950996,-0.51174221,-0.62803909,-0.69250733,-0.71637897,-0.78736782,-0.87342376,-0.87922537,-0.90240861,-0.98103818,-1.0731629,-1.1038843,-1.1170571,-1.0979215,-1.1331463,-1.2115515,-1.2788265,-1.3458013,-1.4165264,-1.4966213,-1.4901858,-1.412673,-1.3149174,-1.2414128,-1.1585637,-1.0459318,-0.94957424,-0.87907368,-0.82999959,-0.70422621,-0.59996088,-0.49062005,-0.42778063,-0.30259046,-0.22387642,-0.13723037,-0.041437185,0.0018459302,0.10234438,0.1648149,0.23496588,0.28568153,0.37852393,0.47811953,0.59210858,0.646806,0.69970861,0.79466795,0.84612731,0.95217575,1.0307121,1.1265552,1.2475877,1.3234364,1.4092541,1.5351275,1.6340524,1.6717256,1.7478967,1.8572839,1.9593302,2.0298639,2.0866703,2.1708541,2.1309748,2.0445286,1.9459368,1.8217385,1.695275,1.6271701,1.5025455,1.3797438,1.2812178,1.1744673,1.0678071,0.96425055,0.85074955,0.73485978,0.62738568,0.51411943,0.40448979,0.29785802,0.1929004,0.070032544,-0.042698616,-0.14676771,-0.24978928,-0.36771679,-0.48312838,-0.54889062,-0.64978767,-0.74594247,-0.83897857,-0.95697763,-1.0693427,-1.172955,-1.2852246,-1.3609403,-1.3437341,-1.3070682,-1.2521174,-1.2160856,-1.1042027,-1.0205191,-0.92250079,-0.84422158,-0.79060078,-0.77510048,-0.81237678,-0.88058265,-0.94408587,-0.96261043,-0.93794766,-0.90439568,-0.84450809,-0.77128724,-0.67848677,-0.59713119,-0.51370803,-0.44273203,-0.37759156,-0.33148678,-0.33258021,-0.39454675,-0.44513356,-0.39884214,-0.33303821,-0.30007116,-0.26288002,-0.20725856,-0.13740945,-0.068468534,-0.024222095,0.035836791,0.13357048,0.2336971,0.31559599,0.39089232,0.47108132,0.51353518,0.58860775,0.69707275,0.81230769,0.91035784,0.90853931,0.80523203,0.70003528,0.59912982,0.49375184,0.39869601,0.29471895,0.19036654,0.081903288,0.021416942,-0.069364294,-0.17231148,-0.27836334,-0.38770876,-0.5005375,-0.60590439,-0.71343379,-0.81187921,-0.91254151,-0.96118889,-0.97947956,-0.99918191,-0.95406763,-0.91045172,-0.86158879,-0.77283859,-0.66235366,-0.55348043,-0.46202756,-0.37598441,-0.30816882,-0.23985809,-0.18719008,-0.098922703,0.0039931002,0.12131498,0.21026018,0.2531258,0.29392784,0.37857415,0.44929033,0.50787024,0.55821547,0.61892549,0.70044807,0.70759067,0.64303632,0.60916437,0.57248953,0.54963845,0.56468225,0.60291782,0.65020237,0.71107803,0.79172304,0.81289259,0.85882948,0.9284573,0.96393031,1.0284668,1.092751,1.1540215,1.2315087,1.2822347,1.3348562,1.4211152,1.4621324,1.4090361,1.2957959,1.1838374,1.0622867,0.94362153,0.8432074,0.73220773,0.61302483,0.49948526,0.38870682,0.28134559,0.16972216,0.071206247,-0.039827674,-0.14412092,-0.25085843,-0.36031741,-0.46384787,-0.56703169,-0.67265218,-0.77601363,-0.88228982,-0.98595798,-1.0906393,-1.1947258,-1.2981163,-1.3991746,-1.5077533,-1.6089742,-1.7163788,-1.8026917,-1.8543721,-1.8660147,-1.8823193,-1.8179786,-1.7256052,-1.6169073,-1.53787,-1.4444771,-1.3339938,-1.225511,-1.1183323,-0.98961991,-0.87153515,-0.7489713,-0.63233526,-0.51343438,-0.38717701,-0.26106047,-0.14098295,-0.03542211,0.062706792,0.14825613,0.2669787,0.36528595,0.45175631,0.5419746,0.60185037,0.69814724,0.81101753,0.91483237,0.87734351,0.81103575,0.73944494,0.68720407,0.7095603,0.80491471,0.90349177,0.99388923,1.0839592,1.2076333,1.3203701,1.4056699,1.4556111,1.5266891,1.6159677,1.7010629,1.7762272,1.8474642,1.926511,2.0226572,2.1041656,2.1441241,2.0690257,2.0061268,1.9411436,1.8646675,1.8024666,1.7355957,1.6541663,1.5648057,1.4906172,1.4403797,1.4259693,1.3598529,1.2653877,1.1587605,1.0717922,0.96535017,0.88086808,0.79466306,0.69888866,0.63620166,0.60292745,0.62279761,0.67785742,0.67891433,0.57548896,0.44074713,0.30825736,0.18255917,0.061233836,-0.028332562,-0.10970077,-0.22870386,-0.34534398,-0.44465061,-0.54127647,-0.66479516,-0.7852524,-0.87784534,-0.96843499,-1.073235,-1.1765374,-1.2932194,-1.3646719,-1.4758313,-1.5844729,-1.6879699,-1.7963759,-1.9020097,-2.0086582,-2.0972141,-2.1007517,-1.9938131,-1.8856381,-1.7805836,-1.6782503,-1.5699535,-1.467513,-1.3638565,-1.2614976,-1.1516811,-1.0480635,-0.94614731,-0.84198539,-0.73090023,-0.62671712,-0.51590222,-0.43288531,-0.33153049,-0.22057811,-0.1169132,-0.0023179518,0.10707632,0.15505423,0.25938641,0.3734061,0.49381919,0.60167657,0.71763114,0.83764011,0.95542593,1.0777342,1.1990072:5
0.26741774,0.21473451,0.157347,0.095258204,0.038593687,-0.010940685,-0.034043928,-0.061756225,-0.10167993,-0.13594341,-0.18423495,-0.22833718,-0.27807033,-0.3297513,-0.3700582,-0.42346572,-0.47173761,-0.52458861,-0.5801088,-0.63296192,-0.69969284,-0.75863044,-0.82501697,-0.88162591,-0.93048256,-0.98503873,-1.0189601,-1.0304843,-1.0146186,-0.97326985,-0.92079005,-0.87273247,-0.81730949,-0.7713591,-0.71971178,-0.679868,-0.65568042,-0.60369399,-0.6065677,-0.59056392,-0.58609565,-0.57248245,-0.57920285,-0.58064133,-0.60503996,-0.62480311,-0.6648969,-0.69032242,-0.73200019,-0.77932312,-0.84006285,-0.91145028,-0.9551921,-1.021386,-1.0588028,-1.0943265,-1.1053393,-1.1434446,-1.2141099,-1.2694527,-1.3100476,-1.2594739,-1.2014534,-1.1450538,-1.0873254,-1.0198343,-0.95644042,-0.89045955,-0.81557945,-0.74197843,-0.67263885,-0.59377842,-0.51090858,-0.46790807,-0.38206136,-0.35912341,-0.35656695,-0.30148136,-0.256299,-0.22596657,-0.16647313,-0.10560145,-0.062031991,-0.0039127191,-0.02071397,0.033251857,0.092534567,0.067060495,0.12065998,0.16517967,0.20263831,0.2564609,0.29662286,0.33931393,0.38049988,0.40697716,0.42324898,0.43741739,0.44453936,0.43001942,0.40664851,0.37074436,0.33302324,0.294006,0.25709322,0.21092796,0.17449022,0.13663465,0.16364915,0.24773975,0.32249605,0.30535155,0.35310095,0.42166475,0.5143766,0.57557639,0.64042317,0.70349073,0.8101283,0.89478417,1.0002503,1.0637864,1.148438,1.2526744,1.3398644,1.4461333,1.5308975,1.6144309,1.69881,1.8053985,1.8861715,1.9436096,2.0085024,2.1147204,2.1995625,2.2414638,2.2708636,2.292577,2.2887377,2.283587,2.2638969,2.2128372,2.1072063,2.0353645,1.9594981,1.8917008,1.8225095,1.7625919,1.7027953,1.625179,1.5592811,1.4730584,1.3873253,1.3015666,1.1947702,1.1097919,1.0037253,0.93418202,0.88335332,0.7797968,0.72296992,0.64276681,0.56104805,0.49865515,0.4458303,0.41738116,0.37071866,0.36385247,0.37307502,0.40143769,0.43378938,0.44495808,0.43870917,0.40549413,0.36181125,0.32157617,0.27146093,0.22200536,0.18488909,0.12116977,0.061183567,0.0015972512,-0.059321981,-0.12373328,-0.20572557,-0.29182041,-0.377212,-0.46237864,-0.54557853,-0.61532335,-0.69421852,-0.76857705,-0.84040437,-0.83668344,-0.77609534,-0.73415595,-0.71707333,-0.68894637,-0.66512892,-0.6537471,-0.64380298,-0.62185104,-0.6063004,-0.61268867,-0.60472577,-0.5968961,-0.58446827,-0.59666375,-0.57519253,-0.58899317,-0.60376369,-0.63819447,-0.6589645,-0.67628489,-0.68180337,-0.68247473,-0.66097596,-0.63966324,-0.63560982,-0.60885972,-0.57807671,-0.56159056,-0.55058297,-0.53339435,-0.50907561,-0.48244813,-0.47372121,-0.45593197,-0.47127971,-0.48334791,-0.50491463,-0.53157087,-0.57752927,-0.6296705,-0.69672657,-0.77787232,-0.84611745,-0.91752643,-0.99277463,-1.090835,-1.1733963,-1.2571295,-1.3359133,-1.4193944,-1.4983468,-1.5748799,-1.6584679,-1.7344156,-1.814153,-1.8840036,-1.9595198,-2.0332746,-2.1115329,-2.1788147,-2.2286263,-2.252137,-2.290925,-2.2242234,-2.1595704,-2.0819602,-2.0017194,-1.9440056,-1.9104043,-1.840342,-1.7522277,-1.6813833,-1.6046373,-1.5341292,-1.453688,-1.3735796,-1.297096,-1.2265942,-1.1560157,-1.0774448,-0.99722995,-0.92931602,-0.84975573,-0.76744698,-0.69471737,-0.62462779,-0.54890907,-0.47279236,-0.39627417,-0.3296773,-0.25698693,-0.17891591,-0.11455934,-0.07962789,-0.059236466,-0.047327328,-0.05123166,-0.048112735,-0.059396941,-0.079492519,-0.1063933,-0.1191936,-0.161738,-0.19854579,-0.24085354,-0.26540565,-0.29009927,-0.28686796,-0.19864345,-0.10968992,-0.028859803,0.042487605,0.11901954,0.19167405,0.27934441,0.34894107,0.35989262,0.42154533,0.49129323,0.55192131,0.6131609,0.68538703,0.76939787,0.85747511,0.91634331,0.99748624,1.0839985,1.1672232,1.2483605,1.3527044,1.4229099,1.4917629,1.5476078,1.5778238,1.5802513,1.5794499,1.580505,1.5744883,1.5482124,1.5212915,1.4866842,1.4510156,1.4100031,1.3670563,1.32845,1.2829399,1.2360343,1.1895263,1.1432,1.0900245,1.0445639,1.006246,1.0160264,1.0453282,1.0885113,1.1335522,1.1896232,1.2510289,1.2997663,1.3659039,1.4159347,1.4657033,1.5116022,1.5501488,1.5965479,1.6302002,1.652667,1.642306,1.5962041,1.5413424,1.4693424,1.3939129,1.3178428,1.2346956,1.156212,1.080659,0.97907105,0.90347546,0.80241891,0.71629036,0.63915306,0.55558895,0.45374817,0.36909279,0.29270933,0.22149311,0.16672639,0.065423001,-0.038955613,-0.094902811,-0.16907351,-0.23429238,-0.32011875,-0.40552163,-0.49325351,-0.58156088,-0.64799371,-0.73589167,-0.824053,-0.90781946,-0.98962688,-1.0733545,-1.1092775,-1.0942221,-1.0351674,-0.96540696,-0.89493533,-0.8269879,-0.7611504,-0.67847274,-0.61409693,-0.53677358,-0.46847854,-0.39232835,-0.31530126,-0.24706708,-0.17294805,-0.094928065,-0.020998356,0.05759257,0.12205798,0.18294843,0.25969876,0.33154303,0.37218397,0.42132631,0.44944108,0.46602172,0.46809099,0.44488454,0.41752043,0.37187603,0.31883085:2
0.23176119,0.094604725,-0.044378543,-0.078736179,-0.036929639,0.0060657693,0.059981118,0.11100029,0.11822635,0.083289013,0.10225665,0.13944578,0.21205579,0.27810871,0.33351129,0.39940468,0.36402102,0.36177602,0.27053033,0.33499088,0.39218987,0.47966509,0.54200233,0.58388707,0.61774021,0.68741718,0.77525964,0.82609939,0.86297028,0.92027565,1.0107701,1.0760425,1.0804937,0.97434576,0.8791384,0.77901349,0.68416649,0.58565533,0.49327519,0.4001632,0.30392006,0.20920967,0.11584812,0.027293686,-0.072355039,-0.18269068,-0.27304072,-0.38188995,-0.45191343,-0.52272211,-0.61898997,-0.71713732,-0.83292368,-0.92919158,-1.0317398,-1.1163629,-1.2194833,-1.309903,-1.4262836,-1.5078416,-1.6071785,-1.697629,-1.8059216,-1.8942801,-1.9811994,-2.0830066,-2.1838104,-2.2708163,-2.362832,-2.4610257,-2.5521512,-2.634822,-2.7414985,-2.7713156,-2.7385632,-2.7343952,-2.732289,-2.6830089,-2.6296047,-2.6071479,-2.5362859,-2.4291516,-2.3305447,-2.2735125,-2.2116265,-2.1952945,-2.2186261,-2.2945093,-2.2551712,-2.1394328,-2.0678373,-1.9455752,-1.8704675,-1.7876613,-1.7490824,-1.6799565,-1.5947367,-1.5161136,-1.439382,-1.3726873,-1.3034044,-1.2150916,-1.1439993,-1.0859184,-1.0569284,-1.0764324,-1.1649433,-1.2423237,-1.3106317,-1.3704472,-1.4231645,-1.3567392,-1.3116137,-1.2735279,-1.1791065,-1.0849299,-0.98434559,-0.88984881,-0.83625747,-0.74022491,-0.6446043,-0.54236908,-0.45218903,-0.33596848,-0.23745768,-0.15315042,-0.076940612,-0.025355158,-0.052679155,-0.11603523,-0.017927759,0.066165009,0.18419139,0.24648907,0.34706438,0.43849003,0.51744372,0.61105244,0.71739145,0.82951232,0.90131975,1.0040246,1.0955542,1.2170968,1.3124019,1.3967154,1.5050922,1.6047949,1.7024854,1.7944507,1.8669826,1.87175,1.8187292,1.7002761,1.579489,1.4550451,1.3359225,1.2125225,1.0811274,0.98629238,0.85845288,0.74688804,0.63269756,0.54574458,0.5103779,0.51583121,0.47129675,0.35584256,0.27031536,0.19028562,0.12583676,0.0060230528,-0.079643386,-0.090623962,-0.019162759,0.0070661071,-0.059640821,-0.11408056,-0.19780868,-0.2867096,-0.39867445,-0.47560503,-0.50215657,-0.51696196,-0.5858802,-0.53941571,-0.57084313,-0.6458745,-0.73334676,-0.8210892,-0.90457809,-0.91452484,-0.79778593,-0.66715748,-0.53577037,-0.44819851,-0.31416042,-0.21489992,-0.13316628,-0.071765851,-0.11657875,-0.17265681,-0.1956454,-0.20349562,-0.27597956,-0.32197374,-0.38851057,-0.40597548,-0.34034814,-0.39177153,-0.45864051,-0.55333964,-0.6232176,-0.69079561,-0.74863137,-0.81594634,-0.76013481,-0.73261718,-0.76430437,-0.78624318,-0.82410667,-0.86206709,-0.84911032,-0.89315329,-0.92762727,-0.93978244,-0.95295824,-0.96389013,-0.85254712,-0.75163569,-0.65233369,-0.54107301,-0.44983344,-0.32668344,-0.2345028,-0.11705825,-0.028385949,0.10368029,0.19119201,0.28731252,0.36656055,0.49572193,0.58816107,0.67757409,0.73695923,0.78807826,0.91516949,1.0009008,1.1059406,1.1774504,1.1147052,1.0748157,1.1158864,1.1671183,1.2249382,1.2723321,1.323873,1.3544114,1.305903,1.2042183,1.1391483,1.0518098,0.94938068,0.91792446,0.85253616,0.77928301,0.72364406,0.70684169,0.61743659,0.55538708,0.53069579,0.48449179,0.4142738,0.35512165,0.32611735,0.30371178,0.21458217,0.16474577,0.10787366,0.11506019,0.037620143,-0.077712833,-0.11905966,-0.090161663,-0.084880222,-0.12451675,-0.13531156,-0.12983224,-0.14034652,-0.16200586,-0.18858982,-0.17484157,-0.19598238,-0.2009539,-0.22829812,-0.24571487,-0.24563635,-0.25867192,-0.25400781,-0.26679401,-0.27174142,-0.27168143,-0.2720913,-0.24771366,-0.23875784,-0.22689173,-0.20900919,-0.19541141,-0.17596399,-0.15315837,-0.12496267,-0.10634582,-0.07542628,-0.024967672,0.022132594,0.041833823,0.09850261,0.16399515,0.2435712,0.28573289,0.33139519,0.38482608,0.4275382,0.49660924,0.53373673,0.58102729,0.60312792,0.66556824,0.74842661,0.7867083,0.79335182,0.76951861,0.78907543,0.84267755,0.88475558,0.91379307,0.98036035,1.0696988,1.1673574,1.1976827,1.2244488,1.2394009,1.1964355,1.1634692,1.1474802,1.119973,1.1296573,1.1282651,1.1017292,1.1373951,1.1466691,1.1739318,1.232128,1.2900007,1.2991383,1.3093236,1.3721975,1.4107517,1.3952789,1.3393908,1.3742389,1.3540142,1.343173,1.321484,1.2848313,1.1989745,1.1116212,1.1051028,1.1226704,1.1370671,1.1433954,1.1163933,1.1032592,1.1062153,1.0796779,1.024956,0.9452208,0.9447611,0.96513953,0.95744669,0.89945954,0.81657931,0.80139249,0.7738089,0.79042403,0.71661804,0.6273628,0.55934682,0.44376985,0.35133788,0.24273507,0.17475229,0.073051811,0.054125516,0.074965639,0.089621207,0.10079958,0.13663262,0.15660117,0.1787389,0.20735085,0.18088016,0.19870623,0.24382315,0.24652936,0.23296476,0.26214192,0.2574215,0.19278782,0.093193939,0.023365942,-0.009722071,-0.019421744,0.0022884143,0.037418425,0.089838685,0.11621143,0.16059045,0.15365338,0.14029178,0.18092527,0.22436088,0.2486075,0.21768925,0.24680045,0.25766642,0.25655044:3
1.5982752,1.4948008,1.4168169,1.3270026,1.2330884,1.1873754,1.0989028,1.0406685,0.99923919,1.021286,1.0222411,0.92212573,0.82396302,0.71855886,0.58195952,0.55702844,0.47303399,0.37754181,0.26651093,0.15015103,0.169809,0.29758318,0.4201582,0.54724131,0.67865221,0.80193937,0.92601908,1.054,1.1834925,1.2781959,1.1924788,1.0345697,0.89904822,0.80195406,0.72796763,0.6627655,0.53090064,0.40974796,0.31307817,0.22399648,0.15220904,0.15063927,0.034220501,-0.081977385,-0.18406366,-0.31436389,-0.4385932,-0.5620069,-0.68388548,-0.78976292,-0.91612081,-0.97608197,-1.0369985,-1.0707269,-1.0818726,-1.099135,-1.1421092,-1.0559129,-0.93838162,-0.8668964,-0.73079613,-0.60421351,-0.47138009,-0.36088732,-0.28988909,-0.16143818,-0.034213905,0.10075992,0.23678986,0.37865905,0.51962393,0.66584123,0.82076063,0.96452553,1.1179755,1.2626891,1.4187454,1.5191621,1.4184395,1.3119509,1.2158257,1.1245179,1.0332082,0.93952945,0.82965955,0.7176692,0.65693801,0.63626497,0.56345575,0.4646393,0.38355224,0.28956742,0.18475214,0.15651361,0.21731289,0.29800542,0.27543676,0.17995473,0.079514558,-0.012659943,-0.10994698,-0.2134734,-0.28137362,-0.38810295,-0.49067661,-0.59514064,-0.69719362,-0.78841337,-0.8300862,-0.83739441,-0.7333097,-0.68234311,-0.69041429,-0.77414167,-0.86609554,-0.94268676,-0.90142499,-0.76459666,-0.63398494,-0.49501298,-0.35159738,-0.20478977,-0.065443579,0.098329407,0.25186651,0.38357907,0.55954449,0.7064742,0.83962972,1.0190222,1.1361376,1.1026224,0.97768239,0.83269325,0.68388281,0.51377113,0.39733158,0.26416074,0.20029897,0.072580543,-0.070759096,-0.1928033,-0.33894355,-0.48419052,-0.62606396,-0.77516804,-0.90075812,-1.0381423,-1.1648126,-1.2964624,-1.2969435,-1.229538,-1.1339306,-1.0077152,-0.90490443,-0.84902506,-0.89260499,-1.0036984,-1.0844423,-1.0712882,-0.99037933,-0.86773848,-0.72810136,-0.59347797,-0.43908776,-0.35251477,-0.25377225,-0.11712514,-0.028914648,0.10603907,0.16778873,0.10270952,0.053687794,0.15695036,0.17962468,0.28115747,0.38952344,0.43810904,0.51693628,0.55426722,0.71495703,0.77329345,0.7343072,0.77428437,0.89976012,1.0153341,1.0665541,1.1451536,1.2346848,1.3535038,1.4891794,1.608879,1.6844896,1.5750704,1.4215711,1.2724078,1.1283258,0.99002361,0.82026203,0.66657614,0.53256236,0.39252342,0.23321821,0.070909946,-0.11442483,-0.28508644,-0.46216765,-0.61183163,-0.75271431,-0.88507089,-1.0171031,-1.1404883,-1.27288,-1.4001987,-1.4361109,-1.3817307,-1.2364574,-1.1635893,-1.0479843,-0.91299926,-0.79372308,-0.68152086,-0.5895771,-0.47914034,-0.35329616,-0.23835549,-0.13956371,-0.033752045,0.070671981,0.16664105,0.20755729,0.29168875,0.39208404,0.49813871,0.60185429,0.68621349,0.78493578,0.89729273,1.0128698,1.1255365,1.2577855,1.3772375,1.3494869,1.201695,1.0528899,0.9053114,0.75811955,0.6131014,0.49240859,0.38544885,0.30181846,0.29763289,0.37945027,0.49747584,0.61131095,0.726666,0.84712391,0.9462112,1.0424456,1.1418578,1.1425925,1.126513,1.1292079,1.1884821,1.2328427,1.2908046,1.3317739,1.3630139,1.4898675,1.6437959,1.5841689,1.4741651,1.3616149,1.2463015,1.1276974,1.0076835,0.9098517,0.78226151,0.6549014,0.52445186,0.39571977,0.26673738,0.13990361,0.021602672,-0.091133253,-0.1364953,-0.12986886,-0.1445183,-0.27287732,-0.43308683,-0.51153652,-0.65045958,-0.78104683,-0.93292055,-1.0736269,-1.2306669,-1.3869195,-1.5678099,-1.6958454,-1.814366,-1.9501854,-2.1083404,-2.2743099,-2.4108034,-2.526545,-2.6526729,-2.7520046,-2.8704716,-2.9799027,-2.9155996,-2.9547347,-2.9158638,-2.8674751,-2.7274089,-2.6374899,-2.6010437,-2.4820626,-2.4421163,-2.331204,-2.2043408,-2.0758108,-2.0276181,-1.8815796,-1.728787,-1.5590108,-1.4535581,-1.3614904,-1.2097181,-1.0554214,-0.92339482,-0.7918805,-0.66659362,-0.52504623,-0.36928799,-0.26393463,-0.14871968,-0.027914794,0.10098455,0.21949513,0.14776255,0.049190832,-0.024268258,-0.11244386,-0.20191785,-0.26981785,-0.32157052,-0.27596758,-0.15877954,-0.041004535,0.078475086,0.1900668,0.31278272,0.43041654,0.54508378,0.65899949,0.66753435,0.68508525,0.77796306,0.88622246,0.9960962,1.1043488,1.220683,1.340618,1.4596067,1.4279335,1.2911155,1.1492719,1.031691,0.92151136,0.814315,0.68001615,0.54884361,0.46997847,0.47627502,0.51743027,0.44633984,0.3137468,0.19497148,0.066723059,-0.060892282,-0.18638268,-0.3119839,-0.38785407,-0.496791,-0.60555912,-0.6438993,-0.5893618,-0.47244961,-0.357749,-0.26130233,-0.15473409,-0.1144117,-0.24230669,-0.36385517,-0.48581159,-0.59519335,-0.70159912,-0.806938,-0.91972838,-1.0550741,-1.1240163,-1.2202991,-1.2179034,-1.0653235,-0.93057041,-0.79901728,-0.65404606,-0.51902224,-0.36761956,-0.21580967,-0.10094262,-0.11761095,-0.10153412,-0.076357487,0.0059157493,0.14147649,0.29333341,0.44480364,0.58084262,0.73357159,0.82959931,0.92756429,1.0888467,1.2204331,1.3595464,1.4892595,1.6009258:5
2.5913468,2.4471341,2.3311503,2.2177105,2.0833348,1.9503623,1.8419388,1.7195184,1.6187113,1.511508,1.4020251,1.2771908,1.1711654,1.1548053,1.1002007,1.0067561,0.90310239,0.81071091,0.74943033,0.72056992,0.75335417,0.72628799,0.63509586,0.57568709,0.46462147,0.37318277,0.27484878,0.17823537,0.18577401,0.24957864,0.16385785,0.07880018,-0.016873881,-0.11223514,-0.22096358,-0.33641685,-0.30568499,-0.27786521,-0.34751745,-0.49341488,-0.62678319,-0.74578247,-0.86466966,-0.95118725,-1.0811202,-1.2208009,-1.3666315,-1.5144626,-1.6231463,-1.626624,-1.5145343,-1.4339174,-1.3147144,-1.2017332,-1.1932662,-1.0648419,-0.97327299,-0.86148532,-0.75466464,-0.76827371,-0.63656789,-0.56337855,-0.45061228,-0.37933234,-0.31533655,-0.19749666,-0.12405285,-0.042049396,0.066512223,0.12597422,0.071064654,-0.039182559,-0.12728167,-0.2501681,-0.31139869,-0.41838828,-0.52789819,-0.53646126,-0.59194769,-0.68815631,-0.78752669,-0.88721046,-0.95946839,-0.9566794,-1.0110367,-1.0980714,-1.1736395,-1.264943,-1.3154903,-1.4121533,-1.4992323,-1.5668923,-1.6438898,-1.7341313,-1.8028145,-1.7644039,-1.6980059,-1.6264214,-1.5368642,-1.4507946,-1.3905983,-1.2990742,-1.2103345,-1.1078378,-1.0222604,-0.94738259,-0.84547581,-0.77832181,-0.68917779,-0.60712943,-0.53052928,-0.42397,-0.32223015,-0.24946927,-0.19583383,-0.11540647,-0.036508091,0.047513809,0.13188274,0.23886381,0.29290352,0.36556814,0.4675251,0.57313198,0.65149644,0.76579667,0.87307527,0.99609281,1.1335924,1.2731158,1.2397138,1.1698131,1.0763072,0.98962102,0.89245953,0.81566971,0.76474134,0.68528039,0.6299747,0.62860444,0.58969061,0.53703832,0.50652335,0.50336183,0.54600457,0.52023216,0.48319291,0.47323094,0.48792911,0.57032107,0.54285902,0.51382587,0.47282791,0.43006648,0.39781738,0.31273709,0.33119479,0.41060035,0.45068449,0.46105391,0.42593063,0.42341396,0.33935193,0.31952971,0.34809002,0.26068776,0.18364388,0.14342292,0.14558766,0.12946843,0.056018156,-0.012882914,-0.032311681,-0.13455894,-0.11757303,-0.21404694,-0.31078849,-0.39792443,-0.43423983,-0.53339547,-0.62330099,-0.68698468,-0.78524621,-0.75344531,-0.62885754,-0.51017182,-0.3727401,-0.23384174,-0.094813021,0.026741784,0.1522462,0.25589774,0.39476483,0.53587866,0.66018822,0.79715681,0.92090838,1.0458181,1.1565267,1.2948132,1.415834,1.5572159,1.6780479,1.8023451,1.9335178,2.0526493,2.1719222,2.2441385,2.3646196,2.4464194,2.4648974,2.3716764,2.2846448,2.2105055,2.0902621,1.9618215,1.8207517,1.6995747,1.557248,1.4192237,1.2978142,1.1745126,1.0768346,0.95491886,0.84364458,0.70500027,0.56382581,0.44391681,0.30257797,0.16150088,0.057489268,-0.063699173,-0.19349143,-0.33446537,-0.46822563,-0.51941249,-0.61903749,-0.74905609,-0.87618944,-0.82612195,-0.75059529,-0.67433081,-0.61903275,-0.5487333,-0.48817466,-0.43169768,-0.42512317,-0.35370204,-0.31487958,-0.27528168,-0.29495027,-0.22677909,-0.20886921,-0.17241322,-0.13606397,-0.11146443,-0.075856687,-0.16507614,-0.091625405,-0.035213144,-0.010508893,0.05154666,0.014069098,0.032944898,0.10713943,0.038704055,0.1192234,0.12791382,0.1191961,0.016689004,-0.097863107,-0.050257207,0.029875831,0.030141254,0.045328279,0.076269165,0.094736513,0.14285228,0.14731269,0.020169723,-0.066989398,0.044582599,0.029472603,0.11407252,0.13905866,0.10672578,0.0052489109,0.055718123,0.088744975,0.17185841,0.23287675,0.17083746,0.19747502,0.23588576,0.30547341,0.36450434,0.33850123,0.45753614,0.57762905,0.59212877,0.72070216,0.79900149,0.89176221,0.83673267,0.71998753,0.58138137,0.42626179,0.31875239,0.21855918,0.15147964,0.023336737,-0.089500649,-0.1883084,-0.27414578,-0.41234817,-0.50322909,-0.58734671,-0.68768621,-0.76427739,-0.82890553,-0.98341479,-1.0568434,-1.1517185,-1.229878,-1.3213288,-1.4036329,-1.4957928,-1.5852353,-1.6659041,-1.7739624,-1.8655771,-1.929039,-2.0265655,-2.0656487,-2.010211,-1.8897836,-1.77152,-1.7713585,-1.6593369,-1.5775287,-1.5794082,-1.587828,-1.4786236,-1.360103,-1.3488433,-1.2333639,-1.1418437,-1.0961125,-1.1514099,-1.1241197,-1.00715,-0.92258445,-0.8213695,-0.77946966,-0.76823182,-0.66060831,-0.55446808,-0.53436092,-0.4244862,-0.33911517,-0.27716981,-0.35812596,-0.48776505,-0.55226784,-0.65232936,-0.71793493,-0.84865135,-0.94075164,-1.0035882,-1.0255184,-1.1699043,-1.2358182,-1.3124298,-1.2167559,-1.2255419,-1.1468161,-1.0740323,-0.95049165,-0.88003027,-0.84283807,-0.72461999,-0.61053997,-0.57424806,-0.46054268,-0.34976927,-0.33768739,-0.38982993,-0.40665792,-0.35110404,-0.2412509,-0.16873304,-0.19266899,-0.21810056,-0.12069133,-0.0067892275,0.11048715,0.19341112,0.13260832,0.24978902,0.33815079,0.39827358,0.51325447,0.57462257,0.70432957,0.81166816,0.76736915,0.75210883,0.87352191,0.94308494,1.0262717,1.1048251,1.2168712,1.2271648,1.1770201,1.3016492,1.3672333,1.4760741,1.5929361,1.6327843,1.7480726,1.8710343,1.9786782,2.0558551,2.1757259,2.324413,2.4450421,2.5459768:6
1.8886362,1.7868666,1.658054,1.5071809,1.3500178,1.3934796,1.2048732,1.0426553,1.0427096,0.98247902,0.83103363,0.71549085,0.61837328,0.48350614,0.30973372,0.14198206,0.24377786,0.16688562,-0.027006435,-0.17421118,-0.29994712,-0.4175468,-0.55382526,-0.72969302,-0.90143218,-1.028439,-1.1332393,-0.95652004,-0.76948852,-0.59429085,-0.3803571,-0.21216989,-0.0071368698,0.19131863,0.35637357,0.45385691,0.57254284,0.76815269,0.96152003,1.0616831,1.2677688,1.4448311,1.6298791,1.5162847,1.3460023,1.2101887,1.1965186,1.0521008,0.89625486,0.8747439,0.77040558,0.62924825,0.59244103,0.4538086,0.3126914,0.36041624,0.24233938,0.14726625,0.0026685688,-0.10755637,-0.22329491,-0.31641788,-0.42943999,-0.55299225,-0.68045547,-0.81991002,-0.66617556,-0.58324,-0.3577595,-0.1001252,0.10196078,0.28475275,0.3254794,0.53457347,0.73731306,0.8861259,0.90740814,0.78948617,0.67505166,0.53742348,0.48350283,0.36531871,0.22423965,0.3113912,0.23455488,0.15973875,0.097668848,0.022548319,0.001633638,-0.085436522,-0.16136853,-0.22418635,-0.28995288,-0.38398171,-0.49169225,-0.59757054,-0.72093096,-0.66343199,-0.48706915,-0.32647051,-0.17836506,-0.079593467,0.12830634,0.30867529,0.27047419,0.13470701,0.027519979,-0.073921956,-0.22063494,-0.1734429,-0.22849555,-0.34787476,-0.48573411,-0.61115036,-0.71875354,-0.84816237,-0.91764356,-0.97053509,-0.81424359,-0.83780554,-0.845971,-1.0169598,-1.1131998,-1.2713499,-1.4342121,-1.6038438,-1.7773186,-1.8443549,-1.9412615,-2.0708794,-1.9920373,-1.9848887,-1.7923717,-1.690311,-1.5053615,-1.295505,-1.0402787,-0.86527904,-0.65561155,-0.47657748,-0.26838121,-0.055997554,0.16480285,0.33131997,0.5489792,0.74607265,0.92901429,1.1490005,1.3671103,1.5269935,1.7547301,1.9594043,2.1516687,2.3841811,2.5612709,2.7679789,2.9485293,3.1144181,3.0118044,3.009129,2.8346841,2.6362756,2.4338234,2.1810843,1.9769411,1.7636721,1.5483887,1.3335403,1.120754,0.91212832,0.7284208,0.52214671,0.30293091,0.11483792,-0.076526309,-0.29687211,-0.49499823,-0.67754267,-0.89730227,-1.0996094,-1.2810759,-1.4955542,-1.7109969,-1.9217278,-2.1278828,-2.29846,-2.2007809,-2.0308861,-1.886724,-1.72346,-1.5915805,-1.4664132,-1.4138303,-1.2543256,-1.174054,-1.1287244,-0.9981719,-0.84281643,-0.93773634,-1.1684588,-1.0300381,-1.022246,-0.91579217,-0.78710621,-0.66417397,-0.60839915,-0.50462444,-0.43917568,-0.37312864,-0.26014723,-0.15567389,-0.0960555,-0.20219585,-0.22126371,-0.086422099,-0.0091757541,0.10341125,0.18612219,0.28845733,0.45193549,0.4952244,0.46046189,0.2463892,0.067254444,-0.12792563,-0.14547504,-0.33224222,-0.54518254,-0.71959196,-0.93683359,-1.1244546,-1.3237863,-1.352885,-1.1894045,-1.1641384,-1.0275774,-0.94112858,-0.86093374,-0.68673937,-0.69577577,-0.62586493,-0.51612838,-0.42867746,-0.46917164,-0.37869847,-0.30041207,-0.24730043,-0.17924929,-0.061610805,0.0061363741,0.096402005,0.20618141,0.29079026,0.22202216,0.37094534,0.51502693,0.56317625,0.68086968,0.79190152,0.8970032,0.9946118,0.79387777,0.61351029,0.42899475,0.21998044,0.09089586,0.076244927,-0.11609351,-0.29630013,-0.46314668,-0.66094051,-0.83624065,-0.98958095,-0.88689648,-0.80488932,-0.66090427,-0.52673364,-0.55374791,-0.4841734,-0.36859604,-0.24569598,-0.13758524,-0.037526441,0.054994979,-0.048850995,0.062891602,0.1788085,0.28258364,0.42084355,0.54548633,0.41585964,0.48474988,0.61838117,0.75072278,0.87167673,0.89606277,1.0408338,1.1176873,1.2840295,1.4141524,1.4403864,1.1786141,1.033911,0.86217106,0.68103207,0.42525333,0.23360925,0.091536826,-0.16159667,-0.35506921,-0.53635362,-0.78448694,-1.027276,-1.1868258,-1.3799178,-1.5324705,-1.6340142,-1.473824,-1.3046785,-1.1495877,-1.0056025,-0.87001526,-0.71639393,-0.55189191,-0.41525007,-0.28163351,-0.35483518,-0.20019119,-0.036905603,0.11711255,0.19609267,0.37447166,0.52505892,0.46394551,0.60847708,0.7788682,0.95730398,0.97239117,1.139408,1.313351,1.4059707,1.5916013,1.7586289,1.6266817,1.4794637,1.4135412,1.3064659,1.1191414,0.92855588,0.78797297,0.80470095,0.61625805,0.44266496,0.3453518,0.17853028,0.050664069,-0.027924269,-0.058571583,-0.19138523,-0.37769328,-0.55958365,-0.7202712,-0.82957356,-0.83531705,-1.0161597,-1.1915478,-1.3352435,-1.5385486,-1.5695548,-1.746322,-1.8764218,-1.6749116,-1.4888356,-1.2407918,-1.080186,-0.84533162,-0.61126324,-0.44304625,-0.34392898,-0.24257488,-0.062040696,0.10388087,0.33070131,0.45250392,0.64401733,0.80167835,1.010849,1.2471303,1.1882438,1.0297962,0.86945817,0.74683197,0.56054344,0.37970633,0.41791854,0.31295209,0.16528319,0.0060474812,-0.14373233,-0.076344837,-0.19603099,-0.33354565,-0.49622839,-0.53297809,-0.66229156,-0.79036997,-0.90202562,-1.0637146,-1.2341588,-1.1710562,-0.9781802,-0.78351671,-0.56847385,-0.40952309,-0.21196566,-0.085731227,0.082956851,0.26403956,0.43231004,0.57465859,0.66801454,0.87983936,1.053711,1.1851811,1.398076,1.5800641,1.7819009:1
1.8979121,1.8273904,1.6822481,1.5311783,1.3564904,1.194976,1.0393248,0.87354379,0.72936823,0.56605739,0.42760248,0.35076867,0.32021333,0.2548738,0.215653,0.13779493,0.072114033,0.073957138,0.024324933,0.035276752,0.060378156,0.040671318,0.066532408,0.065343138,0.081300882,0.069723052,0.12259194,0.10201909,0.11830687,0.14323037,0.15346269,0.14035758,0.070643704,0.010684536,-0.0053348474,0.020273309,0.014084893,0.16517696,0.18731304,0.30598497,0.38513984,0.39913672,0.44651959,0.44228467,0.39944178,0.36707186,0.31857111,0.34536939,0.38606923,0.45437276,0.51140063,0.44859704,0.45403822,0.50175168,0.55774279,0.55691139,0.57865574,0.62296761,0.66981179,0.74323791,0.71548449,0.54194159,0.35566073,0.17790289,0.049626091,-0.10265191,-0.18943243,-0.25833302,-0.27959205,-0.24928069,-0.18656494,-0.15526756,-0.099040253,-0.064476091,-0.015447656,0.035320174,-5.2599029E-4,-0.059734633,-0.07676908,0.013722372,0.1341968,0.2490921,0.32519705,0.378176,0.44798261,0.52403388,0.59638301,0.59863259,0.64310041,0.72790466,0.75748547,0.79943775,0.81799665,0.82002879,0.81652327,0.6868904,0.68055515,0.69253399,0.72796314,0.72633644,0.75433096,0.79558818,0.83196017,0.89554354,0.89165844,0.9630186,0.98000773,1.0019643,1.0486702,1.0638798,1.1598994,1.2045801,1.2586915,1.3161766,1.3373029,1.3385427,1.2086428,1.1157481,1.0006784,0.94606281,0.87732699,0.78139687,0.66762233,0.56989496,0.41867323,0.41816119,0.44646663,0.46902419,0.46539956,0.47158371,0.49130897,0.40922551,0.26291346,0.13777285,-0.011345214,-0.10938284,-0.034333872,-0.02930185,0.030203458,-0.077532891,-0.20998212,-0.34958338,-0.48751581,-0.61243253,-0.64917341,-0.79877369,-0.8870313,-1.0229239,-1.1560363,-1.2435358,-1.3461256,-1.4790897,-1.6127923,-1.6892254,-1.7451022,-1.8342949,-1.9666695,-2.1075541,-2.1893616,-2.2577188,-2.3827623,-2.4575524,-2.3952611,-2.3853416,-2.3404464,-2.2842275,-2.2155143,-2.1769474,-2.2236254,-2.1528616,-2.1502164,-2.0930999,-2.0730318,-1.954622,-1.8434502,-1.7303865,-1.617847,-1.4835228,-1.3739342,-1.2685895,-1.297761,-1.2159475,-1.1124728,-1.0226838,-0.98255263,-0.93290762,-0.88885252,-0.83203175,-0.83649307,-0.79209585,-0.91914423,-1.0402304,-1.0882544,-1.1401109,-1.1475844,-1.1222329,-1.0576904,-0.96846323,-0.83882617,-0.74484432,-0.65567798,-0.59663161,-0.53892985,-0.47296945,-0.35777403,-0.26227228,-0.14872018,-0.051899222,-0.044002842,-0.11357803,-0.035629687,0.086846124,0.13145873,0.24891794,0.35327097,0.47421221,0.61242216,0.74563961,0.86334827,0.93101392,0.87231475,0.72916825,0.57969283,0.42846232,0.33328735,0.20498512,0.084634856,-0.04679997,-0.17949542,-0.25866833,-0.2495523,-0.34275515,-0.47110437,-0.61378971,-0.75463292,-0.85136855,-0.98102982,-1.0196915,-0.98197656,-1.0312156,-0.96265597,-0.87547979,-0.79613697,-0.803919,-0.83384038,-0.95903745,-1.0784767,-1.2074209,-1.2515912,-1.2870075,-1.4138361,-1.5335965,-1.6570567,-1.7754727,-1.8953317,-1.9621693,-1.9058628,-1.968482,-2.0667976,-2.1553145,-2.1542531,-2.2318726,-2.3215988,-2.4086785,-2.4870048,-2.5551968,-2.4178595,-2.3624214,-2.2710659,-2.1277597,-2.020028,-1.8677414,-1.7066893,-1.5488601,-1.4071985,-1.2572171,-1.1386024,-1.0097606,-0.91758084,-0.87846987,-0.71257871,-0.55609326,-0.39991996,-0.30363269,-0.18759174,-0.060648373,-0.024848462,0.093035156,0.16932816,0.29937268,0.48540739,0.54862469,0.65328579,0.80909925,0.93630131,1.0814725,1.2059074,1.3356317,1.4301997,1.5569029,1.6982604,1.6853124,1.6313858,1.5694379,1.4882412,1.4143083,1.3268776,1.2514648,1.2658467,1.2375549,1.1553001,1.0711187,1.0054658,0.92286287,0.82099384,0.73449946,0.84275274,0.89763735,0.82327635,0.7319729,0.63528397,0.58833518,0.52963151,0.46324271,0.39751669,0.34053389,0.36793966,0.49186516,0.61194164,0.74816007,0.77491691,0.72690304,0.68710911,0.63396319,0.54531359,0.54608153,0.44142932,0.33329582,0.37468818,0.33348966,0.27518843,0.19903894,0.15620617,0.097224626,0.055868346,0.015770355,0.12923318,0.25870166,0.39233064,0.42879517,0.35952473,0.23369651,0.18805013,0.11056271,0.058469033,-0.0077613558,-0.05141315,-0.068065802,-0.082663773,-0.083377247,-0.017918654,0.0351097,0.12605078,0.15325221,0.25636168,0.37965155,0.52184673,0.65898818,0.78528586,0.91372884,0.97683999,0.95375368,0.95150542,0.94067884,0.91994323,1.0138776,0.99439235,0.95406541,0.90751945,0.8705936,0.83041785,0.76982335,0.83989194,0.94295451,0.93879092,0.89089268,0.90591374,0.88293795,0.81066364,0.72644772,0.66808725,0.59071666,0.55529763,0.55574057,0.54113689,0.50990858,0.49105871,0.45638067,0.39149191,0.43124706,0.41801116,0.35101452,0.33104273,0.34692317,0.30474333,0.28429337,0.27104697,0.28126915,0.26476897,0.27674818,0.28658964,0.27121009,0.26166806,0.24527105,0.23510877,0.30476562,0.32279932,0.46112473,0.61116854,0.76373656,0.92440314,1.0986334,1.2480907,1.3991013,1.5529669,1.7183191,1.8542652:3
2.8352118,2.7116007,2.564731,2.3262552,2.126201,1.9407849,1.7574933,1.5483903,1.3649935,1.2049506,1.0154153,0.85489261,0.65537324,0.5486982,0.36431994,0.16557193,-0.029666357,-0.20533648,-0.3920863,-0.61217999,-0.78241804,-0.98892766,-1.1973279,-1.4049905,-1.611716,-1.7777406,-2.0142735,-2.1179396,-2.185495,-2.3078132,-2.1811142,-2.0632,-2.0114983,-1.9173497,-1.806066,-1.681944,-1.5334356,-1.3762134,-1.2650726,-1.1894261,-1.0978546,-0.97879805,-0.83921046,-0.85044607,-0.76625854,-0.65286301,-0.5716632,-0.52602506,-0.43491548,-0.32633972,-0.32881296,-0.28029341,-0.22563941,-0.13980274,-0.050612389,0.0059030035,0.083324433,-0.017902469,-0.21515331,-0.27308184,-0.45573507,-0.63270324,-0.78067328,-0.78212146,-0.70521439,-0.68314536,-0.58020059,-0.58766988,-0.54704637,-0.43519498,-0.40935228,-0.4044038,-0.33043089,-0.26428141,-0.1838933,-0.095945858,-0.041040398,0.028366743,0.1041705,0.20091259,0.22732778,0.28128408,0.33433294,0.41733705,0.50075693,0.5760175,0.63834516,0.66870374,0.53867483,0.34292699,0.091979569,-0.060773488,-0.23597744,-0.42857274,-0.57118275,-0.76154941,-0.95212948,-1.0541923,-0.96874566,-0.91939229,-0.81892369,-0.7378268,-0.75949718,-0.71311036,-0.59366455,-0.489465,-0.38336781,-0.2793118,-0.15770697,-0.14320591,-0.048408124,0.020402654,0.14108031,0.24651625,0.36679423,0.4485237,0.50916666,0.52577133,0.630864,0.77540503,0.92084867,1.0817533,1.224649,1.3825806,1.4800381,1.4707542,1.2913834,1.110139,0.912154,0.78885083,0.64342692,0.44750392,0.28030923,0.3058399,0.21135231,0.039352938,-0.0640169,-0.19042861,-0.30957324,-0.44329257,-0.60336337,-0.79273229,-0.97901304,-1.1408386,-1.1247183,-0.94085127,-0.93833852,-0.77787574,-0.58214607,-0.72293233,-0.57542673,-0.39085754,-0.27754502,-0.10255512,0.024732234,-0.036852185,-0.092217821,-0.060561784,0.13021671,0.2672513,0.42034563,0.48697938,0.62126422,0.74442266,0.85463431,0.84829901,0.90397309,1.0459676,1.0349046,1.0921473,1.2405964,1.3238026,1.496564,1.6224372,1.7563842,1.7246782,1.5640079,1.3673907,1.2043899,1.0871577,0.99514927,0.81390704,0.65608076,0.53556762,0.40603354,0.27977832,0.11125987,-0.042085699,-0.056243882,-0.23893545,-0.39622407,-0.58901455,-0.74039953,-0.92613047,-0.73025426,-0.60656143,-0.51235643,-0.39683605,-0.37662527,-0.23443848,-0.12672828,-0.012820161,0.096055759,0.24646907,0.38859705,0.49542676,0.46922627,0.63221862,0.78978166,0.95401388,1.0947015,1.1718539,1.1054773,0.97670378,0.79064442,0.63335176,0.61554648,0.39918629,0.29753652,0.27829763,0.11659013,0.0693008,-0.090069527,-0.22716523,-0.27306718,-0.29366497,-0.50464148,-0.59911591,-0.65944114,-0.85853784,-1.0010415,-1.2091905,-1.2344507,-1.1465288,-1.1433035,-0.94343641,-0.79748826,-0.67481778,-0.58231366,-0.4119072,-0.22776186,-0.068906905,0.10996115,0.28775057,0.46354833,0.60338021,0.58383259,0.77139843,0.95815277,1.1177637,1.2981218,1.4937199,1.6555834,1.7729842,1.7498181,1.6463488,1.4998227,1.3806697,1.2584922,1.2613665,1.0917923,0.94578124,0.82080022,0.86187787,0.70638464,0.62189241,0.48602301,0.34474931,0.37888397,0.43973573,0.30340856,0.19469212,0.05461192,-0.09093436,-0.18964238,-0.3239663,-0.47137605,-0.58187699,-0.72494837,-0.8636354,-0.98379923,-1.0892692,-0.91070577,-0.74874814,-0.58556962,-0.3869479,-0.19432942,-0.034727946,0.14730664,0.34804387,0.43405379,0.62278179,0.77941406,1.0076054,1.2003247,1.4171751,1.2758442,1.1566676,1.0597794,0.92474309,0.82241207,0.69640622,0.73176873,0.67071336,0.53447282,0.49330703,0.38620261,0.30934741,0.21030132,0.1208746,0.30459067,0.26480809,0.17583316,0.084886495,0.046750169,-0.06412845,-0.14139759,-0.23165792,-0.32735712,-0.3867458,-0.49513491,-0.60588595,-0.72521176,-0.71481852,-0.53248719,-0.40552532,-0.25453756,-0.10611622,0.10945178,0.17912277,0.34344959,0.52167887,0.70872425,0.90139071,0.88748783,0.79123913,0.74635336,0.66956402,0.69409687,0.61085578,0.53519331,0.45803371,0.41448409,0.52205636,0.48885093,0.44883246,0.3916344,0.31912837,0.24714906,0.15783674,0.13647668,0.058789517,-0.10503065,-0.23912098,-0.26944933,-0.28864974,-0.098679477,0.089847141,0.29334583,0.50048117,0.64077465,0.49510502,0.41786039,0.36294159,0.2346836,0.12928685,0.17151321,0.065628067,-0.047450979,-0.12129549,-0.15648175,-0.23308461,-0.26075937,-0.38353312,-0.49712823,-0.48939456,-0.60412464,-0.75842459,-0.91126104,-1.0443705,-1.0669829,-1.1393882,-1.2526426,-1.3530015,-1.3945955,-1.5474536,-1.6909355,-1.8059144,-1.8534472,-2.0066677,-2.0980913,-2.2730676,-2.3428656,-2.4813296,-2.6658577,-2.837019,-2.744341,-2.6104388,-2.5765608,-2.3701222,-2.1861036,-2.0040407,-1.798416,-1.5907598,-1.3811623,-1.1877926,-1.0145331,-0.81118236,-0.60292827,-0.39635859,-0.21543597,-0.027174946,0.17108108,0.34359409,0.55198981,0.741873,0.92618532,1.1243931,1.3032861,1.5059341,1.6905007,1.881561,2.0830497,2.329014,2.5329151,2.6470421,2.7823922:1
1.4737383,1.4180468,1.3537391,1.2850665,1.2073229,1.1303364,1.0455736,0.95894985,0.88621615,0.78576305,0.71532379,0.64530009,0.54879499,0.45800704,0.37520934,0.27986806,0.17733468,0.064104413,-0.046497043,-0.17621366,-0.30648675,-0.43805287,-0.56744115,-0.67243331,-0.74867215,-0.73331795,-0.6340387,-0.54671751,-0.44602118,-0.35515781,-0.26190873,-0.16142384,-0.082372239,0.0082699154,0.078877728,0.15918451,0.23143614,0.30873432,0.37411207,0.44119873,0.49644281,0.5579793,0.58793377,0.53481432,0.50350808,0.46637982,0.43412258,0.38772902,0.34142682,0.29982629,0.23979354,0.17140021,0.10013233,0.023802411,-0.077341777,-0.18542774,-0.2918914,-0.39197637,-0.49205591,-0.58877954,-0.68714522,-0.7848363,-0.87637509,-0.96644782,-1.0639439,-1.1472277,-1.2290062,-1.3198653,-1.4101457,-1.4936736,-1.5732828,-1.6568576,-1.7241754,-1.7655428,-1.7028809,-1.6124912,-1.5030096,-1.4146238,-1.3045107,-1.2194479,-1.1067588,-1.0207218,-0.93292143,-0.82794575,-0.73214424,-0.63897387,-0.53083775,-0.42553958,-0.32018494,-0.21764115,-0.097216441,0.02118967,0.10315273,0.17487362,0.23869525,0.2698369,0.28343989,0.28805489,0.27456871,0.24106321,0.20603152,0.1648779,0.13117434,0.082314466,0.045151645,0.0023664446,-0.034640185,-0.082181026,-0.12286909,-0.16242979,-0.20522333,-0.24172411,-0.2700159,-0.28440955,-0.24761902,-0.21552606,-0.21600972,-0.24038565,-0.28136489,-0.33250882,-0.38414304,-0.44072179,-0.49240591,-0.54688203,-0.59449876,-0.63146857,-0.66091032,-0.70014333,-0.72209631,-0.74946265,-0.7595177,-0.79132426,-0.82277528,-0.85276074,-0.8741236,-0.88500109,-0.91700863,-0.93483344,-0.94169345,-0.96544127,-0.98466097,-0.99294584,-0.91413298,-0.8265192,-0.72371594,-0.63086469,-0.54193106,-0.44365731,-0.34024377,-0.25429776,-0.15114319,-0.058309911,0.044545875,0.12298614,0.18365764,0.26122671,0.30560648,0.35577497,0.41345516,0.4655622,0.51622848,0.551322,0.59818491,0.62291635,0.65163111,0.67466423,0.71275448,0.73458403,0.72926493,0.66264506,0.70231009,0.75639255,0.81550333,0.87034666,0.90940116,0.94072274,0.96383141,0.99025409,1.0355448,1.0957301,1.1613027,1.249096,1.3515414,1.4137827,1.4652589,1.5014801,1.5291684,1.5441386,1.5581109,1.5500204,1.5612493,1.5497668,1.5366012,1.5233703,1.509275,1.5785702,1.6643276,1.7937956,1.8991047,2.0058103,2.1370696,2.2356885,2.3030702,2.373042,2.4124609,2.3724542,2.3229534,2.2559325,2.1938192,2.1072903,2.0624222,1.942729,1.8140373,1.7398255,1.6390894,1.5227821,1.4074724,1.3282087,1.2777996,1.2738493,1.2119174,1.1737346,1.1216598,1.0691372,1.021659,0.9512917,0.87638922,0.8053246,0.72759008,0.64256778,0.56494087,0.47708074,0.40120303,0.32665059,0.27654109,0.24493933,0.22837015,0.18496176,0.14853756,0.11646927,0.082265319,0.046205408,0.011584262,-0.034040604,-0.10317625,-0.20374071,-0.25090818,-0.25438383,-0.25711452,-0.23912871,-0.23307798,-0.23401704,-0.21601703,-0.21917987,-0.22485353,-0.23670287,-0.25598236,-0.27317411,-0.30637471,-0.33293127,-0.36723886,-0.40406239,-0.44166279,-0.49660482,-0.56617983,-0.6235343,-0.7117805,-0.80687867,-0.90393167,-1.0040101,-1.0913574,-1.1930055,-1.2788023,-1.3776235,-1.4668597,-1.55869,-1.6442215,-1.6983315,-1.7877141,-1.8309191,-1.9101334,-1.9420599,-1.9635634,-1.9699576,-1.9569286,-1.9376419,-1.9165607,-1.8884964,-1.8632555,-1.8256492,-1.7967841,-1.7643379,-1.7190625,-1.6809378,-1.6364063,-1.5908554,-1.5390976,-1.4903687,-1.4349192,-1.3751289,-1.3216642,-1.2576332,-1.2039325,-1.1474495,-1.0833793,-1.0153546,-0.94711294,-0.87772601,-0.8019341,-0.73066828,-0.6584941,-0.58630962,-0.5117105,-0.44080874,-0.36347821,-0.29307844,-0.2181969,-0.14246854,-0.069378955,0.0056363283,0.070393189,0.12508198,0.14418523,0.10003738,0.049088836,-0.010988315,-0.045422331,0.019525136,0.092101266,0.16069047,0.23783941,0.31047247,0.37917095,0.44310105,0.50721571,0.55520368,0.59046502,0.63962916,0.60310517,0.5348098,0.44898605,0.33516159,0.22439019,0.11594883,0.0088457087,-0.096714389,-0.19654575,-0.30560701,-0.40345427,-0.50837788,-0.59214596,-0.69536932,-0.7992005,-0.89767028,-1.0004203,-1.1005633,-1.1877122,-1.2964668,-1.3837434,-1.4832697,-1.5754547,-1.6791645,-1.7640971,-1.7009788,-1.6127066,-1.5204417,-1.4194333,-1.3383965,-1.2324592,-1.1392492,-1.0469364,-0.94651734,-0.85785775,-0.75760664,-0.66983963,-0.56687886,-0.47472189,-0.37365173,-0.28215551,-0.1792849,-0.086245705,0.0072280877,0.10728565,0.21006372,0.30845405,0.39976759,0.50289819,0.60785736,0.70719598,0.80706648,0.92059451,1.0285037,1.1318363,1.1999414,1.2546325,1.2848402,1.2305224,1.1901732,1.1320447,1.0574671,0.98049553,0.90945598,0.83343099,0.7607266,0.69455964,0.62572636,0.55286387,0.49497251,0.42944964,0.47824255,0.5692051,0.66084566,0.76852782,0.87227961,0.97077368,1.065244,1.1577049,1.2279575,1.3115103,1.3760766,1.4402729,1.5058008,1.5410682,1.5280557,1.5140532,1.5036231,1.4952233:2
2.910374,2.7827415,2.6860742,2.5593022,2.4533958,2.3384284,2.2318286,2.1174723,2.0270172,1.9321021,1.8324824,1.706776,1.5880113,1.4953003,1.3702451,1.2455042,1.1458187,1.0290095,0.90422646,0.78088719,0.68986652,0.56602062,0.44335196,0.32043214,0.1980061,0.043579364,-0.059993556,-0.16935695,-0.28939307,-0.41109566,-0.54985189,-0.68788697,-0.80921296,-0.9380033,-1.0518143,-1.1398513,-1.2938691,-1.4149166,-1.5356811,-1.6817738,-1.7409985,-1.6805932,-1.6127889,-1.5358787,-1.4837588,-1.4189061,-1.3462411,-1.3144116,-1.22943,-1.135095,-1.0883209,-1.0156328,-0.95749415,-0.99778479,-0.94315558,-1.0049044,-1.0751626,-1.1392716,-1.1232397,-1.1258831,-1.0785445,-1.0095038,-0.92226288,-0.8138149,-0.75405899,-0.63806561,-0.55870964,-0.5900912,-0.63188868,-0.52579288,-0.45904717,-0.38487686,-0.29756897,-0.28467397,-0.28427508,-0.2278731,-0.15909761,-0.14368541,-0.064065262,-0.042053428,-0.084011896,-0.16398372,-0.274825,-0.36695553,-0.4650429,-0.54214922,-0.63019543,-0.7110349,-0.6706723,-0.61373115,-0.58046772,-0.52785949,-0.4550999,-0.36556404,-0.32017084,-0.29587096,-0.26927334,-0.17531256,-0.17658369,-0.10501948,-0.056803166,-0.0046850607,0.03290385,0.079820383,0.11965148,0.14815358,0.10938741,0.036999467,-0.016436932,-0.01206811,0.043256888,0.12614489,0.18316723,0.25013942,0.31781102,0.38910135,0.45084658,0.4727069,0.52483214,0.48526343,0.44245098,0.50145126,0.55461914,0.63854585,0.73012643,0.81440312,0.85857617,0.8734378,0.95641882,1.0300962,1.121569,1.1578121,1.1801789,1.1339179,1.0292075,0.92679875,0.8160288,0.74950348,0.6475742,0.53452983,0.42493801,0.39990836,0.28291804,0.18098249,0.066152678,-0.037703617,-0.14376182,-0.21001025,-0.21426063,-0.32220578,-0.44669261,-0.55359458,-0.66012019,-0.78098214,-0.88483341,-1.0189098,-1.1282235,-1.2117942,-1.3010899,-1.4181114,-1.3817835,-1.3363301,-1.2601232,-1.2053012,-1.0916542,-0.97723253,-0.85096597,-0.7781737,-0.7099189,-0.74166862,-0.67285376,-0.58961724,-0.48455266,-0.35665331,-0.31466734,-0.23828091,-0.14540354,-0.051504727,0.040437628,0.094073348,0.060344524,-0.022281194,-0.040781498,-0.037670375,0.092634093,0.18817309,0.28087495,0.37653587,0.40379516,0.52106286,0.61175304,0.59605328,0.68620762,0.80827137,0.89399069,1.0042431,1.0825087,1.133039,1.2122565,1.3361534,1.4527047,1.5921097,1.6803697,1.660582,1.5916941,1.4962318,1.3985303,1.2814505,1.1553057,1.0948544,1.0288572,0.91774438,0.79615353,0.67792452,0.67453392,0.68106937,0.70402689,0.62359732,0.52798341,0.44591246,0.3697504,0.2591905,0.17660967,0.15584233,0.052281235,-0.059350062,-0.11373542,-0.036894247,-0.03497795,0.012295761,0.089807876,0.17668957,0.23042566,0.19632251,0.15734441,0.10713686,0.034148501,-0.029614801,-0.13842936,-0.25338745,-0.28167694,-0.3974616,-0.54160875,-0.6584493,-0.68810479,-0.77944878,-0.87021672,-0.95607975,-1.0519994,-1.1747288,-1.2832468,-1.380468,-1.4626207,-1.4836757,-1.3671729,-1.2632334,-1.1560025,-1.1198528,-1.0407674,-0.93161111,-0.83088115,-0.72257505,-0.59540837,-0.49254645,-0.38849078,-0.31820413,-0.19015739,-0.19592566,-0.15128418,-0.041578529,0.064958047,0.17619952,0.28174157,0.3938806,0.51443446,0.62390371,0.57646687,0.61341293,0.65733227,0.69480558,0.79658232,0.90098484,1.002324,1.1082938,1.2259821,1.3259247,1.4438106,1.4702108,1.42275,1.3327609,1.2449006,1.1603836,1.1087362,1.0473536,0.94968433,0.86840412,0.76337522,0.67536924,0.58871034,0.61336719,0.57208285,0.48770081,0.39644945,0.30053141,0.31659006,0.24913103,0.15365345,0.075912242,-0.0031824622,-0.079486543,-0.0023773088,0.081678407,0.11551386,0.05038439,0.022385577,-0.043070863,-0.062176621,-0.13515026,-0.20727179,-0.28134539,-0.3541603,-0.41106911,-0.4446852,-0.3461086,-0.26087507,-0.30176822,-0.37169581,-0.42890243,-0.50187962,-0.55173855,-0.6363922,-0.73509381,-0.7569592,-0.6824817,-0.60259668,-0.50382902,-0.40613925,-0.30774804,-0.20422893,-0.076371152,-0.037538069,0.079464369,0.1031926,0.050364344,-0.0054603965,-0.073591146,-0.11211129,-0.19525568,-0.27206161,-0.35064912,-0.40492901,-0.31365977,-0.37891496,-0.43424871,-0.54119067,-0.60203616,-0.67777928,-0.61480711,-0.65204741,-0.73036449,-0.85045511,-0.939566,-0.85705704,-0.80021584,-0.84281866,-0.93922964,-1.0004522,-1.0216652,-1.0669431,-1.1164327,-1.1722675,-1.2274977,-1.3023037,-1.3840368,-1.4273662,-1.5170765,-1.5162502,-1.5662575,-1.6514856,-1.6737565,-1.7673973,-1.8233839,-1.8708774,-1.919793,-1.9714351,-1.9706001,-1.8535019,-1.7325123,-1.577249,-1.4235814,-1.26997,-1.1165068,-0.96359972,-0.81476013,-0.69151293,-0.57115503,-0.4373363,-0.30016211,-0.18012219,-0.06006163,0.060146013,0.18153777,0.30132671,0.42228367,0.54345469,0.66487163,0.78665761,0.9087157,1.0097953,1.120246,1.2431826,1.3614656,1.4736711,1.5817524,1.7036768,1.816513,1.92059,2.0376508,2.1353403,2.2606158,2.3744112,2.4777142,2.5938269,2.6989176,2.821553,2.8895004,2.9071083:3
