/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.datanode;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;

public class UpdateDataNodePlan
extends ConfigPhysicalPlan {
    private TDataNodeConfiguration dataNodeConfiguration;

    public UpdateDataNodePlan() {
        super(ConfigPhysicalPlanType.UpdateDataNodeConfiguration);
    }

    public UpdateDataNodePlan(TDataNodeConfiguration dataNodeConfiguration) {
        this();
        this.dataNodeConfiguration = dataNodeConfiguration;
    }

    public TDataNodeConfiguration getDataNodeConfiguration() {
        return this.dataNodeConfiguration;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        ThriftCommonsSerDeUtils.serializeTDataNodeConfiguration((TDataNodeConfiguration)this.dataNodeConfiguration, (DataOutputStream)stream);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) {
        this.dataNodeConfiguration = ThriftCommonsSerDeUtils.deserializeTDataNodeConfiguration((ByteBuffer)buffer);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!this.getType().equals((Object)((UpdateDataNodePlan)o).getType())) {
            return false;
        }
        UpdateDataNodePlan that = (UpdateDataNodePlan)o;
        return this.dataNodeConfiguration.equals(that.dataNodeConfiguration);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.getType(), this.dataNodeConfiguration});
    }
}

