/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.stream;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.apache.james.mime4j.ExampleMail;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.stream.EntityState;
import org.apache.james.mime4j.stream.MimeTokenStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MimeTokenStreamReaderTest {
    MimeTokenStream parser;

    @Before
    public void setUp() throws Exception {
        this.parser = new MimeTokenStream();
    }

    @Test
    public void testShouldReadSimpleBody() throws Exception {
        byte[] bytes = ExampleMail.RFC822_SIMPLE_BYTES;
        String body = "This is a very simple email.\r\n";
        this.checkSimpleMail(bytes, body, 4);
    }

    @Test
    public void testShouldReadOnePartMimeASCIIBody() throws Exception {
        byte[] bytes = ExampleMail.ONE_PART_MIME_ASCII_BYTES;
        String body = "A single part MIME mail.\r\n";
        this.checkSimpleMail(bytes, body, 11);
    }

    @Test
    public void testShouldReadOnePartMime8859Body() throws Exception {
        byte[] bytes = ExampleMail.ONE_PART_MIME_8859_BYTES;
        String body = "M\u00f6nchengladbach\r\n";
        this.checkSimpleMail(bytes, body, 13);
    }

    @Test
    public void testShouldReadOnePartMimeBase64ASCIIBody() throws Exception {
        byte[] bytes = ExampleMail.ONE_PART_MIME_BASE64_ASCII_BYTES;
        String body = "Hello, World!\r\n";
        this.checkSimpleMail(bytes, body, 11);
    }

    @Test
    public void testShouldReadOnePartMimeBase64Latin1Body() throws Exception {
        byte[] bytes = ExampleMail.ONE_PART_MIME_BASE64_LATIN1_BYTES;
        String body = "Hello Mo\u00f6nchengladbach\r\n";
        this.checkSimpleMail(bytes, body, 11);
    }

    @Test
    public void testShouldReadOnePartMimeQuotedPrintable() throws Exception {
        byte[] bytes = ExampleMail.ONE_PART_MIME_QUOTED_PRINTABLE_ASCII_BYTES;
        String body = "Sonnet LXXXI By William Shakespeare\r\nOr I shall live your epitaph to make,\r\nOr you survive when I in earth am rotten;\r\nFrom hence your memory death cannot take,\r\nAlthough in me each part will be forgotten.\r\nYour name from hence immortal life shall have,\r\nThough I, once gone, to all the world must die:\r\nThe earth can yield me but a common grave,\r\nWhen you entombed in men's eyes shall lie.\r\nYour monument shall be my gentle verse,\r\nWhich eyes not yet created shall o'er-read;\r\nAnd tongues to be, your being shall rehearse,\r\nWhen all the breathers of this world are dead;\r\n  You still shall live,--such virtue hath my pen,--\r\n  Where breath most breathes, even in the mouths of men.\r\n";
        this.checkSimpleMail(bytes, body, 11);
    }

    @Test
    public void testShouldReadPartBodies() throws IOException, MimeException {
        ByteArrayInputStream in = new ByteArrayInputStream(ExampleMail.MIME_MIXED_MULTIPART_VARIOUS_ENCODINGS_BYTES);
        this.parser.parse((InputStream)in);
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_START_HEADER), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        for (int i = 0; i < 5; ++i) {
            Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_FIELD), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        }
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_END_HEADER), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_START_MULTIPART), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_PREAMBLE), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_START_BODYPART), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_START_HEADER), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_FIELD), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_FIELD), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_END_HEADER), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_BODY), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        this.checkBody("Sonnet XXXIII By William Shakespeare\r\n\r\nFull many a glorious morning have I seen\r\nFlatter the mountain tops with sovereign eye,\r\nKissing with golden face the meadows green,\r\nGilding pale streams with heavenly alchemy;\r\nAnon permit the basest clouds to ride\r\nWith ugly rack on his celestial face,\r\nAnd from the forlorn world his visage hide,\r\nStealing unseen to west with this disgrace:\r\nEven so my sun one early morn did shine,\r\nWith all triumphant splendour on my brow;\r\nBut out! alack! he was but one hour mine,\r\nThe region cloud hath mask'd him from me now.\r\n  Yet him for this my love no whit disdaineth;\r\n  Suns of the world may stain when heaven's sun staineth.\r\n");
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_END_BODYPART), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_START_BODYPART), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_START_HEADER), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_FIELD), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_FIELD), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_END_HEADER), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_BODY), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        this.checkBody("Sonnet XXXV By William Shakespeare\r\n\r\nNo more be griev'd at that which thou hast done:\r\nRoses have thorns, and silver fountains mud:\r\nClouds and eclipses stain both moon and sun,\r\nAnd loathsome canker lives in sweetest bud.\r\nAll men make faults, and even I in this,\r\nAuthorizing thy trespass with compare,\r\nMyself corrupting, salving thy amiss,\r\nExcusing thy sins more than thy sins are;\r\nFor to thy sensual fault I bring in sense,--\r\nThy adverse party is thy advocate,--\r\nAnd 'gainst myself a lawful plea commence:\r\nSuch civil war is in my love and hate,\r\n  That I an accessary needs must be,\r\n  To that sweet thief which sourly robs from me.\r\n");
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_END_BODYPART), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_START_BODYPART), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_START_HEADER), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_FIELD), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_FIELD), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_END_HEADER), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_BODY), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        this.checkBody("Sonnet XXXVIII By William Shakespeare\r\n\r\nHow can my muse want subject to invent,\r\nWhile thou dost breathe, that pour'st into my verse\r\nThine own sweet argument, too excellent\r\nFor every vulgar paper to rehearse?\r\nO! give thy self the thanks, if aught in me\r\nWorthy perusal stand against thy sight;\r\nFor who's so dumb that cannot write to thee,\r\nWhen thou thy self dost give invention light?\r\nBe thou the tenth Muse, ten times more in worth\r\nThan those old nine which rhymers invocate;\r\nAnd he that calls on thee, let him bring forth\r\nEternal numbers to outlive long date.\r\n  If my slight muse do please these curious days,\r\n  The pain be mine, but thine shall be the praise.\r\n");
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_END_BODYPART), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
    }

    private void checkSimpleMail(byte[] bytes, String body, int fields) throws IOException, MimeException {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        this.parser.parse((InputStream)in);
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_START_HEADER), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        for (int i = 0; i < fields; ++i) {
            Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_FIELD), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        }
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_END_HEADER), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_BODY), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        this.checkBody(body);
    }

    private void checkBody(String body) throws IOException {
        Reader reader = this.parser.getReader();
        Assert.assertNotNull((Object)reader);
        Assert.assertEquals((Object)body, (Object)IOUtils.toString((Reader)reader));
    }
}

