/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.api.TimeMetric;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.CommandHandler;
import org.apache.james.protocols.api.handler.ExtensibleHandler;
import org.apache.james.protocols.api.handler.LineHandler;
import org.apache.james.protocols.api.handler.WiringException;
import org.apache.james.protocols.smtp.MailEnvelope;
import org.apache.james.protocols.smtp.MailEnvelopeImpl;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.DataLineFilter;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.util.MDCBuilder;

public class DataCmdHandler
implements CommandHandler<SMTPSession>,
ExtensibleHandler {
    private static final Response NO_RECIPIENT = new SMTPResponse("503", DSNStatus.getStatus(5, "5.0") + " No recipients specified").immutable();
    private static final Response NO_SENDER = new SMTPResponse("503", DSNStatus.getStatus(5, "5.0") + " No sender specified").immutable();
    private static final Response UNEXPECTED_ARG = new SMTPResponse("500", DSNStatus.getStatus(5, "5.4") + " Unexpected argument provided with DATA command").immutable();
    private static final Response DATA_READY = new SMTPResponse("354", "Ok Send data ending with <CRLF>.<CRLF>").immutable();
    private static final Collection<String> COMMANDS = ImmutableSet.of((Object)"DATA");
    public static final ProtocolSession.AttachmentKey<MailEnvelope> MAILENV = ProtocolSession.AttachmentKey.of((String)"MAILENV", MailEnvelope.class);
    private final MetricFactory metricFactory;
    private LineHandler<SMTPSession> lineHandler;

    @Inject
    public DataCmdHandler(MetricFactory metricFactory) {
        this.metricFactory = metricFactory;
    }

    public Response onCommand(SMTPSession session, Request request) {
        TimeMetric timeMetric = this.metricFactory.timer("SMTP-" + request.getCommand());
        session.stopDetectingCommandInjection();
        try {
            Response response;
            block15: {
                Response response2;
                Closeable closeable;
                block13: {
                    Response response3;
                    block14: {
                        closeable = MDCBuilder.create().addToContext("action", request.getCommand()).build();
                        try {
                            String parameters = request.getArgument();
                            response2 = this.doDATAFilter(session, parameters);
                            if (response2 != null) break block13;
                            response3 = this.doDATA(session, parameters);
                            if (closeable == null) break block14;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (closeable != null) {
                                    try {
                                        closeable.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        closeable.close();
                    }
                    return response3;
                }
                response = response2;
                if (closeable == null) break block15;
                closeable.close();
            }
            return response;
        }
        finally {
            timeMetric.stopAndPublish();
            session.needsCommandInjectionDetection();
        }
    }

    protected Response doDATA(SMTPSession session, String argument) {
        MaybeSender sender = session.getAttachment(SMTPSession.SENDER, ProtocolSession.State.Transaction).orElse(MaybeSender.nullSender());
        MailEnvelope env = this.createEnvelope(sender, (List)session.getAttachment(SMTPSession.RCPT_LIST, ProtocolSession.State.Transaction).orElse(ImmutableList.of()));
        session.setAttachment(MAILENV, env, ProtocolSession.State.Transaction);
        session.pushLineHandler(this.lineHandler);
        return DATA_READY;
    }

    protected MailEnvelope createEnvelope(MaybeSender sender, List<MailAddress> recipients) {
        MailEnvelopeImpl env = new MailEnvelopeImpl();
        env.setRecipients(recipients);
        env.setSender(sender);
        return env;
    }

    public Collection<String> getImplCommands() {
        return COMMANDS;
    }

    public List getMarkerInterfaces() {
        LinkedList<Class<DataLineFilter>> classes = new LinkedList<Class<DataLineFilter>>();
        classes.add(DataLineFilter.class);
        return classes;
    }

    public void wireExtensions(Class interfaceName, List extension) throws WiringException {
        if (DataLineFilter.class.equals((Object)interfaceName)) {
            Object lineHandler = new DataConsumerLineHandler();
            for (int i = extension.size() - 1; i >= 0; --i) {
                lineHandler = new DataLineFilterWrapper((DataLineFilter)extension.get(i), (LineHandler<SMTPSession>)lineHandler);
            }
            this.lineHandler = lineHandler;
        }
    }

    protected Response doDATAFilter(SMTPSession session, String argument) {
        if (argument != null && argument.length() > 0) {
            return UNEXPECTED_ARG;
        }
        if (!session.getAttachment(SMTPSession.SENDER, ProtocolSession.State.Transaction).isPresent()) {
            return NO_SENDER;
        }
        if (!session.getAttachment(SMTPSession.RCPT_LIST, ProtocolSession.State.Transaction).isPresent()) {
            return NO_RECIPIENT;
        }
        return null;
    }

    protected LineHandler<SMTPSession> getLineHandler() {
        return this.lineHandler;
    }

    public static final class DataLineFilterWrapper
    implements LineHandler<SMTPSession> {
        private final DataLineFilter filter;
        private final LineHandler<SMTPSession> next;

        public DataLineFilterWrapper(DataLineFilter filter, LineHandler<SMTPSession> next) {
            this.filter = filter;
            this.next = next;
        }

        public Response onLine(SMTPSession session, byte[] line) {
            return this.filter.onLine(session, line, this.next);
        }
    }

    public static final class DataConsumerLineHandler
    implements LineHandler<SMTPSession> {
        public SMTPResponse onLine(SMTPSession session, byte[] line) {
            if (line.length == 3 && line[0] == 46) {
                session.popLineHandler();
            }
            return null;
        }
    }
}

