/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.vault.routes;

import java.time.Clock;
import java.time.Instant;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;
import org.apache.james.vault.DeletedMessageVault;
import org.apache.james.webadmin.vault.routes.DeletedMessagesVaultDeleteTaskDTO;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class DeletedMessagesVaultDeleteTask
implements Task {
    public static final TaskType TYPE = TaskType.of((String)"deleted-messages-delete");
    private final DeletedMessageVault vault;
    private final Username username;
    private final MessageId messageId;

    DeletedMessagesVaultDeleteTask(DeletedMessageVault vault, Username username, MessageId messageId) {
        this.vault = vault;
        this.username = username;
        this.messageId = messageId;
    }

    public Task.Result run() {
        return Mono.from((Publisher)this.vault.delete(this.username, this.messageId)).doOnError(e -> LOGGER.error("Error while deleting message {} for user {} in DeletedMessageVault: {}", new Object[]{this.messageId, this.username, e})).thenReturn((Object)Task.Result.COMPLETED).blockOptional().orElse(Task.Result.PARTIAL);
    }

    public TaskType type() {
        return TYPE;
    }

    MessageId getMessageId() {
        return this.messageId;
    }

    Username getUsername() {
        return this.username;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(new AdditionalInformation(this.username, this.messageId, Clock.systemUTC().instant()));
    }

    public static class AdditionalInformation
    implements TaskExecutionDetails.AdditionalInformation {
        private final Username username;
        private final MessageId deleteMessageId;
        private final Instant timestamp;

        AdditionalInformation(Username username, MessageId deleteMessageId, Instant timestamp) {
            this.username = username;
            this.deleteMessageId = deleteMessageId;
            this.timestamp = timestamp;
        }

        public String getUsername() {
            return this.username.asString();
        }

        public String getDeleteMessageId() {
            return this.deleteMessageId.serialize();
        }

        public Instant timestamp() {
            return this.timestamp;
        }
    }

    public static class Factory {
        private final DeletedMessageVault deletedMessageVault;
        private final MessageId.Factory messageIdFactory;

        @Inject
        public Factory(DeletedMessageVault deletedMessageVault, MessageId.Factory messageIdFactory) {
            this.deletedMessageVault = deletedMessageVault;
            this.messageIdFactory = messageIdFactory;
        }

        public DeletedMessagesVaultDeleteTask create(DeletedMessagesVaultDeleteTaskDTO dto) {
            MessageId messageId = this.messageIdFactory.fromString(dto.getMessageId());
            Username username = Username.of((String)dto.getUserName());
            return new DeletedMessagesVaultDeleteTask(this.deletedMessageVault, username, messageId);
        }
    }
}

