/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.method;

import eu.timepit.refined.api.RefType$;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.boolean;
import eu.timepit.refined.collection;
import eu.timepit.refined.string;
import java.io.Serializable;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.jmap.core.Properties;
import org.apache.james.jmap.core.Properties$;
import org.apache.james.jmap.core.SetError;
import org.apache.james.jmap.core.SetError$;
import org.apache.james.jmap.json.MailboxSerializer;
import org.apache.james.jmap.mail.InvalidPatchException;
import org.apache.james.jmap.mail.InvalidPropertyException;
import org.apache.james.jmap.mail.InvalidUpdateException;
import org.apache.james.jmap.mail.IsSubscribed;
import org.apache.james.jmap.mail.IsSubscribedUpdate;
import org.apache.james.jmap.mail.MailboxGet$;
import org.apache.james.jmap.mail.MailboxPatchObject;
import org.apache.james.jmap.mail.MailboxSetRequest;
import org.apache.james.jmap.mail.MailboxSetResponse$;
import org.apache.james.jmap.mail.MailboxUpdateResponse;
import org.apache.james.jmap.mail.NameUpdate;
import org.apache.james.jmap.mail.ParentIdUpdate;
import org.apache.james.jmap.mail.ServerSetPropertyException;
import org.apache.james.jmap.mail.UnparsedMailboxId;
import org.apache.james.jmap.mail.UnsupportedPropertyUpdatedException;
import org.apache.james.jmap.mail.ValidatedMailboxPatchObject;
import org.apache.james.jmap.method.LoopInMailboxGraphException;
import org.apache.james.jmap.method.MailboxSetUpdatePerformer$MailboxUpdateResults$;
import org.apache.james.jmap.method.SystemMailboxChangeException;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.Role;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.exception.InsufficientRightsException;
import org.apache.james.mailbox.exception.MailboxExistsException;
import org.apache.james.mailbox.exception.MailboxNameException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxMetaData;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.search.MailboxNameExpression;
import org.apache.james.mailbox.model.search.MailboxQuery;
import org.apache.james.mailbox.model.search.PrefixedWildcard;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.duration.Duration;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0011\rr!B0a\u0011\u0003Yg!B7a\u0011\u0003q\u0007\"B;\u0002\t\u00031haB<\u0002!\u0003\r\n\u0003\u001f\u0004\u0007\u0003\u007f\f\u0001I!\u0001\t\u0015\u0005mAA!f\u0001\n\u0003\u0011\u0019\u0001\u0003\u0006\u0002,\u0011\u0011\t\u0012)A\u0005\u0005\u000bAa!\u001e\u0003\u0005\u0002\tU\u0001\"CA;\t\u0005\u0005I\u0011\u0001B\u000e\u0011%\ty\bBI\u0001\n\u0003\u0011y\u0002C\u0005\u0002$\u0012\t\t\u0011\"\u0011\u0002&\"I\u0011q\u0017\u0003\u0002\u0002\u0013\u0005\u0011\u0011\u0018\u0005\n\u0003\u0003$\u0011\u0011!C\u0001\u0005GA\u0011\"a4\u0005\u0003\u0003%\t%!5\t\u0013\u0005}G!!A\u0005\u0002\t\u001d\u0002\"CAv\t\u0005\u0005I\u0011\tB\u0016\u0011%\t\t\u0010BA\u0001\n\u0003\n\u0019\u0010C\u0005\u0002v\u0012\t\t\u0011\"\u0011\u0002x\"I\u0011\u0011 \u0003\u0002\u0002\u0013\u0005#qF\u0004\n\u0005g\t\u0011\u0011!E\u0001\u0005k1\u0011\"a@\u0002\u0003\u0003E\tAa\u000e\t\rU$B\u0011\u0001B(\u0011%\t)\u0010FA\u0001\n\u000b\n9\u0010C\u0005\u0003RQ\t\t\u0011\"!\u0003T!I!q\u000b\u000b\u0002\u0002\u0013\u0005%\u0011\f\u0005\n\u0005C\"\u0012\u0011!C\u0005\u0005G2AA_\u0001Aw\"Q\u00111\u0004\u000e\u0003\u0016\u0004%\t!!\b\t\u0015\u0005-\"D!E!\u0002\u0013\ty\u0002\u0003\u0006\u0002.i\u0011)\u001a!C\u0001\u0003_A!\"a\u000e\u001b\u0005#\u0005\u000b\u0011BA\u0019\u0011)\tID\u0007BK\u0002\u0013\u0005\u00111\b\u0005\u000b\u0003\u0013R\"\u0011#Q\u0001\n\u0005u\u0002BB;\u001b\t\u0003\tY\u0005C\u0004\u0002Vi!\t!a\u0016\t\u000f\u0005-$\u0004\"\u0001\u0002n!I\u0011Q\u000f\u000e\u0002\u0002\u0013\u0005\u0011q\u000f\u0005\n\u0003\u007fR\u0012\u0013!C\u0001\u0003\u0003C\u0011\"a&\u001b#\u0003%\t!!'\t\u0013\u0005u%$%A\u0005\u0002\u0005}\u0005\"CAR5\u0005\u0005I\u0011IAS\u0011%\t9LGA\u0001\n\u0003\tI\fC\u0005\u0002Bj\t\t\u0011\"\u0001\u0002D\"I\u0011q\u001a\u000e\u0002\u0002\u0013\u0005\u0013\u0011\u001b\u0005\n\u0003?T\u0012\u0011!C\u0001\u0003CD\u0011\"a;\u001b\u0003\u0003%\t%!<\t\u0013\u0005E($!A\u0005B\u0005M\b\"CA{5\u0005\u0005I\u0011IA|\u0011%\tIPGA\u0001\n\u0003\nYpB\u0005\u0003l\u0005\t\t\u0011#\u0001\u0003n\u0019A!0AA\u0001\u0012\u0003\u0011y\u0007\u0003\u0004ve\u0011\u0005!q\u000f\u0005\n\u0003k\u0014\u0014\u0011!C#\u0003oD\u0011B!\u00153\u0003\u0003%\tI!\u001f\t\u0013\t]#'!A\u0005\u0002\n\u0005\u0005\"\u0003B1e\u0005\u0005I\u0011\u0002B2\r\u0019\u0011i)\u0001!\u0003\u0010\"Q!\u0011\u0013\u001d\u0003\u0016\u0004%\tAa%\t\u0015\tm\u0005H!E!\u0002\u0013\u0011)\n\u0003\u0004vq\u0011\u0005!Q\u0014\u0005\b\u0005GCD\u0011\u0001BS\u0011\u001d\u0011i\f\u000fC\u0001\u0005\u007fC\u0011\"!\u001e9\u0003\u0003%\tAa1\t\u0013\u0005}\u0004(%A\u0005\u0002\t\u001d\u0007\"CARq\u0005\u0005I\u0011IAS\u0011%\t9\fOA\u0001\n\u0003\tI\fC\u0005\u0002Bb\n\t\u0011\"\u0001\u0003L\"I\u0011q\u001a\u001d\u0002\u0002\u0013\u0005\u0013\u0011\u001b\u0005\n\u0003?D\u0014\u0011!C\u0001\u0005\u001fD\u0011\"a;9\u0003\u0003%\tEa5\t\u0013\u0005E\b(!A\u0005B\u0005M\b\"CA{q\u0005\u0005I\u0011IA|\u0011%\tI\u0010OA\u0001\n\u0003\u00129nB\u0005\u0003\\\u0006\t\t\u0011#\u0001\u0003^\u001aI!QR\u0001\u0002\u0002#\u0005!q\u001c\u0005\u0007k*#\tAa9\t\u0013\u0005U(*!A\u0005F\u0005]\b\"\u0003B)\u0015\u0006\u0005I\u0011\u0011Bs\u0011%\u00119FSA\u0001\n\u0003\u0013I\u000fC\u0005\u0003b)\u000b\t\u0011\"\u0003\u0003d\u0019)Q\u000e\u0019\u0001\u0003p\"Q!\u0011\u001f)\u0003\u0002\u0003\u0006IAa=\t\u0015\t}\bK!A!\u0002\u0013\u0019\t\u0001\u0003\u0006\u0004\nA\u0013\t\u0011)A\u0005\u0007\u0017A!b!\u0005Q\u0005\u0003\u0005\u000b\u0011BB\n\u0011\u0019)\b\u000b\"\u0001\u0004\"!91q\b)\u0005\u0002\r\u0005\u0003bBBP!\u0012%1\u0011\u0015\u0005\b\u0007s\u0003F\u0011BB^\u0011\u001d\u0019)\r\u0015C\u0005\u0007\u000fDqa!5Q\t\u0013\u0019\u0019\u000eC\u0004\u0004rB#Iaa=\t\u000f\rE\u0007\u000b\"\u0003\u0005\u0004!9AQ\u0002)\u0005\n\u0011=\u0001b\u0002C\f!\u0012%A\u0011D\u0001\u001a\u001b\u0006LGNY8y'\u0016$X\u000b\u001d3bi\u0016\u0004VM\u001d4pe6,'O\u0003\u0002bE\u00061Q.\u001a;i_\u0012T!a\u00193\u0002\t)l\u0017\r\u001d\u0006\u0003K\u001a\fQA[1nKNT!a\u001a5\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0017aA8sO\u000e\u0001\u0001C\u00017\u0002\u001b\u0005\u0001'!G'bS2\u0014w\u000e_*fiV\u0003H-\u0019;f!\u0016\u0014hm\u001c:nKJ\u001c\"!A8\u0011\u0005A\u001cX\"A9\u000b\u0003I\fQa]2bY\u0006L!\u0001^9\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t1NA\nNC&d'm\u001c=Va\u0012\fG/\u001a*fgVdGo\u0005\u0002\u0004_&\u001a1A\u0007\u0003\u0003)5\u000b\u0017\u000e\u001c2pqV\u0003H-\u0019;f\r\u0006LG.\u001e:f'\u0019Qr\u000e @\u0002\u0004A\u0011QpA\u0007\u0002\u0003A\u0011\u0001o`\u0005\u0004\u0003\u0003\t(a\u0002)s_\u0012,8\r\u001e\t\u0005\u0003\u000b\t)B\u0004\u0003\u0002\b\u0005Ea\u0002BA\u0005\u0003\u001fi!!a\u0003\u000b\u0007\u00055!.\u0001\u0004=e>|GOP\u0005\u0002e&\u0019\u00111C9\u0002\u000fA\f7m[1hK&!\u0011qCA\r\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\r\t\u0019\"]\u0001\n[\u0006LGNY8y\u0013\u0012,\"!a\b\u0011\t\u0005\u0005\u0012qE\u0007\u0003\u0003GQ1!!\nc\u0003\u0011i\u0017-\u001b7\n\t\u0005%\u00121\u0005\u0002\u0012+:\u0004\u0018M]:fI6\u000b\u0017\u000e\u001c2pq&#\u0017AC7bS2\u0014w\u000e_%eA\u0005IQ\r_2faRLwN\\\u000b\u0003\u0003c\u0001B!!\u0002\u00024%!\u0011QGA\r\u0005%!\u0006N]8xC\ndW-\u0001\u0006fq\u000e,\u0007\u000f^5p]\u0002\nQ\u0001]1uG\",\"!!\u0010\u0011\u000bA\fy$a\u0011\n\u0007\u0005\u0005\u0013O\u0001\u0004PaRLwN\u001c\t\u0005\u0003C\t)%\u0003\u0003\u0002H\u0005\r\"a\u0007,bY&$\u0017\r^3e\u001b\u0006LGNY8y!\u0006$8\r[(cU\u0016\u001cG/\u0001\u0004qCR\u001c\u0007\u000e\t\u000b\t\u0003\u001b\ny%!\u0015\u0002TA\u0011QP\u0007\u0005\b\u00037\t\u0003\u0019AA\u0010\u0011\u001d\ti#\ta\u0001\u0003cAq!!\u000f\"\u0001\u0004\ti$\u0001\u0004gS2$XM\u001d\u000b\u0005\u00033\n9\u0007E\u0003q\u0003\u007f\tY\u0006\u0005\u0003\u0002^\u0005\rTBAA0\u0015\r\t\tGY\u0001\u0005G>\u0014X-\u0003\u0003\u0002f\u0005}#A\u0003)s_B,'\u000f^5fg\"9\u0011\u0011\u000e\u0012A\u0002\u0005m\u0013\u0001F1dG\u0016\u0004H/\u00192mKB\u0013x\u000e]3si&,7/A\tbg6\u000b\u0017\u000e\u001c2pqN+G/\u0012:s_J,\"!a\u001c\u0011\t\u0005u\u0013\u0011O\u0005\u0005\u0003g\nyF\u0001\u0005TKR,%O]8s\u0003\u0011\u0019w\u000e]=\u0015\u0011\u00055\u0013\u0011PA>\u0003{B\u0011\"a\u0007%!\u0003\u0005\r!a\b\t\u0013\u00055B\u0005%AA\u0002\u0005E\u0002\"CA\u001dIA\u0005\t\u0019AA\u001f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a!+\t\u0005}\u0011QQ\u0016\u0003\u0003\u000f\u0003B!!#\u0002\u00146\u0011\u00111\u0012\u0006\u0005\u0003\u001b\u000by)A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011S9\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0016\u0006-%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAANU\u0011\t\t$!\"\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011\u0011\u0015\u0016\u0005\u0003{\t))A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003O\u0003B!!+\u000246\u0011\u00111\u0016\u0006\u0005\u0003[\u000by+\u0001\u0003mC:<'BAAY\u0003\u0011Q\u0017M^1\n\t\u0005U\u00161\u0016\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005m\u0006c\u00019\u0002>&\u0019\u0011qX9\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\u0015\u00171\u001a\t\u0004a\u0006\u001d\u0017bAAec\n\u0019\u0011I\\=\t\u0013\u00055'&!AA\u0002\u0005m\u0016a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002TB1\u0011Q[An\u0003\u000bl!!a6\u000b\u0007\u0005e\u0017/\u0001\u0006d_2dWm\u0019;j_:LA!!8\u0002X\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t\u0019/!;\u0011\u0007A\f)/C\u0002\u0002hF\u0014qAQ8pY\u0016\fg\u000eC\u0005\u0002N2\n\t\u00111\u0001\u0002F\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\t9+a<\t\u0013\u00055W&!AA\u0002\u0005m\u0016\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005m\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\u001d\u0016AB3rk\u0006d7\u000f\u0006\u0003\u0002d\u0006u\b\"CAga\u0005\u0005\t\u0019AAc\u0005Qi\u0015-\u001b7c_b,\u0006\u000fZ1uKN+8mY3tgN1Aa\u001c?\u007f\u0003\u0007)\"A!\u0002\u0011\t\t\u001d!\u0011C\u0007\u0003\u0005\u0013QAAa\u0003\u0003\u000e\u0005)Qn\u001c3fY*\u0019!q\u00023\u0002\u000f5\f\u0017\u000e\u001c2pq&!!1\u0003B\u0005\u0005%i\u0015-\u001b7c_bLE\r\u0006\u0003\u0003\u0018\te\u0001CA?\u0005\u0011\u001d\tYb\u0002a\u0001\u0005\u000b!BAa\u0006\u0003\u001e!I\u00111\u0004\u0005\u0011\u0002\u0003\u0007!QA\u000b\u0003\u0005CQCA!\u0002\u0002\u0006R!\u0011Q\u0019B\u0013\u0011%\ti\rDA\u0001\u0002\u0004\tY\f\u0006\u0003\u0002d\n%\u0002\"CAg\u001d\u0005\u0005\t\u0019AAc)\u0011\t9K!\f\t\u0013\u00055w\"!AA\u0002\u0005mF\u0003BAr\u0005cA\u0011\"!4\u0013\u0003\u0003\u0005\r!!2\u0002)5\u000b\u0017\u000e\u001c2pqV\u0003H-\u0019;f'V\u001c7-Z:t!\tiHcE\u0003\u0015\u0005s\u0011)\u0005\u0005\u0005\u0003<\t\u0005#Q\u0001B\f\u001b\t\u0011iDC\u0002\u0003@E\fqA];oi&lW-\u0003\u0003\u0003D\tu\"!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocA!!q\tB'\u001b\t\u0011IE\u0003\u0003\u0003L\u0005=\u0016AA5p\u0013\u0011\t9B!\u0013\u0015\u0005\tU\u0012!B1qa2LH\u0003\u0002B\f\u0005+Bq!a\u0007\u0018\u0001\u0004\u0011)!A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\tm#Q\f\t\u0006a\u0006}\"Q\u0001\u0005\n\u0005?B\u0012\u0011!a\u0001\u0005/\t1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011)\u0007\u0005\u0003\u0002*\n\u001d\u0014\u0002\u0002B5\u0003W\u0013aa\u00142kK\u000e$\u0018\u0001F'bS2\u0014w\u000e_+qI\u0006$XMR1jYV\u0014X\r\u0005\u0002~eM)!G!\u001d\u0003FAa!1\bB:\u0003?\t\t$!\u0010\u0002N%!!Q\u000fB\u001f\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u000b\u0003\u0005[\"\u0002\"!\u0014\u0003|\tu$q\u0010\u0005\b\u00037)\u0004\u0019AA\u0010\u0011\u001d\ti#\u000ea\u0001\u0003cAq!!\u000f6\u0001\u0004\ti\u0004\u0006\u0003\u0003\u0004\n-\u0005#\u00029\u0002@\t\u0015\u0005#\u00039\u0003\b\u0006}\u0011\u0011GA\u001f\u0013\r\u0011I)\u001d\u0002\u0007)V\u0004H.Z\u001a\t\u0013\t}c'!AA\u0002\u00055#\u0001F'bS2\u0014w\u000e_+qI\u0006$XMU3tk2$8oE\u00039_z\f\u0019!A\u0004sKN,H\u000e^:\u0016\u0005\tU\u0005#BA\u0003\u0005/c\u0018\u0002\u0002BM\u00033\u00111aU3r\u0003!\u0011Xm];miN\u0004C\u0003\u0002BP\u0005C\u0003\"! \u001d\t\u000f\tE5\b1\u0001\u0003\u0016\u00069Q\u000f\u001d3bi\u0016$WC\u0001BT!!\u0011IK!-\u0003\u0006\t]f\u0002\u0002BV\u0005[\u00032!!\u0003r\u0013\r\u0011y+]\u0001\u0007!J,G-\u001a4\n\t\tM&Q\u0017\u0002\u0004\u001b\u0006\u0004(b\u0001BXcB!\u0011\u0011\u0005B]\u0013\u0011\u0011Y,a\t\u0003+5\u000b\u0017\u000e\u001c2pqV\u0003H-\u0019;f%\u0016\u001c\bo\u001c8tK\u0006Qan\u001c;Va\u0012\fG/\u001a3\u0016\u0005\t\u0005\u0007\u0003\u0003BU\u0005c\u000by\"a\u001c\u0015\t\t}%Q\u0019\u0005\n\u0005#s\u0004\u0013!a\u0001\u0005++\"A!3+\t\tU\u0015Q\u0011\u000b\u0005\u0003\u000b\u0014i\rC\u0005\u0002N\n\u000b\t\u00111\u0001\u0002<R!\u00111\u001dBi\u0011%\ti\rRA\u0001\u0002\u0004\t)\r\u0006\u0003\u0002(\nU\u0007\"CAg\u000b\u0006\u0005\t\u0019AA^)\u0011\t\u0019O!7\t\u0013\u00055\u0007*!AA\u0002\u0005\u0015\u0017\u0001F'bS2\u0014w\u000e_+qI\u0006$XMU3tk2$8\u000f\u0005\u0002~\u0015N)!J!9\u0003FAA!1\bB!\u0005+\u0013y\n\u0006\u0002\u0003^R!!q\u0014Bt\u0011\u001d\u0011\t*\u0014a\u0001\u0005+#BAa;\u0003nB)\u0001/a\u0010\u0003\u0016\"I!q\f(\u0002\u0002\u0003\u0007!qT\n\u0003!>\f!b]3sS\u0006d\u0017N_3s!\u0011\u0011)Pa?\u000e\u0005\t](b\u0001B}E\u0006!!n]8o\u0013\u0011\u0011iPa>\u0003#5\u000b\u0017\u000e\u001c2pqN+'/[1mSj,'/\u0001\bnC&d'm\u001c=NC:\fw-\u001a:\u0011\t\r\r1QA\u0007\u0003\u0005\u001bIAaa\u0002\u0003\u000e\tqQ*Y5mE>DX*\u00198bO\u0016\u0014\u0018aE:vEN\u001c'/\u001b9uS>tW*\u00198bO\u0016\u0014\b\u0003BB\u0002\u0007\u001bIAaa\u0004\u0003\u000e\t\u00192+\u001e2tGJL\u0007\u000f^5p]6\u000bg.Y4fe\u0006\u0001R.Y5mE>D\u0018\n\u001a$bGR|'/\u001f\t\u0005\u0007+\u0019YB\u0004\u0003\u0003\b\r]\u0011\u0002BB\r\u0005\u0013\t\u0011\"T1jY\n|\u00070\u00133\n\t\ru1q\u0004\u0002\b\r\u0006\u001cGo\u001c:z\u0015\u0011\u0019IB!\u0003\u0015\u0015\r\r2QEB\u0014\u0007S\u0019Y\u0003\u0005\u0002m!\"9!\u0011_+A\u0002\tM\bb\u0002B\u0000+\u0002\u00071\u0011\u0001\u0005\b\u0007\u0013)\u0006\u0019AB\u0006\u0011\u001d\u0019\t\"\u0016a\u0001\u0007'A3!VB\u0018!\u0011\u0019\tda\u000f\u000e\u0005\rM\"\u0002BB\u001b\u0007o\ta!\u001b8kK\u000e$(BAB\u001d\u0003\u0015Q\u0017M^1y\u0013\u0011\u0019ida\r\u0003\r%s'.Z2u\u0003=)\b\u000fZ1uK6\u000b\u0017\u000e\u001c2pq\u0016\u001cH\u0003CB\"\u0007_\u001aIha!\u0011\r\r\u001531KB,\u001b\t\u00199E\u0003\u0003\u0004J\r-\u0013!\u00039vE2L7\u000f[3s\u0015\r\u00118Q\n\u0006\u0005\u0003C\u001ayE\u0003\u0002\u0004R\u00059!/Z1di>\u0014\u0018\u0002BB+\u0007\u000f\u0012QaU'p]>\u00042a!\u00179\u001d\r\u0019Y\u0006\u0001\b\u0005\u0007;\u001aiG\u0004\u0003\u0004`\r-d\u0002BB1\u0007SrAaa\u0019\u0004h9!\u0011\u0011BB3\u0013\u0005I\u0017BA4i\u0013\t)g-\u0003\u0002dI&\u0011\u0011M\u0019\u0005\b\u0007c2\u0006\u0019AB:\u00039i\u0017-\u001b7c_b\u001cVm]:j_:\u0004Baa\u0001\u0004v%!1q\u000fB\u0007\u00059i\u0015-\u001b7c_b\u001cVm]:j_:Dqaa\u001fW\u0001\u0004\u0019i(A\tnC&d'm\u001c=TKR\u0014V-];fgR\u0004B!!\t\u0004\u0000%!1\u0011QA\u0012\u0005Ei\u0015-\u001b7c_b\u001cV\r\u001e*fcV,7\u000f\u001e\u0005\b\u0007\u000b3\u0006\u0019ABD\u00031\u0019\u0017\r]1cS2LG/[3t!\u0019\u0011Ik!#\u0004\u000e&!11\u0012B[\u0005\r\u0019V\r\u001e\t\u0005\u0007\u001f\u001bIJ\u0004\u0003\u0004\u0012\u000eUe\u0002BB/\u0007'K1!!\u0019c\u0013\u0011\u00199*a\u0018\u0002)\r\u000b\u0007/\u00192jY&$\u00180\u00133f]RLg-[3s\u0013\u0011\u0019Yj!(\u0003)\r\u000b\u0007/\u00192jY&$\u00180\u00133f]RLg-[3s\u0015\u0011\u00199*a\u0018\u0002\u001bU\u0004H-\u0019;f\u001b\u0006LGNY8y)1\u0019\u0019ka*\u0004*\u000e-6qVB\\!\u0019\u0019)ea\u0015\u0004&B\u00191\u0011L\u0002\t\u000f\rEt\u000b1\u0001\u0004t!9\u00111D,A\u0002\t\u0015\u0001bBBW/\u0002\u0007\u0011qD\u0001\u0012k:\u0004\u0018M]:fI6\u000b\u0017\u000e\u001c2pq&#\u0007bBA\u001d/\u0002\u00071\u0011\u0017\t\u0005\u0003C\u0019\u0019,\u0003\u0003\u00046\u0006\r\"AE'bS2\u0014w\u000e\u001f)bi\u000eDwJ\u00196fGRDqa!\"X\u0001\u0004\u00199)\u0001\nva\u0012\fG/Z*vEN\u001c'/\u001b9uS>tG\u0003CBR\u0007{\u001byla1\t\u000f\u0005m\u0001\f1\u0001\u0003\u0006!91\u0011\u0019-A\u0002\u0005\r\u0013A\u0004<bY&$\u0017\r^3e!\u0006$8\r\u001b\u0005\b\u0007cB\u0006\u0019AB:\u0003E)\b\u000fZ1uK6\u000b\u0017\u000e\u001c2pqB\u000bG\u000f\u001b\u000b\u000b\u0007G\u001bIma3\u0004N\u000e=\u0007bBA\u000e3\u0002\u0007!Q\u0001\u0005\b\u0007[K\u0006\u0019AA\u0010\u0011\u001d\u0019\t-\u0017a\u0001\u0003\u0007Bqa!\u001dZ\u0001\u0004\u0019\u0019(A\nbaBd\u0017\u0010U1sK:$\u0018\nZ+qI\u0006$X\r\u0006\u0005\u0004V\u000e\u000581]Bx!\u001d\u00018q[Bn\u00077L1a!7r\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003\u0003\b\ru\u0017\u0002BBp\u0005\u0013\u00111\"T1jY\n|\u0007\u0010U1uQ\"9\u00111\u0004.A\u0002\t\u0015\u0001bBBs5\u0002\u00071q]\u0001\u0014[\u0006L(-\u001a)be\u0016tG/\u00133Va\u0012\fG/\u001a\t\u0006a\u0006}2\u0011\u001e\t\u0005\u0003C\u0019Y/\u0003\u0003\u0004n\u0006\r\"A\u0004)be\u0016tG/\u00133Va\u0012\fG/\u001a\u0005\b\u0007cR\u0006\u0019AB:\u0003=\t\u0007\u000f\u001d7z\u001d\u0006lW-\u00169eCR,GCBBk\u0007k$\t\u0001C\u0004\u0004xn\u0003\ra!?\u0002\u001f5\f\u0017PY3OC6,W\u000b\u001d3bi\u0016\u0004R\u0001]A \u0007w\u0004B!!\t\u0004~&!1q`A\u0012\u0005)q\u0015-\\3Va\u0012\fG/\u001a\u0005\b\u0007cZ\u0006\u0019AB:)!\u0019)\u000e\"\u0002\u0005\b\u0011-\u0001bBA\u000e9\u0002\u0007!Q\u0001\u0005\b\t\u0013a\u0006\u0019ABu\u00039\u0001\u0018M]3oi&#W\u000b\u001d3bi\u0016Dqa!\u001d]\u0001\u0004\u0019\u0019(A\nva\u0012\fG/Z'bS2\u0014w\u000e\u001f*jO\"$8\u000f\u0006\u0005\u0004$\u0012EA1\u0003C\u000b\u0011\u001d\tY\"\u0018a\u0001\u0005\u000bAqa!1^\u0001\u0004\t\u0019\u0005C\u0004\u0004ru\u0003\raa\u001d\u0002!%\u001c\u0018iU=ti\u0016lW*Y5mE>DH\u0003BAr\t7AqAa\u0004_\u0001\u0004!i\u0002\u0005\u0003\u0004\u0004\u0011}\u0011\u0002\u0002C\u0011\u0005\u001b\u0011a\"T3tg\u0006<W-T1oC\u001e,'\u000f")
public class MailboxSetUpdatePerformer {
    private final MailboxSerializer serializer;
    private final MailboxManager mailboxManager;
    private final SubscriptionManager subscriptionManager;
    private final MailboxId.Factory mailboxIdFactory;

    public SMono<MailboxUpdateResults> updateMailboxes(MailboxSession mailboxSession, MailboxSetRequest mailboxSetRequest, Set<Refined<String, string.Uri>> capabilities) {
        SFlux qual$1 = SFlux$.MODULE$.fromIterable((Iterable)mailboxSetRequest.update().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$));
        Function1 & Serializable x$1 = (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                UnparsedMailboxId unparsedMailboxId = (UnparsedMailboxId)tuple2._1();
                MailboxPatchObject patch = (MailboxPatchObject)tuple2._2();
                if (unparsedMailboxId != null) {
                    UnparsedMailboxId unparsedMailboxId2 = unparsedMailboxId;
                    if (patch != null) {
                        MailboxPatchObject mailboxPatchObject = patch;
                        return ((SMono)MailboxGet$.MODULE$.parse($this.mailboxIdFactory, unparsedMailboxId2).fold((Function1 & Serializable)e -> SMono$.MODULE$.just((Object)new MailboxUpdateFailure(unparsedMailboxId2, (Throwable)e, (Option<ValidatedMailboxPatchObject>)None$.MODULE$)), (Function1 & Serializable)mailboxId -> this.updateMailbox(mailboxSession, (MailboxId)mailboxId, unparsedMailboxId2, mailboxPatchObject, capabilities))).onErrorResume((Function1 & Serializable)e -> SMono$.MODULE$.just((Object)new MailboxUpdateFailure(unparsedMailboxId2, (Throwable)e, (Option<ValidatedMailboxPatchObject>)None$.MODULE$)));
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        };
        int x$2 = 5;
        int x$3 = qual$1.flatMap$default$3();
        boolean x$4 = qual$1.flatMap$default$4();
        return qual$1.flatMap((Function1)x$1, 5, x$3, x$4).collectSeq().map((Function1)MailboxSetUpdatePerformer$MailboxUpdateResults$.MODULE$);
    }

    private SMono<MailboxUpdateResult> updateMailbox(MailboxSession mailboxSession, MailboxId mailboxId, UnparsedMailboxId unparsedMailboxId, MailboxPatchObject patch, Set<Refined<String, string.Uri>> capabilities) {
        return (SMono)patch.validate(this.mailboxIdFactory, this.serializer, capabilities, mailboxSession).fold((Function1 & Serializable)e -> SMono$.MODULE$.error((Throwable)e), (Function1 & Serializable)validatedPatch -> this.updateMailboxRights(mailboxId, (ValidatedMailboxPatchObject)validatedPatch, mailboxSession).then(this.updateSubscription(mailboxId, (ValidatedMailboxPatchObject)validatedPatch, mailboxSession)).then(this.updateMailboxPath(mailboxId, unparsedMailboxId, (ValidatedMailboxPatchObject)validatedPatch, mailboxSession)));
    }

    private SMono<MailboxUpdateResult> updateSubscription(MailboxId mailboxId, ValidatedMailboxPatchObject validatedPatch, MailboxSession mailboxSession) {
        return (SMono)validatedPatch.isSubscribedUpdate().map((Function1 & Serializable)isSubscribedUpdate -> SMono$.MODULE$.fromCallable(() -> {
            MailboxSetUpdatePerformer.$anonfun$updateSubscription$2(this, mailboxId, mailboxSession, isSubscribedUpdate);
            return BoxedUnit.UNIT;
        }).then(SMono$.MODULE$.just((Object)new MailboxUpdateSuccess(mailboxId))).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER)).getOrElse((Function0 & Serializable)() -> SMono$.MODULE$.just((Object)new MailboxUpdateSuccess(mailboxId)));
    }

    private SMono<MailboxUpdateResult> updateMailboxPath(MailboxId mailboxId, UnparsedMailboxId unparsedMailboxId, ValidatedMailboxPatchObject validatedPatch, MailboxSession mailboxSession) {
        if (validatedPatch.shouldUpdateMailboxPath()) {
            return SMono$.MODULE$.fromCallable(() -> {
                Product product;
                try {
                    MailboxPath newPath;
                    MessageManager mailbox = $this.mailboxManager.getMailbox(mailboxId, mailboxSession);
                    if (this.isASystemMailbox(mailbox)) {
                        throw new SystemMailboxChangeException(mailboxId);
                    }
                    if (validatedPatch.parentIdUpdate().flatMap((Function1 & Serializable)x$3 -> x$3.newId()).contains((Object)mailboxId)) {
                        throw new LoopInMailboxGraphException(mailboxId);
                    }
                    MailboxPath oldPath = mailbox.getMailboxPath();
                    Object object = !oldPath.equals((Object)(newPath = (MailboxPath)this.applyParentIdUpdate(mailboxId, validatedPatch.parentIdUpdate(), mailboxSession).andThen(this.applyNameUpdate(validatedPatch.nameUpdate(), mailboxSession)).apply((Object)oldPath))) ? $this.mailboxManager.renameMailbox(mailboxId, newPath, MailboxManager.RenameOption.RENAME_SUBSCRIPTIONS, mailboxSession) : BoxedUnit.UNIT;
                    product = new MailboxUpdateSuccess(mailboxId);
                }
                catch (Exception e) {
                    product = new MailboxUpdateFailure(unparsedMailboxId, e, (Option<ValidatedMailboxPatchObject>)new Some((Object)validatedPatch));
                }
                return product;
            }).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER);
        }
        return SMono$.MODULE$.just((Object)new MailboxUpdateSuccess(mailboxId));
    }

    private Function1<MailboxPath, MailboxPath> applyParentIdUpdate(MailboxId mailboxId, Option<ParentIdUpdate> maybeParentIdUpdate, MailboxSession mailboxSession) {
        return (Function1)maybeParentIdUpdate.map((Function1 & Serializable)parentIdUpdate -> this.applyParentIdUpdate(mailboxId, (ParentIdUpdate)parentIdUpdate, mailboxSession)).getOrElse((Function0 & Serializable)() -> (Function1 & Serializable)x -> x);
    }

    private Function1<MailboxPath, MailboxPath> applyNameUpdate(Option<NameUpdate> maybeNameUpdate, MailboxSession mailboxSession) {
        return (Function1 & Serializable)originalPath -> (MailboxPath)maybeNameUpdate.map((Function1 & Serializable)nameUpdate -> {
            Option originalParentPath = ((IterableOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(originalPath.getHierarchyLevels(mailboxSession.getPathDelimiter())).asScala().reverse()).drop(1)).headOption();
            return (MailboxPath)originalParentPath.map((Function1 & Serializable)x$4 -> x$4.child(nameUpdate.newName(), mailboxSession.getPathDelimiter())).getOrElse((Function0 & Serializable)() -> MailboxPath.forUser((Username)mailboxSession.getUser(), (String)nameUpdate.newName()));
        }).getOrElse((Function0 & Serializable)() -> originalPath);
    }

    private Function1<MailboxPath, MailboxPath> applyParentIdUpdate(MailboxId mailboxId, ParentIdUpdate parentIdUpdate, MailboxSession mailboxSession) {
        return (Function1 & Serializable)originalPath -> {
            String currentName = originalPath.getName(mailboxSession.getPathDelimiter());
            return (MailboxPath)parentIdUpdate.newId().map((Function1 & Serializable)id -> {
                Duration x$1;
                SMono qual$1 = SFlux$.MODULE$.fromPublisher((Publisher)$this.mailboxManager.search(MailboxQuery.builder().userAndNamespaceFrom(originalPath).expression((MailboxNameExpression)new PrefixedWildcard(new StringBuilder(0).append(originalPath.getName()).append(mailboxSession.getPathDelimiter()).toString())).build(), MailboxManager.MailboxSearchFetchType.Minimal, mailboxSession)).filter((Function1 & Serializable)child -> BoxesRunTime.boxToBoolean((boolean)MailboxSetUpdatePerformer.$anonfun$applyParentIdUpdate$6(id, child))).hasElements();
                boolean createsALoop = BoxesRunTime.unboxToBoolean((Object)qual$1.block(x$1 = qual$1.block$default$1()));
                if (createsALoop) {
                    throw new LoopInMailboxGraphException(mailboxId);
                }
                MailboxPath parentPath = $this.mailboxManager.getMailbox(id, mailboxSession).getMailboxPath();
                return parentPath.child(currentName, mailboxSession.getPathDelimiter());
            }).getOrElse((Function0 & Serializable)() -> MailboxPath.forUser((Username)originalPath.getUser(), (String)currentName));
        };
    }

    private SMono<MailboxUpdateResult> updateMailboxRights(MailboxId mailboxId, ValidatedMailboxPatchObject validatedPatch, MailboxSession mailboxSession) {
        SMono resetOperation = (SMono)validatedPatch.rightsReset().map((Function1 & Serializable)sharedWithResetUpdate -> SMono$.MODULE$.fromCallable(() -> {
            this.mailboxManager.setRights(mailboxId, sharedWithResetUpdate.rights().toMailboxAcl().asJava(), mailboxSession);
            return BoxedUnit.UNIT;
        }).then()).getOrElse((Function0 & Serializable)() -> SMono$.MODULE$.empty());
        SFlux qual$1 = SFlux$.MODULE$.fromIterable(validatedPatch.rightsPartialUpdates());
        Function1 & Serializable x$1 = (Function1 & Serializable)partialUpdate -> SMono$.MODULE$.fromCallable(() -> {
            this.mailboxManager.applyRightsCommand(mailboxId, partialUpdate.asACLCommand(), mailboxSession);
            return BoxedUnit.UNIT;
        });
        int x$2 = 5;
        int x$3 = qual$1.flatMap$default$3();
        boolean x$4 = qual$1.flatMap$default$4();
        SMono partialUpdatesOperation = qual$1.flatMap((Function1)x$1, 5, x$3, x$4).then();
        return SFlux$.MODULE$.merge((Seq)new .colon.colon((Object)resetOperation, (List)new .colon.colon((Object)partialUpdatesOperation, (List)Nil$.MODULE$)), SFlux$.MODULE$.merge$default$2(), SFlux$.MODULE$.merge$default$3()).then().then(SMono$.MODULE$.just((Object)new MailboxUpdateSuccess(mailboxId))).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER);
    }

    private boolean isASystemMailbox(MessageManager mailbox) {
        return Role.from((String)mailbox.getMailboxPath().getName()).isPresent();
    }

    public static final /* synthetic */ void $anonfun$updateSubscription$2(MailboxSetUpdatePerformer $this, MailboxId mailboxId$2, MailboxSession mailboxSession$3, IsSubscribedUpdate isSubscribedUpdate$1) {
        MessageManager mailbox = $this.mailboxManager.getMailbox(mailboxId$2, mailboxSession$3);
        boolean isOwner = mailbox.getMailboxPath().belongsTo(mailboxSession$3);
        boolean shouldSubscribe = BoxesRunTime.unboxToBoolean((Object)isSubscribedUpdate$1.isSubscribed().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)((IsSubscribed)x$2).value())).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> isOwner));
        if (shouldSubscribe) {
            $this.subscriptionManager.subscribe(mailboxSession$3, mailbox.getMailboxPath());
            return;
        }
        $this.subscriptionManager.unsubscribe(mailboxSession$3, mailbox.getMailboxPath());
    }

    public static final /* synthetic */ boolean $anonfun$applyParentIdUpdate$6(MailboxId id$1, MailboxMetaData child) {
        return child.getId().equals(id$1);
    }

    @Inject
    public MailboxSetUpdatePerformer(MailboxSerializer serializer, MailboxManager mailboxManager, SubscriptionManager subscriptionManager, MailboxId.Factory mailboxIdFactory) {
        this.serializer = serializer;
        this.mailboxManager = mailboxManager;
        this.subscriptionManager = subscriptionManager;
        this.mailboxIdFactory = mailboxIdFactory;
    }

    public static class MailboxUpdateFailure
    implements MailboxUpdateResult,
    Product,
    Serializable {
        private final UnparsedMailboxId mailboxId;
        private final Throwable exception;
        private final Option<ValidatedMailboxPatchObject> patch;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public UnparsedMailboxId mailboxId() {
            return this.mailboxId;
        }

        public Throwable exception() {
            return this.exception;
        }

        public Option<ValidatedMailboxPatchObject> patch() {
            return this.patch;
        }

        public Option<Properties> filter(Properties acceptableProperties) {
            return new Some(this.patch().map((Function1 & Serializable)x$1 -> x$1.updatedProperties().intersect(acceptableProperties)).getOrElse((Function0 & Serializable)() -> acceptableProperties));
        }

        public SetError asMailboxSetError() {
            Throwable throwable = this.exception();
            if (throwable instanceof MailboxNotFoundException) {
                MailboxNotFoundException mailboxNotFoundException = (MailboxNotFoundException)throwable;
                return SetError$.MODULE$.notFound(mailboxNotFoundException.getMessage());
            }
            if (throwable instanceof MailboxNameException) {
                MailboxNameException mailboxNameException = (MailboxNameException)throwable;
                return SetError$.MODULE$.invalidArguments(mailboxNameException.getMessage(), this.filter(Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"name")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"parentId")).value()))}))));
            }
            if (throwable instanceof MailboxExistsException) {
                MailboxExistsException mailboxExistsException = (MailboxExistsException)throwable;
                return SetError$.MODULE$.invalidArguments(mailboxExistsException.getMessage(), this.filter(Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"name")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"parentId")).value()))}))));
            }
            if (throwable instanceof UnsupportedPropertyUpdatedException) {
                UnsupportedPropertyUpdatedException unsupportedPropertyUpdatedException = (UnsupportedPropertyUpdatedException)throwable;
                return SetError$.MODULE$.invalidArguments(new StringBuilder(45).append(new Refined((Object)unsupportedPropertyUpdatedException.property())).append(" property do not exist thus cannot be updated").toString(), (Option<Properties>)new Some((Object)Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)unsupportedPropertyUpdatedException.property())}))));
            }
            if (throwable instanceof InvalidUpdateException) {
                InvalidUpdateException invalidUpdateException = (InvalidUpdateException)throwable;
                return SetError$.MODULE$.invalidArguments(String.valueOf(invalidUpdateException.cause()), (Option<Properties>)new Some((Object)Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)invalidUpdateException.property())}))));
            }
            if (throwable instanceof ServerSetPropertyException) {
                ServerSetPropertyException serverSetPropertyException = (ServerSetPropertyException)throwable;
                return SetError$.MODULE$.invalidArguments("Can not modify server-set properties", (Option<Properties>)new Some((Object)Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)serverSetPropertyException.property())}))));
            }
            if (throwable instanceof InvalidPropertyException) {
                InvalidPropertyException invalidPropertyException = (InvalidPropertyException)throwable;
                return SetError$.MODULE$.invalidPatch(String.valueOf(invalidPropertyException.cause()));
            }
            if (throwable instanceof InvalidPatchException) {
                InvalidPatchException invalidPatchException = (InvalidPatchException)throwable;
                return SetError$.MODULE$.invalidPatch(String.valueOf(invalidPatchException.cause()));
            }
            if (throwable instanceof SystemMailboxChangeException) {
                return SetError$.MODULE$.invalidArguments("Invalid change to a system mailbox", this.filter(Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"name")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"parentId")).value()))}))));
            }
            if (throwable instanceof LoopInMailboxGraphException) {
                return SetError$.MODULE$.invalidArguments("A mailbox parentId property can not be set to itself or one of its child", (Option<Properties>)new Some((Object)Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"parentId")).value()))}))));
            }
            if (throwable instanceof InsufficientRightsException) {
                return SetError$.MODULE$.invalidArguments("Invalid change to a delegated mailbox", SetError$.MODULE$.invalidArguments$default$2());
            }
            if (throwable instanceof IllegalArgumentException) {
                IllegalArgumentException illegalArgumentException = (IllegalArgumentException)throwable;
                return SetError$.MODULE$.invalidArguments(illegalArgumentException.getMessage(), (Option<Properties>)None$.MODULE$);
            }
            return SetError$.MODULE$.serverFail(this.exception().getMessage());
        }

        public MailboxUpdateFailure copy(UnparsedMailboxId mailboxId, Throwable exception, Option<ValidatedMailboxPatchObject> patch) {
            return new MailboxUpdateFailure(mailboxId, exception, patch);
        }

        public UnparsedMailboxId copy$default$1() {
            return this.mailboxId();
        }

        public Throwable copy$default$2() {
            return this.exception();
        }

        public Option<ValidatedMailboxPatchObject> copy$default$3() {
            return this.patch();
        }

        public String productPrefix() {
            return "MailboxUpdateFailure";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.mailboxId();
                }
                case 1: {
                    return this.exception();
                }
                case 2: {
                    return this.patch();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MailboxUpdateFailure;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "mailboxId";
                }
                case 1: {
                    return "exception";
                }
                case 2: {
                    return "patch";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MailboxUpdateFailure)) return false;
            boolean bl = true;
            if (!bl) return false;
            MailboxUpdateFailure mailboxUpdateFailure = (MailboxUpdateFailure)x$1;
            UnparsedMailboxId unparsedMailboxId = this.mailboxId();
            UnparsedMailboxId unparsedMailboxId2 = mailboxUpdateFailure.mailboxId();
            if (unparsedMailboxId == null) {
                if (unparsedMailboxId2 != null) {
                    return false;
                }
            } else if (!((Object)unparsedMailboxId).equals(unparsedMailboxId2)) return false;
            Throwable throwable = this.exception();
            Throwable throwable2 = mailboxUpdateFailure.exception();
            if (throwable == null) {
                if (throwable2 != null) {
                    return false;
                }
            } else if (!throwable.equals(throwable2)) return false;
            Option<ValidatedMailboxPatchObject> option = this.patch();
            Option<ValidatedMailboxPatchObject> option2 = mailboxUpdateFailure.patch();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!mailboxUpdateFailure.canEqual(this)) return false;
            return true;
        }

        public MailboxUpdateFailure(UnparsedMailboxId mailboxId, Throwable exception, Option<ValidatedMailboxPatchObject> patch) {
            this.mailboxId = mailboxId;
            this.exception = exception;
            this.patch = patch;
            Product.$init$((Product)this);
        }
    }

    public static interface MailboxUpdateResult {
    }

    public static class MailboxUpdateResults
    implements Product,
    Serializable {
        private final Seq<MailboxUpdateResult> results;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Seq<MailboxUpdateResult> results() {
            return this.results;
        }

        public Map<MailboxId, MailboxUpdateResponse> updated() {
            return ((IterableOnceOps)this.results().flatMap((Function1 & Serializable)result -> {
                MailboxUpdateResult mailboxUpdateResult = result;
                if (mailboxUpdateResult instanceof MailboxUpdateSuccess) {
                    MailboxUpdateSuccess mailboxUpdateSuccess = (MailboxUpdateSuccess)mailboxUpdateResult;
                    return new Some((Object)new Tuple2((Object)mailboxUpdateSuccess.mailboxId(), (Object)MailboxSetResponse$.MODULE$.empty()));
                }
                return None$.MODULE$;
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }

        public Map<UnparsedMailboxId, SetError> notUpdated() {
            return ((IterableOnceOps)this.results().flatMap((Function1 & Serializable)result -> {
                MailboxUpdateResult mailboxUpdateResult = result;
                if (mailboxUpdateResult instanceof MailboxUpdateFailure) {
                    MailboxUpdateFailure mailboxUpdateFailure = (MailboxUpdateFailure)mailboxUpdateResult;
                    return new Some((Object)new Tuple2((Object)mailboxUpdateFailure.mailboxId(), (Object)mailboxUpdateFailure.asMailboxSetError()));
                }
                return None$.MODULE$;
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }

        public MailboxUpdateResults copy(Seq<MailboxUpdateResult> results) {
            return new MailboxUpdateResults(results);
        }

        public Seq<MailboxUpdateResult> copy$default$1() {
            return this.results();
        }

        public String productPrefix() {
            return "MailboxUpdateResults";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.results();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MailboxUpdateResults;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "results";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MailboxUpdateResults)) return false;
            boolean bl = true;
            if (!bl) return false;
            MailboxUpdateResults mailboxUpdateResults = (MailboxUpdateResults)x$1;
            Seq<MailboxUpdateResult> seq = this.results();
            Seq<MailboxUpdateResult> seq2 = mailboxUpdateResults.results();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!mailboxUpdateResults.canEqual(this)) return false;
            return true;
        }

        public MailboxUpdateResults(Seq<MailboxUpdateResult> results) {
            this.results = results;
            Product.$init$((Product)this);
        }
    }

    public static class MailboxUpdateSuccess
    implements MailboxUpdateResult,
    Product,
    Serializable {
        private final MailboxId mailboxId;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public MailboxId mailboxId() {
            return this.mailboxId;
        }

        public MailboxUpdateSuccess copy(MailboxId mailboxId) {
            return new MailboxUpdateSuccess(mailboxId);
        }

        public MailboxId copy$default$1() {
            return this.mailboxId();
        }

        public String productPrefix() {
            return "MailboxUpdateSuccess";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.mailboxId();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MailboxUpdateSuccess;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "mailboxId";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MailboxUpdateSuccess)) return false;
            boolean bl = true;
            if (!bl) return false;
            MailboxUpdateSuccess mailboxUpdateSuccess = (MailboxUpdateSuccess)x$1;
            MailboxId mailboxId = this.mailboxId();
            MailboxId mailboxId2 = mailboxUpdateSuccess.mailboxId();
            if (mailboxId == null) {
                if (mailboxId2 != null) {
                    return false;
                }
            } else if (!mailboxId.equals(mailboxId2)) return false;
            if (!mailboxUpdateSuccess.canEqual(this)) return false;
            return true;
        }

        public MailboxUpdateSuccess(MailboxId mailboxId) {
            this.mailboxId = mailboxId;
            Product.$init$((Product)this);
        }
    }
}

