/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.util;

import com.datastax.oss.driver.internal.core.util.Dependency;
import java.util.concurrent.ConcurrentHashMap;

public class GraalDependencyChecker {
    private static final ConcurrentHashMap<Dependency, Boolean> CACHE = new ConcurrentHashMap();

    public static boolean isPresent(Dependency dependency) {
        try {
            return CACHE.computeIfAbsent(dependency, dep -> {
                for (String classNameToTest : dependency.classes()) {
                    try {
                        Class.forName(classNameToTest);
                    }
                    catch (Exception | LinkageError e) {
                        return false;
                    }
                }
                return true;
            });
        }
        catch (Exception e) {
            return false;
        }
    }
}

