/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.mail.model;

import java.util.Optional;
import java.util.function.Predicate;
import javax.mail.Flags;

public class FlagsFilter {
    private final SystemFlagFilter systemFlagFilter;
    private final UserFlagFilter userFlagFilter;

    public static Builder builder() {
        return new Builder();
    }

    public static FlagsFilter noFilter() {
        return FlagsFilter.builder().build();
    }

    private FlagsFilter(SystemFlagFilter systemFlagFilter, UserFlagFilter userFlagFilter) {
        this.systemFlagFilter = systemFlagFilter;
        this.userFlagFilter = userFlagFilter;
    }

    public SystemFlagFilter getSystemFlagFilter() {
        return this.systemFlagFilter;
    }

    public UserFlagFilter getUserFlagFilter() {
        return this.userFlagFilter;
    }

    @FunctionalInterface
    public static interface UserFlagFilter
    extends Predicate<String> {
    }

    @FunctionalInterface
    public static interface SystemFlagFilter
    extends Predicate<Flags.Flag> {
    }

    public static class Builder {
        private Optional<SystemFlagFilter> systemFlagFilter = Optional.empty();
        private Optional<UserFlagFilter> userFlagFilter = Optional.empty();

        private Builder() {
        }

        public Builder systemFlagFilter(SystemFlagFilter filter) {
            this.systemFlagFilter = Optional.of(filter);
            return this;
        }

        public Builder userFlagFilter(UserFlagFilter filter) {
            this.userFlagFilter = Optional.of(filter);
            return this;
        }

        public FlagsFilter build() {
            return new FlagsFilter(this.systemFlagFilter.orElse(f -> true), this.userFlagFilter.orElse(s -> true));
        }
    }
}

