/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.mailrepository.guice;

import com.google.inject.Inject;
import com.google.inject.Module;
import org.apache.james.mailrepository.api.MailRepository;
import org.apache.james.mailrepository.api.MailRepositoryLoader;
import org.apache.james.mailrepository.api.MailRepositoryStore;
import org.apache.james.mailrepository.api.MailRepositoryUrl;
import org.apache.james.utils.ClassName;
import org.apache.james.utils.GuiceGenericLoader;

public class GuiceMailRepositoryLoader
implements MailRepositoryLoader {
    private final GuiceGenericLoader genericLoader;

    @Inject
    public GuiceMailRepositoryLoader(GuiceGenericLoader genericLoader) {
        this.genericLoader = genericLoader;
    }

    public MailRepository load(String fullyQualifiedClassName, MailRepositoryUrl url) throws MailRepositoryStore.MailRepositoryStoreException {
        try {
            Module urlModule = binder -> binder.bind(MailRepositoryUrl.class).toInstance((Object)url);
            return (MailRepository)this.genericLoader.withChildModule(urlModule).instantiate(new ClassName(fullyQualifiedClassName));
        }
        catch (ClassNotFoundException e) {
            throw new MailRepositoryStore.UnsupportedRepositoryStoreException("No Mail Repository found with class name " + fullyQualifiedClassName);
        }
        catch (ClassCastException e) {
            throw new MailRepositoryStore.MailRepositoryStoreException(fullyQualifiedClassName + " is not a MailRepository");
        }
    }
}

