/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.quota.task;

import com.google.common.collect.ImmutableList;
import java.time.Clock;
import java.time.Instant;
import java.util.Optional;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.quota.task.RecomputeCurrentQuotasService;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;

public class RecomputeCurrentQuotasTask
implements Task {
    static final TaskType RECOMPUTE_CURRENT_QUOTAS = TaskType.of((String)"recompute-current-quotas");
    private final RecomputeCurrentQuotasService service;
    private final RecomputeCurrentQuotasService.RunningOptions runningOptions;
    private final RecomputeCurrentQuotasService.Context context;

    public RecomputeCurrentQuotasTask(RecomputeCurrentQuotasService service, RecomputeCurrentQuotasService.RunningOptions runningOptions) {
        this.service = service;
        this.runningOptions = runningOptions;
        this.context = new RecomputeCurrentQuotasService.Context();
    }

    public Task.Result run() {
        return (Task.Result)this.service.recomputeCurrentQuotas(this.context, RecomputeCurrentQuotasService.RunningOptions.DEFAULT).block();
    }

    public TaskType type() {
        return RECOMPUTE_CURRENT_QUOTAS;
    }

    public RecomputeCurrentQuotasService.RunningOptions getRunningOptions() {
        return this.runningOptions;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        RecomputeCurrentQuotasService.Context.Snapshot snapshot = this.context.snapshot();
        return Optional.of(new Details(Clock.systemUTC().instant(), snapshot.getProcessedQuotaRootCount(), (ImmutableList<String>)((ImmutableList)snapshot.getFailedQuotaRoots().stream().map(QuotaRoot::asString).collect(ImmutableList.toImmutableList())), this.runningOptions));
    }

    public static class Details
    implements TaskExecutionDetails.AdditionalInformation {
        private final Instant instant;
        private final long processedQuotaRoots;
        private final ImmutableList<String> failedQuotaRoots;
        private final RecomputeCurrentQuotasService.RunningOptions runningOptions;

        Details(Instant instant, long processedQuotaRoots, ImmutableList<String> failedQuotaRoots, RecomputeCurrentQuotasService.RunningOptions runningOptions) {
            this.instant = instant;
            this.processedQuotaRoots = processedQuotaRoots;
            this.failedQuotaRoots = failedQuotaRoots;
            this.runningOptions = runningOptions;
        }

        public Instant timestamp() {
            return this.instant;
        }

        long getProcessedQuotaRoots() {
            return this.processedQuotaRoots;
        }

        ImmutableList<String> getFailedQuotaRoots() {
            return this.failedQuotaRoots;
        }

        public RecomputeCurrentQuotasService.RunningOptions getRunningOptions() {
            return this.runningOptions;
        }
    }
}

