/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.json.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.spi.JsonProvider;
import jakarta.json.stream.JsonLocation;
import jakarta.json.stream.JsonParsingException;
import java.io.IOException;
import org.opensearch.client.json.jackson.JacksonJsonpLocation;

class JsonValueParser {
    private final JsonProvider provider = JsonProvider.provider();

    JsonValueParser() {
    }

    public JsonObject parseObject(JsonParser parser) throws IOException {
        JsonToken token;
        JsonObjectBuilder ob = this.provider.createObjectBuilder();
        while ((token = parser.nextToken()) != JsonToken.END_OBJECT) {
            if (token != JsonToken.FIELD_NAME) {
                throw new JsonParsingException("Expected a property name", (JsonLocation)new JacksonJsonpLocation(parser));
            }
            String name = parser.getCurrentName();
            parser.nextToken();
            ob.add(name, this.parseValue(parser));
        }
        return ob.build();
    }

    public JsonArray parseArray(JsonParser parser) throws IOException {
        JsonArrayBuilder ab = this.provider.createArrayBuilder();
        while (parser.nextToken() != JsonToken.END_ARRAY) {
            ab.add(this.parseValue(parser));
        }
        return ab.build();
    }

    public JsonValue parseValue(JsonParser parser) throws IOException {
        switch (parser.currentToken()) {
            case START_OBJECT: {
                return this.parseObject(parser);
            }
            case START_ARRAY: {
                return this.parseArray(parser);
            }
            case VALUE_TRUE: {
                return JsonValue.TRUE;
            }
            case VALUE_FALSE: {
                return JsonValue.FALSE;
            }
            case VALUE_NULL: {
                return JsonValue.NULL;
            }
            case VALUE_STRING: {
                return this.provider.createValue(parser.getText());
            }
            case VALUE_NUMBER_FLOAT: 
            case VALUE_NUMBER_INT: {
                switch (parser.getNumberType()) {
                    case INT: {
                        return this.provider.createValue(parser.getIntValue());
                    }
                    case LONG: {
                        return this.provider.createValue(parser.getLongValue());
                    }
                    case FLOAT: 
                    case DOUBLE: {
                        return this.provider.createValue(parser.getDoubleValue());
                    }
                    case BIG_DECIMAL: {
                        return this.provider.createValue(parser.getDecimalValue());
                    }
                    case BIG_INTEGER: {
                        return this.provider.createValue(parser.getBigIntegerValue());
                    }
                }
            }
        }
        throw new JsonParsingException("Unexpected token '" + parser.currentToken() + "'", (JsonLocation)new JacksonJsonpLocation(parser));
    }
}

