/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster.allocation_explain;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class AllocationStore
implements JsonpSerializable {
    private final String allocationId;
    private final boolean found;
    private final boolean inSync;
    private final long matchingSizeInBytes;
    private final boolean matchingSyncId;
    private final String storeException;
    public static final JsonpDeserializer<AllocationStore> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AllocationStore::setupAllocationStoreDeserializer);

    private AllocationStore(Builder builder) {
        this.allocationId = ApiTypeHelper.requireNonNull(builder.allocationId, this, "allocationId");
        this.found = ApiTypeHelper.requireNonNull(builder.found, this, "found");
        this.inSync = ApiTypeHelper.requireNonNull(builder.inSync, this, "inSync");
        this.matchingSizeInBytes = ApiTypeHelper.requireNonNull(builder.matchingSizeInBytes, this, "matchingSizeInBytes");
        this.matchingSyncId = ApiTypeHelper.requireNonNull(builder.matchingSyncId, this, "matchingSyncId");
        this.storeException = ApiTypeHelper.requireNonNull(builder.storeException, this, "storeException");
    }

    public static AllocationStore of(Function<Builder, ObjectBuilder<AllocationStore>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String allocationId() {
        return this.allocationId;
    }

    public final boolean found() {
        return this.found;
    }

    public final boolean inSync() {
        return this.inSync;
    }

    public final long matchingSizeInBytes() {
        return this.matchingSizeInBytes;
    }

    public final boolean matchingSyncId() {
        return this.matchingSyncId;
    }

    public final String storeException() {
        return this.storeException;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("allocation_id");
        generator.write(this.allocationId);
        generator.writeKey("found");
        generator.write(this.found);
        generator.writeKey("in_sync");
        generator.write(this.inSync);
        generator.writeKey("matching_size_in_bytes");
        generator.write(this.matchingSizeInBytes);
        generator.writeKey("matching_sync_id");
        generator.write(this.matchingSyncId);
        generator.writeKey("store_exception");
        generator.write(this.storeException);
    }

    protected static void setupAllocationStoreDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::allocationId, JsonpDeserializer.stringDeserializer(), "allocation_id");
        op.add(Builder::found, JsonpDeserializer.booleanDeserializer(), "found");
        op.add(Builder::inSync, JsonpDeserializer.booleanDeserializer(), "in_sync");
        op.add(Builder::matchingSizeInBytes, JsonpDeserializer.longDeserializer(), "matching_size_in_bytes");
        op.add(Builder::matchingSyncId, JsonpDeserializer.booleanDeserializer(), "matching_sync_id");
        op.add(Builder::storeException, JsonpDeserializer.stringDeserializer(), "store_exception");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<AllocationStore> {
        private String allocationId;
        private Boolean found;
        private Boolean inSync;
        private Long matchingSizeInBytes;
        private Boolean matchingSyncId;
        private String storeException;

        public final Builder allocationId(String value) {
            this.allocationId = value;
            return this;
        }

        public final Builder found(boolean value) {
            this.found = value;
            return this;
        }

        public final Builder inSync(boolean value) {
            this.inSync = value;
            return this;
        }

        public final Builder matchingSizeInBytes(long value) {
            this.matchingSizeInBytes = value;
            return this;
        }

        public final Builder matchingSyncId(boolean value) {
            this.matchingSyncId = value;
            return this;
        }

        public final Builder storeException(String value) {
            this.storeException = value;
            return this;
        }

        @Override
        public AllocationStore build() {
            this._checkSingleUse();
            return new AllocationStore(this);
        }
    }
}

