/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.msearch;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.search.Suggester;
import org.opensearch.client.opensearch.core.search.TrackHits;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class MultisearchBody
implements JsonpSerializable {
    private final Map<String, Aggregation> aggregations;
    @Nullable
    private final Query query;
    @Nullable
    private final Integer from;
    @Nullable
    private final Integer size;
    @Nullable
    private final TrackHits trackTotalHits;
    @Nullable
    private final Suggester suggest;
    public static final JsonpDeserializer<MultisearchBody> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MultisearchBody::setupMultisearchBodyDeserializer);

    private MultisearchBody(Builder builder) {
        this.aggregations = ApiTypeHelper.unmodifiable(builder.aggregations);
        this.query = builder.query;
        this.from = builder.from;
        this.size = builder.size;
        this.trackTotalHits = builder.trackTotalHits;
        this.suggest = builder.suggest;
    }

    public static MultisearchBody of(Function<Builder, ObjectBuilder<MultisearchBody>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, Aggregation> aggregations() {
        return this.aggregations;
    }

    @Nullable
    public final Query query() {
        return this.query;
    }

    @Nullable
    public final Integer from() {
        return this.from;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    @Nullable
    public final TrackHits trackTotalHits() {
        return this.trackTotalHits;
    }

    @Nullable
    public final Suggester suggest() {
        return this.suggest;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.aggregations)) {
            generator.writeKey("aggregations");
            generator.writeStartObject();
            for (Map.Entry<String, Aggregation> item0 : this.aggregations.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.query != null) {
            generator.writeKey("query");
            this.query.serialize(generator, mapper);
        }
        if (this.from != null) {
            generator.writeKey("from");
            generator.write(this.from.intValue());
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size.intValue());
        }
        if (this.trackTotalHits != null) {
            generator.writeKey("track_total_hits");
            this.trackTotalHits.serialize(generator, mapper);
        }
        if (this.suggest != null) {
            generator.writeKey("suggest");
            this.suggest.serialize(generator, mapper);
        }
    }

    protected static void setupMultisearchBodyDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::aggregations, JsonpDeserializer.stringMapDeserializer(Aggregation._DESERIALIZER), "aggregations", "aggs");
        op.add(Builder::query, Query._DESERIALIZER, "query");
        op.add(Builder::from, JsonpDeserializer.integerDeserializer(), "from");
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size");
        op.add(Builder::trackTotalHits, TrackHits._DESERIALIZER, "track_total_hits");
        op.add(Builder::suggest, Suggester._DESERIALIZER, "suggest");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<MultisearchBody> {
        @Nullable
        private Map<String, Aggregation> aggregations;
        @Nullable
        private Query query;
        @Nullable
        private Integer from;
        @Nullable
        private Integer size;
        @Nullable
        private TrackHits trackTotalHits;
        @Nullable
        private Suggester suggest;

        public final Builder aggregations(Map<String, Aggregation> map) {
            this.aggregations = Builder._mapPutAll(this.aggregations, map);
            return this;
        }

        public final Builder aggregations(String key, Aggregation value) {
            this.aggregations = Builder._mapPut(this.aggregations, key, value);
            return this;
        }

        public final Builder aggregations(String key, Function<Aggregation.Builder, ObjectBuilder<Aggregation>> fn) {
            return this.aggregations(key, fn.apply(new Aggregation.Builder()).build());
        }

        public final Builder query(@Nullable Query value) {
            this.query = value;
            return this;
        }

        public final Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        public final Builder from(@Nullable Integer value) {
            this.from = value;
            return this;
        }

        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public final Builder trackTotalHits(@Nullable TrackHits value) {
            this.trackTotalHits = value;
            return this;
        }

        public final Builder trackTotalHits(Function<TrackHits.Builder, ObjectBuilder<TrackHits>> fn) {
            return this.trackTotalHits(fn.apply(new TrackHits.Builder()).build());
        }

        public final Builder suggest(@Nullable Suggester value) {
            this.suggest = value;
            return this;
        }

        public final Builder suggest(Function<Suggester.Builder, ObjectBuilder<Suggester>> fn) {
            return this.suggest(fn.apply(new Suggester.Builder()).build());
        }

        @Override
        public MultisearchBody build() {
            this._checkSingleUse();
            return new MultisearchBody(this);
        }
    }
}

