/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jsieve.tests;

import org.apache.jsieve.Arguments;
import org.apache.jsieve.SieveContext;
import org.apache.jsieve.exception.SieveException;
import org.apache.jsieve.exception.SyntaxException;
import org.apache.jsieve.mail.MailAdapter;
import org.apache.jsieve.tests.ExecutableTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTest
implements ExecutableTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTest.class);

    @Override
    public boolean execute(MailAdapter mail, Arguments arguments, SieveContext context) throws SieveException {
        this.validateArguments(arguments, context);
        return this.executeBasic(mail, arguments, context);
    }

    protected abstract boolean executeBasic(MailAdapter var1, Arguments var2, SieveContext var3) throws SieveException;

    protected void validateArguments(Arguments arguments, SieveContext context) throws SieveException {
        if (!arguments.getArgumentList().isEmpty()) {
            LOGGER.warn("Unexpected arguments for {}", (Object)this.getClass().getName());
            context.getCoordinate().logDiagnosticsInfo();
            LOGGER.debug(arguments.toString());
            String message = context.getCoordinate().addStartLineAndColumn("Found unexpected arguments.");
            throw new SyntaxException(message);
        }
    }
}

