/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.api.querybuilder.update.Update;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.init.configuration.CassandraConfiguration;
import org.apache.james.backends.cassandra.init.configuration.JamesExecutionProfiles;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.table.CassandraMessageModseqTable;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.store.mail.ModSeqProvider;
import org.apache.james.util.ReactorUtils;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.util.retry.Retry;
import reactor.util.retry.RetryBackoffSpec;

public class CassandraModSeqProvider
implements ModSeqProvider {
    public static final String MOD_SEQ_CONDITION = "modSeqCondition";
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final PreparedStatement select;
    private final PreparedStatement update;
    private final PreparedStatement insert;
    private final RetryBackoffSpec retrySpec;
    private final DriverExecutionProfile lwtProfile;
    private final CassandraConfiguration cassandraConfiguration;

    private static <T> T unbox(Supplier<T> supplier) throws MailboxException {
        try {
            return supplier.get();
        }
        catch (CompletionException e) {
            if (e.getCause() instanceof ExceptionRelay) {
                throw ((ExceptionRelay)e.getCause()).getUnderlying();
            }
            throw e;
        }
    }

    @Inject
    public CassandraModSeqProvider(CqlSession session, CassandraConfiguration cassandraConfiguration) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.lwtProfile = JamesExecutionProfiles.getLWTProfile((CqlSession)session);
        this.insert = this.prepareInsert(session);
        this.update = this.prepareUpdate(session);
        this.select = this.prepareSelect(session);
        Duration firstBackoff = Duration.ofMillis(10L);
        this.retrySpec = Retry.backoff((long)cassandraConfiguration.getModSeqMaxRetry(), (Duration)firstBackoff).scheduler(Schedulers.parallel());
        this.cassandraConfiguration = cassandraConfiguration;
    }

    private PreparedStatement prepareInsert(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"modseq").value(CassandraMessageModseqTable.NEXT_MODSEQ, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageModseqTable.NEXT_MODSEQ)).value(CassandraMessageModseqTable.MAILBOX_ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageModseqTable.MAILBOX_ID)).ifNotExists().build());
    }

    private PreparedStatement prepareUpdate(CqlSession session) {
        return session.prepare(((Update)((Update)QueryBuilder.update((String)"modseq").setColumn(CassandraMessageModseqTable.NEXT_MODSEQ, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageModseqTable.NEXT_MODSEQ)).where((Relation)Relation.column((CqlIdentifier)CassandraMessageModseqTable.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageModseqTable.MAILBOX_ID)))).ifColumn(CassandraMessageModseqTable.NEXT_MODSEQ).isEqualTo((Term)QueryBuilder.bindMarker((String)MOD_SEQ_CONDITION))).build());
    }

    private PreparedStatement prepareSelect(CqlSession session) {
        return session.prepare(((Select)QueryBuilder.selectFrom((String)"modseq").column(CassandraMessageModseqTable.NEXT_MODSEQ).where((Relation)Relation.column((CqlIdentifier)CassandraMessageModseqTable.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageModseqTable.MAILBOX_ID)))).build());
    }

    public ModSeq nextModSeq(Mailbox mailbox) throws MailboxException {
        return (ModSeq)this.nextModSeqReactive(mailbox.getMailboxId()).blockOptional().orElseThrow(() -> new MailboxException("Can not retrieve modseq for " + mailbox.getMailboxId()));
    }

    public ModSeq nextModSeq(MailboxId mailboxId) throws MailboxException {
        return (ModSeq)this.nextModSeqReactive(mailboxId).blockOptional().orElseThrow(() -> new MailboxException("Can not retrieve modseq for " + mailboxId));
    }

    public ModSeq highestModSeq(Mailbox mailbox) throws MailboxException {
        return this.highestModSeq(mailbox.getMailboxId());
    }

    public ModSeq highestModSeq(MailboxId mailboxId) throws MailboxException {
        return CassandraModSeqProvider.unbox(() -> ((Optional)this.findHighestModSeq((CassandraId)mailboxId, Optional.of(this.lwtProfile).filter(any -> this.cassandraConfiguration.isUidReadStrongConsistency())).block()).orElse(ModSeq.first()));
    }

    private Mono<Optional<ModSeq>> findHighestModSeq(CassandraId mailboxId, Optional<DriverExecutionProfile> executionProfile) {
        BoundStatement statement = (BoundStatement)this.select.bind(new Object[0]).set(CassandraMessageModseqTable.MAILBOX_ID, (Object)mailboxId.asUuid(), TypeCodecs.TIMEUUID);
        return this.cassandraAsyncExecutor.executeSingleRowOptional((Statement)executionProfile.map(arg_0 -> ((BoundStatement)statement).setExecutionProfile(arg_0)).orElse(statement)).map(maybeRow -> maybeRow.map(row -> ModSeq.of((long)row.getLong(0))));
    }

    private Mono<ModSeq> tryInsertModSeq(CassandraId mailboxId, ModSeq modSeq) {
        ModSeq nextModSeq = modSeq.next();
        return this.cassandraAsyncExecutor.executeReturnApplied((Statement)((BoundStatement)this.insert.bind(new Object[0]).set(CassandraMessageModseqTable.MAILBOX_ID, (Object)mailboxId.asUuid(), TypeCodecs.TIMEUUID)).setLong(CassandraMessageModseqTable.NEXT_MODSEQ, nextModSeq.asLong())).map(success -> this.successToModSeq(nextModSeq, (Boolean)success)).handle(ReactorUtils.publishIfPresent());
    }

    private Mono<ModSeq> tryUpdateModSeq(CassandraId mailboxId, ModSeq modSeq) {
        ModSeq nextModSeq = modSeq.next();
        return this.cassandraAsyncExecutor.executeReturnApplied((Statement)((BoundStatement)((BoundStatement)this.update.bind(new Object[0]).set(CassandraMessageModseqTable.MAILBOX_ID, (Object)mailboxId.asUuid(), TypeCodecs.TIMEUUID)).setLong(CassandraMessageModseqTable.NEXT_MODSEQ, nextModSeq.asLong())).setLong(MOD_SEQ_CONDITION, modSeq.asLong())).map(success -> this.successToModSeq(nextModSeq, (Boolean)success)).handle(ReactorUtils.publishIfPresent());
    }

    private Optional<ModSeq> successToModSeq(ModSeq modSeq, Boolean success) {
        if (success.booleanValue()) {
            return Optional.of(modSeq);
        }
        return Optional.empty();
    }

    public Mono<ModSeq> nextModSeqReactive(MailboxId mailboxId) {
        CassandraId cassandraId = (CassandraId)mailboxId;
        return this.findHighestModSeq(cassandraId, Optional.of(this.lwtProfile)).flatMap(maybeHighestModSeq -> maybeHighestModSeq.map(highestModSeq -> this.tryUpdateModSeq(cassandraId, (ModSeq)highestModSeq)).orElseGet(() -> this.tryInsertModSeq(cassandraId, ModSeq.first()))).single().retryWhen((Retry)this.retrySpec);
    }

    public Mono<ModSeq> highestModSeqReactive(Mailbox mailbox) {
        return this.findHighestModSeq((CassandraId)mailbox.getMailboxId(), Optional.empty()).map(optional -> optional.orElse(ModSeq.first()));
    }

    public static class ExceptionRelay
    extends RuntimeException {
        private final MailboxException underlying;

        public ExceptionRelay(MailboxException underlying) {
            super((Throwable)underlying);
            this.underlying = underlying;
        }

        public MailboxException getUnderlying() {
            return this.underlying;
        }
    }
}

