/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.fasterxml.jackson.databind.Module;
import javax.inject.Inject;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.mail.CassandraMailboxCounterDAO;
import org.apache.james.mailbox.cassandra.mail.task.MailboxMergingTask;
import org.apache.james.mailbox.cassandra.mail.task.MailboxMergingTaskRunner;
import org.apache.james.task.Task;
import org.apache.james.task.TaskManager;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.dto.MailboxMergingRequest;
import org.apache.james.webadmin.tasks.TaskFromRequest;
import org.apache.james.webadmin.utils.JsonExtractException;
import org.apache.james.webadmin.utils.JsonExtractor;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Request;
import spark.ResponseTransformer;
import spark.Service;

public class CassandraMailboxMergingRoutes
implements Routes {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraMailboxMergingRoutes.class);
    public static final String BASE = "/cassandra/mailbox/merging";
    private final MailboxMergingTaskRunner mailboxMergingTaskRunner;
    private final CassandraId.Factory mailboxIdFactory;
    private final JsonExtractor<MailboxMergingRequest> jsonExtractor;
    private final TaskManager taskManager;
    private final JsonTransformer jsonTransformer;
    private final CassandraMailboxCounterDAO counterDAO;

    @Inject
    public CassandraMailboxMergingRoutes(MailboxMergingTaskRunner mailboxMergingTaskRunner, CassandraId.Factory mailboxIdFactory, TaskManager taskManager, JsonTransformer jsonTransformer, CassandraMailboxCounterDAO counterDAO) {
        this.mailboxMergingTaskRunner = mailboxMergingTaskRunner;
        this.mailboxIdFactory = mailboxIdFactory;
        this.taskManager = taskManager;
        this.jsonTransformer = jsonTransformer;
        this.counterDAO = counterDAO;
        this.jsonExtractor = new JsonExtractor(MailboxMergingRequest.class, new Module[0]);
    }

    public String getBasePath() {
        return BASE;
    }

    public void define(Service service) {
        TaskFromRequest taskFromRequest = this::mergeMailboxes;
        service.post(BASE, taskFromRequest.asRoute(this.taskManager), (ResponseTransformer)this.jsonTransformer);
    }

    public Task mergeMailboxes(Request request) throws JsonExtractException {
        LOGGER.debug("Cassandra upgrade launched");
        MailboxMergingRequest mailboxMergingRequest = (MailboxMergingRequest)this.jsonExtractor.parse(request.body());
        CassandraId originId = this.mailboxIdFactory.fromString(mailboxMergingRequest.getMergeOrigin());
        CassandraId destinationId = this.mailboxIdFactory.fromString(mailboxMergingRequest.getMergeDestination());
        long totalMessagesToMove = (Long)this.counterDAO.countMessagesInMailbox(originId).defaultIfEmpty((Object)0L).block();
        return new MailboxMergingTask(this.mailboxMergingTaskRunner, totalMessagesToMove, originId, destinationId);
    }
}

