/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.parser;

import java.util.EnumSet;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.Tag;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.StatusDataItems;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.decode.DecodingException;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.decode.parser.AbstractUidCommandParser;
import org.apache.james.imap.decode.parser.StatusCommandParser;
import org.apache.james.imap.message.request.ListRequest;

public class ListCommandParser
extends AbstractUidCommandParser {
    @Inject
    public ListCommandParser(StatusResponseFactory statusResponseFactory) {
        super(ImapConstants.LIST_COMMAND, statusResponseFactory);
    }

    protected ListCommandParser(ImapCommand command, StatusResponseFactory statusResponseFactory) {
        super(command, statusResponseFactory);
    }

    public String listMailbox(ImapRequestLineReader request) throws DecodingException {
        char next = request.nextWordChar();
        switch (next) {
            case '\"': {
                return request.consumeQuoted();
            }
            case '{': {
                return request.consumeLiteral(null);
            }
        }
        return request.consumeWord(ListCharValidator.INSTANCE);
    }

    @Override
    protected ImapMessage decode(ImapRequestLineReader request, Tag tag, boolean useUids, ImapSession session) throws DecodingException {
        EnumSet<ListRequest.ListSelectOption> listOptions = this.parseSelectOptions(request);
        String referenceName = request.mailbox();
        String mailboxPattern = this.listMailbox(request);
        Pair<EnumSet<ListRequest.ListReturnOption>, Optional<StatusDataItems>> listReturnOptions = this.parseReturnOptions(request);
        request.eol();
        if (listOptions.isEmpty() && ((EnumSet)listReturnOptions.getLeft()).isEmpty()) {
            return this.createMessage(referenceName, mailboxPattern, tag);
        }
        if (listOptions.contains((Object)ListRequest.ListSelectOption.SPECIAL_USE)) {
            ((EnumSet)listReturnOptions.getLeft()).add(ListRequest.ListReturnOption.SPECIAL_USE);
        }
        return new ListRequest(ImapConstants.LIST_COMMAND, referenceName, mailboxPattern, tag, listOptions, (EnumSet)listReturnOptions.getLeft(), (Optional)listReturnOptions.getRight());
    }

    protected ImapMessage createMessage(String referenceName, String mailboxPattern, Tag tag) {
        return new ListRequest(referenceName, mailboxPattern, tag);
    }

    private EnumSet<ListRequest.ListSelectOption> parseSelectOptions(ImapRequestLineReader request) throws DecodingException {
        EnumSet<ListRequest.ListSelectOption> listOptions = EnumSet.noneOf(ListRequest.ListSelectOption.class);
        if (request.nextWordChar() != '(') {
            return listOptions;
        }
        request.consumeChar('(');
        request.nextWordChar();
        while (request.nextChar() != ')') {
            listOptions.add(this.parseListSelectOption(request));
            request.nextWordChar();
        }
        request.consumeChar(')');
        return listOptions;
    }

    private ListRequest.ListSelectOption parseListSelectOption(ImapRequestLineReader request) throws DecodingException {
        char c = request.nextWordChar();
        if (c == 'r' || c == 'R') {
            return this.readR(request);
        }
        if (c == 's' || c == 'S') {
            return this.readSelectS(request);
        }
        throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown select option: '" + request.consumeWord(ImapRequestLineReader.NoopCharValidator.INSTANCE) + "'");
    }

    private ListRequest.ListSelectOption readSelectS(ImapRequestLineReader request) throws DecodingException {
        request.consume();
        char c = request.nextChar();
        if (c == 'u' || c == 'U') {
            this.consumeSubscribed(request);
            return ListRequest.ListSelectOption.SUBSCRIBED;
        }
        this.consumeSpecialUse(request);
        return ListRequest.ListSelectOption.SPECIAL_USE;
    }

    private Pair<ListRequest.ListReturnOption, Optional<StatusDataItems>> readS(ImapRequestLineReader request) throws DecodingException {
        request.consume();
        char c = request.nextWordChar();
        if (c == 'T' || c == 't') {
            return this.readStatus(request);
        }
        if (c == 'P' || c == 'p') {
            return Pair.of((Object)((Object)this.readSpecialUse(request)), Optional.empty());
        }
        return Pair.of((Object)((Object)this.readReturnSubscribed(request)), Optional.empty());
    }

    private Pair<ListRequest.ListReturnOption, Optional<StatusDataItems>> readStatus(ImapRequestLineReader request) throws DecodingException {
        this.assertChar(request, 'T', 't');
        this.assertChar(request, 'A', 'a');
        this.assertChar(request, 'T', 't');
        this.assertChar(request, 'U', 'u');
        this.assertChar(request, 'S', 's');
        return Pair.of((Object)((Object)ListRequest.ListReturnOption.STATUS), Optional.of(StatusCommandParser.statusDataItems(request)));
    }

    private ListRequest.ListReturnOption readSpecialUse(ImapRequestLineReader request) throws DecodingException {
        this.consumeSpecialUse(request);
        return ListRequest.ListReturnOption.SPECIAL_USE;
    }

    private void consumeSpecialUse(ImapRequestLineReader request) throws DecodingException {
        this.assertChar(request, 'P', 'p');
        this.assertChar(request, 'E', 'e');
        this.assertChar(request, 'C', 'c');
        this.assertChar(request, 'I', 'i');
        this.assertChar(request, 'A', 'a');
        this.assertChar(request, 'L', 'l');
        this.assertChar(request, '-', '-');
        this.assertChar(request, 'U', 'u');
        this.assertChar(request, 'S', 's');
        this.assertChar(request, 'E', 'e');
    }

    private ListRequest.ListSelectOption readR(ImapRequestLineReader request) throws DecodingException {
        request.consume();
        char c2 = request.nextChar();
        if (c2 == 'e' || c2 == 'E') {
            request.consume();
            char c3 = request.nextChar();
            if (c3 == 'm' || c3 == 'M') {
                return this.readRemote(request);
            }
            return this.readRecursivematch(request);
        }
        throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown select option: '" + request.consumeWord(ImapRequestLineReader.NoopCharValidator.INSTANCE) + "'");
    }

    private ListRequest.ListSelectOption readRemote(ImapRequestLineReader request) throws DecodingException {
        this.assertChar(request, 'M', 'm');
        this.assertChar(request, 'O', 'o');
        this.assertChar(request, 'T', 't');
        this.assertChar(request, 'E', 'e');
        return ListRequest.ListSelectOption.REMOTE;
    }

    private ListRequest.ListSelectOption readRecursivematch(ImapRequestLineReader request) throws DecodingException {
        this.assertChar(request, 'C', 'c');
        this.assertChar(request, 'U', 'u');
        this.assertChar(request, 'R', 'r');
        this.assertChar(request, 'S', 's');
        this.assertChar(request, 'I', 'i');
        this.assertChar(request, 'V', 'v');
        this.assertChar(request, 'E', 'e');
        this.assertChar(request, 'M', 'm');
        this.assertChar(request, 'A', 'a');
        this.assertChar(request, 'T', 't');
        this.assertChar(request, 'C', 'c');
        this.assertChar(request, 'H', 'h');
        return ListRequest.ListSelectOption.RECURSIVEMATCH;
    }

    private Pair<EnumSet<ListRequest.ListReturnOption>, Optional<StatusDataItems>> parseReturnOptions(ImapRequestLineReader request) throws DecodingException {
        if (request.nextWordCharLenient().isPresent()) {
            String returnKey = request.consumeWord(ImapRequestLineReader.AtomCharValidator.INSTANCE);
            if ("RETURN".equalsIgnoreCase(returnKey)) {
                EnumSet<ListRequest.ListReturnOption> listReturnOptions = EnumSet.noneOf(ListRequest.ListReturnOption.class);
                request.nextWordChar();
                request.consumeChar('(');
                request.nextWordChar();
                Optional statusDataItems = Optional.empty();
                while (request.nextChar() != ')') {
                    Pair<ListRequest.ListReturnOption, Optional<StatusDataItems>> listReturnOption = this.parseListReturnOption(request);
                    listReturnOptions.add((ListRequest.ListReturnOption)((Object)listReturnOption.getLeft()));
                    if (((Optional)listReturnOption.getRight()).isPresent()) {
                        statusDataItems = (Optional)listReturnOption.getRight();
                    }
                    request.nextWordChar();
                }
                request.consumeChar(')');
                return Pair.of(listReturnOptions, statusDataItems);
            }
            throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown '" + returnKey + "' option'");
        }
        return Pair.of(EnumSet.noneOf(ListRequest.ListReturnOption.class), Optional.empty());
    }

    private Pair<ListRequest.ListReturnOption, Optional<StatusDataItems>> parseListReturnOption(ImapRequestLineReader request) throws DecodingException {
        char c = request.nextWordChar();
        if (c == 'c' || c == 'C') {
            return Pair.of((Object)((Object)this.readChildren(request)), Optional.empty());
        }
        if (c == 's' || c == 'S') {
            return this.readS(request);
        }
        if (c == 'm' || c == 'M') {
            return Pair.of((Object)((Object)this.readMyRight(request)), Optional.empty());
        }
        throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown return option: '" + request.consumeWord(ImapRequestLineReader.NoopCharValidator.INSTANCE) + "'");
    }

    private ListRequest.ListReturnOption readChildren(ImapRequestLineReader request) throws DecodingException {
        this.assertChar(request, 'C', 'c');
        this.assertChar(request, 'H', 'h');
        this.assertChar(request, 'I', 'i');
        this.assertChar(request, 'L', 'l');
        this.assertChar(request, 'D', 'd');
        this.assertChar(request, 'R', 'r');
        this.assertChar(request, 'E', 'e');
        this.assertChar(request, 'N', 'n');
        return ListRequest.ListReturnOption.CHILDREN;
    }

    private ListRequest.ListReturnOption readMyRight(ImapRequestLineReader request) throws DecodingException {
        this.assertChar(request, 'M', 'm');
        this.assertChar(request, 'Y', 'y');
        this.assertChar(request, 'R', 'r');
        this.assertChar(request, 'I', 'i');
        this.assertChar(request, 'G', 'g');
        this.assertChar(request, 'H', 'h');
        this.assertChar(request, 'T', 't');
        this.assertChar(request, 'S', 's');
        return ListRequest.ListReturnOption.MYRIGHTS;
    }

    private ListRequest.ListReturnOption readReturnSubscribed(ImapRequestLineReader request) throws DecodingException {
        this.consumeSubscribed(request);
        return ListRequest.ListReturnOption.SUBSCRIBED;
    }

    private void consumeSubscribed(ImapRequestLineReader request) throws DecodingException {
        this.assertChar(request, 'U', 'u');
        this.assertChar(request, 'B', 'b');
        this.assertChar(request, 'S', 's');
        this.assertChar(request, 'C', 'c');
        this.assertChar(request, 'R', 'r');
        this.assertChar(request, 'I', 'i');
        this.assertChar(request, 'B', 'b');
        this.assertChar(request, 'E', 'e');
        this.assertChar(request, 'D', 'd');
    }

    private void assertChar(ImapRequestLineReader reader, char c, char cUp) throws DecodingException {
        char c2 = reader.consume();
        if (c2 != c && c2 != cUp) {
            throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unexpected token in select option. Expecting " + c + " got " + c2);
        }
    }

    private static class ListCharValidator
    extends ImapRequestLineReader.AtomCharValidator {
        public static final ImapRequestLineReader.CharacterValidator INSTANCE = new ListCharValidator();

        private ListCharValidator() {
        }

        @Override
        public boolean isValid(char chr) {
            if (ImapRequestLineReader.isListWildcard(chr)) {
                return true;
            }
            return super.isValid(chr);
        }
    }
}

