/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.crypto;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Base64;
import javax.inject.Inject;
import org.apache.james.jmap.draft.crypto.AsymmetricKeys;
import org.apache.james.jmap.draft.crypto.SecurityKeyLoader;
import org.apache.james.jmap.draft.crypto.SignatureHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JamesSignatureHandler
implements SignatureHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(JamesSignatureHandler.class);
    public static final String ALGORITHM = "SHA1withRSA";
    private final SecurityKeyLoader keyLoader;
    private AsymmetricKeys securityKeys;

    @Inject
    @VisibleForTesting
    JamesSignatureHandler(SecurityKeyLoader keyLoader) {
        this.keyLoader = keyLoader;
    }

    @Override
    public void init() throws Exception {
        this.securityKeys = this.keyLoader.load();
    }

    @Override
    public String sign(String source) {
        Preconditions.checkNotNull((Object)source);
        try {
            Signature javaSignature = Signature.getInstance(ALGORITHM);
            javaSignature.initSign(this.securityKeys.getPrivateKey());
            javaSignature.update(source.getBytes());
            return Base64.getEncoder().encodeToString(javaSignature.sign());
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean verify(String source, String signature) {
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkNotNull((Object)signature);
        try {
            Signature javaSignature = Signature.getInstance(ALGORITHM);
            javaSignature.initVerify(this.securityKeys.getPublicKey());
            javaSignature.update(source.getBytes());
            return javaSignature.verify(Base64.getDecoder().decode(signature));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (SignatureException e) {
            LOGGER.warn("Attempt to use a malformed signature '{}' for source '{}'", new Object[]{signature, source, e});
            return false;
        }
    }
}

