/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.methods;

import com.google.common.annotations.VisibleForTesting;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.jmap.draft.methods.Method;

public class ErrorResponse
implements Method.Response {
    public static final Method.Response.Name ERROR_METHOD = Method.Response.name("error");
    @VisibleForTesting
    static final String DEFAULT_ERROR_MESSAGE = "Error while processing";
    private final String type;
    private final Optional<String> description;

    public static Builder builder() {
        return new Builder();
    }

    @VisibleForTesting
    ErrorResponse(String type, Optional<String> description) {
        this.type = type;
        this.description = description;
    }

    public String getType() {
        return this.type;
    }

    public Optional<String> getDescription() {
        return this.description;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ErrorResponse that = (ErrorResponse)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.description, that.description);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.description);
    }

    public static class Builder {
        private Optional<String> type = Optional.empty();
        private Optional<String> description = Optional.empty();

        private Builder() {
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        public ErrorResponse build() {
            return new ErrorResponse(this.type.orElse(ErrorResponse.DEFAULT_ERROR_MESSAGE), this.description);
        }
    }
}

