/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.methods;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.mail.Flags;
import javax.mail.internet.SharedInputStream;
import javax.mail.util.SharedByteArrayInputStream;
import org.apache.james.jmap.JMAPConfiguration;
import org.apache.james.jmap.draft.exceptions.AttachmentsNotFoundException;
import org.apache.james.jmap.draft.exceptions.SizeExceededException;
import org.apache.james.jmap.draft.methods.BlobManager;
import org.apache.james.jmap.draft.methods.MIMEMessageConverter;
import org.apache.james.jmap.draft.methods.ValueWithId;
import org.apache.james.jmap.draft.model.Attachment;
import org.apache.james.jmap.draft.model.Blob;
import org.apache.james.jmap.draft.model.BlobId;
import org.apache.james.jmap.draft.model.CreationMessage;
import org.apache.james.jmap.draft.model.Keywords;
import org.apache.james.jmap.draft.model.message.view.MessageFullViewFactory;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.ByteContent;
import org.apache.james.mailbox.model.ComposedMessageId;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MessageAppender {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageAppender.class);
    private final MailboxManager mailboxManager;
    private final MessageIdManager messageIdManager;
    private final MIMEMessageConverter mimeMessageConverter;
    private final BlobManager blobManager;
    private final JMAPConfiguration configuration;

    @Inject
    public MessageAppender(MailboxManager mailboxManager, MessageIdManager messageIdManager, MIMEMessageConverter mimeMessageConverter, BlobManager blobManager, JMAPConfiguration configuration) {
        this.mailboxManager = mailboxManager;
        this.messageIdManager = messageIdManager;
        this.mimeMessageConverter = mimeMessageConverter;
        this.blobManager = blobManager;
        this.configuration = configuration;
    }

    public Mono<MessageFullViewFactory.MetaDataWithContent> appendMessageInMailboxes(ValueWithId.CreationMessageEntry createdEntry, List<MailboxId> targetMailboxes, MailboxSession session) {
        return Mono.fromCallable(() -> {
            Preconditions.checkArgument((!targetMailboxes.isEmpty() ? 1 : 0) != 0);
            ImmutableList<Attachment.WithBlob> attachmentsWithBlobs = this.getMessageAttachments(session, ((CreationMessage)createdEntry.getValue()).getAttachments());
            Message message = this.mimeMessageConverter.convertToMime(createdEntry, attachmentsWithBlobs);
            byte[] messageContent = this.mimeMessageConverter.asBytes(message);
            if (this.maximumSizeExceeded(messageContent).booleanValue()) {
                throw new SizeExceededException(messageContent.length, (Long)this.configuration.getMaximumSendSize().get());
            }
            Date internalDate = Date.from(((CreationMessage)createdEntry.getValue()).getDate().toInstant());
            return new NewMessage(messageContent, message, internalDate);
        }).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER).flatMap(newMessage -> Mono.from((Publisher)this.mailboxManager.getMailboxReactive((MailboxId)targetMailboxes.get(0), session)).flatMap(mailbox -> Mono.from((Publisher)mailbox.appendMessageReactive(MessageManager.AppendCommand.builder().withInternalDate(newMessage.date).withFlags(this.getFlags((CreationMessage)createdEntry.getValue())).notRecent().withParsedMessage(newMessage.message).build((Content)new ByteContent(newMessage.messageContent)), session)).flatMap(appendResult -> {
            ComposedMessageId ids = appendResult.getId();
            if (targetMailboxes.size() > 1) {
                return Mono.from((Publisher)this.messageIdManager.setInMailboxesReactive(ids.getMessageId(), (Collection)targetMailboxes, session)).thenReturn(appendResult);
            }
            return Mono.just((Object)appendResult);
        }).doFinally(any -> newMessage.message.dispose()).map(appendResult -> MessageFullViewFactory.MetaDataWithContent.builder().uid(appendResult.getId().getUid()).keywords(((CreationMessage)createdEntry.getValue()).getKeywords()).internalDate(newMessage.date.toInstant()).sharedContent((SharedInputStream)new SharedByteArrayInputStream(newMessage.messageContent)).size(newMessage.messageContent.length).attachments(appendResult.getMessageAttachments()).mailboxId(mailbox.getId()).message(newMessage.message).messageId(appendResult.getId().getMessageId()).build())));
    }

    private Boolean maximumSizeExceeded(byte[] messageContent) {
        return this.configuration.getMaximumSendSize().map(limit -> (long)messageContent.length > limit).orElse(false);
    }

    public MessageFullViewFactory.MetaDataWithContent appendMessageInMailbox(Message message, MessageManager messageManager, Flags flags, MailboxSession session) throws MailboxException {
        byte[] messageContent = this.mimeMessageConverter.asBytes(message);
        Date internalDate = new Date();
        MessageManager.AppendResult appendResult = messageManager.appendMessage(MessageManager.AppendCommand.builder().withFlags(flags).build((Content)new ByteContent(messageContent)), session);
        ComposedMessageId ids = appendResult.getId();
        return MessageFullViewFactory.MetaDataWithContent.builder().uid(ids.getUid()).keywords(Keywords.lenientFactory().fromFlags(flags)).internalDate(internalDate.toInstant()).sharedContent((SharedInputStream)new SharedByteArrayInputStream(messageContent)).size(messageContent.length).attachments(appendResult.getMessageAttachments()).mailboxId(messageManager.getId()).message(message).messageId(ids.getMessageId()).build();
    }

    private Flags getFlags(CreationMessage message) {
        return message.getKeywords().asFlags();
    }

    private ImmutableList<Attachment.WithBlob> getMessageAttachments(MailboxSession session, ImmutableList<Attachment> attachments) {
        ImmutableMap blobs = (ImmutableMap)Flux.from(this.blobManager.retrieve((Collection)attachments.stream().map(Attachment::getBlobId).collect(ImmutableList.toImmutableList()), session)).collect(ImmutableMap.toImmutableMap(Blob::getBlobId, Function.identity())).block();
        ImmutableList result = (ImmutableList)attachments.stream().flatMap(attachment -> Optional.ofNullable((Blob)blobs.get((Object)attachment.getBlobId())).map(blob -> new Attachment.WithBlob((Attachment)attachment, (Blob)blob)).stream()).collect(ImmutableList.toImmutableList());
        if (result.size() != attachments.size()) {
            Sets.SetView notFound = Sets.difference(attachments.stream().map(Attachment::getBlobId).collect(Collectors.toSet()), result.stream().map(att -> att.getAttachment().getBlobId()).collect(Collectors.toSet()));
            throw new AttachmentsNotFoundException((List<BlobId>)ImmutableList.copyOf((Collection)notFound));
        }
        return result;
    }

    private static class NewMessage {
        private final byte[] messageContent;
        private final Message message;
        private final Date date;

        private NewMessage(byte[] messageContent, Message message, Date date) {
            this.messageContent = messageContent;
            this.message = message;
            this.date = date;
        }
    }
}

