/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.james.jmap.draft.model.BlobId;
import org.apache.james.jmap.draft.model.MessageProperties;
import org.apache.james.jmap.draft.model.SetError;

public class SetMessagesError
extends SetError {
    private ImmutableList<BlobId> attachmentsNotFound;

    public static Builder builder() {
        return new Builder();
    }

    public SetMessagesError(SetError setError, ImmutableList<BlobId> attachmentsNotFound) {
        super(setError);
        this.attachmentsNotFound = attachmentsNotFound;
    }

    @JsonSerialize
    public List<BlobId> getAttachmentsNotFound() {
        return this.attachmentsNotFound;
    }

    public static class Builder
    extends SetError.Builder {
        private List<BlobId> attachmentsNotFound = new ArrayList<BlobId>();

        private Builder() {
        }

        @Override
        public Builder description(String description) {
            return (Builder)super.description(description);
        }

        @Override
        public Builder properties(MessageProperties.MessageProperty ... properties) {
            return (Builder)super.properties(properties);
        }

        @Override
        public Builder properties(Set<MessageProperties.MessageProperty> properties) {
            return (Builder)super.properties(properties);
        }

        @Override
        public Builder type(SetError.Type type) {
            return (Builder)super.type(type);
        }

        public Builder attachmentsNotFound(BlobId ... attachmentIds) {
            return this.attachmentsNotFound(Arrays.asList(attachmentIds));
        }

        public Builder attachmentsNotFound(List<BlobId> attachmentIds) {
            this.attachmentsNotFound.addAll(attachmentIds);
            return this;
        }

        @Override
        public SetError build() {
            return new SetMessagesError(super.build(), (ImmutableList<BlobId>)ImmutableList.copyOf(this.attachmentsNotFound));
        }
    }
}

