/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.jsieve;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableList;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.james.core.MailAddress;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.mdn.MDN;
import org.apache.james.mdn.MDNReport;
import org.apache.james.mdn.action.mode.DispositionActionMode;
import org.apache.james.mdn.fields.Disposition;
import org.apache.james.mdn.fields.ReportingUserAgent;
import org.apache.james.mdn.modifier.DispositionModifier;
import org.apache.james.mdn.sending.mode.DispositionSendingMode;
import org.apache.james.mdn.type.DispositionType;
import org.apache.james.server.core.MailImpl;
import org.apache.james.transport.mailets.jsieve.ActionContext;
import org.apache.james.transport.mailets.jsieve.ActionUtils;
import org.apache.james.transport.mailets.jsieve.DiscardAction;
import org.apache.james.transport.mailets.jsieve.MailAction;
import org.apache.jsieve.mail.Action;
import org.apache.jsieve.mail.ActionReject;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RejectAction
implements MailAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(RejectAction.class);

    @Override
    public void execute(Action action, Mail mail, ActionContext context) throws MessagingException {
        if (action instanceof ActionReject) {
            ActionReject actionReject = (ActionReject)action;
            this.execute(actionReject, mail, context);
            DiscardAction.removeRecipient(mail, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ActionReject anAction, Mail aMail, ActionContext context) throws MessagingException {
        ActionUtils.detectAndHandleLocalLooping(aMail, context, "reject");
        StringBuilder humanText = new StringBuilder(128);
        humanText.append("This message was refused by the recipient's mail filtering program.");
        humanText.append("\r\n");
        humanText.append("The reason given was:");
        humanText.append("\r\n");
        humanText.append("\r\n");
        humanText.append(anAction.getMessage());
        String reportingUAName = null;
        try {
            reportingUAName = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException ex) {
            reportingUAName = "localhost";
        }
        String reportingUAProduct = context.getServerInfo();
        String[] originalRecipients = aMail.getMessage().getHeader("Original-Recipient");
        String originalRecipient = null;
        if (null != originalRecipients && originalRecipients.length > 0) {
            originalRecipient = originalRecipients[0];
        }
        String finalRecipient = context.getRecipient().asString();
        String originalMessageId = aMail.getMessage().getMessageID();
        MimeMultipart multipart = MDN.builder().humanReadableText(humanText.toString()).report(MDNReport.builder().reportingUserAgentField(ReportingUserAgent.builder().userAgentName(reportingUAName).userAgentProduct(reportingUAProduct).build()).finalRecipientField(finalRecipient).originalRecipientField(originalRecipient).originalMessageIdField(originalMessageId).dispositionField(Disposition.builder().actionMode(DispositionActionMode.Automatic).sendingMode(DispositionSendingMode.Automatic).type(DispositionType.Deleted).addModifier(DispositionModifier.Error).build()).build()).build().asMultipart();
        MimeMessage reply = (MimeMessage)aMail.getMessage().reply(false);
        context.getRecipient().toInternetAddress().ifPresent(Throwing.consumer(arg_0 -> ((MimeMessage)reply).setFrom(arg_0)).sneakyThrow());
        reply.setContent((Multipart)multipart);
        reply.saveChanges();
        Address[] recipientAddresses = reply.getAllRecipients();
        if (recipientAddresses != null) {
            MailImpl mail = MailImpl.builder().name(MailImpl.getId()).addRecipients((Collection)Arrays.stream(recipientAddresses).map(InternetAddress.class::cast).map(Throwing.function(MailAddress::new)).collect(ImmutableList.toImmutableList())).mimeMessage(reply).build();
            try {
                context.post((Mail)mail);
            }
            finally {
                LifecycleUtil.dispose((Object)mail);
            }
        } else {
            LOGGER.info("Unable to send reject MDN. Could not determine the recipient.");
        }
    }
}

