/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.component.VEvent;
import org.apache.james.core.MailAddress;

public class ICALAttributeDTO {
    public static final String DEFAULT_SEQUENCE_VALUE = "0";
    private final String ical;
    private final String sender;
    private final String recipient;
    private final String replyTo;
    private final String uid;
    private final String dtstamp;
    private final String method;
    private final Optional<String> sequence;
    private final Optional<String> recurrenceId;

    public static Builder builder() {
        return new Builder();
    }

    private ICALAttributeDTO(String ical, String uid, String sender, String recipient, String replyTo, String dtstamp, String method, Optional<String> sequence, Optional<String> recurrenceId) {
        this.ical = ical;
        this.sender = sender;
        this.recipient = recipient;
        this.replyTo = replyTo;
        this.uid = uid;
        this.dtstamp = dtstamp;
        this.method = method;
        this.sequence = sequence;
        this.recurrenceId = recurrenceId;
    }

    public String getIcal() {
        return this.ical;
    }

    public String getSender() {
        return this.sender;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public String getUid() {
        return this.uid;
    }

    public String getDtstamp() {
        return this.dtstamp;
    }

    public String getMethod() {
        return this.method;
    }

    public String getSequence() {
        return this.sequence.orElse(DEFAULT_SEQUENCE_VALUE);
    }

    @JsonProperty(value="recurrence-id")
    public Optional<String> getRecurrenceId() {
        return this.recurrenceId;
    }

    public final boolean equals(Object o) {
        if (o instanceof ICALAttributeDTO) {
            ICALAttributeDTO that = (ICALAttributeDTO)o;
            return Objects.equals(that.ical, this.ical) && Objects.equals(that.sender, this.sender) && Objects.equals(that.recipient, this.recipient) && Objects.equals(that.uid, this.uid) && Objects.equals(that.sequence, this.sequence) && Objects.equals(that.dtstamp, this.dtstamp) && Objects.equals(that.method, this.method) && Objects.equals(that.recurrenceId, this.recurrenceId) && Objects.equals(that.replyTo, this.replyTo);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.ical, this.sender, this.recipient, this.uid, this.sequence, this.dtstamp, this.method, this.recurrenceId, this.replyTo);
    }

    public static class Builder {
        public RequiresSender from(Calendar calendar, byte[] originalEvent) {
            String ical = new String(originalEvent, StandardCharsets.UTF_8);
            VEvent vevent = (VEvent)calendar.getComponent("VEVENT");
            Optional<String> uid = this.optionalOf((Property)vevent.getUid());
            Optional<String> method = this.optionalOf((Property)calendar.getMethod());
            Optional<String> recurrenceId = this.optionalOf((Property)vevent.getRecurrenceId());
            Optional<String> sequence = this.optionalOf((Property)vevent.getSequence());
            Optional<String> dtstamp = this.optionalOf((Property)vevent.getDateStamp());
            Preconditions.checkNotNull((Object)ical);
            Preconditions.checkState((boolean)uid.isPresent(), (Object)"uid is a compulsory property of an ICAL object");
            Preconditions.checkState((boolean)method.isPresent(), (Object)"method is a compulsory property of an ICAL object");
            Preconditions.checkState((boolean)dtstamp.isPresent(), (Object)"dtstamp is a compulsory property of an ICAL object");
            return sender -> recipient -> replyTo -> new ICALAttributeDTO(ical, (String)uid.get(), sender.asString(), recipient.asString(), replyTo.asString(), (String)dtstamp.get(), (String)method.get(), sequence, recurrenceId);
        }

        private Optional<String> optionalOf(Property property) {
            return Optional.ofNullable(property).map(Content::getValue);
        }

        @FunctionalInterface
        public static interface RequiresReplyTo {
            public ICALAttributeDTO replyTo(MailAddress var1);
        }

        @FunctionalInterface
        public static interface RequiresRecipient {
            public RequiresReplyTo recipient(MailAddress var1);
        }

        @FunctionalInterface
        public static interface RequiresSender {
            public RequiresRecipient sender(MailAddress var1);
        }
    }
}

