/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.library;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.queue.api.MailQueueManagementMBean;
import org.apache.james.queue.api.MailQueueName;
import org.apache.james.queue.api.ManageableMailQueue;
import org.apache.james.queue.library.MailQueueManagement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMailQueueFactory<T extends MailQueue>
implements MailQueueFactory<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMailQueueFactory.class);
    public static final String MBEAN_NAME_QUEUE_PREFIX = "org.apache.james:type=component,name=queue,queue=";
    protected final Map<MailQueueName, T> queues = new HashMap<MailQueueName, T>();
    private boolean useJMX = true;
    private MBeanServer mbeanServer;
    private final List<String> mbeans = new ArrayList<String>();

    public void setUseJMX(boolean useJMX) {
        this.useJMX = useJMX;
    }

    @VisibleForTesting
    void setMbeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    @PostConstruct
    public void init() {
        this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
    }

    public Set<MailQueueName> listCreatedMailQueues() {
        return (Set)this.queues.values().stream().map(MailQueue::getName).collect(ImmutableSet.toImmutableSet());
    }

    @PreDestroy
    public synchronized void destroy() {
        for (String mbean : this.mbeans) {
            try {
                this.mbeanServer.unregisterMBean(new ObjectName(mbean));
            }
            catch (Exception e) {
                LOGGER.error("Error while destroying AbstractMailQueueFactory : ", (Throwable)e);
            }
        }
        this.mbeans.clear();
        for (MailQueue mailQueue : this.queues.values()) {
            LifecycleUtil.dispose((Object)mailQueue);
        }
    }

    public final synchronized Optional<T> getQueue(MailQueueName name, MailQueueFactory.PrefetchCount prefetchCount) {
        return Optional.ofNullable((MailQueue)this.queues.get(name));
    }

    public synchronized T createQueue(MailQueueName name, MailQueueFactory.PrefetchCount prefetchCount) {
        return (T)this.getQueue(name, prefetchCount).orElseGet(() -> this.createAndRegisterQueue(name));
    }

    private T createAndRegisterQueue(MailQueueName name) {
        T queue = this.createCacheableMailQueue(name);
        if (this.useJMX) {
            this.registerMBean(name, (MailQueue)queue);
        }
        this.queues.put(name, queue);
        return queue;
    }

    protected abstract T createCacheableMailQueue(MailQueueName var1);

    protected synchronized void registerMBean(MailQueueName queuename, MailQueue queue) {
        String mbeanName = MBEAN_NAME_QUEUE_PREFIX + queuename.asString();
        try {
            MailQueueManagement mbean = null;
            if (queue instanceof ManageableMailQueue) {
                mbean = new MailQueueManagement((ManageableMailQueue)queue);
            } else if (queue instanceof MailQueueManagementMBean) {
                mbean = (MailQueueManagementMBean)queue;
            }
            if (mbean != null) {
                this.mbeanServer.registerMBean(mbean, new ObjectName(mbeanName));
                this.mbeans.add(mbeanName);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to register mbean", e);
        }
    }

    protected synchronized void unregisterMBean(String mbeanName) {
        try {
            this.mbeanServer.unregisterMBean(new ObjectName(mbeanName));
            this.mbeans.remove(mbeanName);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to unregister mbean", e);
        }
    }
}

