/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.utils;

import com.github.fge.lambdas.Throwing;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.File;
import java.io.FileNotFoundException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.FileBasedBuilderParameters;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.server.core.configuration.Configuration;
import org.apache.james.server.core.filesystem.FileSystemImpl;
import org.apache.james.utils.DelegatedPropertiesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"org.apache.james.CONFIGURATION");
    private static final char COMMA = ',';
    private final FileSystem fileSystem;
    private final Configuration.ConfigurationPath configurationPrefix;
    private final LoadingCache<String, Optional<File>> fileCacheLoader;

    private static boolean failOnMissingConfiguration() {
        return Boolean.valueOf(System.getProperty("james.fail.on.missing.configuration", "false"));
    }

    @VisibleForTesting
    public static PropertiesProvider forTesting() {
        Configuration.Basic configuration = Configuration.builder().workingDirectory("../").configurationFromClasspath().build();
        FileSystemImpl fileSystem = new FileSystemImpl(configuration.directories());
        return new PropertiesProvider((FileSystem)fileSystem, configuration.configurationPath());
    }

    public PropertiesProvider(FileSystem fileSystem, Configuration.ConfigurationPath configurationPrefix) {
        this.fileSystem = fileSystem;
        this.configurationPrefix = configurationPrefix;
        this.fileCacheLoader = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofMinutes(10L)).build((CacheLoader)new CacheLoader<String, Optional<File>>(){

            public Optional<File> load(String fileName) {
                return PropertiesProvider.this.getConfigurationFileFromFileSystem(fileName);
            }
        });
    }

    public org.apache.commons.configuration2.Configuration getConfigurations(String ... filenames) throws FileNotFoundException, ConfigurationException {
        File file = (File)Arrays.stream(filenames).map(this::getConfigurationFile).flatMap(Optional::stream).findFirst().orElseThrow(() -> this.fail(Joiner.on((String)",").join((Object[])filenames) + " not found"));
        return this.getConfiguration(file);
    }

    public org.apache.commons.configuration2.Configuration getConfiguration(String fileName) throws FileNotFoundException, ConfigurationException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)fileName) ? 1 : 0) != 0);
        File file = this.getConfigurationFile(fileName).orElseThrow(() -> this.fail(fileName));
        return this.getConfiguration(file);
    }

    public FileNotFoundException fail(String message) {
        if (PropertiesProvider.failOnMissingConfiguration()) {
            throw new MissingConfigurationFile(message);
        }
        return new FileNotFoundException(message);
    }

    private org.apache.commons.configuration2.Configuration getConfiguration(File propertiesFile) throws ConfigurationException {
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)((FileBasedBuilderParameters)new Parameters().fileBased().setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','))).setFile(propertiesFile)});
        return new DelegatedPropertiesConfiguration(',', (org.apache.commons.configuration2.Configuration)builder.getConfiguration());
    }

    private Optional<File> getConfigurationFile(String fileName) {
        return (Optional)Throwing.supplier(() -> (Optional)this.fileCacheLoader.get((Object)fileName)).get();
    }

    private Optional<File> getConfigurationFileFromFileSystem(String fileName) {
        try {
            File file = this.fileSystem.getFile(this.configurationPrefix.asString() + fileName + ".properties");
            LOGGER.info("Load configuration file {}", (Object)file.getAbsolutePath());
            return Optional.of(file).filter(File::exists);
        }
        catch (FileNotFoundException e) {
            return Optional.empty();
        }
    }

    public static class MissingConfigurationFile
    extends RuntimeException {
        public MissingConfigurationFile(String message) {
            super(message);
        }
    }
}

