/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfpatch.system;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.UUID;
import org.apache.jena.atlas.lib.Bytes;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.rdf.model.impl.Util;
import org.apache.jena.rdfpatch.system.URNs;

public final class Id {
    private static final String SCHEME = "id:";
    private static final String nilStr = "00000000-0000-0000-0000-000000000000";
    private static final Id nilId = Id.fromUUID(UUID.fromString("00000000-0000-0000-0000-000000000000"));
    private final UUID uuid;
    private final String string;

    public static int lenStrUUID() {
        return nilStr.length();
    }

    public static boolean maybeUUID(String str) {
        return str.length() == nilStr.length() && str.charAt(8) == '-';
    }

    public static Id nullId() {
        return nilId;
    }

    public static Id create() {
        return new Id(URNs.genUUID());
    }

    public static Id fromBytes(byte[] bytes) {
        if (bytes.length == 16) {
            long mostSig = Bytes.getLong((byte[])bytes, (int)0);
            long leastSig = Bytes.getLong((byte[])bytes, (int)8);
            UUID uuid = new UUID(mostSig, leastSig);
            return Id.fromUUID(uuid);
        }
        String str = new String(bytes, StandardCharsets.UTF_8);
        return new Id(str);
    }

    public static String str(Node node) {
        if (node == null) {
            return "<null>";
        }
        return Id.fromNode(node).toString();
    }

    public static Id fromNode(Node node) {
        if (node == null) {
            return null;
        }
        String s = null;
        if (node.isURI()) {
            s = node.getURI();
        } else if (Util.isSimpleString((Node)node)) {
            s = node.getLiteralLexicalForm();
        }
        if (s == null) {
            throw new IllegalArgumentException("Id input is not a URI or a string");
        }
        return Id.fromString$(s);
    }

    public static Id fromUUID(UUID uuid) {
        return new Id(uuid);
    }

    private static Id fromString$(String str) {
        if (str.startsWith("uuid:")) {
            str = str.substring("uuid:".length());
        } else if (str.startsWith("urn:uuid:")) {
            str = str.substring("urn:uuid:".length());
        }
        return Id.fromString(str);
    }

    public static Id fromStringOrNull(String str) {
        return str == null ? null : Id.fromString(str);
    }

    public static Id fromString(String str) {
        Objects.requireNonNull(str);
        switch (str) {
            case "00000000-0000-0000-0000-000000000000": 
            case "id:nil": {
                return Id.nullId();
            }
        }
        if (str.startsWith(SCHEME)) {
            str = str.substring(SCHEME.length());
        }
        try {
            UUID uuid = UUID.fromString(str);
            return new Id(uuid);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("String for id does not match a UUID: '" + str + "'");
        }
    }

    public static UUID parseUUID(String patchStr, UUID dft) {
        try {
            return UUID.fromString(patchStr);
        }
        catch (IllegalArgumentException ex) {
            return dft;
        }
    }

    public static Id parseId(String uuidStr, Id dft) {
        try {
            return Id.fromUUID(UUID.fromString(uuidStr));
        }
        catch (IllegalArgumentException ex) {
            return dft;
        }
    }

    private Id(UUID id) {
        this.uuid = Objects.requireNonNull(id);
        this.string = null;
    }

    private Id(String id) {
        this.uuid = null;
        this.string = Objects.requireNonNull(id);
    }

    public boolean isNil() {
        return this.equals(nilId);
    }

    public String asParam() {
        if (this.uuid != null) {
            return this.uuid.toString();
        }
        return this.string;
    }

    public byte[] asBytes() {
        if (this.uuid != null) {
            byte[] bytes = new byte[16];
            Bytes.setLong((long)this.uuid.getMostSignificantBits(), (byte[])bytes, (int)0);
            Bytes.setLong((long)this.uuid.getLeastSignificantBits(), (byte[])bytes, (int)8);
            return bytes;
        }
        return this.string.getBytes(StandardCharsets.UTF_8);
    }

    public String asPlainString() {
        if (this.uuid != null) {
            return this.uuid.toString();
        }
        if (this.string != null) {
            return this.string;
        }
        throw new InternalErrorException("Id has null UUID and string");
    }

    public String asString() {
        if (this.uuid != null) {
            return SCHEME + this.uuid.toString();
        }
        if (this.string != null) {
            return this.string;
        }
        throw new InternalErrorException("Id has null UUID and null string");
    }

    public Node asNode() {
        if (this.uuid != null) {
            return NodeFactory.createURI((String)("uuid:" + this.uuid.toString()));
        }
        return NodeFactory.createLiteralString((String)this.string);
    }

    public String toString() {
        return this.toSchemeString(SCHEME);
    }

    public String toSchemeString(String scheme) {
        if (this == nilId) {
            return "id:nil";
        }
        if (this.uuid != null) {
            return scheme + Id.shortUUIDstr(this.uuid);
        }
        return scheme + "\"" + this.string + "\"";
    }

    public static String shortUUIDstr(UUID uuid) {
        String str = uuid.toString();
        int version = uuid.version();
        if (version == 1) {
            return uuid.toString().substring(0, 6);
        }
        if (version == 4) {
            return uuid.toString().substring(0, 6);
        }
        return uuid.toString().substring(0, 8);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.string == null ? 0 : this.string.hashCode());
        result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Id other = (Id)obj;
        if (this.string == null ? other.string != null : !this.string.equals(other.string)) {
            return false;
        }
        return !(this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid));
    }
}

