/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.main.sys;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.jena.fuseki.main.sys.FusekiAutoModules;
import org.apache.jena.fuseki.main.sys.FusekiModule;

public class FusekiModules {
    private static FusekiModules systemFusekiModules = null;
    private final List<FusekiModule> modules;

    public static void setSystemDefault(FusekiModules fusekiModules) {
        systemFusekiModules = fusekiModules == null ? FusekiModules.create(new FusekiModule[0]) : fusekiModules;
    }

    public static void restoreSystemDefault() {
        systemFusekiModules = null;
    }

    public static FusekiModules getSystemModules() {
        if (systemFusekiModules == null) {
            systemFusekiModules = FusekiAutoModules.get();
        }
        return systemFusekiModules;
    }

    static void init() {
    }

    public static final FusekiModules empty() {
        return FusekiModules.create(new FusekiModule[0]);
    }

    static void resetSystemDefault() {
        FusekiAutoModules.reset();
        systemFusekiModules = FusekiAutoModules.get();
    }

    public static FusekiModules create(FusekiModule ... modules) {
        return new FusekiModules(modules);
    }

    public static FusekiModules create(List<FusekiModule> modules) {
        return new FusekiModules(modules);
    }

    public static FusekiModules add(FusekiModules fusekiModules, FusekiModule ... additionalModules) {
        if (additionalModules.length == 0) {
            return fusekiModules;
        }
        ArrayList<FusekiModule> list = new ArrayList<FusekiModule>();
        list.addAll(fusekiModules.modules);
        for (FusekiModule fm : additionalModules) {
            list.add(fm);
        }
        return FusekiModules.create(list);
    }

    public static FusekiModules add(FusekiModules fusekiModules, List<FusekiModule> additionalModules) {
        if (additionalModules.isEmpty()) {
            return fusekiModules;
        }
        ArrayList<FusekiModule> list = new ArrayList<FusekiModule>();
        list.addAll(fusekiModules.modules);
        for (FusekiModule fm : additionalModules) {
            list.add(fm);
        }
        return FusekiModules.create(list);
    }

    private FusekiModules(FusekiModule ... modules) {
        this.modules = List.of(Objects.requireNonNull(modules));
    }

    private FusekiModules(List<FusekiModule> modules) {
        this.modules = List.copyOf((Collection)Objects.requireNonNull(modules));
    }

    public List<FusekiModule> asList() {
        return List.copyOf(this.modules);
    }

    public void forEach(Consumer<FusekiModule> action) {
        this.modules.forEach(action);
    }

    public boolean contains(FusekiModule module) {
        return this.modules.contains(module);
    }

    public boolean isEmpty() {
        return this.modules.isEmpty();
    }
}

