/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdf.model.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.jena.atlas.lib.Creator;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.rdf.model.RDFReaderF;
import org.apache.jena.rdf.model.RDFReaderI;
import org.apache.jena.rdf.model.impl.NTripleReader;
import org.apache.jena.shared.JenaException;
import org.apache.jena.shared.NoReaderForLangException;

public class RDFReaderFImpl
implements RDFReaderF {
    public static final String DEFAULTLANG = "RDF/XML";
    private static Map<String, Creator<RDFReaderI>> custom = new LinkedHashMap<String, Creator<RDFReaderI>>();
    private static RDFReaderF rewiredAlternative = null;
    private static final boolean includeRDFXML = false;
    private static String msgNoRDFXML = "RDF/XML is no longer supported in jena-core. Add jena-arq to the classpath";
    private static Set<String> removedLangs = Set.of("RDF", "RDF/XML", "RDF/XML-ABBREV");

    public static void alternative(RDFReaderF other) {
        rewiredAlternative = other;
    }

    @Override
    public RDFReaderI getReader(String lang) {
        Creator<RDFReaderI> c;
        if (lang == null || lang.equals("")) {
            lang = DEFAULTLANG;
        }
        if (rewiredAlternative != null) {
            return rewiredAlternative.getReader(lang);
        }
        if (removedLangs.contains(lang)) {
            Log.error("RDFReader", msgNoRDFXML);
        }
        if ((c = custom.get(lang)) == null) {
            throw new NoReaderForLangException("Reader not found: " + lang);
        }
        try {
            return c.create();
        }
        catch (RuntimeException e2) {
            throw new JenaException(e2);
        }
    }

    private static void setup() {
        Creator<RDFReaderI> ntReader = NTripleReader::new;
        custom.put("N-TRIPLE", ntReader);
        custom.put("N-TRIPLES", ntReader);
        custom.put("N-Triples", ntReader);
    }

    static {
        RDFReaderFImpl.setup();
    }
}

