/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.compression.gzip;

import java.util.zip.Deflater;
import org.eclipse.jetty.compression.EncoderConfig;

public class GzipEncoderConfig
implements EncoderConfig {
    private static final int DEFAULT_BUFFER_SIZE = 512;
    private static final int MIN_BUFFER_SIZE = 8;
    private int bufferSize = 512;
    private int level = -1;
    private int strategy = 0;
    private boolean syncFlush = false;

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public void setBufferSize(int size) {
        this.bufferSize = Math.max(8, size);
    }

    @Override
    public int getCompressionLevel() {
        return this.level;
    }

    @Override
    public void setCompressionLevel(int level) {
        if (level != -1 && (level < 0 || level > 9)) {
            throw new IllegalArgumentException("Compression Level should be in range [0, 9] (or " + Deflater.class.getName() + ".DEFAULT_COMPRESSION to use default level)");
        }
        this.level = level;
    }

    @Override
    public int getStrategy() {
        return this.strategy;
    }

    @Override
    public void setStrategy(int strategy) {
        switch (strategy) {
            case 0: 
            case 1: 
            case 2: {
                this.strategy = strategy;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized strategy: " + strategy);
            }
        }
    }

    public boolean isSyncFlush() {
        return this.syncFlush;
    }

    public void setSyncFlush(boolean syncFlush) {
        this.syncFlush = syncFlush;
    }
}

