/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.main.cmds;

import java.util.function.Consumer;
import org.apache.jena.cmd.CmdException;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.main.FusekiAbortException;
import org.apache.jena.fuseki.system.FusekiLogging;

class RunFuseki {
    RunFuseki() {
    }

    public static void run(String[] args, Consumer<String[]> action) {
        try {
            action.accept(args);
        }
        catch (IllegalArgumentException | CmdException ex) {
            RunFuseki.exit(1, ex.getMessage());
        }
        catch (FusekiAbortException ex) {
            RunFuseki.exit(ex.getCode(), ex.getMessage());
        }
    }

    private static void exit(int exitCode, String message) {
        if (message != null) {
            Fuseki.fusekiLog.error(message);
        }
        System.out.flush();
        System.err.flush();
        System.exit(exitCode);
    }

    static {
        FusekiLogging.setLogging();
    }
}

