/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.converters;

import org.apache.juneau.rest.RestConverter;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.utils.PojoQuery;
import org.apache.juneau.utils.SearchArgs;

public final class Queryable
implements RestConverter {
    public static final String SWAGGER_PARAMS = "{in:'query',name:'s',description:'Search.\nKey/value pairs representing column names and search tokens.\n\\'*\\' and \\'?\\' can be used as meta-characters in string fields.\n\\'>\\', \\'>=\\', \\'<\\', and \\'<=\\' can be used as limits on numeric and date fields.\nDate fields can be matched with partial dates (e.g. \\'2018\\' to match any date in the year 2018).',type:'array',collectionFormat:'csv',x-examples:{example:'?s=Bill*,birthDate>2000'}},{in:'query',name:'v',description:'View.\nColumn names to display.',type:'array',collectionFormat:'csv',x-examples:{example:'?v=name,birthDate'}},{in:'query',name:'o',description:'Order by.\nColumns to sort by.\nColumn names can be suffixed with \\'+\\' or \\'-\\' to indicate ascending or descending order.\nThe default is ascending order.',type:'array',collectionFormat:'csv',x-examples:{example:'?o=name,birthDate-'}},{in:'query',name:'i',description:'Case-insensitive.\nFlag for case-insensitive matching on the search parameters.',type:'boolean',x-examples:{example:'?i=true'}},{in:'query',name:'p',description:'Position.\nOnly return rows starting at the specified index position (zero-indexed).\nDefault is 0',type:'integer',x-examples:{example:'?p=100'}},{in:'query',name:'l',description:'Limit.\nOnly return the specified number of rows.\nDefault is 0 (meaning return all rows).',type:'integer',x-examples:{example:'?l=100'}}";

    @Override
    public Object convert(RestRequest req, Object o) {
        if (o == null) {
            return null;
        }
        SearchArgs searchArgs = req.getQuery().getSearchArgs();
        if (searchArgs == null) {
            return o;
        }
        return new PojoQuery(o, req.getBeanSession()).filter(searchArgs);
    }
}

